/*
 *	cliptcl.h
 *
 *	TclC^v^
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sun Oct 26 19:32:00 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- ukeep/TclΉ.xlsvɁAΉ󋵂L^čs܂B
 */
#ifndef __CLIP_TCL_H__
#define __CLIP_TCL_H__

//
//ydvzW[́AK[x[WRN^[Ƃ̕pOƂĂ܂B@@@@@@@@@@@@@@@@@@@@
//EP/ECEł́ATcl_CreateInterp()ĂяoOɁAugc_init(GC_LEVEL_CONSERVATIVE);vsĂĂB
//EPCł́AK[x[WRN^[̃Cu(uBoehm GCv)NĂB@@@@@@@@@@@@@@
//

/****************************************************************************
 *	萔E\
 ****************************************************************************/
//When a TCL command returns, the string pointer interp->result points to a string containing return information from the command.
//In addition, the command procedure returns an integer value, which is one of the following:
#define TCL_OK				0				//Command completed normally; interp->result contains the command's result.
#define TCL_ERROR			1				//The command couldn't be completed successfully; interp->result describes what went wrong.
#define TCL_RETURN			2				//The command requests that the current procedure return; interp->result contains the procedure's return value.
#define TCL_BREAK			3				//The command requests that the innermost loop be exited; interp->result is meaningless.
#define TCL_CONTINUE			4				//Go on to the next iteration of the current loop; interp->result is meaninless.
/****************************************************************************
 *	
 ****************************************************************************/
char* Tcl_IsBracedElement(const char* s, int termChar);
char* Tcl_IsQuotedElement(const char* s, int termChar);
int Tcl_SplitList(const char* s, char*** argvPtr);
/*--------------------------------------------------------------------------*/
char* Tcl_Merge(int argc, char** argv);
char* Tcl_Concat(int argc, char** argv);
/*--------------------------------------------------------------------------*/
#define TCL_NORMAL			0				//All characters that don't have special significance to the Tcl language.
#define TCL_SPACE			1				//Character is space, tab, or return.
#define TCL_COMMAND_END			2				//Character is newline or null or semicolon or close-bracket.
#define TCL_QUOTE			3				//Character is a double-quote.
#define TCL_OPEN_BRACKET		4				//Character is a "[".
#define TCL_OPEN_BRACE			5				//Character is a "{".
#define TCL_CLOSE_BRACE			6				//Character is a "}".
#define TCL_BACKSLASH			7				//Character is a "\".
#define TCL_DOLLAR			8				//Character is a "$".
int Tcl_CharType(int c, int termChar);
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _Tcl_Table {
	LIST_ENTRY			list_head;
} Tcl_Table;
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_TableEntry {
	LIST_ENTRY			list_entry;
	const char*			key;
	void*				value;
} Tcl_TableEntry;
/*--------------------------------------------------------------------------*/
typedef struct Tcl_TableSearch {
	LIST_ENTRY*			list_head;
	LIST_ENTRY*			list_entry;
} Tcl_TableSearch;
/*--------------------------------------------------------------------------*/
void Tcl_InitTable(Tcl_Table* tablePtr);
Tcl_TableEntry* Tcl_CreateTableEntry(Tcl_Table* tablePtr, const char* key, int* newPtr);
Tcl_TableEntry* Tcl_FindTableEntry(Tcl_Table* tablePtr, const char* key);
void Tcl_DeleteTableEntry(Tcl_TableEntry* entryPtr);
Tcl_TableEntry* Tcl_FirstTableEntry(Tcl_Table* tablePtr, Tcl_TableSearch* searchPtr);
Tcl_TableEntry* Tcl_NextTableEntry(Tcl_TableSearch* searchPtr);
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _Tcl_CallFrame {
	int				level;				//Level of this procedure, for "uplevel" purposes (i.e. corresponds to nesting of callerVarPtr's, not callerPtr's). 1 means outer-most procedure, 0 means top-level.
	Tcl_Table			varTable;			//Table containing all of procedure's local variables.
	struct _Tcl_CallFrame*		callerPtr;			//Value of interp->framePtr when this procedure was invoked (i.e. next in stack of all active procedures).
	struct _Tcl_CallFrame*		callerVarPtr;			//Value of interp->varFramePtr when this procedure was invoked (i.e. determines variable scoping within caller; same as callerPtr unless an "uplevel" command or something equivalent was active in the caller).
} Tcl_CallFrame;
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_ArraySearch {
	Tcl_TableSearch			search;				//Info kept by the hash module about progress through the array.
	Tcl_TableEntry*			nextEntryPtr;
} Tcl_ArraySearch;
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_Interp {
	const char*			result;				//Points to result returned by last command.		//AvP[VQƂȌJtB[h
	Tcl_Table			commandTable;			//Contains all of the commands currently registered in this interpreter. Indexed by strings; values have type (Tcl_Command*).
	Tcl_Table			globalTable;			//Contains all global variables for interpreter. Indexed by strings; values have type (Tcl_Var*).
	Tcl_Table			arraySearchTable;		//Contains all array searches currently active in this interpreter. Indexed by strings; values have type (Tcl_ArraySearch*).
	Tcl_Table			fileTable;			//Contains all files opened in this interpreter. Indexed by strings; values have type (FILE*).
	int				numLevels;			//Keeps track of how many nested calls to Tcl_Eval are in progress for this interpreter. It's used to delay deletion of the table until all Tcl_Eval invocations are completed.
	Tcl_CallFrame*			framePtr;			//Points to top-most in stack of all nested procedure invocations. NULL means there are no active procedures.
	Tcl_CallFrame*			varFramePtr;			//Points to the call frame whose variables are currently in use (same as framePtr unless an "uplevel" command is being executed). NULL means no procedure is active or "uplevel 0" is being exec'ed.
	int				noEval;
	int				argc;				//
	char**				argv;				//Tcl_CmdProc()ւ̈
	void*				data;				//
} Tcl_Interp;
/*--------------------------------------------------------------------------*/
Tcl_Interp* Tcl_CreateInterp();													//AvP[V痘pȃO[o֐
void Tcl_AppendElement(Tcl_Interp* iPtr, const char* elem);
void Tcl_AppendResult(Tcl_Interp* iPtr, const char* fmt, ...);
int Tcl_ReturnCmd(Tcl_Interp* iPtr);
int Tcl_ErrorCmd(Tcl_Interp* iPtr);
int Tcl_CatchCmd(Tcl_Interp* iPtr);
/****************************************************************************
 *	
 ****************************************************************************/
typedef int Tcl_CmdProc(Tcl_Interp* iPtr);
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_Command {
	Tcl_CmdProc*			proc;
	void*				data;
} Tcl_Command;
/*--------------------------------------------------------------------------*/
void Tcl_CreateCommand(Tcl_Interp* iPtr, const char* cmdName, Tcl_CmdProc* proc, void* data);					//AvP[V痘pȃO[o֐
int Tcl_DeleteCommand(Tcl_Interp* iPtr, char* cmdName);										//AvP[V痘pȃO[o֐
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_CommandComplete(const char* s);
char* Tcl_WordEnd(const char* s, int nested);
char* Tcl_QuoteEnd(const char* s, int termChar);
char* Tcl_VarNameEnd(const char* s);
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_Eval(Tcl_Interp* iPtr, const char* s, char** termPtr, int termChar);
int Tcl_EvalString(Tcl_Interp* iPtr, const char* s);										//AvP[V痘pȃO[o֐
int Tcl_EvalFile(Tcl_Interp* iPtr, FILE* fp);											//AvP[V痘pȃO[o֐
int Tcl_ParseWords(Tcl_Interp* iPtr, const char *s, char** termPtr, int termChar, int* argcPtr, char*** argvPtr);
int Tcl_ParseQuotes(Tcl_Interp* iPtr, const char* s, char** termPtr, int rightChar);
int Tcl_ParseBraces(Tcl_Interp* iPtr, const char* s, char** termPtr, int termChar);
char* Tcl_ParseVar(Tcl_Interp* iPtr, const char* s, char** termPtr);
/****************************************************************************
 *	
 ****************************************************************************/
/* Tcl_Var.type */
#define TCL_VAR_UNDEFINED		0
#define TCL_VAR_SCALAR			1
#define TCL_VAR_ARRAY			2
#define TCL_VAR_UPVAR			3
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_Var {
	int				type;
	union {
		char*			scalar;
		Tcl_Table*		array;
		Tcl_TableEntry*		upvar;
	} value;
} Tcl_Var;
/*--------------------------------------------------------------------------*/
char* Tcl_GetVar(Tcl_Interp* iPtr, const char* name);										//AvP[V痘pȃO[o֐
char* Tcl_SetVar(Tcl_Interp* iPtr, char* name, const char* value);								//AvP[V痘pȃO[o֐
int Tcl_UnsetVar(Tcl_Interp* iPtr, char* name);											//AvP[V痘pȃO[o֐
char* Tcl_GetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2);
char* Tcl_SetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* value);
int Tcl_UnsetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2);
/*--------------------------------------------------------------------------*/
int Tcl_SetCmd(Tcl_Interp* iPtr);
int Tcl_UnsetCmd(Tcl_Interp* iPtr);
int Tcl_AppendCmd(Tcl_Interp* iPtr);
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_GetInt(Tcl_Interp* iPtr, const char* s, int* intPtr);
int Tcl_GetDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr);
int Tcl_GetBoolean(Tcl_Interp* iPtr, const char* s, int* boolPtr);
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _Tcl_Arg {
	char*				name;				//Name of argument starts here. The name is followed by space for the default, if there is one. The actual size of this field will be as large as necessary to hold both name and default value.
	char*				defValue;			//Pointer to arg's default value, or NULL if no default value.
	struct _Tcl_Arg*		nextArgPtr;			//Next argument for this procedure, or NULL if this is the last argument.
} Tcl_Arg;
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_Proc {
	char*				command;			//Command that constitutes the body of the procedure (dynamically allocated).
	Tcl_Arg*			argPtr;				//Pointer to first of procedure's formal arguments, or NULL if none.
} Tcl_Proc;
/*--------------------------------------------------------------------------*/
int Tcl_ProcCmd(Tcl_Interp* iPtr);
int Tcl_RenameCmd(Tcl_Interp* iPtr);
int Tcl_UplevelCmd(Tcl_Interp* iPtr);
int Tcl_UpvarCmd(Tcl_Interp* iPtr);
int Tcl_GlobalCmd(Tcl_Interp* iPtr);
/*--------------------------------------------------------------------------*/
int Tcl_ArrayCmd(Tcl_Interp* iPtr);
/*--------------------------------------------------------------------------*/
int Tcl_GetIndex(Tcl_Interp* iPtr, const char* s, int* indexPtr, int* endPtr);
int Tcl_ListCmd(Tcl_Interp* iPtr);
int Tcl_LlengthCmd(Tcl_Interp* iPtr);
int Tcl_LindexCmd(Tcl_Interp* iPtr);
int Tcl_LinsertCmd(Tcl_Interp* iPtr);
int Tcl_LrangeCmd(Tcl_Interp* iPtr);
int Tcl_LreplaceCmd(Tcl_Interp* iPtr);
int Tcl_LsearchCmd(Tcl_Interp* iPtr);
int Tcl_LsortCmd(Tcl_Interp* iPtr);
/*--------------------------------------------------------------------------*/
int Tcl_GlobCmd(Tcl_Interp* iPtr);
/*--------------------------------------------------------------------------*/
int Tcl_IncrCmd(Tcl_Interp* iPtr);
int Tcl_ConcatCmd(Tcl_Interp* iPtr);
int Tcl_JoinCmd(Tcl_Interp* iPtr);
int Tcl_SplitCmd(Tcl_Interp* iPtr);
/****************************************************************************
 *	
 ****************************************************************************/
/* Tcl_Value.type */
#define TCL_TYPE_STRING			 0
#define TCL_TYPE_INT			 1
#define TCL_TYPE_DOUBLE			 2
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_Value {
	int				type;
	union {
		int			intValue;
		double			doubleValue;
		const char*		stringValue;
	} value;
} Tcl_Value;
/*--------------------------------------------------------------------------*/
/* Tcl_ExprInfo.token */
#define TCL_TOKEN_VALUE			 0
#define TCL_TOKEN_OPEN_PAREN		 1
#define TCL_TOKEN_CLOSE_PAREN		 2
#define TCL_TOKEN_END			 3
//Binary operators:
#define TCL_TOKEN_MULT			 4
#define TCL_TOKEN_DIVIDE		 5
#define TCL_TOKEN_MOD			 6
#define TCL_TOKEN_PLUS			 7
#define TCL_TOKEN_MINUS			 8
#define TCL_TOKEN_LEFT_SHIFT		 9
#define TCL_TOKEN_RIGHT_SHIFT		10
#define TCL_TOKEN_LESS			11
#define TCL_TOKEN_GREATER		12
#define TCL_TOKEN_LEQ			13
#define TCL_TOKEN_GEQ			14
#define TCL_TOKEN_EQUAL			15
#define TCL_TOKEN_NEQ			16
#define TCL_TOKEN_BIT_AND		17
#define TCL_TOKEN_BIT_XOR		18
#define TCL_TOKEN_BIT_OR		19
#define TCL_TOKEN_AND			20
#define TCL_TOKEN_OR			21
#define TCL_TOKEN_QUESTY		22
#define TCL_TOKEN_COLON			23
//Unary operators:
#define	TCL_TOKEN_UNARY_MINUS		24
#define TCL_TOKEN_NOT			25
#define TCL_TOKEN_BIT_NOT		26
/*--------------------------------------------------------------------------*/
typedef struct _Tcl_ExprInfo {
	int				token;			//Type of the last token to be parsed from expr. See below for definitions. Corresponds to the characters just before expr.
	const char*			expr;			//Position to the next character to be scanned from the expression string.
} Tcl_ExprInfo;
/*--------------------------------------------------------------------------*/
int Tcl_EvalCmd(Tcl_Interp* iPtr);
int Tcl_ExprCmd(Tcl_Interp* iPtr);
int Tcl_ExprString(Tcl_Interp* iPtr, const char* s);
int Tcl_ExprInt(Tcl_Interp* iPtr, const char* s, int* intPtr);
int Tcl_ExprDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr);
int Tcl_ExprBoolean(Tcl_Interp* iPtr, const char* s, int* booleanPtr);
int Tcl_ExprTopLevel(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr);
int Tcl_ExprGetValue(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, int prec, Tcl_Value* valuePtr);
int Tcl_ExprLex(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, Tcl_Value* valuePtr);
int Tcl_ExprParseString(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr);
void Tcl_ExprMakeString(Tcl_Value* valuePtr);
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_BreakCmd(Tcl_Interp* iPtr);
int Tcl_ContinueCmd(Tcl_Interp* iPtr);
int Tcl_IfCmd(Tcl_Interp* iPtr);
int Tcl_WhileCmd(Tcl_Interp* iPtr);
int Tcl_ForCmd(Tcl_Interp* iPtr);
int Tcl_ForeachCmd(Tcl_Interp* iPtr);
int Tcl_SwitchCmd(Tcl_Interp* iPtr);
int Tcl_StringCmd(Tcl_Interp* iPtr);
int Tcl_FormatCmd(Tcl_Interp* iPtr);
int Tcl_ScanCmd(Tcl_Interp* iPtr);
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_ExitCmd(Tcl_Interp* iPtr);
int Tcl_OpenCmd(Tcl_Interp* iPtr);
int Tcl_CloseCmd(Tcl_Interp* iPtr);
int Tcl_FlushCmd(Tcl_Interp* iPtr);
int Tcl_EofCmd(Tcl_Interp* iPtr);
int Tcl_TellCmd(Tcl_Interp* iPtr);
int Tcl_SeekCmd(Tcl_Interp* iPtr);
int Tcl_GetsCmd(Tcl_Interp* iPtr);
int Tcl_PutsCmd(Tcl_Interp* iPtr);
int Tcl_SourceCmd(Tcl_Interp* iPtr);

#endif/*__CLIP_TCL_H__*/
