/*
 *	cliptcl.c
 *
 *	TclC^v^
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sun Oct 26 19:32:00 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- ukeep/TclΉ.xlsvɁAΉ󋵂L^čs܂B
 */
#include "clip.h"

//
//ydvzW[́AK[x[WRN^[Ƃ̕pOƂĂ܂B@@@@@@@@@@@@@@@@@@@@
//EP/ECEł́ATcl_CreateInterp()ĂяoOɁAugc_init(GC_LEVEL_CONSERVATIVE);vsĂĂB
//EPCł́AK[x[WRN^[̃Cu(uBoehm GCv)NĂB@@@@@@@@@@@@@@
//

/****************************************************************************
 *	
 ****************************************************************************/
/* ̐擪ɁATcľdlɉA{`},,"`"ň͂܂ꂽvfL邩𔻒fB
 * [in]
 *	s		ׂ镶B
 *	leftChar	͂݊JnB'{',,'"'w肵ĂB(̕w\)
 *	rightChar	͂ݏIB'}',,'"'w肵ĂB(̕w\)
 *	termChar	͂ݏI̎̕ƂāAk,,spɉċe镶	Ƃ΁uset x [expr {1+1}]vp[X\Ƃ邽߂̈łB'}'̎󔒂łȂ']'ł邪'}'镶łƔ肵܂B
 * [out]
 *	߂l		͂܂ꂽvfȂ΁ȀI[|C^ԂB
 *			͂܂ꂽvfłȂ΁ANULL|C^ԂB
 * [note]
 *	- ֐́ATcl_IsBracedElement()Tcl_IsQuotedElement()̋ʏƂč쐬܂A
 *	  ͔ėpIɍĂ̂ŁAleftChar,rightCharɔCӂ̕w肷邱Ƃł܂B
 *	- s̐擪ɁA͂܂ꂽvfL邩𔻒f@́Aȉ̒ʂłB
 *	  1. 1ڂ͂݊JnłȂ΁A͂܂ꂽvfłȂB
 *	  2. 2ڈȍ~A͂݊Jn,y,͂ݏII[ƂāAGXP[vB
 *	  3. ͂ݏIŏI[ꍇ́A[炷B[0ɂȂꍇA̕𒲂ׂB
 *	  3-1. ͂ݏI̎̕Ak,,sp,,e镶̂ꂩȂ΁A͂܂ꂽvfłB
 *	  3-2. ͂ݏI̎̕ȊO̕Ȃ΁A͂܂ꂽvfłȂB
 *	  4. ͂݊JnŏI[ꍇ́A[𑝂₷B
 *	  5. ȊO̕ŏI[ꍇ́A͂܂ꂽvfłȂB
 *	  ͂܂ꂽvfꍇ́A͂ݏI̎̈ʒuA͂܂ꂽvf̏I[|C^łB
 */
static char* Tcl_IsEnclosedElement(const char* s, int leftChar, int rightChar, int termChar) {
	const char delim[3] = { leftChar, rightChar, '\0' };
	int c, depth = 1;
	/* ŏ̕擾āA֐i߂B
	 * ŏ͂݊̕JnłȂ΁A͂܂ꂽvfł͂ȂB */
	if(*s++ != delim[0]) { return NULL; }
	for(;;) {
		/* GXP[vĂȂ͂݊Jn,͂ݏI,,kɓB܂ŁAGXP[vB
		 * GXP[vʂ́̕AsvȂ̂ŁAɊJB */
		free(strcompress(s, (char**)&s, delim));/* "\t\n\v\f\r "́A͂܂ꂽvf̒ɂẮAI[ł͂ȂB */
		/* GXP[vI[̕擾āA֐i߂B */
		c = *s++;
		/* ͂ݏIȂ΁c
		 * - ͂݊Jnƈ͂ݏIꍇ̂߂ɁA͂ݏIɔfB */
		if(c == delim[1]) {
			/* [炷B */
			depth--;
			/* [0ɂȂc */
			if(!depth) {
				/* ͂ݏI̎̕Ak,,sp,,e镶̂ꂩȂ΁A͂܂ꂽvfłB
				 * ͂ݏI̎̈ʒuA͂܂ꂽvf̏I[|C^łB */
				if(!*s || isspace(*s) || ((*s == '\\') && (*(s+1) == '\n')) || (*s == termChar)) { return (char*)s; }
				/* ȊO̕Ȃ΁A͂܂ꂽvfłȂB */
				break;
			}
		/* ͂݊JnȂ΁c */
		} else if(c == delim[0]) {
			/* [𑝂₷B */
			depth++;
		/* ȊO̕Ȃ΁c */
		} else {
			/* ͂܂ꂽvfłȂB */
			break;
		}
	}
	/* ͂܂ꂽvfłȂ΁ANULLԂB */
	return NULL;
}
/* ̐擪ɁATcľdlɉA{`}ň͂܂ꂽvfL邩𔻒fB
 * s၄
 * Tcl_IsBracedElement(  "{123}"  )	True
 * Tcl_IsBracedElement( "{{123}"  )	False	[0ɂȂOɃkŏI[B
 * Tcl_IsBracedElement(  "{123}}" )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsBracedElement( " {123}"  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsBracedElement(  "{123} " )	True
 * Tcl_IsBracedElement( "x{123}"  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsBracedElement(  "{123}x" )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsBracedElement("x {123}"  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsBracedElement(  "{123} x")	True
 */
char* Tcl_IsBracedElement(const char* s, int termChar) {
	return Tcl_IsEnclosedElement(s, '{', '}', termChar);
}
/* ̐擪ɁATcľdlɉA"`"ň͂܂ꂽvfL邩𔻒fB
 * s၄
 * Tcl_IsQuotedElement(  "\"123\""  )	True
 * Tcl_IsQuotedElement("\"\"123\""  )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsQuotedElement(  "\"123\"\"")	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsQuotedElement( " \"123\""  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsQuotedElement(  "\"123\" " )	True
 * Tcl_IsQuotedElement( "x\"123\""  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsQuotedElement(  "\"123\"x" )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsQuotedElement("x \"123\""  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsQuotedElement(  "\"123\" x")	True
 */
char* Tcl_IsQuotedElement(const char* s, int termChar) {
	return Tcl_IsEnclosedElement(s, '"', '"', termChar);
}
/*--------------------------------------------------------------------------*/
/* XgƌȂĕAvfz쐬B
 * [in]
 *	s		镶B
 *	argvPtr		vfz̃|C^i[ϐւ̃|C^BNULLw肷Ɗi[ȂB
 * [out]
 *	߂l		vfB
 * [note]
 *	- vfźANULL|C^ŏI[܂B߂l̗vf́AI[NULL|C^܂݂܂B
 *	  (main֐́Aargc,argvƓlłB)
 *	- ĂяoŃJ@́Aȉ̂ƂłBGCgpꍇ́AJsvłB
 *	  const char s[]="1st \"\\x32nd \\x33rd\" {\\x34th \\x35th}";
 *	  char**argv;
 *	  int i,argc=Tcl_SplitList(s,&argv);
 *	  for(i=0;i<argc;i++){//I(argv[i])ł
 *	    printf("[%d] %s\n",i,argv[i]);
 *	  }
 *	  for(i=0;i<argc;i++){free(argv[i]);}//J
 *	  free(argv);                        //
 *	  ʁ
 *	  [0] 1st
 *	  [1] 2nd 3rd
 *	  [2] \x34th \x35th
 */
int Tcl_SplitList(const char* s, char*** argvPtr) {
	int    argc = 0;
	char** argv = NULL;
	for(;;) {
		char* elem = NULL;
		/* 擪̋󔒂ǂݔ΂B */
		s += strspn(s, "\t\n\v\f\r ");
		/* ̏I[łȂ΁c */
		if(*s) {
			char* endp;
			/* gʂň͂܂ꂽvfȂ΁c */
			if((endp = Tcl_IsBracedElement(s, 0))) {
				/* gʂ̒̕AGXP[vɎ擾B */
				if(!(elem = strndup(s+1, endp-s-2))) { DIE(); }
			/* dpň͂܂ꂽvfȂ΁c */
			} else if((endp = Tcl_IsQuotedElement(s, 0))) {
				/* dp̒̕AGXP[vĎ擾B */
				elem = strcompress(s+1, NULL, "\"");
			/* ͂܂ꂽvfłȂ΁c */
			} else {
				/* 󔒕܂ł̕AGXP[vĎ擾B */
				elem = strcompress(s, &endp, "\t\n\v\f\r ");
			}
			/* I[(̓k)玟̗vfB */
			s = endp;
		}
		/* vfzɁAvf,,NULL|C^i[B */
		if(!(argv = realloc(argv, sizeof(char*) * (argc+1)))) { DIE(); }
		argv[argc] = elem;
		/* vfz̏I[Ȃ΁c */
		if(!elem) {
			/* vfz̃|C^i[BvĂȂΔjB */
			if(argvPtr) { *argvPtr = argv; } else { free(argvPtr); }
			/* vfԂBI[NULL|C^͗vfɊ܂߂ȂB */
			return argc;
		}
		/* vf𑝂₷B */
		argc++;
	}
}
/*--------------------------------------------------------------------------*/
//"list"R}hɑB
char* Tcl_Merge(int argc, char** argv) {
	char* s = strdup("");
	int i;
	for(i = 0; i < argc; i++) {
		const char* elem = strescape(argv[i], " $;[]{}");	//evfgȂBGXP[vB
		if(!*elem) { elem = "\\0"; }				//󕶎̗vf΂ȂBulist x "" yv̌ʂ́ux yvł͂Ȃux {} yv,,ux \0 yvɂȂB
		s = strjoin(*s ? " " : NULL, s, elem, NULL);		//Zp[^LB
	}
	return s;
}
/*--------------------------------------------------------------------------*/
//"concat"R}hɑB
char* Tcl_Concat(int argc, char** argv) {
	char* s = strdup("");
	int i;
	for(i = 0; i < argc; i++) {
		const char* elem = strtrim(argv[i], 0, NULL);		//evfgBGXP[vȂB
		if(!*elem) { continue; }				//gʂ󕶎ƂȂvf͔΂Buconcat x "" yv̌ʂ́ux  yvł͂Ȃux yvɂȂB
		s = strjoin(*s ? " " : NULL, s, elem, NULL);		//Zp[^LB
	}
	return s;
}
/*--------------------------------------------------------------------------*/
/* c̎ނ𔻕ʂBTcl_ParseWords()gpB
 * lXgR}ȟĂяołꍇ́A(termChar=']')w肷邱ƁB
 * ȊȌꍇ́A(termChar=0)w肷邱ƁB */
int Tcl_CharType(int c, int termChar) {
	static const char TypeTable[]={
		1,'$',				//8 TCL_DOLLAR
		1,'\\',				//7 TCL_BACKSLASH
		1,'}',				//6 TCL_CLOSE_BRACE
		1,'{',				//5 TCL_OPEN_BRACE
		1,'[',				//4 TCL_OPEN_BRACKET
		1,'"',				//3 TCL_QUOTE
		3,'\0','\n',';',		//2 TCL_COMMAND_END
		5,'\t','\v','\f','\r',' '};	//1 TCL_SPACE
	const char* p = TypeTable;
	int t = TCL_DOLLAR;
	if(c == termChar) { return TCL_COMMAND_END; }	//(c=']')&&(termChar=']')̏ꍇ͂TCL_COMMAND_ENDƔfB(c='\0')&&(termChar=0)̏ꍇTCL_COMMAND_ENDƔf邪ȂB(c='\0')&&(termChar=']')̏ꍇ͉̃[v̒TCL_COMMAND_ENDƔfB
	do {
		int n = *p++;
		do {
			if(*p++ == c) { return t; }
		} while(--n);
	} while(--t);
	return TCL_NORMAL;
}
/****************************************************************************
 *	
 ****************************************************************************/
/*  */
void Tcl_InitTable(Tcl_Table* tablePtr) {
	InitializeListHead(&tablePtr->list_head);
}
/*--------------------------------------------------------------------------*/
/* 쐬 */
Tcl_TableEntry* Tcl_CreateTableEntry(Tcl_Table* tablePtr, const char* key, int* newPtr) {
	Tcl_TableEntry* entryPtr;
	int bNew = 0;
	if(!(entryPtr = Tcl_FindTableEntry(tablePtr, key))) {
		entryPtr = calloc(sizeof(Tcl_TableEntry), 1);
		InsertTailList(&tablePtr->list_head, &entryPtr->list_entry);
		entryPtr->key = strdup(key);
		bNew = 1;
	}
	if(newPtr) { *newPtr = bNew; }
	return entryPtr;
}
/*--------------------------------------------------------------------------*/
/*  */
Tcl_TableEntry* Tcl_FindTableEntry(Tcl_Table* tablePtr, const char* key) {
	Tcl_TableSearch search;
	Tcl_TableEntry* entryPtr;
	for(entryPtr = Tcl_FirstTableEntry(tablePtr, &search);
	    entryPtr;
	    entryPtr = Tcl_NextTableEntry(&search)) {
		if(!strcmp(entryPtr->key, key)) { break; }
	}
	return entryPtr;
}
/*--------------------------------------------------------------------------*/
/* 폜 */
void Tcl_DeleteTableEntry(Tcl_TableEntry* entryPtr) {
	RemoveEntryList(&entryPtr->list_entry);
}
/*--------------------------------------------------------------------------*/
/* Jn */
Tcl_TableEntry* Tcl_FirstTableEntry(Tcl_Table* tablePtr, Tcl_TableSearch* searchPtr) {
	searchPtr->list_head = searchPtr->list_entry = &tablePtr->list_head;
	return Tcl_NextTableEntry(searchPtr);
}
/*--------------------------------------------------------------------------*/
/*  */
Tcl_TableEntry* Tcl_NextTableEntry(Tcl_TableSearch* searchPtr) {
	if((searchPtr->list_entry = searchPtr->list_entry->Flink) == searchPtr->list_head) { return NULL; }
	return CONTAINING_RECORD(searchPtr->list_entry, Tcl_TableEntry, list_entry);
}
/****************************************************************************
 *	
 ****************************************************************************/
static const struct {
	const char*			name;				//Name of command.
	Tcl_CmdProc*			proc;				//Procedure that executes command.
} TBL_TclBuiltInCmds[]={
	//Commands in the generic core:
	{"return",		Tcl_ReturnCmd},
	{"error",		Tcl_ErrorCmd},
	{"catch",		Tcl_CatchCmd},
	{"set",			Tcl_SetCmd},
	{"unset",		Tcl_UnsetCmd},
	{"append",		Tcl_AppendCmd},		//ʉ
	{"lappend",		Tcl_AppendCmd},		//
	{"proc",		Tcl_ProcCmd},
	{"rename",		Tcl_RenameCmd},
	{"uplevel",		Tcl_UplevelCmd},
	{"upvar",		Tcl_UpvarCmd},
	{"global",		Tcl_GlobalCmd},
	{"array",		Tcl_ArrayCmd},
	{"list",		Tcl_ListCmd},
	{"llength",		Tcl_LlengthCmd},
	{"lindex",		Tcl_LindexCmd},
	{"linsert",		Tcl_LinsertCmd},
	{"lrange",		Tcl_LrangeCmd},
	{"lreplace",		Tcl_LreplaceCmd},
	{"lsearch",		Tcl_LsearchCmd},
	{"lsort",		Tcl_LsortCmd},
	{"glob",		Tcl_GlobCmd},
	{"incr",		Tcl_IncrCmd},
	{"concat",		Tcl_ConcatCmd},
	{"join",		Tcl_JoinCmd},
	{"split",		Tcl_SplitCmd},
	{"eval",		Tcl_EvalCmd},
	{"expr",		Tcl_ExprCmd},
	{"break",		Tcl_BreakCmd},
	{"continue",		Tcl_ContinueCmd},
	{"if",			Tcl_IfCmd},
	{"while",		Tcl_WhileCmd},
	{"for",			Tcl_ForCmd},
	{"foreach",		Tcl_ForeachCmd},
	{"switch",		Tcl_SwitchCmd},
	{"string",		Tcl_StringCmd},
	{"format",		Tcl_FormatCmd},
	{"scan",		Tcl_ScanCmd},
	{"exit",		Tcl_ExitCmd},
	{"open",		Tcl_OpenCmd},
	{"close",		Tcl_CloseCmd},
	{"flush",		Tcl_FlushCmd},
	{"eof",			Tcl_EofCmd},
	{"tell",		Tcl_TellCmd},
	{"seek",		Tcl_SeekCmd},
	{"gets",		Tcl_GetsCmd},
	{"puts",		Tcl_PutsCmd},
	{"source",		Tcl_SourceCmd},
//	{"read",		Tcl_ReadCmd},		//ΉȂ
//	{"info",		Tcl_InfoCmd},		//ΉȂ
//	{"regexp",		Tcl_RegexpCmd},		//ΉȂ
//	{"regsub",		Tcl_RegsubCmd},		//ΉȂ
//	{"trace",		Tcl_TraceCmd},		//ΉȂ
//	{"cd",			Tcl_CdCmd},		//ΉȂ
//	{"exec",		Tcl_ExecCmd},		//ΉȂ
//	{"file",		Tcl_FileCmd},		//ΉȂ
//	{"pwd",			Tcl_PwdCmd},		//ΉȂ
//	{"time",		Tcl_TimeCmd},		//ΉȂ
};
/*--------------------------------------------------------------------------*/
Tcl_Interp* Tcl_CreateInterp() {
	Tcl_Interp* iPtr;
	int i;
	//Create a new TCL command interpreter.
	iPtr = calloc(sizeof(Tcl_Interp), 1);
	iPtr->result = "";
	Tcl_InitTable(&iPtr->commandTable);
	Tcl_InitTable(&iPtr->globalTable);
	Tcl_InitTable(&iPtr->arraySearchTable);
	Tcl_InitTable(&iPtr->fileTable);
	Tcl_CreateTableEntry(&iPtr->fileTable, "stdin",  NULL)->value = stdin;	//
	Tcl_CreateTableEntry(&iPtr->fileTable, "stdout", NULL)->value = stdout;	//Wo͂o^ĂB
	Tcl_CreateTableEntry(&iPtr->fileTable, "stderr", NULL)->value = stderr;	//
	//Create the built-in commands.
	for(i = 0; i < ARRAY_SIZE(TBL_TclBuiltInCmds); i++) {
		Tcl_CreateCommand(iPtr,
			TBL_TclBuiltInCmds[i].name,
			TBL_TclBuiltInCmds[i].proc, NULL);
	}
	return iPtr;
}
/*--------------------------------------------------------------------------*/
void Tcl_AppendElement(Tcl_Interp* iPtr, const char* elem) {
	elem = strescape(elem, " $;[]{}");	//GXP[vB
	if(!*elem) { elem = "\\0"; }		//󕶎̃Xgvf\邽߂ɕKvB
	iPtr->result = strjoin(
		*iPtr->result ? " " : NULL,	//Zp[^LB
		iPtr->result,
		elem,
		NULL);
}
/*--------------------------------------------------------------------------*/
void Tcl_AppendResult(Tcl_Interp* iPtr, const char* fmt, ...) {
	char* elem;
	va_list ap;
	va_start(ap, fmt);
	elem = strdup_vprintf(fmt, ap);		//GXP[vȂB
	iPtr->result = strjoin(
		NULL,				//Zp[^B
		iPtr->result,
		elem,
		NULL);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
int Tcl_ReturnCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc > 2) { goto syntaxError; }
	if(iPtr->argc == 2) { iPtr->result = iPtr->argv[1]; }
	return TCL_RETURN;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ErrorCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 2) { goto syntaxError; }
	iPtr->result = iPtr->argv[1];
	return TCL_ERROR;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_CatchCmd(Tcl_Interp* iPtr) {
	int retCode;
	if((iPtr->argc < 2) || (iPtr->argc > 3)) { goto syntaxError; }
	retCode = Tcl_EvalString(iPtr, iPtr->argv[1]);
	if(iPtr->argc == 3) {
		if(!Tcl_SetVar(iPtr, iPtr->argv[2], iPtr->result)) {
			iPtr->result = "couldn't save command result in variable";
			return TCL_ERROR;
		}
	}
	iPtr->result = strdup_printf("%d", retCode);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
void Tcl_CreateCommand(Tcl_Interp* iPtr, const char* cmdName, Tcl_CmdProc* proc, void* data) {
	Tcl_TableEntry* tablePtr = Tcl_CreateTableEntry(&iPtr->commandTable, cmdName, NULL);
	Tcl_Command* cmdPtr = calloc(sizeof(Tcl_Command), 1);
	tablePtr->value = cmdPtr;
	cmdPtr->proc = proc;
	cmdPtr->data = data;
}
/*--------------------------------------------------------------------------*/
int Tcl_DeleteCommand(Tcl_Interp* iPtr, char* cmdName) {
	Tcl_TableEntry* tPtr = Tcl_FindTableEntry(&iPtr->commandTable, cmdName);
	if(!tPtr) { return -1; }
	Tcl_DeleteTableEntry(tPtr);
	return 0;
}
/****************************************************************************
 *	
 ****************************************************************************/
/* sASȃR}hł邩𔻒fB
 * SȃR}hƂ́Au(|;){(Sȃ[h){(|;){...v̂ƂłB(Ȑł͂ȂB)
 * SȃR}hȂ΁A0ȊOԂB
 * SȃR}hłȂ΁A0ԂB
 * s}`Xe[ggłꍇ́ASĂ(=Ō)Xe[ggSł邩𔻒fB */
int Tcl_CommandComplete(const char* s) {
//{{2014/10/25ύX:s󔒂΂łȂARgsǂݔ΂悤ɏCB
//	for(;;) {
//		/* s󔒂΂B */
//		while(isspace(*s)) { s++; }
//		/* 0ȏ̋󔒂ŏI[ĂASȃR}hłB */
//		if(!*s) { return 1; }
//		/* [hSł邩𔻒肷B */
//		s = Tcl_WordEnd(s, 0);
//		/* [hsSȂ΁ASȃR}hłȂB */
//		if(!*s) { return 0; }
//		/* [h̍Ṓ̕A̕pB */
//		s++;
//	}
//2014/10/25ύX:s󔒂΂łȂARgsǂݔ΂悤ɏCB
//̏ȂƁAu#i[vƂRgs͂ĉsƂɁASȃR}hƌȂȂB
//ȂȂ΁Au[v2oCgڂ'['ƌȂAsĂR}hpƔfĂ܂łB
//Tcl6.7̃\[Xł́ATcl_CommandComplete()ɂĂ̓Rgǂݔ΂sĂȂA
//Tcl_CommandComplete()ɂĂATcl_Eval()Ɠl̃Rgǂݔ΂KvƎv̂ŒǉB
//Ȃ݂Ɍɂ́A{2oCgڂ'['ƌȂĂ܂́ARĝ݂Ȃ炸"`"̒łN蓾̂ŁAƖ͑傫̂A
//Ƃ肠AvO{̂̒ł͓{ΉƂĂARgœ{邱Ƃ͓̂ŁARĝ̖ݑΏ邱ƂɂB
//A̕@ŉł̂́AuO[ox̃RgvłAu֐̃ubÑRgv̓{̖͉łȂB
//u֐̃ubÑRgv͂ł͂ȂTcl_WordEnd()̒ŉ߂邩łB
//ǂ̂ƂA{(Rgłł)ȂׂgpȂ悤ɂ̂S낤B
//ɂstrescape(),strcompress()CЂĂstrspn(),strcspn()}`oCgΉɉ邱ƂAe傫߂̂ōsȂƂɂB
//2014/10/25ǋL
//L̑ΉsĂA***Tcl̂̎dl̂߂***ARg̊ʂÂ炢oOɉe邱Ƃ͔ȂB
//Ƃ΁A{tclshőΘb[hŎsA
//  if {1} {
//  #if {2} {
//    puts ok
//  }
//̂悤ɓ͂ƁAsڂ̊ʂĂȂƔfăR}hsȂB(^Z͂ƎsB)
//ł́A^Z͂ĂsꂸAmissing close-braceG[ɂȂB
//Tcl̃Rg̊ʂ̈͂낢Ƃ킩Â炢̂ŁAtclC^v^OiKŉvvZbT(cppƂm4Ƃsed)gďSȋCB
//Tcl̃Rg̊ʂ̈ɂāA֘Aukeep/Why_can_I_not_place_unmatched_braces_in_Tcl_commentsvɕۑB
L_LineStart:
	//s,y,Z~R΂B
	while(isspace(*s) || (*s == ';')) { s++; }
	//0ȏ̋󔒂ŏI[ĂASȃR}hłB
	if(!*s) { return 1; }
	//s,,}`Xe[gg̐擪猩āAŏɌꂽ󔒕'#'Ȃ΃RgsłB
	if(*s == '#') {
		for(;;) {
			s++;								//'#'̎̕֐i߂B
			if((*s == '\n') && (*(s-1) != '\\')) { goto L_LineStart; }	//GXP[vĂȂsȂ΁ARgIƌȂBs̏ɖ߂B	s̏'\n'΂̂ŁAŐi߂Ȃč\ȂB
			if(!*s) { return 0; }						//s̃Rgŕ񂪏Iꍇ́ASȃR}hłȂB
		}
	//RgsłȂ΁c
	} else {
		for(;;) {
			//[hSł邩𔻒肷B
			s = Tcl_WordEnd(s, 0);
			//[hsSȂ΁ASȃR}hłȂB
			if(!*s) { return 0; }
			//[hZ~RŏI[ĂAs̏ɖ߂B												s̏';'΂̂ŁAŐi߂Ȃč\ȂB
			if(*s == ';') { goto L_LineStart; }
			//[h̍Ṓ̕A̕pB
			s++;
			//󔒂΂B
			while(isspace(*s)) {
				if(*s == '\n') { goto L_LineStart; }			//sAs̏ɖ߂B						s̏'\n'΂̂ŁAŐi߂Ȃč\ȂB
				s++;							//󔒂̎̕֐i߂B
			}
			//0ȏ̋󔒂ŏI[ĂASȃR}hłB
			if(!*s) { return 1; }
		}
	}
//}}2014/10/25ύX:s󔒂΂łȂARgsǂݔ΂悤ɏCB
}
/*--------------------------------------------------------------------------*/
/* s̒́AŏɌ[h́AŌ̕ւ̃|C^ԂB((+1)ł͂ȂB)
 * s̒ɁAŏɌ[hsSłꍇ́Akւ̃|C^ԂB
 * s̒ɁA[hȂꍇ́Akւ̃|C^ԂB */
char* Tcl_WordEnd(const char* s, int nested) {
	char* p = (char*)s;
	/* s󔒂΂B */
	while(isspace(*p)) { p++; }
	/* [hdpŊJnĂc */
	if(*p == '"') {
		/* dpʒu擾B */
		p = Tcl_QuoteEnd(p + 1, '"');
		/* dpĂȂ΁Akւ̃|C^ԂB */
		if(!*p) { return p; }
		/* dpʒúA̕pB
		 * ۂɂ̓G[ł邪Ał͌pBTcl_Eval()ɂăG[ƂB */
		p++;
	/* [hgʂŊJnĂc */
	} else if(*p == '{') {
		/* Egʂ̈ʒu擾B */
//{{bC
//		strcompress(p, &p, "}");			//~~~ł{}̃lXgĂ炸uswitch 1 {{1}svWordEndƌȂĂ܂ĂB~~~
//		/* gʂĂȂ΁Akւ̃|C^ԂB */
//		if(!*p) { return p; }
//		/* Egʂ́A̕pB
//		 * ۂɂ̓G[ł邪Ał͌pBTcl_Eval()ɂăG[ƂB */
//		p++;
//bC
		p = Tcl_IsBracedElement(p, nested ? ']' : 0);	//[`]̒Ȃ'}'̌']'ĂĂok
		/* gʂĂȂ΁Akւ̃|C^ԂB */
		if(!p) { return strchr(s, '\0'); }		//Tcl_IsBracedElement()͕ĂȂNULLԂ̂ŁAēxI[TKvLBbCł̂ŁAłƌ̗ǂ@B
		//Tcl_IsBracedElement()'}'̎̈ʒuԂ̂p++͕sv
//}}bC
	}
	//Handle words that don't start with a brace or double-quote.
	//This code is also invoked if the word starts with a brace or double-quote and there is garbage after the closing brace or quote.
	//This is an error as far as Tcl_Eval is concerned, but for here the garbage is treated as part of the word.
	for(;;) {
///?		/* s󔒂΂B */									//Kvsv?v	2sLɂƁuwhile {1} {svŃ[hIĂ܂svB
///?		while(isspace(*p)) { p++; }									//Kvsv?v	
		/* ꕶ܂ł̕AGXP[vĎ擾B */
		strcompress(p, &p, "\t\n\v\f\r $;[]");
		if(!*p) {
			//Nested commands can't end because of the end of the string.
			if(nested) { return p; }
			if(str_has_suffix(s, "\\\n")) { return p; } //̍Ōɍsp(\+s)L鎞ɃR}hƌȂȂ߂̔łBȂGXP[vꂽ\+s(\\+s)̏ꍇ̓R}hƌȂKvL܂̏Ŕł܂B(\\+s)̏ꍇ͂ʂ炸Ɉԉ̃ubN֍sureturn p-1vŉs̈ʒuԂTcl_CommandComplete()ɂăR}hƔf邩łB
			return p - 1;
		} else if(*p == '$') {
			p = Tcl_VarNameEnd(p + 1);
			if(!*p) { return p; }
			p++;
		} else if(*p == ';') {
			//Include the semi-colon in the word that is returned.
			return p;
		} else if(*p == '[') {
			do {
				p = Tcl_WordEnd(p + 1, 1);
				if(!*p) { return p; }
			} while(*p != ']');
			p++;
		} else if(*p == ']') {
			if(nested) { return p; }
			p++;
		} else /*if(isspace(*p))*/ {
			return p - 1;
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ͂܂ꂽ́AIւ̃|C^ԂB((+1)ł͂ȂB)
 * ͂܂ꂽ񂪁AĂȂꍇ́Akւ̃|C^ԂB
 * śA͂܂ꂽ́AJn̎̕w肷邱ƁB
 * <>u"ABC"v𒲂ׂꍇAs='A'̈ʒu,termChar='"'w肵Aʂ'"'̈ʒuƂȂB
 * <>u(ABC)v𒲂ׂꍇAs='A'̈ʒu,termChar=')'w肵Aʂ')'̈ʒuƂȂB */
char* Tcl_QuoteEnd(const char* s, int termChar) {
	char* p = (char*)s;
	char* delim = strdup_printf("$[%c", termChar);
	for(;;) {
		strcompress(p, &p, delim);
		if(*p == '$') {
			p = Tcl_VarNameEnd(p + 1);
			if(!*p) { return p; }
			p++;
		} else if(*p == '[') {
			do {
				p = Tcl_WordEnd(p + 1, 1);
				if(!*p) { return p; }
			} while(*p != ']');
			p++;
		} else /*if(!*p || (*p == termChar))*/ {
			return p;
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ϐ́̕AŌ̕ւ̃|C^ԂB((+1)ł͂ȂB)
 * ϐSłȂꍇ́Akւ̃|C^ԂB
 * śAϐɐs'$'́A̕(=ϐ̈ꕶ)w肷邱ƁB
 * <>u$ABCv𒲂ׂꍇAs='A'̈ʒuw肵Aʂ'C'̈ʒuƂȂB
 * <>u${ABC}v𒲂ׂꍇAs='{'̈ʒuw肵Aʂ'}'̈ʒuƂȂB
 * <>u$ABC(123)v𒲂ׂꍇAs='A'̈ʒuw肵Aʂ')'̈ʒuƂȂB */
char* Tcl_VarNameEnd(const char* s) {
	char* p = (char*)s;
	if(*p == '{') {
		while(*p && (*p != '}')) { p++; }
		return p;
	} else {
		while(iscsym(*p)) { p++; }
		if(*p == '(') { return Tcl_QuoteEnd(p + 1, ')'); }
		return p - 1;
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//sɊ܂܂A}`Xe[ggsB
//́A'['̎̕A']'܂łsB
int Tcl_Eval(Tcl_Interp* iPtr, const char* s, char** termPtr, int termChar) {	//(termPtr=NULL)
	int retCode, argc;
	char* p = (char*)s;
	char** argv;
	Tcl_TableEntry* tPtr;
	Tcl_Command* cmdPtr;
	/* ʂNAĂB
	 *- ȂƁA󕶎sƈȉwhile[vʂ炸AʂsɂȂĂ܂B */
	retCode = TCL_OK;
	iPtr->result = "";
	/* Ăяo̐[𑝂₷B */
	if(iPtr->numLevels >= 99/**/) { DIE(); }
	iPtr->numLevels++;
	//There can be many sub-commands (separated by semi-colons or newlines) in one command string.
	//This outer loop iterates over individual commands.
	while(*p != termChar) {
		/* Rgsǂݔ΂BRgsǂݔ΂͂łB
		 * - Tcl͍s̓rɗL'#'RgƌȂȂ̂ŁAR}ȟɌ'#'͍lKvB
		 *   <>u#puts okv̓RgsłBuputs ok #xxxv#ȍ~RgƌȂꂸG[ƂȂB */
		while(isspace(*p) || (*p == ';')) { p++; }	//s,y,Z~R΂B
		if(*p == '#') {	//s,,}`Xe[gg̐擪猩āAŏɌꂽ󔒕'#'Ȃ΃RgsłB
			do {
				p++;	//̕֐i߂B
				if((*p == '\n') && (*(p-1) != '\\')) { p++; break; }	//GXP[vĂȂsȂ΁ARgIƌȂBs̎̕֐i߁AB
			} while(*p);	//s̃Rgŕ񂪏IꍇB
		}
		/* R}h𕪉Az쐬B */
		retCode = Tcl_ParseWords(iPtr, p, &p, termChar, &argc, &argv);	//IȂ΁Ap̓k,,';'̈ʒuwB
		if(retCode) { break; }	//G[ȂΔBĂяo̐[炷KvL邽߁AreturnĂ͂ȂB
		//If this is an empty command (or if we're just parsing commands without evaluating them), then just skip to the next command.
		if(!argc || iPtr->noEval) { continue; }
		//Find the procedure to execute this command.
		tPtr = Tcl_FindTableEntry(&iPtr->commandTable, argv[0]);
		if(!tPtr) {
			iPtr->result = strdup_printf("invalid command name: \"%s\"", argv[0]);
			retCode = TCL_ERROR;
			break;		//G[ȂΔBĂяo̐[炷KvL邽߁AreturnĂ͂ȂB
		}
		cmdPtr = tPtr->value;
		//At long last, invoke the command procedure.
		//Reset the result to its default empty value first (it could have gotten changed by earlier commands in the same command string).	dv
		iPtr->result = "";
		{
			/* Ăяop[^ޔB */
			int    save_argc = iPtr->argc;
			char** save_argv = iPtr->argv;
			void*  save_data = iPtr->data;
			/* Ăяop[^ݒ肷B */
			iPtr->argc = argc;
			iPtr->argv = argv;
			iPtr->data = cmdPtr->data;
			/* vV[W֐ĂяoB */
			retCode = (*cmdPtr->proc)(iPtr);
			/* Ăяop[^ޔB */
			iPtr->argc = save_argc;
			iPtr->argv = save_argv;
			iPtr->data = save_data;
		}
		if(retCode) { break; }	//TCL_OKȊO(=TCL_ERROR,TCL_RETURN,TCL_BREAK,TCL_CONTINUE,...)ȂΔBĂяo̐[炷KvL邽߁AreturnĂ͂ȂB
	}
	/* Ăяo̐[炷B */
	iPtr->numLevels--;
	/* Ăяo̐[0ɂȂc */
	if(!iPtr->numLevels) {
		/* ߂lɂāc */
		switch(retCode) {
		case TCL_OK:
		case TCL_ERROR:
			/** no job **/
			break;
		case TCL_RETURN:
			/* gbvxreturnꍇAIƂB */
			retCode = TCL_OK;
			break;
		case TCL_BREAK:
			/* gbvxbreakꍇAG[IƂB */
			iPtr->result = "invoked \"break\" outside of a loop";
			retCode = TCL_ERROR;
			break;
		case TCL_CONTINUE:
			/* gbvxcontinueꍇAG[IƂB */
			iPtr->result = "invoked \"continue\" outside of a loop";
			retCode = TCL_ERROR;
			break;
		default:
			/* ȊO̖߂l̏ꍇAʕݒ肵ŁAʏ̃G[ƂB */
			iPtr->result = strdup_printf("command returned bad code: %d", retCode);
			retCode = TCL_ERROR;
			break;
		}
	}
	if(termPtr) { *termPtr = p; }	//I[ʒui[B
	return retCode;
}
/*--------------------------------------------------------------------------*/
int Tcl_EvalString(Tcl_Interp* iPtr, const char* s) {
	return Tcl_Eval(iPtr, s, NULL, 0);
}
/*--------------------------------------------------------------------------*/
int Tcl_EvalFile(Tcl_Interp* iPtr, FILE* fp) {
	int interactive = isatty(fileno(fp));	//R\[ȂΑΘbIsƂ
	int retCode;
	do {
		const char* s = "";
		/* ΘbIsȂ΁c */
		if(interactive) {
			/* vvg\B */
			fputs("% ", stdout);
			fflush(     stdout);
		}
		do {
			do {
				char line[80/**/];
				/* ǂݍށBI[ȂΔB */
				if(!fgets(line, sizeof line, fp)) { break; }
				/* AB */
				s = strjoin(NULL, s, line, NULL);
			/* sȂΔB */
			} while(!str_has_suffix(s, "\n"));
			/* I[ȂΔB */
			if(feof(fp)) { break; }
		/* R}h܂ŌJԂB */
		} while(!Tcl_CommandComplete(s));
		/* R}hsB */
		retCode = Tcl_EvalString(iPtr, s);
		/* ΘbIsȂ΁c */
		if(interactive) {
			/* ,,G[\B */
			if(retCode) {
				printf("Error");
				if(retCode != TCL_ERROR) { printf(" %d", retCode); }
				if(*iPtr->result) { printf(": %s", iPtr->result); }
			} else {
				if(*iPtr->result) { printf("%s", iPtr->result); }
			}
			if(retCode || *iPtr->result) { printf("\n"); }
		/* ΘbIsłȂ΁c */
		} else {
			if(retCode) { break; }
		}
	/* I[܂ŌJԂB */
	} while(!feof(fp));
	/* Ō̌ʂԂB */
	return retCode;
}
/*--------------------------------------------------------------------------*/
//̃Xe[ggɑA[hzp[XB
//́A'['̎̕A']'܂łp[XB
int Tcl_ParseWords(Tcl_Interp* iPtr, const char *s, char** termPtr, int termChar, int* argcPtr, char*** argvPtr) {
	int retCode, type, argc = 0;
	char* p = (char*)s;
	char** argv = NULL;
	for(;;) {
		char* elem = strdup("");
		/* s󔒂ǂݔ΂B */
		while((type = Tcl_CharType(*p, termChar)) == TCL_SPACE) { p++; }
		/* obNXbV̏ꍇc */
		if(type == TCL_BACKSLASH) {
			/* spȂ΁A̍s̐s󔒂ǂݔ΂JԂB */
			if(*(p+1) == '\n') {
				p += 2;
			/* spȊÕobNXbVȂ΁Aʏ핶ƓƂB */
			} else {
				type = TCL_NORMAL;
			}
		}
		if(type == TCL_COMMAND_END) {
			if(!*p && (termChar == ']')) {	//lXgR}h']'ŏI[OɁȀI[ɒBꍇ̓G[B
				iPtr->result = "missing close-bracket";
				return TCL_ERROR;
			}
			break;	//R}hI
		} else if(type == TCL_QUOTE) {
			retCode = Tcl_ParseQuotes(iPtr, p+1, &p, '"');	//IȂ΁Ap'"'̈ʒuwB
			if(retCode) { return retCode; }
			elem = strjoin(NULL, elem, iPtr->result, NULL);
			p++;						//p'"'̎֐i߂B
			/* '"'̎ɋ̂́A,I[,sp݂̂łB */
			type = Tcl_CharType(*p, termChar);
			if((type == TCL_SPACE) ||				//
			   (type == TCL_COMMAND_END) ||				//I[
			  ((type == TCL_BACKSLASH) && (*(p+2) == '\n'))) {	//sp
				//L̂ꂩȂokB̃[h́Aus󔒂ǂݔ΂vŁAǂݔ΂B
			} else {
				iPtr->result = "extra characters after close-quote";
				return TCL_ERROR;
			}
			//[hI
		} else if(type == TCL_OPEN_BRACE) {
			retCode = Tcl_ParseBraces(iPtr, p+1, &p, termChar);	//IȂ΁Ap'}'̈ʒuwB
			if(retCode) { return retCode; }
			elem = strjoin(NULL, elem, iPtr->result, NULL);
			p++;						//p'}'̎֐i߂B
			/* '}'̎ɋ̂́A,I[,sp݂̂łB */
			type = Tcl_CharType(*p, termChar);
			if((type == TCL_SPACE) ||				//
			   (type == TCL_COMMAND_END) ||				//I[
			  ((type == TCL_BACKSLASH) && (*(p+2) == '\n'))) {	//sp
				//L̂ꂩȂokB̃[h́Aus󔒂ǂݔ΂vŁAǂݔ΂B
			} else {
				iPtr->result = "extra characters after close-brace";
				return TCL_ERROR;
			}
			//[hI
		} else {
			for(;;) {
				/* ꕶ̎O܂ŃGXP[vAɒǉB */
				char* value = strcompress(p, &p, "\t\n\v\f\r $;[]");	//̓lXgR}hOȂ̂ŁAI[(']'or'\0')̍lsvłB
				elem = strjoin(NULL, elem, value, NULL);
				/* ꕶ̎ނɂāc */
				type = Tcl_CharType(*p, termChar);
				if((type == TCL_SPACE) || (type == TCL_COMMAND_END)) {
					break;	//[hI
				} else if(type == TCL_OPEN_BRACKET) {
					retCode = Tcl_Eval(iPtr, p+1, &p, ']');		//IȂ΁Ap']'̈ʒuwB
					if(retCode) { return retCode; }
					elem = strjoin(NULL, elem, iPtr->result, NULL);
					p++;						//p']'̎֐i߂B
					//[hp
				} else if(type == TCL_DOLLAR) {
					value = Tcl_ParseVar(iPtr, p+1, &p);		//IȂ΁Ap͕ϐ(͕ϐ͂'}')̎̈ʒuwB
					if(!value) { return TCL_ERROR; }
					elem = strjoin(NULL, elem, value, NULL);
					//[hp
				} else {
					elem = strdup_printf("%s%c", elem, *p++);	//ꕶ̃ReLXgł͒ʏ핶B
					//[hp
				}
			}
		}
		/* vfi[B */
		argv = realloc(argv, sizeof(char*) * (argc+1));
		argv[argc++] = elem;
	}
	/* I[NULLi[B */
	argv = realloc(argv, sizeof(char*) * (argc+1));
	argv[argc] = NULL;
	/* I[ʒu,vf,vfzi[B */
	*termPtr = p;	//(termChar!=0)w肵ꍇ́AtermChar̈ʒu,,k̈ʒuwB(termChar=0)w肵ꍇ́Ak̈ʒuwB
	*argcPtr = argc;
	*argvPtr = argv;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//'"'̎̕A'"'܂łp[XB
//́A'('̎̕A')'܂łp[XB
int Tcl_ParseQuotes(Tcl_Interp* iPtr, const char* s, char** termPtr, int rightChar) {
	int retCode;
	char* p = (char*)s;
	char* delim = strdup_printf("\t\n\v\f\r $;[]%c", rightChar);	//ꕶ+I[
	char* elem = strdup("");
	for(;;) {
		/* ꕶ,,I[̎O܂ŃGXP[vAɒǉB */
		char* value = strcompress(p, &p, delim);		//IȂ΁Ap͓ꕶ,,I[,,k̈ʒuwB
		elem = strjoin(NULL, elem, value, NULL);
		if(!*p) {
			iPtr->result = strdup_printf("missing %c", rightChar);	//I[ɁȀI[ɒBꍇ̓G[
			return TCL_ERROR;
		} else if(*p == rightChar) {
			break;	//I
		} else if(*p == '$') {
			value = Tcl_ParseVar(iPtr, p+1, &p);		//IȂ΁Ap͕ϐ(͕ϐ͂'}')̎̈ʒuwB
			if(!value) { return TCL_ERROR; }
			elem = strjoin(NULL, elem, value, NULL);
			//p
		} else if(*p == '[') {
			retCode = Tcl_Eval(iPtr, p+1, &p, ']');		//IȂ΁Ap']'̈ʒuwB
			if(retCode) { return retCode; }
			elem = strjoin(NULL, elem, iPtr->result, NULL);
			p++;						//p']'̎֐i߂B
			//p
		} else {
			elem = strdup_printf("%s%c", elem, *p++);	//ꕶ̃ReLXgł͒ʏ핶B
			//p
		}
	}
	iPtr->result = elem;	//ʂi[B
	*termPtr = p;		//I[,,k̈ʒui[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//'{'̎̕A'}'܂łp[XB
int Tcl_ParseBraces(Tcl_Interp* iPtr, const char* s, char** termPtr, int termChar) {
	char* p = (char*)s;			//'{'̎̈ʒu
	/* gʂň͂܂ꂽvfłȂ΃G[B */
	char* endp = Tcl_IsBracedElement(p-1, termChar);	//IȂ΁Aendp'}'̎̈ʒuwB
	if(!endp) {
		iPtr->result = "missing close-brace";
		return TCL_ERROR;
	}
	endp--;					//endp'}'̈ʒuwB
	/* gʂ̒̕AGXP[vɎ擾B */
	iPtr->result = strndup(p, endp-p);
	*termPtr = endp;			//'}'̈ʒu
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//'$'̎̕Aϐ(͕ϐ͂'}')̎̈ʒu܂ŁB */
char* Tcl_ParseVar(Tcl_Interp* iPtr, const char* s, char** termPtr) {
	int retCode;
	char *p = (char*)s, *q;
	const char *name1, *name2 = NULL;
	if(*p == '{') {
		p++;					//p='{'̎̈ʒu
		for(q = p; *q != '}'; q++) {		//q='}'̈ʒu܂
			if(!*q) { return NULL; }
		}
		name1 = strndup(p, q-p);		//'{'̎̈ʒu'}'̑Öʒu܂ŕ
		p = q+1;				//p='}'̎̈ʒu
	} else {
		for(q = p; iscsym(*q); q++) { }		//q=ϐƂėLȕ̎̈ʒu܂
		name1 = strndup(p, q-p);		//ϐ𕡐
		p = q;					//p=ϐƂėLȕ̎̈ʒu
		if(*p == '(') {
			retCode = Tcl_ParseQuotes(iPtr, p+1, &q, ')');	//IȂ΁Ap')'̈ʒuwB
			if(retCode) { return NULL; }
			name2 = iPtr->result;		//z̗vf擾
			p = q+1;			//p=')'̎̈ʒu
		}
	}
	*termPtr = p;					//'}'̎̈ʒu,,ϐƂėLȕ̎̈ʒu,,')'̎̈ʒu
	return Tcl_GetVar2(iPtr, name1, name2);
}
/****************************************************************************
 *	
 ****************************************************************************/
static void Tcl_VarErrMsg(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* operation, const char* reason) {
	if(name2) {
		iPtr->result = strdup_printf("can't %s \"%s(%s)\": %s", operation, name1, name2, reason);
	} else {
		iPtr->result = strdup_printf("can't %s \"%s\": %s", operation, name1, reason);
	}
}
static const char noSuchVar[]     = "no such variable";
static const char noSuchElement[] = "no such element in array";
static const char needScalar[]    = "variable isn't scalar";
static const char needArray[]     = "variable isn't array";
/*--------------------------------------------------------------------------*/
static void Tcl_SplitVarName(const char* name, char** name1, char** name2) {
	char *lp, *rp;
	if((lp = strchr(name, '(')) &&			//'('LA
	   (rp = strchr(  lp, ')')) &&			//'('ȍ~')'LA
	   (!*(rp+1))) {				//')'Ō̕Ȃ΁c
		*name1 = strndup(name, lp-name);	//   ŏ̕A'('̑O̕܂
		*name2 = strndup(lp+1, rp-lp-1);	//'('̎̕A')'̑O̕܂
	} else {
		*name1 = strdup( name);
		*name2 = NULL;
	}
}
char* Tcl_GetVar(Tcl_Interp* iPtr, const char* name) {
	char *name1, *name2;
	Tcl_SplitVarName(name, &name1, &name2);
	return Tcl_GetVar2(iPtr, name1, name2);
}
char* Tcl_SetVar(Tcl_Interp* iPtr, char* name, const char* value) {
	char *name1, *name2;
	Tcl_SplitVarName(name, &name1, &name2);
	return Tcl_SetVar2(iPtr, name1, name2, value);
}
int Tcl_UnsetVar(Tcl_Interp* iPtr, char* name) {
	char *name1, *name2;
	Tcl_SplitVarName(name, &name1, &name2);
	return Tcl_UnsetVar2(iPtr, name1, name2);
}
/*--------------------------------------------------------------------------*/
char* Tcl_GetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2) {
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	/* ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? &iPtr->varFramePtr->varTable : &iPtr->globalTable;
	/* ϐ擾B */
	tPtr = Tcl_FindTableEntry(tablePtr, name1);
	if(!tPtr) {
		Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchVar);
		return NULL;
	}
	varPtr = tPtr->value;
	/* ʃvV[W̕ϐȂ΁c */
	if(varPtr->type == TCL_VAR_UPVAR) {
		tPtr = varPtr->value.upvar;
		varPtr = tPtr->value;
	}
	/* z̗vfw肳Ăc */
	if(name2) {
		/* `ς݂̔zł邱ƂmFB */
		if(varPtr->type != TCL_VAR_ARRAY) {
			Tcl_VarErrMsg(iPtr, name1, name2, "read", needArray);
			return NULL;
		}
		/* z̗vf擾B */
		tPtr = Tcl_FindTableEntry(varPtr->value.array, name2);
		if(!tPtr) {
			Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchElement);
			return NULL;
		}
		varPtr = tPtr->value;
	}
	/* `ς݂̕ϐł邱ƂmFB */
	if(varPtr->type != TCL_VAR_SCALAR) {
		Tcl_VarErrMsg(iPtr, name1, name2, "read", needScalar);
		return NULL;
	}
	/* ϐ̒lԂB */
	return varPtr->value.scalar;
}
/*--------------------------------------------------------------------------*/
char* Tcl_SetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* value) {
	int bNew;
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	/* ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? &iPtr->varFramePtr->varTable : &iPtr->globalTable;
	/* ϐe[ũGg쐬,,擾B */
	tPtr = Tcl_CreateTableEntry(tablePtr, name1, &bNew);
	/* VK̕ϐȂ΁c */
	if(bNew) {
		/* ϐ쐬B */
		varPtr = calloc(sizeof(Tcl_Var), 1);
		tPtr->value = varPtr;
	/* ̕ϐȂ΁c */
	} else {
		/* ϐ擾B */
		varPtr = tPtr->value;
		/* ʃvV[W̕ϐȂ΁c */
		if(varPtr->type == TCL_VAR_UPVAR) {
			tPtr = varPtr->value.upvar;
			/* ϐ擾B */
			varPtr = tPtr->value;
		}
	}
	/* z̗vfw肳Ăc */
	if(name2) {
		/* `̕ϐȂ΁c */
		if(!varPtr->type) {	//`ϐւupvar,,ō쐬ϐ */
			varPtr->type = TCL_VAR_ARRAY;
			varPtr->value.array = calloc(sizeof(Tcl_Table), 1);
			Tcl_InitTable(varPtr->value.array);
		/* `ς݂̕ϐȂ΁Azł邱ƂmFB */
		} else if(varPtr->type != TCL_VAR_ARRAY) {
			Tcl_VarErrMsg(iPtr, name1, name2, "set", needArray);
			return NULL;
		}
		/* z̗vf̃Gg쐬,,擾B */
		tPtr = Tcl_CreateTableEntry(varPtr->value.array, name2, &bNew);
		/* VK̗vfȂ΁c */
		if(bNew) {
			/* vf쐬B */
			varPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr->value = varPtr;
		/* ̗vfȂ΁c */
		} else {
			/* vf擾B */
			varPtr = tPtr->value;
		}
	}
	/* ϐ,,z̗vfA`,,XJł邱ƂmFB */
	if(varPtr->type && (varPtr->type != TCL_VAR_SCALAR)) {
		Tcl_VarErrMsg(iPtr, name1, name2, "set", needScalar);
		return NULL;
	}
	/* ϐ̒lݒ肷B */
	varPtr->type = TCL_VAR_SCALAR;
	return (varPtr->value.scalar = strdup(value));
}
/*--------------------------------------------------------------------------*/
int Tcl_UnsetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2) {
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	/* ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? &iPtr->varFramePtr->varTable : &iPtr->globalTable;
	/* ϐ擾B */
	tPtr = Tcl_FindTableEntry(tablePtr, name1);
	if(!tPtr) {
		Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchVar);
		return -1;
	}
	varPtr = tPtr->value;
	/* ʃvV[W̕ϐȂ΁c */
	if(varPtr->type == TCL_VAR_UPVAR) {
		tPtr = varPtr->value.upvar;
		varPtr = tPtr->value;
	}
	/* z̗vfw肳Ăc */
	if(name2) {
		/* `ς݂̔zł邱ƂmFB */
		if(varPtr->type != TCL_VAR_ARRAY) {
			Tcl_VarErrMsg(iPtr, name1, name2, "read", needArray);
			return -1;
		}
		/* z̗vf擾B */
		tPtr = Tcl_FindTableEntry(varPtr->value.array, name2);
		if(!tPtr) {
			Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchElement);
			return -1;
		}
		varPtr = tPtr->value;
	}
	/* `ς݂̕ϐ,,`ς݂̔zł邱ƂmFB */
	if(!varPtr->type) {
		Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchVar);
		return -1;
	}
	/* ϐ폜B */
	Tcl_DeleteTableEntry(tPtr);
	return 0;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_SetCmd(Tcl_Interp* iPtr) {
	const char* s;
	if(iPtr->argc == 2) {
		s = Tcl_GetVar(iPtr, iPtr->argv[1]);
		if(!s) { return TCL_ERROR; }
		iPtr->result = s;
	} else if(iPtr->argc == 3) {
		s = Tcl_SetVar(iPtr, iPtr->argv[1], iPtr->argv[2]);
		if(!s) { return TCL_ERROR; }
		iPtr->result = s;
	} else {
		iPtr->result = "syntax error";
		return TCL_ERROR;
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_UnsetCmd(Tcl_Interp* iPtr) {
	int i;
	for(i = 1; i < iPtr->argc; i++) {
		if(Tcl_UnsetVar(iPtr, iPtr->argv[i])) { return TCL_ERROR; }
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_AppendCmd(Tcl_Interp* iPtr) {
	const char* s;
	int i;
	if(iPtr->argc < 2) {
		iPtr->result = "syntax error";
		return TCL_ERROR;
	}
	s = Tcl_GetVar(iPtr, iPtr->argv[1]);
	if(!s) { s = ""; }
	for(i = 2; i < iPtr->argc; i++) {
		const char* elem = iPtr->argv[i];
		if(*iPtr->argv[0] == 'l') {	//lappend̏ꍇ
			elem = strescape(elem, " $;[]{}");		//evfGXP[vB
			if(!*elem) { elem = "\\0"; }			//󕶎̃Xgvf\邽߂ɕKvB
			s = strjoin(*s ? " " : NULL, s, elem, NULL);	//Zp[^LB
		} else {			// append̏ꍇ
			s = strjoin(           NULL, s, elem, NULL);	//Zp[^BevfGXP[vȂB
		}
	}
	s = Tcl_SetVar(iPtr, iPtr->argv[1], s);
	if(!s) { return TCL_ERROR; }
	iPtr->result = s;
	return TCL_OK;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_GetInt(Tcl_Interp* iPtr, const char* s, int* intPtr) {
	char* p = (char*)s;
	int i = strtol(p, &p, 0);		//l擾B
	while(*p && isspace(*p)) { p++; }	//ľ̋󔒂ǂݔ΂B
	if((p == s) || *p) {			//󕶎񂪎w肳ꂽ,,ľɋ󔒈ȊOL΃G[B
		iPtr->result = strdup_printf("expected integer but got \"%s\"", s);
		return TCL_ERROR;
	}
	*intPtr = i;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_GetDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr) {
	char* p = (char*)s;
	double d = strtod(p, &p);		//l擾B
	while(*p && isspace(*p)) { p++; }	//ľ̋󔒂ǂݔ΂B
	if((p == s) || *p) {			//󕶎񂪎w肳ꂽ,,ľɋ󔒈ȊOL΃G[B
		iPtr->result = strdup_printf("expected floating-point number but got \"%s\"", s);
		return TCL_ERROR;
	}
	*doublePtr = d;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_GetBoolean(Tcl_Interp* iPtr, const char* s, int* boolPtr) {
	//gďB
	char* p = strlwr(strtrim(s, 0, NULL));
	//󕶎łȂ΁c
	if(*p) {
		static const char TBL_boolStr[3][2][5/*ő咷*/+1/*nul*/]={
			{"false","true"},
			{"no"   ,"yes" },
			{"off"  ,"on"  },
		};
		int i, mask = 0;
		double d;
		//_l̖̂̂ꂩɑOv邩?
		for(i = 0; i < ARRAY_SIZE(TBL_boolStr); i++) {
			if(str_has_prefix(TBL_boolStr[i][0], p)) { mask |= (1<<0); } //Û̖ɈvƂ}[N
			if(str_has_prefix(TBL_boolStr[i][1], p)) { mask |= (1<<1); } //^̖̂ɈvƂ}[N
		}
		if(mask == (1<<0)) { *boolPtr = 0; return TCL_OK; } //Û̖݂̂ɈvAUƌ肷B"o"͗Ɉv̂ŏO邽߂̑΍łB
		if(mask == (1<<1)) { *boolPtr = 1; return TCL_OK; } //^̖݂̂̂ɈvA^ƌ肷B
		//l? (strtod()ŕϊł̂strtol()͕sv)
		d = strtod(p, &p);	//ȍ~pQƂȂ̂Ŕj󂵂đv
		if(!*p) {
			*boolPtr = !!d;
			return TCL_OK;
		}
	}
	//󕶎,,L̕@ŔłȂ΃G[B
	iPtr->result = strdup_printf("expected boolean value but got \"%s\"", s);
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
static int Tcl_InterpProc(Tcl_Interp* iPtr) {
	int retCode, argc;
	char* value;
	char** argv;
	Tcl_Proc* procPtr;
	Tcl_Arg* argPtr;
	Tcl_CallFrame frame;
	/* t[쐬AǉB */
	memset(&frame, 0, sizeof frame.varTable);
	Tcl_InitTable(&frame.varTable);
	if(iPtr->varFramePtr) { frame.level = iPtr->varFramePtr->level; }
	frame.level++;
///	frame.argc         = iPtr->argc;		//vȂ񂶂Ȃ?mFł폜悤
///	frame.argv         = iPtr->argv;		//vȂ񂶂Ȃ?mFł폜悤
	frame.callerPtr    = iPtr->framePtr;
	frame.callerVarPtr = iPtr->varFramePtr;
	iPtr->framePtr     = &frame;
	iPtr->varFramePtr  = &frame;
	//Match the actual arguments against the procedure's formal parameters to compute local variables.
	argc    = iPtr->argc - 1;	//̎c萔
	argv    = iPtr->argv + 1;
	procPtr = iPtr->data;
	for(argPtr = procPtr->argPtr; argPtr; argPtr = argPtr->nextArgPtr) {	//SẲɂāc
		/* Ō̉ŁAOargsȂ΁c */
		if(!argPtr->nextArgPtr && !strcmp(argPtr->name, "args")) {
			value = Tcl_Merge(argc, argv);		//̎cXgɂB
			Tcl_SetVar(iPtr, argPtr->name, value);	//̎cXgɂʂA[Jϐ"args"ɐݒ肷B
			argc = 0;				//̎cSďB
		} else {
			/* ̎c肪L΁c */
			if(argc) {
				         argc--;
				value = *argv++;
			/* ̎c肪AftHglL΁c */
			} else if(argPtr->defValue) {
				value = argPtr->defValue;
			} else {
				iPtr->result = strdup_printf("no value given for parameter \"%s\" to \"%s\"", argPtr->name, iPtr->argv[0]);	//s
				retCode = TCL_ERROR;
				goto L_RET;
			}
			Tcl_SetVar(iPtr, argPtr->name, value);	//,,ftHglA[Jϐɐݒ肷B
		}
	}
	if(argc) {	//΁c
		iPtr->result = strdup_printf("called \"%s\" with too many arguments", iPtr->argv[0]);	//
		retCode = TCL_ERROR;
		goto L_RET;
	}
	/* R}hsB */
	retCode = Tcl_EvalString(iPtr, procPtr->command);
	switch(retCode) {
	case TCL_RETURN:
		retCode = TCL_OK;	//vV[WreturnŔꍇAIƂB
		break;
	case TCL_BREAK:
		iPtr->result = "invoked \"break\" outside of a loop";
		retCode = TCL_ERROR;	//vV[WbreakŔꍇAG[ƂB
		break;
	case TCL_CONTINUE:
		iPtr->result = "invoked \"continue\" outside of a loop";
		retCode = TCL_ERROR;	//vV[WcontinueŔꍇAG[ƂB
		break;
	}
L_RET:
	/* t[폜B */
	iPtr->framePtr    = frame.callerPtr;
	iPtr->varFramePtr = frame.callerVarPtr;
	return retCode;
}
/*--------------------------------------------------------------------------*/
int Tcl_ProcCmd(Tcl_Interp* iPtr) {
	int i, argCount, fieldCount;
	char **argArray, **fieldValues;
	Tcl_Arg *argPtr, **lastArgPtr;
	Tcl_Proc* procPtr;
	if(iPtr->argc != 4) {
		iPtr->result = "syntax error";
		return TCL_ERROR;
	}
	/* vV[W\̂쐬B */
	procPtr = calloc(sizeof(Tcl_Proc), 1);
	procPtr->command = strdup(iPtr->argv[3]);
	lastArgPtr = &procPtr->argPtr;
	/* Xg𕪊B */
	argCount = Tcl_SplitList(iPtr->argv[2], &argArray);
	for(i = 0; i < argCount; i++) {
		/* ̉AƃftHgl(L)ɕB */
		fieldCount = Tcl_SplitList(argArray[i], &fieldValues);
		if(!fieldCount || !*fieldValues[0]) {
			iPtr->result = strdup_printf("procedure \"%s\" has argument with no name", iPtr->argv[1]);
			return TCL_ERROR;
		}
		if(fieldCount > 2) {
			iPtr->result = strdup_printf("too many fields in argument specifier \"%s\"", argArray[i]);
			return TCL_ERROR;
		}
		/* \̂쐬B */
		argPtr = calloc(sizeof(Tcl_Arg), 1);
		argPtr->name = strdup(fieldValues[0]);
		if(fieldCount == 2) { argPtr->defValue = strdup(fieldValues[1]); }
		/* \̂ǉB */
		*lastArgPtr = argPtr;
		lastArgPtr = &argPtr->nextArgPtr;
	}
	/* R}ho^B */
	Tcl_CreateCommand(iPtr, iPtr->argv[1], Tcl_InterpProc, procPtr);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_RenameCmd(Tcl_Interp* iPtr) {
	Tcl_Command* cmdPtr;
	Tcl_TableEntry *tPtr1, *tPtr2;
	if(iPtr->argc != 3) { goto syntaxError; }
	if(!*iPtr->argv[2]) {	//newName󕶎ȂoldNamẽR}h폜B
		if(Tcl_DeleteCommand(iPtr, iPtr->argv[1])) { return TCL_ERROR; }
		return TCL_OK;
	}
	tPtr1 = Tcl_FindTableEntry(&iPtr->commandTable, iPtr->argv[1]);
	tPtr2 = Tcl_FindTableEntry(&iPtr->commandTable, iPtr->argv[2]);
	if(!tPtr1 || tPtr2) {	//oldNamẽR}h݂ȂAnewNamẽR}h݂G[B
		iPtr->result = "can't rename";
		return TCL_ERROR;
	}
	//oldNamẽGg폜AnewNamẽGg쐬AoldNamẽR}hnewNameɕtւB
	cmdPtr = tPtr1->value;
	Tcl_DeleteTableEntry(tPtr1);
	tPtr2 = Tcl_CreateTableEntry(&iPtr->commandTable, iPtr->argv[2], NULL);
	tPtr2->value = cmdPtr;
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
static int Tcl_GetFrame(Tcl_Interp* iPtr, const char* s, Tcl_CallFrame** pFramePtr) {
	int i, level;
	Tcl_CallFrame* framePtr = iPtr->varFramePtr;
	if(!framePtr) {
		iPtr->result = "already at top level";				//vFgbvxłuuplevel #0vuuplevel 0v͋ׂł͂ȂH
		return -1;
	}
	//Parse string to figure out which level number to go to.
	if(*s == '#') {
		if(Tcl_GetInt(iPtr, s+1, &level)) { return -1; }
		i = 1;	//xwɈvf1gp
	} else if(isdigit(*s)) {
		if(Tcl_GetInt(iPtr, s  , &level)) { return -1; }
		level = framePtr->level - level;
		i = 1;	//xwɈvf1gp
	} else {
		level = framePtr->level - 1;
		i = 0;	//xwɈvf0gp
	}
	//Figure out which frame to use, and modify the interpreter so its variables come from that frame.
	if(level) {
		while(framePtr->level != level) {
			if(!(framePtr = framePtr->callerVarPtr)) {
				iPtr->result = strdup_printf("bad level \"%s\"", s);
				return -1;
			}
		}
	} else {
		framePtr = NULL;
	}
	*pFramePtr = framePtr;
	return i;
}
/*--------------------------------------------------------------------------*/
int Tcl_UplevelCmd(Tcl_Interp* iPtr) {
	int i, argc = iPtr->argc, retCode;
	char** argv = iPtr->argv;
	Tcl_CallFrame *framePtr, *savedVarFramePtr;
	if(argc < 2) { goto syntaxError; }
	//Find the level to use for executing the command.
	i = Tcl_GetFrame(iPtr, argv[1], &framePtr);
	if(i == -1) { return TCL_ERROR; }
	argc -= (i+1);	//xwɎgp΂B
	argv += (i+1);	//
	if(argc <= 0) { goto syntaxError; }	//R}h
	//Modify the interpreter state to execute in the given frame.
	 savedVarFramePtr = iPtr->varFramePtr;
	iPtr->varFramePtr = framePtr;
	//Execute the residual arguments as a command.
	retCode = Tcl_EvalString(iPtr, Tcl_Concat(argc, argv));	//R}hȍ~AĎsB
	//Restore the variable frame, and return.
	iPtr->varFramePtr = savedVarFramePtr;
	return retCode;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_UpvarCmd(Tcl_Interp* iPtr) {
	int i, argc = iPtr->argc;
	char** argv = iPtr->argv;
	Tcl_CallFrame* framePtr;
	Tcl_Table* upVarTablePtr;
	if(iPtr->argc < 3) { goto syntaxError; }
	//Find the table containing the variable being referenced.
	i = Tcl_GetFrame(iPtr, argv[1], &framePtr);
	if(i == -1) { return TCL_ERROR; }
	argc -= (i+1);	//xwɎgp΂B
	argv += (i+1);	//
	if((argc <= 0) || (argc & 1)) { goto syntaxError; }	//ϐ,,ϐgg݂ɂȂĂȂB
	//QƐ̕ϐe[u擾B
	upVarTablePtr = framePtr ? &framePtr->varTable : &iPtr->globalTable;
	//Iterate over all the pairs of (local variable, other variable) names.
	//For each pair, create a table entry in the upper context (if the name wasn't there already), then associate it with a new local variable.
	do {
		Tcl_TableEntry *tPtr1, *tPtr2;
		Tcl_Var *varPtr, *upVarPtr;
		int bNew;
		//QƐ̕ϐ̃Gg쐬,,擾B
		tPtr1 = Tcl_CreateTableEntry(upVarTablePtr, *(argv+0), &bNew);		//TODO:ł͎QƐ悪zvf̏ꍇɑΉłĂȂB
		if(bNew) {
			//QƐ̕ϐVKGgȂ΁Aϐ쐬B
			upVarPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr1->value = upVarPtr;
		} else {
			//QƐ̕ϐGgȂ΁Aϐ擾B
			upVarPtr = tPtr1->value;
			//QƐ̕ϐupvarȂ΁A̎QƐ̕ϐ擾B dv
			// - ̎QƐ̕ϐupvarł邱Ƃ͖Bupvarϐ̎QƐ́AKupvarȊOłB
			//   XNvgupvar𑽏dɃ`FCĂA̓sxupvarȊOw悤ɉĂ͂B(ōsĂ̂̏łB)
			//   QƐ̕ϐupvarȂ΁AC^v^̃oOłB
			//;vV[Wlev_4ɂāAuOkvƕ\B
			//proc lev_4 {x} { upvar $x y; puts $y }
			//proc lev_3 {x} { upvar $x y; lev_4 y }
			//proc lev_2 {x} { upvar $x y; lev_3 y }
			//proc lev_1 {x} { upvar $x y; lev_2 y }
			//set a Ok
			//lev_1 a
			if(upVarPtr->type == TCL_VAR_UPVAR) {	//
				tPtr1 = upVarPtr->value.upvar;	//dv
				upVarPtr = tPtr1->value;	//
			}
		}
		//[Jϐ̃Gg擾B
		tPtr2 = Tcl_CreateTableEntry(&iPtr->varFramePtr->varTable, *(argv+1), &bNew);	//(varFramePtr!=NULL)ł邱ƂTcl_GetFrame()ɂĊmFς݁B
		if(bNew) {
			//[Jϐ΁AVK쐬B
			varPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr2->value = varPtr;
			varPtr->type = TCL_VAR_UPVAR;
		} else {
			//[Jϐ̏ꍇAsetupvar̓G[łB
			//globalupvarAupvarupvar̓G[ł͂ȂB
			varPtr = tPtr2->value;
			if(varPtr->type != TCL_VAR_UPVAR) {
				iPtr->result = strdup_printf("variable \"%s\" already exists", *(argv+1));
				return TCL_ERROR;
			}
		}
		//[JϐQƐ̕ϐGgւupvarݒ,,ύXB
		varPtr->value.upvar = tPtr1;
		//̓g݂ցB
		argc -= 2;
		argv += 2;
	} while(argc);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_GlobalCmd(Tcl_Interp* iPtr) {
	int i, bNew;
	Tcl_TableEntry *tPtr1, *tPtr2;
	Tcl_Var *varPtr, *gVarPtr;
	if(iPtr->argc < 2) { goto syntaxError; }
	//uTcl 8.4.1 Manual Command Referencevp:
	//̃R}hTclvV[W̎słȂΖ܂B
	//O[oϐe[uɃO[oϐւupvarGgƏzQƂɂȂĂ܂̂ŁAL̒ʂ薳̂B
	if(!iPtr->varFramePtr) { return TCL_OK; }
	//w肳ꂽX̕ϐɂāc
	for(i = 1; i < iPtr->argc; i++) {
		//O[oϐ̃Gg擾B
		tPtr1 = Tcl_CreateTableEntry(&iPtr->globalTable, iPtr->argv[i], &bNew);
		if(bNew) {
			//O[oϐ΁AVK쐬B
			gVarPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr1->value = gVarPtr;
		} else {
			//O[oϐL΁Aϐ擾B
			gVarPtr = tPtr1->value;
		}
		//[Jϐ̃Gg擾B
		tPtr2 = Tcl_CreateTableEntry(&iPtr->varFramePtr->varTable, iPtr->argv[i], &bNew);
		if(bNew) {
			//[Jϐ΁AVK쐬B
			varPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr2->value = varPtr;
			varPtr->type = TCL_VAR_UPVAR;
		} else {
			//[Jϐ̏ꍇAsetglobal̓G[łB
			//globalglobalAupvarglobal̓G[ł͂ȂB
			varPtr = tPtr2->value;
			if(varPtr->type != TCL_VAR_UPVAR) {
				iPtr->result = strdup_printf("variable \"%s\" already exists", iPtr->argv[i]);
				return TCL_ERROR;
			}
		}
		//[JϐO[oϐGgւupvarݒ,,ύXB
		varPtr->value.upvar = tPtr1;
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_ArrayCmd(Tcl_Interp* iPtr) {
	Tcl_Table* tablePtr;
	Tcl_TableEntry *tPtr, *tPtr2;
	Tcl_Var *varPtr, *varPtr2;
	Tcl_ArraySearch* arraySearchPtr;
	Tcl_TableSearch search;
	if(iPtr->argc < 3) { goto syntaxError; }
	/* ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? &iPtr->varFramePtr->varTable : &iPtr->globalTable;
	/* Gg擾B */
	tPtr = Tcl_FindTableEntry(tablePtr, iPtr->argv[2]);
	if(!tPtr) { goto notArray; }
	varPtr = tPtr->value;
	/* ʃvV[W̕ϐȂ΁c */
	if(varPtr->type == TCL_VAR_UPVAR) {
		tPtr = varPtr->value.upvar;
		varPtr = tPtr->value;
	}
	/* `ς݂̔zł邱ƂmFB */
	if(varPtr->type != TCL_VAR_ARRAY) { goto notArray; }
	if(!strcmp(iPtr->argv[1], "size")) {
		int size;
		if(iPtr->argc != 3) { goto syntaxError; }
		/* `ς݂̔zvf𐔂B */
		size = 0;
		for(tPtr2 = Tcl_FirstTableEntry(varPtr->value.array, &search);
		    tPtr2;
		    tPtr2 = Tcl_NextTableEntry(&search)) {
			varPtr2 = tPtr2->value;
			if(!varPtr2->type) { continue; }	//`̔zvf͊܂߂ȂB
			size++;
		}
		iPtr->result = strdup_printf("%d", size);
	} else if(!strcmp(iPtr->argv[1], "names")) {
		if(iPtr->argc != 3) { goto syntaxError; }
		/* `ς݂̔zvf̗vf̃Xg擾B */
		for(tPtr2 = Tcl_FirstTableEntry(varPtr->value.array, &search);
		    tPtr2;
		    tPtr2 = Tcl_NextTableEntry(&search)) {
			varPtr2 = tPtr2->value;
			if(!varPtr2->type) { continue; }	//`̔zvf͊܂߂ȂB
			Tcl_AppendElement(iPtr, tPtr2->key);
		}
	} else if(!strcmp(iPtr->argv[1], "startsearch")) {
		if(iPtr->argc != 3) { goto syntaxError; }
		arraySearchPtr = calloc(sizeof(Tcl_ArraySearch), 1);
		tPtr2 = Tcl_CreateTableEntry(
			&iPtr->arraySearchTable,
			strdup_printf("%p", arraySearchPtr),	//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
			NULL);
		tPtr2->value = arraySearchPtr;
		arraySearchPtr->nextEntryPtr = Tcl_FirstTableEntry(varPtr->value.array, &arraySearchPtr->search);
		iPtr->result = tPtr2->key;
	} else if(!strcmp(iPtr->argv[1], "nextelement")) {
		if(iPtr->argc != 4) { goto syntaxError; }
		tPtr2 = Tcl_FindTableEntry(&iPtr->arraySearchTable, iPtr->argv[3]);
		if(!tPtr2) { return TCL_ERROR; }
		arraySearchPtr = tPtr2->value;
		if(arraySearchPtr->nextEntryPtr) {
			iPtr->result = arraySearchPtr->nextEntryPtr->key;
			arraySearchPtr->nextEntryPtr = Tcl_NextTableEntry(&arraySearchPtr->search);
		}
	} else if(!strcmp(iPtr->argv[1], "donesearch")) {
		if(iPtr->argc != 4) { goto syntaxError; }
		tPtr2 = Tcl_FindTableEntry(&iPtr->arraySearchTable, iPtr->argv[3]);
		if(!tPtr2) { return TCL_ERROR; }
		Tcl_DeleteTableEntry(tPtr2);
	} else if(!strcmp(iPtr->argv[1], "anymore")) {
		if(iPtr->argc != 4) { goto syntaxError; }
		tPtr2 = Tcl_FindTableEntry(&iPtr->arraySearchTable, iPtr->argv[3]);
		if(!tPtr2) { return TCL_ERROR; }
		arraySearchPtr = tPtr2->value;
		iPtr->result = strdup_printf("%d", !!arraySearchPtr->nextEntryPtr);
	} else {
		iPtr->result = strdup_printf("bad option: %s", iPtr->argv[0]);
		return TCL_ERROR;
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
notArray:
	iPtr->result = strdup_printf("\"%s\" isn't an array", iPtr->argv[2]);
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
//Tcl6.7̎dlł́Aê͉Ľ`łB
//Einteger?[+-]integer?
//E    end?[+-]integer?
//ł͏LɉāA[+-]integerxło邱Ƃe邱ƂɂB
//Einteger?[+-]integer[+-]integer...?
//E    end?[+-]integer[+-]integer...?
int Tcl_GetIndex(Tcl_Interp* iPtr, const char* s, int* indexPtr, int* endPtr) {
	int index = 0, bEnd = 0;
	//󔒂ǂݔ΂B
	while(isspace(*s)) { s++; }
	//󕶎Ȃ΃G[B
	if(!*s) { goto syntaxError; }
	//'end'ŊJnĂc
	if(str_has_prefix(s, "end")) {
		bEnd = 1;
		s += 3;
	}
	for(;;) {
		char* t;
		//󔒂ǂݔ΂B
		while(isspace(*s)) { s++; }
		//I[ȂΔB
		if(!*s) { break; }
		//lϊB
		index += strtol(s, &t, 0);
		//ꕶϊłȂ΃G[B
		if(s == t) { goto syntaxError; }
		//̐l(L)ցB
		s = t;
	}
	//CfNX̍v'end'̗Li[B
	*indexPtr = index;
	*endPtr = bEnd;
	return TCL_OK;
syntaxError:
	iPtr->result = strdup_printf("bad index: %s", iPtr->argv[0]);
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ListCmd(Tcl_Interp* iPtr) {
	iPtr->result = Tcl_Merge(iPtr->argc - 1, iPtr->argv + 1);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_LlengthCmd(Tcl_Interp* iPtr) {
	int argc;
	if(iPtr->argc != 2) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], NULL);
	iPtr->result = strdup_printf("%d", argc);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_LindexCmd(Tcl_Interp* iPtr) {
	int retCode, argc, index, bEnd;
	char** argv;
	if(iPtr->argc != 3) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &index, &bEnd);
	if(retCode) { return TCL_ERROR; }
	if(bEnd) { index += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	if((unsigned)index < (unsigned)argc) {	//index,,list̗vfȏłꍇA󕶎ԂB
		iPtr->result = argv[index];
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_LinsertCmd(Tcl_Interp* iPtr) {
	int retCode, argc, index, bEnd, i, j;
	char** argv;
	if(iPtr->argc < 4) { goto syntaxError; }	//}vfAŒ1ȏw肵Ȃ΂ȂȂB(Tcldl)
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &index, &bEnd);
	if(retCode) { return TCL_ERROR; }
	if(bEnd) { index += argc; }	//lindexend̓Xg̗vfQƂB
	for(i = 0; i <       argc; i++) { if(index <= i) { break; } Tcl_AppendElement(iPtr,       argv[i]); }
	for(j = 3; j < iPtr->argc; j++) {                           Tcl_AppendElement(iPtr, iPtr->argv[j]); }
	for(     ; i <       argc; i++) {                           Tcl_AppendElement(iPtr,       argv[i]); }
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_LrangeCmd(Tcl_Interp* iPtr) {
	int retCode, argc, first, last, bEnd, i;
	char** argv;
	if(iPtr->argc != 4) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &first, &bEnd);
	if(retCode) { return TCL_ERROR; }
	if(bEnd) { first += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &last, &bEnd);
	if(retCode) { return TCL_ERROR; }
	if(bEnd) { last += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	for(i = 0; i < argc; i++) {
		if((i >= first) && (i <= last)) { Tcl_AppendElement(iPtr, argv[i]); }
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_LreplaceCmd(Tcl_Interp* iPtr) {
	int retCode, argc, first, last, bEnd, i, j;
	char** argv;
	if(iPtr->argc < 4) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &first, &bEnd);
	if(retCode) { return TCL_ERROR; }
	if(bEnd) { first += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &last, &bEnd);
	if(retCode) { return TCL_ERROR; }
	if(bEnd) { last += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	if(first < 0) { first = 0; }		//first0̏ꍇAlist̍ŏ̗vfQƂ܂B
	for(i = 0; i < argc; i++) {
		if(i == first) { for(j = 4; j < iPtr->argc; j++) { Tcl_AppendElement(iPtr, iPtr->argv[j]); } }	//̏Ԃ͕K{Btɂƌ̗vf폜Ȃ̋dlƈĂ܂B
		if((i < first) || (i > last)) {                    Tcl_AppendElement(iPtr,       argv[i]); }	//<>ulreplace {A B C} 1 0 xv{A x B C}ƂȂ̂B{A B x C}͌B
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_LsearchCmd(Tcl_Interp* iPtr) {
	int argc, index = -1, i;
	char** argv;
	if(iPtr->argc != 3) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	for(i = 0; i < argc; i++) {
		if(string_match(iPtr->argv[2], argv[i])) {
			index = i;
			break;
		}
	}
	iPtr->result = strdup_printf("%d", index);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
static int Tcl_LsortCmd_compare(const void* x, const void* y) {
	return strcmp(*(char**)x, *(char**)y);
}
int Tcl_LsortCmd(Tcl_Interp* iPtr) {
	int argc;
	char** argv;
	if(iPtr->argc != 2) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	qsort(argv, argc, sizeof(char*), Tcl_LsortCmd_compare);
	iPtr->result = Tcl_Merge(argc, argv);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
static const char* Tcl_GlobCmd_pattern;
static int Tcl_GlobCmd_filter(const struct dirent* e) {
	// - ɂ́Astring matchɂ͖AglobL̃p^[Ƃāu{a,b,...}v`ĂB
	//   u{a,b,...}v̎gppx͒Ⴂ̂ŁAł͑ΉAstring matcĥ܂܎gƂɂB
	// - ɂ́Auglob *v́u.vu..vɃ}b`ȂAł̓}b`B
	//   ̈ႢɂȂ邱Ƃ͏ȂƎv̂ŁÂ܂܂ɂ邱ƂɂB
	return string_match(Tcl_GlobCmd_pattern, e->d_name);
}
int Tcl_GlobCmd(Tcl_Interp* iPtr) {
	int noComplain = 0;
	char** argv = iPtr->argv + 1;	//R}h̎̈
	//LA'-nocomplain'Ȃ΁c
	if(*argv && !strcmp(*argv, "-nocomplain")) {
		noComplain = 1;
		argv++;	//̈
	}
	//cĂԁAJԂB
	while((Tcl_GlobCmd_pattern = *argv++)) {
		int n;
		struct dirent** e;
		n = scandir(".", &e, Tcl_GlobCmd_filter, NULL);
		while(n--) { Tcl_AppendElement(iPtr, (*e++)->d_name); }
	}
	//'-nocomplain'w肳Ă炸A}b`Ȃ΁c
	if(!noComplain && !*iPtr->result) {
		iPtr->result = "no files matched glob pattern";
		return TCL_ERROR;
	}
	return TCL_OK;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_IncrCmd(Tcl_Interp* iPtr) {
	int retCode, x = 0, y = 1;
	const char* s;
	if((iPtr->argc < 2) || (iPtr->argc > 3)) { goto syntaxError; }
	s = Tcl_GetVar(iPtr, iPtr->argv[1]);
	if(s) {
		retCode = Tcl_GetInt(iPtr, s, &x);
		if(retCode) { return retCode; }
	}
	if(iPtr->argc == 3) {
		retCode = Tcl_GetInt(iPtr, iPtr->argv[2], &y);
		if(retCode) { return retCode; }
	}
	s = strdup_printf("%d", x + y);
	s = Tcl_SetVar(iPtr, iPtr->argv[1], s);
	if(!s) { return TCL_ERROR; }
	iPtr->result = s;
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ConcatCmd(Tcl_Interp* iPtr) {
	iPtr->result = Tcl_Concat(iPtr->argc - 1, iPtr->argv + 1);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_JoinCmd(Tcl_Interp* iPtr) {
	int argc;
	char** argv;
	if((iPtr->argc < 2) || (iPtr->argc > 3)) { goto syntaxError; }
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	iPtr->result = strjoinv(
		(iPtr->argc == 3) ? iPtr->argv[2] : " ",
		argv);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_SplitCmd(Tcl_Interp* iPtr) {
	const char* splitChars = "\t\n\v\f\r ";
	if((iPtr->argc < 2) || (iPtr->argc > 3)) { goto syntaxError; }
	if(iPtr->argc == 3) { splitChars = iPtr->argv[2]; }
	if(*splitChars) {
		char** argv = strsplit_set(iPtr->argv[1], splitChars, 0);
		iPtr->result = Tcl_Merge(strv_length(argv), argv);
	} else {
		//Handle the special case of splitting on every character.
		const char* s = iPtr->argv[1];
		while(*s) {
			char buf[2] = { *s++ };
			Tcl_AppendElement(iPtr, buf);
		}
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_EvalCmd(Tcl_Interp* iPtr) {
	const char* s;
	if(iPtr->argc < 2) { goto syntaxError; }
	s = Tcl_Concat(iPtr->argc - 1, iPtr->argv + 1);
	return Tcl_EvalString(iPtr, s);
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ExprCmd(Tcl_Interp* iPtr) {
	const char* s;
	if(iPtr->argc < 2) { goto syntaxError; }
	s = Tcl_Concat(iPtr->argc - 1, iPtr->argv + 1);
	return Tcl_ExprString(iPtr, s);
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ExprString(Tcl_Interp* iPtr, const char* s) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);
	if(retCode) { return retCode; }
	switch(value.type) {
	case TCL_TYPE_STRING:
		iPtr->result = value.value.stringValue;
		break;
	case TCL_TYPE_INT:
		iPtr->result = strdup_printf("%d", value.value.intValue);
		break;
	case TCL_TYPE_DOUBLE:
		iPtr->result = strdup_printf("%g", value.value.doubleValue);
		break;
	default:
		DIE();
	}
	return retCode;
}
/*--------------------------------------------------------------------------*/
//݂̏ǂgpĂȂ̂ŖBKvɂȂLɂB
#if 0
int Tcl_ExprInt(Tcl_Interp* iPtr, const char* s, int* intPtr) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);
	if(retCode) { return retCode; }
	switch(value.type) {
	case TCL_TYPE_STRING:
		iPtr->result = "expression didn't have numeric value";
		break;
	case TCL_TYPE_INT:
		*intPtr = value.value.intValue;
		break;
	case TCL_TYPE_DOUBLE:
		*intPtr = value.value.doubleValue;
		break;
	default:
		DIE();
	}
	return retCode;
}
#endif
/*--------------------------------------------------------------------------*/
//݂̏ǂgpĂȂ̂ŖBKvɂȂLɂB
#if 0
int Tcl_ExprDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);
	if(retCode) { return retCode; }
	switch(value.type) {
	case TCL_TYPE_STRING:
		iPtr->result = "expression didn't have numeric value";
		break;
	case TCL_TYPE_INT:
		*doublePtr = value.value.intValue;
		break;
	case TCL_TYPE_DOUBLE:
		*doublePtr = value.value.doubleValue;
		break;
	default:
		DIE();
	}
	return retCode;
}
#endif
/*--------------------------------------------------------------------------*/
int Tcl_ExprBoolean(Tcl_Interp* iPtr, const char* s, int* booleanPtr) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);
	if(retCode) { return retCode; }
	switch(value.type) {
	case TCL_TYPE_STRING:
		iPtr->result = "expression didn't have numeric value";
		break;
	case TCL_TYPE_INT:
		*booleanPtr = !!value.value.intValue;
		break;
	case TCL_TYPE_DOUBLE:
		*booleanPtr = !!value.value.doubleValue;
		break;
	default:
		DIE();
	}
	return retCode;
}
/*--------------------------------------------------------------------------*/
int Tcl_ExprTopLevel(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr) {
	int retCode;
	Tcl_ExprInfo info;
	info.expr = s;
	retCode = Tcl_ExprGetValue(iPtr, &info, -1, valuePtr);
	if(retCode) { return retCode; }
	if(info.token != TCL_TOKEN_END) {
		iPtr->result = strdup_printf("syntax error in expression \"%s\"", s);
		return TCL_ERROR;
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
int Tcl_ExprGetValue(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, int prec, Tcl_Value* valuePtr) {
	static const char TBL_TokenPrec[/*(TCL_TOKEN_*)*/]={
		0,0,0,0,			//VALUE,OPEN_PAREN,CLOSE_PAREN,END
		11,11,11,			//MULT,DIVIDE,MOD
		10,10,				//PLUS,MINUS
		9,9,				//LEFT_SHIFT,RIGHT_SHIFT
		8,8,8,8,			//LESS,GREATER,LEQ,GEQ
		7,7,				//EQUAL,NEQ
		6,				//BIT_AND
		5,				//BIT_XOR
		4,				//BIT_OR
		3,				//AND
		2,				//OR
		1,1,				//QUESTY,COLON
		12,12,12,			//UNARY_MINUS,NOT,BIT_NOT
	};
	int retCode;
	int gotOp = 0;		//Non-zero means already lexed the operator (while picking up value for unary operator). Don't lex again.
	int operator;		//Current operator (either unary or binary).
	Tcl_Value value2;	//Second operand for current operator.
	Tcl_Value dummy;	//Zq҂ꍇ,y,lǂݔ΂ꍇ̃_~[ϐ
	//There are two phases to this procedure.
	//First, pick off an initial value.
	//Then, parse (binary operator, value) pairs until done.
	retCode = Tcl_ExprLex(iPtr, infoPtr, valuePtr);
	if(retCode) { return retCode; }
	if(infoPtr->token == TCL_TOKEN_OPEN_PAREN) {
		//Parenthesized sub-expression.
		retCode = Tcl_ExprGetValue(iPtr, infoPtr, -1, valuePtr);
		if(retCode) { return retCode; }
		if(infoPtr->token != TCL_TOKEN_CLOSE_PAREN) {
			iPtr->result = "unmatched parentheses in expression";
			return TCL_ERROR;
		}
	} else {
		if(infoPtr->token == TCL_TOKEN_MINUS) { infoPtr->token = TCL_TOKEN_UNARY_MINUS; }
		//PZqȂ΁c
		if(infoPtr->token >= TCL_TOKEN_UNARY_MINUS) {	//TCL_TOKEN_UNARY_MINUS or TCL_TOKEN_NOT or TCL_TOKEN_BIT_NOT
			//Process unary operators.
			operator = infoPtr->token;
			retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);	//operatorD揇ʂ͈̍͂]
			if(retCode) { return retCode; }
			switch(operator) {
			case TCL_TOKEN_UNARY_MINUS:
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = -valuePtr->value.intValue;
				} else if(valuePtr->type == TCL_TYPE_DOUBLE){
					valuePtr->value.doubleValue = -valuePtr->value.doubleValue;
				} else {
					goto illegalType;
				}
				break;
			case TCL_TOKEN_NOT:
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = !valuePtr->value.intValue;
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = !valuePtr->value.doubleValue;
					valuePtr->type = TCL_TYPE_INT;
				} else {
					goto illegalType;
				}
				break;
			case TCL_TOKEN_BIT_NOT:
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = ~valuePtr->value.intValue;
				} else {
					goto illegalType;
				}
				break;
			default:
				DIE();
			}
			gotOp = 1;
		} else if(infoPtr->token != TCL_TOKEN_VALUE) {	//'('łPZqłȂΕKlƂĎ擾悤BPƂ̒l,,񍀉Zq̍ӂƎvA܂ڂłĂȂBvmFB
			goto syntaxError;
		}
	}
	//Got the first operand. Now fetch (operator,operand) pairs.
	if(!gotOp) {
		retCode = Tcl_ExprLex(iPtr, infoPtr, &dummy);	//infoPtr->tokenɓ񍀉Zq擾̂ړIłAl͕svȂ̂dummyw肷Bl擾ꍇ͈ȉ̏ŃG[ƂȂB
		if(retCode) { return retCode; }
	}
	for(;;) {
		operator = infoPtr->token;
		//񍀉ZqłȂ΁c
		if((operator < TCL_TOKEN_MULT) || (operator > TCL_TOKEN_COLON)) {
			if((operator == TCL_TOKEN_END) ||(operator == TCL_TOKEN_CLOSE_PAREN)) {
				retCode = TCL_OK;
				return retCode;
			} else {
				goto syntaxError;
			}
		}
		//ĂяỏZqD揇ʂႢȂ΁c(E͍lȂ̂?)
		if(TBL_TokenPrec[operator] <= prec) {
			retCode = TCL_OK;
			return retCode;
		}
		//If we're doing an AND or OR and the first operand already determines the result, don't execute anything in the second operand: just parse.
		//Same style for ?: pairs.
		if((operator == TCL_TOKEN_AND) || (operator == TCL_TOKEN_OR) || (operator == TCL_TOKEN_QUESTY)) {
			if(valuePtr->type == TCL_TYPE_INT) {
				/** no job **/
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = !!valuePtr->value.doubleValue;
				valuePtr->type = TCL_TYPE_INT;
			} else {
				goto illegalType;
			}
			if(((operator == TCL_TOKEN_AND) && !valuePtr->value.intValue) ||	//(&&)̍ӂUȂΉEӂ]Ȃ
			   ((operator == TCL_TOKEN_OR ) &&  valuePtr->value.intValue)) {	//(||)̍ӂ^ȂΉEӂ]Ȃ
				iPtr->noEval++;
				retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &dummy);	//Eӂǂݔ΂
				iPtr->noEval--;
				if(retCode) { return retCode; }
			} else if(operator == TCL_TOKEN_QUESTY) {										//@͑vHuset x 1;expr {$x==1?"one":$x==2?"two":"three"}v͊Ғʂ"one"ɂȂ邩HvmFB
				if(valuePtr->value.intValue) {	//(?:)̑^ȂΑ]O]Ȃ
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);
					if(retCode) { return retCode; }
					if(infoPtr->token != TCL_TOKEN_COLON) { goto syntaxError; }
					iPtr->noEval++;
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &dummy);	//Oǂݔ΂
					iPtr->noEval--;
					if(retCode) { return retCode; }
				} else {			//(?:)̑UȂΑ]O]
					iPtr->noEval++;
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &dummy);	//ǂݔ΂
					iPtr->noEval--;
					if(retCode) { return retCode; }
					if(infoPtr->token != TCL_TOKEN_COLON) { goto syntaxError; }
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);
					if(retCode) { return retCode; }
				}
			} else {
				//Eӂ擾B
				retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &value2);
				if(retCode) { return retCode; }
			}
		} else {
			//Eӂ擾B
			retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &value2);
			if(retCode) { return retCode; }
		}
		//(OPEN_PAREN or UNKNOWN)Ƃ?
		if((infoPtr->token <  TCL_TOKEN_MULT) &&
		   (infoPtr->token != TCL_TOKEN_VALUE) &&
		   (infoPtr->token != TCL_TOKEN_END) &&
		   (infoPtr->token != TCL_TOKEN_CLOSE_PAREN)) { goto syntaxError; }
		//At this point we've got two values and an operator.
		//Check to make sure that the particular data types are appropriate for the particular operator, and perform type conversion if necessary.
		switch(operator) {
		//For the operators below, no strings are allowed and ints get converted to floats if necessary.
		case TCL_TOKEN_MULT:
		case TCL_TOKEN_DIVIDE:
		case TCL_TOKEN_PLUS:
		case TCL_TOKEN_MINUS:
			if((valuePtr->type == TCL_TYPE_STRING) || (value2.type == TCL_TYPE_STRING)) { goto illegalType; }
			if(valuePtr->type == TCL_TYPE_DOUBLE) {
				if(value2.type == TCL_TYPE_INT) {
					value2.value.doubleValue = value2.value.intValue;
					value2.type = TCL_TYPE_DOUBLE;
				}
			} else if(value2.type == TCL_TYPE_DOUBLE) {
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.doubleValue = valuePtr->value.intValue;
					valuePtr->type = TCL_TYPE_DOUBLE;
				}
			}
			break;
		//For the operators below, only integers are allowed.
		case TCL_TOKEN_MOD:
		case TCL_TOKEN_LEFT_SHIFT:
		case TCL_TOKEN_RIGHT_SHIFT:
		case TCL_TOKEN_BIT_AND:
		case TCL_TOKEN_BIT_XOR:
		case TCL_TOKEN_BIT_OR:
			if((valuePtr->type != TCL_TYPE_INT) || (value2.type != TCL_TYPE_INT)) { goto illegalType; }
			break;
		//For the operators below, any type is allowed but the two operands must have the same type.
		//Convert integers to floats and either to strings, if necessary.
		case TCL_TOKEN_LESS:
		case TCL_TOKEN_GREATER:
		case TCL_TOKEN_LEQ:
		case TCL_TOKEN_GEQ:
		case TCL_TOKEN_EQUAL:
		case TCL_TOKEN_NEQ:
			if(valuePtr->type == TCL_TYPE_STRING) {
				if(value2.type != TCL_TYPE_STRING) {
					Tcl_ExprMakeString(&value2);
				}
			} else if(value2.type == TCL_TYPE_STRING) {
				if(valuePtr->type != TCL_TYPE_STRING) {
					Tcl_ExprMakeString(valuePtr);
				}
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				if(value2.type == TCL_TYPE_INT) {
					value2.value.doubleValue = value2.value.intValue;
					value2.type = TCL_TYPE_DOUBLE;
				}
			} else if(value2.type == TCL_TYPE_DOUBLE) {
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.doubleValue = valuePtr->value.intValue;
					valuePtr->type = TCL_TYPE_DOUBLE;
				}
			}
			break;
		//For the operators below, no strings are allowed, but no int->double conversions are performed.
		case TCL_TOKEN_AND:
		case TCL_TOKEN_OR:
			if((valuePtr->type == TCL_TYPE_STRING) || (value2.type == TCL_TYPE_STRING)) { goto illegalType; }
			break;
		//For the operators below, type and conversions are irrelevant: they're handled elsewhere.
		case TCL_TOKEN_QUESTY:
		case TCL_TOKEN_COLON:
			break;
		//Any other operator is an error.
		default:
			iPtr->result = "unknown operator in expression";	//N蓾̂?LcaseSĖԗĂȂ炱֓Bꍇ̓vOoOł͂Ȃ?
			return TCL_ERROR;
		}
		//If necessary, convert one of the operands to the type of the other.
		//If the operands are incompatible with the operator (e.g. "+" on strings) then return an error.
		switch(operator) {
		case TCL_TOKEN_MULT:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue *= value2.value.intValue;
			} else {
				valuePtr->value.doubleValue *= value2.value.doubleValue;
			}
			break;
		case TCL_TOKEN_DIVIDE:
			if(valuePtr->type == TCL_TYPE_INT) {
				if(!value2.value.intValue) {
					iPtr->result = "divide by zero";
					return TCL_ERROR;
				}
				valuePtr->value.intValue /= value2.value.intValue;
			} else {
				if(!value2.value.doubleValue) {
					iPtr->result = "divide by zero";
					return TCL_ERROR;
				}
				valuePtr->value.doubleValue /= value2.value.doubleValue;
			}
			break;
		case TCL_TOKEN_MOD:
			if(!value2.value.intValue) {
				iPtr->result = "divide by zero";
				return TCL_ERROR;
			}
			valuePtr->value.intValue %= value2.value.intValue;
			break;
		case TCL_TOKEN_PLUS:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue += value2.value.intValue;
			} else {
				valuePtr->value.doubleValue += value2.value.doubleValue;
			}
			break;
		case TCL_TOKEN_MINUS:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue -= value2.value.intValue;
			} else {
				valuePtr->value.doubleValue -= value2.value.doubleValue;
			}
			break;
		case TCL_TOKEN_LEFT_SHIFT:
			valuePtr->value.intValue <<= value2.value.intValue;
			break;
		case TCL_TOKEN_RIGHT_SHIFT:
			valuePtr->value.intValue >>= value2.value.intValue;
			break;
		case TCL_TOKEN_LESS:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue = (valuePtr->value.intValue < value2.value.intValue);
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = (valuePtr->value.doubleValue < value2.value.doubleValue);
			} else {
				valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) < 0);
			}
			valuePtr->type = TCL_TYPE_INT;
			break;
		case TCL_TOKEN_GREATER:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue = (valuePtr->value.intValue > value2.value.intValue);
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = (valuePtr->value.doubleValue > value2.value.doubleValue);
			} else {
				valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) > 0);
			}
			valuePtr->type = TCL_TYPE_INT;
			break;
		case TCL_TOKEN_LEQ:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue = (valuePtr->value.intValue <= value2.value.intValue);
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = (valuePtr->value.doubleValue <= value2.value.doubleValue);
			} else {
				valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) <= 0);
			}
			valuePtr->type = TCL_TYPE_INT;
			break;
		case TCL_TOKEN_GEQ:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue = (valuePtr->value.intValue >= value2.value.intValue);
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = (valuePtr->value.doubleValue >= value2.value.doubleValue);
			} else {
				valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) >= 0);
			}
			valuePtr->type = TCL_TYPE_INT;
			break;
		case TCL_TOKEN_EQUAL:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue = (valuePtr->value.intValue == value2.value.intValue);
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = (valuePtr->value.doubleValue == value2.value.doubleValue);
			} else {
				valuePtr->value.intValue = !strcmp(valuePtr->value.stringValue, value2.value.stringValue);
			}
			valuePtr->type = TCL_TYPE_INT;
			break;
		case TCL_TOKEN_NEQ:
			if(valuePtr->type == TCL_TYPE_INT) {
				valuePtr->value.intValue = (valuePtr->value.intValue != value2.value.intValue);
			} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
				valuePtr->value.intValue = (valuePtr->value.doubleValue != value2.value.doubleValue);
			} else {
				valuePtr->value.intValue = !!strcmp(valuePtr->value.stringValue, value2.value.stringValue);
			}
			valuePtr->type = TCL_TYPE_INT;
			break;
		case TCL_TOKEN_BIT_AND:
			valuePtr->value.intValue &= value2.value.intValue;
			break;
		case TCL_TOKEN_BIT_XOR:
			valuePtr->value.intValue ^= value2.value.intValue;
			break;
		case TCL_TOKEN_BIT_OR:
			valuePtr->value.intValue |= value2.value.intValue;
			break;
		//For AND and OR, we know that the first value has already been converted to an integer.
		//Thus we need only consider the possibility of int vs. double for the second value.
		case TCL_TOKEN_AND:
			if(value2.type == TCL_TYPE_DOUBLE) {
				value2.value.intValue = !!value2.value.doubleValue;
				value2.type = TCL_TYPE_INT;
			}
			valuePtr->value.intValue = valuePtr->value.intValue && value2.value.intValue;
			break;
		case TCL_TOKEN_OR:
			if(value2.type == TCL_TYPE_DOUBLE) {
				value2.value.intValue = !!value2.value.doubleValue;
				value2.type = TCL_TYPE_INT;
			}
			valuePtr->value.intValue = valuePtr->value.intValue || value2.value.intValue;
			break;
		case TCL_TOKEN_COLON:
			iPtr->result = "can't have : operator without ? first";
			return TCL_ERROR;
		}
	}
	return retCode;
illegalType:
	iPtr->result = "illegal operand type";
	return TCL_ERROR;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ExprLex(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, Tcl_Value* valuePtr) {
	int retCode, c;
	const char *p, *var;
	//s󔒂ǂݔ΂B
	p = infoPtr->expr;
	while(isspace(c = *p++)) { /** no job **/ }
	infoPtr->expr = p;	//c̎̈ʒu
	p--;			//c̈ʒu
	//l?
	if(isdigit(c) || (c == '.')) {	//֐ł'-'ZqƉ߂Bl̈ꕔƂ͌ȂȂB
		//Number.
		//First read an integer.
		//Then if it looks like there's a floating-point number (or if it's too big a number to fit in an integer), parse it as a floating-point number.
		char *endp1, *endp2;
		int i = strtol(p, &endp1, 0);
		int d = strtod(p, &endp2);
		if((endp1 == p) && (endp2 == p)) { return TCL_ERROR; }	//ƂĂƂĂ߂łȂB(N蓾Ȃ͂)
		//Œvŉ߂Bŉ߂łꍇ͐ƌȂB
		if(endp1 >= endp2) {
			valuePtr->type = TCL_TYPE_INT;
			valuePtr->value.intValue = i;
			infoPtr->expr = endp1;
		} else {
			valuePtr->type = TCL_TYPE_DOUBLE;
			valuePtr->value.doubleValue = d;
			infoPtr->expr = endp2;
		}
		infoPtr->token = TCL_TOKEN_VALUE;
		return TCL_OK;
	}
	//Zq?
	switch(c) {
	case '$':
		//Variable.
		//Fetch its value, then see if it makes sense as an integer or floating-point number.
		infoPtr->token = TCL_TOKEN_VALUE;
		var = Tcl_ParseVar(iPtr, infoPtr->expr, (char**)&infoPtr->expr);
		if(!var) { return TCL_ERROR; }
		if(!iPtr->noEval) {
			retCode = Tcl_ExprParseString(iPtr, var, valuePtr);
			if(retCode) { return retCode; }
		}
		return TCL_OK;
	case '[':
		infoPtr->token = TCL_TOKEN_VALUE;
		retCode = Tcl_Eval(iPtr, infoPtr->expr, (char**)&infoPtr->expr, ']');
		if(retCode) { return retCode; }
		infoPtr->expr++;	//']'̎̈ʒu
		if(!iPtr->noEval) {
			retCode = Tcl_ExprParseString(iPtr, iPtr->result, valuePtr);
			if(retCode) { return retCode; }
		}
		iPtr->result = "";	//mTcl_Eval()i[ʂ̂ĂKv͗L̂A֐̌Ăяoŏ㏑邩炱ŃNAȂĂǂ̂ł?
		return TCL_OK;
	case '"':
		infoPtr->token = TCL_TOKEN_VALUE;
		retCode = Tcl_ParseQuotes(iPtr, infoPtr->expr, (char**)&infoPtr->expr, '"');
		if(retCode) { return retCode; }
		infoPtr->expr++;	//'"'̎̈ʒu
		return Tcl_ExprParseString(iPtr, iPtr->result, valuePtr);
	case '{':
		infoPtr->token = TCL_TOKEN_VALUE;
		retCode = Tcl_ParseBraces(iPtr, infoPtr->expr, (char**)&infoPtr->expr, 0);	//ł́uexpr {{1}+1}vɑΉłĂȂ̂ł͂ȂHvB
		if(retCode) { return retCode; }
		infoPtr->expr++;	//'}'̎̈ʒu
		return Tcl_ExprParseString(iPtr, iPtr->result, valuePtr);
	case '(':
		infoPtr->token = TCL_TOKEN_OPEN_PAREN;
		return TCL_OK;
	case ')':
		infoPtr->token = TCL_TOKEN_CLOSE_PAREN;
		return TCL_OK;
	case '*':
		infoPtr->token = TCL_TOKEN_MULT;
		return TCL_OK;
	case '/':
		infoPtr->token = TCL_TOKEN_DIVIDE;
		return TCL_OK;
	case '%':
		infoPtr->token = TCL_TOKEN_MOD;
		return TCL_OK;
	case '+':
		infoPtr->token = TCL_TOKEN_PLUS;
		return TCL_OK;
	case '-':
		infoPtr->token = TCL_TOKEN_MINUS;
		return TCL_OK;
	case '?':
		infoPtr->token = TCL_TOKEN_QUESTY;
		return TCL_OK;
	case ':':
		infoPtr->token = TCL_TOKEN_COLON;
		return TCL_OK;
	case '<':
		switch(*infoPtr->expr) {
		case '<':
			infoPtr->token = TCL_TOKEN_LEFT_SHIFT;
			infoPtr->expr++;
			break;
		case '=':
			infoPtr->token = TCL_TOKEN_LEQ;
			infoPtr->expr++;
			break;
		default:
			infoPtr->token = TCL_TOKEN_LESS;
			break;
		}
		return TCL_OK;
	case '>':
		switch(*infoPtr->expr) {
		case '>':
			infoPtr->token = TCL_TOKEN_RIGHT_SHIFT;
			infoPtr->expr++;
			break;
		case '=':
			infoPtr->token = TCL_TOKEN_GEQ;
			infoPtr->expr++;
			break;
		default:
			infoPtr->token = TCL_TOKEN_GREATER;
			break;
		}
		return TCL_OK;
	case '=':
		if(*infoPtr->expr == '=') {
			infoPtr->token = TCL_TOKEN_EQUAL;
			infoPtr->expr++;
		} else {
			return TCL_ERROR;
		}
		return TCL_OK;
	case '!':
		if(*infoPtr->expr == '=') {
			infoPtr->token = TCL_TOKEN_NEQ;
			infoPtr->expr++;
		} else {
			infoPtr->token = TCL_TOKEN_NOT;
		}
		return TCL_OK;
	case '&':
		if(*infoPtr->expr == '&') {
			infoPtr->token = TCL_TOKEN_AND;
			infoPtr->expr++;
		} else {
			infoPtr->token = TCL_TOKEN_BIT_AND;
		}
		return TCL_OK;
	case '^':
		infoPtr->token = TCL_TOKEN_BIT_XOR;
		return TCL_OK;
	case '|':
		if(*infoPtr->expr == '|') {
			infoPtr->token = TCL_TOKEN_OR;
		} else {
			infoPtr->token = TCL_TOKEN_BIT_OR;
		}
		return TCL_OK;
	case '~':
		infoPtr->token = TCL_TOKEN_BIT_NOT;
		return TCL_OK;
	case '\0':
		infoPtr->token = TCL_TOKEN_END;
		infoPtr->expr--;	//'\0'̈ʒu
		return TCL_OK;
	default:
		return TCL_ERROR;
	}
}
/*--------------------------------------------------------------------------*/
int Tcl_ExprParseString(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr) {
	//󕶎łȂ΁c
	if(*s) {
		char* endp;
		//ƂĕI[܂ŉ߂ł΁AƌȂB
		valuePtr->type = TCL_TYPE_INT;
		valuePtr->value.intValue = strtol(s, &endp, 0);
		while(isspace(*endp)) { endp++; }
		if(!*endp) { return TCL_OK; }
		//ƂĕI[܂ŉ߂ł΁AƌȂB
		valuePtr->type = TCL_TYPE_DOUBLE;
		valuePtr->value.doubleValue = strtod(s, &endp);
		while(isspace(*endp)) { endp++; }
		if(!*endp) { return TCL_OK; }
	}
	//,,Ƃĉ߂łȂ΁AƌȂB
	valuePtr->type = TCL_TYPE_STRING;
	valuePtr->value.stringValue = s;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
void Tcl_ExprMakeString(Tcl_Value* valuePtr) {
	if(valuePtr->type == TCL_TYPE_INT) {
		valuePtr->value.stringValue = strdup_printf("%d", valuePtr->value.intValue);
	} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
		valuePtr->value.stringValue = strdup_printf("%g", valuePtr->value.doubleValue);
	}
	valuePtr->type = TCL_TYPE_STRING;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_BreakCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { goto syntaxError; }
	return TCL_BREAK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ContinueCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { goto syntaxError; }
	return TCL_CONTINUE;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_IfCmd(Tcl_Interp* iPtr) {
	int retCode, cond, i = 1;
	//Tclif́AŌɎsR}ȟʂԂBifƁAwhileyfoŕA߂l̎dl̈ႢɒӂB
	for(;;) {
		//At this point in the loop, argv and argc refer to an expression to test, either for the main expression or an expression following an "elseif".
		//The arguments after the expression must be "then"(optional) and a script to execute if the expression is true.
		if(i >= iPtr->argc) { goto syntaxError; }
		retCode = Tcl_ExprBoolean(iPtr, iPtr->argv[i], &cond);
		if(retCode) { return retCode; }
		i++;
		if((i < iPtr->argc) && !strcmp(iPtr->argv[i], "then")) { i++; }
		if(i >= iPtr->argc) { goto syntaxError; }
		if(cond) { return Tcl_EvalString(iPtr, iPtr->argv[i]); }
		//The expression evaluated to false.
		//Skip the command, then see if there is an "else" or "elseif" clause.
		i++;
		if(i >= iPtr->argc) { return TCL_OK; }	//'elseif'߂'else'߂
		//if expr1 ?then? body1 elseif expr2 ?then? body2 elseif ... ?else? ?bodyN?
		//                                                           ~~~~~~elseȗ\ł邱Ƃɒӂ<>if {0} {} else {puts ok}Ƣif {0} {} {puts ok}͓
		if(!strcmp(iPtr->argv[i], "elseif")) { i++; continue; }	//'elseif'ߗLB'elseif'߂bodyȂꍇ͎̃[v̐擪ŃG[oB
		if(!strcmp(iPtr->argv[i], "else")) { i++; }		//'else'𖾎'else'ߗLB'else'߂bodyȂꍇ̓[v𔲂ɃG[oB
		break;							//i='else'𖾎'else'߂bodyÁA'else'ȗ'else'߂bodywĂ͂B[v𔲂B
	}
	if(i != (iPtr->argc - 1)) { goto syntaxError; }			//'else'߂bodyȂÁA'else'߂body̌ɗ]ȈLB
	return Tcl_EvalString(iPtr, iPtr->argv[i]);
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_WhileCmd(Tcl_Interp* iPtr) {
	int retCode, cond;
	if(iPtr->argc != 3) { goto syntaxError; }
	for(;;) {
		retCode = Tcl_ExprBoolean(iPtr, iPtr->argv[1], &cond);
		if(retCode) { return retCode; }
		if(!cond) { break; }
		retCode = Tcl_EvalString(iPtr, iPtr->argv[2]);
		if(retCode == TCL_BREAK) { break; }
		if(retCode == TCL_CONTINUE) { retCode = TCL_OK; }
		if(retCode) { return retCode; }
	}
	iPtr->result = "";	//Tclwhile,for,foreach́A󕶎ԂdlłBŌɎsR}ȟʂԂ̂ł͂ȂBifƁAwhile,for,foreach́A߂l̎dl̈ႢɒӂB
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_ForCmd(Tcl_Interp* iPtr) {
	int retCode, cond;
	if(iPtr->argc != 5) { goto syntaxError; }
	//start
	retCode = Tcl_EvalString(iPtr, iPtr->argv[1]);
	if(retCode) { return retCode; }
	for(;;) {
		//test
		retCode = Tcl_ExprBoolean(iPtr, iPtr->argv[2], &cond);
		if(retCode) { return retCode; }
		if(!cond) { break; }
		//body
		retCode = Tcl_EvalString(iPtr, iPtr->argv[4]);
		if(retCode == TCL_BREAK) { break; }
		if(retCode == TCL_CONTINUE) { retCode = TCL_OK; }
		if(retCode) { return retCode; }
		//next
		retCode = Tcl_EvalString(iPtr, iPtr->argv[3]);
		if(retCode == TCL_BREAK) { break; }	//TclfoŕAufor {@} {A} {B} {C}vɂāACłȂBłbreakĂBCforƈႤ̂ŒӂB
		if(retCode) { return retCode; }
	}
	iPtr->result = "";	//Tclwhile,for,foreach́A󕶎ԂdlłBŌɎsR}ȟʂԂ̂ł͂ȂBifƁAwhile,for,foreach́A߂l̎dl̈ႢɒӂB
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
//݂̎ł́uforeach varname list bodyv`ɑΉB
//uforeach varlist1 list1 ?varlist2 list2 c? bodyv`ɂ͖ΉB
int Tcl_ForeachCmd(Tcl_Interp* iPtr) {
	int retCode;
	char **argv, *elem;
	if(iPtr->argc != 4) { goto syntaxError; }
	Tcl_SplitList(iPtr->argv[2], &argv);
	while((elem = *argv++)) {
		if(!Tcl_SetVar(iPtr, iPtr->argv[1], elem)) { return TCL_ERROR; }
		retCode = Tcl_EvalString(iPtr, iPtr->argv[3]);
		if(retCode == TCL_BREAK) { break; }
		if(retCode == TCL_CONTINUE) { retCode = TCL_OK; }
		if(retCode) { return retCode; }
	}
	iPtr->result = "";	//Tclwhile,for,foreach́A󕶎ԂdlłBŌɎsR}ȟʂԂ̂ł͂ȂBifƁAwhile,for,foreach́A߂l̎dl̈ႢɒӂB
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
//uswitch ?options? string pattern body ?pattern body c?v
int Tcl_SwitchCmd(Tcl_Interp* iPtr) {
	int retCode;
	int mode = 0;	//0=exact,1=globBregexp͖ΉB
	int cond = 0;	//}b`1ɂȂAȍ~̍ŏɌ'-'ȊObodysB
	char **argv, *str, *pat, *body;
	for(argv = iPtr->argv + 1;	//R}h̎̈
	    *argv && (**argv == '-');	//܂LAIvVwȂ
	    argv++) {			//ȉāÄ֐i߂
		if(!strcmp(*argv, "-exact")) { mode = 0; continue; }
		if(!strcmp(*argv, "-glob" )) { mode = 1; continue; }
		if(!strcmp(*argv, "--"    )) {              break; }
		iPtr->result = "bad option";
		return TCL_ERROR;
	}
	//string擾A֐i߂B
	if(!(str = *argv++)) { goto syntaxError; }
	//uswitch ?options? string {pattern body ?pattern body c?}v`Ȃ΁A
	//uswitch ?options? string pattern body ?pattern body c?v`ɕϊB
	if(!*argv) { goto syntaxError; }
	if(!*(argv+1)) { Tcl_SplitList(*argv, &argv); }
	//patternbody̑gݍ킹ƂɌJԂB
	while((pat = *argv++)) {
		if(!(body = *argv++)) { goto syntaxError; }
		if(!cond) {
			if(!*argv && !strcmp(pat, "default")) {	//Ōpattern'default'̏ꍇ̂defaultƂĈBŌpatternłȂ'default'ƂełB
				cond = 1;
			} else {
				if(!mode) {	//exact
					cond = !strcmp(pat, str);
				} else {	//glob
					cond = string_match(pat, str);
				}
			}
		}
		if(cond && strcmp(body, "-")) {
			retCode = Tcl_EvalString(iPtr, body);
			if(retCode) { return retCode; }
			break;
		}
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
int Tcl_StringCmd(Tcl_Interp* iPtr) {
	char* p;
	int retCode, i, len, index, first, last, bEnd;
	if(iPtr->argc < 2) { goto syntaxError; }
	if(!strcmp(iPtr->argv[1], "length")) {
		if(iPtr->argc != 3) { goto syntaxError; }
		len = strlen(iPtr->argv[2]);
		iPtr->result = strdup_printf("%d", len);
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "index")) {	//startIndex͖Ή
		if(iPtr->argc != 4) { goto syntaxError; }
		len = strlen(iPtr->argv[2]);
		retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &index, &bEnd);
		if(retCode) { return TCL_ERROR; }
		if(bEnd) { index += (len - 1); }	//lindexend͕̍Ō̕QƂB
		if((unsigned)index < (unsigned)len) {
			iPtr->result = strdup_printf("%c", iPtr->argv[2][index]);
		}
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "trim")) {
		if((iPtr->argc < 3) || (iPtr->argc > 4)) { goto syntaxError; }
		iPtr->result = strtrim(iPtr->argv[2], 0, iPtr->argv[3]);	//(iPtr->argc=3)Ȃ(iPtr->argv[3]=NULL)Ȃ̂strtrim()ɂ󔒕̎wƂĈB
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "trimleft")) {
		if((iPtr->argc < 3) || (iPtr->argc > 4)) { goto syntaxError; }
		iPtr->result = strtrim(iPtr->argv[2], 1, iPtr->argv[3]);	//(iPtr->argc=3)Ȃ(iPtr->argv[3]=NULL)Ȃ̂strtrim()ɂ󔒕̎wƂĈB
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "trimright")) {
		if((iPtr->argc < 3) || (iPtr->argc > 4)) { goto syntaxError; }
		iPtr->result = strtrim(iPtr->argv[2], 2, iPtr->argv[3]);	//(iPtr->argc=3)Ȃ(iPtr->argv[3]=NULL)Ȃ̂strtrim()ɂ󔒕̎wƂĈB
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "tolower")) {
		if(iPtr->argc != 3) { goto syntaxError; }
		iPtr->result = strlwr(strdup(iPtr->argv[2]));
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "toupper")) {
		if(iPtr->argc != 3) { goto syntaxError; }
		iPtr->result = strupr(strdup(iPtr->argv[2]));
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "compare")) {
		if(iPtr->argc != 4) { goto syntaxError; }
		i = strcmp(iPtr->argv[2], iPtr->argv[3]);
		if(i < 0) { i = -1; }
		if(i > 0) { i =  1; }
		iPtr->result = strdup_printf("%d", i);
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "match")) {
		if(iPtr->argc != 4) { goto syntaxError; }
		i = string_match(iPtr->argv[2], iPtr->argv[3]);
		iPtr->result = strdup_printf("%d", i);
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "first")) {	//startIndex͖Ή
		if(iPtr->argc != 4) { goto syntaxError; }
		p = strstr(iPtr->argv[3], iPtr->argv[2]);
		i = p ? (p - iPtr->argv[3]) : -1;
		iPtr->result = strdup_printf("%d", i);
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "last")) {
		if(iPtr->argc != 4) { goto syntaxError; }
		i = strlen(iPtr->argv[3]);
		while(--i >= 0) {
			if(strstr(iPtr->argv[3] + i, iPtr->argv[2])) { break; }
		}
		iPtr->result = strdup_printf("%d", i);
		return TCL_OK;
	} else if(!strcmp(iPtr->argv[1], "range")) {
		if(iPtr->argc != 5) { goto syntaxError; }
		len = strlen(iPtr->argv[2]);
		retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &first, &bEnd);
		if(retCode) { return TCL_ERROR; }
		if(bEnd) { first += (len - 1); }	//rangeend͕̍Ō̕QƂB
		retCode = Tcl_GetIndex(iPtr, iPtr->argv[4], &last, &bEnd);
		if(retCode) { return TCL_ERROR; }
		if(bEnd) { last += (len - 1); }		//rangeend͕̍Ō̕QƂB
		if(first < 0) { first = 0; }
		if(last > (len - 1)) { last = (len - 1); }
		if(first <= last) {
			iPtr->result = strndup(iPtr->argv[2] + first, last - first + 1);
		}
		return TCL_OK;
	} else {
		iPtr->result = "bad option";
		return TCL_ERROR;
	}
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_FormatCmd(Tcl_Interp* iPtr) {
	int retCode, intValue, len;
	double doubleValue;
	char **argv, *p, *fmt;
	if(iPtr->argc < 2) { goto syntaxError; }
	argv = iPtr->argv + 1;
	p = *argv++;
	while(*p) {
		if(*p == '%') {
			len = strcspn(p + 1/*'%'*/, "duioxXcsfeEgG%"/*ϊwq*/);
			fmt = strndup(p, 1/*'%'*/ + len/*x*/ + 1/*ϊwq*/);
			switch(*(p + 1/*'%'*/ + len/*x*/)) {
			case 'd':
			case 'u':
			case 'i':
			case 'o':
			case 'x':
			case 'X':
			case 'c':
				if(!*argv) { return TCL_ERROR; }
				retCode = Tcl_GetInt(iPtr, *argv++, &intValue);
				if(retCode) { return retCode; }
				Tcl_AppendResult(iPtr, fmt, intValue);
				break;
			case 's':
				if(!*argv) { return TCL_ERROR; }
				Tcl_AppendResult(iPtr, fmt, *argv++);
				break;
			case 'f':
			case 'e':
			case 'E':
			case 'g':
			case 'G':
				if(!*argv) { return TCL_ERROR; }
				retCode = Tcl_GetDouble(iPtr, *argv++, &doubleValue);
				if(retCode) { return retCode; }
				Tcl_AppendResult(iPtr, fmt, doubleValue);
				break;
			case '%':
				Tcl_AppendResult(iPtr, fmt);
				break;
			default:
				iPtr->result = "invalid format";
				return TCL_ERROR;
			}
			p += (1/*'%'*/ + len/*x*/ + 1/*ϊwq*/);
		} else {
			Tcl_AppendResult(iPtr, "%s", strcompress(p, &p, "%"));
		}
	}
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
static void Tcl_ScanCmd_callback(struct doscan_store* storePtr, void* param) {
	char*** argvPtr = param;
	int argc = strv_length(*argvPtr);
	switch(storePtr->type) {
	case 'n':
	case 'i':
	case 'd':
	case 'o':
	case 'u':
	case 'x':
	case 'X':
		(*argvPtr)[argc] = strdup_printf("%d", storePtr->value.i);
		break;
	case 'e':
	case 'E':
	case 'f':
	case 'g':
	case 'G':
		(*argvPtr)[argc] = strdup_printf("%g", storePtr->value.f);
		break;
	case 's':
	case 'c':
	case '[':
		(*argvPtr)[argc] = strdup(storePtr->value.s);
		break;
	default:
		DIE();
	}
	*argvPtr = realloc(*argvPtr, sizeof(char*)*(argc+1/*񑝂*/+1/*I[NULL*/));
	(*argvPtr)[argc+1] = NULL;//I[NULL
}
int Tcl_ScanCmd(Tcl_Interp* iPtr) {
	int argc, i;
	char** argv;
	if(iPtr->argc < 3) { goto syntaxError; }
	argv = calloc(sizeof(char*), 1);//argv[0]=I[NULL
	doscan(iPtr->argv[1], iPtr->argv[2], Tcl_ScanCmd_callback, &argv);
	argc = strv_length(argv);
	if(iPtr->argc == 3) {
		iPtr->result = Tcl_Merge(argc, argv);
	} else {
		for(i = 0; i < argc; i++) {
			if(iPtr->argc <= (3+i)) { goto storeError; }
			if(!Tcl_SetVar(iPtr, iPtr->argv[3+i], argv[i])) { goto storeError; }
		}
		iPtr->result = strdup_printf("%d", argc);
	}
	return TCL_OK;
storeError:
	iPtr->result = "store error";
	return TCL_ERROR;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/****************************************************************************
 *	
 ****************************************************************************/
static FILE* Tcl_GetFile(Tcl_Interp* iPtr, const char* channelId) {
	Tcl_TableEntry* tPtr = Tcl_FindTableEntry(&iPtr->fileTable, channelId);
	if(!tPtr) {
		iPtr->result = "bad channelId";
		return NULL;
	}
	return tPtr->value;
}
/*--------------------------------------------------------------------------*/
int Tcl_ExitCmd(Tcl_Interp* iPtr) {
	int retCode, status;
	if(iPtr->argc == 1) {
		status = 0;
	} else if(iPtr->argc == 2) {
		retCode = Tcl_GetInt(iPtr, iPtr->argv[1], &status);
		if(retCode) { return retCode; }
	} else {
		goto syntaxError;
	}
	exit(status);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_OpenCmd(Tcl_Interp* iPtr) {
	const char* mode;
	FILE* fp;
	Tcl_TableEntry* tPtr;
	if(iPtr->argc == 2) {
		mode = "r";
	} else if(iPtr->argc == 3) {
		mode = iPtr->argv[2];
	} else {
		goto syntaxError;
	}
	fp = fopen(iPtr->argv[1], mode);
	if(!fp) {
		iPtr->result = "open error";
		return TCL_ERROR;
	}
	tPtr = Tcl_CreateTableEntry(
		&iPtr->fileTable,
		strdup_printf("%p", fp),	//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
		NULL);
	tPtr->value = fp;
	iPtr->result = tPtr->key;
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_CloseCmd(Tcl_Interp* iPtr) {
	Tcl_TableEntry* tPtr;
	FILE* fp;
	if(iPtr->argc != 2) { goto syntaxError; }
	if(str_has_prefix(iPtr->argv[1], "std")) {	//WnhƁA\łȂɂȂ̂ŁAȂ悤ɂBK{ł͂ȂB
		iPtr->result = "std* shouldn't be closed";
		return TCL_ERROR;
	}
	tPtr = Tcl_FindTableEntry(&iPtr->fileTable, iPtr->argv[1]);
	if(!tPtr) {
		iPtr->result = "bad channelId";
		return TCL_ERROR;
	}
	fp = tPtr->value;
	fclose(fp);
	Tcl_DeleteTableEntry(tPtr);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_FlushCmd(Tcl_Interp* iPtr) {
	FILE* fp;
	if(iPtr->argc != 2) { goto syntaxError; }
	fp = Tcl_GetFile(iPtr, iPtr->argv[1]);
	if(!fp) { return TCL_ERROR; }
	fflush(fp);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_EofCmd(Tcl_Interp* iPtr) {
	FILE* fp;
	if(iPtr->argc != 2) { goto syntaxError; }
	fp = Tcl_GetFile(iPtr, iPtr->argv[1]);
	if(!fp) { return TCL_ERROR; }
	iPtr->result = strdup_printf("%d", !!feof(fp));
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_TellCmd(Tcl_Interp* iPtr) {
	FILE* fp;
	if(iPtr->argc != 2) { goto syntaxError; }
	fp = Tcl_GetFile(iPtr, iPtr->argv[1]);
	if(!fp) { return TCL_ERROR; }
	iPtr->result = strdup_printf("%d", ftell(fp));
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_SeekCmd(Tcl_Interp* iPtr) {
	int retCode, offset, origin;
	FILE* fp;
	if(iPtr->argc == 3) {
		origin = SEEK_SET;
	} else if(iPtr->argc == 4) {
		if(!strcmp(iPtr->argv[3], "start")) {
			origin = SEEK_SET;
		} else if(!strcmp(iPtr->argv[3], "current")) {
			origin = SEEK_CUR;
		} else if(!strcmp(iPtr->argv[3], "end")) {
			origin = SEEK_END;
		} else {
			iPtr->result = "bad origin";
			return TCL_ERROR;
		}
	} else {
		goto syntaxError;
	}
	fp = Tcl_GetFile(iPtr, iPtr->argv[1]);
	if(!fp) { return TCL_ERROR; }
	retCode = Tcl_GetInt(iPtr, iPtr->argv[2], &offset);
	if(retCode) { return retCode; }
	fseek(fp, offset, origin);
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_GetsCmd(Tcl_Interp* iPtr) {
	const char* s = "";
	FILE* fp;
	char buf[2];
	if((iPtr->argc < 2) || (iPtr->argc > 3)) { goto syntaxError; }
	fp = Tcl_GetFile(iPtr, iPtr->argv[1]);
	if(!fp) { return TCL_ERROR; }
	buf[1] = '\0';
	while((buf[0] = fgetc(fp)) != EOF) {
		if(buf[0] == '\n') { break; }
		s = strjoin(NULL, s, buf, NULL);
	}
	if(iPtr->argc == 2) {
		iPtr->result = s;
	} else {
		if(!Tcl_SetVar(iPtr, iPtr->argv[2], s)) { goto storeError; }
		iPtr->result = strdup_printf("%d", strlen(s));
	}
	return TCL_OK;
storeError:
	iPtr->result = "store error";
	return TCL_ERROR;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_PutsCmd(Tcl_Interp* iPtr) {
	int i = 1, newline = 1;
	FILE* fp;
	if((iPtr->argc >= 2) && !strcmp(iPtr->argv[i], "-nonewline")) {
		newline = 0;
		i++;
	}
	if(iPtr->argc == (i + 1)) {
		fp = stdout;
	} else if(iPtr->argc == (i + 2)) {
		fp = Tcl_GetFile(iPtr, iPtr->argv[i]);
		if(!fp) { return TCL_ERROR; }
		i++;
	} else {
		goto syntaxError;
	}
	fputs(iPtr->argv[i], fp);
	if(newline) { fputc('\n', fp); }
	return TCL_OK;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
int Tcl_SourceCmd(Tcl_Interp* iPtr) {
	int retCode;
	FILE* fp;
	if(iPtr->argc != 2) { goto syntaxError; }
	/* t@CJB */
	fp = fopen(iPtr->argv[1], "r");
	if(!fp) {
		iPtr->result = "open error";
		return TCL_ERROR;
	}
	/* t@C̓esB */
	retCode = Tcl_EvalFile(iPtr, fp);
	/* t@CB */
	fclose(fp);
	return retCode;
syntaxError:
	iPtr->result = "syntax error";
	return TCL_ERROR;
}
