/*	
 *	clipsrf.c
 *
 *	ld33݊[_
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Mon Jul 13 18:26:06 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	  ld33̎dĺAEPSONJc[(ccEVv40.exe)̃hLg(/cc33/UTILITY/ld33)QƂĂB
 *	  ̂Akeep/ld33.7zɂĂ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

/* srf33wb_
 * - ʏsrf33t@CA[_psrf33t@CA\łB
 * - oCgI[_[̓rbOGfBAŁA[hACgĂ܂B
 */
typedef struct _sr_ctrlinfo {
	unsigned char c_fatt  [2];	/* + 0,2: t@CtO */
	unsigned char c_pentry[2];	/* + 2,2: Gg[AhX */
	unsigned char c_ver   [2];	/* + 4,2: srf33o[W */
	unsigned char c_scncnt[2];	/* + 6,2: ZNV */
	unsigned char c_scnptr[4];	/* + 8,4: ZNV`F[ */
	unsigned char c_debptr[4];	/* +12,4: fobO`F[ */
} sr_ctrlinfo;				/* =16 */

/* ZNV
 * - ʏsrf33t@CA[_psrf33t@CA\łB
 * - oCgI[_[̓rbOGfBAŁA[hACgĂ܂B
 */
typedef struct _sr_scninfo {
	unsigned char s_nxptr [4];	/* + 0,4: ̃ZNVւ̃`F[ */
	unsigned char s_scntyp[2];	/* + 4,2: ZNV^Cv */
	unsigned char s_lnktyp[2];	/* + 6,2: N@ */
	unsigned char s_scnatt[2];	/* + 8,2: ZNV */
	unsigned char s_off   [4];	/* +10,4: ZNṼX^[gAhX */
	unsigned char s_rcptr [4];	/* +14,4: P[V`F[ */
	unsigned char s_rcsiz [4];	/* +18,4: P[VoCgTCY */
	unsigned char s_exptr [4];	/* +22,4: GNX^[`F[ */
	unsigned char s_exsiz [4];	/* +26,4: GNX^[oCgTCY */
	unsigned char s_excnt [4];	/* +30,4: GNX^[̌ */
	unsigned char s_rdptr [4];	/* +34,4: f[^ւ̃`F[ */
	unsigned char s_dsiz  [4];	/* +38,4: f[^oCgTCY */
	unsigned char s_scnndx[2];	/* +42,2: ZNVID */
} sr_scninfo;				/* =44 */

/* P[V ([_p)
 * - ʏsrf33t@CƁA[_psrf33t@Cł́A\Ă܂B
 * - oCgI[_[̓gGfBAŁA[hACgĂ܂B
 */
typedef struct _sr_rcinfo {
	unsigned short r_rctyp;		/* + 0,2: P[V^Cv */
	unsigned short r_scnndx;	/* + 2,2: ZNV܂̓GNX^[̃CfbNX */
	unsigned long  r_scnoff;	/* + 4,4: ZNVItZbg */
	         long  r_symoff;	/* + 8,4: P[VΏۃAhX̃ItZbgl */
} sr_rcinfo;				/* =12 */

/* GNX^[ ([_p)
 * - ʏsrf33t@CƁA[_psrf33t@Cł́A\Ă܂B
 * - oCgI[_[̓gGfBAŁA[hACgĂ܂B
 */
typedef struct _sr_extinfo {
	unsigned long e_namoff;		/* + 0,4: V{̃ItZbg */
} sr_extinfo;				/* = 4 */

/*****************************************************************************
 *	
 *****************************************************************************/

void
srf_init(void* srf, void* (*symbol)(const char* name, int user_data), int user_data)
{
	sr_ctrlinfo* ctrlinfo;
	sr_scninfo* scninfo[3]; /* [0] = code, [1] = data, [2] = bss */
	sr_scninfo* scnptr;
	sr_rcinfo* rcinfo;
	sr_rcinfo* rcinfo_end;
	sr_extinfo* extinfo;
	int i_scn;
	int dsiz;
	int addr;
	void* off;
	char* name;
	unsigned short* symoff;

	/* [_psrf33t@ĆA4oCgEɃ[hĂB
	 * [_psrf33t@C̍\́Ae4oCgEɃACgdlłA
	 * 擪AhX̃ACgĂƁAẽACgĂ܂܂B
	 */
	if((int)srf & 3) {
		DIE();
	}

	/* srf33wb_i[܂B */
	ctrlinfo = srf;

	/* [_psrf33t@Cł邱ƂmF܂B
	 * [_psrf33t@C(.srf)́Alk33"-ld"IvVw肵āA쐬ĂB
	 * ʏsrf33t@C(.srf)ANĂȂsrf33t@C(.o)́Awł܂B
	 */
	if(!(GET_BEHALF(ctrlinfo->c_fatt) & 0x0020)) { /* [_[rbg */
		DIE();
	}

	/* srf33o[WmF܂B
	 * P/ECEJ̃c[AȊÕo[Wi[邱Ƃ͖͂łB
	 */
	if(GET_BEHALF(ctrlinfo->c_ver) != 0x3300) { /* o[W = 33, rW = 00 */
		DIE();
	}

	/* [_psrf33t@ĆAZNV3Œ̎dlłB
	 * ZNV1codeZNVAZNV2dataZNVAZNV3bssZNVłB
	 */
	if(GET_BEHALF(ctrlinfo->c_scncnt) != 3) { /* [0] = code, [1] = data, [2] = bss */
		DIE();
	}

	/* ȉ̃R[hŁAvoid|C^^ϐsrfւ̉Z𑽗pĂ܂AGNU CgdlłB
	 * ut[\tgEFAOꊈpu(7)vp(http://www.cqpub.co.jp/interface/column/freesoft/2003/200303/1.htm)
	 *    void|C^Ɗ֐ւ̃|C^̎ZpZ
	 *    GNU Cł́Avoid|C^֐ւ̃|C^ŉZƌZ̉Z邱Ƃ\łB
	 *    ́Avoid֐̃TCY1Ƃ݂ȂČvZ܂B
	 *    IvV-Wpointer-arith́ÅggꂽꍇɌxo܂B
	 *    ͂ʏ͍̌ɂȂ̂ŁAvoidȂΑz肳^ɃLXgȂ肵āÅgdlׂ͉łB
	 * gׂłhƏĂ܂A֗Ȃ̂ŎgƂɂ܂B(srf + `̂Ƃ)
	 *  ȂA/usr/PIECE/include/stddef.hgdlgĂAIvV-Wpointer-arithw肷ƌx܂B
	 */
	for(i_scn = 0, scnptr = srf + GET_BEWORD(ctrlinfo->c_scnptr);
	    i_scn < 3;
	    i_scn++  , scnptr = srf + GET_BEWORD(scnptr->s_nxptr)) {

		/* ZNṼ|C^i[܂B */
		scninfo[i_scn] = scnptr;

		/* [_psrf33t@C̍\́AZNV4oCgEɃACgdlłB
		 * ŃAT[gAsr_ctrlinfo.c_scnptrsr_scninfo.s_nxptrɁA4̔{łȂli[Ă܂B
		 * dlǂȂ΁AŃAT[g邱Ƃ͗L蓾܂񂪁AÔ߂ɊmFĂƂɂ܂B
		 */
		if((int)scnptr & 3) {
			DIE();
		}

		/* [_psrf33t@ĆAZNV3Œ̎dlłB
		 * ZNV1codeZNVAZNV2dataZNVAZNV3bssZNVłB
		 * Ô߂ɁAZNV^CvāAL̎dlǂł邱ƂmF܂B
		 */
		if(GET_BEHALF(scnptr->s_scntyp) != (i_scn + 1)) { /* 1 = code, 2 = data, 3 = bss */
			DIE();
		}

		/* [_psrf33t@C̍\́Ae4oCgEɃACgdlłB
		 * ŃAT[gAP[V񂩃GNX^[4oCgEɃACgĂ܂B
		 * dlǂȂ΁AŃAT[g邱Ƃ͗L蓾܂񂪁AÔ߂ɊmFĂƂɂ܂B
		 */
		if(GET_BEWORD(scnptr->s_rcptr) & 3) {
			DIE();
		}
		if(GET_BEWORD(scnptr->s_exptr) & 3) {
			DIE();
		}

		/* [_psrf33t@C̍\́Ae4oCgEAf[^2oCgEɃACgdlłB
		 * Aۂ̃f[^𒲍ƂAf[^4oCgEɃACgĂ悤łB
		 * 4oCgEł邱Ƃ𗘗pāAcodeZNVdataZNV̎f[^Â܂܂̈ʒuŎg܂B
		 * Ô߂ɁA{Ɏf[^4oCgEɃACgĂ邩ǂmF邱Ƃɂ܂B
		 */
		if(GET_BEWORD(scnptr->s_rdptr) & 3) {
			DIE();
		}

		/* sr_scninfo.s_offtB[hɁAZNV̎sAhXi[邱Ƃɂ܂B */
		dsiz = GET_BEWORD(scnptr->s_dsiz);
		if(dsiz) {
			/* f[^oCgTCY0łȂ΁ÃZNV݂܂B */
			if(i_scn < 2) { /* [0] = code, [1] = data */
				/* codeZNVdataZNVȂ΁Af[^̂܂܂̈ʒuŎg܂B */
				off = srf + GET_BEWORD(scnptr->s_rdptr);
			} else { /* [2] = bss */
				/* bssZNVȂ΁A[NAmۂ܂B */
				off = calloc(dsiz, 1);
				if(!off) {
					DIE();
				}
			}
		} else {
			/* f[^oCgTCY0Ȃ΁ÃZNV݂͑܂B
			 * codeZNV,dataZNV,bssZNVÃZNV݂Ȃ\܂B
			 */
			off = NULL;
		}
		PUT_BEWORD(scnptr->s_off, (int)off); /* ZNV̎sAhXi[ */
	}

	/* eZNVɂāAP[VsȂ܂B */
	for(i_scn = 0; i_scn < 3; i_scn++) {

		/* ZNṼ|C^擾܂B */
		scnptr = scninfo[i_scn];

		/* P[V̐擪AhXƁAI[AhX擾܂B */
		rcinfo     = srf + GET_BEWORD(scnptr->s_rcptr);
		rcinfo_end = srf + GET_BEWORD(scnptr->s_rcptr) + GET_BEWORD(scnptr->s_rcsiz);

		/* eP[Vɂāc */
		while(rcinfo < rcinfo_end) {

			/* P[V^Cv̏8rbgAZNVQƂAGNX^[QƂĂ܂B */
			switch(rcinfo->r_rctyp >> 8) {
			case 0: /* ZNVQ */
				/* ZNVQƃCfNXA͈͓ł邱ƂmF܂B
				 * - ʏsrf33t@CƁA[_psrf33t@CŁAsr_rcinfo.r_scnndẍӖقȂ邱ƂɒӂĂB
				 *     ʏsrf33t@Cł́AuQƂGNX^[񂪏*ZNVID*vwĂ܂B
				 *     [_psrf33t@Cł́AuZNV܂̓GNX^[*CfbNX*vwĂ܂B
				 *   ʏsrf33t@Cł́Asr_scninfo.s_scnndxKv܂A[_psrf33t@Cł́A̕KvL܂B
				 * - ۂ̃f[^𒲍Ă݂ƁAȂƂ[_psrf33t@CɂẮAZNV̏ԂƃZNVID͈vĂ܂B
				 *   Ȃ킿Auscninfo[0]->s_scnndx == 0, scninfo[1]->s_scnndx == 1, scninfo[2]->s_scnndx == 2vƂȂĂ܂B
				 *   ]āA[_psrf33t@Cɂsr_rcinfo.r_scnndxZNVIDwĂƍlĂAʂ͓łB
				 * - CfbNXƌȂĎȒPȂ̂ŁAȉ̃R[h͂̂悤Ɏ܂B
				 *   EPSOŃuld33.cv\[XACfbNXƌȂĎĂ̂ŁA̕@ňSƎv܂B
				 */
				if(rcinfo->r_scnndx > 2) { /* [0] = code, [1] = data, [2] = bss */
					DIE();
				}
				/* ZNV̎sAhX擾܂B */
				addr = GET_BEWORD(scninfo[rcinfo->r_scnndx]->s_off);
				break;
			case 1: /* GNX^[Q */
				/* GNX^[̐擪AhXƁAI[AhX擾܂B
				 * GNX^[̏I[AhXAItZbg̋N_AhXƂȂ܂B
				 */
				extinfo =             srf + GET_BEWORD(scnptr->s_exptr);
				name    = (char*)(extinfo + GET_BEWORD(scnptr->s_excnt));
				/* GNX^[QƃCfNXA͈͓ł邱ƂmF܂B */
				if(rcinfo->r_scnndx > GET_BEWORD(scnptr->s_excnt) - 1) {
					DIE();
				}
				/* OQƂV{擾܂B */
				extinfo +=  rcinfo->r_scnndx;
				name    += extinfo->e_namoff;
				/* symbolT[`֐w肳ĂȂ΁AG[Ƃ܂B */
				if(!symbol) {
					DIE();
				}
				/* symbolɑΉsAhX擾܂B */
				addr = (int)(*symbol)(name, user_data);
				break;
			default:
				DIE();
			}

			/* P[VΏۃAhX̃ItZbglZAAhX肵܂B */
			addr += rcinfo->r_symoff;

			/* AhXi[ZNVItZbg擾AsAhX肵܂B */
			symoff = (unsigned short*)(GET_BEWORD(scnptr->s_off) + rcinfo->r_scnoff);

			/* P[V^Cv̉8rbgAAhXi[@Ă܂B
			 * - P[V^Cv27́Aʏsrf33t@Cƃ[_psrf33t@CƂŁAӖقȂ邱ƂɒӂĂB
			 *   ʏsrf33t@C̏ꍇA@rh,@rm,@rlA@h,@m,@lƂɁAЂƂЂƂP[V񂪐܂B
			 *   [_psrf33t@Cł́A@rh@hA@rh㑱@rm,@rlA@h㑱@m,@l܂ނ̂ƌȂ܂B
			 *   ̂悤ɕύXĂ闝ŔAP[ṼTCYߖ񂷂邽߂ƁAP[V̊ȗ̂߂Ǝv܂B
			 */
			switch(rcinfo->r_rctyp & 255) {
			case 2: /* 32bit΃V{(31:22),SYMBOL@rh */
				/* ZNVItZbg̃ACgdlɖLĂ܂񂪁ACPU̓A炩2oCgEƂȂ͂łB */
				if((int)symoff & 1) {
					DIE();
				}
				addr -= (int)&symoff[2]; /* calljp߂̈ʒȗ΃AhXƂ܂ */
				symoff[0] = (symoff[0] & 0xE000) | ((addr >> 19) & 0x1FF8); /* ext  SYMBOL@rh */
				symoff[1] = (symoff[1] & 0xE000) | ((addr >>  9) & 0x1FFF); /* ext  SYMBOL@rm */
				symoff[2] = (symoff[2] & 0xFF00) | ((addr >>  1) & 0x00FF); /* call SYMBOL@rl */
				break;
			case 7: /* 32bit΃V{(31:19),SYMBOL+imm32@h */
				/* ZNVItZbg̃ACgdlɖLĂ܂񂪁ACPU̓A炩2oCgEƂȂ͂łB */
				if((int)symoff & 1) {
					DIE();
				}
				symoff[0] = (symoff[0] & 0xE000) | ((addr >> 19) & 0x1FFF); /* ext      SYMBOL+imm32@h */
				symoff[1] = (symoff[1] & 0xE000) | ((addr >>  6) & 0x1FFF); /* ext      SYMBOL+imm32@m */
				symoff[2] = (symoff[2] & 0xFC0F) | ((addr <<  4) & 0x03F0); /* ld.w %rd,SYMBOL+imm32@l */
				break;
			case 10: /* 32bit΃V{(31:0),SYMBOL */
				/* ZNVItZbg̃ACgdlɖLĂ܂񂪁ACPU̓A炩4oCgEƂȂ͂łB */
				if((int)symoff & 3) {
					DIE();
				}
				*(int*)symoff = addr;
				break;
			default:
				DIE();
			}

			/* ̃P[VցB */
			rcinfo++;
		}
	}
}

/*---------------------------------------------------------------------------*/

void
srf_free(void* srf)
{
	/* bssZNV̂߂ɁAmۂJ܂B
	 * bssZNVꍇ́Afree(NULL)ƂȂ̂ňSłB
	 */
	free(srf_bss(srf));
}

/*---------------------------------------------------------------------------*/

/* ZNV̎sAhX擾܂B */
static void*
srf_code_data_bss(void* srf, int i/*0=code,1=data,2=bss */)
{
	sr_ctrlinfo* ctrlinfo;
	sr_scninfo* scnptr;

	ctrlinfo = srf;
	scnptr = srf + GET_BEWORD(ctrlinfo->c_scnptr);
	while(i--) {
		scnptr = srf + GET_BEWORD(scnptr->s_nxptr);
	}

	return (void*)GET_BEWORD(scnptr->s_off);
}

void*
srf_code(void* srf)
{
	return srf_code_data_bss(srf, 0/*code*/);
}

void*
srf_data(void* srf)
{
	return srf_code_data_bss(srf, 1/*data*/);
}

void*
srf_bss(void* srf)
{
	return srf_code_data_bss(srf, 2/*bss*/);
}

