/*
 *	clipruds.c
 *
 *	pX[^[̑`V[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Thu Apr 24 19:33:48 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Apr 26 09:27:47 JST 2014 Naoyuki Sawa
 *	- V[PTRpC쐬܂Bclip/tool/dRudSeqC/
 *	  ߃R[h`p}Ngăf[^쐬Kv͂܂B
 *	  XNvgāAV[PTRpCŃf[^쐬ĂB
 *	* Mon May 05 19:19:03 JST 2014 Naoyuki Sawa
 *	- cliprudc.c ɒ~㎥ԂǉƂɔAuwait stopv̏ύX܂B
 *	  [ύXO] ~ɂȂ܂ő҂B
 *	  [ύX] ~,,~㎥I܂ő҂B
 */
#include "clip.h"

/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void RudSeqCh_Exec(int iRudSeqCh);

/****************************************************************************
 *	pX[^[̑`V[PT
 ****************************************************************************/
ST_RudSeq stRudSeq;	/* `V[PT */
/*--------------------------------------------------------------------------*/
void RudSeq_Init(void (*fnUser)(int iRudSeqCh, int no)) {
	/* `V[PTNAB */
	memset(&stRudSeq, 0, sizeof stRudSeq);
	/* AvP[V`ߏ֐i[B */
	stRudSeq.fnUser = fnUser;
}
/*--------------------------------------------------------------------------*/
void RudSeqCh_Play(int iRudSeqCh, const uint16_t* pInst) {
	ST_RudSeqCh* pRudSeqCh;
	/* `V[PT`lmɒ~B */
	RudSeqCh_Stop(iRudSeqCh);
	/* `V[PT`l擾B */
	if((unsigned)iRudSeqCh > RudSeqCh_Max) { DIE(); }
	pRudSeqCh = &stRudSeq.TBL_RudSeqCh[iRudSeqCh];
	/* Ɏs閽߃|C^i[B */
	pRudSeqCh->pInst = pInst;
}
/*--------------------------------------------------------------------------*/
void RudSeqCh_Stop(int iRudSeqCh) {
	ST_RudSeqCh* pRudSeqCh;
	/* `V[PT`l擾B */
	if((unsigned)iRudSeqCh > RudSeqCh_Max) { DIE(); }
	pRudSeqCh = &stRudSeq.TBL_RudSeqCh[iRudSeqCh];
	/* `V[PT`lNAB */
	memset(pRudSeqCh, 0, sizeof(ST_RudSeqCh));
}
/*--------------------------------------------------------------------------*/
void RudSeq_Stop() {
	int iRudSeqCh;
	/* e`V[PT`lɂāc */
	for(iRudSeqCh = 0; iRudSeqCh <= RudSeqCh_Max; iRudSeqCh++) {
		/* `V[PT`l~B */
		RudSeqCh_Stop(iRudSeqCh);
	}
}
/*--------------------------------------------------------------------------*/
void RudSeq_Exec() {
	int iRudSeqCh;
	/* e`V[PT`lɂāc */
	for(iRudSeqCh = 0; iRudSeqCh <= RudSeqCh_Max; iRudSeqCh++) {
		/* `V[PT`lsB */
		RudSeqCh_Exec(iRudSeqCh);
	}
}
/*--------------------------------------------------------------------------*/
static void RudSeqCh_Exec(int iRudSeqCh) {
	ST_RudSeqCh* pRudSeqCh;
	int Hi, Lo;
	/* `V[PT`l擾B */
	if((unsigned)iRudSeqCh > RudSeqCh_Max) { DIE(); }
	pRudSeqCh = &stRudSeq.TBL_RudSeqCh[iRudSeqCh];
	/* ĐłȂ΁AȂB */
	if(!pRudSeqCh->pInst) { return; }
#ifdef  WIN32
//	printf("%*s""AbsTime=%u,RelTime=%u\n",pRudSeqCh->StackLevel,"",pRudSeqCh->AbsTime,pRudSeqCh->RelTime);
#endif//WIN32
	for(;;) {
		/* ߃R[h擾B */
		Hi = *pRudSeqCh->pInst;
		Lo = Hi & 0xFFF;	/* ߃R[h̉12bit */
		Hi >>= 12;		/* ߃R[h̏ 4bit */
		/* ߃R[h̏4bitɂāc */
		switch(Hi) {
		case 0:
			/* ߃R[h̉12bitɂāc */
			switch(Lo) {
			case 0: /* end */
#ifdef  WIN32
				printf("%*s""end\n",pRudSeqCh->StackLevel,"");
#endif//WIN32
				/* X^bNL΁c */
				if(pRudSeqCh->StackLevel) {
					/* X^bN炷B */
					pRudSeqCh->StackLevel--;
					/* RepeatX^bNȂ΁c */
					if(pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].Repeat) {
						/* ,,cJԂ񐔂炵0łȂ΁c */
						if((pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].Repeat < 0) ||
						 (--pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].Repeat)) {
							/* ߃|C^ݒ肷B */
							pRudSeqCh->pInst = pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].pInst;
							/* X^bN𑝂₷B */
							pRudSeqCh->StackLevel++;
						}
					/* CallX^bNȂ΁c */
					} else {
						/* ߃|C^ݒ肷B */
						pRudSeqCh->pInst = pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].pInst;
					}
				/* X^bN΁c */
				} else {
					/* ĐIB */
					RudSeqCh_Stop(iRudSeqCh);
					return; /* ܂ */
				}
				break;
			case 1: /* move init */
#ifdef  WIN32
				printf("%*s""move init\n",pRudSeqCh->StackLevel,"");
#endif//WIN32
				/* ``l̏sB */
				RudCtlCh_MoveInit(iRudSeqCh);									//i``lԍ`V[PT`lԍjƂO
				break;
			case 2: /* move stop */
#ifdef  WIN32
				printf("%*s""move stop\n",pRudSeqCh->StackLevel,"");
#endif//WIN32
				/* ``l̒~sB */
				RudCtlCh_Stop(iRudSeqCh);									//i``lԍ`V[PT`lԍjƂO
				break;
			case 3: /* wait stop */
#ifdef  WIN32
//				printf("%*s""wait stop\n",pRudSeqCh->StackLevel,"");
#endif//WIN32
				/* ``l쒆,,~㎥Ȃ΁c */
				if(RudCtlCh_GetSpd(iRudSeqCh) || RudCtlCh_GetStpTim(iRudSeqCh)) {				//i``lԍ`V[PT`lԍjƂO
					goto L_EXIT; /* ܂ */
				}
				break;
			default: /* user u */
#ifdef  WIN32
				printf("%*s""user %u\n",pRudSeqCh->StackLevel,"",Lo-4);
#endif//WIN32
				/* AvP[V`߂sB */
				(*stRudSeq.fnUser)(iRudSeqCh, Lo-4);
				break;
			}
			break;
		case 1: /* goto */
#ifdef  WIN32
			printf("%*s""goto %d\n",pRudSeqCh->StackLevel,"",((int16_t)(Lo<<4))>>4);
#endif//WIN32
			/* ߃|C^ݒ肷B */
			if(!Lo) { DIE(); } /* f[^oO */									//gotoߎgւgoto͖炩Ƀf[^oOłB
			pRudSeqCh->pInst += (((int16_t)(Lo<<4))>>4) - 1/*ʏ́u+1v𑊎E*/;
			break;
		case 2: /* call */
#ifdef  WIN32
			printf("%*s""call %d\n",pRudSeqCh->StackLevel,"",((int16_t)(Lo<<4))>>4);
#endif//WIN32
			if((unsigned)pRudSeqCh->StackLevel >= RudSeqCh_StackSize) { DIE(); }	/* RudSeqCh_StackSize𒲐 */
			/* ߂̖߃|C^i[B */
			pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].pInst = pRudSeqCh->pInst;					//u`=pRudSeqCh->pInst+1/*̖*/;vł͂ȂƂɒӂBu+1v͖߂莞end̎s̋ʏōs邩B
			/* CallX^bNł邱ƂB */
			pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].Repeat = 0;
			/* X^bN𑝂₷B */
			pRudSeqCh->StackLevel++;
			/* ߃|C^ݒ肷B */
			if(!Lo) { DIE(); } /* f[^oO */									//callߎgւcall͖炩Ƀf[^oOłB
			pRudSeqCh->pInst += (((int16_t)(Lo<<4))>>4) - 1/*ʏ́u+1v𑊎E*/;
			break;
		case 3: /* repeat */
#ifdef  WIN32
			printf("%*s""repeat %u\n",pRudSeqCh->StackLevel,"",Lo);
#endif//WIN32
			if((unsigned)pRudSeqCh->StackLevel >= RudSeqCh_StackSize) { DIE(); }	/* RudSeqCh_StackSize𒲐 */
			/* ߂̖߃|C^i[B */
			pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].pInst = pRudSeqCh->pInst;					//u`=pRudSeqCh->pInst+1/*̖*/;vł͂ȂƂɒӂBu+1v͖߂莞end̎s̋ʏōs邩B
			/* RepeatX^bN̎cJԂ񐔂i[B */
			pRudSeqCh->TBL_Stack[pRudSeqCh->StackLevel].Repeat = Lo ? Lo : -1/**/;
			/* X^bN𑝂₷B */
			pRudSeqCh->StackLevel++;
			break;
		case 4: /* speed */
#ifdef  WIN32
			printf("%*s""speed %u\n",pRudSeqCh->StackLevel,"",Lo);
#endif//WIN32
			/* ݒ肷B */
			pRudSeqCh->Speed = Lo;
			break;
		case 5: /* move rel */
#ifdef  WIN32
			printf("%*s""move rel %d\n",pRudSeqCh->StackLevel,"",((int16_t)(Lo<<4))>>4);
#endif//WIN32
			/* ``l̓sB */
			RudCtlCh_MoveRel(iRudSeqCh, ((int16_t)(Lo<<4))>>4, pRudSeqCh->Speed);					//i``lԍ`V[PT`lԍjƂO
			break;
		case 6: /* move abs */
#ifdef  WIN32
			printf("%*s""move abs %d\n",pRudSeqCh->StackLevel,"",((int16_t)(Lo<<4))>>4);
#endif//WIN32
			/* ``l̓sB */
			RudCtlCh_MoveAbs(iRudSeqCh, ((int16_t)(Lo<<4))>>4, pRudSeqCh->Speed);					//i``lԍ`V[PT`lԍjƂO
			break;
		case 7: /* wait rel */
#ifdef  WIN32
//			printf("%*s""wait rel %u\n",pRudSeqCh->StackLevel,"",Lo);
#endif//WIN32
			/* O̖ߊ̑ΎԂAw肳ꂽΎԂɓBĂȂ΁c */
			if((unsigned)pRudSeqCh->RelTime < (unsigned)Lo) {
				goto L_EXIT; /* ܂ */
			}
			break;
		default: /* wait abs */
#ifdef  WIN32
//			printf("%*s""wait abs %u\n",pRudSeqCh->StackLevel,"",Lo);
#endif//WIN32
			/* f[^ĐJn̐ΎԂAw肳ꂽΎԂɓBĂȂ΁c */
			if((unsigned)pRudSeqCh->AbsTime < (unsigned)(((Hi&7)<<12)|Lo)) {
				goto L_EXIT; /* ܂ */
			}
			break;
		}
		/* ߃|C^i߂B */
		pRudSeqCh->pInst++;												//end,goto,call̒߃|C^iނƂɒӂB
		/* O̖ߊ̑ΎԂZbgB */
		pRudSeqCh->RelTime = 0;
	}
L_EXIT:	/* ̂߂ɁAf[^ĐJn̐ΎԂƁAO̖ߊ̑ΎԂi߂B
	 * - ֐̍ŏŐi߂̂ł͂ȂAŌŐi߂邱ƂɒӂB
	 *   ֐̍ŏŐi߂ƁAAbsTime0Ŏs鎞A񑁂ił܂B
	 */
	if(pRudSeqCh->AbsTime < USHRT_MAX) { pRudSeqCh->AbsTime++; }
	if(pRudSeqCh->RelTime < USHRT_MAX) { pRudSeqCh->RelTime++; }
}

#if 0
/****************************************************************************
 *	Tvf[^
 ****************************************************************************/
//ް1
const uint16_t TBL_Inst1[]={
RudSeq_Inst_move_init,		//s
RudSeq_Inst_wait_abs(1000),	//ްĐJn̐ΎԂ1bȏɂȂ܂ő҂¡
RudSeq_Inst_speed(5),		//ݒ肷顂ȍ~moveɑ΂ēKp
RudSeq_Inst_move_abs(100),	//Έʒuւ̓Jn
RudSeq_Inst_wait_stop,		//삪I܂ő҂¡
RudSeq_Inst_move_rel(-500),	//Έʒuւ̓Jn
RudSeq_Inst_wait_rel(200),	//O̖ߊ̑ΎԂ200ؕbȏɂȂ܂ő҂¡
RudSeq_Inst_move_stop,		//(삪ĂȂΤ)~Jn
RudSeq_Inst_wait_abs(5000),	//ްĐJn̐ΎԂ5bȏɂȂ܂ő҂¡
RudSeq_Inst_move_abs(0),	//_ʒuւ̓Jn
RudSeq_Inst_end,		//ĐI(삪ĂȂ΁A͌p)
};
//s
//move init
//speed 5
//move abs 100
//move rel -500
//move stop
//move abs 0
//end
/*--------------------------------------------------------------------------*/
//ް2
const uint16_t TBL_Inst2[]={
RudSeq_Inst_goto(2),		//̖߂̈ʒuƂΈʒuŤ+2̖߂֕򂷂
RudSeq_Inst_move_init,		//̖߂͎sȂ
//goto̔ѐ
RudSeq_Inst_repeat(2),		//2JԂJn
RudSeq_Inst_call(3),		//̖߂̈ʒuƂΈʒuŤ+3̖߂Ăяo
RudSeq_Inst_end,		//2JԂendͤrepeatɑΉendł
RudSeq_Inst_end,		//ĐI(삪ĂȂ΁A͌p)
//calľĂѐ
RudSeq_Inst_move_rel(10),	//Έʒuւ̓Jn
RudSeq_Inst_wait_stop,		//삪I܂ő҂¡
RudSeq_Inst_move_rel(-10),	//Έʒuւ̓Jn
RudSeq_Inst_wait_stop,		//삪I܂ő҂¡
RudSeq_Inst_end,		//Ăяo֖߂顂endͤcallɑΉendł
};
//s
//goto 2
//repeat 2
// call 3
//  move rel 10
//  move rel -10
//  end
// end
// call 3
//  move rel 10
//  move rel -10
//  end
// end
//end
/*--------------------------------------------------------------------------*/
#endif
