/*	
 *	clipmus.c
 *
 *	P/ECEWyCu ⏕[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon May 24 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Sep 23 18:35:17 JST 2014 Naoyuki Sawa
 *	- music_play(),music_stop(),music_stat()ǉ܂B
 *	  ܂ŁAX̃AvP[Vapp.hŃ}N`Ă܂ÁACuɊ܂߂邱Ƃɂ܂B
 *	* Wed Sep 24 20:09:57 JST 2014 Naoyuki Sawa
 *	- music_loudness()p~Amusic_init(),music_free(),music_filter_install()ƂĔėp܂B
 *	  ܂łmusic_loudness()Ɠʂ́Amusic_filter_install(music_filter_loudness)ɂē܂B
 */
#include "clip.h"

//{{2014/09/23ύX:music_play(),music_stop(),music_stat()ǉ܂B܂ŁAX̃AvP[Vapp.hŃ}N`Ă܂ÁACuɊ܂߂邱Ƃɂ܂B
//static int (*old_WaveDataOut)(int ch, PCEWAVEINFO* pwi);
//static int new_WaveDataOut(int ch, PCEWAVEINFO* pwi)
//{
//	short* p;
//	int i;
//	int v;
//	int len;
//
//	/* P/ECEWyCu̎gp`lւ̏o͂Ȃ΁Aʑ܂B
//	 * Ô߁A16bit PCM`ł邱ƂmFĂ܂B
//	 * P/ECEWyCȕo͂́A16bit PCM`ł͂łB
//	 */
//	if((ch == music_wch) && (pwi->type & PW_TYPE_16BITPCM)) {
//		p = (short*)pwi->pData;
//		len = pwi->len;
//		for(i = 0; i < len; i++) {
//			v = *p << 2; /* BłA4{ȏɂƉ悤ł */
//			     if(v < -32767) v = -32767;
//			else if(v >  32767) v =  32767;
//			*p++ = v;
//		}
//	}
//
//	return old_WaveDataOut(ch, pwi);
//}
//void
//music_loudness(int enable)
//{
//	if(enable) {
//		if(old_WaveDataOut) return; /* ɃtbNĂA܂ */
//		old_WaveDataOut = pceVectorSetKs(KSNO_WaveDataOut, new_WaveDataOut);
//	} else {
//		if(!old_WaveDataOut) return; /* ܂tbNĂȂ΁A܂ */
//		pceVectorSetKs(KSNO_WaveDataOut, old_WaveDataOut);
//		old_WaveDataOut = NULL; /* tbNƂ}[NAYȂ!! */
//	}
//}
//2014/09/23ύX:music_play(),music_stop(),music_stat()ǉ܂B܂ŁAX̃AvP[Vapp.hŃ}N`Ă܂ÁACuɊ܂߂邱Ƃɂ܂B
static MUSICFILTER* music_filter;
void music_filter_install(MUSICFILTER* filter) {
	/* ytB^֐i[܂B */
	music_filter = filter;
}
#ifndef PIECE
void music_filter_loudness(short wbuff[/*len*/], int len) {
	do {
		int x = *wbuff << 2; /* BłA4{ȏɂƉ悤ł */
		if(x < SHRT_MIN) { x = SHRT_MIN; }
		if(x > SHRT_MAX) { x = SHRT_MAX; }
		*wbuff++ = x;
	} while(--len);
}
#else /*PIECE*/
void music_filter_loudness(short wbuff[/*len*/], int len);
asm("
		.code
		.align		1
		.global		music_filter_loudness
music_filter_loudness:
		xld.w		%r14, 32767			;//%r14 := SHRT_MAX
		not		%r15, %r14			;//%r15 := SHRT_MIN
		;//%r12 := wbuff
		;//%r13 := len
		;//%r14 := SHRT_MAX
		;//%r15 := SHRT_MIN
music_filter_loudness_L10:					;//do {
		ld.h		%r9, [%r12]			;//  %r9    := x = *wbuff
		sla		%r9, 2				;//  %r9    := x <<= 2				!INTERLOCK!
		cmp		%r9, %r14			;//  %psr   := x <=> SHRT_MAX
		jrle.d		3				;//  if(       x   > SHRT_MAX) {
		 cmp		%r9, %r15			;//  %psr   := x <=> SHRT_MIN			*delay*
		 ld.w		%r9, %r14			;//    %r9  := x  =  SHRT_MAX  }	@
		jrge.d		3				;//  if(       x <   SHRT_MIN) {	
		 sub		%r13, 1				;//  %r13   := i--				*delay*
		 ld.w		%r9, %r15			;//    %r9  := x  =  SHRT_MIN  }	@
		ld.h		[%r12]+, %r9			;//  *wbuff++ = x			@
		jrne		music_filter_loudness_L10	;//} while(i)				
		ret
");
#endif/*PIECE*/
static int   new_pceWaveDataOut (int ch, PCEWAVEINFO* pwi);
static int (*old_pceWaveDataOut)(int ch, PCEWAVEINFO* pwi) = new_pceWaveDataOut;
static int   new_pceWaveDataOut (int ch, PCEWAVEINFO* pwi) {
	/* P/ECEWyCu̎gp`lւ̏o͂Ȃ΁c
	 *  - Ô߁A16bit PCM`ł邱ƂmF܂B
	 *    P/ECEWyCȕo͂́A16bit PCM`ł͂łB */
	if((ch == music_wch) && (pwi->type & PW_TYPE_16BITPCM)) {
		/* ytB^֐o^Ă΁AytB^֐Ăяo܂B */
		if(music_filter) { (*music_filter)((short*)pwi->pData, pwi->len); }
	}
	return old_pceWaveDataOut(ch, pwi);
}
static void hook_unhook_music() {
	old_pceWaveDataOut = (PCEKSENT)pceVectorSetKs(KSNO_WaveDataOut, old_pceWaveDataOut);
}
void music_init() {
	/* yCu܂B */
	InitMusic();
	/* P/ECEWyCu̎gp`lւ̏o̓tbNݒ肵܂B */
	hook_unhook_music(); /* 1ĂԂƃtbN */
}
void music_free() {
    //{{2014/09/23폜:svłBsĂQ͖AʏȂ̂ō폜邱Ƃɂ܂B
    //	/* mɉyt~܂B
    //	 * TEh̒~̓CupceAppExit()ōsĂ̂ŁAł͕Kv܂B */
    //	StopMusic();
    //}}2014/09/23폜:svłBsĂQ͖AʏȂ̂ō폜邱Ƃɂ܂B
	/* P/ECEWyCu̎gp`lւ̏o̓tbN܂B */
	hook_unhook_music(); /* 2ĂԂƃtbN */
}
//}}2014/09/23ύX:music_play(),music_stop(),music_stat()ǉ܂B܂ŁAX̃AvP[Vapp.hŃ}N`Ă܂ÁACuɊ܂߂邱Ƃɂ܂B

//{{2014/09/23ǉ:music_play(),music_stop(),music_stat()ǉ܂B܂ŁAX̃AvP[Vapp.hŃ}N`Ă܂ÁACuɊ܂߂邱Ƃɂ܂B
void music_play(const void* seq) {
	pceWaveAbort(music_wch);	//KvBStopMusic()ĂяoC̃~LVO荞݂܂ł̊Ԃ́A܂Xg[obt@gpłBpceWaveAbort(music_wch)sȂƁAgp̃Xg[obt@PlayMusic()j󂵂Ė\B
	PlayMusic((unsigned char*)seq);	//x}̂constLXgłB
}
void music_stop() {
	/* - APÍA~vtOZbg邾ŁA܂ۂɂ͍Đ~ĂȂB̃~LVO荞݂ɁAĐRɒ~B
	 *   ȂApceWaveAbort(music_wch)ĂŃ~LVOIɒ~ƁAMusicCheck()IԂɈڍsȂ肪̂ŁA͂ȂƂɂB
	 * - music_stop()ĂяoC̃~LVO荞݂܂ł̊ԂɁAmusic_stat()ĂяoĂÅԂ͍Đ(1)Ɣf邱ƂɒӂB */
	StopMusic();
}
int music_stat() {
	/* * Tue Sep 23 18:23:03 JST 2014 Naoyuki Sawa
	 * - MusicCheck()́A߂l}jAƋtłBmusic_stat()́AMusicCheck()̃}jAǂ̈ӖɕϊĕԂƂɂ܂B
	 *   QƎ:
	 *   P/ECEJP/ECEyCu}jAMusicCheck(/usr/PIECE/docs/muslib/MusicCheck.html)
	 *   ytǂ𒲂ׂ܂B
	 *   void MusicCheck( void );
	 *   ߂lF ==0 ~ <>0 t	ԈႢłB
	 *   u܂ǂ̐Ev(http://www2.plala.or.jp/madoka/)́A2001/12/23̋L(http://www2.plala.or.jp/madoka/nikki/nikki0009.html)
	 *   ƁAOɏĂtԂ𒲂ׂMusicCheckƂ`ohłAǂԂĂl̈Ӗ}jAƋt̂悤łB
	 *   OԂƉtŁAOȊO͒~݂łB͓FinishƂO[oϐQǂ̓ԂĂ邾Ȃ̂ŁA
	 *   ƎvΒ܂AƂƌۂ𒲂ׂĂAANAvXɃ[łĂ݂邩ȁB
	 * - InitMusic()̌APlayMusic()StopMusic()Ăяo܂ł̊ԁAtƔfBP/ECEyCũoÔ悤łB */
	return !MusicCheck();//01
}
//}}2014/09/23ǉ:music_play(),music_stop(),music_stat()ǉ܂B܂ŁAX̃AvP[Vapp.hŃ}N`Ă܂ÁACuɊ܂߂邱Ƃɂ܂B

