
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		LOT_draw_column
LOT_draw_column:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := rndval
LOT_draw_column_LOOP:
		sub		%r13, 1			;// %r13 := column_size--
		jrlt		LOT_draw_column_MISS	;// if(column_size < 0) return -1
		;//
		ld.uh		%r10, [%r12]+		;// %r10 := hitval = *column++
		ld.uh		%r11, [%r12]+		;// %r11 := weight = *column++
;//{{
;//		add		%r11, 1			;// %r11 :=           (weight + 1)
;//		sub		%r14, %r11		;// %r14 := rndval -= (weight + 1)
;//		jrge		LOT_draw_column_LOOP	;// if(rndval <  0) return hitval
;//
		sub		%r14, %r11		;// %r14 := rndval -= (weight    )
		jrgt.d		LOT_draw_column_LOOP	;// if(rndval <= 0) return hitval
		sub		%r14, 1			;// %r14 := rndval -= (         1)	*delay*
;//}}
		ret					;// return  hitval
LOT_draw_column_MISS:
		ret.d					;// return  -1
		ld.w		%r10, -1		;// %r10 := -1				*delay*

	
		.code
		.align		1
		.global		LOT_get_column_weight
LOT_get_column_weight:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := hitval_sel
LOT_get_column_weight_LOOP:
		sub		%r13, 1				;// %r13 := column_size--
		jrlt		LOT_get_column_weight_MISS	;// if(column_size < 0) return 0
		;//
		ld.uh		%r11, [%r12]+			;// %r11 := hitval = *column++
		ld.uh		%r10, [%r12]+			;// %r10 := weight = *column++
		cmp		%r11, %r14			;// if(hitval == hitval_sel)
		jrne		LOT_get_column_weight_LOOP
		ret.d						;//   return  (weight + 1)
		add		%r10, 1				;//   %r10 := (weight + 1)	*delay*
LOT_get_column_weight_MISS:
		ret.d						;// return  0
		ld.w		%r10, 0				;// %r10 := 0			*delay*

	
		.code
		.align		1
LOT_seek_and_call:
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		ld.uh		%r4, [%r12]+					;//%r4  := table_size = *table++
		ld.uh		%r5, [%r12]+					;//%r5  := id_size    = *table++
		sla		%r5, 2						;//%r5  := id_size * sizeof(int)
LOT_seek_and_call_L1:								;//for(;;) {
		;//%r4  := table_size
		;//%r5  := id_size * sizeof(int)
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		sub		%r4, 1						;//%r4  := table_size--
		jrlt		LOT_seek_and_call_DIE				;//if(table_size < 0) { DIE() }
		ld.w		%r6, %r5					;//%r6  := n_id = id_size * sizeof(int)
		ld.w		%r7, 0						;//%r7  := diff = 0
LOT_seek_and_call_L2:								;//for(;;) {
		;//%r4  := table_size
		;//%r5  := id_size * sizeof(int)
		;//%r6  := n_id
		;//%r7  := diff
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		sub		%r6, 4						;//%r6  := n_id -= sizeof(int)
		jrlt		LOT_seek_and_call_L3				;//if(n_id < 0) { break }
		ld.uh		%r10, [%r12]+					;//%r10 :=          id1       = *table++
		ld.w		%r11, [%r13]+					;//%r11 :=                id2 = *pid++
		sub		%r10, %r11					;//%r10 :=         (id1 - id2)
		jp.d		LOT_seek_and_call_L2				;//}
		or		%r7, %r10					;//%r7  := diff |= (id1 - id2)					*delay*
LOT_seek_and_call_L3:
		;//%r4  := table_size
		;//%r5  := id_size * sizeof(int)
		;//%r7  := diff
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		ld.uh		%r6, [%r12]+					;//%r6  := column_size = *table++
		cmp		%r7, 0						;//if(!diff) { break }
		jreq		LOT_seek_and_call_L4
		sub		%r13, %r5					;//%r13 := pid -=   (    id_size *     sizeof(int)           )
		sla		%r6, 2						;//%r6  :=          (column_size * 2 * sizeof(unsigned short))
		jp.d		LOT_seek_and_call_L1				;//}
		add		%r12, %r6					;//%r12 := table += (column_size * 2 * sizeof(unsigned short))	*delay*
LOT_seek_and_call_L4:
		;//%r6  := column_size
		;//%r12 := table
		;//%r13 := pid
		;//%r14 := param
		;//%r15 := fn
		ld.w		%r4, [%r13]					;//%r4  := id2 = *pid
		ld.w		%r13, %r6					;//%r13 := column_size					*anti-interlock*
		cmp		%r4, -1						;//if(id2 != -1) { DIE() }		
		jrne		LOT_seek_and_call_DIE				;//					
;//		ld.w		%r13, %r6					;//%r13 := column_size		
		jp		%r15						;//return (*fn)(table, column_size, param)			(jp.d %rb͕s)

	.code
	.align	2
__LC0:
	.ascii	"cliplot.$\000"
; NO_APP
	.code
	.align	1
LOT_seek_and_call_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x7		; 	xld.w	%r13,0x000001df		; 479
	ld.w	%r13,0x1f
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP
	
		.align		1
		.global		LOT_draw_table_l
		.global		LOT_draw_table_a
		.global		LOT_draw_table_v
LOT_draw_table_l:
		;//%r12    := table
		;//[%sp+0] := retp
		;//[%sp+4] := rndval
		;//[%sp+8] := ...
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8					;//%r13 := ap = &...
	add	%r13,0x8
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+4]					;//%r14 := rndval
LOT_draw_table_a:		;//AZuvOł́A
LOT_draw_table_v:		;//̓̊֐͓łB
		;//%r12    := table
		;//%r13    := pid = ap
		;//%r14    := rndval
	ext	LOT_draw_column+0x0@h	; 		xld.w		%r15, LOT_draw_column				;//%r15 := LOT_draw_column
	ext	LOT_draw_column+0x0@m
	ld.w	%r15,LOT_draw_column+0x0@l
	jp	LOT_seek_and_call	; 		xjp		LOT_seek_and_call				;//return LOT_seek_and_call(table, pid, rndval, LOT_draw_column)

	
		.align		1
		.global		LOT_get_table_weight_l
		.global		LOT_get_table_weight_a
		.global		LOT_get_table_weight_v
LOT_get_table_weight_l:
		;//%r12    := table
		;//[%sp+0] := retp
		;//[%sp+4] := hitval_sel
		;//[%sp+8] := ...
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8					;//%r13 := ap = &...
	add	%r13,0x8
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+4]					;//%r14 := hitval_sel
LOT_get_table_weight_a:		;//AZuvOł́A
LOT_get_table_weight_v:		;//̓̊֐͓łB
		;//%r12    := table
		;//%r13    := pid = ap
		;//%r14    := hitval_sel
	ext	LOT_get_column_weight+0x0@h	; 		xld.w		%r15, LOT_get_column_weight			;//%r15 := LOT_get_column_weight
	ext	LOT_get_column_weight+0x0@m
	ld.w	%r15,LOT_get_column_weight+0x0@l
	jp	LOT_seek_and_call	; 		xjp		LOT_seek_and_call				;//return LOT_seek_and_call(table, pid, hitval_sel, LOT_get_column_weight)

	
		.code
		.align		1
		.global		LOT_get_table_column_id
LOT_get_table_column_id:
		;//%r12 := table
		;//%r13 := i_column
		;//%r14 := pid
		ld.uh		%r4, [%r12]+					;//%r4  := table_size = *table++
		ld.uh		%r5, [%r12]+					;//%r5  := id_size    = *table++
		cmp		%r4, %r13					;//if(table_size <= i_column) { DIE() }
		jrle		LOT_get_table_column_id_DIE
		sla		%r5, 1						;//%r5  := id_size * sizeof(unsigned short)
LOT_get_table_column_id_L1:							;//for(;;) {
		;//%r5  := id_size * sizeof(unsigned short)
		;//%r12 := table
		;//%r13 := i_column
		;//%r14 := pid
		sub		%r13, 1						;//%r13 := i_column--
		jrlt		LOT_get_table_column_id_L2			;//if(i_column < 0) { break }
		add		%r12, %r5					;//%r12 := table += (    id_size     * sizeof(unsigned short))
		ld.uh		%r6, [%r12]+					;//%r6  :=           column_size = *table++
		sla		%r6, 2						;//%r6  :=          (column_size * 2 * sizeof(unsigned short))
		jp.d		LOT_get_table_column_id_L1			;//}
		add		%r12, %r6					;//%r12 := table += (column_size * 2 * sizeof(unsigned short))	*delay*
LOT_get_table_column_id_L2:							;//for(;;) {
		;//%r5  := id_size * sizeof(unsigned short)
		;//%r12 := table
		;//%r14 := pid
		sub		%r5, 2						;//%r5  := (id_size * sizeof(unsigned short)) -= sizeof(unsigned short)
		jrlt		LOT_get_table_column_id_L3			;//     if((id_size * sizeof(unsigned short)) < 0) { break }
		ld.uh		%r4, [%r12]+					;//%r4  :=  id = *table++
		ld.w		[%r14]+, %r4					;//*pid++ = id
		jp		LOT_get_table_column_id_L2			;//}
LOT_get_table_column_id_L3:
		ld.w		%r4, -1						;//%r4  :=  id = -1
		ld.w		[%r14], %r4					;//*pid   = id
		ret

; NO_APP
	.align	1
LOT_get_table_column_id_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0xa		; 	xld.w	%r13,0x00000280		; 640
	ld.w	%r13,0x0
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
