/*	
 *	clipgsm.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2002 Naoyuki Sawa
 *
 *	* Sat Oct 12 06:07:00 JST 2002 Naoyuki Sawa
 *	- clippce.cGSM֐𕪗܂B
 *	  AvP[V̊֐gȂ΁A
 *	  ̊֐pĂGSMCuNȂ̂ŁA
 *	  GSMgȂAvP[ṼTCYȂ͂łB
 *	* Thu Oct 24 20:00:00 JST 2002 Naoyuki Sawa
 *	- c33209.hɊ荞݃xN^ԍ`̂ŁAg悤ɂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	GSMĐ
 ****************************************************************************/

#define MAXCH		4	/* `lFP/ECEdl                    */
#define BLKN		2	/* ubNFA2ȏBԂ2ŏ[ */
#define BLKS		320	/* ubNTCY(Tv)FA64xN */
#define GSMS		160	/* GSMt[TCY(Tv)FGSMdl   */

typedef struct _GSMINFO {
	PCEKSENT old_isr;	/* +0,4:̃TEh荞݃[`       */
	volatile char busy;	/* +4,1:gsm_fill()ē֎~tO           */
	volatile char bc;	/* +5,1:󂫃ubN                     */
	         char bi;	/* +6,1:󂫃ubN̐擪CfNX       */
	volatile char loop;	/* +7,1:c胋[v(݂̃[v܂) */
	/* t@C֘A */
	FILEACC fa;		/* GSMt@C               */
	int ofs;		/* GSMt@C̓ǂݍ݈ʒu */
	/* GSM֘A */
	gsm g;			/* GSMRo[^               */
	gsm_frame gf;		/* GSMt[ǂݍ݃obt@ */
	gsm_signal gs[GSMS];	/* GSMt[WJobt@     */
	int rest;		/* GSMt[̎cTv */
	/* Wave֘A */
	int ch;			/* Đ`l */
	PCEWAVEINFO wi[BLKN];	/* WAVEwb_   */
	short wb[BLKN][BLKS];	/* WAVEf[^   */
} GSMINFO;
static GSMINFO gsm_info;

static void gsm_isr();
static void gsm_fill();
static void gsm_fill_busy();
static void gsm_endproc(PCEWAVEINFO* wi);

int
gsm_play(int ch, const char* fname, int loop)
{
	GSMINFO* gi = &gsm_info;

	int retval, i;
	PCEWAVEINFO* wi;

	/* mɒ~܂B */
	gsm_stop();

	/* ŜNA܂B */
	memset(gi, 0, sizeof(GSMINFO));

	/* t@CJ܂B */
	retval = pceFileOpen(&gi->fa, fname, FOMD_RD);
	if(retval != 0) {
		return -1;
	}

	/* GSMRo[^쐬܂B */
	gi->g = gsm_create();
	if(gi->g == NULL) {
		pceFileClose(&gi->fa);
		return -1;
	}

	/* Đ`li[܂B */
	if(ch < 0 || MAXCH - 1 < ch) {
		gsm_destroy(gi->g);
		pceFileClose(&gi->fa);
		return -1;
	}
	gi->ch = ch;

	/* [v񐔂i[܂B */
	gi->loop = loop;

	/* WAVE܂B */
	for(i = 0, wi = gi->wi; i < BLKN; i++, wi++) {
		wi->type = PW_TYPE_16BITPCM; /* ւɂ̂PW_TYPE_CONTsv */
		wi->pData = &gi->wb[i][0];
		wi->len = BLKS;
		wi->next = &gi->wi[(i + 1) % BLKN]; /* ւɂ܂ */
		wi->pfEndProc = gsm_endproc;
	}

	/* ĐJnOɁASubNɃf[^𖞂Ă܂B */
	gi->bc = BLKN;
	gsm_fill();
	gsm_fill_busy(); /* RpČx} */

	/* TEh荞݃[`tbNAWaveĐJn܂B
	 * ̓̊ԂɃTEh荞݂Ă͂܂B
	 */
DISABLE;
	gi->old_isr = pceVectorSetTrap(TRAP_HDM1, gsm_isr);
	pceWaveDataOut(gi->ch, &gi->wi[0]);
ENABLE;

	return 0;
}

void
gsm_stop()
{
	GSMINFO* gi = &gsm_info;

	/* ĐłȂΉ܂B */
	if(gi->old_isr == NULL) return;

	/* WAVEĐ~ATEh荞݃[`ɖ߂܂B
	 * ̓̊ԂɃTEh荞݂Ă͂܂B
	 */
DISABLE;
	pceWaveAbort(gi->ch);
	pceVectorSetTrap(TRAP_HDM1, gi->old_isr);
	gi->old_isr = NULL;
ENABLE;

	/* GSMRo[^폜܂B */
	gsm_destroy(gi->g);

	/* t@C܂B */
	pceFileClose(&gi->fa);
}

static void
gsm_isr()
{
	/* [%sp+ 0]:psr
	 * [%sp+ 1]:pc
	 */
	asm("
	pushn %r15
	ld.w %r0, %alr
	ld.w %r1, %ahr
	pushn %r1
	");
	/* [%sp+ 0]:alr
	 * [%sp+ 1]:ahr
	 * [%sp+ 2]:r0
	 * [%sp+ 3]:r1
	 * [%sp+ 4]:r2
	 * [%sp+ 5]:r3
	 * [%sp+ 6]:r4
	 * [%sp+ 7]:r5
	 * [%sp+ 8]:r6
	 * [%sp+ 9]:r7
	 * [%sp+10]:r8
	 * [%sp+11]:r9
	 * [%sp+12]:r10
	 * [%sp+13]:r11
	 * [%sp+14]:r12
	 * [%sp+15]:r13
	 * [%sp+16]:r14
	 * [%sp+17]:r15
	 * [%sp+18]:psr
	 * [%sp+19]:pc
	 */
	asm("
	 ld.w %r0, [%sp+18]		; psr
	xld.w %r3, gsm_info
	 ld.w %r4, [%r3]+		; old_isr
	xld.w %r1, gsm_fill_busy
	xld.w %r2, gsm_isr_ret_busy
	btst [%r3], 0			; busy?
	jrne gsm_isr_busy
	xld.w %r1, gsm_fill
	xld.w %r2, gsm_isr_ret
	bset [%r3], 0			; busy <- 1
gsm_isr_busy:
	pushn %r2
	");
	/* %r3     :&busy
	 * %r4     :old_isr
	 * [%sp+ 0]:psr
	 * [%sp+ 1]:gsm_fill/busy
	 * [%sp+ 2]:gsm_isr_ret/busy
	 * [%sp+ 3]:alr
	 * [%sp+ 4]:ahr
	 * [%sp+ 5]:r0
	 * [%sp+ 6]:r1
	 * [%sp+ 7]:r2
	 * [%sp+ 8]:r3
	 * [%sp+ 9]:r4
	 * [%sp+10]:r5
	 * [%sp+11]:r6
	 * [%sp+12]:r7
	 * [%sp+13]:r8
	 * [%sp+14]:r9
	 * [%sp+15]:r10
	 * [%sp+16]:r11
	 * [%sp+17]:r12
	 * [%sp+18]:r13
	 * [%sp+19]:r14
	 * [%sp+20]:r15
	 * [%sp+21]:psr
	 * [%sp+22]:pc
	 */
	asm("
	jp %r4				; * old_isr->(iret)->gsm_fill/busy->(ret)->gsm_isr_ret/busy
					;   Ԃ̊荞݋֎~h߁Aold_isrretiƂ
					;   荞ݔpsr(ĂIE=1)𕜌Ă܂B
					; * 荞݃[`ł̓tOۑKv̂ŁA
					;   gsm_isrAƂretł͂ȂretigȂ΂܂B
					;   ܂A荞ݔpsrA񕜌Ă܂B
gsm_isr_ret:
	bclr [%r3], 0			; S1C33̊֐KɂAr3͕ێĂ͂B
gsm_isr_ret_busy:
	");
	/* [%sp+ 0]:alr
	 * [%sp+ 1]:ahr
	 * [%sp+ 2]:r0
	 * [%sp+ 3]:r1
	 * [%sp+ 4]:r2
	 * [%sp+ 5]:r3
	 * [%sp+ 6]:r4
	 * [%sp+ 7]:r5
	 * [%sp+ 8]:r6
	 * [%sp+ 9]:r7
	 * [%sp+10]:r8
	 * [%sp+11]:r9
	 * [%sp+12]:r10
	 * [%sp+13]:r11
	 * [%sp+14]:r12
	 * [%sp+15]:r13
	 * [%sp+16]:r14
	 * [%sp+17]:r15
	 * [%sp+18]:psr
	 * [%sp+19]:pc
	 */
	asm("
	popn %r1
	ld.w %ahr, %r1
	ld.w %alr, %r0
	popn %r15
	");
	/* [%sp+ 0]:psr
	 * [%sp+ 1]:pc
	 */
	asm("
	reti
	");
}

static void
gsm_fill()
{
	GSMINFO* gi = &gsm_info;

	int retval, n, c;
	short s, *dst, *src;

	while(gi->bc != 0) {
		/* 󂫃ubN̐擪AhXƁAWJGSMTv܂B
		 * * 8KHzGSMf[^A16KHzWAVEf[^ɕϊȂWĴŁA
		 *   WJGSMTv́AubÑTv̔ƂȂ܂B
		 */
		n = BLKS / 2;
		dst = &gi->wb[(int)gi->bi][0];

		/* [vȂ... */
		if(gi->loop != 0) {
			/* WAVEf[^쐬܂B */
			do {
				if(gi->rest == 0) {
					/* GSMt[ǂݍ݂܂B */
					retval = file_read(&gi->fa, gi->gf, gi->ofs, sizeof(gsm_frame));

					/* ̓ǂݍ݈ʒui߂܂B */
					gi->ofs += retval;

					/* GSMt[ǂݍ߂... */
					if(retval == sizeof(gsm_frame)) {
						/* GSMt[WJ܂B */
						retval = gsm_decode(gi->g, gi->gf, gi->gs);
						if(retval != 0) {
							/* WJɎsAɂ܂B(ĂH) */
							memset(gi->gs, 0, sizeof(gsm_signal) * GSMS);
						}
					/* t@CI[Ȃ... */
					} else if(retval == 0) {
						/* loop < 0 ... [vȂ̂ŁA߂B
						 * loop = 0 ... ɒ~Ă̂ŁAɂB
						 * loop = 1 ... loop0(=~)ɂāAɂB
						 * loop > 1 ... loop1炵āA߂B
						 */
						if(gi->loop < 0 || (gi->loop != 0 && --gi->loop != 0)) {
							gi->ofs = 0;
							continue;
						} else {
							memset(gi->gs, 0, sizeof(gsm_signal) * GSMS);
						}
					/* GSMt[r[ɓǂݍ߂... */
					} else {
						/* ɂ܂B(ĂH) */
						memset(gi->gs, 0, sizeof(gsm_signal) * GSMS);
					}

					/* WJf[^̑STvLłB */
					gi->rest = GSMS;
				}

				/* GSMt[WJobt@(8KHz)WAVEf[^(16KHz)փRs[܂B */
				src = &gi->gs[GSMS - gi->rest];
				if(n <= gi->rest) {
					c = n;
					n = 0;
					gi->rest -= c;
				} else {
					c = gi->rest;
					n -= c;
					gi->rest = 0;
				}
				do {
					s = *src++;
					*dst++ = s;
					*dst++ = s;
				} while(--c != 0);
			} while(n != 0);

		/* Ƀ[vIĂ... */
		} else {
			/* ɂ܂B */
			do {
				*dst++ = 0;
				*dst++ = 0;
			} while(--n != 0);
		}

		/* 󂫃ubN̐擪CfNXi߂܂B */
		if(++gi->bi == BLKN) gi->bi = 0;

		/* 󂫃ubN炵܂B
		 * * gsm_fill()gsm_endproc()Ɋ荞܂\̂ŁA
		 *   u󂫃ubN擾1炷i[v̏̑OŊ荞ݐ䂪KvłB
		 * * gsm_isr()oRł̊֐Ă΂ꂽ́A荞݋Ԃ͕sȂ̂ŁA
		 *   PDISABLE/ENABLEł͂ȂAԑޔE֎~EsKv܂B
		 * * 悭lAgsm_isr()oRŌĂ΂ꂽ́A荞݋Ɍ܂Ă悤ȋCĂ܂B
		 *   gsm_isr()͍DMÅ荞݃nhȂ̂łA
		 *   gsm_isr()Ă΂ꂽDMÅ荞݂ꂽ荞݂ĂB
		 * * Ƃ킯ŁAPDISABLE/ENABLEłvm܂B
		 *   ܂AԑޔE֎~EmAȂƂQ͂Ȃ̂ŁÂ܂܂ɂĂ܂B
		 */
		asm("
		pushn %r2
		ld.w %r0, %psr			; %psrۑ
		xand %r1, %r0, 0xffffffef	; 荞݋֎~
		ld.w %psr, %r1
		xld.w %r1, gsm_info + 5		; gsm_info.bc--
		ld.b %r2, [%r1]
		sub %r2, 1
		ld.b [%r1], %r2
		ld.w %psr, %r0			; %psr
		popn %r2
		");
	}
}

static void
gsm_fill_busy()
{
	/* ܂B */
}

static void
gsm_endproc(PCEWAVEINFO* wi)
{
	GSMINFO* gi = &gsm_info;

	/* 󂫃ubN𑝂₵܂B
	 * * PCEWAVEINFO.pfEndProc͊荞݋ԂŌĂ΂܂A
	 *   TEhhCoɂčē֎~Ă̂ŁA
	 *   ugi->bc++v̑Oł̊荞ݐ͕Kv܂B
	 * * ē֎~́Asound_isr3()̌㔼ōsĂ܂B
	 *   isnd.c 421`430sQƁABIOS 1.18݁j
	 */
	gi->bc++;
}
