/*	
 *	clipuio.c
 *
 *	USB I/O (oN]ɂAPI/O)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Jul 08 06:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sat Jul 09 23:23:00 JST 2005 Naoyuki Sawa
 *	- uio_stat()ǉ܂B
 *	* Sun Jul 31 02:03:00 JST 2005 Naoyuki Sawa
 *	- SET_ADDRESSclipusb.cɓ̂ŁAʂ͕̎svƂȂ܂B
 *	* Sun Jul 31 05:41:00 JST 2005 Naoyuki Sawa
 *	- PceComhCǒɔAMf[^ꍇ̂ݑM悤ύX܂B
 *	@܂ł́AMf[^ꍇA[oCg̃pPbg𑗐MdlłB
 *	- M荞ݔɁAMobt@󂾂ꍇɂ̂݁AMR[obNs悤ύX܂B
 *	  ܂ł́A1pPbgM(0oCgpPbg̑M܂)ɑMR[obNsĂ܂B
 *	* Mon Aug 01 20:26:00 JST 2005 Naoyuki Sawa
 *	- XgOfBXNv^ǉ܂B
 *	* Mon Aug 15 04:11:00 JST 2005 Naoyuki Sawa
 *	- XgOfBXNv^̒`ɊւRgǋL܂B
 *	  u񒆂[0-7]܂ނƁA'\0'̑ƌȂ̂ŁAӂĂBv
 *	* Mon Aug 22 04:24:00 JST 2005 Naoyuki Sawa
 *	- uio_open(),uio_close()->uio_start(),uio_stop()ɖOύX܂B
 *	- usb_init(),usb_free()->usb_start(),usb_stop()̖OύXɒǏ]܂B
 *	* Sat Dec 08 00:00:11 JST 2007 Naoyuki Sawa
 *	- clipusb̎dlύXz܂B
 *	  MI[o[\Ƃ邽߂̎dlύXłA{W[͑ΉĂ܂B
 *	  clipusb̎dlύX{W[ŋẑŁA{W[̋@\͂܂łǂłB
 *	  {W[AMI[o[ւ̕ύX́AAKvƂɍs\łB
 */
#include "clip.h"

/****************************************************************************
 *	fBXNv^`
 ****************************************************************************/

/* foCXfBXNv^ */
static const DEVICE_DESCRIPTOR device_desc = {
	bLength:		sizeof(DEVICE_DESCRIPTOR),
	bDescriptorType:	DEVICE_DESCRIPTOR_TYPE,
	bcdUSB:			0x0110,
	bMaxPacketSize0:	EP0_PACKET_SIZE,
	idVendor:		PCE_VENDOR_ID,
	idProduct:		UIO_PRODUCT_ID,				/* d֎~!! */
	bcdDevice:		0x0001,
	iManufacture:		1,
	iProduct:		2,
	bNumConfigurations:	1,
};

/* RtBM[VfBXNv^ */
static const CONFIGURATION_DESCRIPTOR config_desc = {
	bLength:		sizeof(CONFIGURATION_DESCRIPTOR),
	bDescriptorType:	CONFIGURATION_DESCRIPTOR_TYPE,
	wTotalLength:		sizeof(CONFIGURATION_DESCRIPTOR) +	/* config_desc */
				sizeof(INTERFACE_DESCRIPTOR    ) +	/* interface_desc */
				sizeof(ENDPOINT_DESCRIPTOR     ) +	/* endpoint_desc_ep2in */
				sizeof(ENDPOINT_DESCRIPTOR     ),	/* endpoint_desc_ep2out */
	bNumInterfaces:		1,
	bConfigurationValue:	1,
	iConfiguration:		3,
	bmAttributes:		0x80,					/* Bus-powered */
	MaxPower:		100 / 2,				/* 100[mA] () */
};

/* C^[tFCXfBXNv^ */
static const INTERFACE_DESCRIPTOR interface_desc = {
	bLength:		sizeof(INTERFACE_DESCRIPTOR),
	bDescriptorType:	INTERFACE_DESCRIPTOR_TYPE,
	bNumEndpoints:		2,
	bInterfaceClass:	0xff,					/* Vendor-specific */
	bInterfaceSubClass:	0xff,					/* Vendor-specific */
	bInterfaceProtocol:	0xff,					/* Vendor-specific */
	iInterface:		4,
};

/* Gh|CgfBXNv^
 * * P/ECERpC̕s΍̂߁Aendpoint_desc\̔zɂȂ悤!!
 *   ڂ́Aclip/clipusb.h̃RgQƂĂB
 */
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2in = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x82,					/* EP2IN */
	bAttributes:		2,					/* Bulk */
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
};
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2out = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x02,					/* EP2OUT */
	bAttributes:		2,					/* Bulk */
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
};

/* XgOfBXNv^
 * * gcćAL"..."`16bit UNICODEg܂B(32bitɂȂĂ܂܂)
 *   Ȃ̂ŁA1oCgÂLq܂B
 * * 񒆂[0-7]܂ނƁA'\0'̑ƌȂ̂ŁAӂĂB
 */
static const char* const string_desc[] = {
//	   ++-- 04 06 08 0a 0c 0e 10 12 14 16 18 1a 1c 1e 20 22 24 26 28 2a 2c 2e 30
//	   ||
//	"\x??\3_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0"
	"\x04\3\x09\x04",								// 0: wLANGID = 0x0409 English (United States)
	"\x16\3P\0i\0e\0c\0e\0 \0L\0a\0b\0.\0",						// 1: iManufacture   = "Piece Lab."
	"\x22\3P\0/\0E\0C\0E\0 \0U\0S\0B\0 \0d\0e\0v\0i\0c\0e\0",			// 2: iProduct       = "P/ECE USB device"
	"\x2c\3U\0S\0B\0 \0I\0/\0O\0 \0c\0o\0n\0f\0i\0g\0u\0r\0a\0t\0i\0o\0n\0",	// 3: iConfiguration = "USB I/O configuration"
	"\x24\3U\0S\0B\0 \0I\0/\0O\0 \0i\0n\0t\0e\0r\0f\0a\0c\0e\0",			// 4: iInterface     = "USB I/O interface"
};

/****************************************************************************
 *	
 ****************************************************************************/

/* hCo\ */
typedef struct _UIO {
	unsigned char* rxbuf/*[rxcap]*/;	/* Mobt@([pos]`[(pos+len-1)%cap]܂ŗL) */
	int rxcap;				/* Mobt@LpVeB */
	int rxpos;				/* Mf[^̐擪ʒu */
	int rxlen;				/* Mf[^TCY */
	int rxlog;				/* Mf[^oCg(fobOp) */
	int rxerr;				/* MI[o[oCg */
	void (*rxdone)();			/* MR[obN(NULL:) */
	//
	unsigned char* txbuf/*[txcap]*/;	/* Mobt@([pos]`[(pos+len-1)%cap]܂ŗL) */
	int txcap;				/* Mobt@LpVeB */
	int txpos;				/* Mf[^̐擪ʒu */
	int txlen;				/* Mf[^TCY */
	int txlog;				/* Mf[^oCg(fobOp) */
	int txing;				/* M~Ȃ0AM쒆Ȃ1 */
	void (*txdone)();			/* MR[obN(NULL:) */
} UIO;
static UIO uio;

static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
//{{2007/12/08:clipusb̎dlύXz
//static void ep2_rxdone(const unsigned char dat[/*len*/], int len);
//2007/12/08:clipusb̎dlύXz
static void ep2_rxdone();
static void ep2_rxsub(const unsigned char dat[/*len*/], int len);
//}}2007/12/08:clipusb̎dlύXz
static void ep2_txdone();
static void ep2_txsub();

/* USBtbN */
static const USBINF usb_inf = {
	/* USBC mode */
	mode:			D12_ENDP_NONISO,
	/* USBC raw event */
	ep2_rxdone:		ep2_rxdone,
	ep2_txdone:		ep2_txdone,
	/* Device request */
	get_descriptor:		get_descriptor,
	set_configuration:	set_configuration,
	set_interface:		set_interface,
};

/****************************************************************************
 *	
 ****************************************************************************/

static void
get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	static unsigned char tmpbuf[sizeof config_desc /* rs`shbłI */
				  + sizeof interface_desc
				  + sizeof endpoint_desc_ep2in
				  + sizeof endpoint_desc_ep2out];
	//
	int type  = HIBYTE(req->wValue);
	int index = LOBYTE(req->wValue);

	/* vꂽfBXNv^ԑ܂B */
	switch(type) {
	case DEVICE_DESCRIPTOR_TYPE:
		usb_ep0_tx(&device_desc, sizeof device_desc);
		return;
	case CONFIGURATION_DESCRIPTOR_TYPE:
		switch(index) {
		case 0:
			len = 0;
			memcpy(&tmpbuf[len], &config_desc         , sizeof config_desc         ); len += sizeof config_desc         ;
			memcpy(&tmpbuf[len], &interface_desc      , sizeof interface_desc      ); len += sizeof interface_desc      ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep2in , sizeof endpoint_desc_ep2in ); len += sizeof endpoint_desc_ep2in ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep2out, sizeof endpoint_desc_ep2out); len += sizeof endpoint_desc_ep2out;
			usb_ep0_tx(tmpbuf, len);
			return;
		}
		break;
	case STRING_DESCRIPTOR_TYPE:
		if(index < ARRAY_SIZE(string_desc)) {
			usb_ep0_tx(string_desc[index], string_desc[index][0]);
			return;
		}
		break;
	}
	usb_ep0_stall(); /* Ή */
}

static void
set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	/* RtBO[V#1(ꂵ܂)IꂽACGh|CgLɂ܂B */
	D12_SetEndpointEnable(req->wValue == 1);
	usb_ep0_tx(NULL, 0); /* ACK */
}

static void
set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	/* C^[tFCX̑֐ݒ͂ЂƂȂ̂ŁA܂B */
	usb_ep0_tx(NULL, 0); /* ACK */
}

/****************************************************************************
 *	
 ****************************************************************************/

//{{2007/12/08:clipusb̎dlύXz
static void
ep2_rxdone()
{
	int len;
	unsigned char dat[EP2_NONISO_PACKET_SIZE];
	for(;;) { /* _uobt@ɓpPbgSď */
		len = D12_ReadBuffer(EP2OUT, dat, sizeof dat);
		if(len == -1) break;
		D12_ClearBuffer(EP2OUT);
		ep2_rxsub(dat, len);
	}
}
//}}2007/12/08:clipusb̎dlύXz

//{{2007/12/08:clipusb̎dlύXz
//static void
//ep2_rxdone(const unsigned char dat[/*len*/], int len)
//2007/12/08:clipusb̎dlύXz
static void
ep2_rxsub(const unsigned char dat[/*len*/], int len)
//}}2007/12/08:clipusb̎dlύXz
{
	int pos;
	int i;

	/* pPbg̎MȂ΁AɋA܂B */
	if(!len) {
		return;
	}

	/* Rs[f[^TCYAMobt@̋󂫃TCYɐ؂l߂܂B */
	if(len > (uio.rxcap - uio.rxlen)) {
		uio.rxerr += len - (uio.rxcap - uio.rxlen); /* I[o[ */
		             len = (uio.rxcap - uio.rxlen);
	}

	/* MpPbgAMobt@̃f[^փRs[܂B */
	pos = uio.rxpos + uio.rxlen;
	if(pos >= uio.rxcap) {
		pos -= uio.rxcap;
	}
	for(i = 0; i < len; i++) {
		uio.rxbuf[pos++] = *dat++;
		if(pos == uio.rxcap) {
			pos = 0;
		}
	}

	/* Rs[AMobt@̗LTCY𑝂₵܂B */
	uio.rxlen += len;

	/* MR[obNݒ肳ĂAʒm܂B */
	if(uio.rxdone) {
		uio.rxdone();
	}
}

static void
ep2_txdone()
{
	/* Mf[^cĂ... */
	if(uio.txlen) {

		/* Mf[^Gh|Cg֏݂܂B */
		ep2_txsub();

	/* Mf[^Ȃ... */
	} else {

		/* M~}[N܂B(MR[obNɍsƁBK{!!) */
		uio.txing = 0;

		/* MR[obNݒ肳ĂAʒm܂B */
		if(uio.txdone) {
			uio.txdone();
			/* R[obN̒uio_send()Ă΂ꂽꍇAtxing=1ɖ߂Ă܂B */
		}
	}
}

static void
ep2_txsub()
{
	unsigned char dat[EP2_NONISO_PACKET_SIZE];
	int len;
	int i;

	/* Rs[f[^TCYAMobt@̗LTCYɐ؂l߂܂B */
	len = EP2_NONISO_PACKET_SIZE;
	if(len > uio.txlen) {
		len = uio.txlen;
	}

	/* Mobt@̃f[^擪AMpPbgփRs[܂B */
	for(i = 0; i < len; i++) {
		dat[i] = uio.txbuf[uio.txpos++];
		if(uio.txpos == uio.txcap) {
			uio.txpos = 0;
		}
	}

	/* Rs[AMobt@̗LTCY炵܂B */
	uio.txlen -= len;

	/* pPbg𑗐M܂B */
//{{2007/12/08:clipusb̎dlύXz
//	D12_WriteEndpoint(EP2IN, dat, len);
//2007/12/08:clipusb̎dlύXz
	D12_WriteBuffer(EP2IN, dat, len);
	D12_ValidateBuffer(EP2IN);
//}}2007/12/08:clipusb̎dlύXz
}

/****************************************************************************
 *	
 ****************************************************************************/

void
uio_start(int rxcap, int txcap, void (*rxdone)(), void (*txdone)())
{
	/* ܂Amɐؒf܂B */
	uio_stop();

	/* hCo\̂NA܂B */
	memset(&uio, 0, sizeof uio);

	/* Mobt@mۂ܂B */
	if(rxcap < EP2_NONISO_PACKET_SIZE) {
		rxcap = EP2_NONISO_PACKET_SIZE;
	}
	uio.rxcap = rxcap;
	uio.rxbuf = malloc(rxcap);
	if(!uio.rxbuf) {
		DIE();
	}
	uio.rxdone = rxdone; /* MR[obNA܂́ANULLi[ */

	/* Mobt@mۂ܂B */
	if(txcap < EP2_NONISO_PACKET_SIZE) {
		txcap = EP2_NONISO_PACKET_SIZE;
	}
	uio.txcap = txcap;
	uio.txbuf = malloc(txcap);
	if(!uio.txbuf) {
		DIE();
	}
	uio.txdone = txdone; /* MR[obNA܂́ANULLi[ */

	/* USBtbN܂B */
	usb_start(&usb_inf);
}

void
uio_stop()
{
	/* USB̃tbN܂B */
	usb_stop();

	/* Mobt@J܂B */
	free(uio.rxbuf); /* free(0)͈S */

	/* Mobt@J܂B */
	free(uio.txbuf); /* free(0)͈S */

	/* hCo\̂NA܂B */
	memset(&uio, 0, sizeof uio);
}

void
uio_reset()
{
ENTER_CS;

	/* Mobt@AoCgAI[o[NA܂B */
	uio.rxpos = 0;
	uio.rxlen = 0;
	uio.rxlog = 0;
	uio.rxerr = 0;

	/* Mobt@AoCgNA܂B */
	uio.txpos = 0;
	uio.txlen = 0;
	uio.txlog = 0;
	/*uio.txing͕ύX܂*/

LEAVE_CS;
}

int
uio_recv(void* _dat, int len)
{
	unsigned char* dat = _dat;
	int i;

	/* 0oCg̎MvłAȉ̏p܂B
	 * 0oCg̎MvłAMI[o[̗L͎擾ł邩łB
	 */

ENTER_CS;

	if(!uio.rxerr) {

		/* Rs[f[^TCYAMobt@̗LTCYɐ؂l߂܂B */
		if(len > uio.rxlen) {
			len = uio.rxlen;
		}

		/* Mobt@̃f[^擪A[U[obt@փRs[܂B */
		for(i = 0; i < len; i++) {
			*dat++ = uio.rxbuf[uio.rxpos++];
			if(uio.rxpos == uio.rxcap) {
				uio.rxpos = 0;
			}
		}

		/* Rs[AMobt@̗LTCY炵܂B */
		uio.rxlen -= len;

		/* MoCgJEgAbv܂B */
		uio.rxlog += len;

	} else {

		/* MI[o[ĂA|(oCg)߂lƂ܂B */
		len = -uio.rxerr;
	}

LEAVE_CS;

	return len;
}

int
uio_send(const void* _dat, int len)
{
	const unsigned char* dat = _dat;
	int pos;
	int i;

	/* Mf[^TCYɕlw肳ĂAAsciiZƌȂ܂B */
	if(len < 0) {
		len = strlen((char*)dat);
	}

ENTER_CS;

	/* Rs[f[^TCYAMobt@̋󂫃TCYɐ؂l߂܂B */
	if(len > (uio.txcap - uio.txlen)) {
		len = (uio.txcap - uio.txlen);
	}

	/* Mobt@ɒǉ\ȃf[^... */
	if(len) {

		/* [U[obt@AMobt@̃f[^փRs[܂B */
		pos = uio.txpos + uio.txlen;
		if(pos >= uio.txcap) {
			pos -= uio.txcap;
		}
		for(i = 0; i < len; i++) {
			uio.txbuf[pos++] = *dat++;
			if(pos == uio.txcap) {
				pos = 0;
			}
		}

		/* Rs[AMobt@̗LTCY𑝂₵܂B */
		uio.txlen += len;

		/* MoCgJEgAbv܂B */
		uio.txlog += len;

		/* M~Ȃ... */
		if(!uio.txing) {

			/* M쒆}[N܂B */
			uio.txing = 1;

			/* Mf[^Gh|Cgɏ݂܂Bȍ~́Aep2_txdone()ŘA܂B */
			ep2_txsub();
		}
	}

LEAVE_CS;

	return len;
}

void
uio_stat(UIOSTAT* stat)
{
ENTER_CS;

	stat->rxlen = uio.rxlen;
	stat->rxlog = uio.rxlog;
	stat->rxerr = uio.rxerr;
	stat->txlen = uio.txlen;
	stat->txlog = uio.txlog;

LEAVE_CS;
}
