/*	
 *	clipmp3a.c
 *
 *	P/ECE MP3 Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Tue Oct 28 08:11:00 JST 2003 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Nov 12 05:25:00 JST 2003 Naoyuki Sawa
 *	- CLiPCuֈړB
 */
#include "clip.h"

/****************************************************************************
 *	ID3 Tag V1
 ****************************************************************************/

const char* mp3_id3_tag_v1_genre_table[/*MP3ID3TAGV1.genre*/] = {
	/*  0*/	"Blues",
	/*  1*/	"Classic Rock",
	/*  2*/	"Country",
	/*  3*/	"Dance",
	/*  4*/	"Disco",
	/*  5*/	"Funk",
	/*  6*/	"Grunge",
	/*  7*/	"Hip-Hop",
	/*  8*/	"Jazz",
	/*  9*/	"Metal",
	/* 10*/	"New Age",
	/* 11*/	"Oldies",
	/* 12*/	"Other",
	/* 13*/	"Pop",
	/* 14*/	"R&B",
	/* 15*/	"Rap",
	/* 16*/	"Reggae",
	/* 17*/	"Rock",
	/* 18*/	"Techno",
	/* 19*/	"Industrial",
	/* 20*/	"Alternative",
	/* 21*/	"Ska",
	/* 22*/	"Death Metal",
	/* 23*/	"Pranks",
	/* 24*/	"Soundtrack",
	/* 25*/	"Euro-Techno",
	/* 26*/	"Ambient",
	/* 27*/	"Trip-Hop",
	/* 28*/	"Vocal",
	/* 29*/	"Jazz+Funk",
	/* 30*/	"Fusion",
	/* 31*/	"Trance",
	/* 32*/	"Classical",
	/* 33*/	"Instrumental",
	/* 34*/	"Acid",
	/* 35*/	"House",
	/* 36*/	"Game",
	/* 37*/	"Sound Clip",
	/* 38*/	"Gospel",
	/* 39*/	"Noise",
	/* 40*/	"AlternRock",
	/* 41*/	"Bass",
	/* 42*/	"Soul",
	/* 43*/	"Punk",
	/* 44*/	"Space",
	/* 45*/	"Meditative",
	/* 46*/	"Instrumental Pop",
	/* 47*/	"Instrumental Rock",
	/* 48*/	"Ethnic",
	/* 49*/	"Gothic",
	/* 50*/	"Darkwave",
	/* 51*/	"Techno-Industrial",
	/* 52*/	"Electronic",
	/* 53*/	"Pop-Folk",
	/* 54*/	"Eurodance",
	/* 55*/	"Dream",
	/* 56*/	"Southern Rock",
	/* 57*/	"Comedy",
	/* 58*/	"Cult",
	/* 59*/	"Gangsta",
	/* 60*/	"Top 40",
	/* 61*/	"Christian Rap",
	/* 62*/	"Pop/Funk",
	/* 63*/	"Jungle",
	/* 64*/	"Native American",
	/* 65*/	"Cabaret",
	/* 66*/	"New Wave",
	/* 67*/	"Psychadelic",
	/* 68*/	"Rave",
	/* 69*/	"Showtunes",
	/* 70*/	"Trailer",
	/* 71*/	"Lo-Fi",
	/* 72*/	"Tribal",
	/* 73*/	"Acid Punk",
	/* 74*/	"Acid Jazz",
	/* 75*/	"Polka",
	/* 76*/	"Retro",
	/* 77*/	"Musical",
	/* 78*/	"Rock & Roll",
	/* 79*/	"Hard Rock",
	/* 80*/	"Folk",
	/* 81*/	"Folk-Rock",
	/* 82*/	"National Folk",
	/* 83*/	"Swing",
	/* 84*/	"Fast Fusion",
	/* 85*/	"Bebob",
	/* 86*/	"Latin",
	/* 87*/	"Revival",
	/* 88*/	"Celtic",
	/* 89*/	"Bluegrass",
	/* 90*/	"Avantgarde",
	/* 91*/	"Gothic Rock",
	/* 92*/	"Progressive Rock",
	/* 93*/	"Psychedelic Rock",
	/* 94*/	"Symphonic Rock",
	/* 95*/	"Slow Rock",
	/* 96*/	"Big Band",
	/* 97*/	"Chorus",
	/* 98*/	"Easy Listening",
	/* 99*/	"Acoustic",
	/*100*/	"Humour",
	/*101*/	"Speech",
	/*102*/	"Chanson",
	/*103*/	"Opera",
	/*104*/	"Chamber Music",
	/*105*/	"Sonata",
	/*106*/	"Symphony",
	/*107*/	"Booty Bass",
	/*108*/	"Primus",
	/*109*/	"Porn Groove",
	/*110*/	"Satire",
	/*111*/	"Slow Jam",
	/*112*/	"Club",
	/*113*/	"Tango",
	/*114*/	"Samba",
	/*115*/	"Folklore",
	/*116*/	"Ballad",
	/*117*/	"Power Ballad",
	/*118*/	"Rhythmic Soul",
	/*119*/	"Freestyle",
	/*120*/	"Duet",
	/*121*/	"Punk Rock",
	/*122*/	"Drum Solo",
	/*123*/	"Acapella",
	/*124*/	"Euro-House",
	/*125*/	"Dance Hall",
};

/****************************************************************************
 *	t[wb_
 ****************************************************************************/

/* FRAMEHEADER.bitrate_index => rbg[g ϊ\ */
const int mp3_bitrate_table[16/*bitrate_index*/] = { /* for LayerIII */
	/* 0*/	     0,
	/* 1*/	 32000,
	/* 2*/	 40000,
	/* 3*/	 48000,
	/* 4*/	 56000,
	/* 5*/	 64000,
	/* 6*/	 80000,
	/* 7*/	 96000,
	/* 8*/	112000,
	/* 9*/	128000,
	/*10*/	160000,
	/*11*/	192000,
	/*12*/	224000,
	/*13*/	256000,
	/*14*/	320000,
	/*15*/	     0,
};

/* FRAMEHEADER.sampling_frequency => TvOg ϊ\ */
const int mp3_sampling_frequency_table[4/*sampling_frequency*/] = {
	/*0*/	44100,
	/*1*/	48000,
	/*2*/	32000,
	/*3*/	    0,
};

/****************************************************************************
 *	XP[t@N^
 ****************************************************************************/

/* MP3GRANULEINFO.scalefac_compress => slen1, slen2 */
const short mp3_scalefactor_compress_table[16/*MP3GRANLEINFO.scalefac_compress*/][2/*0:slen1/1:slen2*/] = {
	/* 0*/	{ 0, 0 },
	/* 1*/	{ 0, 1 },
	/* 2*/	{ 0, 2 },
	/* 3*/	{ 0, 3 },
	/* 4*/	{ 3, 0 },
	/* 5*/	{ 1, 1 },
	/* 6*/	{ 1, 2 },
	/* 7*/	{ 1, 3 },
	/* 8*/	{ 2, 1 },
	/* 9*/	{ 2, 2 },
	/*10*/	{ 2, 3 },
	/*11*/	{ 3, 1 },
	/*12*/	{ 3, 2 },
	/*13*/	{ 3, 3 },
	/*14*/	{ 4, 2 },
	/*15*/	{ 4, 3 },
};

/* eXP[t@N^ohɑΉA擪f[^CfNX */
const short mp3_scalefactor_band_index_table[3/*0:44.1KHz/1:48KHz/2:32KHz*/][2/*0:LongBlock/1:ShortBlock*/][22/*ScaleFactorBand*/ + 1/*END*/] = {
	/*  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21 END */
	{{  0,  4,  8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90,110,134,162,196,238,288,342,418,576},  /* MP3FRAMEHEADER.sampling_frequency=0(44.1KHz) Long  Block */
	 {  0,  4,  8, 12, 16, 22, 30, 40, 52, 66, 84,106,136,192                                    }}, /*                                              Short Block */
	{{  0,  4,  8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88,106,128,156,190,230,276,330,384,576},  /* MP3FRAMEHEADER.sampling_frequency=1(48  KHz) Long  Block */
	 {  0,  4,  8, 12, 16, 22, 28, 38, 50, 64, 80,100,126,192                                    }}, /*                                              Short Block */
	{{  0,  4,  8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82,102,126,156,194,240,296,364,448,550,576},  /* MP3FRAMEHEADER.sampling_frequency=2(32  KHz) Long  Block */
	 {  0,  4,  8, 12, 16, 22, 30, 42, 58, 78,104,138,180,192                                    }}, /*                                              Short Block */
};

/****************************************************************************
 *	nt}
 ****************************************************************************/

static const short mp3_huffman_bigvalue_table1[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   2, -16},
	/*  2*/	{ -17,  -1},
};
static const short mp3_huffman_bigvalue_table2[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   3,   2},
	/*  2*/	{  -1, -16},
	/*  3*/	{   4, -17},
	/*  4*/	{   5,   7},
	/*  5*/	{   6, -18},
	/*  6*/	{ -34,  -2},
	/*  7*/	{ -33, -32},
};
static const short mp3_huffman_bigvalue_table3[][2] = {
	/*  0*/	{   2,   1},
	/*  1*/	{  -1,   0},
	/*  2*/	{   3, -17},
	/*  3*/	{   4, -16},
	/*  4*/	{   5,   7},
	/*  5*/	{   6, -18},
	/*  6*/	{ -34,  -2},
	/*  7*/	{ -33, -32},
};
static const short mp3_huffman_bigvalue_table5[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   3,   2},
	/*  2*/	{  -1, -16},
	/*  3*/	{   4, -17},
	/*  4*/	{   7,   5},
	/*  5*/	{  10,   6},
	/*  6*/	{  -2, -32},
	/*  7*/	{  12,   8},
	/*  8*/	{   9,  11},
	/*  9*/	{ -19,  -3},
	/* 10*/	{ -18, -33},
	/* 11*/	{ -48, -34},
	/* 12*/	{  13, -49},
	/* 13*/	{  14, -50},
	/* 14*/	{ -51, -35},
};
static const short mp3_huffman_bigvalue_table6[][2] = {
	/*  0*/	{   3,   1},
	/*  1*/	{ -17,   2},
	/*  2*/	{ -16,   0},
	/*  3*/	{   5,   4},
	/*  4*/	{  13,  -1},
	/*  5*/	{   8,   6},
	/*  6*/	{   7, -18},
	/*  7*/	{ -34,  -2},
	/*  8*/	{   9,  12},
	/*  9*/	{  10,  14},
	/* 10*/	{  11, -35},
	/* 11*/	{ -51,  -3},
	/* 12*/	{ -19, -49},
	/* 13*/	{ -33, -32},
	/* 14*/	{ -50, -48},
};
static const short mp3_huffman_bigvalue_table7[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   3,   2},
	/*  2*/	{  -1, -16},
	/*  3*/	{   7,   4},
	/*  4*/	{   5, -17},
	/*  5*/	{ -33,   6},
	/*  6*/	{  -2, -32},
	/*  7*/	{  13,   8},
	/*  8*/	{   9,  18},
	/*  9*/	{  10,  19},
	/* 10*/	{  12,  11},
	/* 11*/	{ -50,  -3},
	/* 12*/	{  -4, -35},
	/* 13*/	{  14,  20},
	/* 14*/	{  22,  15},
	/* 15*/	{  16,  27},
	/* 16*/	{ -81,  17},
	/* 17*/	{  -5, -52},
	/* 18*/	{  24, -18},
	/* 19*/	{ -19, -49},
	/* 20*/	{  21,  31},
	/* 21*/	{  25, -20},
	/* 22*/	{  29,  23},
	/* 23*/	{  26, -21},
	/* 24*/	{ -48, -34},
	/* 25*/	{ -36, -66},
	/* 26*/	{ -37, -82},
	/* 27*/	{ -80,  28},
	/* 28*/	{ -67, -51},
	/* 29*/	{  32,  30},
	/* 30*/	{ -53, -68},
	/* 31*/	{ -65, -64},
	/* 32*/	{  33,  34},
	/* 33*/	{ -85, -69},
	/* 34*/	{ -84, -83},
};
static const short mp3_huffman_bigvalue_table8[][2] = {
	/*  0*/	{   3,   1},
	/*  1*/	{   2,   0},
	/*  2*/	{  -1, -16},
	/*  3*/	{   4, -17},
	/*  4*/	{   5,  19},
	/*  5*/	{  11,   6},
	/*  6*/	{   8,   7},
	/*  7*/	{  -2, -32},
	/*  8*/	{   9, -34},
	/*  9*/	{  20,  10},
	/* 10*/	{  -3, -48},
	/* 11*/	{  15,  12},
	/* 12*/	{  21,  13},
	/* 13*/	{  14,  23},
	/* 14*/	{  -4, -64},
	/* 15*/	{  16,  24},
	/* 16*/	{  26,  17},
	/* 17*/	{  18, -21},
	/* 18*/	{ -82,  -5},
	/* 19*/	{ -18, -33},
	/* 20*/	{ -19, -49},
	/* 21*/	{  22, -65},
	/* 22*/	{ -66, -20},
	/* 23*/	{ -35, -50},
	/* 24*/	{  29,  25},
	/* 25*/	{  28, -36},
	/* 26*/	{  32,  27},
	/* 27*/	{  31, -37},
	/* 28*/	{ -80, -51},
	/* 29*/	{ -81,  30},
	/* 30*/	{ -52, -67},
	/* 31*/	{ -53, -68},
	/* 32*/	{  33, -83},
	/* 33*/	{  34, -69},
	/* 34*/	{ -85, -84},
};
static const short mp3_huffman_bigvalue_table9[][2] = {
	/*  0*/	{   4,   1},
	/*  1*/	{   3,   2},
	/*  2*/	{ -16,   0},
	/*  3*/	{ -17,  -1},
	/*  4*/	{   8,   5},
	/*  5*/	{   6,  26},
	/*  6*/	{   7, -18},
	/*  7*/	{ -34,  -2},
	/*  8*/	{  12,   9},
	/*  9*/	{  21,  10},
	/* 10*/	{ -49,  11},
	/* 11*/	{  -3, -48},
	/* 12*/	{  13,  22},
	/* 13*/	{  17,  14},
	/* 14*/	{  32,  15},
	/* 15*/	{ -67,  16},
	/* 16*/	{ -80,  -4},
	/* 17*/	{  18,  24},
	/* 18*/	{  33,  19},
	/* 19*/	{ -83,  20},
	/* 20*/	{ -84,  -5},
	/* 21*/	{  27, -19},
	/* 22*/	{  28,  23},
	/* 23*/	{ -20, -65},
	/* 24*/	{  30,  25},
	/* 25*/	{ -82, -21},
	/* 26*/	{ -33, -32},
	/* 27*/	{ -35, -50},
	/* 28*/	{  29,  31},
	/* 29*/	{ -36, -66},
	/* 30*/	{ -68, -37},
	/* 31*/	{ -51, -64},
	/* 32*/	{ -81, -52},
	/* 33*/	{  34, -53},
	/* 34*/	{ -85, -69},
};
static const short mp3_huffman_bigvalue_table10[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   3,   2},
	/*  2*/	{  -1, -16},
	/*  3*/	{   7,   4},
	/*  4*/	{   5, -17},
	/*  5*/	{  27,   6},
	/*  6*/	{  -2, -32},
	/*  7*/	{  15,   8},
	/*  8*/	{   9,  28},
	/*  9*/	{  12,  10},
	/* 10*/	{  36,  11},
	/* 11*/	{ -50,  -3},
	/* 12*/	{  13,  30},
	/* 13*/	{  37,  14},
	/* 14*/	{ -51,  -4},
	/* 15*/	{  20,  16},
	/* 16*/	{  31,  17},
	/* 17*/	{  34,  18},
	/* 18*/	{ -96,  19},
	/* 19*/	{  -5, -80},
	/* 20*/	{  41,  21},
	/* 21*/	{  24,  22},
	/* 22*/	{  23, -23},
	/* 23*/	{  -6,  51},
	/* 24*/	{  25,  46},
	/* 25*/	{  26,-112},
	/* 26*/	{-100,  -7},
	/* 27*/	{ -18, -33},
	/* 28*/	{  29,  35},
	/* 29*/	{ -19, -49},
	/* 30*/	{ -20, -65},
	/* 31*/	{  39,  32},
	/* 32*/	{  33,  44},
	/* 33*/	{  38, -21},
	/* 34*/	{ -22, -97},
	/* 35*/	{ -48, -34},
	/* 36*/	{ -64, -35},
	/* 37*/	{ -36, -66},
	/* 38*/	{ -37, -82},
	/* 39*/	{-113,  40},
	/* 40*/	{ -54, -38},
	/* 41*/	{  48,  42},
	/* 42*/	{  52,  43},
	/* 43*/	{ -39,-114},
	/* 44*/	{ -81,  45},
	/* 45*/	{ -52, -67},
	/* 46*/	{ -98,  47},
	/* 47*/	{ -69, -53},
	/* 48*/	{  54,  49},
	/* 49*/	{  58,  50},
	/* 50*/	{-101, -55},
	/* 51*/	{ -83, -68},
	/* 52*/	{  53,  56},
	/* 53*/	{-115, -70},
	/* 54*/	{  59,  55},
	/* 55*/	{  61, -71},
	/* 56*/	{  57, -99},
	/* 57*/	{ -85, -84},
	/* 58*/	{-116, -86},
	/* 59*/	{  62,  60},
	/* 60*/	{-118, -87},
	/* 61*/	{-117,-102},
	/* 62*/	{-119,-103},
};
static const short mp3_huffman_bigvalue_table11[][2] = {
	/*  0*/	{   3,   1},
	/*  1*/	{   2,   0},
	/*  2*/	{  -1, -16},
	/*  3*/	{   7,   4},
	/*  4*/	{   5, -17},
	/*  5*/	{ -18,   6},
	/*  6*/	{  -2, -32},
	/*  7*/	{  16,   8},
	/*  8*/	{  12,   9},
	/*  9*/	{  10, -33},
	/* 10*/	{  11, -34},
	/* 11*/	{  -3, -48},
	/* 12*/	{  13,  29},
	/* 13*/	{  14,  34},
	/* 14*/	{  30,  15},
	/* 15*/	{  -4, -64},
	/* 16*/	{  24,  17},
	/* 17*/	{  18,  35},
	/* 18*/	{  19,  22},
	/* 19*/	{  20, -98},
	/* 20*/	{  21, -21},
	/* 21*/	{ -82,  -5},
	/* 22*/	{  23, -22},
	/* 23*/	{ -38,  -6},
	/* 24*/	{  25,  31},
	/* 25*/	{  49,  26},
	/* 26*/	{  41,  27},
	/* 27*/	{-114,  28},
	/* 28*/	{-100,  -7},
	/* 29*/	{ -19, -49},
	/* 30*/	{ -20, -65},
	/* 31*/	{  32,  38},
	/* 32*/	{-113,  33},
	/* 33*/	{ -23,-112},
	/* 34*/	{ -35, -50},
	/* 35*/	{  44,  36},
	/* 36*/	{  42,  37},
	/* 37*/	{ -36, -66},
	/* 38*/	{  48,  39},
	/* 39*/	{ -96,  40},
	/* 40*/	{ -68, -37},
	/* 41*/	{  46, -39},
	/* 42*/	{ -80,  43},
	/* 43*/	{ -67, -51},
	/* 44*/	{ -97,  45},
	/* 45*/	{ -81, -52},
	/* 46*/	{  52,  47},
	/* 47*/	{ -53, -83},
	/* 48*/	{ -54, -99},
	/* 49*/	{  54,  50},
	/* 50*/	{  51,  53},
	/* 51*/	{  59, -55},
	/* 52*/	{ -69, -84},
	/* 53*/	{-115, -70},
	/* 54*/	{  60,  55},
	/* 55*/	{  56,  57},
	/* 56*/	{-102, -71},
	/* 57*/	{-116,  58},
	/* 58*/	{ -87, -85},
	/* 59*/	{ -86,-101},
	/* 60*/	{  61,  62},
	/* 61*/	{-119,-103},
	/* 62*/	{-118,-117},
};
static const short mp3_huffman_bigvalue_table12[][2] = {
	/*  0*/	{   6,   1},
	/*  1*/	{   2,   4},
	/*  2*/	{   3, -17},
	/*  3*/	{   5,   0},
	/*  4*/	{  -1, -16},
	/*  5*/	{  -2, -32},
	/*  6*/	{  12,   7},
	/*  7*/	{   8,  29},
	/*  8*/	{   9,  38},
	/*  9*/	{  10, -19},
	/* 10*/	{  11, -48},
	/* 11*/	{ -64,  -3},
	/* 12*/	{  18,  13},
	/* 13*/	{  14,  39},
	/* 14*/	{  31,  15},
	/* 15*/	{  16,  30},
	/* 16*/	{  17, -36},
	/* 17*/	{ -80,  -4},
	/* 18*/	{  24,  19},
	/* 19*/	{  20,  33},
	/* 20*/	{  21,  43},
	/* 21*/	{  52,  22},
	/* 22*/	{ -68,  23},
	/* 23*/	{  -6,  -5},
	/* 24*/	{  44,  25},
	/* 25*/	{  36,  26},
	/* 26*/	{  27,  50},
	/* 27*/	{-113,  28},
	/* 28*/	{  -7,-112},
	/* 29*/	{ -18, -33},
	/* 30*/	{ -66, -20},
	/* 31*/	{  32,  48},
	/* 32*/	{ -21, -81},
	/* 33*/	{  34,  41},
	/* 34*/	{ -97,  35},
	/* 35*/	{ -22, -96},
	/* 36*/	{  53,  37},
	/* 37*/	{-100, -23},
	/* 38*/	{ -49, -34},
	/* 39*/	{  47,  40},
	/* 40*/	{ -35, -50},
	/* 41*/	{  49,  42},
	/* 42*/	{ -37, -82},
	/* 43*/	{ -38, -98},
	/* 44*/	{  54,  45},
	/* 45*/	{  51,  46},
	/* 46*/	{  57, -39},
	/* 47*/	{ -51, -65},
	/* 48*/	{ -52, -67},
	/* 49*/	{ -53, -83},
	/* 50*/	{ -54, -99},
	/* 51*/	{ -86, -55},
	/* 52*/	{ -69, -84},
	/* 53*/	{-114, -70},
	/* 54*/	{  58,  55},
	/* 55*/	{  56,  60},
	/* 56*/	{-102, -71},
	/* 57*/	{-115, -85},
	/* 58*/	{  61,  59},
	/* 59*/	{ -87,-117},
	/* 60*/	{-116,-101},
	/* 61*/	{  62,-118},
	/* 62*/	{-119,-103},
};
static const short mp3_huffman_bigvalue_table13[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   4,   2},
	/*  2*/	{   3, -16},
	/*  3*/	{ -17,  -1},
	/*  4*/	{  14,   5},
	/*  5*/	{   8,   6},
	/*  6*/	{  69,   7},
	/*  7*/	{  -2, -32},
	/*  8*/	{  11,   9},
	/*  9*/	{  10,  90},
	/* 10*/	{ -49,  -3},
	/* 11*/	{  12,  70},
	/* 12*/	{ -65,  13},
	/* 13*/	{  -4, -64},
	/* 14*/	{  30,  15},
	/* 15*/	{  20,  16},
	/* 16*/	{  17,  71},
	/* 17*/	{  18,  73},
	/* 18*/	{  94,  19},
	/* 19*/	{ -82,  -5},
	/* 20*/	{  24,  21},
	/* 21*/	{  28,  22},
	/* 22*/	{  74,  23},
	/* 23*/	{  -6, -96},
	/* 24*/	{  25,  95},
	/* 25*/	{  75,  26},
	/* 26*/	{-113,  27},
	/* 27*/	{ -85,  -7},
	/* 28*/	{-129,  29},
	/* 29*/	{  -8,-128},
	/* 30*/	{  41,  31},
	/* 31*/	{  36,  32},
	/* 32*/	{  33,  76},
	/* 33*/	{  78,  34},
	/* 34*/	{  35, 141},
	/* 35*/	{  -9,-144},
	/* 36*/	{  37, 100},
	/* 37*/	{  38, 118},
	/* 38*/	{  79,  39},
	/* 39*/	{  40,-160},
	/* 40*/	{ -10,-104},
	/* 41*/	{  52,  42},
	/* 42*/	{  47,  43},
	/* 43*/	{  44, 103},
	/* 44*/	{  80,  45},
	/* 45*/	{  46, 144},
	/* 46*/	{ -11,-176},
	/* 47*/	{  48, 105},
	/* 48*/	{  49, 123},
	/* 49*/	{  50, 176},
	/* 50*/	{-193,  51},
	/* 51*/	{-152, -12},
	/* 52*/	{  58,  53},
	/* 53*/	{  54,  81},
	/* 54*/	{  84,  55},
	/* 55*/	{ 145,  56},
	/* 56*/	{  57, 205},
	/* 57*/	{ -13,-208},
	/* 58*/	{  64,  59},
	/* 59*/	{  60, 125},
	/* 60*/	{ 181,  61},
	/* 61*/	{  62,  87},
	/* 62*/	{-226,  63},
	/* 63*/	{ -46, -14},
	/* 64*/	{ 130,  65},
	/* 65*/	{  66,  88},
	/* 66*/	{  67, 152},
	/* 67*/	{ 111,  68},
	/* 68*/	{ 184, -15},
	/* 69*/	{ -18, -33},
	/* 70*/	{  91, -19},
	/* 71*/	{  92,  72},
	/* 72*/	{ 112, -20},
	/* 73*/	{ -21, -81},
	/* 74*/	{ -22, -97},
	/* 75*/	{  98, -23},
	/* 76*/	{  99,  77},
	/* 77*/	{-130, -24},
	/* 78*/	{ -25,-145},
	/* 79*/	{ -26,-161},
	/* 80*/	{ -27,-177},
	/* 81*/	{ 108,  82},
	/* 82*/	{ 162,  83},
	/* 83*/	{ 204, -28},
	/* 84*/	{  85, 163},
	/* 85*/	{ 110,  86},
	/* 86*/	{-210, -29},
	/* 87*/	{ -30,-225},
	/* 88*/	{ 128,  89},
	/* 89*/	{ -31,-241},
	/* 90*/	{ -48, -34},
	/* 91*/	{ -35, -50},
	/* 92*/	{ 113,  93},
	/* 93*/	{ -80, -36},
	/* 94*/	{ 134, -37},
	/* 95*/	{ 115,  96},
	/* 96*/	{  97, 114},
	/* 97*/	{ -84, -38},
	/* 98*/	{ -55, -39},
	/* 99*/	{ 136, -40},
	/*100*/	{ 101, 138},
	/*101*/	{ 102, 117},
	/*102*/	{ -41,-146},
	/*103*/	{ 121, 104},
	/*104*/	{ -42,-162},
	/*105*/	{ 106, 189},
	/*106*/	{ 107, 192},
	/*107*/	{ -43, 175},
	/*108*/	{ 147, 109},
	/*109*/	{ -60, -44},
	/*110*/	{ 197, -45},
	/*111*/	{ -47,-242},
	/*112*/	{ -66, -51},
	/*113*/	{ -52, -67},
	/*114*/	{ -98, -53},
	/*115*/	{ 116, 135},
	/*116*/	{-112, -54},
	/*117*/	{ 158, -56},
	/*118*/	{ 142, 119},
	/*119*/	{ 120, 174},
	/*120*/	{ -57, -88},
	/*121*/	{ 122, 159},
	/*122*/	{ -58,-163},
	/*123*/	{ 124, 160},
	/*124*/	{ 194, -59},
	/*125*/	{ 149, 126},
	/*126*/	{ 179, 127},
	/*127*/	{-198, -61},
	/*128*/	{ 129, 213},
	/*129*/	{ 239, -62},
	/*130*/	{ 185, 131},
	/*131*/	{ 170, 132},
	/*132*/	{ 154, 133},
	/*133*/	{ -63, 208},
	/*134*/	{ -83, -68},
	/*135*/	{ -99, -69},
	/*136*/	{-114, 137},
	/*137*/	{ -70,-100},
	/*138*/	{ 139, 156},
	/*139*/	{-131, 140},
	/*140*/	{-102, -71},
	/*141*/	{ -72,-132},
	/*142*/	{ 143,-147},
	/*143*/	{-134, -73},
	/*144*/	{-150, -74},
	/*145*/	{ 146,-209},
	/*146*/	{ 211, -75},
	/*147*/	{ 148, 178},
	/*148*/	{ -76,-196},
	/*149*/	{ 166, 150},
	/*150*/	{ 151, 206},
	/*151*/	{-199, -77},
	/*152*/	{ 168, 153},
	/*153*/	{ 199, -78},
	/*154*/	{ 155, 240},
	/*155*/	{ -79,-244},
	/*156*/	{ 157, 173},
	/*157*/	{-116, -86},
	/*158*/	{ -87,-117},
	/*159*/	{ -89,-149},
	/*160*/	{-179, 161},
	/*161*/	{-136, -90},
	/*162*/	{-194, -91},
	/*163*/	{ 164, 195},
	/*164*/	{-183, 165},
	/*165*/	{ -92,-197},
	/*166*/	{ 167, 198},
	/*167*/	{-224, -93},
	/*168*/	{ 169,-171},
	/*169*/	{-201, -94},
	/*170*/	{ 171, 222},
	/*171*/	{ 172, 215},
	/*172*/	{-232, -95},
	/*173*/	{-101,-115},
	/*174*/	{-133,-103},
	/*175*/	{-165,-105},
	/*176*/	{-192, 177},
	/*177*/	{-180,-106},
	/*178*/	{-107,-182},
	/*179*/	{ 212, 180},
	/*180*/	{-169,-108},
	/*181*/	{ 231, 182},
	/*182*/	{ 207, 183},
	/*183*/	{-109,-227},
	/*184*/	{-110,-156},
	/*185*/	{ 218, 186},
	/*186*/	{ 200, 187},
	/*187*/	{ 224, 188},
	/*188*/	{ 242,-111},
	/*189*/	{ 190,-178},
	/*190*/	{-148, 191},
	/*191*/	{-119,-118},
	/*192*/	{-164, 193},
	/*193*/	{-120,-135},
	/*194*/	{-166,-121},
	/*195*/	{ 196,-195},
	/*196*/	{-153,-122},
	/*197*/	{-211,-123},
	/*198*/	{-213,-124},
	/*199*/	{-125,-215},
	/*200*/	{ 209, 201},
	/*201*/	{ 202,-247},
	/*202*/	{-142, 203},
	/*203*/	{-127,-126},
	/*204*/	{-181,-137},
	/*205*/	{-138,-168},
	/*206*/	{-139,-184},
	/*207*/	{-228,-140},
	/*208*/	{-141,-216},
	/*209*/	{ 210, 216},
	/*210*/	{-143,-248},
	/*211*/	{-167,-151},
	/*212*/	{-212,-154},
	/*213*/	{-185, 214},
	/*214*/	{-155,-170},
	/*215*/	{-157,-217},
	/*216*/	{-204, 217},
	/*217*/	{-174,-158},
	/*218*/	{ 226, 219},
	/*219*/	{ 220, 233},
	/*220*/	{ 235, 221},
	/*221*/	{-235,-159},
	/*222*/	{ 249, 223},
	/*223*/	{-172,-187},
	/*224*/	{-218, 225},
	/*225*/	{-173,-188},
	/*226*/	{ 236, 227},
	/*227*/	{ 228, 246},
	/*228*/	{ 244, 229},
	/*229*/	{-220, 230},
	/*230*/	{-175,-233},
	/*231*/	{-240, 232},
	/*232*/	{-186,-229},
	/*233*/	{ 250, 234},
	/*234*/	{-189,-219},
	/*235*/	{ 243,-190},
	/*236*/	{ 247, 237},
	/*237*/	{ 245, 238},
	/*238*/	{-222,-191},
	/*239*/	{-200,-214},
	/*240*/	{ 241,-243},
	/*241*/	{-202,-230},
	/*242*/	{-203,-246},
	/*243*/	{-250,-205},
	/*244*/	{-251,-206},
	/*245*/	{-238,-207},
	/*246*/	{-236,-221},
	/*247*/	{ 251, 248},
	/*248*/	{-239,-223},
	/*249*/	{-245,-231},
	/*250*/	{-249,-234},
	/*251*/	{ 252,-255},
	/*252*/	{ 253,-237},
	/*253*/	{ 254,-253},
	/*254*/	{-254,-252},
};
static const short mp3_huffman_bigvalue_table15[][2] = {
	/*  0*/	{   7,   1},
	/*  1*/	{   4,   2},
	/*  2*/	{   3,   0},
	/*  3*/	{  -1, -16},
	/*  4*/	{   5, -17},
	/*  5*/	{  78,   6},
	/*  6*/	{  -2, -32},
	/*  7*/	{  21,   8},
	/*  8*/	{  13,   9},
	/*  9*/	{  10, 105},
	/* 10*/	{ 106,  11},
	/* 11*/	{  12, -19},
	/* 12*/	{ -64,  -3},
	/* 13*/	{  17,  14},
	/* 14*/	{ 107,  15},
	/* 15*/	{ -65,  16},
	/* 16*/	{ -20,  -4},
	/* 17*/	{ 109,  18},
	/* 18*/	{  79,  19},
	/* 19*/	{  20, -52},
	/* 20*/	{  -5, -80},
	/* 21*/	{  37,  22},
	/* 22*/	{  32,  23},
	/* 23*/	{  28,  24},
	/* 24*/	{ 111,  25},
	/* 25*/	{  80,  26},
	/* 26*/	{  27, -53},
	/* 27*/	{  -6, -96},
	/* 28*/	{  81,  29},
	/* 29*/	{ 175,  30},
	/* 30*/	{  31, -54},
	/* 31*/	{  -7,-112},
	/* 32*/	{  85,  33},
	/* 33*/	{  83,  34},
	/* 34*/	{  35, 129},
	/* 35*/	{  36, 176},
	/* 36*/	{-116,  -8},
	/* 37*/	{  48,  38},
	/* 38*/	{  90,  39},
	/* 39*/	{  44,  40},
	/* 40*/	{ 134,  41},
	/* 41*/	{  42, 178},
	/* 42*/	{-147,  43},
	/* 43*/	{-119,  -9},
	/* 44*/	{ 117,  45},
	/* 45*/	{  89,  46},
	/* 46*/	{  47,-104},
	/* 47*/	{ -10,-160},
	/* 48*/	{  64,  49},
	/* 49*/	{  59,  50},
	/* 50*/	{  55,  51},
	/* 51*/	{  52, 122},
	/* 52*/	{ 199,  53},
	/* 53*/	{-166,  54},
	/* 54*/	{-192, -11},
	/* 55*/	{ 165,  56},
	/* 56*/	{  57, 141},
	/* 57*/	{-182,  58},
	/* 58*/	{-153, -12},
	/* 59*/	{ 142,  60},
	/* 60*/	{  61, 180},
	/* 61*/	{  62, 200},
	/* 62*/	{  63, -29},
	/* 63*/	{ -45, -13},
	/* 64*/	{  71,  65},
	/* 65*/	{ 101,  66},
	/* 66*/	{ 146,  67},
	/* 67*/	{  99,  68},
	/* 68*/	{  69, 183},
	/* 69*/	{-225,  70},
	/* 70*/	{ -14,-224},
	/* 71*/	{  72, 149},
	/* 72*/	{ 222,  73},
	/* 73*/	{ 213,  74},
	/* 74*/	{ 205,  75},
	/* 75*/	{ 232,  76},
	/* 76*/	{-111,  77},
	/* 77*/	{-174, -15},
	/* 78*/	{ -18, -33},
	/* 79*/	{ -21, -81},
	/* 80*/	{ -98, -22},
	/* 81*/	{ 113,  82},
	/* 82*/	{-100, -23},
	/* 83*/	{ 114,  84},
	/* 84*/	{ -24,-129},
	/* 85*/	{  86, 131},
	/* 86*/	{ 115,  87},
	/* 87*/	{-145,  88},
	/* 88*/	{ -25,-144},
	/* 89*/	{ -26,-161},
	/* 90*/	{  95,  91},
	/* 91*/	{  92, 136},
	/* 92*/	{  93, 190},
	/* 93*/	{-178,  94},
	/* 94*/	{-165, -27},
	/* 95*/	{  96, 119},
	/* 96*/	{  97, 163},
	/* 97*/	{  98, 208},
	/* 98*/	{-181, -28},
	/* 99*/	{ 124, 100},
	/*100*/	{-226, -30},
	/*101*/	{ 102, 170},
	/*102*/	{ 125, 103},
	/*103*/	{ 104, 220},
	/*104*/	{ -31,-241},
	/*105*/	{ 127, -34},
	/*106*/	{ -35, -50},
	/*107*/	{ 108, 128},
	/*108*/	{ -67, -36},
	/*109*/	{ 153, 110},
	/*110*/	{ -37, -82},
	/*111*/	{ 155, 112},
	/*112*/	{ -84, -38},
	/*113*/	{ -39,-114},
	/*114*/	{ -40,-130},
	/*115*/	{ 116, 197},
	/*116*/	{ -41,-103},
	/*117*/	{ 179, 118},
	/*118*/	{ -42,-162},
	/*119*/	{ 139, 120},
	/*120*/	{ 207, 121},
	/*121*/	{ -43, -90},
	/*122*/	{-194, 123},
	/*123*/	{ -44, -91},
	/*124*/	{ -46,-170},
	/*125*/	{ 126, 195},
	/*126*/	{-230, -47},
	/*127*/	{ -49, -48},
	/*128*/	{ -66, -51},
	/*129*/	{ 130, 156},
	/*130*/	{-101, -55},
	/*131*/	{ 158, 132},
	/*132*/	{ 133, 157},
	/*133*/	{ -56,-131},
	/*134*/	{ 160, 135},
	/*135*/	{-148, -57},
	/*136*/	{ 161, 137},
	/*137*/	{ 138,-163},
	/*138*/	{-135, -58},
	/*139*/	{ 140,-179},
	/*140*/	{ -59,-121},
	/*141*/	{ -60,-195},
	/*142*/	{ 167, 143},
	/*143*/	{ 144, 247},
	/*144*/	{ 194, 145},
	/*145*/	{-198, -61},
	/*146*/	{ 147, 218},
	/*147*/	{ 210, 148},
	/*148*/	{ -62,-109},
	/*149*/	{ 186, 150},
	/*150*/	{ 173, 151},
	/*151*/	{ 152, 249},
	/*152*/	{-244, -63},
	/*153*/	{ -97, 154},
	/*154*/	{ -83, -68},
	/*155*/	{ -99, -69},
	/*156*/	{-115, -70},
	/*157*/	{-102, -71},
	/*158*/	{ 159, 177},
	/*159*/	{ -72,-132},
	/*160*/	{-134, -73},
	/*161*/	{ 162, 198},
	/*162*/	{-150, -74},
	/*163*/	{ 164, 192},
	/*164*/	{-193, -75},
	/*165*/	{ 166, 193},
	/*166*/	{-168, -76},
	/*167*/	{ 168, 216},
	/*168*/	{ 201, 169},
	/*169*/	{ -77,-139},
	/*170*/	{ 184, 171},
	/*171*/	{ 202, 172},
	/*172*/	{ -78,-228},
	/*173*/	{ 231, 174},
	/*174*/	{ 211, -79},
	/*175*/	{ -85,-113},
	/*176*/	{-128, -86},
	/*177*/	{ -87,-117},
	/*178*/	{ -88,-133},
	/*179*/	{ -89,-149},
	/*180*/	{ 181, 209},
	/*181*/	{-209, 182},
	/*182*/	{ -92,-208},
	/*183*/	{ -93,-213},
	/*184*/	{ 185, 230},
	/*185*/	{ -94,-171},
	/*186*/	{ 187, 203},
	/*187*/	{ 240, 188},
	/*188*/	{ 212, 189},
	/*189*/	{ -95,-157},
	/*190*/	{-177, 191},
	/*191*/	{-176,-105},
	/*192*/	{-180,-106},
	/*193*/	{-196,-107},
	/*194*/	{-169,-108},
	/*195*/	{-242, 196},
	/*196*/	{-110,-240},
	/*197*/	{-118,-146},
	/*198*/	{-164,-120},
	/*199*/	{-122,-167},
	/*200*/	{-123,-183},
	/*201*/	{-124,-199},
	/*202*/	{-125,-215},
	/*203*/	{ 204, 226},
	/*204*/	{-245,-126},
	/*205*/	{ 206, 227},
	/*206*/	{-233,-127},
	/*207*/	{-151,-136},
	/*208*/	{-137,-152},
	/*209*/	{-197,-138},
	/*210*/	{-140,-200},
	/*211*/	{-217,-141},
	/*212*/	{-142,-232},
	/*213*/	{ 233, 214},
	/*214*/	{ 215, 221},
	/*215*/	{-143,-248},
	/*216*/	{-212, 217},
	/*217*/	{-184,-154},
	/*218*/	{ 248, 219},
	/*219*/	{-155,-185},
	/*220*/	{-156,-201},
	/*221*/	{-204,-158},
	/*222*/	{ 236, 223},
	/*223*/	{ 228, 224},
	/*224*/	{ 241, 225},
	/*225*/	{-220,-159},
	/*226*/	{-231,-172},
	/*227*/	{-247,-173},
	/*228*/	{ 229, 235},
	/*229*/	{-221,-175},
	/*230*/	{-186,-229},
	/*231*/	{-202,-187},
	/*232*/	{-218,-188},
	/*233*/	{ 253, 234},
	/*234*/	{-189,-219},
	/*235*/	{-250,-190},
	/*236*/	{ 244, 237},
	/*237*/	{ 238, 242},
	/*238*/	{ 250, 239},
	/*239*/	{-237,-191},
	/*240*/	{-203,-246},
	/*241*/	{-235,-205},
	/*242*/	{-251, 243},
	/*243*/	{-206,-236},
	/*244*/	{ 251, 245},
	/*245*/	{-238, 246},
	/*246*/	{-253,-207},
	/*247*/	{-211,-210},
	/*248*/	{-214,-227},
	/*249*/	{-243,-216},
	/*250*/	{-252,-222},
	/*251*/	{ 254, 252},
	/*252*/	{-254,-223},
	/*253*/	{-249,-234},
	/*254*/	{-255,-239},
};
static const short mp3_huffman_bigvalue_table16[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   4,   2},
	/*  2*/	{   3, -16},
	/*  3*/	{ -17,  -1},
	/*  4*/	{  16,   5},
	/*  5*/	{   8,   6},
	/*  6*/	{  70,   7},
	/*  7*/	{  -2, -32},
	/*  8*/	{  12,   9},
	/*  9*/	{  71,  10},
	/* 10*/	{  11, -34},
	/* 11*/	{  -3, -48},
	/* 12*/	{  72,  13},
	/* 13*/	{  14,  87},
	/* 14*/	{ -65,  15},
	/* 15*/	{  -4, -64},
	/* 16*/	{  44,  17},
	/* 17*/	{  26,  18},
	/* 18*/	{  22,  19},
	/* 19*/	{  90,  20},
	/* 20*/	{ -81,  21},
	/* 21*/	{ -21,  -5},
	/* 22*/	{  92,  23},
	/* 23*/	{  74,  24},
	/* 24*/	{ -97,  25},
	/* 25*/	{  -6, -96},
	/* 26*/	{  35,  27},
	/* 27*/	{  31,  28},
	/* 28*/	{  95,  29},
	/* 29*/	{  30, -23},
	/* 30*/	{ 154,  -7},
	/* 31*/	{  75,  32},
	/* 32*/	{ 200,  33},
	/* 33*/	{  34, -55},
	/* 34*/	{  -8, -86},
	/* 35*/	{  40,  36},
	/* 36*/	{  37, 113},
	/* 37*/	{  99,  38},
	/* 38*/	{  39, -25},
	/* 39*/	{-118,  -9},
	/* 40*/	{ 139,  41},
	/* 41*/	{  42, 116},
	/* 42*/	{ -26,  43},
	/* 43*/	{ -10,-160},
	/* 44*/	{ 128,  45},
	/* 45*/	{  61,  46},
	/* 46*/	{  56,  47},
	/* 47*/	{  52,  48},
	/* 48*/	{  49, 100},
	/* 49*/	{  50, 143},
	/* 50*/	{-177,  51},
	/* 51*/	{ -11,-176},
	/* 52*/	{  53,  77},
	/* 53*/	{  54, 169},
	/* 54*/	{  55, 145},
	/* 55*/	{-193, -12},
	/* 56*/	{  57,  82},
	/* 57*/	{  58,  79},
	/* 58*/	{  59, 120},
	/* 59*/	{ 122,  60},
	/* 60*/	{ 158, -13},
	/* 61*/	{  68,  62},
	/* 62*/	{-241,  63},
	/* 63*/	{ 124,  64},
	/* 64*/	{ 191,  65},
	/* 65*/	{  66, 148},
	/* 66*/	{  67, 159},
	/* 67*/	{ -14,-224},
	/* 68*/	{  69, -31},
	/* 69*/	{ -47, -15},
	/* 70*/	{ -18, -33},
	/* 71*/	{ -19, -49},
	/* 72*/	{  88,  73},
	/* 73*/	{ 107, -20},
	/* 74*/	{ -98, -22},
	/* 75*/	{  97,  76},
	/* 76*/	{ 136, -24},
	/* 77*/	{ 102,  78},
	/* 78*/	{-178, -27},
	/* 79*/	{  80,  85},
	/* 80*/	{  81, 188},
	/* 81*/	{ 157, -28},
	/* 82*/	{  83, 103},
	/* 83*/	{ 105,  84},
	/* 84*/	{ 119, -29},
	/* 85*/	{-226,  86},
	/* 86*/	{ -46, -30},
	/* 87*/	{ -35, -50},
	/* 88*/	{ 108,  89},
	/* 89*/	{ -80, -36},
	/* 90*/	{ 109,  91},
	/* 91*/	{ -37, -82},
	/* 92*/	{ 111,  93},
	/* 93*/	{ 133,  94},
	/* 94*/	{ -84, -38},
	/* 95*/	{ 134,  96},
	/* 96*/	{ -39,-114},
	/* 97*/	{  98,-130},
	/* 98*/	{-102, -40},
	/* 99*/	{ -41,-146},
	/*100*/	{ 186, 101},
	/*101*/	{ 118, -42},
	/*102*/	{ 156, -43},
	/*103*/	{ 171, 104},
	/*104*/	{ -44, 230},
	/*105*/	{ 106, 242},
	/*106*/	{-211, -45},
	/*107*/	{ -66, -51},
	/*108*/	{ -52, -67},
	/*109*/	{ -83, 110},
	/*110*/	{ -53, -68},
	/*111*/	{-113, 112},
	/*112*/	{-112, -54},
	/*113*/	{ 137, 114},
	/*114*/	{ 183, 115},
	/*115*/	{ -56,-131},
	/*116*/	{ 117, 155},
	/*117*/	{ -57,-147},
	/*118*/	{ -58, -89},
	/*119*/	{ -59, 201},
	/*120*/	{ 146, 121},
	/*121*/	{ 190, -60},
	/*122*/	{ 173, 123},
	/*123*/	{-198, -61},
	/*124*/	{ 175, 125},
	/*125*/	{ 150, 126},
	/*126*/	{ 127, 174},
	/*127*/	{-200, -62},
	/*128*/	{ 179, 129},
	/*129*/	{ 152, 130},
	/*130*/	{ 131,-242},
	/*131*/	{-240, 132},
	/*132*/	{ -63, 160},
	/*133*/	{ -99, -69},
	/*134*/	{-115, 135},
	/*135*/	{-101, -70},
	/*136*/	{ -71,-116},
	/*137*/	{-145, 138},
	/*138*/	{-144, -72},
	/*139*/	{ 165, 140},
	/*140*/	{ 141,-162},
	/*141*/	{ 142,-103},
	/*142*/	{ -73, -87},
	/*143*/	{ 168, 144},
	/*144*/	{ -74,-164},
	/*145*/	{ -75,-180},
	/*146*/	{ 202, 147},
	/*147*/	{-153, -76},
	/*148*/	{ 194, 149},
	/*149*/	{ -77,-139},
	/*150*/	{ 223, 151},
	/*151*/	{ -78, 203},
	/*152*/	{ 153, 253},
	/*153*/	{ 164, -79},
	/*154*/	{-100, -85},
	/*155*/	{ -88,-133},
	/*156*/	{ -90,-165},
	/*157*/	{ -91,-137},
	/*158*/	{ -92,-197},
	/*159*/	{ -93,-213},
	/*160*/	{ 227, 161},
	/*161*/	{ 196, 162},
	/*162*/	{ 163,-189},
	/*163*/	{ 195, -94},
	/*164*/	{ -95,-245},
	/*165*/	{ 166, 184},
	/*166*/	{ 167,-161},
	/*167*/	{-149,-104},
	/*168*/	{-105,-150},
	/*169*/	{ 170,-179},
	/*170*/	{-106,-166},
	/*171*/	{ 172, 217},
	/*172*/	{-196,-107},
	/*173*/	{-154,-108},
	/*174*/	{-109, 211},
	/*175*/	{ 205, 176},
	/*176*/	{ 177, 212},
	/*177*/	{ 204, 178},
	/*178*/	{-216,-110},
	/*179*/	{ 208, 180},
	/*180*/	{ 181,-255},
	/*181*/	{ 199, 182},
	/*182*/	{-111,-246},
	/*183*/	{-132,-117},
	/*184*/	{ 185,-148},
	/*185*/	{-134,-119},
	/*186*/	{ 187,-163},
	/*187*/	{-120,-135},
	/*188*/	{-192, 189},
	/*189*/	{-152,-121},
	/*190*/	{-182,-122},
	/*191*/	{ 218, 192},
	/*192*/	{ 193,-227},
	/*193*/	{-123, 231},
	/*194*/	{-124,-199},
	/*195*/	{-201,-125},
	/*196*/	{ 225, 197},
	/*197*/	{ 198,-202},
	/*198*/	{-126,-172},
	/*199*/	{-127,-247},
	/*200*/	{-129,-128},
	/*201*/	{-151,-136},
	/*202*/	{-138,-168},
	/*203*/	{-228,-140},
	/*204*/	{-187,-141},
	/*205*/	{ 214, 206},
	/*206*/	{ 207, 213},
	/*207*/	{-142,-232},
	/*208*/	{ 234, 209},
	/*209*/	{ 215, 210},
	/*210*/	{ 254,-143},
	/*211*/	{-214,-155},
	/*212*/	{-230,-156},
	/*213*/	{-157,-231},
	/*214*/	{-158, 232},
	/*215*/	{-175, 216},
	/*216*/	{-250,-159},
	/*217*/	{-195,-167},
	/*218*/	{ 221, 219},
	/*219*/	{-212, 220},
	/*220*/	{-184,-169},
	/*221*/	{ 222,-225},
	/*222*/	{-185,-170},
	/*223*/	{ 224, 243},
	/*224*/	{-171,-186},
	/*225*/	{-204, 226},
	/*226*/	{-173,-218},
	/*227*/	{ 237, 228},
	/*228*/	{ 233, 229},
	/*229*/	{ 246,-174},
	/*230*/	{-194,-181},
	/*231*/	{-183,-208},
	/*232*/	{-188,-203},
	/*233*/	{-190,-205},
	/*234*/	{ 248, 235},
	/*235*/	{ 241, 236},
	/*236*/	{-191,-251},
	/*237*/	{ 238, 250},
	/*238*/	{ 239, 244},
	/*239*/	{ 240,-222},
	/*240*/	{-206, 247},
	/*241*/	{-207,-252},
	/*242*/	{-210,-209},
	/*243*/	{-229,-215},
	/*244*/	{-233, 245},
	/*245*/	{-234,-217},
	/*246*/	{-220,-219},
	/*247*/	{-236,-221},
	/*248*/	{ 252, 249},
	/*249*/	{-223,-253},
	/*250*/	{-238, 251},
	/*251*/	{-237,-235},
	/*252*/	{-239,-254},
	/*253*/	{-244,-243},
	/*254*/	{-249,-248},
};
static const short mp3_huffman_bigvalue_table24[][2] = {
	/*  0*/	{  22,   1},
	/*  1*/	{   5,   2},
	/*  2*/	{   4,   3},
	/*  3*/	{ -16,   0},
	/*  4*/	{ -17,  -1},
	/*  5*/	{  12,   6},
	/*  6*/	{   9,   7},
	/*  7*/	{ -33,   8},
	/*  8*/	{  -2, -32},
	/*  9*/	{  10, -18},
	/* 10*/	{  11, -34},
	/* 11*/	{  -3, -48},
	/* 12*/	{  17,  13},
	/* 13*/	{  14,  75},
	/* 14*/	{  15, 103},
	/* 15*/	{ -65,  16},
	/* 16*/	{  -4, -64},
	/* 17*/	{  18,  76},
	/* 18*/	{  19, 132},
	/* 19*/	{ 105,  20},
	/* 20*/	{ -21,  21},
	/* 21*/	{  -5, -80},
	/* 22*/	{  68,  23},
	/* 23*/	{  40,  24},
	/* 24*/	{  30,  25},
	/* 25*/	{ 134,  26},
	/* 26*/	{  78,  27},
	/* 27*/	{  28, 145},
	/* 28*/	{  29, -53},
	/* 29*/	{  -6, -96},
	/* 30*/	{  82,  31},
	/* 31*/	{  36,  32},
	/* 32*/	{  33, 107},
	/* 33*/	{  34,-115},
	/* 34*/	{ -23,  35},
	/* 35*/	{  -7,-112},
	/* 36*/	{  80,  37},
	/* 37*/	{  38, 167},
	/* 38*/	{-129,  39},
	/* 39*/	{  -8,-128},
	/* 40*/	{  54,  41},
	/* 41*/	{  42, 114},
	/* 42*/	{  43,  86},
	/* 43*/	{  48,  44},
	/* 44*/	{ 182,  45},
	/* 45*/	{ 195,  46},
	/* 46*/	{  47,-144},
	/* 47*/	{-160,  -9},
	/* 48*/	{ 155,  49},
	/* 49*/	{  52,  50},
	/* 50*/	{  51, -26},
	/* 51*/	{-176, -10},
	/* 52*/	{  53, -59},
	/* 53*/	{-192, -11},
	/* 54*/	{  61,  55},
	/* 55*/	{  93,  56},
	/* 56*/	{  57,  90},
	/* 57*/	{ 157,  58},
	/* 58*/	{ 184,  59},
	/* 59*/	{  60, -60},
	/* 60*/	{-208, -12},
	/* 61*/	{  62,  97},
	/* 62*/	{  63, 126},
	/* 63*/	{  64, 176},
	/* 64*/	{ 213,  65},
	/* 65*/	{  66,-230},
	/* 66*/	{  67, -13},
	/* 67*/	{ -14,-224},
	/* 68*/	{ 162,  69},
	/* 69*/	{  70,-255},
	/* 70*/	{ 130,  71},
	/* 71*/	{ 101,  72},
	/* 72*/	{  73, 202},
	/* 73*/	{  74, 233},
	/* 74*/	{ -15, 245},
	/* 75*/	{ -19, -49},
	/* 76*/	{ 104,  77},
	/* 77*/	{ -51, -20},
	/* 78*/	{ 106,  79},
	/* 79*/	{ -22, -97},
	/* 80*/	{  81, 149},
	/* 81*/	{-130, -24},
	/* 82*/	{  83, 109},
	/* 83*/	{ 112,  84},
	/* 84*/	{ 193,  85},
	/* 85*/	{ -25,-145},
	/* 86*/	{ 118,  87},
	/* 87*/	{  88, 217},
	/* 88*/	{  89, 181},
	/* 89*/	{-165, -27},
	/* 90*/	{ 121,  91},
	/* 91*/	{ 171,  92},
	/* 92*/	{-181, -28},
	/* 93*/	{ 123,  94},
	/* 94*/	{  95, 172},
	/* 95*/	{  96, 197},
	/* 96*/	{-210, -29},
	/* 97*/	{  98, 159},
	/* 98*/	{ 187,  99},
	/* 99*/	{ 229, 100},
	/*100*/	{-226, -30},
	/*101*/	{-241, 102},
	/*102*/	{ -31,-240},
	/*103*/	{ -35, -50},
	/*104*/	{ -36, -66},
	/*105*/	{ -37, -82},
	/*106*/	{ -38, -98},
	/*107*/	{ 108,-114},
	/*108*/	{ -55, -39},
	/*109*/	{ 150, 110},
	/*110*/	{ 137, 111},
	/*111*/	{-102, -40},
	/*112*/	{ 169, 113},
	/*113*/	{ -41,-103},
	/*114*/	{ 115, 138},
	/*115*/	{ 141, 116},
	/*116*/	{ 170, 117},
	/*117*/	{ -42,-162},
	/*118*/	{ 208, 119},
	/*119*/	{ 120,-178},
	/*120*/	{ -43, -90},
	/*121*/	{ 196, 122},
	/*122*/	{-167, -44},
	/*123*/	{ 185, 124},
	/*124*/	{ 143, 125},
	/*125*/	{-211, -45},
	/*126*/	{ 199, 127},
	/*127*/	{ 212, 128},
	/*128*/	{ 129, -62},
	/*129*/	{ -78, -46},
	/*130*/	{ 144, 131},
	/*131*/	{ -47,-242},
	/*132*/	{ -81, 133},
	/*133*/	{ -52, -67},
	/*134*/	{ 147, 135},
	/*135*/	{ 136, 146},
	/*136*/	{ -54, -99},
	/*137*/	{ -56,-131},
	/*138*/	{ 179, 139},
	/*139*/	{ 152, 140},
	/*140*/	{ -57,-147},
	/*141*/	{ 153, 142},
	/*142*/	{ -58,-163},
	/*143*/	{-198, -61},
	/*144*/	{ -63,-243},
	/*145*/	{ -83, -68},
	/*146*/	{ -69, -84},
	/*147*/	{ 148, 166},
	/*148*/	{ -70,-100},
	/*149*/	{ -71,-116},
	/*150*/	{ 151, 168},
	/*151*/	{ -72,-132},
	/*152*/	{ -73,-148},
	/*153*/	{ 154,-135},
	/*154*/	{ -74,-120},
	/*155*/	{ 209, 156},
	/*156*/	{-193, -75},
	/*157*/	{ 218, 158},
	/*158*/	{ -76,-196},
	/*159*/	{ 174, 160},
	/*160*/	{ 161, 211},
	/*161*/	{-199, -77},
	/*162*/	{ 225, 163},
	/*163*/	{ 191, 164},
	/*164*/	{ 178, 165},
	/*165*/	{ -79,-244},
	/*166*/	{ -85,-113},
	/*167*/	{ -86,-101},
	/*168*/	{ -87,-117},
	/*169*/	{ -88,-133},
	/*170*/	{ -89,-149},
	/*171*/	{-194, -91},
	/*172*/	{ 173, 210},
	/*173*/	{-209, -92},
	/*174*/	{ 175, 198},
	/*175*/	{-225, -93},
	/*176*/	{ 189, 177},
	/*177*/	{ -94,-186},
	/*178*/	{ -95,-245},
	/*179*/	{ 180, 194},
	/*180*/	{-161,-104},
	/*181*/	{-177,-105},
	/*182*/	{-180, 183},
	/*183*/	{-106,-166},
	/*184*/	{-107,-182},
	/*185*/	{ 219, 186},
	/*186*/	{-169,-108},
	/*187*/	{ 188, 220},
	/*188*/	{-109,-214},
	/*189*/	{ 190,-201},
	/*190*/	{-110,-156},
	/*191*/	{ 206, 192},
	/*192*/	{-111,-246},
	/*193*/	{-118,-146},
	/*194*/	{-134,-119},
	/*195*/	{-121,-151},
	/*196*/	{-195,-122},
	/*197*/	{-123,-183},
	/*198*/	{-213,-124},
	/*199*/	{ 200, 248},
	/*200*/	{-229, 201},
	/*201*/	{-171,-125},
	/*202*/	{ 222, 203},
	/*203*/	{ 215, 204},
	/*204*/	{ 205, 230},
	/*205*/	{-217,-126},
	/*206*/	{ 207,-247},
	/*207*/	{-143,-127},
	/*208*/	{-179,-136},
	/*209*/	{-137,-152},
	/*210*/	{-197,-138},
	/*211*/	{-139,-184},
	/*212*/	{-140,-200},
	/*213*/	{ 236, 214},
	/*214*/	{-141,-216},
	/*215*/	{ 216, 221},
	/*216*/	{-203,-142},
	/*217*/	{-150,-164},
	/*218*/	{-168,-153},
	/*219*/	{-212,-154},
	/*220*/	{-227,-155},
	/*221*/	{-232,-157},
	/*222*/	{ 223, 231},
	/*223*/	{ 238, 224},
	/*224*/	{-204,-158},
	/*225*/	{ 241, 226},
	/*226*/	{ 227, 254},
	/*227*/	{-250, 228},
	/*228*/	{-175,-159},
	/*229*/	{-185,-170},
	/*230*/	{-231,-172},
	/*231*/	{ 232, 237},
	/*232*/	{-233,-173},
	/*233*/	{ 239, 234},
	/*234*/	{ 244, 235},
	/*235*/	{-174,-234},
	/*236*/	{-202,-187},
	/*237*/	{-218,-188},
	/*238*/	{-189,-219},
	/*239*/	{ 249, 240},
	/*240*/	{-190,-235},
	/*241*/	{ 251, 242},
	/*242*/	{ 247, 243},
	/*243*/	{-191,-251},
	/*244*/	{-205,-220},
	/*245*/	{ 250, 246},
	/*246*/	{-237,-206},
	/*247*/	{-207,-252},
	/*248*/	{-215,-228},
	/*249*/	{-236,-221},
	/*250*/	{-238,-222},
	/*251*/	{ 253, 252},
	/*252*/	{-223,-253},
	/*253*/	{-239,-254},
	/*254*/	{-249,-248},
};
/* typedef struct _MP3HUFFMANBIGVALUETABLE {
 * 	const short (*table)[2];
 * 	short linbits;
 * } MP3HUFFMANBIGVALUETABLE;
 * extern const MP3HUFFMANBIGVALUETABLE mp3_huffman_bigvalue_table[32];
 */
const MP3HUFFMANBIGVALUETABLE mp3_huffman_bigvalue_table[32] = {
	/* 0*/	{NULL,0},
	/* 1*/	{mp3_huffman_bigvalue_table1 , 0},
	/* 2*/	{mp3_huffman_bigvalue_table2 , 0},
	/* 3*/	{mp3_huffman_bigvalue_table3 , 0},
	/* 4*/	{NULL,0},
	/* 5*/	{mp3_huffman_bigvalue_table5 , 0},
	/* 6*/	{mp3_huffman_bigvalue_table6 , 0},
	/* 7*/	{mp3_huffman_bigvalue_table7 , 0},
	/* 8*/	{mp3_huffman_bigvalue_table8 , 0},
	/* 9*/	{mp3_huffman_bigvalue_table9 , 0},
	/*10*/	{mp3_huffman_bigvalue_table10, 0},
	/*11*/	{mp3_huffman_bigvalue_table11, 0},
	/*12*/	{mp3_huffman_bigvalue_table12, 0},
	/*13*/	{mp3_huffman_bigvalue_table13, 0},
	/*14*/	{NULL,0},
	/*15*/	{mp3_huffman_bigvalue_table15, 0},
	/*16*/	{mp3_huffman_bigvalue_table16, 1},
	/*17*/	{mp3_huffman_bigvalue_table16, 2},
	/*18*/	{mp3_huffman_bigvalue_table16, 3},
	/*19*/	{mp3_huffman_bigvalue_table16, 4},
	/*20*/	{mp3_huffman_bigvalue_table16, 6},
	/*21*/	{mp3_huffman_bigvalue_table16, 8},
	/*22*/	{mp3_huffman_bigvalue_table16,10},
	/*23*/	{mp3_huffman_bigvalue_table16,13},
	/*24*/	{mp3_huffman_bigvalue_table24, 4},
	/*25*/	{mp3_huffman_bigvalue_table24, 5},
	/*26*/	{mp3_huffman_bigvalue_table24, 6},
	/*27*/	{mp3_huffman_bigvalue_table24, 7},
	/*28*/	{mp3_huffman_bigvalue_table24, 8},
	/*29*/	{mp3_huffman_bigvalue_table24, 9},
	/*30*/	{mp3_huffman_bigvalue_table24,11},
	/*31*/	{mp3_huffman_bigvalue_table24,13},
};

static const short mp3_huffman_count1_table0[][2] = {
	/*  0*/	{   1,   0},
	/*  1*/	{   4,   2},
	/*  2*/	{   3,   7},
	/*  3*/	{  -2,  -1},
	/*  4*/	{   8,   5},
	/*  5*/	{   6,  11},
	/*  6*/	{  -6,  -3},
	/*  7*/	{  -4,  -8},
	/*  8*/	{  12,   9},
	/*  9*/	{  10,  -9},
	/* 10*/	{  -7,  -5},
	/* 11*/	{ -10, -12},
	/* 12*/	{  13,  14},
	/* 13*/	{ -11, -15},
	/* 14*/	{ -13, -14},
};
static const short mp3_huffman_count1_table1[][2] = {
	/*  0*/	{   8,   1},
	/*  1*/	{   5,   2},
	/*  2*/	{   4,   3},
	/*  3*/	{  -1,   0},
	/*  4*/	{  -3,  -2},
	/*  5*/	{   7,   6},
	/*  6*/	{  -5,  -4},
	/*  7*/	{  -7,  -6},
	/*  8*/	{  12,   9},
	/*  9*/	{  11,  10},
	/* 10*/	{  -9,  -8},
	/* 11*/	{ -11, -10},
	/* 12*/	{  14,  13},
	/* 13*/	{ -13, -12},
	/* 14*/	{ -15, -14},
};
/* typedef struct _MP3HUFFMANCOUNT1TABLE {
 * 	const short (*table)[2];
 * } MP3HUFFMANCOUNT1TABLE;
 */
const MP3HUFFMANCOUNT1TABLE mp3_huffman_count1_table[2] = {
	/* 1*/	{ mp3_huffman_count1_table0 },
	/* 2*/	{ mp3_huffman_count1_table1 },
};

/****************************************************************************
 *	tʎq
 ****************************************************************************/

/* V[gubÑTvт
 *	[13(=XP[t@N^oh)][3(=TuubN)][?(=g)] => Ŝ[192(=g)][3(=TuubN)]
 * ɕёւ邽߂́AǂݍݑCfNXe[ułB
 */
const short mp3_reorder_read_index_table[3/*MP3FRAMEHEADER.sampling_frequency=0:44.1KHz/1:48KHz/2:32KHz*/][MP3_GRANULE_SIZE] = {{
	  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35,
	 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47, 48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53, 59, 65, 66, 74, 82, 67, 75, 83,
	 68, 76, 84, 69, 77, 85, 70, 78, 86, 71, 79, 87, 72, 80, 88, 73, 81, 89, 90,100,110, 91,101,111, 92,102,112, 93,103,113, 94,104,114, 95,105,115,
	 96,106,116, 97,107,117, 98,108,118, 99,109,119,120,132,144,121,133,145,122,134,146,123,135,147,124,136,148,125,137,149,126,138,150,127,139,151,
	128,140,152,129,141,153,130,142,154,131,143,155,156,170,184,157,171,185,158,172,186,159,173,187,160,174,188,161,175,189,162,176,190,163,177,191,
	164,178,192,165,179,193,166,180,194,167,181,195,168,182,196,169,183,197,198,216,234,199,217,235,200,218,236,201,219,237,202,220,238,203,221,239,
	204,222,240,205,223,241,206,224,242,207,225,243,208,226,244,209,227,245,210,228,246,211,229,247,212,230,248,213,231,249,214,232,250,215,233,251,
	252,274,296,253,275,297,254,276,298,255,277,299,256,278,300,257,279,301,258,280,302,259,281,303,260,282,304,261,283,305,262,284,306,263,285,307,
	264,286,308,265,287,309,266,288,310,267,289,311,268,290,312,269,291,313,270,292,314,271,293,315,272,294,316,273,295,317,318,348,378,319,349,379,
	320,350,380,321,351,381,322,352,382,323,353,383,324,354,384,325,355,385,326,356,386,327,357,387,328,358,388,329,359,389,330,360,390,331,361,391,
	332,362,392,333,363,393,334,364,394,335,365,395,336,366,396,337,367,397,338,368,398,339,369,399,340,370,400,341,371,401,342,372,402,343,373,403,
	344,374,404,345,375,405,346,376,406,347,377,407,408,464,520,409,465,521,410,466,522,411,467,523,412,468,524,413,469,525,414,470,526,415,471,527,
	416,472,528,417,473,529,418,474,530,419,475,531,420,476,532,421,477,533,422,478,534,423,479,535,424,480,536,425,481,537,426,482,538,427,483,539,
	428,484,540,429,485,541,430,486,542,431,487,543,432,488,544,433,489,545,434,490,546,435,491,547,436,492,548,437,493,549,438,494,550,439,495,551,
	440,496,552,441,497,553,442,498,554,443,499,555,444,500,556,445,501,557,446,502,558,447,503,559,448,504,560,449,505,561,450,506,562,451,507,563,
	452,508,564,453,509,565,454,510,566,455,511,567,456,512,568,457,513,569,458,514,570,459,515,571,460,516,572,461,517,573,462,518,574,463,519,575,
},{
	  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35,
	 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47, 48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53, 59, 65, 66, 72, 78, 67, 73, 79,
	 68, 74, 80, 69, 75, 81, 70, 76, 82, 71, 77, 83, 84, 94,104, 85, 95,105, 86, 96,106, 87, 97,107, 88, 98,108, 89, 99,109, 90,100,110, 91,101,111,
	 92,102,112, 93,103,113,114,126,138,115,127,139,116,128,140,117,129,141,118,130,142,119,131,143,120,132,144,121,133,145,122,134,146,123,135,147,
	124,136,148,125,137,149,150,164,178,151,165,179,152,166,180,153,167,181,154,168,182,155,169,183,156,170,184,157,171,185,158,172,186,159,173,187,
	160,174,188,161,175,189,162,176,190,163,177,191,192,208,224,193,209,225,194,210,226,195,211,227,196,212,228,197,213,229,198,214,230,199,215,231,
	200,216,232,201,217,233,202,218,234,203,219,235,204,220,236,205,221,237,206,222,238,207,223,239,240,260,280,241,261,281,242,262,282,243,263,283,
	244,264,284,245,265,285,246,266,286,247,267,287,248,268,288,249,269,289,250,270,290,251,271,291,252,272,292,253,273,293,254,274,294,255,275,295,
	256,276,296,257,277,297,258,278,298,259,279,299,300,326,352,301,327,353,302,328,354,303,329,355,304,330,356,305,331,357,306,332,358,307,333,359,
	308,334,360,309,335,361,310,336,362,311,337,363,312,338,364,313,339,365,314,340,366,315,341,367,316,342,368,317,343,369,318,344,370,319,345,371,
	320,346,372,321,347,373,322,348,374,323,349,375,324,350,376,325,351,377,378,444,510,379,445,511,380,446,512,381,447,513,382,448,514,383,449,515,
	384,450,516,385,451,517,386,452,518,387,453,519,388,454,520,389,455,521,390,456,522,391,457,523,392,458,524,393,459,525,394,460,526,395,461,527,
	396,462,528,397,463,529,398,464,530,399,465,531,400,466,532,401,467,533,402,468,534,403,469,535,404,470,536,405,471,537,406,472,538,407,473,539,
	408,474,540,409,475,541,410,476,542,411,477,543,412,478,544,413,479,545,414,480,546,415,481,547,416,482,548,417,483,549,418,484,550,419,485,551,
	420,486,552,421,487,553,422,488,554,423,489,555,424,490,556,425,491,557,426,492,558,427,493,559,428,494,560,429,495,561,430,496,562,431,497,563,
	432,498,564,433,499,565,434,500,566,435,501,567,436,502,568,437,503,569,438,504,570,439,505,571,440,506,572,441,507,573,442,508,574,443,509,575,
},{
	  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35,
	 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47, 48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53, 59, 65, 66, 74, 82, 67, 75, 83,
	 68, 76, 84, 69, 77, 85, 70, 78, 86, 71, 79, 87, 72, 80, 88, 73, 81, 89, 90,102,114, 91,103,115, 92,104,116, 93,105,117, 94,106,118, 95,107,119,
	 96,108,120, 97,109,121, 98,110,122, 99,111,123,100,112,124,101,113,125,126,142,158,127,143,159,128,144,160,129,145,161,130,146,162,131,147,163,
	132,148,164,133,149,165,134,150,166,135,151,167,136,152,168,137,153,169,138,154,170,139,155,171,140,156,172,141,157,173,174,194,214,175,195,215,
	176,196,216,177,197,217,178,198,218,179,199,219,180,200,220,181,201,221,182,202,222,183,203,223,184,204,224,185,205,225,186,206,226,187,207,227,
	188,208,228,189,209,229,190,210,230,191,211,231,192,212,232,193,213,233,234,260,286,235,261,287,236,262,288,237,263,289,238,264,290,239,265,291,
	240,266,292,241,267,293,242,268,294,243,269,295,244,270,296,245,271,297,246,272,298,247,273,299,248,274,300,249,275,301,250,276,302,251,277,303,
	252,278,304,253,279,305,254,280,306,255,281,307,256,282,308,257,283,309,258,284,310,259,285,311,312,346,380,313,347,381,314,348,382,315,349,383,
	316,350,384,317,351,385,318,352,386,319,353,387,320,354,388,321,355,389,322,356,390,323,357,391,324,358,392,325,359,393,326,360,394,327,361,395,
	328,362,396,329,363,397,330,364,398,331,365,399,332,366,400,333,367,401,334,368,402,335,369,403,336,370,404,337,371,405,338,372,406,339,373,407,
	340,374,408,341,375,409,342,376,410,343,377,411,344,378,412,345,379,413,414,456,498,415,457,499,416,458,500,417,459,501,418,460,502,419,461,503,
	420,462,504,421,463,505,422,464,506,423,465,507,424,466,508,425,467,509,426,468,510,427,469,511,428,470,512,429,471,513,430,472,514,431,473,515,
	432,474,516,433,475,517,434,476,518,435,477,519,436,478,520,437,479,521,438,480,522,439,481,523,440,482,524,441,483,525,442,484,526,443,485,527,
	444,486,528,445,487,529,446,488,530,447,489,531,448,490,532,449,491,533,450,492,534,451,493,535,452,494,536,453,495,537,454,496,538,455,497,539,
	540,552,564,541,553,565,542,554,566,543,555,567,544,556,568,545,557,569,546,558,570,547,559,571,548,560,572,549,561,573,550,562,574,551,563,575,
}};

/* ɏdvB
 * [0`2436]Ȃ̂ŁA12rbgȏKvB(ۂɎĝ͂قƂ1̗̈?)
 * mۂŁAł菬𑽂ȂƁAȂȂĂ܂B
 *
 *	for(i = 0; i < 256; i++) {
 *		mp3_gain_table[i] = pow(2.0, (i - 210) / 4.0);
 *	}
 */
const int mp3_gain_table[256/*MP3GRANULEINFO.global_gain*/] = { /* 1.13.18 */
#define P(d)	((int)((d) * (1 << 18)))
	P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),
	P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),
	P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),
	P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),
	P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),
	P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000000),P(   0.000000001),P(   0.000000001),P(   0.000000001),P(   0.000000001),P(   0.000000001),P(   0.000000001),P(   0.000000002),P(   0.000000002),P(   0.000000002),
	P(   0.000000003),P(   0.000000003),P(   0.000000004),P(   0.000000004),P(   0.000000005),P(   0.000000006),P(   0.000000007),P(   0.000000009),P(   0.000000011),P(   0.000000013),P(   0.000000015),P(   0.000000018),P(   0.000000021),P(   0.000000025),P(   0.000000030),P(   0.000000035),
	P(   0.000000042),P(   0.000000050),P(   0.000000060),P(   0.000000071),P(   0.000000084),P(   0.000000100),P(   0.000000119),P(   0.000000142),P(   0.000000169),P(   0.000000200),P(   0.000000238),P(   0.000000284),P(   0.000000337),P(   0.000000401),P(   0.000000477),P(   0.000000567),
	P(   0.000000674),P(   0.000000802),P(   0.000000954),P(   0.000001134),P(   0.000001349),P(   0.000001604),P(   0.000001907),P(   0.000002268),P(   0.000002697),P(   0.000003208),P(   0.000003815),P(   0.000004536),P(   0.000005395),P(   0.000006416),P(   0.000007629),P(   0.000009073),
	P(   0.000010790),P(   0.000012831),P(   0.000015259),P(   0.000018146),P(   0.000021579),P(   0.000025662),P(   0.000030518),P(   0.000036292),P(   0.000043158),P(   0.000051324),P(   0.000061035),P(   0.000072583),P(   0.000086317),P(   0.000102648),P(   0.000122070),P(   0.000145167),
	P(   0.000172633),P(   0.000205297),P(   0.000244141),P(   0.000290334),P(   0.000345267),P(   0.000410594),P(   0.000488281),P(   0.000580668),P(   0.000690534),P(   0.000821188),P(   0.000976563),P(   0.001161335),P(   0.001381068),P(   0.001642376),P(   0.001953125),P(   0.002322670),
	P(   0.002762136),P(   0.003284752),P(   0.003906250),P(   0.004645340),P(   0.005524272),P(   0.006569503),P(   0.007812500),P(   0.009290681),P(   0.011048543),P(   0.013139006),P(   0.015625000),P(   0.018581361),P(   0.022097087),P(   0.026278013),P(   0.031250000),P(   0.037162722),
	P(   0.044194174),P(   0.052556026),P(   0.062500000),P(   0.074325445),P(   0.088388348),P(   0.105112052),P(   0.125000000),P(   0.148650889),P(   0.176776695),P(   0.210224104),P(   0.250000000),P(   0.297301779),P(   0.353553391),P(   0.420448208),P(   0.500000000),P(   0.594603558),
	P(   0.707106781),P(   0.840896415),P(   1.000000000),P(   1.189207115),P(   1.414213562),P(   1.681792831),P(   2.000000000),P(   2.378414230),P(   2.828427125),P(   3.363585661),P(   4.000000000),P(   4.756828460),P(   5.656854249),P(   6.727171322),P(   8.000000000),P(   9.513656920),
	P(  11.313708499),P(  13.454342644),P(  16.000000000),P(  19.027313840),P(  22.627416998),P(  26.908685288),P(  32.000000000),P(  38.054627680),P(  45.254833996),P(  53.817370576),P(  64.000000000),P(  76.109255360),P(  90.509667992),P( 107.634741152),P( 128.000000000),P( 152.218510720),
	P( 181.019335984),P( 215.269482305),P( 256.000000000),P( 304.437021441),P( 362.038671968),P( 430.538964610),P( 512.000000000),P( 608.874042881),P( 724.077343935),P( 861.077929220),P(1024.000000000),P(1217.748085763),P(1448.154687870),P(1722.155858440),P(2048.000000000),P(2435.496171526),
#undef P
};

/* ܂蒮ɉeȂB
 * [0`21]Ȃ̂ŁA5rbgȏKvB
 *
 *	for(i = 0; i <= MP3_PRE_REQUANTIZE_MAX; i++) {
 *		mp3_pow1_3_table[i] = pow(fabs(i), 1.0 / 3.0);
 *	}
 */
const short mp3_pow1_3_table[MP3_PRE_REQUANTIZE_MAX + 1] = { /* 1.5.10 */
#define P(d)	((short)((d) * (1 << 10)))
	P( 0.000000000),P( 1.000000000),P( 1.259921050),P( 1.442249570),P( 1.587401052),P( 1.709975947),P( 1.817120593),P( 1.912931183),P( 2.000000000),P( 2.080083823),P( 2.154434690),P( 2.223980091),P( 2.289428485),P( 2.351334688),P( 2.410142264),P( 2.466212074),
	P( 2.519842100),P( 2.571281591),P( 2.620741394),P( 2.668401649),P( 2.714417617),P( 2.758924176),P( 2.802039331),P( 2.843866980),P( 2.884499141),P( 2.924017738),P( 2.962496068),P( 3.000000000),P( 3.036588972),P( 3.072316826),P( 3.107232506),P( 3.141380652),
	P( 3.174802104),P( 3.207534330),P( 3.239611801),P( 3.271066310),P( 3.301927249),P( 3.332221852),P( 3.361975407),P( 3.391211443),P( 3.419951893),P( 3.448217240),P( 3.476026645),P( 3.503398060),P( 3.530348335),P( 3.556893304),P( 3.583047871),P( 3.608826080),
	P( 3.634241186),P( 3.659305710),P( 3.684031499),P( 3.708429769),P( 3.732511157),P( 3.756285754),P( 3.779763150),P( 3.802952461),P( 3.825862366),P( 3.848501131),P( 3.870876641),P( 3.892996416),P( 3.914867641),P( 3.936497183),P( 3.957891610),P( 3.979057208),
	P( 4.000000000),P( 4.020725759),P( 4.041240021),P( 4.061548100),P( 4.081655102),P( 4.101565930),P( 4.121285300),P( 4.140817749),P( 4.160167646),P( 4.179339196),P( 4.198336454),P( 4.217163327),P( 4.235823584),P( 4.254320865),P( 4.272658682),P( 4.290840427),
	P( 4.308869380),P( 4.326748711),P( 4.344481486),P( 4.362070671),P( 4.379519140),P( 4.396829672),P( 4.414004962),P( 4.431047622),P( 4.447960181),P( 4.464745096),P( 4.481404747),P( 4.497941445),P( 4.514357435),P( 4.530654896),P( 4.546835944),P( 4.562902635),
	P( 4.578856970),P( 4.594700892),P( 4.610436292),P( 4.626065009),P( 4.641588834),P( 4.657009508),P( 4.672328728),P( 4.687548148),P( 4.702669375),P( 4.717693980),P( 4.732623491),P( 4.747459399),P( 4.762203156),P( 4.776856181),P( 4.791419857),P( 4.805895534),
	P( 4.820284528),P( 4.834588127),P( 4.848807586),P( 4.862944131),P( 4.876998961),P( 4.890973247),P( 4.904868132),P( 4.918684734),P( 4.932424149),P( 4.946087443),P( 4.959675664),P( 4.973189833),P( 4.986630952),P( 5.000000000),P( 5.013297935),P( 5.026525695),
	P( 5.039684200),P( 5.052774347),P( 5.065797019),P( 5.078753078),P( 5.091643370),P( 5.104468722),P( 5.117229947),P( 5.129927840),P( 5.142563181),P( 5.155136735),P( 5.167649252),P( 5.180101467),P( 5.192494102),P( 5.204827863),P( 5.217103446),P( 5.229321532),
	P( 5.241482788),P( 5.253587872),P( 5.265637428),P( 5.277632088),P( 5.289572473),P( 5.301459192),P( 5.313292846),P( 5.325074022),P( 5.336803297),P( 5.348481241),P( 5.360108411),P( 5.371685355),P( 5.383212612),P( 5.394690712),P( 5.406120176),P( 5.417501515),
	P( 5.428835233),P( 5.440121825),P( 5.451361778),P( 5.462555571),P( 5.473703675),P( 5.484806552),P( 5.495864660),P( 5.506878446),P( 5.517848353),P( 5.528774814),P( 5.539658257),P( 5.550499103),P( 5.561297767),P( 5.572054656),P( 5.582770172),P( 5.593444710),
	P( 5.604078661),P( 5.614672408),P( 5.625226328),P( 5.635740795),P( 5.646216173),P( 5.656652826),P( 5.667051108),P( 5.677411371),P( 5.687733960),P( 5.698019215),P( 5.708267473),P( 5.718479065),P( 5.728654316),P( 5.738793548),P( 5.748897079),P( 5.758965220),
	P( 5.768998281),P( 5.778996565),P( 5.788960372),P( 5.798889998),P( 5.808785734),P( 5.818647867),P( 5.828476683),P( 5.838272461),P( 5.848035476),P( 5.857766003),P( 5.867464308),P( 5.877130659),P( 5.886765317),P( 5.896368540),P( 5.905940584),P( 5.915481700),
	P( 5.924992137),P( 5.934472140),P( 5.943921953),P( 5.953341813),P( 5.962731958),P( 5.972092620),P( 5.981424030),P( 5.990726415),P( 6.000000000),P( 6.009245007),P( 6.018461655),P( 6.027650160),P( 6.036810737),P( 6.045943596),P( 6.055048947),P( 6.064126995),
	P( 6.073177944),P( 6.082201996),P( 6.091199349),P( 6.100170200),P( 6.109114744),P( 6.118033173),P( 6.126925675),P( 6.135792440),P( 6.144633651),P( 6.153449494),P( 6.162240148),P( 6.171005793),P( 6.179746606),P( 6.188462762),P( 6.197154435),P( 6.205821795),
	P( 6.214465012),P( 6.223084253),P( 6.231679684),P( 6.240251469),P( 6.248799770),P( 6.257324746),P( 6.265826556),P( 6.274305357),P( 6.282761305),P( 6.291194552),P( 6.299605249),P( 6.307993549),P( 6.316359598),P( 6.324703543),P( 6.333025531),P( 6.341325705),
	P( 6.349604208),P( 6.357861180),P( 6.366096760),P( 6.374311088),P( 6.382504299),P( 6.390676528),P( 6.398827910),P( 6.406958577),P( 6.415068660),P( 6.423158289),P( 6.431227591),P( 6.439276696),P( 6.447305727),P( 6.455314811),P( 6.463304070),P( 6.471273627),
	P( 6.479223603),P( 6.487154117),P( 6.495065288),P( 6.502957234),P( 6.510830072),P( 6.518683915),P( 6.526518879),P( 6.534335077),P( 6.542132620),P( 6.549911620),P( 6.557672186),P( 6.565414427),P( 6.573138451),P( 6.580844365),P( 6.588532275),P( 6.596202284),
	P( 6.603854498),P( 6.611489018),P( 6.619105948),P( 6.626705387),P( 6.634287437),P( 6.641852195),P( 6.649399761),P( 6.656930232),P( 6.664443703),P( 6.671940272),P( 6.679420032),P( 6.686883077),P( 6.694329501),P( 6.701759395),P( 6.709172852),P( 6.716569962),
	P( 6.723950814),P( 6.731315497),P( 6.738664101),P( 6.745996712),P( 6.753313417),P( 6.760614302),P( 6.767899452),P( 6.775168952),P( 6.782422886),P( 6.789661336),P( 6.796884386),P( 6.804092116),P( 6.811284608),P( 6.818461941),P( 6.825624197),P( 6.832771452),
	P( 6.839903787),P( 6.847021278),P( 6.854124002),P( 6.861212036),P( 6.868285455),P( 6.875344335),P( 6.882388750),P( 6.889418775),P( 6.896434481),P( 6.903435942),P( 6.910423230),P( 6.917396417),P( 6.924355573),P( 6.931300768),P( 6.938232074),P( 6.945149558),
	P( 6.952053290),P( 6.958943337),P( 6.965819768),P( 6.972682649),P( 6.979532047),P( 6.986368028),P( 6.993190657),P( 7.000000000),P( 7.006796121),P( 7.013579083),P( 7.020348952),P( 7.027105788),P( 7.033849656),P( 7.040580617),P( 7.047298732),P( 7.054004063),
	P( 7.060696671),P( 7.067376615),P( 7.074043955),P( 7.080698751),P( 7.087341062),P( 7.093970945),P( 7.100588459),P( 7.107193661),P( 7.113786609),P( 7.120367359),P( 7.126935967),P( 7.133492490),P( 7.140036982),P( 7.146569499),P( 7.153090095),P( 7.159598825),
	P( 7.166095742),P( 7.172580900),P( 7.179054352),P( 7.185516151),P( 7.191966348),P( 7.198404996),P( 7.204832147),P( 7.211247852),P( 7.217652160),P( 7.224045124),P( 7.230426793),P( 7.236797216),P( 7.243156443),P( 7.249504524),P( 7.255841507),P( 7.262167440),
	P( 7.268482371),P( 7.274786349),P( 7.281079420),P( 7.287361631),P( 7.293633030),P( 7.299893662),P( 7.306143574),P( 7.312382812),P( 7.318611420),P( 7.324829445),P( 7.331036930),P( 7.337233921),P( 7.343420462),P( 7.349596597),P( 7.355762368),P( 7.361917821),
	P( 7.368062997),P( 7.374197940),P( 7.380322692),P( 7.386437295),P( 7.392541792),P( 7.398636223),P( 7.404720631),P( 7.410795055),P( 7.416859539),P( 7.422914120),P( 7.428958841),P( 7.434993742),P( 7.441018861),P( 7.447034238),P( 7.453039914),P( 7.459035926),
	P( 7.465022314),P( 7.470999115),P( 7.476966370),P( 7.482924114),P( 7.488872387),P( 7.494811226),P( 7.500740668),P( 7.506660750),P( 7.512571508),P( 7.518472981),P( 7.524365204),P( 7.530248212),P( 7.536122043),P( 7.541986732),P( 7.547842314),P( 7.553688825),
	P( 7.559526299),P( 7.565354772),P( 7.571174278),P( 7.576984852),P( 7.582786527),P( 7.588579338),P( 7.594363318),P( 7.600138502),P( 7.605904922),P( 7.611662611),P( 7.617411603),P( 7.623151931),P( 7.628883626),P( 7.634606721),P( 7.640321250),P( 7.646027242),
	P( 7.651724731),P( 7.657413748),P( 7.663094324),P( 7.668766491),P( 7.674430279),P( 7.680085720),P( 7.685732843),P( 7.691371681),P( 7.697002263),P( 7.702624618),P( 7.708238778),P( 7.713844772),P( 7.719442629),P( 7.725032380),P( 7.730614053),P( 7.736187677),
	P( 7.741753281),P( 7.747310895),P( 7.752860547),P( 7.758402264),P( 7.763936077),P( 7.769462012),P( 7.774980097),P( 7.780490361),P( 7.785992832),P( 7.791487536),P( 7.796974501),P( 7.802453754),P( 7.807925322),P( 7.813389232),P( 7.818845511),P( 7.824294186),
	P( 7.829735282),P( 7.835168827),P( 7.840594846),P( 7.846013365),P( 7.851424411),P( 7.856828008),P( 7.862224183),P( 7.867612960),P( 7.872994366),P( 7.878368425),P( 7.883735163),P( 7.889094604),P( 7.894446773),P( 7.899791695),P( 7.905129393),P( 7.910459893),
	P( 7.915783219),P( 7.921099395),P( 7.926408444),P( 7.931710392),P( 7.937005260),P( 7.942293073),P( 7.947573855),P( 7.952847628),P( 7.958114416),P( 7.963374242),P( 7.968627129),P( 7.973873099),P( 7.979112176),P( 7.984344383),P( 7.989569740),P( 7.994788272),
	P( 8.000000000),P( 8.005204946),P( 8.010403133),P( 8.015594581),P( 8.020779314),P( 8.025957353),P( 8.031128718),P( 8.036293433),P( 8.041451517),P( 8.046602993),P( 8.051747881),P( 8.056886203),P( 8.062017979),P( 8.067143230),P( 8.072261977),P( 8.077374241),
	P( 8.082480041),P( 8.087579399),P( 8.092672335),P( 8.097758868),P( 8.102839019),P( 8.107912808),P( 8.112980255),P( 8.118041379),P( 8.123096201),P( 8.128144739),P( 8.133187014),P( 8.138223044),P( 8.143252850),P( 8.148276449),P( 8.153293862),P( 8.158305107),
	P( 8.163310204),P( 8.168309170),P( 8.173302026),P( 8.178288788),P( 8.183269477),P( 8.188244110),P( 8.193212706),P( 8.198175283),P( 8.203131859),P( 8.208082453),P( 8.213027082),P( 8.217965765),P( 8.222898519),P( 8.227825361),P( 8.232746311),P( 8.237661384),
	P( 8.242570600),P( 8.247473974),P( 8.252371525),P( 8.257263270),P( 8.262149226),P( 8.267029409),P( 8.271903838),P( 8.276772529),P( 8.281635499),P( 8.286492764),P( 8.291344342),P( 8.296190248),P( 8.301030501),P( 8.305865115),P( 8.310694107),P( 8.315517494),
	P( 8.320335292),P( 8.325147517),P( 8.329954186),P( 8.334755313),P( 8.339550915),P( 8.344341009),P( 8.349125609),P( 8.353904732),P( 8.358678393),P( 8.363446607),P( 8.368209391),P( 8.372966760),P( 8.377718728),P( 8.382465312),P( 8.387206527),P( 8.391942387),
	P( 8.396672908),P( 8.401398104),P( 8.406117992),P( 8.410832585),P( 8.415541899),P( 8.420245948),P( 8.424944747),P( 8.429638310),P( 8.434326653),P( 8.439009789),P( 8.443687734),P( 8.448360500),P( 8.453028104),P( 8.457690558),P( 8.462347878),P( 8.467000076),
	P( 8.471647169),P( 8.476289168),P( 8.480926088),P( 8.485557944),P( 8.490184749),P( 8.494806516),P( 8.499423260),P( 8.504034993),P( 8.508641730),P( 8.513243484),P( 8.517840269),P( 8.522432098),P( 8.527018983),P( 8.531600940),P( 8.536177980),P( 8.540750116),
	P( 8.545317363),P( 8.549879733),P( 8.554437239),P( 8.558989894),P( 8.563537711),P( 8.568080703),P( 8.572618882),P( 8.577152262),P( 8.581680854),P( 8.586204672),P( 8.590723728),P( 8.595238034),P( 8.599747604),P( 8.604252449),P( 8.608752582),P( 8.613248015),
	P( 8.617738760),P( 8.622224830),P( 8.626706237),P( 8.631182992),P( 8.635655108),P( 8.640122598),P( 8.644585472),P( 8.649043743),P( 8.653497422),P( 8.657946522),P( 8.662391053),P( 8.666831029),P( 8.671266460),P( 8.675697359),P( 8.680123736),P( 8.684545603),
	P( 8.688962972),P( 8.693375853),P( 8.697784260),P( 8.702188202),P( 8.706587691),P( 8.710982739),P( 8.715373356),P( 8.719759553),P( 8.724141343),P( 8.728518735),P( 8.732891741),P( 8.737260372),P( 8.741624639),P( 8.745984552),P( 8.750340123),P( 8.754691362),
	P( 8.759038280),P( 8.763380887),P( 8.767719196),P( 8.772053215),P( 8.776382955),P( 8.780708428),P( 8.785029644),P( 8.789346612),P( 8.793659344),P( 8.797967850),P( 8.802272141),P( 8.806572225),P( 8.810868115),P( 8.815159819),P( 8.819447349),P( 8.823730714),
	P( 8.828009925),P( 8.832284991),P( 8.836555922),P( 8.840822729),P( 8.845085422),P( 8.849344010),P( 8.853598503),P( 8.857848911),P( 8.862095243),P( 8.866337511),P( 8.870575722),P( 8.874809888),P( 8.879040017),P( 8.883266120),P( 8.887488205),P( 8.891706283),
	P( 8.895920362),P( 8.900130453),P( 8.904336564),P( 8.908538706),P( 8.912736887),P( 8.916931117),P( 8.921121404),P( 8.925307760),P( 8.929490191),P( 8.933668708),P( 8.937843321),P( 8.942014037),P( 8.946180866),P( 8.950343817),P( 8.954502899),P( 8.958658122),
	P( 8.962809493),P( 8.966957022),P( 8.971100718),P( 8.975240590),P( 8.979376646),P( 8.983508896),P( 8.987637347),P( 8.991762009),P( 8.995882891),P( 9.000000000),P( 9.004113346),P( 9.008222937),P( 9.012328783),P( 9.016430890),P( 9.020529268),P( 9.024623926),
	P( 9.028714871),P( 9.032802112),P( 9.036885658),P( 9.040965517),P( 9.045041697),P( 9.049114206),P( 9.053183053),P( 9.057248245),P( 9.061309792),P( 9.065367701),P( 9.069421981),P( 9.073472639),P( 9.077519683),P( 9.081563122),P( 9.085602964),P( 9.089639217),
	P( 9.093671888),P( 9.097700985),P( 9.101726517),P( 9.105748491),P( 9.109766916),P( 9.113781798),P( 9.117793146),P( 9.121800968),P( 9.125805271),P( 9.129806063),P( 9.133803351),P( 9.137797144),P( 9.141787449),P( 9.145774274),P( 9.149757625),P( 9.153737512),
	P( 9.157713940),P( 9.161686919),P( 9.165656454),P( 9.169622555),P( 9.173585227),P( 9.177544479),P( 9.181500317),P( 9.185452750),P( 9.189401784),P( 9.193347428),P( 9.197289687),P( 9.201228569),P( 9.205164083),P( 9.209096233),P( 9.213025029),P( 9.216950477),
	P( 9.220872584),P( 9.224791357),P( 9.228706804),P( 9.232618931),P( 9.236527746),P( 9.240433255),P( 9.244335465),P( 9.248234384),P( 9.252130018),P( 9.256022375),P( 9.259911460),P( 9.263797282),P( 9.267679846),P( 9.271559160),P( 9.275435230),P( 9.279308064),
	P( 9.283177667),P( 9.287044047),P( 9.290907211),P( 9.294767164),P( 9.298623915),P( 9.302477468),P( 9.306327832),P( 9.310175012),P( 9.314019016),P( 9.317859849),P( 9.321697518),P( 9.325532030),P( 9.329363391),P( 9.333191608),P( 9.337016687),P( 9.340838634),
	P( 9.344657457),P( 9.348473160),P( 9.352285752),P( 9.356095237),P( 9.359901623),P( 9.363704916),P( 9.367505121),P( 9.371302245),P( 9.375096295),P( 9.378887277),P( 9.382675196),P( 9.386460060),P( 9.390241873),P( 9.394020643),P( 9.397796375),P( 9.401569076),
	P( 9.405338751),P( 9.409105407),P( 9.412869049),P( 9.416629685),P( 9.420387319),P( 9.424141957),P( 9.427893606),P( 9.431642272),P( 9.435387961),P( 9.439130677),P( 9.442870428),P( 9.446607220),P( 9.450341057),P( 9.454071946),P( 9.457799893),P( 9.461524903),
	P( 9.465246982),P( 9.468966137),P( 9.472682372),P( 9.476395693),P( 9.480106107),P( 9.483813619),P( 9.487518234),P( 9.491219958),P( 9.494918797),P( 9.498614756),P( 9.502307842),P( 9.505998059),P( 9.509685413),P( 9.513369910),P( 9.517051555),P( 9.520730354),
	P( 9.524406312),P( 9.528079435),P( 9.531749727),P( 9.535417196),P( 9.539081846),P( 9.542743682),P( 9.546402709),P( 9.550058934),P( 9.553712362),P( 9.557362998),P( 9.561010846),P( 9.564655914),P( 9.568298205),P( 9.571937726),P( 9.575574480),P( 9.579208475),
	P( 9.582839714),P( 9.586468204),P( 9.590093948),P( 9.593716954),P( 9.597337224),P( 9.600954766),P( 9.604569584),P( 9.608181683),P( 9.611791067),P( 9.615397744),P( 9.619001716),P( 9.622602990),P( 9.626201570),P( 9.629797462),P( 9.633390671),P( 9.636981200),
	P( 9.640569057),P( 9.644154244),P( 9.647736769),P( 9.651316634),P( 9.654893846),P( 9.658468409),P( 9.662040328),P( 9.665609608),P( 9.669176254),P( 9.672740271),P( 9.676301663),P( 9.679860436),P( 9.683416593),P( 9.686970141),P( 9.690521083),P( 9.694069425),
	P( 9.697615172),P( 9.701158327),P( 9.704698896),P( 9.708236884),P( 9.711772294),P( 9.715305133),P( 9.718835404),P( 9.722363112),P( 9.725888262),P( 9.729410859),P( 9.732930906),P( 9.736448410),P( 9.739963373),P( 9.743475802),P( 9.746985700),P( 9.750493072),
	P( 9.753997922),P( 9.757500256),P( 9.761000077),P( 9.764497390),P( 9.767992199),P( 9.771484510),P( 9.774974326),P( 9.778461653),P( 9.781946493),P( 9.785428852),P( 9.788908735),P( 9.792386145),P( 9.795861087),P( 9.799333566),P( 9.802803585),P( 9.806271149),
	P( 9.809736263),P( 9.813198931),P( 9.816659156),P( 9.820116944),P( 9.823572299),P( 9.827025224),P( 9.830475725),P( 9.833923805),P( 9.837369469),P( 9.840812721),P( 9.844253565),P( 9.847692005),P( 9.851128046),P( 9.854561691),P( 9.857992945),P( 9.861421813),
	P( 9.864848297),P( 9.868272403),P( 9.871694135),P( 9.875113495),P( 9.878530490),P( 9.881945122),P( 9.885357396),P( 9.888767317),P( 9.892174886),P( 9.895580110),P( 9.898982992),P( 9.902383537),P( 9.905781747),P( 9.909177627),P( 9.912571181),P( 9.915962413),
	P( 9.919351328),P( 9.922737928),P( 9.926122218),P( 9.929504202),P( 9.932883884),P( 9.936261267),P( 9.939636356),P( 9.943009155),P( 9.946379667),P( 9.949747896),P( 9.953113846),P( 9.956477521),P( 9.959838925),P( 9.963198061),P( 9.966554934),P( 9.969909547),
	P( 9.973261904),P( 9.976612010),P( 9.979959866),P( 9.983305478),P( 9.986648849),P( 9.989989983),P( 9.993328884),P( 9.996665555),P(10.000000000),P(10.003332223),P(10.006662227),P(10.009990017),P(10.013315595),P(10.016638966),P(10.019960133),P(10.023279100),
	P(10.026595870),P(10.029910447),P(10.033222835),P(10.036533038),P(10.039841058),P(10.043146900),P(10.046450567),P(10.049752063),P(10.053051391),P(10.056348554),P(10.059643557),P(10.062936403),P(10.066227096),P(10.069515638),P(10.072802034),P(10.076086286),
	P(10.079368399),P(10.082648376),P(10.085926220),P(10.089201936),P(10.092475525),P(10.095746992),P(10.099016340),P(10.102283573),P(10.105548694),P(10.108811707),P(10.112072614),P(10.115331419),P(10.118588127),P(10.121842739),P(10.125095259),P(10.128345691),
	P(10.131594038),P(10.134840304),P(10.138084491),P(10.141326603),P(10.144566644),P(10.147804616),P(10.151040524),P(10.154274369),P(10.157506156),P(10.160735888),P(10.163963568),P(10.167189199),P(10.170412785),P(10.173634329),P(10.176853834),P(10.180071303),
	P(10.183286739),P(10.186500147),P(10.189711528),P(10.192920886),P(10.196128224),P(10.199333546),P(10.202536855),P(10.205738153),P(10.208937444),P(10.212134731),P(10.215330018),P(10.218523306),P(10.221714601),P(10.224903903),P(10.228091218),P(10.231276547),
	P(10.234459894),P(10.237641262),P(10.240820654),P(10.243998073),P(10.247173522),P(10.250347004),P(10.253518522),P(10.256688080),P(10.259855680),P(10.263021325),P(10.266185019),P(10.269346764),P(10.272506563),P(10.275664420),P(10.278820336),P(10.281974316),
	P(10.285126363),P(10.288276478),P(10.291424666),P(10.294570928),P(10.297715269),P(10.300857691),P(10.303998196),P(10.307136789),P(10.310273471),P(10.313408246),P(10.316541116),P(10.319672085),P(10.322801155),P(10.325928329),P(10.329053610),P(10.332177001),
	P(10.335298505),P(10.338418124),P(10.341535862),P(10.344651721),P(10.347765704),P(10.350877815),P(10.353988054),P(10.357096427),P(10.360202935),P(10.363307581),P(10.366410368),P(10.369511298),P(10.372610375),P(10.375707602),P(10.378802980),P(10.381896513),
	P(10.384988204),P(10.388078055),P(10.391166068),P(10.394252248),P(10.397336596),P(10.400419115),P(10.403499808),P(10.406578678),P(10.409655727),P(10.412730958),P(10.415804373),P(10.418875976),P(10.421945769),P(10.425013754),P(10.428079935),P(10.431144313),
	P(10.434206893),P(10.437267675),P(10.440326663),P(10.443383860),P(10.446439268),P(10.449492890),P(10.452544728),P(10.455594785),P(10.458643064),P(10.461689566),P(10.464734296),P(10.467777254),P(10.470818445),P(10.473857870),P(10.476895532),P(10.479931433),
	P(10.482965577),P(10.485997965),P(10.489028600),P(10.492057486),P(10.495084623),P(10.498110015),P(10.501133664),P(10.504155574),P(10.507175745),P(10.510194181),P(10.513210885),P(10.516225858),P(10.519239103),P(10.522250623),P(10.525260421),P(10.528268497),
	P(10.531274856),P(10.534279500),P(10.537282430),P(10.540283650),P(10.543283162),P(10.546280968),P(10.549277071),P(10.552271472),P(10.555264176),P(10.558255183),P(10.561244497),P(10.564232119),P(10.567218053),P(10.570202300),P(10.573184862),P(10.576165744),
	P(10.579144945),P(10.582122470),P(10.585098320),P(10.588072498),P(10.591045006),P(10.594015846),P(10.596985021),P(10.599952533),P(10.602918385),P(10.605882578),P(10.608845115),P(10.611805999),P(10.614765231),P(10.617722814),P(10.620678750),P(10.623633042),
	P(10.626585692),P(10.629536702),P(10.632486074),P(10.635433811),P(10.638379914),P(10.641324387),P(10.644267231),P(10.647208449),P(10.650148043),P(10.653086015),P(10.656022368),P(10.658957103),P(10.661890223),P(10.664821730),P(10.667751626),P(10.670679913),
	P(10.673606595),P(10.676531672),P(10.679455148),P(10.682377023),P(10.685297301),P(10.688215984),P(10.691133074),P(10.694048573),P(10.696962482),P(10.699874806),P(10.702785544),P(10.705694701),P(10.708602277),P(10.711508275),P(10.714412697),P(10.717315545),
	P(10.720216822),P(10.723116529),P(10.726014669),P(10.728911243),P(10.731806255),P(10.734699705),P(10.737591596),P(10.740481930),P(10.743370710),P(10.746257937),P(10.749143613),P(10.752027741),P(10.754910322),P(10.757791359),P(10.760670854),P(10.763548808),
	P(10.766425224),P(10.769300104),P(10.772173450),P(10.775045264),P(10.777915548),P(10.780784304),P(10.783651534),P(10.786517240),P(10.789381424),P(10.792244089),P(10.795105235),P(10.797964866),P(10.800822983),P(10.803679588),P(10.806534683),P(10.809388270),
	P(10.812240352),P(10.815090929),P(10.817940005),P(10.820787581),P(10.823633659),P(10.826478240),P(10.829321328),P(10.832162924),P(10.835003030),P(10.837841648),P(10.840678779),P(10.843514426),P(10.846348591),P(10.849181276),P(10.852012482),P(10.854842211),
	P(10.857670466),P(10.860497249),P(10.863322560),P(10.866146403),P(10.868968779),P(10.871789690),P(10.874609137),P(10.877427124),P(10.880243651),P(10.883058720),P(10.885872335),P(10.888684495),P(10.891495203),P(10.894304462),P(10.897112273),P(10.899918637),
	P(10.902723557),P(10.905527035),P(10.908329071),P(10.911129669),P(10.913928831),P(10.916726557),P(10.919522849),P(10.922317711),P(10.925111143),P(10.927903147),P(10.930693725),P(10.933482879),P(10.936270610),P(10.939056921),P(10.941841814),P(10.944625289),
	P(10.947407350),P(10.950187997),P(10.952967232),P(10.955745058),P(10.958521476),P(10.961296488),P(10.964070096),P(10.966842301),P(10.969613105),P(10.972382510),P(10.975150518),P(10.977917130),P(10.980682349),P(10.983446175),P(10.986208611),P(10.988969659),
	P(10.991729320),P(10.994487596),P(10.997244489),P(11.000000000),P(11.002754131),P(11.005506885),P(11.008258261),P(11.011008264),P(11.013756893),P(11.016504151),P(11.019250039),P(11.021994560),P(11.024737714),P(11.027479505),P(11.030219932),P(11.032958998),
	P(11.035696706),P(11.038433055),P(11.041168048),P(11.043901688),P(11.046633974),P(11.049364910),P(11.052094496),P(11.054822735),P(11.057549627),P(11.060275176),P(11.062999382),P(11.065722246),P(11.068443772),P(11.071163960),P(11.073882812),P(11.076600329),
	P(11.079316514),P(11.082031367),P(11.084744891),P(11.087457087),P(11.090167957),P(11.092877502),P(11.095585724),P(11.098292625),P(11.100998206),P(11.103702469),P(11.106405415),P(11.109107046),P(11.111807364),P(11.114506370),P(11.117204066),P(11.119900453),
	P(11.122595533),P(11.125289308),P(11.127981779),P(11.130672947),P(11.133362815),P(11.136051384),P(11.138738655),P(11.141424630),P(11.144109311),P(11.146792699),P(11.149474795),P(11.152155602),P(11.154835121),P(11.157513353),P(11.160190299),P(11.162865962),
	P(11.165540343),P(11.168213444),P(11.170885265),P(11.173555809),P(11.176225077),P(11.178893071),P(11.181559792),P(11.184225241),P(11.186889421),P(11.189552332),P(11.192213976),P(11.194874355),P(11.197533470),P(11.200191323),P(11.202847915),P(11.205503248),
	P(11.208157323),P(11.210810141),P(11.213461705),P(11.216112015),P(11.218761073),P(11.221408881),P(11.224055439),P(11.226700751),P(11.229344816),P(11.231987637),P(11.234629214),P(11.237269550),P(11.239908646),P(11.242546503),P(11.245183123),P(11.247818507),
	P(11.250452657),P(11.253085573),P(11.255717259),P(11.258347714),P(11.260976940),P(11.263604940),P(11.266231713),P(11.268857263),P(11.271481589),P(11.274104694),P(11.276726579),P(11.279347245),P(11.281966694),P(11.284584928),P(11.287201946),P(11.289817752),
	P(11.292432347),P(11.295045731),P(11.297657906),P(11.300268874),P(11.302878636),P(11.305487193),P(11.308094547),P(11.310700700),P(11.313305652),P(11.315909404),P(11.318511960),P(11.321113318),P(11.323713482),P(11.326312453),P(11.328910231),P(11.331506818),
	P(11.334102216),P(11.336696426),P(11.339289449),P(11.341881287),P(11.344471940),P(11.347061411),P(11.349649701),P(11.352236811),P(11.354822742),P(11.357407495),P(11.359991073),P(11.362573476),P(11.365154706),P(11.367734764),P(11.370313651),P(11.372891369),
	P(11.375467919),P(11.378043303),P(11.380617521),P(11.383190575),P(11.385762466),P(11.388333196),P(11.390902766),P(11.393471177),P(11.396038431),P(11.398604528),P(11.401169471),P(11.403733260),P(11.406295896),P(11.408857382),P(11.411417718),P(11.413976906),
	P(11.416534947),P(11.419091842),P(11.421647592),P(11.424202199),P(11.426755664),P(11.429307988),P(11.431859173),P(11.434409220),P(11.436958130),P(11.439505904),P(11.442052544),P(11.444598051),P(11.447142426),P(11.449685670),P(11.452227785),P(11.454768772),
	P(11.457308632),P(11.459847367),P(11.462384977),P(11.464921464),P(11.467456829),P(11.469991074),P(11.472524199),P(11.475056206),P(11.477587097),P(11.480116871),P(11.482645531),P(11.485173078),P(11.487699513),P(11.490224838),P(11.492749052),P(11.495272159),
	P(11.497794158),P(11.500315051),P(11.502834840),P(11.505353525),P(11.507871108),P(11.510387590),P(11.512902972),P(11.515417255),P(11.517930441),P(11.520442531),P(11.522953525),P(11.525463426),P(11.527972234),P(11.530479950),P(11.532986576),P(11.535492113),
	P(11.537996562),P(11.540499925),P(11.543002202),P(11.545503394),P(11.548003503),P(11.550502530),P(11.553000476),P(11.555497342),P(11.557993130),P(11.560487841),P(11.562981475),P(11.565474034),P(11.567965519),P(11.570455932),P(11.572945273),P(11.575433543),
	P(11.577920744),P(11.580406877),P(11.582891943),P(11.585375943),P(11.587858878),P(11.590340750),P(11.592821559),P(11.595301307),P(11.597779995),P(11.600257624),P(11.602734195),P(11.605209709),P(11.607684167),P(11.610157571),P(11.612629922),P(11.615101220),
	P(11.617571467),P(11.620040664),P(11.622508812),P(11.624975912),P(11.627441966),P(11.629906974),P(11.632370937),P(11.634833857),P(11.637295735),P(11.639756572),P(11.642216368),P(11.644675126),P(11.647132845),P(11.649589528),P(11.652045175),P(11.654499788),
	P(11.656953367),P(11.659405913),P(11.661857428),P(11.664307913),P(11.666757369),P(11.669205797),P(11.671653197),P(11.674099572),P(11.676544922),P(11.678989248),P(11.681432551),P(11.683874832),P(11.686316093),P(11.688756335),P(11.691195558),P(11.693633764),
	P(11.696070953),P(11.698507127),P(11.700942287),P(11.703376433),P(11.705809568),P(11.708241691),P(11.710672804),P(11.713102909),P(11.715532005),P(11.717960095),P(11.720387179),P(11.722813258),P(11.725238333),P(11.727662405),P(11.730085476),P(11.732507546),
	P(11.734928617),P(11.737348689),P(11.739767763),P(11.742185841),P(11.744602924),P(11.747019011),P(11.749434106),P(11.751848208),P(11.754261318),P(11.756673439),P(11.759084569),P(11.761494712),P(11.763903867),P(11.766312036),P(11.768719219),P(11.771125418),
	P(11.773530634),P(11.775934867),P(11.778338119),P(11.780740391),P(11.783141683),P(11.785541998),P(11.787941334),P(11.790339695),P(11.792737080),P(11.795133491),P(11.797528928),P(11.799923393),P(11.802316887),P(11.804709410),P(11.807100964),P(11.809491549),
	P(11.811881167),P(11.814269819),P(11.816657505),P(11.819044226),P(11.821429984),P(11.823814779),P(11.826198613),P(11.828581486),P(11.830963399),P(11.833344354),P(11.835724351),P(11.838103391),P(11.840481475),P(11.842858605),P(11.845234780),P(11.847610003),
	P(11.849984274),P(11.852357593),P(11.854729963),P(11.857101383),P(11.859471855),P(11.861841380),P(11.864209959),P(11.866577592),P(11.868944281),P(11.871310026),P(11.873674829),P(11.876038690),P(11.878401611),P(11.880763592),P(11.883124634),P(11.885484738),
	P(11.887843906),P(11.890202137),P(11.892559433),P(11.894915795),P(11.897271224),P(11.899625721),P(11.901979286),P(11.904331921),P(11.906683626),P(11.909034403),P(11.911384252),P(11.913733174),P(11.916081171),P(11.918428242),P(11.920774389),P(11.923119613),
	P(11.925463915),P(11.927807296),P(11.930149756),P(11.932491297),P(11.934831919),P(11.937171624),P(11.939510411),P(11.941848283),P(11.944185240),P(11.946521282),P(11.948856412),P(11.951190628),P(11.953523934),P(11.955856329),P(11.958187814),P(11.960518391),
	P(11.962848059),P(11.965176821),P(11.967504677),P(11.969831627),P(11.972157673),P(11.974482815),P(11.976807055),P(11.979130393),P(11.981452830),P(11.983774367),P(11.986095005),P(11.988414745),P(11.990733587),P(11.993051533),P(11.995368583),P(11.997684739),
	P(12.000000000),P(12.002314368),P(12.004627845),P(12.006940430),P(12.009252124),P(12.011562929),P(12.013872845),P(12.016181873),P(12.018490014),P(12.020797269),P(12.023103638),P(12.025409123),P(12.027713724),P(12.030017443),P(12.032320279),P(12.034622235),
	P(12.036923310),P(12.039223505),P(12.041522822),P(12.043821261),P(12.046118824),P(12.048415510),P(12.050711321),P(12.053006257),P(12.055300320),P(12.057593510),P(12.059885829),P(12.062177276),P(12.064467853),P(12.066757560),P(12.069046399),P(12.071334370),
	P(12.073621474),P(12.075907711),P(12.078193084),P(12.080477592),P(12.082761236),P(12.085044017),P(12.087325937),P(12.089606994),P(12.091887192),P(12.094166530),P(12.096445009),P(12.098722630),P(12.100999394),P(12.103275301),P(12.105550353),P(12.107824550),
	P(12.110097893),P(12.112370383),P(12.114642020),P(12.116912806),P(12.119182741),P(12.121451826),P(12.123720062),P(12.125987449),P(12.128253989),P(12.130519682),P(12.132784529),P(12.135048530),P(12.137311688),P(12.139574001),P(12.141835472),P(12.144096100),
	P(12.146355888),P(12.148614834),P(12.150872941),P(12.153130209),P(12.155386639),P(12.157642231),P(12.159896987),P(12.162150906),P(12.164403991),P(12.166656242),P(12.168907658),P(12.171158242),P(12.173407994),P(12.175656915),P(12.177905006),P(12.180152266),
	P(12.182398698),P(12.184644301),P(12.186889077),P(12.189133027),P(12.191376150),P(12.193618449),P(12.195859923),P(12.198100573),P(12.200340401),P(12.202579406),P(12.204817590),P(12.207054954),P(12.209291497),P(12.211527222),P(12.213762128),P(12.215996217),
	P(12.218229489),P(12.220461944),P(12.222693585),P(12.224924410),P(12.227154422),P(12.229383621),P(12.231612007),P(12.233839582),P(12.236066345),P(12.238292299),P(12.240517443),P(12.242741778),P(12.244965306),P(12.247188026),P(12.249409940),P(12.251631048),
	P(12.253851350),P(12.256070849),P(12.258289544),P(12.260507436),P(12.262724526),P(12.264940815),P(12.267156303),P(12.269370991),P(12.271584879),P(12.273797970),P(12.276010262),P(12.278221757),P(12.280432456),P(12.282642360),P(12.284851468),P(12.287059782),
	P(12.289267303),P(12.291474031),P(12.293679966),P(12.295885111),P(12.298089465),P(12.300293028),P(12.302495803),P(12.304697789),P(12.306898987),P(12.309099398),P(12.311299023),P(12.313497862),P(12.315695916),P(12.317893186),P(12.320089672),P(12.322285375),
	P(12.324480295),P(12.326674435),P(12.328867793),P(12.331060372),P(12.333252171),P(12.335443191),P(12.337633433),P(12.339822898),P(12.342011586),P(12.344199498),P(12.346386634),P(12.348572996),P(12.350758585),P(12.352943400),P(12.355127442),P(12.357310712),
	P(12.359493212),P(12.361674940),P(12.363855899),P(12.366036089),P(12.368215510),P(12.370394164),P(12.372572050),P(12.374749170),P(12.376925524),P(12.379101113),P(12.381275938),P(12.383449999),P(12.385623296),P(12.387795832),P(12.389967605),P(12.392138617),
	P(12.394308869),P(12.396478362),P(12.398647095),P(12.400815070),P(12.402982286),P(12.405148746),P(12.407314450),P(12.409479397),P(12.411643590),P(12.413807028),P(12.415969712),P(12.418131643),P(12.420292822),P(12.422453248),P(12.424612924),P(12.426771849),
	P(12.428930024),P(12.431087450),P(12.433244127),P(12.435400056),P(12.437555238),P(12.439709674),P(12.441863363),P(12.444016307),P(12.446168506),P(12.448319962),P(12.450470674),P(12.452620643),P(12.454769870),P(12.456918355),P(12.459066100),P(12.461213104),
	P(12.463359369),P(12.465504895),P(12.467649682),P(12.469793732),P(12.471937045),P(12.474079621),P(12.476221462),P(12.478362567),P(12.480502938),P(12.482642575),P(12.484781479),P(12.486919650),P(12.489057090),P(12.491193798),P(12.493329775),P(12.495465022),
	P(12.497599539),P(12.499733328),P(12.501866388),P(12.503998721),P(12.506130326),P(12.508261206),P(12.510391359),P(12.512520788),P(12.514649491),P(12.516777471),P(12.518904728),P(12.521031262),P(12.523157074),P(12.525282164),P(12.527406533),P(12.529530183),
	P(12.531653112),P(12.533775323),P(12.535896815),P(12.538017589),P(12.540137646),P(12.542256987),P(12.544375611),P(12.546493520),P(12.548610715),P(12.550727195),P(12.552842962),P(12.554958015),P(12.557072356),P(12.559185986),P(12.561298904),P(12.563411112),
	P(12.565522610),P(12.567633398),P(12.569743477),P(12.571852849),P(12.573961512),P(12.576069469),P(12.578176719),P(12.580283264),P(12.582389103),P(12.584494238),P(12.586598668),P(12.588702395),P(12.590805419),P(12.592907741),P(12.595009361),P(12.597110280),
	P(12.599210499),P(12.601310017),P(12.603408837),P(12.605506957),P(12.607604379),P(12.609701104),P(12.611797131),P(12.613892462),P(12.615987097),P(12.618081037),P(12.620174282),P(12.622266833),P(12.624358690),P(12.626449855),P(12.628540327),P(12.630630107),
	P(12.632719195),P(12.634807593),P(12.636895301),P(12.638982319),P(12.641068649),P(12.643154289),P(12.645239242),P(12.647323508),P(12.649407087),P(12.651489980),P(12.653572187),P(12.655653709),P(12.657734546),P(12.659814700),P(12.661894170),P(12.663972958),
	P(12.666051063),P(12.668128486),P(12.670205229),P(12.672281291),P(12.674356672),P(12.676431375),P(12.678505398),P(12.680578743),P(12.682651411),P(12.684723401),P(12.686794714),P(12.688865352),P(12.690935313),P(12.693004600),P(12.695073212),P(12.697141151),
	P(12.699208416),P(12.701275008),P(12.703340928),P(12.705406176),P(12.707470753),P(12.709534659),P(12.711597895),P(12.713660462),P(12.715722359),P(12.717783589),P(12.719844150),P(12.721904044),P(12.723963271),P(12.726021831),P(12.728079726),P(12.730136956),
	P(12.732193521),P(12.734249422),P(12.736304659),P(12.738359233),P(12.740413144),P(12.742466394),P(12.744518982),P(12.746570909),P(12.748622176),P(12.750672783),P(12.752722730),P(12.754772019),P(12.756820649),P(12.758868621),P(12.760915937),P(12.762962595),
	P(12.765008598),P(12.767053944),P(12.769098636),P(12.771142673),P(12.773186056),P(12.775228785),P(12.777270861),P(12.779312285),P(12.781353057),P(12.783393177),P(12.785432646),P(12.787471465),P(12.789509634),P(12.791547154),P(12.793584024),P(12.795620246),
	P(12.797655821),P(12.799690748),P(12.801725028),P(12.803758662),P(12.805791650),P(12.807823993),P(12.809855691),P(12.811886744),P(12.813917154),P(12.815946921),P(12.817976045),P(12.820004527),P(12.822032367),P(12.824059566),P(12.826086124),P(12.828112042),
	P(12.830137320),P(12.832161959),P(12.834185959),P(12.836209322),P(12.838232046),P(12.840254133),P(12.842275584),P(12.844296398),P(12.846316577),P(12.848336121),P(12.850355030),P(12.852373304),P(12.854390945),P(12.856407953),P(12.858424328),P(12.860440071),
	P(12.862455183),P(12.864469663),P(12.866483512),P(12.868496731),P(12.870509321),P(12.872521281),P(12.874532613),P(12.876543316),P(12.878553391),P(12.880562839),P(12.882571661),P(12.884579856),P(12.886587425),P(12.888594369),P(12.890600689),P(12.892606384),
	P(12.894611455),P(12.896615902),P(12.898619727),P(12.900622929),P(12.902625510),P(12.904627469),P(12.906628807),P(12.908629524),P(12.910629622),P(12.912629100),P(12.914627959),P(12.916626199),P(12.918623822),P(12.920620827),P(12.922617214),P(12.924612985),
	P(12.926608140),P(12.928602679),P(12.930596603),P(12.932589913),P(12.934582607),P(12.936574689),P(12.938566156),P(12.940557011),P(12.942547254),P(12.944536885),P(12.946525904),P(12.948514312),P(12.950502110),P(12.952489298),P(12.954475876),P(12.956461845),
	P(12.958447205),P(12.960431957),P(12.962416102),P(12.964399639),P(12.966382570),P(12.968364894),P(12.970346612),P(12.972327725),P(12.974308233),P(12.976288137),P(12.978267437),P(12.980246133),P(12.982224226),P(12.984201716),P(12.986178604),P(12.988154891),
	P(12.990130576),P(12.992105661),P(12.994080145),P(12.996054029),P(12.998027314),P(13.000000000),P(13.001972087),P(13.003943577),P(13.005914469),P(13.007884763),P(13.009854461),P(13.011823563),P(13.013792069),P(13.015759979),P(13.017727295),P(13.019694016),
	P(13.021660143),P(13.023625677),P(13.025590617),P(13.027554965),P(13.029518721),P(13.031481885),P(13.033444457),P(13.035406439),P(13.037367830),P(13.039328632),P(13.041288843),P(13.043248466),P(13.045207500),P(13.047165946),P(13.049123804),P(13.051081075),
	P(13.053037759),P(13.054993856),P(13.056949367),P(13.058904293),P(13.060858634),P(13.062812390),P(13.064765562),P(13.066718150),P(13.068670154),P(13.070621576),P(13.072572415),P(13.074522672),P(13.076472347),P(13.078421441),P(13.080369955),P(13.082317888),
	P(13.084265241),P(13.086212014),P(13.088158209),P(13.090103825),P(13.092048863),P(13.093993323),P(13.095937205),P(13.097880511),P(13.099823240),P(13.101765393),P(13.103706971),P(13.105647973),P(13.107588401),P(13.109528254),P(13.111467534),P(13.113406240),
	P(13.115344372),P(13.117281932),P(13.119218920),P(13.121155336),P(13.123091181),P(13.125026455),P(13.126961158),P(13.128895291),P(13.130828855),P(13.132761849),P(13.134694274),P(13.136626131),P(13.138557420),P(13.140488141),P(13.142418295),P(13.144347882),
	P(13.146276903),P(13.148205358),P(13.150133247),P(13.152060571),P(13.153987331),P(13.155913526),P(13.157839158),P(13.159764226),P(13.161688730),P(13.163612673),P(13.165536053),P(13.167458871),P(13.169381128),P(13.171302824),P(13.173223959),P(13.175144534),
	P(13.177064549),P(13.178984005),P(13.180902902),P(13.182821240),P(13.184739021),P(13.186656243),P(13.188572908),P(13.190489016),P(13.192404568),P(13.194319564),P(13.196234004),P(13.198147888),P(13.200061218),P(13.201973993),P(13.203886214),P(13.205797882),
	P(13.207708996),P(13.209619557),P(13.211529565),P(13.213439022),P(13.215347927),P(13.217256280),P(13.219164083),P(13.221071335),P(13.222978037),P(13.224884189),P(13.226789792),P(13.228694846),P(13.230599352),P(13.232503309),P(13.234406719),P(13.236309581),
	P(13.238211896),P(13.240113665),P(13.242014887),P(13.243915564),P(13.245815695),P(13.247715282),P(13.249614324),P(13.251512821),P(13.253410775),P(13.255308185),P(13.257205053),P(13.259101377),P(13.260997159),P(13.262892400),P(13.264787099),P(13.266681257),
	P(13.268574874),P(13.270467951),P(13.272360487),P(13.274252485),P(13.276143943),P(13.278034862),P(13.279925243),P(13.281815086),P(13.283704391),P(13.285593159),P(13.287481390),P(13.289369084),P(13.291256242),P(13.293142865),P(13.295028952),P(13.296914505),
	P(13.298799522),P(13.300684006),P(13.302567955),P(13.304451371),P(13.306334255),P(13.308216605),P(13.310098423),P(13.311979709),P(13.313860463),P(13.315740687),P(13.317620379),P(13.319499541),P(13.321378173),P(13.323256275),P(13.325133848),P(13.327010891),
	P(13.328887407),P(13.330763394),P(13.332638853),P(13.334513784),P(13.336388189),P(13.338262067),P(13.340135418),P(13.342008244),P(13.343880543),P(13.345752318),P(13.347623568),P(13.349494293),P(13.351364494),P(13.353234171),P(13.355103325),P(13.356971955),
	P(13.358840063),P(13.360707649),P(13.362574713),P(13.364441255),P(13.366307276),P(13.368172776),P(13.370037755),P(13.371902214),P(13.373766154),P(13.375629574),P(13.377492475),P(13.379354858),P(13.381216722),P(13.383078068),P(13.384938896),P(13.386799207),
	P(13.388659002),P(13.390518279),P(13.392377041),P(13.394235287),P(13.396093017),P(13.397950232),P(13.399806933),P(13.401663119),P(13.403518791),P(13.405373949),P(13.407228594),P(13.409082726),P(13.410936346),P(13.412789453),P(13.414642048),P(13.416494132),
	P(13.418345704),P(13.420196766),P(13.422047317),P(13.423897358),P(13.425746889),P(13.427595911),P(13.429444424),P(13.431292428),P(13.433139923),P(13.434986911),P(13.436833390),P(13.438679363),P(13.440524828),P(13.442369787),P(13.444214240),P(13.446058186),
	P(13.447901627),P(13.449744563),P(13.451586994),P(13.453428920),P(13.455270342),P(13.457111260),P(13.458951675),P(13.460791586),P(13.462630995),P(13.464469901),P(13.466308304),P(13.468146207),P(13.469983607),P(13.471820507),P(13.473656905),P(13.475492803),
	P(13.477328202),P(13.479163100),P(13.480997499),P(13.482831399),P(13.484664800),P(13.486497702),P(13.488330107),P(13.490162014),P(13.491993423),P(13.493824336),P(13.495654752),P(13.497484671),P(13.499314094),P(13.501143022),P(13.502971454),P(13.504799391),
	P(13.506626833),P(13.508453781),P(13.510280235),P(13.512106196),P(13.513931663),P(13.515756637),P(13.517581118),P(13.519405107),P(13.521228603),P(13.523051609),P(13.524874122),P(13.526696145),P(13.528517677),P(13.530338719),P(13.532159270),P(13.533979332),
	P(13.535798904),P(13.537617988),P(13.539436582),P(13.541254688),P(13.543072306),P(13.544889437),P(13.546706080),P(13.548522236),P(13.550337905),P(13.552153087),P(13.553967784),P(13.555781994),P(13.557595719),P(13.559408960),P(13.561221715),P(13.563033986),
	P(13.564845772),P(13.566657075),P(13.568467894),P(13.570278230),P(13.572088083),P(13.573897453),P(13.575706342),P(13.577514748),P(13.579322673),P(13.581130116),P(13.582937079),P(13.584743561),P(13.586549562),P(13.588355084),P(13.590160126),P(13.591964688),
	P(13.593768772),P(13.595572376),P(13.597375503),P(13.599178151),P(13.600980321),P(13.602782014),P(13.604583230),P(13.606383969),P(13.608184232),P(13.609984018),P(13.611783329),P(13.613582164),P(13.615380523),P(13.617178408),P(13.618975818),P(13.620772754),
	P(13.622569215),P(13.624365203),P(13.626160718),P(13.627955760),P(13.629750329),P(13.631544425),P(13.633338049),P(13.635131202),P(13.636923883),P(13.638716092),P(13.640507831),P(13.642299100),P(13.644089898),P(13.645880226),P(13.647670084),P(13.649459473),
	P(13.651248393),P(13.653036844),P(13.654824827),P(13.656612342),P(13.658399389),P(13.660185968),P(13.661972080),P(13.663757726),P(13.665542904),P(13.667327617),P(13.669111863),P(13.670895644),P(13.672678960),P(13.674461810),P(13.676244195),P(13.678026116),
	P(13.679807573),P(13.681588566),P(13.683369096),P(13.685149162),P(13.686928766),P(13.688707906),P(13.690486584),P(13.692264801),P(13.694042555),P(13.695819848),P(13.697596680),P(13.699373051),P(13.701148961),P(13.702924412),P(13.704699402),P(13.706473932),
	P(13.708248004),P(13.710021616),P(13.711794769),P(13.713567464),P(13.715339701),P(13.717111480),P(13.718882801),P(13.720653665),P(13.722424072),P(13.724194022),P(13.725963516),P(13.727732553),P(13.729501135),P(13.731269262),P(13.733036933),P(13.734804149),
	P(13.736570911),P(13.738337218),P(13.740103071),P(13.741868470),P(13.743633416),P(13.745397909),P(13.747161949),P(13.748925536),P(13.750688671),P(13.752451354),P(13.754213585),P(13.755975364),P(13.757736693),P(13.759497570),P(13.761257997),P(13.763017974),
	P(13.764777501),P(13.766536578),P(13.768295206),P(13.770053384),P(13.771811114),P(13.773568395),P(13.775325227),P(13.777081612),P(13.778837549),P(13.780593039),P(13.782348081),P(13.784102677),P(13.785856826),P(13.787610528),P(13.789363785),P(13.791116596),
	P(13.792868962),P(13.794620882),P(13.796372357),P(13.798123388),P(13.799873975),P(13.801624117),P(13.803373816),P(13.805123072),P(13.806871884),P(13.808620253),P(13.810368180),P(13.812115664),P(13.813862706),P(13.815609307),P(13.817355466),P(13.819101183),
	P(13.820846460),P(13.822591296),P(13.824335692),P(13.826079647),P(13.827823163),P(13.829566239),P(13.831308876),P(13.833051074),P(13.834792833),P(13.836534154),P(13.838275036),P(13.840015481),P(13.841755488),P(13.843495058),P(13.845234190),P(13.846972886),
	P(13.848711145),P(13.850448968),P(13.852186355),P(13.853923307),P(13.855659822),P(13.857395903),P(13.859131549),P(13.860866760),P(13.862601537),P(13.864335880),P(13.866069789),P(13.867803264),P(13.869536306),P(13.871268915),P(13.873001092),P(13.874732836),
	P(13.876464148),P(13.878195028),P(13.879925476),P(13.881655493),P(13.883385079),P(13.885114233),P(13.886842958),P(13.888571252),P(13.890299116),P(13.892026550),P(13.893753555),P(13.895480131),P(13.897206277),P(13.898931995),P(13.900657285),P(13.902382146),
	P(13.904106580),P(13.905830585),P(13.907554164),P(13.909277315),P(13.911000040),P(13.912722337),P(13.914444209),P(13.916165655),P(13.917886674),P(13.919607269),P(13.921327438),P(13.923047182),P(13.924766501),P(13.926485396),P(13.928203866),P(13.929921913),
	P(13.931639536),P(13.933356735),P(13.935073512),P(13.936789865),P(13.938505796),P(13.940221304),P(13.941936391),P(13.943651055),P(13.945365298),P(13.947079119),P(13.948792520),P(13.950505499),P(13.952218058),P(13.953930197),P(13.955641916),P(13.957353215),
	P(13.959064094),P(13.960774554),P(13.962484595),P(13.964194217),P(13.965903421),P(13.967612206),P(13.969320574),P(13.971028523),P(13.972736056),P(13.974443171),P(13.976149869),P(13.977856150),P(13.979562015),P(13.981267463),P(13.982972496),P(13.984677113),
	P(13.986381314),P(13.988085101),P(13.989788472),P(13.991491429),P(13.993193971),P(13.994896099),P(13.996597813),P(13.998299113),P(14.000000000),P(14.001700474),P(14.003400535),P(14.005100183),P(14.006799418),P(14.008498242),P(14.010196653),P(14.011894653),
	P(14.013592242),P(14.015289419),P(14.016986185),P(14.018682541),P(14.020378486),P(14.022074021),P(14.023769146),P(14.025463861),P(14.027158167),P(14.028852064),P(14.030545551),P(14.032238630),P(14.033931301),P(14.035623563),P(14.037315418),P(14.039006864),
	P(14.040697903),P(14.042388535),P(14.044078760),P(14.045768578),P(14.047457990),P(14.049146995),P(14.050835595),P(14.052523789),P(14.054211577),P(14.055898960),P(14.057585937),P(14.059272510),P(14.060958679),P(14.062644443),P(14.064329803),P(14.066014759),
	P(14.067699312),P(14.069383461),P(14.071067208),P(14.072750551),P(14.074433492),P(14.076116030),P(14.077798166),P(14.079479901),P(14.081161233),P(14.082842165),P(14.084522695),P(14.086202824),P(14.087882552),P(14.089561880),P(14.091240808),P(14.092919336),
	P(14.094597464),P(14.096275193),P(14.097952522),P(14.099629452),P(14.101305984),P(14.102982117),P(14.104657851),P(14.106333188),P(14.108008126),P(14.109682667),P(14.111356811),P(14.113030558),P(14.114703907),P(14.116376860),P(14.118049417),P(14.119721577),
	P(14.121393341),P(14.123064710),P(14.124735683),P(14.126406261),P(14.128076444),P(14.129746232),P(14.131415625),P(14.133084624),P(14.134753229),P(14.136421441),P(14.138089258),P(14.139756682),P(14.141423713),P(14.143090351),P(14.144756597),P(14.146422450),
	P(14.148087910),P(14.149752979),P(14.151417656),P(14.153081941),P(14.154745835),P(14.156409338),P(14.158072450),P(14.159735171),P(14.161397502),P(14.163059443),P(14.164720994),P(14.166382155),P(14.168042927),P(14.169703309),P(14.171363302),P(14.173022907),
	P(14.174682123),P(14.176340951),P(14.177999390),P(14.179657442),P(14.181315106),P(14.182972382),P(14.184629272),P(14.186285774),P(14.187941890),P(14.189597619),P(14.191252961),P(14.192907918),P(14.194562489),P(14.196216674),P(14.197870473),P(14.199523888),
	P(14.201176918),P(14.202829562),P(14.204481823),P(14.206133699),P(14.207785191),P(14.209436299),P(14.211087023),P(14.212737364),P(14.214387322),P(14.216036897),P(14.217686090),P(14.219334899),P(14.220983327),P(14.222631372),P(14.224279036),P(14.225926317),
	P(14.227573218),P(14.229219737),P(14.230865876),P(14.232511633),P(14.234157010),P(14.235802007),P(14.237446624),P(14.239090861),P(14.240734718),P(14.242378196),P(14.244021294),P(14.245664014),P(14.247306355),P(14.248948317),P(14.250589901),P(14.252231106),
	P(14.253871934),P(14.255512385),P(14.257152457),P(14.258792153),P(14.260431471),P(14.262070413),P(14.263708978),P(14.265347167),P(14.266984979),P(14.268622416),P(14.270259477),P(14.271896162),P(14.273532472),P(14.275168407),P(14.276803967),P(14.278439153),
	P(14.280073964),P(14.281708401),P(14.283342463),P(14.284976152),P(14.286609468),P(14.288242410),P(14.289874979),P(14.291507174),P(14.293138998),P(14.294770448),P(14.296401527),P(14.298032233),P(14.299662567),P(14.301292530),P(14.302922121),P(14.304551341),
	P(14.306180190),P(14.307808668),P(14.309436776),P(14.311064513),P(14.312691880),P(14.314318877),P(14.315945504),P(14.317571761),P(14.319197650),P(14.320823169),P(14.322448319),P(14.324073100),P(14.325697513),P(14.327321558),P(14.328945234),P(14.330568543),
	P(14.332191484),P(14.333814058),P(14.335436264),P(14.337058103),P(14.338679575),P(14.340300681),P(14.341921420),P(14.343541793),P(14.345161800),P(14.346781441),P(14.348400717),P(14.350019627),P(14.351638172),P(14.353256352),P(14.354874167),P(14.356491618),
	P(14.358108704),P(14.359725426),P(14.361341784),P(14.362957779),P(14.364573410),P(14.366188677),P(14.367803581),P(14.369418123),P(14.371032301),P(14.372646117),P(14.374259571),P(14.375872663),P(14.377485393),P(14.379097761),P(14.380709767),P(14.382321412),
	P(14.383932696),P(14.385543619),P(14.387154182),P(14.388764384),P(14.390374225),P(14.391983707),P(14.393592829),P(14.395201591),P(14.396809993),P(14.398418036),P(14.400025720),P(14.401633045),P(14.403240012),P(14.404846620),P(14.406452869),P(14.408058761),
	P(14.409664294),P(14.411269470),P(14.412874289),P(14.414478750),P(14.416082854),P(14.417686601),P(14.419289992),P(14.420893025),P(14.422495703),P(14.424098025),P(14.425699990),P(14.427301600),P(14.428902854),P(14.430503753),P(14.432104297),P(14.433704486),
	P(14.435304321),P(14.436903800),P(14.438502926),P(14.440101697),P(14.441700114),P(14.443298178),P(14.444895888),P(14.446493244),P(14.448090248),P(14.449686898),P(14.451283196),P(14.452879141),P(14.454474734),P(14.456069975),P(14.457664863),P(14.459259400),
	P(14.460853585),P(14.462447419),P(14.464040901),P(14.465634033),P(14.467226814),P(14.468819244),P(14.470411323),P(14.472003053),P(14.473594432),P(14.475185461),P(14.476776141),P(14.478366471),P(14.479956452),P(14.481546084),P(14.483135367),P(14.484724301),
	P(14.486312887),P(14.487901124),P(14.489489013),P(14.491076555),P(14.492663748),P(14.494250594),P(14.495837093),P(14.497423244),P(14.499009048),P(14.500594506),P(14.502179617),P(14.503764381),P(14.505348800),P(14.506932872),P(14.508516598),P(14.510099979),
	P(14.511683014),P(14.513265704),P(14.514848048),P(14.516430048),P(14.518011703),P(14.519593014),P(14.521173980),P(14.522754602),P(14.524334880),P(14.525914814),P(14.527494405),P(14.529073652),P(14.530652556),P(14.532231117),P(14.533809335),P(14.535387210),
	P(14.536964743),P(14.538541933),P(14.540118782),P(14.541695288),P(14.543271453),P(14.544847276),P(14.546422758),P(14.547997898),P(14.549572698),P(14.551147156),P(14.552721274),P(14.554295052),P(14.555868489),P(14.557441586),P(14.559014344),P(14.560586761),
	P(14.562158839),P(14.563730578),P(14.565301978),P(14.566873038),P(14.568443760),P(14.570014143),P(14.571584188),P(14.573153894),P(14.574723262),P(14.576292293),P(14.577860985),P(14.579429340),P(14.580997358),P(14.582565039),P(14.584132383),P(14.585699389),
	P(14.587266060),P(14.588832393),P(14.590398391),P(14.591964052),P(14.593529378),P(14.595094367),P(14.596659022),P(14.598223340),P(14.599787324),P(14.601350973),P(14.602914287),P(14.604477266),P(14.606039910),P(14.607602221),P(14.609164197),P(14.610725840),
	P(14.612287148),P(14.613848123),P(14.615408765),P(14.616969073),P(14.618529049),P(14.620088691),P(14.621648001),P(14.623206978),P(14.624765623),P(14.626323936),P(14.627881917),P(14.629439566),P(14.630996883),P(14.632553869),P(14.634110524),P(14.635666847),
	P(14.637222840),P(14.638778502),P(14.640333833),P(14.641888834),P(14.643443505),P(14.644997846),P(14.646551857),P(14.648105538),P(14.649658889),P(14.651211912),P(14.652764605),P(14.654316969),P(14.655869004),P(14.657420711),P(14.658972089),P(14.660523139),
	P(14.662073860),P(14.663624254),P(14.665174320),P(14.666724059),P(14.668273470),P(14.669822553),P(14.671371310),P(14.672919740),P(14.674467842),P(14.676015619),P(14.677563069),P(14.679110193),P(14.680656990),P(14.682203462),P(14.683749608),P(14.685295429),
	P(14.686840924),P(14.688386094),P(14.689930939),P(14.691475459),P(14.693019655),P(14.694563526),P(14.696107072),P(14.697650295),P(14.699193193),P(14.700735768),P(14.702278019),P(14.703819946),P(14.705361550),P(14.706902831),P(14.708443789),P(14.709984424),
	P(14.711524737),P(14.713064727),P(14.714604395),P(14.716143740),P(14.717682764),P(14.719221466),P(14.720759846),P(14.722297904),P(14.723835642),P(14.725373058),P(14.726910154),P(14.728446928),P(14.729983382),P(14.731519515),P(14.733055329),P(14.734590822),
	P(14.736125995),P(14.737660848),P(14.739195381),P(14.740729596),P(14.742263490),P(14.743797066),P(14.745330323),P(14.746863261),P(14.748395880),P(14.749928181),P(14.751460164),P(14.752991828),P(14.754523175),P(14.756054203),P(14.757584914),P(14.759115308),
	P(14.760645384),P(14.762175143),P(14.763704585),P(14.765233711),P(14.766762519),P(14.768291011),P(14.769819187),P(14.771347047),P(14.772874591),P(14.774401818),P(14.775928731),P(14.777455327),P(14.778981608),P(14.780507575),P(14.782033226),P(14.783558562),
	P(14.785083583),P(14.786608290),P(14.788132683),P(14.789656761),P(14.791180526),P(14.792703976),P(14.794227113),P(14.795749936),P(14.797272446),P(14.798794643),P(14.800316526),P(14.801838097),P(14.803359354),P(14.804880299),P(14.806400932),P(14.807921253),
	P(14.809441261),P(14.810960957),P(14.812480342),P(14.813999415),P(14.815518176),P(14.817036627),P(14.818554766),P(14.820072594),P(14.821590111),P(14.823107317),P(14.824624213),P(14.826140799),P(14.827657074),P(14.829173040),P(14.830688695),P(14.832204041),
	P(14.833719077),P(14.835233804),P(14.836748221),P(14.838262330),P(14.839776129),P(14.841289620),P(14.842802802),P(14.844315676),P(14.845828241),P(14.847340498),P(14.848852447),P(14.850364088),P(14.851875422),P(14.853386448),P(14.854897167),P(14.856407578),
	P(14.857917683),P(14.859427480),P(14.860936971),P(14.862446155),P(14.863955033),P(14.865463605),P(14.866971870),P(14.868479830),P(14.869987483),P(14.871494831),P(14.873001874),P(14.874508611),P(14.876015043),P(14.877521170),P(14.879026992),P(14.880532509),
	P(14.882037721),P(14.883542630),P(14.885047234),P(14.886551534),P(14.888055530),P(14.889559222),P(14.891062610),P(14.892565695),P(14.894068477),P(14.895570955),P(14.897073130),P(14.898575003),P(14.900076573),P(14.901577840),P(14.903078805),P(14.904579467),
	P(14.906079827),P(14.907579886),P(14.909079642),P(14.910579097),P(14.912078251),P(14.913577103),P(14.915075653),P(14.916573903),P(14.918071852),P(14.919569500),P(14.921066847),P(14.922563894),P(14.924060641),P(14.925557087),P(14.927053234),P(14.928549080),
	P(14.930044627),P(14.931539875),P(14.933034823),P(14.934529471),P(14.936023821),P(14.937517871),P(14.939011623),P(14.940505076),P(14.941998231),P(14.943491087),P(14.944983645),P(14.946475905),P(14.947967867),P(14.949459532),P(14.950950898),P(14.952441968),
	P(14.953932739),P(14.955423214),P(14.956913392),P(14.958403273),P(14.959892857),P(14.961382144),P(14.962871135),P(14.964359830),P(14.965848229),P(14.967336331),P(14.968824138),P(14.970311649),P(14.971798865),P(14.973285785),P(14.974772410),P(14.976258740),
	P(14.977744774),P(14.979230514),P(14.980715960),P(14.982201111),P(14.983685967),P(14.985170529),P(14.986654797),P(14.988138771),P(14.989622452),P(14.991105838),P(14.992588932),P(14.994071731),P(14.995554238),P(14.997036452),P(14.998518372),P(15.000000000),
	P(15.001481335),P(15.002962378),P(15.004443128),P(15.005923586),P(15.007403752),P(15.008883627),P(15.010363209),P(15.011842500),P(15.013321499),P(15.014800207),P(15.016278624),P(15.017756749),P(15.019234584),P(15.020712128),P(15.022189381),P(15.023666344),
	P(15.025143017),P(15.026619399),P(15.028095492),P(15.029571294),P(15.031046806),P(15.032522029),P(15.033996963),P(15.035471607),P(15.036945962),P(15.038420028),P(15.039893805),P(15.041367293),P(15.042840493),P(15.044313404),P(15.045786026),P(15.047258361),
	P(15.048730407),P(15.050202166),P(15.051673636),P(15.053144820),P(15.054615715),P(15.056086323),P(15.057556644),P(15.059026678),P(15.060496425),P(15.061965885),P(15.063435058),P(15.064903945),P(15.066372546),P(15.067840860),P(15.069308888),P(15.070776630),
	P(15.072244087),P(15.073711257),P(15.075178143),P(15.076644742),P(15.078111057),P(15.079577086),P(15.081042830),P(15.082508290),P(15.083973464),P(15.085438354),P(15.086902960),P(15.088367282),P(15.089831319),P(15.091295072),P(15.092758541),P(15.094221727),
	P(15.095684629),P(15.097147247),P(15.098609582),P(15.100071634),P(15.101533403),P(15.102994889),P(15.104456092),P(15.105917012),P(15.107377650),P(15.108838006),P(15.110298079),P(15.111757870),P(15.113217379),P(15.114676606),P(15.116135552),P(15.117594216),
	P(15.119052599),P(15.120510700),P(15.121968520),P(15.123426059),P(15.124883318),P(15.126340295),P(15.127796992),P(15.129253408),P(15.130709544),P(15.132165400),P(15.133620976),P(15.135076272),P(15.136531288),P(15.137986024),P(15.139440481),P(15.140894658),
	P(15.142348556),P(15.143802175),P(15.145255515),P(15.146708576),P(15.148161359),P(15.149613862),P(15.151066088),P(15.152518035),P(15.153969703),P(15.155421094),P(15.156872207),P(15.158323042),P(15.159773599),P(15.161223879),P(15.162673881),P(15.164123606),
	P(15.165573054),P(15.167022225),P(15.168471119),P(15.169919736),P(15.171368076),P(15.172816141),P(15.174263928),P(15.175711440),P(15.177158676),P(15.178605635),P(15.180052319),P(15.181498727),P(15.182944859),P(15.184390716),P(15.185836298),P(15.187281605),
	P(15.188726636),P(15.190171393),P(15.191615875),P(15.193060082),P(15.194504015),P(15.195947673),P(15.197391057),P(15.198834167),P(15.200277003),P(15.201719565),P(15.203161854),P(15.204603869),P(15.206045610),P(15.207487078),P(15.208928273),P(15.210369194),
	P(15.211809843),P(15.213250219),P(15.214690322),P(15.216130153),P(15.217569711),P(15.219008997),P(15.220448011),P(15.221886752),P(15.223325222),P(15.224763420),P(15.226201346),P(15.227639001),P(15.229076384),P(15.230513496),P(15.231950337),P(15.233386907),
	P(15.234823206),P(15.236259234),P(15.237694992),P(15.239130479),P(15.240565696),P(15.242000642),P(15.243435318),P(15.244869725),P(15.246303861),P(15.247737728),P(15.249171325),P(15.250604652),P(15.252037710),P(15.253470499),P(15.254903019),P(15.256335270),
	P(15.257767252),P(15.259198965),P(15.260630409),P(15.262061586),P(15.263492493),P(15.264923133),P(15.266353504),P(15.267783607),P(15.269213443),P(15.270643011),P(15.272072311),P(15.273501344),P(15.274930109),P(15.276358607),P(15.277786838),P(15.279214802),
	P(15.280642499),P(15.282069930),P(15.283497093),P(15.284923991),P(15.286350622),P(15.287776986),P(15.289203085),P(15.290628918),P(15.292054484),P(15.293479785),P(15.294904821),P(15.296329591),P(15.297754095),P(15.299178335),P(15.300602309),P(15.302026018),
	P(15.303449462),P(15.304872642),P(15.306295557),P(15.307718207),P(15.309140593),P(15.310562715),P(15.311984572),P(15.313406166),P(15.314827496),P(15.316248562),P(15.317669364),P(15.319089903),P(15.320510178),P(15.321930190),P(15.323349939),P(15.324769425),
	P(15.326188648),P(15.327607608),P(15.329026306),P(15.330444740),P(15.331862913),P(15.333280823),P(15.334698471),P(15.336115857),P(15.337532981),P(15.338949843),P(15.340366444),P(15.341782783),P(15.343198860),P(15.344614676),P(15.346030231),P(15.347445525),
	P(15.348860558),P(15.350275330),P(15.351689841),P(15.353104091),P(15.354518081),P(15.355931811),P(15.357345280),P(15.358758490),P(15.360171439),P(15.361584128),P(15.362996558),P(15.364408728),P(15.365820638),P(15.367232289),P(15.368643681),P(15.370054813),
	P(15.371465687),P(15.372876301),P(15.374286657),P(15.375696754),P(15.377106592),P(15.378516172),P(15.379925494),P(15.381334557),P(15.382743362),P(15.384151909),P(15.385560198),P(15.386968230),P(15.388376004),P(15.389783520),P(15.391190779),P(15.392597781),
	P(15.394004525),P(15.395411013),P(15.396817243),P(15.398223217),P(15.399628934),P(15.401034394),P(15.402439598),P(15.403844545),P(15.405249237),P(15.406653672),P(15.408057851),P(15.409461774),P(15.410865442),P(15.412268854),P(15.413672010),P(15.415074911),
	P(15.416477556),P(15.417879947),P(15.419282082),P(15.420683962),P(15.422085588),P(15.423486959),P(15.424888075),P(15.426288937),P(15.427689544),P(15.429089897),P(15.430489996),P(15.431889841),P(15.433289432),P(15.434688769),P(15.436087852),P(15.437486682),
	P(15.438885259),P(15.440283582),P(15.441681652),P(15.443079468),P(15.444477032),P(15.445874343),P(15.447271401),P(15.448668207),P(15.450064760),P(15.451461060),P(15.452857108),P(15.454252904),P(15.455648448),P(15.457043740),P(15.458438780),P(15.459833568),
	P(15.461228105),P(15.462622390),P(15.464016424),P(15.465410206),P(15.466803738),P(15.468197018),P(15.469590047),P(15.470982826),P(15.472375353),P(15.473767630),P(15.475159657),P(15.476551433),P(15.477942959),P(15.479334235),P(15.480725261),P(15.482116037),
	P(15.483506563),P(15.484896839),P(15.486286865),P(15.487676643),P(15.489066170),P(15.490455449),P(15.491844478),P(15.493233259),P(15.494621790),P(15.496010073),P(15.497398106),P(15.498785892),P(15.500173429),P(15.501560717),P(15.502947757),P(15.504334549),
	P(15.505721093),P(15.507107389),P(15.508493437),P(15.509879238),P(15.511264791),P(15.512650096),P(15.514035154),P(15.515419965),P(15.516804529),P(15.518188845),P(15.519572915),P(15.520956738),P(15.522340314),P(15.523723643),P(15.525106726),P(15.526489563),
	P(15.527872153),P(15.529254497),P(15.530636596),P(15.532018448),P(15.533400054),P(15.534781415),P(15.536162530),P(15.537543399),P(15.538924023),P(15.540304402),P(15.541684536),P(15.543064424),P(15.544444068),P(15.545823467),P(15.547202621),P(15.548581530),
	P(15.549960195),P(15.551338615),P(15.552716791),P(15.554094723),P(15.555472411),P(15.556849855),P(15.558227054),P(15.559604011),P(15.560980723),P(15.562357192),P(15.563733417),P(15.565109399),P(15.566485138),P(15.567860634),P(15.569235887),P(15.570610896),
	P(15.571985663),P(15.573360188),P(15.574734469),P(15.576108509),P(15.577482306),P(15.578855860),P(15.580229173),P(15.581602243),P(15.582975071),P(15.584347658),P(15.585720003),P(15.587092106),P(15.588463967),P(15.589835588),P(15.591206967),P(15.592578104),
	P(15.593949001),P(15.595319657),P(15.596690071),P(15.598060245),P(15.599430179),P(15.600799871),P(15.602169324),P(15.603538535),P(15.604907507),P(15.606276239),P(15.607644730),P(15.609012981),P(15.610380993),P(15.611748765),P(15.613116297),P(15.614483590),
	P(15.615850644),P(15.617217458),P(15.618584032),P(15.619950368),P(15.621316465),P(15.622682323),P(15.624047942),P(15.625413322),P(15.626778464),P(15.628143368),P(15.629508033),P(15.630872459),P(15.632236648),P(15.633600598),P(15.634964311),P(15.636327786),
	P(15.637691023),P(15.639054022),P(15.640416784),P(15.641779308),P(15.643141595),P(15.644503645),P(15.645865457),P(15.647227033),P(15.648588372),P(15.649949474),P(15.651310339),P(15.652670967),P(15.654031359),P(15.655391515),P(15.656751434),P(15.658111118),
	P(15.659470565),P(15.660829776),P(15.662188751),P(15.663547490),P(15.664905994),P(15.666264262),P(15.667622295),P(15.668980092),P(15.670337654),P(15.671694981),P(15.673052072),P(15.674408929),P(15.675765551),P(15.677121938),P(15.678478091),P(15.679834008),
	P(15.681189692),P(15.682545141),P(15.683900356),P(15.685255336),P(15.686610083),P(15.687964595),P(15.689318874),P(15.690672919),P(15.692026730),P(15.693380308),P(15.694733652),P(15.696086763),P(15.697439641),P(15.698792285),P(15.700144697),P(15.701496875),
	P(15.702848821),P(15.704200534),P(15.705552014),P(15.706903262),P(15.708254277),P(15.709605060),P(15.710955611),P(15.712305929),P(15.713656016),P(15.715005870),P(15.716355493),P(15.717704884),P(15.719054043),P(15.720402971),P(15.721751667),P(15.723100132),
	P(15.724448365),P(15.725796368),P(15.727144139),P(15.728491679),P(15.729838989),P(15.731186068),P(15.732532916),P(15.733879534),P(15.735225921),P(15.736572077),P(15.737918004),P(15.739263700),P(15.740609166),P(15.741954403),P(15.743299409),P(15.744644186),
	P(15.745988732),P(15.747333050),P(15.748677138),P(15.750020996),P(15.751364625),P(15.752708025),P(15.754051196),P(15.755394138),P(15.756736851),P(15.758079335),P(15.759421591),P(15.760763617),P(15.762105416),P(15.763446986),P(15.764788327),P(15.766129441),
	P(15.767470326),P(15.768810984),P(15.770151413),P(15.771491614),P(15.772831588),P(15.774171334),P(15.775510853),P(15.776850144),P(15.778189208),P(15.779528045),P(15.780866654),P(15.782205036),P(15.783543192),P(15.784881120),P(15.786218822),P(15.787556297),
	P(15.788893546),P(15.790230568),P(15.791567364),P(15.792903933),P(15.794240276),P(15.795576393),P(15.796912285),P(15.798247950),P(15.799583389),P(15.800918603),P(15.802253591),P(15.803588353),P(15.804922890),P(15.806257202),P(15.807591289),P(15.808925150),
	P(15.810258787),P(15.811592198),P(15.812925384),P(15.814258346),P(15.815591083),P(15.816923596),P(15.818255884),P(15.819587948),P(15.820919787),P(15.822251402),P(15.823582793),P(15.824913960),P(15.826244903),P(15.827575623),P(15.828906118),P(15.830236390),
	P(15.831566439),P(15.832896264),P(15.834225865),P(15.835555244),P(15.836884399),P(15.838213331),P(15.839542040),P(15.840870527),P(15.842198790),P(15.843526831),P(15.844854649),P(15.846182245),P(15.847509618),P(15.848836769),P(15.850163698),P(15.851490404),
	P(15.852816889),P(15.854143152),P(15.855469192),P(15.856795011),P(15.858120609),P(15.859445984),P(15.860771139),P(15.862096071),P(15.863420783),P(15.864745273),P(15.866069543),P(15.867393591),P(15.868717418),P(15.870041025),P(15.871364410),P(15.872687575),
	P(15.874010520),P(15.875333244),P(15.876655747),P(15.877978031),P(15.879300094),P(15.880621937),P(15.881943560),P(15.883264963),P(15.884586146),P(15.885907110),P(15.887227853),P(15.888548378),P(15.889868683),P(15.891188768),P(15.892508634),P(15.893828281),
	P(15.895147709),P(15.896466918),P(15.897785908),P(15.899104679),P(15.900423231),P(15.901741565),P(15.903059680),P(15.904377577),P(15.905695255),P(15.907012716),P(15.908329957),P(15.909646981),P(15.910963787),P(15.912280375),P(15.913596745),P(15.914912897),
	P(15.916228832),P(15.917544549),P(15.918860048),P(15.920175330),P(15.921490395),P(15.922805243),P(15.924119873),P(15.925434287),P(15.926748484),P(15.928062463),P(15.929376226),P(15.930689773),P(15.932003102),P(15.933316216),P(15.934629113),P(15.935941793),
	P(15.937254257),P(15.938566506),P(15.939878538),P(15.941190354),P(15.942501954),P(15.943813339),P(15.945124508),P(15.946435461),P(15.947746199),P(15.949056721),P(15.950367028),P(15.951677120),P(15.952986996),P(15.954296658),P(15.955606104),P(15.956915336),
	P(15.958224353),P(15.959533155),P(15.960841743),P(15.962150116),P(15.963458274),P(15.964766218),P(15.966073948),P(15.967381464),P(15.968688765),P(15.969995853),P(15.971302727),P(15.972609386),P(15.973915832),P(15.975222065),P(15.976528084),P(15.977833889),
	P(15.979139481),P(15.980444860),P(15.981750025),P(15.983054977),P(15.984359716),P(15.985664243),P(15.986968556),P(15.988272656),P(15.989576544),P(15.990880220),P(15.992183682),P(15.993486932),P(15.994789970),P(15.996092796),P(15.997395409),P(15.998697811),
	P(16.000000000),P(16.001301977),P(16.002603743),P(16.003905297),P(16.005206639),P(16.006507769),P(16.007808688),P(16.009109396),P(16.010409892),P(16.011710177),P(16.013010251),P(16.014310114),P(16.015609766),P(16.016909207),P(16.018208437),P(16.019507457),
	P(16.020806265),P(16.022104864),P(16.023403251),P(16.024701429),P(16.025999396),P(16.027297153),P(16.028594699),P(16.029892036),P(16.031189163),P(16.032486080),P(16.033782787),P(16.035079284),P(16.036375572),P(16.037671650),P(16.038967519),P(16.040263178),
	P(16.041558628),P(16.042853869),P(16.044148901),P(16.045443724),P(16.046738338),P(16.048032743),P(16.049326939),P(16.050620926),P(16.051914705),P(16.053208275),P(16.054501637),P(16.055794791),P(16.057087736),P(16.058380473),P(16.059673002),P(16.060965323),
	P(16.062257437),P(16.063549342),P(16.064841039),P(16.066132529),P(16.067423811),P(16.068714886),P(16.070005753),P(16.071296413),P(16.072586865),P(16.073877111),P(16.075167149),P(16.076456980),P(16.077746605),P(16.079036022),P(16.080325233),P(16.081614237),
	P(16.082903034),P(16.084191625),P(16.085480010),P(16.086768188),P(16.088056160),P(16.089343925),P(16.090631485),P(16.091918838),P(16.093205986),P(16.094492928),P(16.095779664),P(16.097066194),P(16.098352518),P(16.099638638),P(16.100924551),P(16.102210259),
	P(16.103495762),P(16.104781060),P(16.106066153),P(16.107351040),P(16.108635723),P(16.109920201),P(16.111204474),P(16.112488542),P(16.113772406),P(16.115056065),P(16.116339519),P(16.117622770),P(16.118905816),P(16.120188657),P(16.121471295),P(16.122753728),
	P(16.124035958),P(16.125317983),P(16.126599805),P(16.127881423),P(16.129162838),P(16.130444048),P(16.131725056),P(16.133005860),P(16.134286460),P(16.135566858),P(16.136847052),P(16.138127043),P(16.139406831),P(16.140686416),P(16.141965798),P(16.143244978),
	P(16.144523954),P(16.145802729),P(16.147081300),P(16.148359669),P(16.149637836),P(16.150915801),P(16.152193563),P(16.153471123),P(16.154748481),P(16.156025638),P(16.157302592),P(16.158579344),P(16.159855895),P(16.161132244),P(16.162408392),P(16.163684338),
	P(16.164960082),P(16.166235626),P(16.167510968),P(16.168786109),P(16.170061048),P(16.171335787),P(16.172610325),P(16.173884662),P(16.175158798),P(16.176432734),P(16.177706469),P(16.178980003),P(16.180253337),P(16.181526470),P(16.182799403),P(16.184072136),
	P(16.185344669),P(16.186617002),P(16.187889135),P(16.189161067),P(16.190432800),P(16.191704334),P(16.192975667),P(16.194246801),P(16.195517736),P(16.196788471),P(16.198059006),P(16.199329343),P(16.200599480),P(16.201869418),P(16.203139157),P(16.204408697),
	P(16.205678038),P(16.206947180),P(16.208216124),P(16.209484869),P(16.210753415),P(16.212021763),P(16.213289912),P(16.214557863),P(16.215825616),P(16.217093171),P(16.218360527),P(16.219627686),P(16.220894646),P(16.222161409),P(16.223427973),P(16.224694340),
	P(16.225960510),P(16.227226482),P(16.228492256),P(16.229757833),P(16.231023212),P(16.232288395),P(16.233553380),P(16.234818168),P(16.236082759),P(16.237347153),P(16.238611350),P(16.239875350),P(16.241139153),P(16.242402760),P(16.243666171),P(16.244929384),
	P(16.246192402),P(16.247455223),P(16.248717848),P(16.249980276),P(16.251242509),P(16.252504545),P(16.253766385),P(16.255028030),P(16.256289479),P(16.257550732),P(16.258811789),P(16.260072651),P(16.261333317),P(16.262593788),P(16.263854063),P(16.265114143),
	P(16.266374028),P(16.267633718),P(16.268893212),P(16.270152512),P(16.271411617),P(16.272670527),P(16.273929242),P(16.275187763),P(16.276446089),P(16.277704220),P(16.278962157),P(16.280219900),P(16.281477448),P(16.282734802),P(16.283991962),P(16.285248928),
	P(16.286505700),P(16.287762277),P(16.289018661),P(16.290274852),P(16.291530848),P(16.292786651),P(16.294042260),P(16.295297676),P(16.296552899),P(16.297807928),P(16.299062764),P(16.300317406),P(16.301571856),P(16.302826112),P(16.304080176),P(16.305334047),
	P(16.306587724),P(16.307841210),P(16.309094502),P(16.310347602),P(16.311600509),P(16.312853224),P(16.314105747),P(16.315358077),P(16.316610215),P(16.317862161),P(16.319113914),P(16.320365476),P(16.321616846),P(16.322868024),P(16.324119010),P(16.325369805),
	P(16.326620408),P(16.327870819),P(16.329121039),P(16.330371067),P(16.331620904),P(16.332870550),P(16.334120005),P(16.335369268),P(16.336618341),P(16.337867222),P(16.339115913),P(16.340364412),P(16.341612721),P(16.342860840),P(16.344108767),P(16.345356504),
	P(16.346604051),P(16.347851407),P(16.349098573),P(16.350345549),P(16.351592335),P(16.352838930),P(16.354085335),P(16.355331551),P(16.356577577),P(16.357823412),P(16.359069058),P(16.360314515),P(16.361559781),P(16.362804859),P(16.364049746),P(16.365294445),
	P(16.366538954),P(16.367783274),P(16.369027404),P(16.370271346),P(16.371515099),P(16.372758662),P(16.374002037),P(16.375245223),P(16.376488220),P(16.377731029),P(16.378973649),P(16.380216080),P(16.381458323),P(16.382700378),P(16.383942244),P(16.385183922),
	P(16.386425412),P(16.387666714),P(16.388907828),P(16.390148754),P(16.391389492),P(16.392630042),P(16.393870404),P(16.395110579),P(16.396350566),P(16.397590366),P(16.398829978),P(16.400069403),P(16.401308640),P(16.402547691),P(16.403786554),P(16.405025230),
	P(16.406263719),P(16.407502021),P(16.408740136),P(16.409978064),P(16.411215806),P(16.412453361),P(16.413690729),P(16.414927911),P(16.416164906),P(16.417401715),P(16.418638338),P(16.419874774),P(16.421111024),P(16.422347088),P(16.423582966),P(16.424818659),
	P(16.426054165),P(16.427289485),P(16.428524620),P(16.429759568),P(16.430994332),P(16.432228909),P(16.433463302),P(16.434697508),P(16.435931530),P(16.437165366),P(16.438399017),P(16.439632483),P(16.440865763),P(16.442098859),P(16.443331770),P(16.444564496),
	P(16.445797037),P(16.447029394),P(16.448261566),P(16.449493553),P(16.450725355),P(16.451956974),P(16.453188408),P(16.454419657),P(16.455650723),P(16.456881604),P(16.458112301),P(16.459342814),P(16.460573143),P(16.461803288),P(16.463033250),P(16.464263027),
	P(16.465492621),P(16.466722032),P(16.467951259),P(16.469180302),P(16.470409162),P(16.471637838),P(16.472866332),P(16.474094642),P(16.475322769),P(16.476550712),P(16.477778473),P(16.479006051),P(16.480233446),P(16.481460659),P(16.482687688),P(16.483914535),
	P(16.485141199),P(16.486367681),P(16.487593980),P(16.488820097),P(16.490046032),P(16.491271784),P(16.492497354),P(16.493722742),P(16.494947948),P(16.496172972),P(16.497397814),P(16.498622475),P(16.499846953),P(16.501071250),P(16.502295365),P(16.503519298),
	P(16.504743050),P(16.505966621),P(16.507190010),P(16.508413218),P(16.509636244),P(16.510859090),P(16.512081754),P(16.513304238),P(16.514526540),P(16.515748661),P(16.516970602),P(16.518192362),P(16.519413941),P(16.520635339),P(16.521856557),P(16.523077594),
	P(16.524298451),P(16.525519128),P(16.526739624),P(16.527959940),P(16.529180076),P(16.530400032),P(16.531619807),P(16.532839403),P(16.534058819),P(16.535278055),P(16.536497111),P(16.537715988),P(16.538934684),P(16.540153202),P(16.541371539),P(16.542589698),
	P(16.543807677),P(16.545025476),P(16.546243097),P(16.547460538),P(16.548677800),P(16.549894883),P(16.551111787),P(16.552328512),P(16.553545058),P(16.554761426),P(16.555977615),P(16.557193625),P(16.558409456),P(16.559625109),P(16.560840584),P(16.562055880),
	P(16.563270998),P(16.564485937),P(16.565700699),P(16.566915282),P(16.568129687),P(16.569343914),P(16.570557963),P(16.571771835),P(16.572985528),P(16.574199044),P(16.575412382),P(16.576625543),P(16.577838526),P(16.579051331),P(16.580263959),P(16.581476410),
	P(16.582688684),P(16.583900780),P(16.585112699),P(16.586324441),P(16.587536006),P(16.588747394),P(16.589958605),P(16.591169639),P(16.592380497),P(16.593591178),P(16.594801682),P(16.596012010),P(16.597222161),P(16.598432135),P(16.599641934),P(16.600851555),
	P(16.602061001),P(16.603270271),P(16.604479364),P(16.605688281),P(16.606897023),P(16.608105588),P(16.609313978),P(16.610522191),P(16.611730229),P(16.612938092),P(16.614145778),P(16.615353289),P(16.616560625),P(16.617767785),P(16.618974770),P(16.620181580),
	P(16.621388214),P(16.622594673),P(16.623800957),P(16.625007067),P(16.626213001),P(16.627418760),P(16.628624344),P(16.629829754),P(16.631034988),P(16.632240049),P(16.633444934),P(16.634649645),P(16.635854182),P(16.637058544),P(16.638262732),P(16.639466745),
	P(16.640670584),P(16.641874250),P(16.643077741),P(16.644281058),P(16.645484201),P(16.646687170),P(16.647889965),P(16.649092587),P(16.650295035),P(16.651497309),P(16.652699409),P(16.653901336),P(16.655103090),P(16.656304670),P(16.657506077),P(16.658707311),
	P(16.659908371),P(16.661109258),P(16.662309972),P(16.663510513),P(16.664710882),P(16.665911077),P(16.667111099),P(16.668310949),P(16.669510626),P(16.670710130),P(16.671909462),P(16.673108621),P(16.674307608),P(16.675506422),P(16.676705064),P(16.677903533),
	P(16.679101831),P(16.680299956),P(16.681497909),P(16.682695690),P(16.683893300),P(16.685090737),P(16.686288002),P(16.687485096),P(16.688682018),P(16.689878768),P(16.691075347),P(16.692271754),P(16.693467989),P(16.694664054),P(16.695859946),P(16.697055668),
	P(16.698251218),P(16.699446597),P(16.700641805),P(16.701836842),P(16.703031708),P(16.704226403),P(16.705420928),P(16.706615281),P(16.707809464),P(16.709003476),P(16.710197317),P(16.711390988),P(16.712584488),P(16.713777818),P(16.714970977),P(16.716163967),
	P(16.717356786),P(16.718549434),P(16.719741913),P(16.720934221),P(16.722126360),P(16.723318328),P(16.724510127),P(16.725701756),P(16.726893215),P(16.728084504),P(16.729275624),P(16.730466574),P(16.731657354),P(16.732847965),P(16.734038407),P(16.735228679),
	P(16.736418782),P(16.737608716),P(16.738798481),P(16.739988076),P(16.741177503),P(16.742366760),P(16.743555849),P(16.744744769),P(16.745933519),P(16.747122102),P(16.748310515),P(16.749498760),P(16.750686836),P(16.751874744),P(16.753062483),P(16.754250054),
	P(16.755437456),P(16.756624691),P(16.757811757),P(16.758998655),P(16.760185385),P(16.761371946),P(16.762558340),P(16.763744566),P(16.764930624),P(16.766116514),P(16.767302237),P(16.768487792),P(16.769673179),P(16.770858399),P(16.772043451),P(16.773228336),
	P(16.774413053),P(16.775597603),P(16.776781986),P(16.777966201),P(16.779150250),P(16.780334131),P(16.781517846),P(16.782701393),P(16.783884773),P(16.785067987),P(16.786251034),P(16.787433914),P(16.788616627),P(16.789799174),P(16.790981554),P(16.792163768),
	P(16.793345815),P(16.794527696),P(16.795709411),P(16.796890959),P(16.798072341),P(16.799253557),P(16.800434607),P(16.801615491),P(16.802796209),P(16.803976761),P(16.805157147),P(16.806337367),P(16.807517422),P(16.808697311),P(16.809877034),P(16.811056592),
	P(16.812235984),P(16.813415211),P(16.814594272),P(16.815773168),P(16.816951899),P(16.818130464),P(16.819308865),P(16.820487100),P(16.821665170),P(16.822843076),P(16.824020816),P(16.825198392),P(16.826375802),P(16.827553048),P(16.828730129),P(16.829907046),
	P(16.831083798),P(16.832260385),P(16.833436808),P(16.834613067),P(16.835789161),P(16.836965091),P(16.838140857),P(16.839316458),P(16.840491896),P(16.841667169),P(16.842842279),P(16.844017224),P(16.845192006),P(16.846366623),P(16.847541077),P(16.848715367),
	P(16.849889494),P(16.851063457),P(16.852237256),P(16.853410892),P(16.854584364),P(16.855757673),P(16.856930819),P(16.858103802),P(16.859276621),P(16.860449277),P(16.861621770),P(16.862794100),P(16.863966267),P(16.865138271),P(16.866310112),P(16.867481790),
	P(16.868653306),P(16.869824659),P(16.870995849),P(16.872166877),P(16.873337742),P(16.874508445),P(16.875678985),P(16.876849363),P(16.878019579),P(16.879189632),P(16.880359523),P(16.881529252),P(16.882698819),P(16.883868224),P(16.885037467),P(16.886206548),
	P(16.887375467),P(16.888544225),P(16.889712820),P(16.890881254),P(16.892049526),P(16.893217637),P(16.894385586),P(16.895553374),P(16.896721001),P(16.897888466),P(16.899055769),P(16.900222912),P(16.901389893),P(16.902556713),P(16.903723372),P(16.904889870),
	P(16.906056207),P(16.907222384),P(16.908388399),P(16.909554254),P(16.910719947),P(16.911885480),P(16.913050853),P(16.914216065),P(16.915381116),P(16.916546007),P(16.917710738),P(16.918875308),P(16.920039718),P(16.921203967),P(16.922368057),P(16.923531986),
	P(16.924695755),P(16.925859364),P(16.927022814),P(16.928186103),P(16.929349232),P(16.930512202),P(16.931675012),P(16.932837662),P(16.934000153),P(16.935162484),P(16.936324655),P(16.937486667),P(16.938648520),P(16.939810213),P(16.940971747),P(16.942133122),
	P(16.943294337),P(16.944455393),P(16.945616291),P(16.946777029),P(16.947937608),P(16.949098028),P(16.950258289),P(16.951418392),P(16.952578336),P(16.953738121),P(16.954897747),P(16.956057215),P(16.957216524),P(16.958375675),P(16.959534667),P(16.960693501),
	P(16.961852177),P(16.963010694),P(16.964169053),P(16.965327254),P(16.966485297),P(16.967643182),P(16.968800909),P(16.969958477),P(16.971115888),P(16.972273141),P(16.973430237),P(16.974587174),P(16.975743954),P(16.976900576),P(16.978057041),P(16.979213348),
	P(16.980369498),P(16.981525490),P(16.982681325),P(16.983837002),P(16.984992522),P(16.986147885),P(16.987303091),P(16.988458140),P(16.989613032),P(16.990767767),P(16.991922345),P(16.993076766),P(16.994231030),P(16.995385137),P(16.996539088),P(16.997692882),
	P(16.998846519),P(17.000000000),P(17.001153324),P(17.002306492),P(17.003459504),P(17.004612359),P(17.005765057),P(17.006917600),P(17.008069986),P(17.009222216),P(17.010374291),P(17.011526209),P(17.012677971),P(17.013829577),P(17.014981027),P(17.016132322),
	P(17.017283460),P(17.018434443),P(17.019585271),P(17.020735942),P(17.021886459),P(17.023036819),P(17.024187024),P(17.025337074),P(17.026486969),P(17.027636708),P(17.028786292),P(17.029935720),P(17.031084994),P(17.032234113),P(17.033383076),P(17.034531884),
	P(17.035680538),P(17.036829037),P(17.037977380),P(17.039125570),P(17.040273604),P(17.041421484),P(17.042569209),P(17.043716779),P(17.044864195),P(17.046011457),P(17.047158564),P(17.048305516),P(17.049452315),P(17.050598959),P(17.051745449),P(17.052891785),
	P(17.054037967),P(17.055183994),P(17.056329868),P(17.057475588),P(17.058621154),P(17.059766566),P(17.060911824),P(17.062056928),P(17.063201879),P(17.064346676),P(17.065491320),P(17.066635810),P(17.067780147),P(17.068924330),P(17.070068359),P(17.071212236),
	P(17.072355959),P(17.073499529),P(17.074642946),P(17.075786210),P(17.076929320),P(17.078072278),P(17.079215082),P(17.080357734),P(17.081500233),P(17.082642579),P(17.083784772),P(17.084926813),P(17.086068701),P(17.087210436),P(17.088352019),P(17.089493449),
	P(17.090634727),P(17.091775852),P(17.092916825),P(17.094057646),P(17.095198314),P(17.096338831),P(17.097479195),P(17.098619407),P(17.099759467),P(17.100899375),P(17.102039131),P(17.103178735),P(17.104318187),P(17.105457488),P(17.106596636),P(17.107735633),
	P(17.108874479),P(17.110013173),P(17.111151715),P(17.112290106),P(17.113428345),P(17.114566433),P(17.115704370),P(17.116842155),P(17.117979789),P(17.119117272),P(17.120254604),P(17.121391784),P(17.122528814),P(17.123665692),P(17.124802420),P(17.125938997),
	P(17.127075423),P(17.128211698),P(17.129347822),P(17.130483796),P(17.131619619),P(17.132755292),P(17.133890814),P(17.135026185),P(17.136161406),P(17.137296477),P(17.138431397),P(17.139566167),P(17.140700787),P(17.141835257),P(17.142969576),P(17.144103745),
	P(17.145237765),P(17.146371634),P(17.147505353),P(17.148638923),P(17.149772342),P(17.150905612),P(17.152038732),P(17.153171703),P(17.154304523),P(17.155437195),P(17.156569716),P(17.157702088),P(17.158834311),P(17.159966384),P(17.161098308),P(17.162230083),
	P(17.163361708),P(17.164493184),P(17.165624511),P(17.166755689),P(17.167886718),P(17.169017598),P(17.170148329),P(17.171278911),P(17.172409344),P(17.173539628),P(17.174669764),P(17.175799750),P(17.176929589),P(17.178059278),P(17.179188819),P(17.180318212),
	P(17.181447456),P(17.182576551),P(17.183705498),P(17.184834297),P(17.185962948),P(17.187091450),P(17.188219805),P(17.189348011),P(17.190476069),P(17.191603979),P(17.192731741),P(17.193859355),P(17.194986821),P(17.196114139),P(17.197241310),P(17.198368333),
	P(17.199495208),P(17.200621935),P(17.201748515),P(17.202874948),P(17.204001232),P(17.205127370),P(17.206253360),P(17.207379203),P(17.208504898),P(17.209630446),P(17.210755847),P(17.211881101),P(17.213006207),P(17.214131167),P(17.215255979),P(17.216380645),
	P(17.217505164),P(17.218629535),P(17.219753760),P(17.220877839),P(17.222001770),P(17.223125555),P(17.224249193),P(17.225372685),P(17.226496030),P(17.227619228),P(17.228742280),P(17.229865186),P(17.230987945),P(17.232110558),P(17.233233025),P(17.234355346),
	P(17.235477520),P(17.236599549),P(17.237721431),P(17.238843167),P(17.239964758),P(17.241086202),P(17.242207500),P(17.243328653),P(17.244449660),P(17.245570521),P(17.246691237),P(17.247811807),P(17.248932231),P(17.250052510),P(17.251172643),P(17.252292631),
	P(17.253412473),P(17.254532170),P(17.255651722),P(17.256771129),P(17.257890390),P(17.259009506),P(17.260128477),P(17.261247303),P(17.262365984),P(17.263484520),P(17.264602911),P(17.265721158),P(17.266839259),P(17.267957216),P(17.269075027),P(17.270192694),
	P(17.271310217),P(17.272427595),P(17.273544828),P(17.274661917),P(17.275778861),P(17.276895661),P(17.278012317),P(17.279128828),P(17.280245195),P(17.281361418),P(17.282477497),P(17.283593431),P(17.284709222),P(17.285824868),P(17.286940371),P(17.288055729),
	P(17.289170943),P(17.290286014),P(17.291400941),P(17.292515724),P(17.293630364),P(17.294744859),P(17.295859211),P(17.296973420),P(17.298087485),P(17.299201407),P(17.300315185),P(17.301428819),P(17.302542311),P(17.303655659),P(17.304768864),P(17.305881925),
	P(17.306994844),P(17.308107619),P(17.309220251),P(17.310332741),P(17.311445087),P(17.312557290),P(17.313669351),P(17.314781268),P(17.315893043),P(17.317004675),P(17.318116165),P(17.319227511),P(17.320338715),P(17.321449777),P(17.322560696),P(17.323671473),
	P(17.324782107),P(17.325892599),P(17.327002948),P(17.328113155),P(17.329223220),P(17.330333143),P(17.331442923),P(17.332552562),P(17.333662058),P(17.334771413),P(17.335880625),P(17.336989695),P(17.338098624),P(17.339207411),P(17.340316056),P(17.341424559),
	P(17.342532921),P(17.343641140),P(17.344749219),P(17.345857155),P(17.346964951),P(17.348072604),P(17.349180117),P(17.350287488),P(17.351394717),P(17.352501805),P(17.353608753),P(17.354715558),P(17.355822223),P(17.356928747),P(17.358035129),P(17.359141371),
	P(17.360247471),P(17.361353431),P(17.362459249),P(17.363564927),P(17.364670464),P(17.365775861),P(17.366881116),P(17.367986231),P(17.369091205),P(17.370196039),P(17.371300732),P(17.372405285),P(17.373509697),P(17.374613969),P(17.375718101),P(17.376822092),
	P(17.377925943),P(17.379029654),P(17.380133224),P(17.381236655),P(17.382339945),P(17.383443096),P(17.384546106),P(17.385648976),P(17.386751707),P(17.387854298),P(17.388956748),P(17.390059059),P(17.391161231),P(17.392263262),P(17.393365154),P(17.394466907),
	P(17.395568520),P(17.396669993),P(17.397771327),P(17.398872521),P(17.399973576),P(17.401074492),P(17.402175269),P(17.403275906),P(17.404376404),P(17.405476763),P(17.406576983),P(17.407677063),P(17.408777005),P(17.409876808),P(17.410976471),P(17.412075996),
	P(17.413175382),P(17.414274630),P(17.415373738),P(17.416472708),P(17.417571539),P(17.418670231),P(17.419768785),P(17.420867201),P(17.421965477),P(17.423063616),P(17.424161616),P(17.425259477),P(17.426357201),P(17.427454786),P(17.428552232),P(17.429649541),
	P(17.430746712),P(17.431843744),P(17.432940638),P(17.434037394),P(17.435134013),P(17.436230493),P(17.437326835),P(17.438423040),P(17.439519107),P(17.440615036),P(17.441710827),P(17.442806481),P(17.443901997),P(17.444997376),P(17.446092616),P(17.447187720),
	P(17.448282686),P(17.449377514),P(17.450472206),P(17.451566759),P(17.452661176),P(17.453755455),P(17.454849597),P(17.455943602),P(17.457037470),P(17.458131201),P(17.459224795),P(17.460318252),P(17.461411572),P(17.462504755),P(17.463597801),P(17.464690710),
	P(17.465783483),P(17.466876118),P(17.467968618),P(17.469060980),P(17.470153206),P(17.471245295),P(17.472337248),P(17.473429064),P(17.474520744),P(17.475612288),P(17.476703695),P(17.477794966),P(17.478886101),P(17.479977099),P(17.481067961),P(17.482158688),
	P(17.483249278),P(17.484339732),P(17.485430050),P(17.486520232),P(17.487610278),P(17.488700188),P(17.489789963),P(17.490879601),P(17.491969104),P(17.493058471),P(17.494147703),P(17.495236799),P(17.496325759),P(17.497414584),P(17.498503273),P(17.499591827),
	P(17.500680246),P(17.501768529),P(17.502856677),P(17.503944689),P(17.505032566),P(17.506120308),P(17.507207915),P(17.508295387),P(17.509382724),P(17.510469925),P(17.511556992),P(17.512643924),P(17.513730720),P(17.514817382),P(17.515903910),P(17.516990302),
	P(17.518076560),P(17.519162682),P(17.520248671),P(17.521334524),P(17.522420243),P(17.523505828),P(17.524591278),P(17.525676594),P(17.526761775),P(17.527846822),P(17.528931734),P(17.530016513),P(17.531101157),P(17.532185666),P(17.533270042),P(17.534354284),
	P(17.535438391),P(17.536522365),P(17.537606204),P(17.538689910),P(17.539773481),P(17.540856919),P(17.541940223),P(17.543023393),P(17.544106429),P(17.545189332),P(17.546272101),P(17.547354736),P(17.548437238),P(17.549519607),P(17.550601841),P(17.551683943),
	P(17.552765911),P(17.553847745),P(17.554929446),P(17.556011014),P(17.557092449),P(17.558173751),P(17.559254919),P(17.560335954),P(17.561416856),P(17.562497625),P(17.563578261),P(17.564658765),P(17.565739135),P(17.566819372),P(17.567899477),P(17.568979448),
	P(17.570059287),P(17.571138993),P(17.572218567),P(17.573298008),P(17.574377316),P(17.575456492),P(17.576535535),P(17.577614446),P(17.578693224),P(17.579771870),P(17.580850384),P(17.581928765),P(17.583007014),P(17.584085131),P(17.585163116),P(17.586240968),
	P(17.587318689),P(17.588396277),P(17.589473733),P(17.590551058),P(17.591628250),P(17.592705310),P(17.593782239),P(17.594859036),P(17.595935701),P(17.597012234),P(17.598088635),P(17.599164905),P(17.600241044),P(17.601317050),P(17.602392925),P(17.603468669),
	P(17.604544281),P(17.605619762),P(17.606695111),P(17.607770329),P(17.608845416),P(17.609920371),P(17.610995196),P(17.612069889),P(17.613144451),P(17.614218882),P(17.615293181),P(17.616367350),P(17.617441388),P(17.618515295),P(17.619589071),P(17.620662716),
	P(17.621736230),P(17.622809613),P(17.623882866),P(17.624955988),P(17.626028979),P(17.627101840),P(17.628174570),P(17.629247170),P(17.630319639),P(17.631391978),P(17.632464186),P(17.633536264),P(17.634608211),P(17.635680028),P(17.636751715),P(17.637823272),
	P(17.638894699),P(17.639965995),P(17.641037161),P(17.642108197),P(17.643179104),P(17.644249880),P(17.645320526),P(17.646391042),P(17.647461429),P(17.648531685),P(17.649601812),P(17.650671809),P(17.651741677),P(17.652811414),P(17.653881022),P(17.654950501),
	P(17.656019850),P(17.657089069),P(17.658158159),P(17.659227120),P(17.660295951),P(17.661364652),P(17.662433225),P(17.663501668),P(17.664569982),P(17.665638166),P(17.666706222),P(17.667774148),P(17.668841946),P(17.669909614),P(17.670977153),P(17.672044563),
	P(17.673111845),P(17.674178997),P(17.675246021),P(17.676312916),P(17.677379682),P(17.678446319),P(17.679512828),P(17.680579207),P(17.681645459),P(17.682711582),P(17.683777576),P(17.684843441),P(17.685909179),P(17.686974787),P(17.688040268),P(17.689105620),
	P(17.690170844),P(17.691235939),P(17.692300906),P(17.693365745),P(17.694430456),P(17.695495039),P(17.696559494),P(17.697623821),P(17.698688019),P(17.699752090),P(17.700816033),P(17.701879848),P(17.702943535),P(17.704007094),P(17.705070525),P(17.706133829),
	P(17.707197005),P(17.708260054),P(17.709322974),P(17.710385767),P(17.711448433),P(17.712510971),P(17.713573382),P(17.714635665),P(17.715697821),P(17.716759850),P(17.717821751),P(17.718883525),P(17.719945172),P(17.721006691),P(17.722068083),P(17.723129349),
	P(17.724190487),P(17.725251498),P(17.726312382),P(17.727373139),P(17.728433769),P(17.729494273),P(17.730554649),P(17.731614899),P(17.732675022),P(17.733735018),P(17.734794887),P(17.735854630),P(17.736914246),P(17.737973736),P(17.739033098),P(17.740092335),
	P(17.741151445),P(17.742210429),P(17.743269286),P(17.744328016),P(17.745386621),P(17.746445099),P(17.747503451),P(17.748561677),P(17.749619776),P(17.750677750),P(17.751735597),P(17.752793318),P(17.753850913),P(17.754908383),P(17.755965726),P(17.757022943),
	P(17.758080035),P(17.759137001),P(17.760193840),P(17.761250554),P(17.762307143),P(17.763363606),P(17.764419943),P(17.765476154),P(17.766532240),P(17.767588200),P(17.768644035),P(17.769699744),P(17.770755328),P(17.771810787),P(17.772866120),P(17.773921328),
	P(17.774976410),P(17.776031368),P(17.777086200),P(17.778140907),P(17.779195489),P(17.780249946),P(17.781304277),P(17.782358484),P(17.783412566),P(17.784466522),P(17.785520354),P(17.786574061),P(17.787627643),P(17.788681101),P(17.789734433),P(17.790787641),
	P(17.791840725),P(17.792893683),P(17.793946517),P(17.794999226),P(17.796051811),P(17.797104272),P(17.798156607),P(17.799208819),P(17.800260906),P(17.801312869),P(17.802364707),P(17.803416421),P(17.804468011),P(17.805519477),P(17.806570818),P(17.807622036),
	P(17.808673129),P(17.809724098),P(17.810774943),P(17.811825664),P(17.812876262),P(17.813926735),P(17.814977084),P(17.816027310),P(17.817077412),P(17.818127390),P(17.819177244),P(17.820226975),P(17.821276582),P(17.822326065),P(17.823375425),P(17.824424661),
	P(17.825473774),P(17.826522763),P(17.827571629),P(17.828620371),P(17.829668990),P(17.830717486),P(17.831765858),P(17.832814107),P(17.833862233),P(17.834910236),P(17.835958116),P(17.837005872),P(17.838053505),P(17.839101016),P(17.840148403),P(17.841195667),
	P(17.842242809),P(17.843289827),P(17.844336723),P(17.845383496),P(17.846430146),P(17.847476673),P(17.848523078),P(17.849569360),P(17.850615519),P(17.851661556),P(17.852707470),P(17.853753261),P(17.854798930),P(17.855844477),P(17.856889901),P(17.857935203),
	P(17.858980382),P(17.860025439),P(17.861070374),P(17.862115187),P(17.863159877),P(17.864204445),P(17.865248891),P(17.866293215),P(17.867337417),P(17.868381497),P(17.869425455),P(17.870469290),P(17.871513004),P(17.872556596),P(17.873600066),P(17.874643415),
	P(17.875686641),P(17.876729746),P(17.877772729),P(17.878815591),P(17.879858330),P(17.880900948),P(17.881943445),P(17.882985820),P(17.884028073),P(17.885070206),P(17.886112216),P(17.887154105),P(17.888195873),P(17.889237520),P(17.890279045),P(17.891320449),
	P(17.892361732),P(17.893402893),P(17.894443934),P(17.895484853),P(17.896525651),P(17.897566329),P(17.898606885),P(17.899647320),P(17.900687634),P(17.901727828),P(17.902767900),P(17.903807852),P(17.904847683),P(17.905887393),P(17.906926982),P(17.907966451),
	P(17.909005799),P(17.910045026),P(17.911084133),P(17.912123119),P(17.913161985),P(17.914200730),P(17.915239355),P(17.916277859),P(17.917316244),P(17.918354507),P(17.919392651),P(17.920430674),P(17.921468576),P(17.922506359),P(17.923544022),P(17.924581564),
	P(17.925618986),P(17.926656288),P(17.927693471),P(17.928730533),P(17.929767475),P(17.930804297),P(17.931841000),P(17.932877582),P(17.933914045),P(17.934950388),P(17.935986611),P(17.937022714),P(17.938058698),P(17.939094562),P(17.940130307),P(17.941165932),
	P(17.942201437),P(17.943236823),P(17.944272089),P(17.945307236),P(17.946342264),P(17.947377172),P(17.948411961),P(17.949446630),P(17.950481180),P(17.951515611),P(17.952549923),P(17.953584116),P(17.954618189),P(17.955652144),P(17.956685979),P(17.957719695),
	P(17.958753293),P(17.959786771),P(17.960820130),P(17.961853371),P(17.962886493),P(17.963919495),P(17.964952380),P(17.965985145),P(17.967017791),P(17.968050319),P(17.969082729),P(17.970115019),P(17.971147191),P(17.972179245),P(17.973211180),P(17.974242996),
	P(17.975274694),P(17.976306274),P(17.977337735),P(17.978369078),P(17.979400302),P(17.980431409),P(17.981462397),P(17.982493267),P(17.983524018),P(17.984554652),P(17.985585167),P(17.986615564),P(17.987645844),P(17.988676005),P(17.989706048),P(17.990735974),
	P(17.991765781),P(17.992795471),P(17.993825042),P(17.994854496),P(17.995883832),P(17.996913051),P(17.997942152),P(17.998971135),P(18.000000000),P(18.001028748),P(18.002057378),P(18.003085891),P(18.004114286),P(18.005142564),P(18.006170724),P(18.007198767),
	P(18.008226692),P(18.009254500),P(18.010282191),P(18.011309765),P(18.012337221),P(18.013364560),P(18.014391782),P(18.015418887),P(18.016445875),P(18.017472746),P(18.018499499),P(18.019526136),P(18.020552655),P(18.021579058),P(18.022605344),P(18.023631513),
	P(18.024657565),P(18.025683500),P(18.026709319),P(18.027735021),P(18.028760606),P(18.029786074),P(18.030811426),P(18.031836661),P(18.032861780),P(18.033886782),P(18.034911668),P(18.035936437),P(18.036961089),P(18.037985626),P(18.039010046),P(18.040034349),
	P(18.041058536),P(18.042082607),P(18.043106562),P(18.044130401),P(18.045154123),P(18.046177729),P(18.047201219),P(18.048224593),P(18.049247851),P(18.050270993),P(18.051294019),P(18.052316930),P(18.053339724),P(18.054362402),P(18.055384964),P(18.056407411),
	P(18.057429742),P(18.058451957),P(18.059474056),P(18.060496040),P(18.061517908),P(18.062539661),P(18.063561297),P(18.064582819),P(18.065604225),P(18.066625515),P(18.067646690),P(18.068667749),P(18.069688693),P(18.070709522),P(18.071730235),P(18.072750833),
	P(18.073771316),P(18.074791684),P(18.075811936),P(18.076832073),P(18.077852096),P(18.078872003),P(18.079891795),P(18.080911472),P(18.081931033),P(18.082950480),P(18.083969812),P(18.084989030),P(18.086008132),P(18.087027119),P(18.088045992),P(18.089064750),
	P(18.090083393),P(18.091101921),P(18.092120335),P(18.093138634),P(18.094156819),P(18.095174889),P(18.096192844),P(18.097210685),P(18.098228411),P(18.099246023),P(18.100263521),P(18.101280904),P(18.102298173),P(18.103315327),P(18.104332367),P(18.105349293),
	P(18.106366105),P(18.107382803),P(18.108399386),P(18.109415855),P(18.110432210),P(18.111448451),P(18.112464579),P(18.113480592),P(18.114496491),P(18.115512276),P(18.116527947),P(18.117543504),P(18.118558948),P(18.119574278),P(18.120589494),P(18.121604596),
	P(18.122619584),P(18.123634459),P(18.124649220),P(18.125663868),P(18.126678402),P(18.127692822),P(18.128707129),P(18.129721323),P(18.130735403),P(18.131749369),P(18.132763222),P(18.133776962),P(18.134790588),P(18.135804102),P(18.136817501),P(18.137830788),
	P(18.138843961),P(18.139857022),P(18.140869969),P(18.141882803),P(18.142895524),P(18.143908132),P(18.144920627),P(18.145933008),P(18.146945277),P(18.147957433),P(18.148969477),P(18.149981407),P(18.150993224),P(18.152004929),P(18.153016521),P(18.154028000),
	P(18.155039366),P(18.156050620),P(18.157061761),P(18.158072790),P(18.159083706),P(18.160094509),P(18.161105200),P(18.162115779),P(18.163126245),P(18.164136598),P(18.165146840),P(18.166156968),P(18.167166985),P(18.168176889),P(18.169186681),P(18.170196361),
	P(18.171205928),P(18.172215384),P(18.173224727),P(18.174233958),P(18.175243077),P(18.176252084),P(18.177260979),P(18.178269762),P(18.179278433),P(18.180286992),P(18.181295440),P(18.182303775),P(18.183311998),P(18.184320110),P(18.185328110),P(18.186335999),
	P(18.187343775),P(18.188351440),P(18.189358993),P(18.190366435),P(18.191373765),P(18.192380984),P(18.193388091),P(18.194395086),P(18.195401970),P(18.196408743),P(18.197415404),P(18.198421954),P(18.199428392),P(18.200434720),P(18.201440936),P(18.202447040),
	P(18.203453034),P(18.204458916),P(18.205464688),P(18.206470348),P(18.207475897),P(18.208481335),P(18.209486662),P(18.210491877),P(18.211496982),P(18.212501977),P(18.213506860),P(18.214511632),P(18.215516293),P(18.216520844),P(18.217525284),P(18.218529613),
	P(18.219533831),P(18.220537939),P(18.221541936),P(18.222545822),P(18.223549598),P(18.224553263),P(18.225556818),P(18.226560262),P(18.227563596),P(18.228566819),P(18.229569932),P(18.230572935),P(18.231575827),P(18.232578609),P(18.233581280),P(18.234583841),
	P(18.235586292),P(18.236588633),P(18.237590864),P(18.238592984),P(18.239594995),P(18.240596895),P(18.241598685),P(18.242600365),P(18.243601936),P(18.244603396),P(18.245604746),P(18.246605987),P(18.247607117),P(18.248608138),P(18.249609049),P(18.250609850),
	P(18.251610542),P(18.252611123),P(18.253611595),P(18.254611958),P(18.255612210),P(18.256612353),P(18.257612387),P(18.258612311),P(18.259612125),P(18.260611830),P(18.261611426),P(18.262610912),P(18.263610289),P(18.264609556),P(18.265608714),P(18.266607763),
	P(18.267606703),P(18.268605533),P(18.269604254),P(18.270602866),P(18.271601369),P(18.272599762),P(18.273598047),P(18.274596222),P(18.275594289),P(18.276592246),P(18.277590095),P(18.278587834),P(18.279585465),P(18.280582986),P(18.281580399),P(18.282577703),
	P(18.283574899),P(18.284571985),P(18.285568963),P(18.286565832),P(18.287562592),P(18.288559244),P(18.289555787),P(18.290552222),P(18.291548548),P(18.292544765),P(18.293540874),P(18.294536874),P(18.295532766),P(18.296528550),P(18.297524225),P(18.298519792),
	P(18.299515251),P(18.300510601),P(18.301505843),P(18.302500977),P(18.303496003),P(18.304490920),P(18.305485729),P(18.306480431),P(18.307475024),P(18.308469509),P(18.309463886),P(18.310458155),P(18.311452316),P(18.312446369),P(18.313440314),P(18.314434151),
	P(18.315427881),P(18.316421503),P(18.317415016),P(18.318408422),P(18.319401721),P(18.320394911),P(18.321387994),P(18.322380970),P(18.323373838),P(18.324366598),P(18.325359250),P(18.326351795),P(18.327344233),P(18.328336563),P(18.329328786),P(18.330320901),
	P(18.331312909),P(18.332304809),P(18.333296602),P(18.334288288),P(18.335279867),P(18.336271338),P(18.337262702),P(18.338253959),P(18.339245109),P(18.340236152),P(18.341227087),P(18.342217916),P(18.343208637),P(18.344199252),P(18.345189759),P(18.346180160),
	P(18.347170454),P(18.348160640),P(18.349150720),P(18.350140693),P(18.351130560),P(18.352120319),P(18.353109972),P(18.354099518),P(18.355088957),P(18.356078290),P(18.357067516),P(18.358056635),P(18.359045648),P(18.360034555),P(18.361023354),P(18.362012048),
	P(18.363000634),P(18.363989115),P(18.364977489),P(18.365965757),P(18.366953918),P(18.367941973),P(18.368929922),P(18.369917764),P(18.370905500),P(18.371893130),P(18.372880654),P(18.373868072),P(18.374855383),P(18.375842589),P(18.376829688),P(18.377816681),
	P(18.378803569),P(18.379790350),P(18.380777026),P(18.381763595),P(18.382750059),P(18.383736417),P(18.384722669),P(18.385708815),P(18.386694855),P(18.387680790),P(18.388666619),P(18.389652342),P(18.390637959),P(18.391623471),P(18.392608878),P(18.393594178),
	P(18.394579374),P(18.395564463),P(18.396549447),P(18.397534326),P(18.398519099),P(18.399503767),P(18.400488330),P(18.401472787),P(18.402457139),P(18.403441385),P(18.404425527),P(18.405409563),P(18.406393493),P(18.407377319),P(18.408361039),P(18.409344655),
	P(18.410328165),P(18.411311570),P(18.412294870),P(18.413278065),P(18.414261156),P(18.415244141),P(18.416227021),P(18.417209796),P(18.418192467),P(18.419175032),P(18.420157493),P(18.421139849),P(18.422122100),P(18.423104247),P(18.424086289),P(18.425068226),
	P(18.426050058),P(18.427031786),P(18.428013409),P(18.428994928),P(18.429976342),P(18.430957652),P(18.431938857),P(18.432919958),P(18.433900954),P(18.434881846),P(18.435862633),P(18.436843317),P(18.437823895),P(18.438804370),P(18.439784740),P(18.440765006),
	P(18.441745168),P(18.442725226),P(18.443705179),P(18.444685029),P(18.445664774),P(18.446644415),P(18.447623953),P(18.448603386),P(18.449582715),P(18.450561940),P(18.451541061),P(18.452520079),P(18.453498992),P(18.454477802),P(18.455456508),P(18.456435110),
	P(18.457413608),P(18.458392003),P(18.459370294),P(18.460348481),P(18.461326565),P(18.462304544),P(18.463282421),P(18.464260193),P(18.465237863),P(18.466215428),P(18.467192890),P(18.468170249),P(18.469147504),P(18.470124656),P(18.471101705),P(18.472078650),
	P(18.473055492),P(18.474032230),P(18.475008866),P(18.475985398),P(18.476961826),P(18.477938152),P(18.478914374),P(18.479890494),P(18.480866510),P(18.481842423),P(18.482818233),P(18.483793940),P(18.484769544),P(18.485745045),P(18.486720443),P(18.487695738),
	P(18.488670931),P(18.489646020),P(18.490621007),P(18.491595891),P(18.492570672),P(18.493545350),P(18.494519925),P(18.495494398),P(18.496468768),P(18.497443036),P(18.498417201),P(18.499391263),P(18.500365223),P(18.501339080),P(18.502312835),P(18.503286487),
	P(18.504260037),P(18.505233484),P(18.506206829),P(18.507180072),P(18.508153212),P(18.509126250),P(18.510099185),P(18.511072018),P(18.512044749),P(18.513017378),P(18.513989905),P(18.514962329),P(18.515934652),P(18.516906872),P(18.517878990),P(18.518851006),
	P(18.519822920),P(18.520794733),P(18.521766443),P(18.522738051),P(18.523709557),P(18.524680961),P(18.525652264),P(18.526623465),P(18.527594563),P(18.528565560),P(18.529536456),P(18.530507249),P(18.531477941),P(18.532448531),P(18.533419020),P(18.534389407),
	P(18.535359692),P(18.536329876),P(18.537299958),P(18.538269938),P(18.539239818),P(18.540209595),P(18.541179272),P(18.542148846),P(18.543118320),P(18.544087692),P(18.545056963),P(18.546026132),P(18.546995200),P(18.547964167),P(18.548933033),P(18.549901797),
	P(18.550870460),P(18.551839023),P(18.552807484),P(18.553775843),P(18.554744102),P(18.555712260),P(18.556680317),P(18.557648273),P(18.558616127),P(18.559583881),P(18.560551534),P(18.561519086),P(18.562486538),P(18.563453888),P(18.564421138),P(18.565388286),
	P(18.566355334),P(18.567322282),P(18.568289128),P(18.569255874),P(18.570222520),P(18.571189064),P(18.572155508),P(18.573121852),P(18.574088095),P(18.575054237),P(18.576020279),P(18.576986221),P(18.577952062),P(18.578917802),P(18.579883442),P(18.580848982),
	P(18.581814422),P(18.582779761),P(18.583745000),P(18.584710139),P(18.585675177),P(18.586640115),P(18.587604953),P(18.588569691),P(18.589534329),P(18.590498867),P(18.591463304),P(18.592427642),P(18.593391879),P(18.594356017),P(18.595320054),P(18.596283992),
	P(18.597247830),P(18.598211567),P(18.599175205),P(18.600138743),P(18.601102182),P(18.602065520),P(18.603028759),P(18.603991898),P(18.604954937),P(18.605917876),P(18.606880716),P(18.607843457),P(18.608806097),P(18.609768638),P(18.610731080),P(18.611693422),
	P(18.612655664),P(18.613617807),P(18.614579851),P(18.615541795),P(18.616503639),P(18.617465385),P(18.618427031),P(18.619388577),P(18.620350025),P(18.621311373),P(18.622272621),P(18.623233771),P(18.624194821),P(18.625155772),P(18.626116624),P(18.627077377),
	P(18.628038031),P(18.628998586),P(18.629959042),P(18.630919398),P(18.631879656),P(18.632839815),P(18.633799874),P(18.634759835),P(18.635719697),P(18.636679460),P(18.637639125),P(18.638598690),P(18.639558157),P(18.640517524),P(18.641476794),P(18.642435964),
	P(18.643395036),P(18.644354009),P(18.645312883),P(18.646271659),P(18.647230336),P(18.648188915),P(18.649147395),P(18.650105777),P(18.651064060),P(18.652022244),P(18.652980330),P(18.653938318),P(18.654896208),P(18.655853999),P(18.656811691),P(18.657769286),
	P(18.658726782),P(18.659684180),P(18.660641479),P(18.661598681),P(18.662555784),P(18.663512789),P(18.664469696),P(18.665426505),P(18.666383216),P(18.667339828),P(18.668296343),P(18.669252760),P(18.670209078),P(18.671165299),P(18.672121422),P(18.673077447),
	P(18.674033374),P(18.674989203),P(18.675944934),P(18.676900567),P(18.677856103),P(18.678811541),P(18.679766881),P(18.680722124),P(18.681677269),P(18.682632316),P(18.683587265),P(18.684542117),P(18.685496871),P(18.686451528),P(18.687406087),P(18.688360549),
	P(18.689314913),P(18.690269180),P(18.691223350),P(18.692177421),P(18.693131396),P(18.694085273),P(18.695039053),P(18.695992736),P(18.696946321),P(18.697899809),P(18.698853200),P(18.699806493),P(18.700759690),P(18.701712789),P(18.702665791),P(18.703618696),
	P(18.704571504),P(18.705524215),P(18.706476828),P(18.707429345),P(18.708381765),P(18.709334088),P(18.710286314),P(18.711238443),P(18.712190475),P(18.713142410),P(18.714094248),P(18.715045990),P(18.715997635),P(18.716949183),P(18.717900634),P(18.718851988),
	P(18.719803246),P(18.720754407),P(18.721705472),P(18.722656440),P(18.723607311),P(18.724558086),P(18.725508764),P(18.726459346),P(18.727409831),P(18.728360220),P(18.729310512),P(18.730260708),P(18.731210807),P(18.732160811),P(18.733110717),P(18.734060528),
	P(18.735010242),P(18.735959860),P(18.736909381),P(18.737858807),P(18.738808136),P(18.739757369),P(18.740706506),P(18.741655546),P(18.742604491),P(18.743553339),P(18.744502092),P(18.745450748),P(18.746399309),P(18.747347773),P(18.748296141),P(18.749244414),
	P(18.750192591),P(18.751140671),P(18.752088656),P(18.753036545),P(18.753984338),P(18.754932036),P(18.755879638),P(18.756827143),P(18.757774554),P(18.758721868),P(18.759669087),P(18.760616210),P(18.761563238),P(18.762510170),P(18.763457006),P(18.764403747),
	P(18.765350392),P(18.766296942),P(18.767243397),P(18.768189755),P(18.769136019),P(18.770082187),P(18.771028260),P(18.771974237),P(18.772920119),P(18.773865906),P(18.774811597),P(18.775757193),P(18.776702694),P(18.777648100),P(18.778593410),P(18.779538626),
	P(18.780483746),P(18.781428771),P(18.782373701),P(18.783318536),P(18.784263276),P(18.785207921),P(18.786152471),P(18.787096926),P(18.788041286),P(18.788985551),P(18.789929721),P(18.790873796),P(18.791817776),P(18.792761662),P(18.793705453),P(18.794649149),
	P(18.795592750),P(18.796536256),P(18.797479668),P(18.798422985),P(18.799366208),P(18.800309335),P(18.801252369),P(18.802195307),P(18.803138151),P(18.804080901),P(18.805023556),P(18.805966116),P(18.806908582),P(18.807850954),P(18.808793231),P(18.809735413),
	P(18.810677502),P(18.811619496),P(18.812561395),P(18.813503201),P(18.814444912),P(18.815386529),P(18.816328051),P(18.817269479),P(18.818210814),P(18.819152054),P(18.820093199),P(18.821034251),P(18.821975209),P(18.822916072),P(18.823856842),P(18.824797517),
	P(18.825738099),P(18.826678586),P(18.827618980),P(18.828559279),P(18.829499485),P(18.830439597),P(18.831379615),P(18.832319539),P(18.833259369),P(18.834199106),P(18.835138748),P(18.836078297),P(18.837017753),P(18.837957114),P(18.838896382),P(18.839835556),
	P(18.840774637),P(18.841713624),P(18.842652518),P(18.843591317),P(18.844530024),P(18.845468637),P(18.846407156),P(18.847345582),P(18.848283914),P(18.849222153),P(18.850160299),P(18.851098351),P(18.852036310),P(18.852974176),P(18.853911948),P(18.854849627),
	P(18.855787213),P(18.856724705),P(18.857662105),P(18.858599411),P(18.859536624),P(18.860473744),P(18.861410770),P(18.862347704),P(18.863284545),P(18.864221292),P(18.865157947),P(18.866094508),P(18.867030977),P(18.867967352),P(18.868903635),P(18.869839824),
	P(18.870775921),P(18.871711925),P(18.872647836),P(18.873583655),P(18.874519380),P(18.875455013),P(18.876390553),P(18.877326000),P(18.878261355),P(18.879196617),P(18.880131786),P(18.881066863),P(18.882001847),P(18.882936738),P(18.883871537),P(18.884806243),
	P(18.885740857),P(18.886675378),P(18.887609807),P(18.888544143),P(18.889478387),P(18.890412539),P(18.891346598),P(18.892280565),P(18.893214439),P(18.894148221),P(18.895081911),P(18.896015509),P(18.896949014),P(18.897882427),P(18.898815748),P(18.899748977),
	P(18.900682114),P(18.901615158),P(18.902548111),P(18.903480971),P(18.904413739),P(18.905346415),P(18.906279000),P(18.907211492),P(18.908143892),P(18.909076200),P(18.910008417),P(18.910940541),P(18.911872574),P(18.912804514),P(18.913736363),P(18.914668120),
	P(18.915599785),P(18.916531359),P(18.917462841),P(18.918394231),P(18.919325529),P(18.920256736),P(18.921187851),P(18.922118874),P(18.923049806),P(18.923980646),P(18.924911395),P(18.925842052),P(18.926772617),P(18.927703091),P(18.928633474),P(18.929563765),
	P(18.930493965),P(18.931424073),P(18.932354090),P(18.933284015),P(18.934213850),P(18.935143592),P(18.936073244),P(18.937002804),P(18.937932273),P(18.938861651),P(18.939790938),P(18.940720133),P(18.941649238),P(18.942578251),P(18.943507173),P(18.944436004),
	P(18.945364744),P(18.946293393),P(18.947221950),P(18.948150417),P(18.949078793),P(18.950007078),P(18.950935272),P(18.951863375),P(18.952791387),P(18.953719308),P(18.954647139),P(18.955574878),P(18.956502527),P(18.957430085),P(18.958357552),P(18.959284929),
	P(18.960212214),P(18.961139409),P(18.962066514),P(18.962993528),P(18.963920451),P(18.964847283),P(18.965774025),P(18.966700677),P(18.967627237),P(18.968553708),P(18.969480088),P(18.970406377),P(18.971332576),P(18.972258684),P(18.973184703),P(18.974110630),
	P(18.975036468),P(18.975962215),P(18.976887871),P(18.977813438),P(18.978738914),P(18.979664300),P(18.980589595),P(18.981514801),P(18.982439916),P(18.983364941),P(18.984289876),P(18.985214721),P(18.986139476),P(18.987064140),P(18.987988715),P(18.988913200),
	P(18.989837594),P(18.990761899),P(18.991686113),P(18.992610238),P(18.993534273),P(18.994458218),P(18.995382073),P(18.996305838),P(18.997229513),P(18.998153098),P(18.999076594),P(19.000000000),P(19.000923316),P(19.001846543),P(19.002769679),P(19.003692726),
	P(19.004615684),P(19.005538552),P(19.006461330),P(19.007384018),P(19.008306617),P(19.009229127),P(19.010151547),P(19.011073877),P(19.011996118),P(19.012918269),P(19.013840331),P(19.014762304),P(19.015684187),P(19.016605981),P(19.017527685),P(19.018449300),
	P(19.019370826),P(19.020292263),P(19.021213610),P(19.022134868),P(19.023056037),P(19.023977116),P(19.024898107),P(19.025819008),P(19.026739820),P(19.027660543),P(19.028581177),P(19.029501721),P(19.030422177),P(19.031342544),P(19.032262822),P(19.033183010),
	P(19.034103110),P(19.035023121),P(19.035943043),P(19.036862876),P(19.037782620),P(19.038702275),P(19.039621841),P(19.040541319),P(19.041460708),P(19.042380008),P(19.043299219),P(19.044218341),P(19.045137375),P(19.046056320),P(19.046975177),P(19.047893944),
	P(19.048812624),P(19.049731214),P(19.050649716),P(19.051568130),P(19.052486454),P(19.053404691),P(19.054322839),P(19.055240898),P(19.056158869),P(19.057076752),P(19.057994546),P(19.058912251),P(19.059829869),P(19.060747398),P(19.061664838),P(19.062582191),
	P(19.063499455),P(19.064416631),P(19.065333718),P(19.066250718),P(19.067167629),P(19.068084452),P(19.069001187),P(19.069917833),P(19.070834392),P(19.071750862),P(19.072667245),P(19.073583539),P(19.074499746),P(19.075415864),P(19.076331894),P(19.077247837),
	P(19.078163691),P(19.079079458),P(19.079995136),P(19.080910727),P(19.081826230),P(19.082741645),P(19.083656972),P(19.084572211),P(19.085487363),P(19.086402427),P(19.087317403),P(19.088232291),P(19.089147092),P(19.090061805),P(19.090976431),P(19.091890969),
	P(19.092805419),P(19.093719781),P(19.094634056),P(19.095548244),P(19.096462344),P(19.097376356),P(19.098290281),P(19.099204119),P(19.100117869),P(19.101031532),P(19.101945107),P(19.102858595),P(19.103771995),P(19.104685308),P(19.105598534),P(19.106511673),
	P(19.107424724),P(19.108337688),P(19.109250565),P(19.110163355),P(19.111076057),P(19.111988672),P(19.112901200),P(19.113813641),P(19.114725995),P(19.115638262),P(19.116550442),P(19.117462534),P(19.118374540),P(19.119286459),P(19.120198290),P(19.121110035),
	P(19.122021693),P(19.122933264),P(19.123844748),P(19.124756145),P(19.125667455),P(19.126578678),P(19.127489815),P(19.128400865),P(19.129311828),P(19.130222704),P(19.131133493),P(19.132044196),P(19.132954812),P(19.133865342),P(19.134775785),P(19.135686141),
	P(19.136596410),P(19.137506593),P(19.138416690),P(19.139326699),P(19.140236623),P(19.141146459),P(19.142056210),P(19.142965874),P(19.143875451),P(19.144784942),P(19.145694347),P(19.146603665),P(19.147512897),P(19.148422042),P(19.149331101),P(19.150240074),
	P(19.151148961),P(19.152057761),P(19.152966475),P(19.153875103),P(19.154783645),P(19.155692100),P(19.156600469),P(19.157508753),P(19.158416950),P(19.159325061),P(19.160233085),P(19.161141024),P(19.162048877),P(19.162956644),P(19.163864325),P(19.164771919),
	P(19.165679428),P(19.166586851),P(19.167494188),P(19.168401439),P(19.169308605),P(19.170215684),P(19.171122677),P(19.172029585),P(19.172936407),P(19.173843143),P(19.174749794),P(19.175656358),P(19.176562837),P(19.177469231),P(19.178375538),P(19.179281760),
	P(19.180187897),P(19.181093947),P(19.181999913),P(19.182905792),P(19.183811586),P(19.184717295),P(19.185622918),P(19.186528455),P(19.187433907),P(19.188339274),P(19.189244555),P(19.190149751),P(19.191054861),P(19.191959886),P(19.192864826),P(19.193769680),
	P(19.194674449),P(19.195579133),P(19.196483731),P(19.197388244),P(19.198292672),P(19.199197015),P(19.200101273),P(19.201005445),P(19.201909532),P(19.202813534),P(19.203717451),P(19.204621283),P(19.205525030),P(19.206428692),P(19.207332269),P(19.208235761),
	P(19.209139168),P(19.210042489),P(19.210945726),P(19.211848878),P(19.212751945),P(19.213654928),P(19.214557825),P(19.215460637),P(19.216363365),P(19.217266008),P(19.218168566),P(19.219071039),P(19.219973428),P(19.220875732),P(19.221777951),P(19.222680085),
	P(19.223582135),P(19.224484100),P(19.225385980),P(19.226287776),P(19.227189488),P(19.228091114),P(19.228992656),P(19.229894114),P(19.230795487),P(19.231696776),P(19.232597980),P(19.233499100),P(19.234400135),P(19.235301086),P(19.236201952),P(19.237102734),
	P(19.238003432),P(19.238904046),P(19.239804575),P(19.240705020),P(19.241605380),P(19.242505656),P(19.243405848),P(19.244305956),P(19.245205980),P(19.246105919),P(19.247005775),P(19.247905546),P(19.248805233),P(19.249704836),P(19.250604355),P(19.251503790),
	P(19.252403141),P(19.253302408),P(19.254201590),P(19.255100689),P(19.255999704),P(19.256898635),P(19.257797482),P(19.258696245),P(19.259594924),P(19.260493520),P(19.261392031),P(19.262290459),P(19.263188803),P(19.264087063),P(19.264985240),P(19.265883332),
	P(19.266781341),P(19.267679266),P(19.268577108),P(19.269474866),P(19.270372540),P(19.271270131),P(19.272167638),P(19.273065061),P(19.273962401),P(19.274859657),P(19.275756830),P(19.276653919),P(19.277550925),P(19.278447847),P(19.279344686),P(19.280241441),
	P(19.281138113),P(19.282034702),P(19.282931207),P(19.283827629),P(19.284723968),P(19.285620223),P(19.286516395),P(19.287412484),P(19.288308489),P(19.289204411),P(19.290100250),P(19.290996006),P(19.291891678),P(19.292787268),P(19.293682774),P(19.294578197),
	P(19.295473537),P(19.296368794),P(19.297263968),P(19.298159059),P(19.299054067),P(19.299948992),P(19.300843834),P(19.301738593),P(19.302633268),P(19.303527861),P(19.304422372),P(19.305316799),P(19.306211143),P(19.307105405),P(19.307999583),P(19.308893679),
	P(19.309787692),P(19.310681622),P(19.311575470),P(19.312469235),P(19.313362917),P(19.314256516),P(19.315150033),P(19.316043467),P(19.316936818),P(19.317830087),P(19.318723273),P(19.319616377),P(19.320509398),P(19.321402336),P(19.322295192),P(19.323187965),
	P(19.324080656),P(19.324973265),P(19.325865791),P(19.326758234),P(19.327650596),P(19.328542874),P(19.329435071),P(19.330327185),P(19.331219217),P(19.332111166),P(19.333003033),P(19.333894818),P(19.334786520),P(19.335678141),P(19.336569679),P(19.337461135),
	P(19.338352508),P(19.339243800),P(19.340135009),P(19.341026137),P(19.341917182),P(19.342808145),P(19.343699026),P(19.344589825),P(19.345480542),P(19.346371177),P(19.347261730),P(19.348152200),P(19.349042589),P(19.349932896),P(19.350823122),P(19.351713265),
	P(19.352603326),P(19.353493306),P(19.354383203),P(19.355273019),P(19.356162753),P(19.357052405),P(19.357941976),P(19.358831464),P(19.359720871),P(19.360610196),P(19.361499440),P(19.362388602),P(19.363277682),P(19.364166681),P(19.365055597),P(19.365944433),
	P(19.366833187),P(19.367721859),P(19.368610449),P(19.369498959),P(19.370387386),P(19.371275732),P(19.372163997),P(19.373052180),P(19.373940282),P(19.374828302),P(19.375716241),P(19.376604099),P(19.377491875),P(19.378379570),P(19.379267184),P(19.380154716),
	P(19.381042167),P(19.381929537),P(19.382816825),P(19.383704032),P(19.384591158),P(19.385478203),P(19.386365167),P(19.387252049),P(19.388138851),P(19.389025571),P(19.389912210),P(19.390798768),P(19.391685245),P(19.392571641),P(19.393457956),P(19.394344190),
	P(19.395230343),P(19.396116415),P(19.397002406),P(19.397888317),P(19.398774146),P(19.399659894),P(19.400545562),P(19.401431148),P(19.402316654),P(19.403202079),P(19.404087423),P(19.404972686),P(19.405857869),P(19.406742971),P(19.407627992),P(19.408512932),
	P(19.409397792),P(19.410282571),P(19.411167269),P(19.412051887),P(19.412936424),P(19.413820881),P(19.414705257),P(19.415589552),P(19.416473767),P(19.417357901),P(19.418241955),P(19.419125929),P(19.420009821),P(19.420893634),P(19.421777366),P(19.422661017),
	P(19.423544588),P(19.424428079),P(19.425311490),P(19.426194820),P(19.427078069),P(19.427961239),P(19.428844328),P(19.429727337),P(19.430610266),P(19.431493114),P(19.432375882),P(19.433258570),P(19.434141178),P(19.435023706),P(19.435906153),P(19.436788520),
	P(19.437670808),P(19.438553015),P(19.439435142),P(19.440317189),P(19.441199156),P(19.442081043),P(19.442962850),P(19.443844577),P(19.444726224),P(19.445607791),P(19.446489279),P(19.447370686),P(19.448252013),P(19.449133261),P(19.450014428),P(19.450895516),
	P(19.451776524),P(19.452657453),P(19.453538301),P(19.454419070),P(19.455299759),P(19.456180368),P(19.457060898),P(19.457941347),P(19.458821718),P(19.459702008),P(19.460582219),P(19.461462350),P(19.462342402),P(19.463222374),P(19.464102266),P(19.464982079),
	P(19.465861813),P(19.466741467),P(19.467621041),P(19.468500536),P(19.469379952),P(19.470259288),P(19.471138544),P(19.472017722),P(19.472896819),P(19.473775838),P(19.474654777),P(19.475533637),P(19.476412417),P(19.477291119),P(19.478169741),P(19.479048283),
	P(19.479926747),P(19.480805131),P(19.481683436),P(19.482561662),P(19.483439808),P(19.484317876),P(19.485195864),P(19.486073774),P(19.486951604),P(19.487829355),P(19.488707027),P(19.489584620),P(19.490462134),P(19.491339569),P(19.492216925),P(19.493094202),
	P(19.493971400),P(19.494848519),P(19.495725559),P(19.496602520),P(19.497479402),P(19.498356206),P(19.499232931),P(19.500109576),P(19.500986143),P(19.501862632),P(19.502739041),P(19.503615372),P(19.504491624),P(19.505367797),P(19.506243891),P(19.507119907),
	P(19.507995844),P(19.508871703),P(19.509747483),P(19.510623184),P(19.511498806),P(19.512374350),P(19.513249816),P(19.514125203),P(19.515000511),P(19.515875741),P(19.516750893),P(19.517625965),P(19.518500960),P(19.519375876),P(19.520250713),P(19.521125473),
	P(19.522000153),P(19.522874756),P(19.523749280),P(19.524623726),P(19.525498093),P(19.526372382),P(19.527246593),P(19.528120725),P(19.528994780),P(19.529868756),P(19.530742653),P(19.531616473),P(19.532490215),P(19.533363878),P(19.534237463),P(19.535110970),
	P(19.535984399),P(19.536857750),P(19.537731023),P(19.538604217),P(19.539477334),P(19.540350372),P(19.541223333),P(19.542096216),P(19.542969020),P(19.543841747),P(19.544714396),P(19.545586967),P(19.546459460),P(19.547331875),P(19.548204212),P(19.549076471),
	P(19.549948653),P(19.550820756),P(19.551692782),P(19.552564730),P(19.553436601),P(19.554308393),P(19.555180108),P(19.556051746),P(19.556923305),P(19.557794787),P(19.558666191),P(19.559537517),P(19.560408766),P(19.561279938),P(19.562151031),P(19.563022047),
	P(19.563892986),P(19.564763847),P(19.565634631),P(19.566505337),P(19.567375965),P(19.568246516),P(19.569116990),P(19.569987386),P(19.570857705),P(19.571727946),P(19.572598110),P(19.573468197),P(19.574338206),P(19.575208138),P(19.576077992),P(19.576947770),
	P(19.577817470),P(19.578687093),P(19.579556638),P(19.580426106),P(19.581295497),P(19.582164811),P(19.583034048),P(19.583903208),P(19.584772290),P(19.585641295),P(19.586510224),P(19.587379075),P(19.588247849),P(19.589116546),P(19.589985166),P(19.590853708),
	P(19.591722174),P(19.592590563),P(19.593458875),P(19.594327110),P(19.595195268),P(19.596063349),P(19.596931354),P(19.597799281),P(19.598667131),P(19.599534905),P(19.600402602),P(19.601270222),P(19.602137765),P(19.603005231),P(19.603872621),P(19.604739934),
	P(19.605607170),P(19.606474329),P(19.607341412),P(19.608208418),P(19.609075347),P(19.609942200),P(19.610808976),P(19.611675676),P(19.612542299),P(19.613408845),P(19.614275315),P(19.615141708),P(19.616008024),P(19.616874265),P(19.617740428),P(19.618606515),
	P(19.619472526),P(19.620338460),P(19.621204318),P(19.622070100),P(19.622935805),P(19.623801433),P(19.624666986),P(19.625532462),P(19.626397861),P(19.627263184),P(19.628128431),P(19.628993602),P(19.629858697),P(19.630723715),P(19.631588657),P(19.632453523),
	P(19.633318312),P(19.634183026),P(19.635047663),P(19.635912224),P(19.636776709),P(19.637641118),P(19.638505451),P(19.639369708),P(19.640233888),P(19.641097993),P(19.641962021),P(19.642825974),P(19.643689851),P(19.644553651),P(19.645417376),P(19.646281025),
	P(19.647144597),P(19.648008094),P(19.648871515),P(19.649734860),P(19.650598130),P(19.651461323),P(19.652324441),P(19.653187482),P(19.654050448),P(19.654913339),P(19.655776153),P(19.656638892),P(19.657501555),P(19.658364142),P(19.659226654),P(19.660089090),
	P(19.660951450),P(19.661813734),P(19.662675943),P(19.663538077),P(19.664400135),P(19.665262117),P(19.666124023),P(19.666985855),P(19.667847610),P(19.668709290),P(19.669570895),P(19.670432424),P(19.671293878),P(19.672155256),P(19.673016559),P(19.673877786),
	P(19.674738938),P(19.675600014),P(19.676461016),P(19.677321942),P(19.678182792),P(19.679043567),P(19.679904267),P(19.680764892),P(19.681625441),P(19.682485916),P(19.683346314),P(19.684206638),P(19.685066887),P(19.685927060),P(19.686787158),P(19.687647181),
	P(19.688507129),P(19.689367002),P(19.690226800),P(19.691086522),P(19.691946170),P(19.692805742),P(19.693665240),P(19.694524662),P(19.695384010),P(19.696243282),P(19.697102480),P(19.697961602),P(19.698820650),P(19.699679622),P(19.700538520),P(19.701397343),
	P(19.702256091),P(19.703114764),P(19.703973363),P(19.704831886),P(19.705690335),P(19.706548709),P(19.707407008),P(19.708265232),P(19.709123382),P(19.709981457),P(19.710839457),P(19.711697383),P(19.712555234),P(19.713413010),P(19.714270711),P(19.715128338),
	P(19.715985891),P(19.716843368),P(19.717700772),P(19.718558100),P(19.719415354),P(19.720272534),P(19.721129639),P(19.721986669),P(19.722843625),P(19.723700507),P(19.724557314),P(19.725414047),P(19.726270705),P(19.727127289),P(19.727983799),P(19.728840234),
	P(19.729696595),P(19.730552881),P(19.731409093),P(19.732265231),P(19.733121295),P(19.733977284),P(19.734833199),P(19.735689040),P(19.736544806),P(19.737400499),P(19.738256117),P(19.739111661),P(19.739967131),P(19.740822527),P(19.741677848),P(19.742533096),
	P(19.743388269),P(19.744243368),P(19.745098394),P(19.745953345),P(19.746808222),P(19.747663025),P(19.748517754),P(19.749372410),P(19.750226991),P(19.751081498),P(19.751935932),P(19.752790291),P(19.753644577),P(19.754498788),P(19.755352926),P(19.756206990),
	P(19.757060980),P(19.757914896),P(19.758768739),P(19.759622507),P(19.760476202),P(19.761329824),P(19.762183371),P(19.763036845),P(19.763890245),P(19.764743571),P(19.765596824),P(19.766450003),P(19.767303108),P(19.768156140),P(19.769009098),P(19.769861982),
	P(19.770714793),P(19.771567530),P(19.772420194),P(19.773272784),P(19.774125301),P(19.774977744),P(19.775830114),P(19.776682410),P(19.777534633),P(19.778386782),P(19.779238858),P(19.780090861),P(19.780942790),P(19.781794646),P(19.782646428),P(19.783498137),
	P(19.784349773),P(19.785201335),P(19.786052825),P(19.786904240),P(19.787755583),P(19.788606852),P(19.789458048),P(19.790309171),P(19.791160221),P(19.792011197),P(19.792862101),P(19.793712931),P(19.794563688),P(19.795414372),P(19.796264983),P(19.797115520),
	P(19.797965985),P(19.798816377),P(19.799666695),P(19.800516941),P(19.801367113),P(19.802217213),P(19.803067239),P(19.803917193),P(19.804767073),P(19.805616881),P(19.806466615),P(19.807316277),P(19.808165866),P(19.809015382),P(19.809864825),P(19.810714196),
	P(19.811563493),P(19.812412718),P(19.813261870),P(19.814110949),P(19.814959956),P(19.815808889),P(19.816657750),P(19.817506538),P(19.818355254),P(19.819203897),P(19.820052467),P(19.820900964),P(19.821749389),P(19.822597741),P(19.823446021),P(19.824294228),
	P(19.825142362),P(19.825990424),P(19.826838413),P(19.827686330),P(19.828534175),P(19.829381946),P(19.830229646),P(19.831077272),P(19.831924827),P(19.832772309),P(19.833619718),P(19.834467055),P(19.835314320),P(19.836161512),P(19.837008632),P(19.837855680),
	P(19.838702655),P(19.839549558),P(19.840396389),P(19.841243147),P(19.842089834),P(19.842936448),P(19.843782989),P(19.844629459),P(19.845475856),P(19.846322181),P(19.847168434),P(19.848014614),P(19.848860723),P(19.849706759),P(19.850552724),P(19.851398616),
	P(19.852244436),P(19.853090184),P(19.853935860),P(19.854781464),P(19.855626996),P(19.856472456),P(19.857317844),P(19.858163160),P(19.859008404),P(19.859853576),P(19.860698676),P(19.861543705),P(19.862388661),P(19.863233545),P(19.864078358),P(19.864923099),
	P(19.865767768),P(19.866612365),P(19.867456890),P(19.868301343),P(19.869145725),P(19.869990035),P(19.870834273),P(19.871678440),P(19.872522534),P(19.873366557),P(19.874210509),P(19.875054389),P(19.875898197),P(19.876741933),P(19.877585598),P(19.878429191),
	P(19.879272712),P(19.880116162),P(19.880959541),P(19.881802848),P(19.882646083),P(19.883489247),P(19.884332339),P(19.885175360),P(19.886018309),P(19.886861187),P(19.887703994),P(19.888546729),P(19.889389392),P(19.890231985),P(19.891074505),P(19.891916955),
	P(19.892759333),P(19.893601640),P(19.894443875),P(19.895286039),P(19.896128132),P(19.896970154),P(19.897812104),P(19.898653983),P(19.899495791),P(19.900337528),P(19.901179193),P(19.902020788),P(19.902862311),P(19.903703763),P(19.904545143),P(19.905386453),
	P(19.906227692),P(19.907068859),P(19.907909955),P(19.908750981),P(19.909591935),P(19.910432818),P(19.911273630),P(19.912114371),P(19.912955042),P(19.913795641),P(19.914636169),P(19.915476627),P(19.916317013),P(19.917157328),P(19.917997573),P(19.918837747),
	P(19.919677849),P(19.920517881),P(19.921357843),P(19.922197733),P(19.923037552),P(19.923877301),P(19.924716979),P(19.925556586),P(19.926396122),P(19.927235588),P(19.928074983),P(19.928914307),P(19.929753561),P(19.930592744),P(19.931431856),P(19.932270897),
	P(19.933109868),P(19.933948769),P(19.934787598),P(19.935626357),P(19.936465046),P(19.937303664),P(19.938142211),P(19.938980688),P(19.939819095),P(19.940657430),P(19.941495696),P(19.942333891),P(19.943172015),P(19.944010069),P(19.944848053),P(19.945685966),
	P(19.946523809),P(19.947361581),P(19.948199283),P(19.949036915),P(19.949874477),P(19.950711968),P(19.951549388),P(19.952386739),P(19.953224019),P(19.954061229),P(19.954898369),P(19.955735438),P(19.956572437),P(19.957409366),P(19.958246225),P(19.959083014),
	P(19.959919732),P(19.960756381),P(19.961592959),P(19.962429467),P(19.963265905),P(19.964102273),P(19.964938571),P(19.965774799),P(19.966610956),P(19.967447044),P(19.968283062),P(19.969119009),P(19.969954887),P(19.970790695),P(19.971626433),P(19.972462101),
	P(19.973297699),P(19.974133227),P(19.974968685),P(19.975804073),P(19.976639391),P(19.977474640),P(19.978309819),P(19.979144928),P(19.979979967),P(19.980814936),P(19.981649835),P(19.982484665),P(19.983319425),P(19.984154115),P(19.984988736),P(19.985823287),
	P(19.986657768),P(19.987492179),P(19.988326521),P(19.989160793),P(19.989994996),P(19.990829129),P(19.991663192),P(19.992497186),P(19.993331110),P(19.994164964),P(19.994998749),P(19.995832465),P(19.996666111),P(19.997499687),P(19.998333194),P(19.999166632),
	P(20.000000000),P(20.000833299),P(20.001666528),P(20.002499688),P(20.003332778),P(20.004165799),P(20.004998751),P(20.005831633),P(20.006664446),P(20.007497189),P(20.008329864),P(20.009162468),P(20.009995004),P(20.010827471),P(20.011659868),P(20.012492196),
	P(20.013324454),P(20.014156644),P(20.014988764),P(20.015820815),P(20.016652797),P(20.017484710),P(20.018316553),P(20.019148328),P(20.019980033),P(20.020811670),P(20.021643237),P(20.022474735),P(20.023306164),P(20.024137524),P(20.024968815),P(20.025800037),
	P(20.026631190),P(20.027462274),P(20.028293289),P(20.029124235),P(20.029955112),P(20.030785920),P(20.031616660),P(20.032447330),P(20.033277932),P(20.034108464),P(20.034938928),P(20.035769323),P(20.036599649),P(20.037429906),P(20.038260095),P(20.039090215),
	P(20.039920266),P(20.040750248),P(20.041580161),P(20.042410006),P(20.043239782),P(20.044069489),P(20.044899128),P(20.045728698),P(20.046558199),P(20.047387632),P(20.048216996),P(20.049046291),P(20.049875518),P(20.050704676),P(20.051533766),P(20.052362787),
	P(20.053191740),P(20.054020624),P(20.054849439),P(20.055678186),P(20.056506865),P(20.057335475),P(20.058164017),P(20.058992490),P(20.059820895),P(20.060649231),P(20.061477499),P(20.062305698),P(20.063133830),P(20.063961892),P(20.064789887),P(20.065617813),
	P(20.066445671),P(20.067273460),P(20.068101182),P(20.068928835),P(20.069756419),P(20.070583936),P(20.071411384),P(20.072238764),P(20.073066076),P(20.073893319),P(20.074720495),P(20.075547602),P(20.076374641),P(20.077201612),P(20.078028515),P(20.078855350),
	P(20.079682116),P(20.080508815),P(20.081335446),P(20.082162008),P(20.082988502),P(20.083814929),P(20.084641287),P(20.085467578),P(20.086293800),P(20.087119955),P(20.087946041),P(20.088772060),P(20.089598010),P(20.090423893),P(20.091249708),P(20.092075455),
	P(20.092901134),P(20.093726745),P(20.094552289),P(20.095377764),P(20.096203172),P(20.097028512),P(20.097853784),P(20.098678989),P(20.099504125),P(20.100329194),P(20.101154196),P(20.101979129),P(20.102803995),P(20.103628793),P(20.104453523),P(20.105278186),
	P(20.106102781),P(20.106927309),P(20.107751769),P(20.108576161),P(20.109400486),P(20.110224743),P(20.111048932),P(20.111873054),P(20.112697109),P(20.113521096),P(20.114345015),P(20.115168867),P(20.115992651),P(20.116816368),P(20.117640018),P(20.118463600),
	P(20.119287115),P(20.120110562),P(20.120933942),P(20.121757254),P(20.122580499),P(20.123403677),P(20.124226788),P(20.125049831),P(20.125872807),P(20.126695715),P(20.127518556),P(20.128341330),P(20.129164037),P(20.129986676),P(20.130809248),P(20.131631753),
	P(20.132454191),P(20.133276562),P(20.134098865),P(20.134921101),P(20.135743271),P(20.136565372),P(20.137387407),P(20.138209375),P(20.139031276),P(20.139853109),P(20.140674876),P(20.141496575),P(20.142318208),P(20.143139773),P(20.143961271),P(20.144782703),
	P(20.145604067),P(20.146425364),P(20.147246595),P(20.148067758),P(20.148888855),P(20.149709885),P(20.150530847),P(20.151351743),P(20.152172572),P(20.152993334),P(20.153814030),P(20.154634658),P(20.155455220),P(20.156275715),P(20.157096143),P(20.157916504),
	P(20.158736798),P(20.159557026),P(20.160377187),P(20.161197281),P(20.162017309),P(20.162837270),P(20.163657164),P(20.164476991),P(20.165296752),P(20.166116446),P(20.166936074),P(20.167755635),P(20.168575129),P(20.169394557),P(20.170213918),
#undef P
};

/****************************************************************************
 *	GAVO팸
 ****************************************************************************/

/* GAVO팸̃o^tCZWB
 *
 *	double cn[8] = { -0.6000,-0.5350,-0.3300,-0.1850,-0.0950,-0.0410,-0.0142,-0.0037 };
 *	for(i = 0; i < 8; i++) {
 *		mp3r_antialias_table[i][0] = 1.0   / sqrt(1.0 + pow(cn[i], 2)); // cs
 *		mp3r_antialias_table[i][1] = cn[i] / sqrt(1.0 + pow(cn[i], 2)); // ca
 *	}
 */
const short mp3_antialias_table[8][2/*0:cs/1:ca*/] = {
#define P(d)	((short)((d) * (1 << 14)))
	{P( 0.857492926),P(-0.514495755)},
	{P( 0.881741997),P(-0.471731969)},
	{P( 0.949628649),P(-0.313377454)},
	{P( 0.983314592),P(-0.181913200)},
	{P( 0.995517816),P(-0.094574193)},
	{P( 0.999160558),P(-0.040965583)},
	{P( 0.999899195),P(-0.014198569)},
	{P( 0.999993155),P(-0.003699975)},
#undef P
};

/****************************************************************************
 *	IMDCT
 ****************************************************************************/

/* Sin֐̓KpIMDCT𓯎ɍssB(OubNp)
 *
 *	pi = acos(-1);
 *	for(i = 0; i < MP3_SUBBAND_SIZE_2; i++) {
 *		w = sin((2 * i + 1) * pi / (2 * MP3_SUBBAND_SIZE_2)); // Sin֐
 *		for(j = 0; j < MP3_SUBBAND_SIZE; j++){
 *			c = cos(((2 * i + 1 + MP3_SUBBAND_SIZE) * (2 * j + 1) * pi) / (2 * MP3_SUBBAND_SIZE_2)); // IMDCT
 *			mp3_imdct_long_matrix[i][j] = w * c;
 *		}
 *	}
 */
const short mp3_imdct_long_matrix[MP3_SUBBAND_SIZE_2][MP3_SUBBAND_SIZE] = { /* 1.1.14 */
#define P(d)	((short)((d) * (1 << 14)))
	{P( 0.029468831),P(-0.034605587),P(-0.023436680),P( 0.038690869),P( 0.016692417),P(-0.041600549),P(-0.009440963),P( 0.043246217),P( 0.001902651),P(-0.043577871),P( 0.005693473),P( 0.042585434),P(-0.013116603),P(-0.040299059),P( 0.020141192),P( 0.036788218),P(-0.026553801),P(-0.032159586)},
	{P( 0.079459311),P(-0.120590477),P(-0.017037087),P( 0.129409523),P(-0.049950211),P(-0.103553391),P( 0.103553391),P( 0.049950211),P(-0.129409523),P( 0.017037087),P( 0.120590477),P(-0.079459311),P(-0.079459311),P( 0.120590477),P( 0.017037087),P(-0.129409523),P( 0.049950211),P( 0.103553391)},
	{P( 0.116292920),P(-0.214587943),P( 0.065084647),P( 0.159576022),P(-0.199964129),P( 0.009440963),P( 0.191984282),P(-0.171713091),P(-0.046846106),P( 0.211309131),P(-0.131760089),P(-0.099940692),P( 0.216233611),P(-0.082827854),P(-0.146224484),P( 0.206422129),P(-0.028251039),P(-0.182543319)},
	{P( 0.138850486),P(-0.298133220),P( 0.203153894),P( 0.065084647),P(-0.277815933),P( 0.253612699),P(-0.013116603),P(-0.238565950),P( 0.286788218),P(-0.090423978),P(-0.183058092),P( 0.300419594),P(-0.161569108),P(-0.115075127),P( 0.293577871),P(-0.221703571),P(-0.039249983),P( 0.266729302)},
	{P( 0.146446609),P(-0.353553391),P( 0.353553391),P(-0.146446609),P(-0.146446609),P( 0.353553391),P(-0.353553391),P( 0.146446609),P( 0.146446609),P(-0.353553391),P( 0.353553391),P(-0.146446609),P(-0.146446609),P( 0.353553391),P(-0.353553391),P( 0.146446609),P( 0.146446609),P(-0.353553391)},
	{P( 0.138850486),P(-0.366329805),P( 0.461309131),P(-0.389434831),P( 0.176703544),P( 0.099940692),P(-0.340436788),P( 0.457798290),P(-0.409576022),P( 0.213211782),P( 0.060270288),P(-0.311952841),P( 0.450803327),P(-0.426600093),P( 0.248097349),P( 0.020141192),P(-0.281094746),P( 0.440377479)},
	{P( 0.116292920),P(-0.327087277),P( 0.476590573),P(-0.536788218),P( 0.496400111),P(-0.362994354),P( 0.161569108),P( 0.070131672),P(-0.288690869),P( 0.453153894),P(-0.532702936),P( 0.512431744),P(-0.396138824),P( 0.205615658),P( 0.023436680),P(-0.248097349),P( 0.426268439),P(-0.524563462)},
	{P( 0.079459311),P(-0.232962913),P( 0.370590477),P(-0.482962913),P( 0.562422224),P(-0.603553391),P( 0.603553391),P(-0.562422224),P( 0.482962913),P(-0.370590477),P( 0.232962913),P(-0.079459311),P(-0.079459311),P( 0.232962913),P(-0.370590477),P( 0.482962913),P(-0.562422224),P( 0.603553391)},
	{P( 0.029468831),P(-0.088182217),P( 0.146224484),P(-0.203153894),P( 0.258537180),P(-0.311952841),P( 0.362994354),P(-0.411273260),P( 0.456422129),P(-0.498097349),P( 0.535981748),P(-0.569787002),P( 0.599255833),P(-0.624163965),P( 0.644321833),P(-0.659576022),P( 0.669810440),P(-0.674947195)},
	{P(-0.032159586),P( 0.096234003),P(-0.159576022),P( 0.221703571),P(-0.282143822),P( 0.340436788),P(-0.396138824),P( 0.448826005),P(-0.498097349),P( 0.543577871),P(-0.584921438),P( 0.621813399),P(-0.653972985),P( 0.681155441),P(-0.703153894),P( 0.719800920),P(-0.730969827),P( 0.736575612)},
	{P(-0.103553391),P( 0.303603179),P(-0.482962913),P( 0.629409523),P(-0.732962913),P( 0.786566092),P(-0.786566092),P( 0.732962913),P(-0.629409523),P( 0.482962913),P(-0.303603179),P( 0.103553391),P( 0.103553391),P(-0.303603179),P( 0.482962913),P(-0.629409523),P( 0.732962913),P(-0.786566092)},
	{P(-0.182543319),P( 0.513424182),P(-0.748097349),P( 0.842588724),P(-0.779192095),P( 0.569787002),P(-0.253612699),P(-0.110084674),P( 0.453153894),P(-0.711309131),P( 0.836176115),P(-0.804356718),P( 0.621813399),P(-0.322751933),P(-0.036788218),P( 0.389434831),P(-0.669107421),P( 0.823399701)},
	{P(-0.266729302),P( 0.703713007),P(-0.886166595),P( 0.748097349),P(-0.339444350),P(-0.191984282),P( 0.653972985),P(-0.879422333),P( 0.786788218),P(-0.409576022),P(-0.115778147),P( 0.599255833),P(-0.865985135),P( 0.819491154),P(-0.476590573),P(-0.038690869),P( 0.539977982),P(-0.845957267)},
	{P(-0.353553391),P( 0.853553391),P(-0.853553391),P( 0.353553391),P( 0.353553391),P(-0.853553391),P( 0.853553391),P(-0.353553391),P(-0.353553391),P( 0.853553391),P(-0.853553391),P( 0.353553391),P( 0.353553391),P(-0.853553391),P( 0.853553391),P(-0.353553391),P(-0.353553391),P( 0.853553391)},
	{P(-0.440377479),P( 0.945557770),P(-0.644321833),P(-0.206422129),P( 0.881119571),P(-0.804356718),P( 0.041600549),P( 0.756634529),P(-0.909576022),P( 0.286788218),P( 0.580586094),P(-0.952809224),P( 0.512431744),P( 0.364971676),P(-0.931110051),P( 0.703153894),P( 0.124485042),P(-0.845957267)},
	{P(-0.524563462),P( 0.967943659),P(-0.293577871),P(-0.719800920),P( 0.901979899),P(-0.042585434),P(-0.865985135),P( 0.774547698),P( 0.211309131),P(-0.953153894),P( 0.594331352),P( 0.450803327),P(-0.975366790),P( 0.373612307),P( 0.659576022),P(-0.931110051),P( 0.127432200),P( 0.823399701)},
	{P(-0.603553391),P( 0.915975615),P( 0.129409523),P(-0.982962913),P( 0.379409523),P( 0.786566092),P(-0.786566092),P(-0.379409523),P( 0.982962913),P(-0.129409523),P(-0.915975615),P( 0.603553391),P( 0.603553391),P(-0.915975615),P(-0.129409523),P( 0.982962913),P(-0.379409523),P(-0.786566092)},
	{P(-0.674947195),P( 0.792598244),P( 0.536788218),P(-0.886166595),P(-0.382319203),P( 0.952809224),P( 0.216233611),P(-0.990501226),P(-0.043577871),P( 0.998097349),P(-0.130401960),P(-0.975366790),P( 0.300419594),P( 0.923000204),P(-0.461309131),P(-0.842588724),P( 0.608182023),P( 0.736575612)},
	{P(-0.736575612),P( 0.608182023),P( 0.842588724),P(-0.461309131),P(-0.923000204),P( 0.300419594),P( 0.975366790),P(-0.130401960),P(-0.998097349),P(-0.043577871),P( 0.990501226),P( 0.216233611),P(-0.952809224),P(-0.382319203),P( 0.886166595),P( 0.536788218),P(-0.792598244),P(-0.674947195)},
	{P(-0.786566092),P( 0.379409523),P( 0.982962913),P( 0.129409523),P(-0.915975615),P(-0.603553391),P( 0.603553391),P( 0.915975615),P(-0.129409523),P(-0.982962913),P(-0.379409523),P( 0.786566092),P( 0.786566092),P(-0.379409523),P(-0.982962913),P(-0.129409523),P( 0.915975615),P( 0.603553391)},
	{P(-0.823399701),P( 0.127432200),P( 0.931110051),P( 0.659576022),P(-0.373612307),P(-0.975366790),P(-0.450803327),P( 0.594331352),P( 0.953153894),P( 0.211309131),P(-0.774547698),P(-0.865985135),P( 0.042585434),P( 0.901979899),P( 0.719800920),P(-0.293577871),P(-0.967943659),P(-0.524563462)},
	{P(-0.845957267),P(-0.124485042),P( 0.703153894),P( 0.931110051),P( 0.364971676),P(-0.512431744),P(-0.952809224),P(-0.580586094),P( 0.286788218),P( 0.909576022),P( 0.756634529),P(-0.041600549),P(-0.804356718),P(-0.881119571),P(-0.206422129),P( 0.644321833),P( 0.945557770),P( 0.440377479)},
	{P(-0.853553391),P(-0.353553391),P( 0.353553391),P( 0.853553391),P( 0.853553391),P( 0.353553391),P(-0.353553391),P(-0.853553391),P(-0.853553391),P(-0.353553391),P( 0.353553391),P( 0.853553391),P( 0.853553391),P( 0.353553391),P(-0.353553391),P(-0.853553391),P(-0.853553391),P(-0.353553391)},
	{P(-0.845957267),P(-0.539977982),P(-0.038690869),P( 0.476590573),P( 0.819491154),P( 0.865985135),P( 0.599255833),P( 0.115778147),P(-0.409576022),P(-0.786788218),P(-0.879422333),P(-0.653972985),P(-0.191984282),P( 0.339444350),P( 0.748097349),P( 0.886166595),P( 0.703713007),P( 0.266729302)},
	{P(-0.823399701),P(-0.669107421),P(-0.389434831),P(-0.036788218),P( 0.322751933),P( 0.621813399),P( 0.804356718),P( 0.836176115),P( 0.711309131),P( 0.453153894),P( 0.110084674),P(-0.253612699),P(-0.569787002),P(-0.779192095),P(-0.842588724),P(-0.748097349),P(-0.513424182),P(-0.182543319)},
	{P(-0.786566092),P(-0.732962913),P(-0.629409523),P(-0.482962913),P(-0.303603179),P(-0.103553391),P( 0.103553391),P( 0.303603179),P( 0.482962913),P( 0.629409523),P( 0.732962913),P( 0.786566092),P( 0.786566092),P( 0.732962913),P( 0.629409523),P( 0.482962913),P( 0.303603179),P( 0.103553391)},
	{P(-0.736575612),P(-0.730969827),P(-0.719800920),P(-0.703153894),P(-0.681155441),P(-0.653972985),P(-0.621813399),P(-0.584921438),P(-0.543577871),P(-0.498097349),P(-0.448826005),P(-0.396138824),P(-0.340436788),P(-0.282143822),P(-0.221703571),P(-0.159576022),P(-0.096234003),P(-0.032159586)},
	{P(-0.674947195),P(-0.669810440),P(-0.659576022),P(-0.644321833),P(-0.624163965),P(-0.599255833),P(-0.569787002),P(-0.535981748),P(-0.498097349),P(-0.456422129),P(-0.411273260),P(-0.362994354),P(-0.311952841),P(-0.258537180),P(-0.203153894),P(-0.146224484),P(-0.088182217),P(-0.029468831)},
	{P(-0.603553391),P(-0.562422224),P(-0.482962913),P(-0.370590477),P(-0.232962913),P(-0.079459311),P( 0.079459311),P( 0.232962913),P( 0.370590477),P( 0.482962913),P( 0.562422224),P( 0.603553391),P( 0.603553391),P( 0.562422224),P( 0.482962913),P( 0.370590477),P( 0.232962913),P( 0.079459311)},
	{P(-0.524563462),P(-0.426268439),P(-0.248097349),P(-0.023436680),P( 0.205615658),P( 0.396138824),P( 0.512431744),P( 0.532702936),P( 0.453153894),P( 0.288690869),P( 0.070131672),P(-0.161569108),P(-0.362994354),P(-0.496400111),P(-0.536788218),P(-0.476590573),P(-0.327087277),P(-0.116292920)},
	{P(-0.440377479),P(-0.281094746),P(-0.020141192),P( 0.248097349),P( 0.426600093),P( 0.450803327),P( 0.311952841),P( 0.060270288),P(-0.213211782),P(-0.409576022),P(-0.457798290),P(-0.340436788),P(-0.099940692),P( 0.176703544),P( 0.389434831),P( 0.461309131),P( 0.366329805),P( 0.138850486)},
	{P(-0.353553391),P(-0.146446609),P( 0.146446609),P( 0.353553391),P( 0.353553391),P( 0.146446609),P(-0.146446609),P(-0.353553391),P(-0.353553391),P(-0.146446609),P( 0.146446609),P( 0.353553391),P( 0.353553391),P( 0.146446609),P(-0.146446609),P(-0.353553391),P(-0.353553391),P(-0.146446609)},
	{P(-0.266729302),P(-0.039249983),P( 0.221703571),P( 0.293577871),P( 0.115075127),P(-0.161569108),P(-0.300419594),P(-0.183058092),P( 0.090423978),P( 0.286788218),P( 0.238565950),P(-0.013116603),P(-0.253612699),P(-0.277815933),P(-0.065084647),P( 0.203153894),P( 0.298133220),P( 0.138850486)},
	{P(-0.182543319),P( 0.028251039),P( 0.206422129),P( 0.146224484),P(-0.082827854),P(-0.216233611),P(-0.099940692),P( 0.131760089),P( 0.211309131),P( 0.046846106),P(-0.171713091),P(-0.191984282),P( 0.009440963),P( 0.199964129),P( 0.159576022),P(-0.065084647),P(-0.214587943),P(-0.116292920)},
	{P(-0.103553391),P( 0.049950211),P( 0.129409523),P( 0.017037087),P(-0.120590477),P(-0.079459311),P( 0.079459311),P( 0.120590477),P(-0.017037087),P(-0.129409523),P(-0.049950211),P( 0.103553391),P( 0.103553391),P(-0.049950211),P(-0.129409523),P(-0.017037087),P( 0.120590477),P( 0.079459311)},
	{P(-0.032159586),P( 0.026553801),P( 0.036788218),P(-0.020141192),P(-0.040299059),P( 0.013116603),P( 0.042585434),P(-0.005693473),P(-0.043577871),P(-0.001902651),P( 0.043246217),P( 0.009440963),P(-0.041600549),P(-0.016692417),P( 0.038690869),P( 0.023436680),P(-0.034605587),P(-0.029468831)},
#undef P
};

/* Sin֐̓KpIMDCT𓯎ɍssB(V[gubNp)
 *
 *	pi = acos(-1);
 *	for(i = 0; i < MP3_SHORT_IMDCT_SIZE_2; i++) {
 *		w = sin((2 * i + 1) * pi / (2 * MP3_SHORT_IMDCT_SIZE_2)); // Sin֐
 *		for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++){
 *			c = cos(((2 * i + 1 + MP3_SHORT_IMDCT_SIZE) * (2 * j + 1) * pi) / (2 * MP3_SHORT_IMDCT_SIZE_2)); // IMDCT
 *			mp3r_imdct_short_matrix[i][j] = w * c;
 *		}
 *	}
 */
const short mp3_imdct_short_matrix[MP3_SHORT_IMDCT_SIZE_2][MP3_SHORT_IMDCT_SIZE] = { /* 1.1.14 */
#define P(d)	((short)((d) * (1 << 14)))
	{P( 0.079459311),P(-0.120590477),P(-0.017037087),P( 0.129409523),P(-0.049950211),P(-0.103553391)},
	{P( 0.146446609),P(-0.353553391),P( 0.353553391),P(-0.146446609),P(-0.146446609),P( 0.353553391)},
	{P( 0.079459311),P(-0.232962913),P( 0.370590477),P(-0.482962913),P( 0.562422224),P(-0.603553391)},
	{P(-0.103553391),P( 0.303603179),P(-0.482962913),P( 0.629409523),P(-0.732962913),P( 0.786566092)},
	{P(-0.353553391),P( 0.853553391),P(-0.853553391),P( 0.353553391),P( 0.353553391),P(-0.853553391)},
	{P(-0.603553391),P( 0.915975615),P( 0.129409523),P(-0.982962913),P( 0.379409523),P( 0.786566092)},
	{P(-0.786566092),P( 0.379409523),P( 0.982962913),P( 0.129409523),P(-0.915975615),P(-0.603553391)},
	{P(-0.853553391),P(-0.353553391),P( 0.353553391),P( 0.853553391),P( 0.853553391),P( 0.353553391)},
	{P(-0.786566092),P(-0.732962913),P(-0.629409523),P(-0.482962913),P(-0.303603179),P(-0.103553391)},
	{P(-0.603553391),P(-0.562422224),P(-0.482962913),P(-0.370590477),P(-0.232962913),P(-0.079459311)},
	{P(-0.353553391),P(-0.146446609),P( 0.146446609),P( 0.353553391),P( 0.353553391),P( 0.146446609)},
	{P(-0.103553391),P( 0.049950211),P( 0.129409523),P( 0.017037087),P(-0.120590477),P(-0.079459311)},
#undef P
};

/****************************************************************************
 *	Tuoh
 ****************************************************************************/

/* Tuoh(ݍ݉Z)sB
 *
 *	pi = acos(-1);
 *	for(i = 0; i < MP3_SUBBAND_COUNT_2; i++) {
 *		for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
 *			mp3_subband_matrix[i][j] = cos((2 * j + 1) * (i + 16) * pi / MP3_SUBBAND_COUNT_2);
 *		}
 *	}
 */
const short mp3_subband_matrix[MP3_SUBBAND_COUNT_2][MP3_SUBBAND_COUNT] = { /* 1.1.14 */
#define P(d)	((short)( (d) * (1 << 14)))
	{P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781)},
	{P( 0.671558955),P(-0.803207531),P(-0.514102744),P( 0.903989293),P( 0.336889853),P(-0.970031253),P(-0.146730474),P( 0.998795456),P(-0.049067674),P(-0.989176510),P( 0.242980180),P( 0.941544065),P(-0.427555093),P(-0.857728610),P( 0.595699304),P( 0.740951125),P(-0.740951125),P(-0.595699304),P( 0.857728610),P( 0.427555093),P(-0.941544065),P(-0.242980180),P( 0.989176510),P( 0.049067674),P(-0.998795456),P( 0.146730474),P( 0.970031253),P(-0.336889853),P(-0.903989293),P( 0.514102744),P( 0.803207531),P(-0.671558955)},
	{P( 0.634393284),P(-0.881921264),P(-0.290284677),P( 0.995184727),P(-0.098017140),P(-0.956940336),P( 0.471396737),P( 0.773010453),P(-0.773010453),P(-0.471396737),P( 0.956940336),P( 0.098017140),P(-0.995184727),P( 0.290284677),P( 0.881921264),P(-0.634393284),P(-0.634393284),P( 0.881921264),P( 0.290284677),P(-0.995184727),P( 0.098017140),P( 0.956940336),P(-0.471396737),P(-0.773010453),P( 0.773010453),P( 0.471396737),P(-0.956940336),P(-0.098017140),P( 0.995184727),P(-0.290284677),P(-0.881921264),P( 0.634393284)},
	{P( 0.595699304),P(-0.941544065),P(-0.049067674),P( 0.970031253),P(-0.514102744),P(-0.671558955),P( 0.903989293),P( 0.146730474),P(-0.989176510),P( 0.427555093),P( 0.740951125),P(-0.857728610),P(-0.242980180),P( 0.998795456),P(-0.336889853),P(-0.803207531),P( 0.803207531),P( 0.336889853),P(-0.998795456),P( 0.242980180),P( 0.857728610),P(-0.740951125),P(-0.427555093),P( 0.989176510),P(-0.146730474),P(-0.903989293),P( 0.671558955),P( 0.514102744),P(-0.970031253),P( 0.049067674),P( 0.941544065),P(-0.595699304)},
	{P( 0.555570233),P(-0.980785280),P( 0.195090322),P( 0.831469612),P(-0.831469612),P(-0.195090322),P( 0.980785280),P(-0.555570233),P(-0.555570233),P( 0.980785280),P(-0.195090322),P(-0.831469612),P( 0.831469612),P( 0.195090322),P(-0.980785280),P( 0.555570233),P( 0.555570233),P(-0.980785280),P( 0.195090322),P( 0.831469612),P(-0.831469612),P(-0.195090322),P( 0.980785280),P(-0.555570233),P(-0.555570233),P( 0.980785280),P(-0.195090322),P(-0.831469612),P( 0.831469612),P( 0.195090322),P(-0.980785280),P( 0.555570233)},
	{P( 0.514102744),P(-0.998795456),P( 0.427555093),P( 0.595699304),P(-0.989176510),P( 0.336889853),P( 0.671558955),P(-0.970031253),P( 0.242980180),P( 0.740951125),P(-0.941544065),P( 0.146730474),P( 0.803207531),P(-0.903989293),P( 0.049067674),P( 0.857728610),P(-0.857728610),P(-0.049067674),P( 0.903989293),P(-0.803207531),P(-0.146730474),P( 0.941544065),P(-0.740951125),P(-0.242980180),P( 0.970031253),P(-0.671558955),P(-0.336889853),P( 0.989176510),P(-0.595699304),P(-0.427555093),P( 0.998795456),P(-0.514102744)},
	{P( 0.471396737),P(-0.995184727),P( 0.634393284),P( 0.290284677),P(-0.956940336),P( 0.773010453),P( 0.098017140),P(-0.881921264),P( 0.881921264),P(-0.098017140),P(-0.773010453),P( 0.956940336),P(-0.290284677),P(-0.634393284),P( 0.995184727),P(-0.471396737),P(-0.471396737),P( 0.995184727),P(-0.634393284),P(-0.290284677),P( 0.956940336),P(-0.773010453),P(-0.098017140),P( 0.881921264),P(-0.881921264),P( 0.098017140),P( 0.773010453),P(-0.956940336),P( 0.290284677),P( 0.634393284),P(-0.995184727),P( 0.471396737)},
	{P( 0.427555093),P(-0.970031253),P( 0.803207531),P(-0.049067674),P(-0.740951125),P( 0.989176510),P(-0.514102744),P(-0.336889853),P( 0.941544065),P(-0.857728610),P( 0.146730474),P( 0.671558955),P(-0.998795456),P( 0.595699304),P( 0.242980180),P(-0.903989293),P( 0.903989293),P(-0.242980180),P(-0.595699304),P( 0.998795456),P(-0.671558955),P(-0.146730474),P( 0.857728610),P(-0.941544065),P( 0.336889853),P( 0.514102744),P(-0.989176510),P( 0.740951125),P( 0.049067674),P(-0.803207531),P( 0.970031253),P(-0.427555093)},
	{P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432)},
	{P( 0.336889853),P(-0.857728610),P( 0.989176510),P(-0.671558955),P( 0.049067674),P( 0.595699304),P(-0.970031253),P( 0.903989293),P(-0.427555093),P(-0.242980180),P( 0.803207531),P(-0.998795456),P( 0.740951125),P(-0.146730474),P(-0.514102744),P( 0.941544065),P(-0.941544065),P( 0.514102744),P( 0.146730474),P(-0.740951125),P( 0.998795456),P(-0.803207531),P( 0.242980180),P( 0.427555093),P(-0.903989293),P( 0.970031253),P(-0.595699304),P(-0.049067674),P( 0.671558955),P(-0.989176510),P( 0.857728610),P(-0.336889853)},
	{P( 0.290284677),P(-0.773010453),P( 0.995184727),P(-0.881921264),P( 0.471396737),P( 0.098017140),P(-0.634393284),P( 0.956940336),P(-0.956940336),P( 0.634393284),P(-0.098017140),P(-0.471396737),P( 0.881921264),P(-0.995184727),P( 0.773010453),P(-0.290284677),P(-0.290284677),P( 0.773010453),P(-0.995184727),P( 0.881921264),P(-0.471396737),P(-0.098017140),P( 0.634393284),P(-0.956940336),P( 0.956940336),P(-0.634393284),P( 0.098017140),P( 0.471396737),P(-0.881921264),P( 0.995184727),P(-0.773010453),P( 0.290284677)},
	{P( 0.242980180),P(-0.671558955),P( 0.941544065),P(-0.989176510),P( 0.803207531),P(-0.427555093),P(-0.049067674),P( 0.514102744),P(-0.857728610),P( 0.998795456),P(-0.903989293),P( 0.595699304),P(-0.146730474),P(-0.336889853),P( 0.740951125),P(-0.970031253),P( 0.970031253),P(-0.740951125),P( 0.336889853),P( 0.146730474),P(-0.595699304),P( 0.903989293),P(-0.998795456),P( 0.857728610),P(-0.514102744),P( 0.049067674),P( 0.427555093),P(-0.803207531),P( 0.989176510),P(-0.941544065),P( 0.671558955),P(-0.242980180)},
	{P( 0.195090322),P(-0.555570233),P( 0.831469612),P(-0.980785280),P( 0.980785280),P(-0.831469612),P( 0.555570233),P(-0.195090322),P(-0.195090322),P( 0.555570233),P(-0.831469612),P( 0.980785280),P(-0.980785280),P( 0.831469612),P(-0.555570233),P( 0.195090322),P( 0.195090322),P(-0.555570233),P( 0.831469612),P(-0.980785280),P( 0.980785280),P(-0.831469612),P( 0.555570233),P(-0.195090322),P(-0.195090322),P( 0.555570233),P(-0.831469612),P( 0.980785280),P(-0.980785280),P( 0.831469612),P(-0.555570233),P( 0.195090322)},
	{P( 0.146730474),P(-0.427555093),P( 0.671558955),P(-0.857728610),P( 0.970031253),P(-0.998795456),P( 0.941544065),P(-0.803207531),P( 0.595699304),P(-0.336889853),P( 0.049067674),P( 0.242980180),P(-0.514102744),P( 0.740951125),P(-0.903989293),P( 0.989176510),P(-0.989176510),P( 0.903989293),P(-0.740951125),P( 0.514102744),P(-0.242980180),P(-0.049067674),P( 0.336889853),P(-0.595699304),P( 0.803207531),P(-0.941544065),P( 0.998795456),P(-0.970031253),P( 0.857728610),P(-0.671558955),P( 0.427555093),P(-0.146730474)},
	{P( 0.098017140),P(-0.290284677),P( 0.471396737),P(-0.634393284),P( 0.773010453),P(-0.881921264),P( 0.956940336),P(-0.995184727),P( 0.995184727),P(-0.956940336),P( 0.881921264),P(-0.773010453),P( 0.634393284),P(-0.471396737),P( 0.290284677),P(-0.098017140),P(-0.098017140),P( 0.290284677),P(-0.471396737),P( 0.634393284),P(-0.773010453),P( 0.881921264),P(-0.956940336),P( 0.995184727),P(-0.995184727),P( 0.956940336),P(-0.881921264),P( 0.773010453),P(-0.634393284),P( 0.471396737),P(-0.290284677),P( 0.098017140)},
	{P( 0.049067674),P(-0.146730474),P( 0.242980180),P(-0.336889853),P( 0.427555093),P(-0.514102744),P( 0.595699304),P(-0.671558955),P( 0.740951125),P(-0.803207531),P( 0.857728610),P(-0.903989293),P( 0.941544065),P(-0.970031253),P( 0.989176510),P(-0.998795456),P( 0.998795456),P(-0.989176510),P( 0.970031253),P(-0.941544065),P( 0.903989293),P(-0.857728610),P( 0.803207531),P(-0.740951125),P( 0.671558955),P(-0.595699304),P( 0.514102744),P(-0.427555093),P( 0.336889853),P(-0.242980180),P( 0.146730474),P(-0.049067674)},
	{P( 0.000000000),P(-0.000000000),P( 0.000000000),P(-0.000000000),P( 0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P(-0.000000000),P( 0.000000000),P(-0.000000000),P( 0.000000000),P(-0.000000000),P( 0.000000000),P(-0.000000000),P( 0.000000000),P( 0.000000000),P( 0.000000000),P(-0.000000000),P( 0.000000000),P( 0.000000000),P( 0.000000000),P(-0.000000000),P( 0.000000000),P( 0.000000000)},
	{P(-0.049067674),P( 0.146730474),P(-0.242980180),P( 0.336889853),P(-0.427555093),P( 0.514102744),P(-0.595699304),P( 0.671558955),P(-0.740951125),P( 0.803207531),P(-0.857728610),P( 0.903989293),P(-0.941544065),P( 0.970031253),P(-0.989176510),P( 0.998795456),P(-0.998795456),P( 0.989176510),P(-0.970031253),P( 0.941544065),P(-0.903989293),P( 0.857728610),P(-0.803207531),P( 0.740951125),P(-0.671558955),P( 0.595699304),P(-0.514102744),P( 0.427555093),P(-0.336889853),P( 0.242980180),P(-0.146730474),P( 0.049067674)},
	{P(-0.098017140),P( 0.290284677),P(-0.471396737),P( 0.634393284),P(-0.773010453),P( 0.881921264),P(-0.956940336),P( 0.995184727),P(-0.995184727),P( 0.956940336),P(-0.881921264),P( 0.773010453),P(-0.634393284),P( 0.471396737),P(-0.290284677),P( 0.098017140),P( 0.098017140),P(-0.290284677),P( 0.471396737),P(-0.634393284),P( 0.773010453),P(-0.881921264),P( 0.956940336),P(-0.995184727),P( 0.995184727),P(-0.956940336),P( 0.881921264),P(-0.773010453),P( 0.634393284),P(-0.471396737),P( 0.290284677),P(-0.098017140)},
	{P(-0.146730474),P( 0.427555093),P(-0.671558955),P( 0.857728610),P(-0.970031253),P( 0.998795456),P(-0.941544065),P( 0.803207531),P(-0.595699304),P( 0.336889853),P(-0.049067674),P(-0.242980180),P( 0.514102744),P(-0.740951125),P( 0.903989293),P(-0.989176510),P( 0.989176510),P(-0.903989293),P( 0.740951125),P(-0.514102744),P( 0.242980180),P( 0.049067674),P(-0.336889853),P( 0.595699304),P(-0.803207531),P( 0.941544065),P(-0.998795456),P( 0.970031253),P(-0.857728610),P( 0.671558955),P(-0.427555093),P( 0.146730474)},
	{P(-0.195090322),P( 0.555570233),P(-0.831469612),P( 0.980785280),P(-0.980785280),P( 0.831469612),P(-0.555570233),P( 0.195090322),P( 0.195090322),P(-0.555570233),P( 0.831469612),P(-0.980785280),P( 0.980785280),P(-0.831469612),P( 0.555570233),P(-0.195090322),P(-0.195090322),P( 0.555570233),P(-0.831469612),P( 0.980785280),P(-0.980785280),P( 0.831469612),P(-0.555570233),P( 0.195090322),P( 0.195090322),P(-0.555570233),P( 0.831469612),P(-0.980785280),P( 0.980785280),P(-0.831469612),P( 0.555570233),P(-0.195090322)},
	{P(-0.242980180),P( 0.671558955),P(-0.941544065),P( 0.989176510),P(-0.803207531),P( 0.427555093),P( 0.049067674),P(-0.514102744),P( 0.857728610),P(-0.998795456),P( 0.903989293),P(-0.595699304),P( 0.146730474),P( 0.336889853),P(-0.740951125),P( 0.970031253),P(-0.970031253),P( 0.740951125),P(-0.336889853),P(-0.146730474),P( 0.595699304),P(-0.903989293),P( 0.998795456),P(-0.857728610),P( 0.514102744),P(-0.049067674),P(-0.427555093),P( 0.803207531),P(-0.989176510),P( 0.941544065),P(-0.671558955),P( 0.242980180)},
	{P(-0.290284677),P( 0.773010453),P(-0.995184727),P( 0.881921264),P(-0.471396737),P(-0.098017140),P( 0.634393284),P(-0.956940336),P( 0.956940336),P(-0.634393284),P( 0.098017140),P( 0.471396737),P(-0.881921264),P( 0.995184727),P(-0.773010453),P( 0.290284677),P( 0.290284677),P(-0.773010453),P( 0.995184727),P(-0.881921264),P( 0.471396737),P( 0.098017140),P(-0.634393284),P( 0.956940336),P(-0.956940336),P( 0.634393284),P(-0.098017140),P(-0.471396737),P( 0.881921264),P(-0.995184727),P( 0.773010453),P(-0.290284677)},
	{P(-0.336889853),P( 0.857728610),P(-0.989176510),P( 0.671558955),P(-0.049067674),P(-0.595699304),P( 0.970031253),P(-0.903989293),P( 0.427555093),P( 0.242980180),P(-0.803207531),P( 0.998795456),P(-0.740951125),P( 0.146730474),P( 0.514102744),P(-0.941544065),P( 0.941544065),P(-0.514102744),P(-0.146730474),P( 0.740951125),P(-0.998795456),P( 0.803207531),P(-0.242980180),P(-0.427555093),P( 0.903989293),P(-0.970031253),P( 0.595699304),P( 0.049067674),P(-0.671558955),P( 0.989176510),P(-0.857728610),P( 0.336889853)},
	{P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432),P(-0.382683432),P( 0.923879533),P(-0.923879533),P( 0.382683432),P( 0.382683432),P(-0.923879533),P( 0.923879533),P(-0.382683432)},
	{P(-0.427555093),P( 0.970031253),P(-0.803207531),P( 0.049067674),P( 0.740951125),P(-0.989176510),P( 0.514102744),P( 0.336889853),P(-0.941544065),P( 0.857728610),P(-0.146730474),P(-0.671558955),P( 0.998795456),P(-0.595699304),P(-0.242980180),P( 0.903989293),P(-0.903989293),P( 0.242980180),P( 0.595699304),P(-0.998795456),P( 0.671558955),P( 0.146730474),P(-0.857728610),P( 0.941544065),P(-0.336889853),P(-0.514102744),P( 0.989176510),P(-0.740951125),P(-0.049067674),P( 0.803207531),P(-0.970031253),P( 0.427555093)},
	{P(-0.471396737),P( 0.995184727),P(-0.634393284),P(-0.290284677),P( 0.956940336),P(-0.773010453),P(-0.098017140),P( 0.881921264),P(-0.881921264),P( 0.098017140),P( 0.773010453),P(-0.956940336),P( 0.290284677),P( 0.634393284),P(-0.995184727),P( 0.471396737),P( 0.471396737),P(-0.995184727),P( 0.634393284),P( 0.290284677),P(-0.956940336),P( 0.773010453),P( 0.098017140),P(-0.881921264),P( 0.881921264),P(-0.098017140),P(-0.773010453),P( 0.956940336),P(-0.290284677),P(-0.634393284),P( 0.995184727),P(-0.471396737)},
	{P(-0.514102744),P( 0.998795456),P(-0.427555093),P(-0.595699304),P( 0.989176510),P(-0.336889853),P(-0.671558955),P( 0.970031253),P(-0.242980180),P(-0.740951125),P( 0.941544065),P(-0.146730474),P(-0.803207531),P( 0.903989293),P(-0.049067674),P(-0.857728610),P( 0.857728610),P( 0.049067674),P(-0.903989293),P( 0.803207531),P( 0.146730474),P(-0.941544065),P( 0.740951125),P( 0.242980180),P(-0.970031253),P( 0.671558955),P( 0.336889853),P(-0.989176510),P( 0.595699304),P( 0.427555093),P(-0.998795456),P( 0.514102744)},
	{P(-0.555570233),P( 0.980785280),P(-0.195090322),P(-0.831469612),P( 0.831469612),P( 0.195090322),P(-0.980785280),P( 0.555570233),P( 0.555570233),P(-0.980785280),P( 0.195090322),P( 0.831469612),P(-0.831469612),P(-0.195090322),P( 0.980785280),P(-0.555570233),P(-0.555570233),P( 0.980785280),P(-0.195090322),P(-0.831469612),P( 0.831469612),P( 0.195090322),P(-0.980785280),P( 0.555570233),P( 0.555570233),P(-0.980785280),P( 0.195090322),P( 0.831469612),P(-0.831469612),P(-0.195090322),P( 0.980785280),P(-0.555570233)},
	{P(-0.595699304),P( 0.941544065),P( 0.049067674),P(-0.970031253),P( 0.514102744),P( 0.671558955),P(-0.903989293),P(-0.146730474),P( 0.989176510),P(-0.427555093),P(-0.740951125),P( 0.857728610),P( 0.242980180),P(-0.998795456),P( 0.336889853),P( 0.803207531),P(-0.803207531),P(-0.336889853),P( 0.998795456),P(-0.242980180),P(-0.857728610),P( 0.740951125),P( 0.427555093),P(-0.989176510),P( 0.146730474),P( 0.903989293),P(-0.671558955),P(-0.514102744),P( 0.970031253),P(-0.049067674),P(-0.941544065),P( 0.595699304)},
	{P(-0.634393284),P( 0.881921264),P( 0.290284677),P(-0.995184727),P( 0.098017140),P( 0.956940336),P(-0.471396737),P(-0.773010453),P( 0.773010453),P( 0.471396737),P(-0.956940336),P(-0.098017140),P( 0.995184727),P(-0.290284677),P(-0.881921264),P( 0.634393284),P( 0.634393284),P(-0.881921264),P(-0.290284677),P( 0.995184727),P(-0.098017140),P(-0.956940336),P( 0.471396737),P( 0.773010453),P(-0.773010453),P(-0.471396737),P( 0.956940336),P( 0.098017140),P(-0.995184727),P( 0.290284677),P( 0.881921264),P(-0.634393284)},
	{P(-0.671558955),P( 0.803207531),P( 0.514102744),P(-0.903989293),P(-0.336889853),P( 0.970031253),P( 0.146730474),P(-0.998795456),P( 0.049067674),P( 0.989176510),P(-0.242980180),P(-0.941544065),P( 0.427555093),P( 0.857728610),P(-0.595699304),P(-0.740951125),P( 0.740951125),P( 0.595699304),P(-0.857728610),P(-0.427555093),P( 0.941544065),P( 0.242980180),P(-0.989176510),P(-0.049067674),P( 0.998795456),P(-0.146730474),P(-0.970031253),P( 0.336889853),P( 0.903989293),P(-0.514102744),P(-0.803207531),P( 0.671558955)},
	{P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781),P(-0.707106781),P( 0.707106781),P( 0.707106781),P(-0.707106781)},
	{P(-0.740951125),P( 0.595699304),P( 0.857728610),P(-0.427555093),P(-0.941544065),P( 0.242980180),P( 0.989176510),P(-0.049067674),P(-0.998795456),P(-0.146730474),P( 0.970031253),P( 0.336889853),P(-0.903989293),P(-0.514102744),P( 0.803207531),P( 0.671558955),P(-0.671558955),P(-0.803207531),P( 0.514102744),P( 0.903989293),P(-0.336889853),P(-0.970031253),P( 0.146730474),P( 0.998795456),P( 0.049067674),P(-0.989176510),P(-0.242980180),P( 0.941544065),P( 0.427555093),P(-0.857728610),P(-0.595699304),P( 0.740951125)},
	{P(-0.773010453),P( 0.471396737),P( 0.956940336),P(-0.098017140),P(-0.995184727),P(-0.290284677),P( 0.881921264),P( 0.634393284),P(-0.634393284),P(-0.881921264),P( 0.290284677),P( 0.995184727),P( 0.098017140),P(-0.956940336),P(-0.471396737),P( 0.773010453),P( 0.773010453),P(-0.471396737),P(-0.956940336),P( 0.098017140),P( 0.995184727),P( 0.290284677),P(-0.881921264),P(-0.634393284),P( 0.634393284),P( 0.881921264),P(-0.290284677),P(-0.995184727),P(-0.098017140),P( 0.956940336),P( 0.471396737),P(-0.773010453)},
	{P(-0.803207531),P( 0.336889853),P( 0.998795456),P( 0.242980180),P(-0.857728610),P(-0.740951125),P( 0.427555093),P( 0.989176510),P( 0.146730474),P(-0.903989293),P(-0.671558955),P( 0.514102744),P( 0.970031253),P( 0.049067674),P(-0.941544065),P(-0.595699304),P( 0.595699304),P( 0.941544065),P(-0.049067674),P(-0.970031253),P(-0.514102744),P( 0.671558955),P( 0.903989293),P(-0.146730474),P(-0.989176510),P(-0.427555093),P( 0.740951125),P( 0.857728610),P(-0.242980180),P(-0.998795456),P(-0.336889853),P( 0.803207531)},
	{P(-0.831469612),P( 0.195090322),P( 0.980785280),P( 0.555570233),P(-0.555570233),P(-0.980785280),P(-0.195090322),P( 0.831469612),P( 0.831469612),P(-0.195090322),P(-0.980785280),P(-0.555570233),P( 0.555570233),P( 0.980785280),P( 0.195090322),P(-0.831469612),P(-0.831469612),P( 0.195090322),P( 0.980785280),P( 0.555570233),P(-0.555570233),P(-0.980785280),P(-0.195090322),P( 0.831469612),P( 0.831469612),P(-0.195090322),P(-0.980785280),P(-0.555570233),P( 0.555570233),P( 0.980785280),P( 0.195090322),P(-0.831469612)},
	{P(-0.857728610),P( 0.049067674),P( 0.903989293),P( 0.803207531),P(-0.146730474),P(-0.941544065),P(-0.740951125),P( 0.242980180),P( 0.970031253),P( 0.671558955),P(-0.336889853),P(-0.989176510),P(-0.595699304),P( 0.427555093),P( 0.998795456),P( 0.514102744),P(-0.514102744),P(-0.998795456),P(-0.427555093),P( 0.595699304),P( 0.989176510),P( 0.336889853),P(-0.671558955),P(-0.970031253),P(-0.242980180),P( 0.740951125),P( 0.941544065),P( 0.146730474),P(-0.803207531),P(-0.903989293),P(-0.049067674),P( 0.857728610)},
	{P(-0.881921264),P(-0.098017140),P( 0.773010453),P( 0.956940336),P( 0.290284677),P(-0.634393284),P(-0.995184727),P(-0.471396737),P( 0.471396737),P( 0.995184727),P( 0.634393284),P(-0.290284677),P(-0.956940336),P(-0.773010453),P( 0.098017140),P( 0.881921264),P( 0.881921264),P( 0.098017140),P(-0.773010453),P(-0.956940336),P(-0.290284677),P( 0.634393284),P( 0.995184727),P( 0.471396737),P(-0.471396737),P(-0.995184727),P(-0.634393284),P( 0.290284677),P( 0.956940336),P( 0.773010453),P(-0.098017140),P(-0.881921264)},
	{P(-0.903989293),P(-0.242980180),P( 0.595699304),P( 0.998795456),P( 0.671558955),P(-0.146730474),P(-0.857728610),P(-0.941544065),P(-0.336889853),P( 0.514102744),P( 0.989176510),P( 0.740951125),P(-0.049067674),P(-0.803207531),P(-0.970031253),P(-0.427555093),P( 0.427555093),P( 0.970031253),P( 0.803207531),P( 0.049067674),P(-0.740951125),P(-0.989176510),P(-0.514102744),P( 0.336889853),P( 0.941544065),P( 0.857728610),P( 0.146730474),P(-0.671558955),P(-0.998795456),P(-0.595699304),P( 0.242980180),P( 0.903989293)},
	{P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533),P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533),P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533),P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533)},
	{P(-0.941544065),P(-0.514102744),P( 0.146730474),P( 0.740951125),P( 0.998795456),P( 0.803207531),P( 0.242980180),P(-0.427555093),P(-0.903989293),P(-0.970031253),P(-0.595699304),P( 0.049067674),P( 0.671558955),P( 0.989176510),P( 0.857728610),P( 0.336889853),P(-0.336889853),P(-0.857728610),P(-0.989176510),P(-0.671558955),P(-0.049067674),P( 0.595699304),P( 0.970031253),P( 0.903989293),P( 0.427555093),P(-0.242980180),P(-0.803207531),P(-0.998795456),P(-0.740951125),P(-0.146730474),P( 0.514102744),P( 0.941544065)},
	{P(-0.956940336),P(-0.634393284),P(-0.098017140),P( 0.471396737),P( 0.881921264),P( 0.995184727),P( 0.773010453),P( 0.290284677),P(-0.290284677),P(-0.773010453),P(-0.995184727),P(-0.881921264),P(-0.471396737),P( 0.098017140),P( 0.634393284),P( 0.956940336),P( 0.956940336),P( 0.634393284),P( 0.098017140),P(-0.471396737),P(-0.881921264),P(-0.995184727),P(-0.773010453),P(-0.290284677),P( 0.290284677),P( 0.773010453),P( 0.995184727),P( 0.881921264),P( 0.471396737),P(-0.098017140),P(-0.634393284),P(-0.956940336)},
	{P(-0.970031253),P(-0.740951125),P(-0.336889853),P( 0.146730474),P( 0.595699304),P( 0.903989293),P( 0.998795456),P( 0.857728610),P( 0.514102744),P( 0.049067674),P(-0.427555093),P(-0.803207531),P(-0.989176510),P(-0.941544065),P(-0.671558955),P(-0.242980180),P( 0.242980180),P( 0.671558955),P( 0.941544065),P( 0.989176510),P( 0.803207531),P( 0.427555093),P(-0.049067674),P(-0.514102744),P(-0.857728610),P(-0.998795456),P(-0.903989293),P(-0.595699304),P(-0.146730474),P( 0.336889853),P( 0.740951125),P( 0.970031253)},
	{P(-0.980785280),P(-0.831469612),P(-0.555570233),P(-0.195090322),P( 0.195090322),P( 0.555570233),P( 0.831469612),P( 0.980785280),P( 0.980785280),P( 0.831469612),P( 0.555570233),P( 0.195090322),P(-0.195090322),P(-0.555570233),P(-0.831469612),P(-0.980785280),P(-0.980785280),P(-0.831469612),P(-0.555570233),P(-0.195090322),P( 0.195090322),P( 0.555570233),P( 0.831469612),P( 0.980785280),P( 0.980785280),P( 0.831469612),P( 0.555570233),P( 0.195090322),P(-0.195090322),P(-0.555570233),P(-0.831469612),P(-0.980785280)},
	{P(-0.989176510),P(-0.903989293),P(-0.740951125),P(-0.514102744),P(-0.242980180),P( 0.049067674),P( 0.336889853),P( 0.595699304),P( 0.803207531),P( 0.941544065),P( 0.998795456),P( 0.970031253),P( 0.857728610),P( 0.671558955),P( 0.427555093),P( 0.146730474),P(-0.146730474),P(-0.427555093),P(-0.671558955),P(-0.857728610),P(-0.970031253),P(-0.998795456),P(-0.941544065),P(-0.803207531),P(-0.595699304),P(-0.336889853),P(-0.049067674),P( 0.242980180),P( 0.514102744),P( 0.740951125),P( 0.903989293),P( 0.989176510)},
	{P(-0.995184727),P(-0.956940336),P(-0.881921264),P(-0.773010453),P(-0.634393284),P(-0.471396737),P(-0.290284677),P(-0.098017140),P( 0.098017140),P( 0.290284677),P( 0.471396737),P( 0.634393284),P( 0.773010453),P( 0.881921264),P( 0.956940336),P( 0.995184727),P( 0.995184727),P( 0.956940336),P( 0.881921264),P( 0.773010453),P( 0.634393284),P( 0.471396737),P( 0.290284677),P( 0.098017140),P(-0.098017140),P(-0.290284677),P(-0.471396737),P(-0.634393284),P(-0.773010453),P(-0.881921264),P(-0.956940336),P(-0.995184727)},
	{P(-0.998795456),P(-0.989176510),P(-0.970031253),P(-0.941544065),P(-0.903989293),P(-0.857728610),P(-0.803207531),P(-0.740951125),P(-0.671558955),P(-0.595699304),P(-0.514102744),P(-0.427555093),P(-0.336889853),P(-0.242980180),P(-0.146730474),P(-0.049067674),P( 0.049067674),P( 0.146730474),P( 0.242980180),P( 0.336889853),P( 0.427555093),P( 0.514102744),P( 0.595699304),P( 0.671558955),P( 0.740951125),P( 0.803207531),P( 0.857728610),P( 0.903989293),P( 0.941544065),P( 0.970031253),P( 0.989176510),P( 0.998795456)},
	{P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000),P(-1.000000000)},
	{P(-0.998795456),P(-0.989176510),P(-0.970031253),P(-0.941544065),P(-0.903989293),P(-0.857728610),P(-0.803207531),P(-0.740951125),P(-0.671558955),P(-0.595699304),P(-0.514102744),P(-0.427555093),P(-0.336889853),P(-0.242980180),P(-0.146730474),P(-0.049067674),P( 0.049067674),P( 0.146730474),P( 0.242980180),P( 0.336889853),P( 0.427555093),P( 0.514102744),P( 0.595699304),P( 0.671558955),P( 0.740951125),P( 0.803207531),P( 0.857728610),P( 0.903989293),P( 0.941544065),P( 0.970031253),P( 0.989176510),P( 0.998795456)},
	{P(-0.995184727),P(-0.956940336),P(-0.881921264),P(-0.773010453),P(-0.634393284),P(-0.471396737),P(-0.290284677),P(-0.098017140),P( 0.098017140),P( 0.290284677),P( 0.471396737),P( 0.634393284),P( 0.773010453),P( 0.881921264),P( 0.956940336),P( 0.995184727),P( 0.995184727),P( 0.956940336),P( 0.881921264),P( 0.773010453),P( 0.634393284),P( 0.471396737),P( 0.290284677),P( 0.098017140),P(-0.098017140),P(-0.290284677),P(-0.471396737),P(-0.634393284),P(-0.773010453),P(-0.881921264),P(-0.956940336),P(-0.995184727)},
	{P(-0.989176510),P(-0.903989293),P(-0.740951125),P(-0.514102744),P(-0.242980180),P( 0.049067674),P( 0.336889853),P( 0.595699304),P( 0.803207531),P( 0.941544065),P( 0.998795456),P( 0.970031253),P( 0.857728610),P( 0.671558955),P( 0.427555093),P( 0.146730474),P(-0.146730474),P(-0.427555093),P(-0.671558955),P(-0.857728610),P(-0.970031253),P(-0.998795456),P(-0.941544065),P(-0.803207531),P(-0.595699304),P(-0.336889853),P(-0.049067674),P( 0.242980180),P( 0.514102744),P( 0.740951125),P( 0.903989293),P( 0.989176510)},
	{P(-0.980785280),P(-0.831469612),P(-0.555570233),P(-0.195090322),P( 0.195090322),P( 0.555570233),P( 0.831469612),P( 0.980785280),P( 0.980785280),P( 0.831469612),P( 0.555570233),P( 0.195090322),P(-0.195090322),P(-0.555570233),P(-0.831469612),P(-0.980785280),P(-0.980785280),P(-0.831469612),P(-0.555570233),P(-0.195090322),P( 0.195090322),P( 0.555570233),P( 0.831469612),P( 0.980785280),P( 0.980785280),P( 0.831469612),P( 0.555570233),P( 0.195090322),P(-0.195090322),P(-0.555570233),P(-0.831469612),P(-0.980785280)},
	{P(-0.970031253),P(-0.740951125),P(-0.336889853),P( 0.146730474),P( 0.595699304),P( 0.903989293),P( 0.998795456),P( 0.857728610),P( 0.514102744),P( 0.049067674),P(-0.427555093),P(-0.803207531),P(-0.989176510),P(-0.941544065),P(-0.671558955),P(-0.242980180),P( 0.242980180),P( 0.671558955),P( 0.941544065),P( 0.989176510),P( 0.803207531),P( 0.427555093),P(-0.049067674),P(-0.514102744),P(-0.857728610),P(-0.998795456),P(-0.903989293),P(-0.595699304),P(-0.146730474),P( 0.336889853),P( 0.740951125),P( 0.970031253)},
	{P(-0.956940336),P(-0.634393284),P(-0.098017140),P( 0.471396737),P( 0.881921264),P( 0.995184727),P( 0.773010453),P( 0.290284677),P(-0.290284677),P(-0.773010453),P(-0.995184727),P(-0.881921264),P(-0.471396737),P( 0.098017140),P( 0.634393284),P( 0.956940336),P( 0.956940336),P( 0.634393284),P( 0.098017140),P(-0.471396737),P(-0.881921264),P(-0.995184727),P(-0.773010453),P(-0.290284677),P( 0.290284677),P( 0.773010453),P( 0.995184727),P( 0.881921264),P( 0.471396737),P(-0.098017140),P(-0.634393284),P(-0.956940336)},
	{P(-0.941544065),P(-0.514102744),P( 0.146730474),P( 0.740951125),P( 0.998795456),P( 0.803207531),P( 0.242980180),P(-0.427555093),P(-0.903989293),P(-0.970031253),P(-0.595699304),P( 0.049067674),P( 0.671558955),P( 0.989176510),P( 0.857728610),P( 0.336889853),P(-0.336889853),P(-0.857728610),P(-0.989176510),P(-0.671558955),P(-0.049067674),P( 0.595699304),P( 0.970031253),P( 0.903989293),P( 0.427555093),P(-0.242980180),P(-0.803207531),P(-0.998795456),P(-0.740951125),P(-0.146730474),P( 0.514102744),P( 0.941544065)},
	{P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533),P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533),P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533),P(-0.923879533),P(-0.382683432),P( 0.382683432),P( 0.923879533),P( 0.923879533),P( 0.382683432),P(-0.382683432),P(-0.923879533)},
	{P(-0.903989293),P(-0.242980180),P( 0.595699304),P( 0.998795456),P( 0.671558955),P(-0.146730474),P(-0.857728610),P(-0.941544065),P(-0.336889853),P( 0.514102744),P( 0.989176510),P( 0.740951125),P(-0.049067674),P(-0.803207531),P(-0.970031253),P(-0.427555093),P( 0.427555093),P( 0.970031253),P( 0.803207531),P( 0.049067674),P(-0.740951125),P(-0.989176510),P(-0.514102744),P( 0.336889853),P( 0.941544065),P( 0.857728610),P( 0.146730474),P(-0.671558955),P(-0.998795456),P(-0.595699304),P( 0.242980180),P( 0.903989293)},
	{P(-0.881921264),P(-0.098017140),P( 0.773010453),P( 0.956940336),P( 0.290284677),P(-0.634393284),P(-0.995184727),P(-0.471396737),P( 0.471396737),P( 0.995184727),P( 0.634393284),P(-0.290284677),P(-0.956940336),P(-0.773010453),P( 0.098017140),P( 0.881921264),P( 0.881921264),P( 0.098017140),P(-0.773010453),P(-0.956940336),P(-0.290284677),P( 0.634393284),P( 0.995184727),P( 0.471396737),P(-0.471396737),P(-0.995184727),P(-0.634393284),P( 0.290284677),P( 0.956940336),P( 0.773010453),P(-0.098017140),P(-0.881921264)},
	{P(-0.857728610),P( 0.049067674),P( 0.903989293),P( 0.803207531),P(-0.146730474),P(-0.941544065),P(-0.740951125),P( 0.242980180),P( 0.970031253),P( 0.671558955),P(-0.336889853),P(-0.989176510),P(-0.595699304),P( 0.427555093),P( 0.998795456),P( 0.514102744),P(-0.514102744),P(-0.998795456),P(-0.427555093),P( 0.595699304),P( 0.989176510),P( 0.336889853),P(-0.671558955),P(-0.970031253),P(-0.242980180),P( 0.740951125),P( 0.941544065),P( 0.146730474),P(-0.803207531),P(-0.903989293),P(-0.049067674),P( 0.857728610)},
	{P(-0.831469612),P( 0.195090322),P( 0.980785280),P( 0.555570233),P(-0.555570233),P(-0.980785280),P(-0.195090322),P( 0.831469612),P( 0.831469612),P(-0.195090322),P(-0.980785280),P(-0.555570233),P( 0.555570233),P( 0.980785280),P( 0.195090322),P(-0.831469612),P(-0.831469612),P( 0.195090322),P( 0.980785280),P( 0.555570233),P(-0.555570233),P(-0.980785280),P(-0.195090322),P( 0.831469612),P( 0.831469612),P(-0.195090322),P(-0.980785280),P(-0.555570233),P( 0.555570233),P( 0.980785280),P( 0.195090322),P(-0.831469612)},
	{P(-0.803207531),P( 0.336889853),P( 0.998795456),P( 0.242980180),P(-0.857728610),P(-0.740951125),P( 0.427555093),P( 0.989176510),P( 0.146730474),P(-0.903989293),P(-0.671558955),P( 0.514102744),P( 0.970031253),P( 0.049067674),P(-0.941544065),P(-0.595699304),P( 0.595699304),P( 0.941544065),P(-0.049067674),P(-0.970031253),P(-0.514102744),P( 0.671558955),P( 0.903989293),P(-0.146730474),P(-0.989176510),P(-0.427555093),P( 0.740951125),P( 0.857728610),P(-0.242980180),P(-0.998795456),P(-0.336889853),P( 0.803207531)},
	{P(-0.773010453),P( 0.471396737),P( 0.956940336),P(-0.098017140),P(-0.995184727),P(-0.290284677),P( 0.881921264),P( 0.634393284),P(-0.634393284),P(-0.881921264),P( 0.290284677),P( 0.995184727),P( 0.098017140),P(-0.956940336),P(-0.471396737),P( 0.773010453),P( 0.773010453),P(-0.471396737),P(-0.956940336),P( 0.098017140),P( 0.995184727),P( 0.290284677),P(-0.881921264),P(-0.634393284),P( 0.634393284),P( 0.881921264),P(-0.290284677),P(-0.995184727),P(-0.098017140),P( 0.956940336),P( 0.471396737),P(-0.773010453)},
	{P(-0.740951125),P( 0.595699304),P( 0.857728610),P(-0.427555093),P(-0.941544065),P( 0.242980180),P( 0.989176510),P(-0.049067674),P(-0.998795456),P(-0.146730474),P( 0.970031253),P( 0.336889853),P(-0.903989293),P(-0.514102744),P( 0.803207531),P( 0.671558955),P(-0.671558955),P(-0.803207531),P( 0.514102744),P( 0.903989293),P(-0.336889853),P(-0.970031253),P( 0.146730474),P( 0.998795456),P( 0.049067674),P(-0.989176510),P(-0.242980180),P( 0.941544065),P( 0.427555093),P(-0.857728610),P(-0.595699304),P( 0.740951125)},
#undef P
};

/* |tF[YtB^[oNW\B(MP3dl)
 * ̂߂ɓ]uĂ܂B
 */
const short mp3_polyphase_filter[MP3_SUBBAND_COUNT][16] = { /* 1.1.14 */
#define P(d)	((short)( (d) * (1 << 14)))
#define M(d)	((short)(-(d) * (1 << 14)))
	{P( 0.000000000),P(-0.000442505),M(-0.003250122),M( 0.007003784),P( 0.031082153),P(-0.078628540),M(-0.100311279),M( 0.572036743),P( 1.144989014),P( 0.572036743),M(-0.100311279),M(-0.078628540),P( 0.031082153),P( 0.007003784),M(-0.003250122),M(-0.000442505)},
	{P(-0.000015259),P(-0.000473022),M(-0.003326416),M( 0.007919312),P( 0.030517578),P(-0.084182739),M(-0.090927124),M( 0.600219727),P( 1.144287109),P( 0.543823242),M(-0.108856201),M(-0.073059082),P( 0.031478882),P( 0.006118774),M(-0.003173828),M(-0.000396729)},
	{P(-0.000015259),P(-0.000534058),M(-0.003387451),M( 0.008865356),P( 0.029785156),P(-0.089706421),M(-0.080688477),M( 0.628295898),P( 1.142211914),P( 0.515609741),M(-0.116577148),M(-0.067520142),P( 0.031738281),P( 0.005294800),M(-0.003082275),M(-0.000366211)},
	{P(-0.000015259),P(-0.000579834),M(-0.003433228),M( 0.009841919),P( 0.028884888),P(-0.095169067),M(-0.069595337),M( 0.656219482),P( 1.138763428),P( 0.487472534),M(-0.123474121),M(-0.061996460),P( 0.031845093),P( 0.004486084),M(-0.002990723),M(-0.000320435)},
	{P(-0.000015259),P(-0.000625610),M(-0.003463745),M( 0.010848999),P( 0.027801514),P(-0.100540161),M(-0.057617187),M( 0.683914185),P( 1.133926392),P( 0.459472656),M(-0.129577637),M(-0.056533813),P( 0.031814575),P( 0.003723145),M(-0.002899170),M(-0.000289917)},
	{P(-0.000015259),P(-0.000686646),M(-0.003479004),M( 0.011886597),P( 0.026535034),P(-0.105819702),M(-0.044784546),M( 0.711318970),P( 1.127746582),P( 0.431655884),M(-0.134887695),M(-0.051132202),P( 0.031661987),P( 0.003005981),M(-0.002792358),M(-0.000259399)},
	{P(-0.000015259),P(-0.000747681),M(-0.003479004),M( 0.012939453),P( 0.025085449),P(-0.110946655),M(-0.031082153),M( 0.738372803),P( 1.120223999),P( 0.404083252),M(-0.139450073),M(-0.045837402),P( 0.031387329),P( 0.002334595),M(-0.002685547),M(-0.000244141)},
	{P(-0.000030518),P(-0.000808716),M(-0.003463745),M( 0.014022827),P( 0.023422241),P(-0.115921021),M(-0.016510010),M( 0.765029907),P( 1.111373901),P( 0.376800537),M(-0.143264771),M(-0.040634155),P( 0.031005859),P( 0.001693726),M(-0.002578735),M(-0.000213623)},
	{P(-0.000030518),P(-0.000885010),M(-0.003417969),M( 0.015121460),P( 0.021575928),P(-0.120697021),M(-0.001068115),M( 0.791213989),P( 1.101211548),P( 0.349868774),M(-0.146362305),M(-0.035552979),P( 0.030532837),P( 0.001098633),M(-0.002456665),M(-0.000198364)},
	{P(-0.000030518),P(-0.000961304),M(-0.003372192),M( 0.016235352),P( 0.019531250),P(-0.125259399),M( 0.015228271),M( 0.816864014),P( 1.089782715),P( 0.323318481),M(-0.148773193),M(-0.030609131),P( 0.029937744),P( 0.000549316),M(-0.002349854),M(-0.000167847)},
	{P(-0.000030518),P(-0.001037598),M(-0.003280640),M( 0.017349243),P( 0.017257690),P(-0.129562378),M( 0.032379150),M( 0.841949463),P( 1.077117920),P( 0.297210693),M(-0.150497437),M(-0.025817871),P( 0.029281616),P( 0.000030518),M(-0.002243042),M(-0.000152588)},
	{P(-0.000045776),P(-0.001113892),M(-0.003173828),M( 0.018463135),P( 0.014801025),P(-0.133590698),M( 0.050354004),M( 0.866363525),P( 1.063217163),P( 0.271591187),M(-0.151596069),M(-0.021179199),P( 0.028533936),P(-0.000442505),M(-0.002120972),M(-0.000137329)},
	{P(-0.000045776),P(-0.001205444),M(-0.003051758),M( 0.019577026),P( 0.012115479),P(-0.137298584),M( 0.069168091),M( 0.890090942),P( 1.048156738),P( 0.246505737),M(-0.152069092),M(-0.016708374),P( 0.027725220),P(-0.000869751),M(-0.002014160),M(-0.000122070)},
	{P(-0.000061035),P(-0.001296997),M(-0.002883911),M( 0.020690918),P( 0.009231567),P(-0.140670776),M( 0.088775635),M( 0.913055420),P( 1.031936646),P( 0.221984863),M(-0.151962280),M(-0.012420654),P( 0.026840210),P(-0.001266479),M(-0.001907349),M(-0.000106812)},
	{P(-0.000061035),P(-0.001388550),M(-0.002700806),M( 0.021789551),P( 0.006134033),P(-0.143676758),M( 0.109161377),M( 0.935195923),P( 1.014617920),P( 0.198059082),M(-0.151306152),M(-0.008316040),P( 0.025909424),P(-0.001617432),M(-0.001785278),M(-0.000106812)},
	{P(-0.000076294),P(-0.001480103),M(-0.002487183),M( 0.022857666),P( 0.002822876),P(-0.146255493),M( 0.130310059),M( 0.956481934),P( 0.996246338),P( 0.174789429),M(-0.150115967),M(-0.004394531),P( 0.024932861),P(-0.001937866),M(-0.001693726),M(-0.000091553)},
	{P(-0.000076294),P(-0.001586914),M(-0.002227783),M( 0.023910522),P(-0.000686646),P(-0.148422241),M( 0.152206421),M( 0.976852417),P( 0.976852417),P( 0.152206421),M(-0.148422241),M(-0.000686646),P( 0.023910522),P(-0.002227783),M(-0.001586914),M(-0.000076294)},
	{P(-0.000091553),P(-0.001693726),M(-0.001937866),M( 0.024932861),P(-0.004394531),P(-0.150115967),M( 0.174789429),M( 0.996246338),P( 0.956481934),P( 0.130310059),M(-0.146255493),M( 0.002822876),P( 0.022857666),P(-0.002487183),M(-0.001480103),M(-0.000076294)},
	{P(-0.000106812),P(-0.001785278),M(-0.001617432),M( 0.025909424),P(-0.008316040),P(-0.151306152),M( 0.198059082),M( 1.014617920),P( 0.935195923),P( 0.109161377),M(-0.143676758),M( 0.006134033),P( 0.021789551),P(-0.002700806),M(-0.001388550),M(-0.000061035)},
	{P(-0.000106812),P(-0.001907349),M(-0.001266479),M( 0.026840210),P(-0.012420654),P(-0.151962280),M( 0.221984863),M( 1.031936646),P( 0.913055420),P( 0.088775635),M(-0.140670776),M( 0.009231567),P( 0.020690918),P(-0.002883911),M(-0.001296997),M(-0.000061035)},
	{P(-0.000122070),P(-0.002014160),M(-0.000869751),M( 0.027725220),P(-0.016708374),P(-0.152069092),M( 0.246505737),M( 1.048156738),P( 0.890090942),P( 0.069168091),M(-0.137298584),M( 0.012115479),P( 0.019577026),P(-0.003051758),M(-0.001205444),M(-0.000045776)},
	{P(-0.000137329),P(-0.002120972),M(-0.000442505),M( 0.028533936),P(-0.021179199),P(-0.151596069),M( 0.271591187),M( 1.063217163),P( 0.866363525),P( 0.050354004),M(-0.133590698),M( 0.014801025),P( 0.018463135),P(-0.003173828),M(-0.001113892),M(-0.000045776)},
	{P(-0.000152588),P(-0.002243042),M( 0.000030518),M( 0.029281616),P(-0.025817871),P(-0.150497437),M( 0.297210693),M( 1.077117920),P( 0.841949463),P( 0.032379150),M(-0.129562378),M( 0.017257690),P( 0.017349243),P(-0.003280640),M(-0.001037598),M(-0.000030518)},
	{P(-0.000167847),P(-0.002349854),M( 0.000549316),M( 0.029937744),P(-0.030609131),P(-0.148773193),M( 0.323318481),M( 1.089782715),P( 0.816864014),P( 0.015228271),M(-0.125259399),M( 0.019531250),P( 0.016235352),P(-0.003372192),M(-0.000961304),M(-0.000030518)},
	{P(-0.000198364),P(-0.002456665),M( 0.001098633),M( 0.030532837),P(-0.035552979),P(-0.146362305),M( 0.349868774),M( 1.101211548),P( 0.791213989),P(-0.001068115),M(-0.120697021),M( 0.021575928),P( 0.015121460),P(-0.003417969),M(-0.000885010),M(-0.000030518)},
	{P(-0.000213623),P(-0.002578735),M( 0.001693726),M( 0.031005859),P(-0.040634155),P(-0.143264771),M( 0.376800537),M( 1.111373901),P( 0.765029907),P(-0.016510010),M(-0.115921021),M( 0.023422241),P( 0.014022827),P(-0.003463745),M(-0.000808716),M(-0.000030518)},
	{P(-0.000244141),P(-0.002685547),M( 0.002334595),M( 0.031387329),P(-0.045837402),P(-0.139450073),M( 0.404083252),M( 1.120223999),P( 0.738372803),P(-0.031082153),M(-0.110946655),M( 0.025085449),P( 0.012939453),P(-0.003479004),M(-0.000747681),M(-0.000015259)},
	{P(-0.000259399),P(-0.002792358),M( 0.003005981),M( 0.031661987),P(-0.051132202),P(-0.134887695),M( 0.431655884),M( 1.127746582),P( 0.711318970),P(-0.044784546),M(-0.105819702),M( 0.026535034),P( 0.011886597),P(-0.003479004),M(-0.000686646),M(-0.000015259)},
	{P(-0.000289917),P(-0.002899170),M( 0.003723145),M( 0.031814575),P(-0.056533813),P(-0.129577637),M( 0.459472656),M( 1.133926392),P( 0.683914185),P(-0.057617187),M(-0.100540161),M( 0.027801514),P( 0.010848999),P(-0.003463745),M(-0.000625610),M(-0.000015259)},
	{P(-0.000320435),P(-0.002990723),M( 0.004486084),M( 0.031845093),P(-0.061996460),P(-0.123474121),M( 0.487472534),M( 1.138763428),P( 0.656219482),P(-0.069595337),M(-0.095169067),M( 0.028884888),P( 0.009841919),P(-0.003433228),M(-0.000579834),M(-0.000015259)},
	{P(-0.000366211),P(-0.003082275),M( 0.005294800),M( 0.031738281),P(-0.067520142),P(-0.116577148),M( 0.515609741),M( 1.142211914),P( 0.628295898),P(-0.080688477),M(-0.089706421),M( 0.029785156),P( 0.008865356),P(-0.003387451),M(-0.000534058),M(-0.000015259)},
	{P(-0.000396729),P(-0.003173828),M( 0.006118774),M( 0.031478882),P(-0.073059082),P(-0.108856201),M( 0.543823242),M( 1.144287109),P( 0.600219727),P(-0.090927124),M(-0.084182739),M( 0.030517578),P( 0.007919312),P(-0.003326416),M(-0.000473022),M(-0.000015259)},
#undef P
#undef M
};

/* =MP3{44.1KHz/48KHz/32KHz} => o=P/ECE{16KHz} TvO[gϊpe[u */
								     /* 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 */
static const unsigned char mp3_sampling_frequency_convert_table0[] = {  0, 2, 5, 8,11,13,16,19,22,24,27,30             };
static const unsigned char mp3_sampling_frequency_convert_table1[] = {  0, 3, 6, 9,12,15,18,21,24,27,30                };
static const unsigned char mp3_sampling_frequency_convert_table2[] = {  0, 2, 4, 6, 8,10,12,14,16,18,20,22,24,26,28,30 };
const MP3SAMPLINGFREQUENCYCONVERTTABLE mp3_sampling_frequency_convert_table[3/*0:44.1KHz/1:48KHz/2:32KHz*/] = {
	{ mp3_sampling_frequency_convert_table0, 12, 16538 },	/* MP3FRAMEHEADER.sampling_frequency=0(44.1KHz) */
	{ mp3_sampling_frequency_convert_table1, 11, 16500 },	/* MP3FRAMEHEADER.sampling_frequency=1(48  KHz) */
	{ mp3_sampling_frequency_convert_table2, 16, 16000 },	/* MP3FRAMEHEADER.sampling_frequency=2(32  KHz) */
};

