/*	
 *	clipm69i.h
 *
 *	P/ECE M6809 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_M69I_H__
#define __CLIP_M69I_H__

/*
 *	M6809RAp̃}N`܂B
 *	}NPāȂ̃}NƏՓ˂鋰ꂪ̂ŁA
 *	M6809RA\[Xt@Ĉ݃CN[hĂB
 */

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	M6809\̃oANZX̊ȗ\L
 */
/*===== WX^ =====*/
#define CC		(m6809->cc)
#define DP		(m6809->dp)
#define D		(m6809->d)
#define X		(m6809->x)
#define Y		(m6809->y)
#define U		(m6809->u)
#define S		(m6809->s)
#define PC		(m6809->pc)
/*=====  =====*/
#define PENDING		(m6809->pending)
#define WAIT		(m6809->wait)
#define CYCLE		(m6809->cycle)
/*===== O֐ =====*/
#define READ(a)		    ((m6809->read )(m6809, (unsigned short)(a)))
#define WRITE(a, n)	do { (m6809->write)(m6809, (unsigned short)(a), (unsigned char)(n)); } while(0)

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	16rbgWX^̏/8rbgANZX
 *
 *	* G~[VzXg(S1C33,Pentium,etc)̏Ȃ̂ŁALittleEndianłB
 */
#define LO(rr)		(*(((unsigned char*)&(rr)) + 0))				/* LittleEndian */
#define HI(rr)		(*(((unsigned char*)&(rr)) + 1))				/* LittleEndian */
#define A		HI(D)
#define B		LO(D)

/*
 *	16rbgANZX
 *
 *	* G~[V^[Qbg(M6809)̏Ȃ̂ŁABigEndianłB
 */
#define READW(a)	(READ(a) << 8 | READ((a) + 1))					/* BigEndian */
#define WRITEW(a, nn)	do { WRITE(a, HI(nn)); WRITE((a) + 1, LO(nn)); } while(0)	/* BigEndian */

/*
 *	PUSH/PULL
 *
 *	* G~[V^[Qbg(M6809)̏Ȃ̂ŁABigEndianłB
 *	* 6800/1/3̓|XgfNgEvCNgłA6809͋tłB
 *	  8080/Z80ƓAvfNgE|XgCNgłB
 */
#define PUSH(sp, r)	do { (sp)--; WRITE((sp), (r)); } while(0)
#define PULL(sp, r)	do { (r) = READ((sp)); (sp)++; } while(0)
#define PUSHW(sp, rr)	do { PUSH((sp), LO(rr)); PUSH((sp), HI(rr)); } while(0)		/* BigEndian */
#define PULLW(sp, rr)	do { PULL((sp), HI(rr)); PULL((sp), LO(rr)); } while(0)		/* BigEndian */

/*
 *	CXgNVtFb`/s
 */
#define FETCH(n)	do {		\
	(n) = READ(PC++);		\
	M6809TRACE("%02x ", (n));	\
} while(0)
#define FETCHW(nn)	do {		\
	int hi, lo;			\
	FETCH(hi);			\
	FETCH(lo);			\
	(nn) = hi << 8 | lo;		\
} while(0)
#define EXEC()		do {							\
	M6809TRACE((op->name ? "[%s]" : ""), &m6809_op_name_table[op->name]);	\
	op->proc(m6809, code, arg);						\
	CYCLE -= op->cycle;							\
} while(0)

/****************************************************************************
 *
 ****************************************************************************/

/* N,ZZbgorZbgAVNAAȊO͕ێ܂B!!V͏ɃNA܂!! */
#define TEST(n)		do { CC = (CC & ~0xe) | ((( n) >>  4) & 8) | (!( n) << 2); } while(0)
#define TESTW(nn)	do { CC = (CC & ~0xe) | (((nn) >> 12) & 8) | (!(nn) << 2); } while(0)

#define ADD(a, b)	m6809_ADD(m6809, a, b)
int m6809_ADD(M6809* m6809, int a, int b);
#define ADC(a, b)	m6809_ADC(m6809, a, b)
int m6809_ADC(M6809* m6809, int a, int b);
#define SUB(a, b)	m6809_SUB(m6809, a, b)
int m6809_SUB(M6809* m6809, int a, int b);
#define SBC(a, b)	m6809_SBC(m6809, a, b)
int m6809_SBC(M6809* m6809, int a, int b);

#define ADDW(a, b)	m6809_ADDW(m6809, a, b)
int m6809_ADDW(M6809* m6809, int a, int b);
#define SUBW(a, b)	m6809_SUBW(m6809, a, b)
int m6809_SUBW(M6809* m6809, int a, int b);

#define AND(a, b)	m6809_AND(m6809, a, b)
int m6809_AND(M6809* m6809, int a, int b);
#define OR(a, b)	m6809_OR(m6809, a, b)
int m6809_OR(M6809* m6809, int a, int b);
#define EOR(a, b)	m6809_EOR(m6809, a, b)
int m6809_EOR(M6809* m6809, int a, int b);

#define INC(a)		m6809_INC(m6809, a)
int m6809_INC(M6809* m6809, int a);
#define DEC(a)		m6809_DEC(m6809, a)
int m6809_DEC(M6809* m6809, int a);

#define COM(a)		m6809_COM(m6809, a)
int m6809_COM(M6809* m6809, int a);
#define NEG(a)		m6809_NEG(m6809, a)
int m6809_NEG(M6809* m6809, int a);
#define TST(a)		m6809_TST(m6809, a)
void m6809_TST(M6809* m6809, int a);

#define ROL(a)		m6809_ROL(m6809, a)
int m6809_ROL(M6809* m6809, int a);
#define ROR(a)		m6809_ROR(m6809, a)
int m6809_ROR(M6809* m6809, int a);
#define ASL(a)		m6809_ASL(m6809, a)
int m6809_ASL(M6809* m6809, int a);
#define ASR(a)		m6809_ASR(m6809, a)
int m6809_ASR(M6809* m6809, int a);
#define LSR(a)		m6809_LSR(m6809, a)
int m6809_LSR(M6809* m6809, int a);

#endif /*__CLIP_M69I_H__*/
