/*	
 *	clipdct.h
 *
 *	URTCϊ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Mon Oct 20 04:14:00 JST 2003 Naoyuki Sawa
 *	- VK쐬B
 */
#ifndef __CLIP_DCT_H__
#define __CLIP_DCT_H__

/****************************************************************************
 *	DCT_REAL
 ****************************************************************************/

typedef struct _DCT_REAL {
	int N;		/*  */
	double* v;	/* GAXZ[tpobt@ */
	double* T[2];	/* ϊs(0:FDCT/1:IDCT) */
} DCT_REAL;

/* DCT_HALF\̂쐬܂B
 * [in]
 *	N		B
 *			lw肷ƁAu₷DCTvI܂B
 *			u₷DCTv́AKϊł͂܂񂪁AWg1{ƂȂ܂B
 * [out]
 *	߂l		DCT_HALF\́B
 */
DCT_REAL* dct_real_new(int N);

/* DCT_HALF\̂J܂B
 * [in]
 *	dct		DCT_HALF\́B
 */
void dct_real_free(DCT_REAL* dct);

/* DCTs܂B
 * [in]
 *	dct		DCT_HALF\́B
 *	src		̓f[^B(ԗ̈)
 *	dst		o̓obt@B(g̈)
 * [note]
 *	* srcdstɓobt@wł܂B(GAXZ[t)
 *	  Asrcdstɕʂ̃obt@w肵ꍇɊrׂāAxቺ܂B
 */
void fdct_real(DCT_REAL* dct, const double* src, double* dst);

/* tDCTs܂B
 * [in]
 *	dct		DCT_HALF\́B
 *	src		̓f[^B(g̈)
 *	dst		o̓obt@B(ԗ̈)
 * [note]
 *	* srcdstɓobt@wł܂B(GAXZ[t)
 *	  Asrcdstɕʂ̃obt@w肵ꍇɊrׂāAxቺ܂B
 */
void idct_real(DCT_REAL* dct, const double* src, double* dst);

/****************************************************************************
 *	DCT_HALF
 ****************************************************************************/

typedef struct _DCT_HALF {
	int N;		/*  */
	short* v;	/* GAXZ[tpobt@ */
	short* T[2];	/* ϊs(0:FDCT/1:IDCT) */
} DCT_HALF;

/* DCT_HALF\̂쐬܂B
 * [in]
 *	N		B
 *			lw肷ƁAu₷DCTvI܂B
 *			u₷DCTv́AKϊł͂܂񂪁AWg1{ƂȂ܂B
 * [out]
 *	߂l		DCT_HALF\́B
 */
DCT_HALF* dct_half_new(int N);

/* DCT_HALF\̂J܂B
 * [in]
 *	dct		DCT_HALF\́B
 */
void dct_half_free(DCT_HALF* dct);

/* DCTs܂B
 * [in]
 *	dct		DCT_HALF\́B
 *	src		̓f[^B(ԗ̈)
 *	dst		o̓obt@B(g̈)
 * [note]
 *	* srcdstɓobt@wł܂B(GAXZ[t)
 *	  Asrcdstɕʂ̃obt@w肵ꍇɊrׂāAxቺ܂B
 */
void fdct_half(DCT_HALF* dct, const short* src, short* dst);

/* tDCTs܂B
 * [in]
 *	dct		DCT_HALF\́B
 *	src		̓f[^B(g̈)
 *	dst		o̓obt@B(ԗ̈)
 * [note]
 *	* srcdstɓobt@wł܂B(GAXZ[t)
 *	  Asrcdstɕʂ̃obt@w肵ꍇɊrׂāAxቺ܂B
 */
void idct_half(DCT_HALF* dct, const short* src, short* dst);

#endif /*__CLIP_DCT_H__*/
