/*	
 *	clipmp3r.c
 *
 *	P/ECE MP3 Driver (TEST PROGRAM)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Tue Nov 05 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬Jn
 */
#include <clip.h>

/****************************************************************************
 *	tʎq
 ****************************************************************************/

/* TODO:
 * * XP[t@N^ATuubNQCAXP[t@N^XP[lĂ܂B
 *   ۂMP3t@Cł́ATuubNQCƃXP[t@N^XP[͂ق100%[Ȃ̂ŁAΉȂĂƎv܂B
 *   XP[t@N^͌̃̕XP[t@N^oh()ɐݒ肳Ă邱Ƃ悤łB
 *   lȂƍ̉ʂ炸AႩႩmCY̌ɂȂ܂B
 *   
 *   XP[t@N^Ή܂B
 *
 * * ŃfR[_ł́AXP[t@N^gaine[uɑgݍނƂɂȂƎv܂B
 *	gain = pow(2.0, (granule->global_gain - 210) / 4.0 - scalefactor / 2.0);
 *	                                                   ~~~~~~~~~~~~~ǉ
 *   XP[t@N^͍ő4rbg(0`15)Ȃ̂ŁAgaine[u int[256][16] = 16KB ɂȂ肻łB
 *   
 *   XP[t@N^͍ŏIIȒl pow(1.0/2.0, scalefactor-1) łĂ邾Ȃ̂ŁA
 *   łł͉EVtgőpł܂Be[u𑝂₷Kv͂܂B
 */

/* * MP3dlɒ߂ꂽAtʎq̌vZ͎̒ʂłB
 *
 *	xr  is ~ |is|^(1/3) ~ 2^(Gain-Scale)
 *
 *	is: tʎqւ̓̓f[^
 *	xr: tʎq̏o͌
 *
 *   A
 *
 *	Gain   (GlobalGain-210)/4 - SubblockGain
 *	Scale  ((ScalefactorScale+1)~(Scalefactor+Preemphasis)) / 2
 *
 *   SubblockGainAScalefactorScaleAPreemphais̏ȗ0Ɖ肷ƁA
 *
 *	Gain   (GlobalGain-210) / 4
 *	Scale  Scalefactor / 2
 *
 *   ܂Ƃ߂ƁAZł͎̂悤ɏł܂B
 *
 *	xr  is ~ |is|^(1/3) ~ 2^((GlobalGain-210)/4 - Scalefactor/2)
 *	    is ~ |is|^(1/3) ~ 2^((GlobalGain-210)/4)  2^(Scalefactor/2)
 *	    is ~ |is|^(1/3) ~ 2^((GlobalGain-210)/4) >> (Scalefactor/2)
 *	            ~~~~~~~~~~    ~~~~~~~~~~~~~~~~~~~~~~
 *	            e[u          e[u      
 */

void
mp3r_requantize_long(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, int count)
{
	int i, index;
	double gain, d;
	const short* sfb_index;
	const short* sfb_scale;

	/* XP[t@N^oh̏B */
	sfb_index = &mp3_scalefactor_band_index_table[frame->sampling_frequency][0/*LongBlock*/][1/*̃oh̊JnCfNX*/];
	sfb_scale = scale->long_block;
	index = 0;

	/* OubÑXP[t@N^[oh0`21 */
	gain = pow(2.0, (granule->global_gain - 210) / 4.0);
	for(i = 0; i < count; i++) {
		/* g1TvtʎqB */
		d = *in++;
		d = d * pow(fabs(d), 1.0 / 3.0);
		d = d * gain;
		d = d * pow(1.0 / 2.0, *sfb_scale / 2.0);
		*out++ = d;

		/* ̃XP[t@N^oh̊JnCfNXɓBAgpXP[֐i߂܂B */
		index++;
		if(index == *sfb_index) {
			sfb_index++;
			sfb_scale++;
		}
	}
}

void
mp3r_requantize_short(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/)
{
	int i, j, k, index;
	double gain, d;
	const short* sfb_index;
	const short (*sfb_scale)[MP3_SUBBLOCK_COUNT];
	const short* reorder;

	/* XP[t@N^oh̏B */
	sfb_index = &mp3_scalefactor_band_index_table[frame->sampling_frequency][1/*ShortBlock*/][1/*̃oh̊JnCfNX*/];
	sfb_scale = scale->short_block;
	index = 0;

	/* TvёւṕAǂݍݑCfNXe[u擾B */
	reorder = mp3_reorder_read_index_table[frame->sampling_frequency];

	gain = pow(2.0, (granule->global_gain - 210) / 4.0);
	for(i = 0; i < MP3_SUBBAND_COUNT; i++) {
		for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
			/* g1AԎ3Tv(=3TuubN)tʎqB
			 * ̌AV[gubNIMDCT (g6~Ԏ1)~Ԏ3 PʂƂď̂ŁA
			 *  [g32][Ԏ3][g6] ̏ɕёւĂ܂B
			 */
			for(k = 0; k < MP3_SUBBLOCK_COUNT; k++) {
				d = in[*reorder++];
				d = d * pow(fabs(d), 1.0 / 3.0);
				d = d * gain;
				d = d * pow(1.0 / 2.0, (*sfb_scale)[k] / 2.0);
				*out = d;
				out += MP3_SHORT_IMDCT_SIZE;
			}
			out -= MP3_SUBBAND_SIZE - 1;

			/* ̃XP[t@N^oh̊JnCfNXɓBAgpXP[֐i߂܂B */
			index++;
			if(index == *sfb_index) {
				sfb_index++;
				sfb_scale++;
			}
		}
		out += MP3_SUBBAND_SIZE - MP3_SHORT_IMDCT_SIZE;
	}
}

//~bNXubN𐶐GR[_܂݂Ȃ炵̂ŁAƂ肠KvȂB
//void
//mp3r_requantize_mixed(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/)
//{
//	double gain, pow1_3;
//	const short* reorder;
//	int i, j, k;
//	double d;
//
//	/* OubÑXP[t@N^[oh0`7 */
//	gain = pow(2.0, (granule->global_gain - 210) / 4.0);
//	for(i = 0; i < 36/*Long/Short̋E*/; i++) {
//		d = *in++;
//		pow1_3 = pow(fabs(d), 1.0 / 3.0);
//		d = d * pow1_3;
//		d = d * gain;
//		*out++ = d;
//	}
//
//	/* V[gubÑXP[t@N^[oh3`12 */
//	reorder = &mp3_reorder_read_index_table[frame->sampling_frequency][36/*Long/Short̋E*/];
//	for(/* no job */; i < MP3_GRANULE_SIZE; i += MP3_SUBBAND_SIZE) {
//		for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
//			for(k = 0; k < MP3_SUBBLOCK_COUNT; k++) {
//				d = in[*reorder++];
//				pow1_3 = pow(fabs(d), 1.0 / 3.0);
//				d = d * pow1_3;
//				d = d * gain;
//				*out = d;
//				out += MP3_SHORT_IMDCT_SIZE;
//			}
//			out -= MP3_SUBBAND_SIZE - 1;
//		}
//		out += MP3_SUBBAND_SIZE - MP3_SHORT_IMDCT_SIZE;
//	}
//}

/****************************************************************************
 *	GAVO팸
 ****************************************************************************/

/* * ͂Ă܂BႦ΁ALӂȃTuoh3̏ꍇA
 *
 *	{͂Ȃ΂Ȃ
 *	+-------------+
 *	|             |
 *	|#31(all zero)|
 *	|             |
 *	+-------------+
 *	| .           |
 *	| . (all zero)|
 *	| .           |
 *	+-------------+
 *	|             |
 *	|# 3(all zero)|
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 2          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 1          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 0          |
 *	|             |
 *	+-------------+
 *
 *   {́ATuoh#2#3Ԃ̃o^tCZsȂ΂܂B
 *   A݂̎ł́AŌ̃o^tCZsĂ܂B
 *
 *	͂ȂĂ
 *	+-------------+
 *	|             |
 *	|#31(  S~  )|
 *	|             |
 *	+-------------+
 *	| .           |
 *	| . (  S~  )|
 *	| .           |
 *	+-------------+
 *	|             |
 *	|# 3(  S~  )|
 *	|             |
 *	+-------------+
 *	|             |
 *	|# 2          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 1          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 0          |
 *	|             |
 *	+-------------+
 *
 *   ȂȂATuoh#3`31ɑ΂Ă͋tʎqł̏o͂sĂ炸AS~Ă邩łB
 *   Tuoh#2#3Ԃ̃o^tCẐ݁A#3all zeroƌȂēʏ邱Ƃł܂B
 *
 *	ǈāi̗pj
 *	+-------------+
 *	|             |
 *	|#31(  S~  )|
 *	|             |
 *	+-------------+
 *	| .           |
 *	| . (  S~  )|
 *	| .           |
 *	+-------------+
 *	|             |
 *	|# 3(  S~  )|
 *	|             |
 *	+-------------+  |#3all zeroƌȂēʏ
 *	|             |<-+
 *	|# 2          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 1          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 0          |
 *	|             |
 *	+-------------+
 *
 *   A͂͂܂łB
 *   Lӂȃf[^̂΂񍂉̕Ȃ̂ŁAĂĂ܂e͂ȂƔfłB
 */

static double mp3r_antialias_table[8][2/*0:cs/1:ca*/];
static void
mp3r_antialias_init()
{
	static const double cn[8] = { -0.6000,-0.5350,-0.3300,-0.1850,-0.0950,-0.0410,-0.0142,-0.0037 };
	int i;

	{ static int init_ok; if(init_ok) return; init_ok = 1; }

	for(i = 0; i < 8; i++) {
		mp3r_antialias_table[i][0/*cs*/] = 1.0   / sqrt(1.0 + pow(cn[i], 2));
		mp3r_antialias_table[i][1/*ca*/] = cn[i] / sqrt(1.0 + pow(cn[i], 2));
	}
}

void
mp3r_antialias(double* in_out, int subband_count)
{
	int i;
	double a, b, cs, ca;
	double *pa, *pb;
	const double* table;

	mp3r_antialias_init();

	table = &mp3r_antialias_table[0][0];
	while(--subband_count > 0) {
		in_out += MP3_SUBBAND_SIZE;
		pa = in_out;
		pb = in_out;
		for(i = 0; i < 8; i++) {
			a = *--pa;
			b = *  pb;
			cs = *table++;
			ca = *table++;
			*pa   = a * cs - b * ca;
			*pb++ = b * cs + a * ca;
		}
		table -= 2 * 8;
	}
}

/****************************************************************************
 *	IMDCT
 ****************************************************************************/

/* TODO:
 * {́AMP3GRANULEINFO.block_type=0/1/3 ɂāAOubNSin֐ωׂłB
 * AԂ񂠂܂蒮ɉeȂȋĈŁADx͒ႢłB
 * e[uǉ block_type ɂĐ؂ւ邾Ȃ̂ŁAԂȂ͂łB
 */

static double mp3r_imdct_long_matrix[MP3_SUBBAND_SIZE_2][MP3_SUBBAND_SIZE];
static void
mp3r_imdct_long_init()
{
	int i, j;
	double pi, w, c;

	{ static int init_ok; if(init_ok) return; init_ok = 1; }

	pi = acos(-1);
	for(i = 0; i < MP3_SUBBAND_SIZE_2; i++) {
		w = sin((2 * i + 1) * pi / (2 * MP3_SUBBAND_SIZE_2)); // Sin֐
		for(j = 0; j < MP3_SUBBAND_SIZE; j++){
			c = cos(((2 * i + 1 + MP3_SUBBAND_SIZE) * (2 * j + 1) * pi) / (2 * MP3_SUBBAND_SIZE_2)); // IMDCT
			mp3r_imdct_long_matrix[i][j] = w * c;
		}
	}
}

void
mp3r_imdct_long(const double* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, double* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, int subband_count)
{
	int i, j, k;
	const double* m;
	double sum;

	mp3r_imdct_long_init();

	k = 0;

	/* BigValue/Count1̈ */
	while(k < subband_count) {
		m = &mp3r_imdct_long_matrix[0][0];

		/* uÕOj[̌㔼vƁũ݂Oj[̑OvďóB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_SIZE; j++) {
				sum += *in++ * *m++;
			}
			sum += *save++;
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;
			out += MP3_SUBBAND_COUNT;
			in  -= MP3_SUBBAND_SIZE;
		}

		out  -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;

		/* ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_SIZE; j++) {
				sum += *in++ * *m++;
			}
			*save++ = sum;
			in -= MP3_SUBBAND_SIZE;
		}

		in += MP3_SUBBAND_SIZE;

		k++;
	}

	/* rzerö */
	while(k < MP3_SUBBAND_COUNT) {
		/* uÕOj[̌㔼vƁũ݂Oj[̑OvďóB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = *save++;
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;
			out += MP3_SUBBAND_COUNT;
		}

		out  -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;

		/* ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			*save++ = 0;
		}

		k++;
	}
}

static double mp3r_imdct_short_matrix[MP3_SHORT_IMDCT_SIZE_2][MP3_SHORT_IMDCT_SIZE];
static void
mp3r_imdct_short_init()
{
	int i, j;
	double pi, w, c;

	{ static int init_ok; if(init_ok) return; init_ok = 1; }

	pi = acos(-1);
	for(i = 0; i < MP3_SHORT_IMDCT_SIZE_2; i++) {
		w = sin((2 * i + 1) * pi / (2 * MP3_SHORT_IMDCT_SIZE_2)); // Sin֐
		for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++){
			c = cos(((2 * i + 1 + MP3_SHORT_IMDCT_SIZE) * (2 * j + 1) * pi) / (2 * MP3_SHORT_IMDCT_SIZE_2)); // IMDCT
			mp3r_imdct_short_matrix[i][j] = w * c;
		}
	}
}

void
mp3r_imdct_short(const double* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, double* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/)
{
#if 0	/*******************************************************************/
	/* fɎᑬ                                            */

	int i, j, k, l;
	const double* m;
	double sum, buf[MP3_SUBBAND_SIZE_2], *pbuf;

	mp3r_imdct_short_init();

	for(k = 0; k < MP3_SUBBAND_COUNT; k++) {
		/* 000000 ------ ------ ------ ------ 000000     */
		/* ------ ?????? ?????? ------ ------ ------ i=0 */
		/* ------ ------ ?????? ?????? ------ ------ i=1 */
		/* ------ ------ ------ ?????? ?????? ------ i=2 */
		/* |=saveƑďo=| |====saveɕۑ====| ~ MP3_SUBBAND_COUNT */
		memset(buf, 0, sizeof buf);
		pbuf = buf + MP3_SHORT_IMDCT_SIZE;
		for(i = 0; i < MP3_SUBBLOCK_COUNT; i++) {
			m = &mp3r_imdct_short_matrix[0][0];
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE_2; j++) {
				sum = 0;
				for(l = 0; l < MP3_SHORT_IMDCT_SIZE; l++) {
					sum += *in++ * *m++;
				}
				*pbuf++ += sum;
				in -= MP3_SHORT_IMDCT_SIZE;
			}
			in += MP3_SHORT_IMDCT_SIZE;
			pbuf -= MP3_SHORT_IMDCT_SIZE;
		}

		pbuf = buf;
		/* uÕOj[̌㔼vƁũ݂Oj[̑OvďóB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = *pbuf++ + *save++;
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;
			out += MP3_SUBBAND_COUNT;
		}
		out -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;
		/* ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			*save++ = *pbuf++;
		}
	}

#else	/*******************************************************************/
	/* ꎞobt@gȂ(܂ςȂ?)           */

	int i, j, k;
	const double* m;
	double sum;

	mp3r_imdct_short_init();

	for(k = 0; k < MP3_SUBBAND_COUNT; k++) {
		/* |=`=| |=a=| |=b=| |=c=| |=d=| |=e=| */
		/* 000000 ------ ------ ------ ------ 000000 */
		/* ------ ?????? ?????? ------ ------ ------ */
		/* ------ ------ ?????? ?????? ------ ------ */
		/* ------ ------ ------ ?????? ?????? ------ */
		/* |=saveƑďo=| |====saveɕۑ====| ~ MP3_SUBBAND_COUNT */

		/* |=`=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = *save++;
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;
			out += MP3_SUBBAND_COUNT;
		}

		/* |=a=| */
		m = &mp3r_imdct_short_matrix[0][0];
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;
			}
			sum += *save++;
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;
			out += MP3_SUBBAND_COUNT;
			in  -= MP3_SHORT_IMDCT_SIZE;
		}

		/* |=b=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;
			}
			m -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;
			}
			sum += *save++;
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;
			out += MP3_SUBBAND_COUNT;
			m  += MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
			in -= MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
		}
		m    -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
		in   += MP3_SHORT_IMDCT_SIZE;
		out  -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;

		/* |=c=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;
			}
			m -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;
			}
			*save++ = sum;
			m  += MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
			in -= MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
		}
		m  -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
		in += MP3_SHORT_IMDCT_SIZE;

		/* |=d=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;
			}
			*save++ = sum;
			in  -= MP3_SHORT_IMDCT_SIZE;
		}
		in += MP3_SHORT_IMDCT_SIZE;

		/* |=e=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			*save++ = 0;
		}
	}

#endif	/*******************************************************************/
}

/****************************************************************************
 *	Tuoh
 ****************************************************************************/

static double mp3r_subband_matrix[MP3_SUBBAND_COUNT_2][MP3_SUBBAND_COUNT];
static void
mp3r_subband_synthesys_init()
{
	int i, j;
	double pi;

	{ static int init_ok; if(init_ok) return; init_ok = 1; }

	pi = acos(-1);
	for(i = 0; i < MP3_SUBBAND_COUNT_2; i++) {
		for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
			mp3r_subband_matrix[i][j] = cos((2 * j + 1) * (i + 16) * pi / MP3_SUBBAND_COUNT_2);
		}
	}
}

static const double mp3r_polyphase_filter[MP3_SUBBAND_COUNT][16] = {
#define P(d)	( (d))
#define M(d)	(-(d))
	{P( 0.000000000),P(-0.000442505),M(-0.003250122),M( 0.007003784),P( 0.031082153),P(-0.078628540),M(-0.100311279),M( 0.572036743),P( 1.144989014),P( 0.572036743),M(-0.100311279),M(-0.078628540),P( 0.031082153),P( 0.007003784),M(-0.003250122),M(-0.000442505)},
	{P(-0.000015259),P(-0.000473022),M(-0.003326416),M( 0.007919312),P( 0.030517578),P(-0.084182739),M(-0.090927124),M( 0.600219727),P( 1.144287109),P( 0.543823242),M(-0.108856201),M(-0.073059082),P( 0.031478882),P( 0.006118774),M(-0.003173828),M(-0.000396729)},
	{P(-0.000015259),P(-0.000534058),M(-0.003387451),M( 0.008865356),P( 0.029785156),P(-0.089706421),M(-0.080688477),M( 0.628295898),P( 1.142211914),P( 0.515609741),M(-0.116577148),M(-0.067520142),P( 0.031738281),P( 0.005294800),M(-0.003082275),M(-0.000366211)},
	{P(-0.000015259),P(-0.000579834),M(-0.003433228),M( 0.009841919),P( 0.028884888),P(-0.095169067),M(-0.069595337),M( 0.656219482),P( 1.138763428),P( 0.487472534),M(-0.123474121),M(-0.061996460),P( 0.031845093),P( 0.004486084),M(-0.002990723),M(-0.000320435)},
	{P(-0.000015259),P(-0.000625610),M(-0.003463745),M( 0.010848999),P( 0.027801514),P(-0.100540161),M(-0.057617187),M( 0.683914185),P( 1.133926392),P( 0.459472656),M(-0.129577637),M(-0.056533813),P( 0.031814575),P( 0.003723145),M(-0.002899170),M(-0.000289917)},
	{P(-0.000015259),P(-0.000686646),M(-0.003479004),M( 0.011886597),P( 0.026535034),P(-0.105819702),M(-0.044784546),M( 0.711318970),P( 1.127746582),P( 0.431655884),M(-0.134887695),M(-0.051132202),P( 0.031661987),P( 0.003005981),M(-0.002792358),M(-0.000259399)},
	{P(-0.000015259),P(-0.000747681),M(-0.003479004),M( 0.012939453),P( 0.025085449),P(-0.110946655),M(-0.031082153),M( 0.738372803),P( 1.120223999),P( 0.404083252),M(-0.139450073),M(-0.045837402),P( 0.031387329),P( 0.002334595),M(-0.002685547),M(-0.000244141)},
	{P(-0.000030518),P(-0.000808716),M(-0.003463745),M( 0.014022827),P( 0.023422241),P(-0.115921021),M(-0.016510010),M( 0.765029907),P( 1.111373901),P( 0.376800537),M(-0.143264771),M(-0.040634155),P( 0.031005859),P( 0.001693726),M(-0.002578735),M(-0.000213623)},
	{P(-0.000030518),P(-0.000885010),M(-0.003417969),M( 0.015121460),P( 0.021575928),P(-0.120697021),M(-0.001068115),M( 0.791213989),P( 1.101211548),P( 0.349868774),M(-0.146362305),M(-0.035552979),P( 0.030532837),P( 0.001098633),M(-0.002456665),M(-0.000198364)},
	{P(-0.000030518),P(-0.000961304),M(-0.003372192),M( 0.016235352),P( 0.019531250),P(-0.125259399),M( 0.015228271),M( 0.816864014),P( 1.089782715),P( 0.323318481),M(-0.148773193),M(-0.030609131),P( 0.029937744),P( 0.000549316),M(-0.002349854),M(-0.000167847)},
	{P(-0.000030518),P(-0.001037598),M(-0.003280640),M( 0.017349243),P( 0.017257690),P(-0.129562378),M( 0.032379150),M( 0.841949463),P( 1.077117920),P( 0.297210693),M(-0.150497437),M(-0.025817871),P( 0.029281616),P( 0.000030518),M(-0.002243042),M(-0.000152588)},
	{P(-0.000045776),P(-0.001113892),M(-0.003173828),M( 0.018463135),P( 0.014801025),P(-0.133590698),M( 0.050354004),M( 0.866363525),P( 1.063217163),P( 0.271591187),M(-0.151596069),M(-0.021179199),P( 0.028533936),P(-0.000442505),M(-0.002120972),M(-0.000137329)},
	{P(-0.000045776),P(-0.001205444),M(-0.003051758),M( 0.019577026),P( 0.012115479),P(-0.137298584),M( 0.069168091),M( 0.890090942),P( 1.048156738),P( 0.246505737),M(-0.152069092),M(-0.016708374),P( 0.027725220),P(-0.000869751),M(-0.002014160),M(-0.000122070)},
	{P(-0.000061035),P(-0.001296997),M(-0.002883911),M( 0.020690918),P( 0.009231567),P(-0.140670776),M( 0.088775635),M( 0.913055420),P( 1.031936646),P( 0.221984863),M(-0.151962280),M(-0.012420654),P( 0.026840210),P(-0.001266479),M(-0.001907349),M(-0.000106812)},
	{P(-0.000061035),P(-0.001388550),M(-0.002700806),M( 0.021789551),P( 0.006134033),P(-0.143676758),M( 0.109161377),M( 0.935195923),P( 1.014617920),P( 0.198059082),M(-0.151306152),M(-0.008316040),P( 0.025909424),P(-0.001617432),M(-0.001785278),M(-0.000106812)},
	{P(-0.000076294),P(-0.001480103),M(-0.002487183),M( 0.022857666),P( 0.002822876),P(-0.146255493),M( 0.130310059),M( 0.956481934),P( 0.996246338),P( 0.174789429),M(-0.150115967),M(-0.004394531),P( 0.024932861),P(-0.001937866),M(-0.001693726),M(-0.000091553)},
	{P(-0.000076294),P(-0.001586914),M(-0.002227783),M( 0.023910522),P(-0.000686646),P(-0.148422241),M( 0.152206421),M( 0.976852417),P( 0.976852417),P( 0.152206421),M(-0.148422241),M(-0.000686646),P( 0.023910522),P(-0.002227783),M(-0.001586914),M(-0.000076294)},
	{P(-0.000091553),P(-0.001693726),M(-0.001937866),M( 0.024932861),P(-0.004394531),P(-0.150115967),M( 0.174789429),M( 0.996246338),P( 0.956481934),P( 0.130310059),M(-0.146255493),M( 0.002822876),P( 0.022857666),P(-0.002487183),M(-0.001480103),M(-0.000076294)},
	{P(-0.000106812),P(-0.001785278),M(-0.001617432),M( 0.025909424),P(-0.008316040),P(-0.151306152),M( 0.198059082),M( 1.014617920),P( 0.935195923),P( 0.109161377),M(-0.143676758),M( 0.006134033),P( 0.021789551),P(-0.002700806),M(-0.001388550),M(-0.000061035)},
	{P(-0.000106812),P(-0.001907349),M(-0.001266479),M( 0.026840210),P(-0.012420654),P(-0.151962280),M( 0.221984863),M( 1.031936646),P( 0.913055420),P( 0.088775635),M(-0.140670776),M( 0.009231567),P( 0.020690918),P(-0.002883911),M(-0.001296997),M(-0.000061035)},
	{P(-0.000122070),P(-0.002014160),M(-0.000869751),M( 0.027725220),P(-0.016708374),P(-0.152069092),M( 0.246505737),M( 1.048156738),P( 0.890090942),P( 0.069168091),M(-0.137298584),M( 0.012115479),P( 0.019577026),P(-0.003051758),M(-0.001205444),M(-0.000045776)},
	{P(-0.000137329),P(-0.002120972),M(-0.000442505),M( 0.028533936),P(-0.021179199),P(-0.151596069),M( 0.271591187),M( 1.063217163),P( 0.866363525),P( 0.050354004),M(-0.133590698),M( 0.014801025),P( 0.018463135),P(-0.003173828),M(-0.001113892),M(-0.000045776)},
	{P(-0.000152588),P(-0.002243042),M( 0.000030518),M( 0.029281616),P(-0.025817871),P(-0.150497437),M( 0.297210693),M( 1.077117920),P( 0.841949463),P( 0.032379150),M(-0.129562378),M( 0.017257690),P( 0.017349243),P(-0.003280640),M(-0.001037598),M(-0.000030518)},
	{P(-0.000167847),P(-0.002349854),M( 0.000549316),M( 0.029937744),P(-0.030609131),P(-0.148773193),M( 0.323318481),M( 1.089782715),P( 0.816864014),P( 0.015228271),M(-0.125259399),M( 0.019531250),P( 0.016235352),P(-0.003372192),M(-0.000961304),M(-0.000030518)},
	{P(-0.000198364),P(-0.002456665),M( 0.001098633),M( 0.030532837),P(-0.035552979),P(-0.146362305),M( 0.349868774),M( 1.101211548),P( 0.791213989),P(-0.001068115),M(-0.120697021),M( 0.021575928),P( 0.015121460),P(-0.003417969),M(-0.000885010),M(-0.000030518)},
	{P(-0.000213623),P(-0.002578735),M( 0.001693726),M( 0.031005859),P(-0.040634155),P(-0.143264771),M( 0.376800537),M( 1.111373901),P( 0.765029907),P(-0.016510010),M(-0.115921021),M( 0.023422241),P( 0.014022827),P(-0.003463745),M(-0.000808716),M(-0.000030518)},
	{P(-0.000244141),P(-0.002685547),M( 0.002334595),M( 0.031387329),P(-0.045837402),P(-0.139450073),M( 0.404083252),M( 1.120223999),P( 0.738372803),P(-0.031082153),M(-0.110946655),M( 0.025085449),P( 0.012939453),P(-0.003479004),M(-0.000747681),M(-0.000015259)},
	{P(-0.000259399),P(-0.002792358),M( 0.003005981),M( 0.031661987),P(-0.051132202),P(-0.134887695),M( 0.431655884),M( 1.127746582),P( 0.711318970),P(-0.044784546),M(-0.105819702),M( 0.026535034),P( 0.011886597),P(-0.003479004),M(-0.000686646),M(-0.000015259)},
	{P(-0.000289917),P(-0.002899170),M( 0.003723145),M( 0.031814575),P(-0.056533813),P(-0.129577637),M( 0.459472656),M( 1.133926392),P( 0.683914185),P(-0.057617187),M(-0.100540161),M( 0.027801514),P( 0.010848999),P(-0.003463745),M(-0.000625610),M(-0.000015259)},
	{P(-0.000320435),P(-0.002990723),M( 0.004486084),M( 0.031845093),P(-0.061996460),P(-0.123474121),M( 0.487472534),M( 1.138763428),P( 0.656219482),P(-0.069595337),M(-0.095169067),M( 0.028884888),P( 0.009841919),P(-0.003433228),M(-0.000579834),M(-0.000015259)},
	{P(-0.000366211),P(-0.003082275),M( 0.005294800),M( 0.031738281),P(-0.067520142),P(-0.116577148),M( 0.515609741),M( 1.142211914),P( 0.628295898),P(-0.080688477),M(-0.089706421),M( 0.029785156),P( 0.008865356),P(-0.003387451),M(-0.000534058),M(-0.000015259)},
	{P(-0.000396729),P(-0.003173828),M( 0.006118774),M( 0.031478882),P(-0.073059082),P(-0.108856201),M( 0.543823242),M( 1.144287109),P( 0.600219727),P(-0.090927124),M(-0.084182739),M( 0.030517578),P( 0.007919312),P(-0.003326416),M(-0.000473022),M(-0.000015259)},
#undef P
#undef M
};

int
mp3r_subband_synthesys(const double* in/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, short* out/*[upto MP3_GRANULE_SIZE]*/, double* save/*[16][MP3_SUBBAND_COUNT_2]*/, int offset, const MP3SAMPLINGFREQUENCYCONVERTTABLE* convert)
{
	int i, j, k, count;
	const double* m;
	double sum;
	const unsigned char* table;

#define OFFSET_MASK	(MP3_SUBBAND_COUNT_2 * 16 - 1)

	mp3r_subband_synthesys_init();

	table = convert->table;
	count = convert->count;

	for(k = 0; k < MP3_SUBBAND_SIZE; k++) {
		/* ݍ݉ZB(32f[^ԗ̈ɕϊ)
		 * ͍s̊s𕄍]ē]u鏈́AIMDCT̒ōsĂ܂B
		 */
#if 0
		/* 1TvÂ~2[vo[W */
		/* O */
		for(i = 0; i < count; i++) {
			m = mp3r_subband_matrix[*table++];
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
				sum += *in++ * *m++;
			}
			save[offset++] = sum;
			in -= MP3_SUBBAND_COUNT;
		}
		table -= count;
		offset += MP3_SUBBAND_COUNT - count;
		/* 㔼 */
		for(i = 0; i < count; i++) {
			m = mp3r_subband_matrix[MP3_SUBBAND_COUNT + *table++];
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
				sum += *in++ * *m++;
			}
			save[offset++] = sum;
			in -= MP3_SUBBAND_COUNT;
		}
		table -= count;
		offset -= MP3_SUBBAND_COUNT + count;
		in += MP3_SUBBAND_COUNT;
#else
		/* 2TvÂ~1[vo[W */
		for(i = 0; i < count; i++) {
			/* O */
			m = mp3r_subband_matrix[*table++];
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
				sum += *in++ * *m++;
			}
			save[offset] = sum;
			offset += MP3_SUBBAND_COUNT;
			in -= MP3_SUBBAND_COUNT;
			/* 㔼 */
			m += MP3_SUBBAND_COUNT * MP3_SUBBAND_COUNT - MP3_SUBBAND_COUNT;
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
				sum += *in++ * *m++;
			}
			save[offset] = sum;
			offset -= MP3_SUBBAND_COUNT - 1;
			in -= MP3_SUBBAND_COUNT;
		}
		table -= count;
		offset -= count;
		in += MP3_SUBBAND_COUNT;
#endif
		/* 16g̃f[^̏dˍ킹B
		 * |tF[YtB^[oNW\́A炩ߓ]uĂ܂B
		 */
		for(i = 0; i < count; i++) {
			m = mp3r_polyphase_filter[*table++];
			sum = 0;
			for(j = 0; j < 16 / 2/*2TvÂ*/; j++) {
				/* O */
				sum += save[offset] * *m++;
				offset += MP3_SUBBAND_COUNT_2 + MP3_SUBBAND_COUNT;
				offset &= OFFSET_MASK;
				/* 㔼 */
				sum += save[offset] * *m++;
				offset += MP3_SUBBAND_COUNT_2 - MP3_SUBBAND_COUNT;
				offset &= OFFSET_MASK;
			}
			offset++;
			/* -0x7fff`0x7fffɃXP[OB */
			if(sum < -1.0) sum = -1.0;
			if(sum >  1.0) sum =  1.0;
			*out++ = (short)(sum * 0x7fff);
		}
		table -= count;
		offset -= MP3_SUBBAND_COUNT_2 + count;
		offset &= OFFSET_MASK;
	}

#undef OFFSET_MASK

	return offset;
}

/****************************************************************************
 *	MP3hCo
 ****************************************************************************/

//#define NO_CONVERT

int
mp3r_init(MP3RDRIVER* mp3, const void* data, int len)
{
	/* ܂[NAB */
	memset(mp3, 0, sizeof(MP3RDRIVER));

	/* ǂݍ݈ʒuƏI[ʒui[܂B */
	mp3->pos = data;
	mp3->end = mp3->pos + len;

	/* TvOgϊpDDAp^̏ݒB */
	mp3->e_fbuff = -SPEAKER_FREQUENCY;

	/* ŏ̃t[fR[hAobt@𖞂܂B */
	if(mp3r_decode_frame(mp3) != 0) return -1;

	return 0;
}

int
mp3r_decode_frame(MP3RDRIVER* mp3)
{
	MP3BITSTREAM bs, bs_tmp;
	MP3FRAMEHEADER frame;
	MP3SIDEINFO side;
	MP3SCALEFACTOR scale;
	MP3GRANULEINFO* granule;
	const MP3SAMPLINGFREQUENCYCONVERTTABLE* convert;
	int bitrate, sampling_frequency, channels, frame_size, main_data_size;
	int i_granule, i_channel, count, subband_count;
	short* out;

	/* t[ԂŕۑKv̂Ȃobt@B */
	static double buf1[MP3_GRANULE_SIZE];
	static double buf2[MP3_GRANULE_SIZE];

	/* t[Jnʒu܂B */
	for(;;) {
		/* f[^I[? */
		if(mp3->pos >= mp3->end - 1) return -1;
		/* [h? */
		if(mp3->pos[0] == 0xff &&
		  (mp3->pos[1] &  0xf0) == 0xf0) break;
		mp3->pos++;
	}

	/* rbgXg[J܂B */
	mp3_bitstream_open(&bs, mp3->pos);

	/* t[wb_ǂݍ݂܂B */
	if(mp3_read_frame_header(&bs, &frame) != 0) return -1/*t[wb_s*/;
	bitrate = mp3_bitrate_table[frame.bitrate_index];
	sampling_frequency = mp3_sampling_frequency_table[frame.sampling_frequency];
	channels = frame.mode == 3 ? 1 : 2;
	frame_size = 144 * bitrate / sampling_frequency + frame.padding_bit; /* t[TCYvZ */

	/* TChǂݍ݂܂B */
	mp3_read_side_info(&bs, &side, channels);

	/* Cf[^̃rbg~ρB */
	ASSERT(bs.cnt == 0); /* TCh̖ŃoCgEɐ񂵂Ă͂ */
	main_data_size = frame_size - (bs.pos - mp3->pos)/*t[wb_ƃTChc肪Cf[^*/;
	if(mp3->main_save_size + main_data_size > sizeof mp3->main_save) {
		memmove(&mp3->main_save[0], &mp3->main_save[mp3->main_save_size - side.main_data_begin], side.main_data_begin);
		mp3->main_save_size = side.main_data_begin;
	}
	memcpy(&mp3->main_save[mp3->main_save_size], bs.pos, main_data_size);
	mp3_bitstream_open(&bs, &mp3->main_save[mp3->main_save_size - side.main_data_begin]);
	mp3->main_save_size += main_data_size;

	/* TvOgϊe[u擾܂B */
	convert = &mp3_sampling_frequency_convert_table[frame.sampling_frequency];

#ifdef NO_CONVERT
	{
		static MP3SAMPLINGFREQUENCYCONVERTTABLE _convert;
		unsigned char _table[32];
		int i;
		for(i = 0; i < 32; i++) _table[i] = i;
		_convert.table = _table;
		_convert.count = 32;
		_convert.sampling_frequency = mp3_sampling_frequency_table[frame.sampling_frequency];
		convert = &_convert;
	}
#endif

	/* eOj[fR[h܂B */
	out = mp3->fbuff;
	for(i_granule = 0; i_granule < MP3_GRANULE_COUNT; i_granule++) {
		for(i_channel = 0; i_channel < channels; i_channel++) {
			granule = &side.granule_info[i_granule][i_channel];
			if(i_channel == 0) { /* `l̂ݎgp */
				bs_tmp = bs;
				/* nt}Count1̈I[ô߁Aǂݍ񂾃rbgZbgĂ܂B
				 * XP[t@N^(Part2)+nt}(Part3)̍vrbgGRANULE.part2_3_lengthƂȂ܂B
				 */
				bs_tmp.read_bits = 0;
				/* Part2: XP[t@N^ǂݍ݁B */
				mp3_read_scalefactor(&bs_tmp, granule, &scale, !i_granule ? 0 : side.scfsi[i_channel]);
				/* Part3: nt}B */
				count = mp3_huffman_decode(&bs_tmp, &frame, granule, (short*)buf1/*shortzƂėp*/);
				if(granule->block_type == 2) {
					if(granule->mixed_block_flag) {
						/* ~bNXubN */
						/* TODO: ~bNXubN𐶐GR[_܂݂Ȃ炵̂ŁAƂ肠KvȂ悤łB */
						memset(buf1, 0, sizeof buf1);
					} else {
						/* V[gubN */
						/* tʎqB */
						mp3r_requantize_short(&frame, granule, &scale, (short*)buf1/*shortzƂėp*/, buf2);
						/* V[gubNɂ͂ƂƃGAVO팸͂܂B */
						/* IMDCTB */
						mp3r_imdct_short(buf2, buf1, &mp3->imdct_save[0]);
					}
				} else {
					/* BigValue/Count1̈̃f[^܂ރTuoh߂܂B */
					subband_count = (count + (MP3_SUBBAND_COUNT - 1)) / MP3_SUBBAND_COUNT;
					/* OubN */
					/* tʎqB */
					mp3r_requantize_long(&frame, granule, &scale, (short*)buf1/*shortzƂėp*/, buf2, count);
					/* GAVO팸B */
					mp3r_antialias(buf2, subband_count);
					/* IMDCTB */
					mp3r_imdct_long(buf2, buf1, &mp3->imdct_save[0], subband_count);
				}
				/* TuohB */
				mp3->subband_synthesys_offset = mp3r_subband_synthesys(buf1, out, &mp3->subband_synthesys_save[0][0], mp3->subband_synthesys_offset, convert);
				out += convert->count * MP3_SUBBAND_SIZE; /* TvOgϊ̃Oj[Tv */
			}
			mp3_bitstream_skip(&bs, granule->part2_3_length);
		}
	}

	/* TvOgƃTvi[܂B */
	mp3->sampling_frequency = convert->sampling_frequency;
	mp3->c_fbuff = convert->count * MP3_SUBBAND_SIZE * MP3_GRANULE_COUNT; /* TvOgϊ̃t[Tv */

	/* t[ʒui߂܂B */
	mp3->pos += frame_size;

	return 0;
}
