/*
 *	jtif.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTIF
 *****************************************************************************/

typedef struct _JTIF {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTCODE_INTERFACE** cond;	/*  */
	JTCODE_INTERFACE** then_body;	/* ^̂ƂɎs镶 */
	JTCODE_INTERFACE** else_body;	/* ÛƂɎs镶A܂́ANULL */
} JTIF;

IMPLEMENT_JTCODE_INTERFACE(JTIF, jtif)

const INTERFACE_MAP jtif_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTIF, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtif_create(JTCODE_INTERFACE** cond, JTCODE_INTERFACE** then_body, JTCODE_INTERFACE** else_body)
{
	JTIF* this = calloc(1, sizeof(JTIF));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtif_interface_map);

	/* A^̂ƂɎs镶AÛƂɎs镶i[܂B */
	safe_assign(this->cond, cond);
	safe_assign(this->then_body, then_body);
	safe_assign(this->else_body, else_body);

	return &this->jtcode_interface;
}

static void
jtif_delete(JTIF* this)
{
	/* A^̂ƂɎs镶AÛƂɎs镶܂B */
	safe_release(this->cond);
	safe_release(this->then_body);
	safe_release(this->else_body);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTIF* this = CONTAINING_RECORD(intf, JTIF, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTCODE_INTERFACE** cond = NULL;
	JTCODE_INTERFACE** body = NULL;
	JTBOOL_INTERFACE** jtbool = NULL;

	/* s܂B */
	safe_attach(cond, (*this->cond)->run(this->cond));
	safe_assign_interface(jtbool, cond, JTBOOL_INTERFACE);
	if(!jtbool) {
		DIE(); /* JTBOOL_INTERFACEKv */
	}

	/* sʂ̐^UɂāAs镶I܂B */	
	if((*jtbool)->get_value(jtbool)) {
		safe_assign(body, this->then_body);
	} else {
		safe_assign(body, this->else_body); /* NULL: elseubN */
	}

	/* Iꂽs܂B
	 * sʂUŁAelseubNꍇ̂߂ɁANULL肪KvłB
	 */
	if(body) {
		safe_attach(code, (*body)->run(body));
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(cond);
	safe_release(body);
	safe_release(jtbool);

	return code;
}

