/*	
 *	framsti.c
 *
 *	P/ECE STIC Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed May 18 20:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

#ifndef STIC_ASM

/****************************************************************************
 *
 ****************************************************************************/

#ifdef STIC_GRAYSCALE
/*
 * (]  5sNZ -> ]  4sNZ) x 32
 * (] c12C   -> ] c11C  ) x  8
 *
 * 12C -> 11C̈kp^[́ÂƂłB
 *
 *	]Line#	]Line#
 *	-----------	-----------
 *	 0		 0
 *	 1		 1
 *	 2		 2
 *	 3		 3
 *	 4		 4
 *	 5		 5
 *	 6		 6
 *	 7		 7
 *	 8		 8
 *	 9		 9
 *	10+11		10
 */
void
stic_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*96*/])
{
	int x;
	int y;
	int z;

	z = 8;
	do {
		y = 11 - 1;
		do {
			x = 32;
			do {
				dst[0] =  src[0];
				dst[1] =  src[1];
				dst[2] =  src[2];
				dst[3] = (src[3] + src[4] + 1) >> 1;
				dst += 4;
				src += 5;
			} while(--x);
		} while(--y);
		//
		x = 32;
		do {
			dst[0] = (src[0] + src[160] + 1) >> 1;
			dst[1] = (src[1] + src[161] + 1) >> 1;
			dst[2] = (src[2] + src[162] + 1) >> 1;
			dst[3] = (src[3] + src[163] +
			          src[4] + src[164] + 2) >> 2;
			dst += 4;
			src += 5;
		} while(--x);
		src += 160;
	} while(--z);
}
#endif /*STIC_GRAYSCALE*/

/****************************************************************************
 *
 ****************************************************************************/

#endif /*STIC_ASM*/
