/*	
 *	frampky.c
 *
 *	P/ECE POKEY(CO12294) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Jan 26 20:20:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	֐
 ****************************************************************************/

short
pokey_process(POKEY* pokey, int cycle)
{
	int step, v;

	while(cycle) {
		/* ꂩ̃`lo͔]܂ł̍ŒZTCN擾܂B */
		                                      step = pokey->channel[0].progress;
		if(pokey->channel[1].progress < step) step = pokey->channel[1].progress;
		if(pokey->channel[2].progress < step) step = pokey->channel[2].progress;
		if(pokey->channel[3].progress < step) step = pokey->channel[3].progress;

		if(cycle < step) {
			/* cTCNȓłȂ΁A]͕svłB */
			step = cycle; /* cTCNSď */
			//pokey->lfsr_progress += step;
			//pokey_channel_process(pokey, &pokey->channel[0], step);
			//pokey_channel_process(pokey, &pokey->channel[1], step);
			//pokey_channel_process(pokey, &pokey->channel[2], step);
			//pokey_channel_process(pokey, &pokey->channel[3], step);
			//Ăʂ͓łA
			//ԒZk̂߂ɂ܂B
			pokey->lfsr_progress += step;
			pokey->channel[0].progress -= step;
			pokey->channel[1].progress -= step;
			pokey->channel[2].progress -= step;
			pokey->channel[3].progress -= step;

		} else { /* cycle >= step */
			/* cTCNȓȂ΁Ao͔]s܂B */
			pokey->lfsr_progress += step;
			pokey_channel_process(pokey, &pokey->channel[0], step);
			pokey_channel_process(pokey, &pokey->channel[1], step);
			pokey_channel_process(pokey, &pokey->channel[2], step);
			pokey_channel_process(pokey, &pokey->channel[3], step);
		}

		/* :
		 * upokey->lfsr_progress += step;v̏͂ɂ܂Ƃ߂Ă悤Ɏv̂łA
		 * ȂֈڂŉFςAmCYۂԈFɂȂĂ܂܂B
		 * pokey_channel_process()̐ɂ邩ł邩̈ႢȂ̂łEEEłB
		 */

		/* cTCN炵܂B */
		cycle -= step;
	}

	/* `l1`4̏o̓xv܂B */
	v = pokey->channel[0].output	/*  t5bit */
	  + pokey->channel[1].output	/* +t5bit */
	  + pokey->channel[2].output	/* +t5bit */
	  + pokey->channel[3].output;	/* +t5bit */
					/* =t7bit */

	/* XP[OANbsO܂B */
	v <<= (16 - 7) + 1/**/;
	if(v < -0x7fff) v = -0x7fff;
	if(v >  0x7fff) v =  0x7fff;

	return v;
}

void
pokey_channel_process(POKEY* pokey, POKEYCHANNEL* channel, int cycle)
{
	if(channel->volume_only) return;
	channel->progress -= cycle;
	while(channel->progress <= 0) {
		channel->progress += channel->period;
		switch(channel->distotion) {
		case 0: /* 5bit & 17(9)bit */
			if(pokey_lfsr_signal5(pokey) && pokey_lfsr_signal17_9(pokey)) channel->signal = !channel->signal;
			break;
		case 1:
		case 3: /* 5bit */
			if(pokey_lfsr_signal5(pokey)                                ) channel->signal = !channel->signal;
			break;
		case 2: /* 5bit & 4bit */
			if(pokey_lfsr_signal5(pokey) && pokey_lfsr_signal4(pokey)   ) channel->signal = !channel->signal;
			break;
		case 4: /* 17(9)bit */
			if(pokey_lfsr_signal17_9(pokey)                             ) channel->signal = !channel->signal;
			break;
		case 6: /* 4bit */
			if(pokey_lfsr_signal4(pokey)                                ) channel->signal = !channel->signal;
			break;
		default:/* case 5,7: PureTone */
			channel->signal = !channel->signal;
			break;
		}
		channel->output = channel->signal ?  channel->volume
						  : -channel->volume;
	}
}

/* 4bit LFSȐo͒l擾܂B */
int
pokey_lfsr_signal4(POKEY* pokey)
{
	unsigned u = pokey->lfsr_progress;
	u %= (1 << 4) - 1;
	u = pokey_lfsr_table4[u / 8] >> (u & 7) & 1;
	return u;
}

/* 5bit LFSȐo͒l擾܂B */
int
pokey_lfsr_signal5(POKEY* pokey)
{
	unsigned u = pokey->lfsr_progress;
	u %= (1 << 5) - 1;
	u = pokey_lfsr_table5[u / 8] >> (u & 7) & 1;
	return u;
}

/* 17or9bit LFSȐo͒l擾܂B */
int
pokey_lfsr_signal17_9(POKEY* pokey)
{
	unsigned u = pokey->lfsr_progress;
	if(pokey->reg[8] & 0x80) { /* 9bit */
		u %= (1 << 9) - 1;
		u = pokey_lfsr_table9[u / 8] >> (u & 7) & 1;
	} else { /* 17bit */
		u %= (1 << 17) - 1;
		u = pokey_lfsr_table17[u / 8] >> (u & 7) & 1;
	}
	return u;
}

/* * pokey_lfsr_signal*()]𑽗p̂ŁA]CuRAMɒu܂B
 *   ܂A__umodsi3pokey_lfsr_signal*()̑O256oCgȓɂ΁Acall߂extsvɂȂ܂B
 *   ł邾pokey_lfsr_signal*()́uvɒuĂB
 *   uOvłȂuvƂŔA__umodsi3̃TCYɉZȂA
 *   uv̕߂Ȃ\łB
 *   SĂ__umodsi3ĂяoA256oCgȓƂȂĂ邱ƂmF܂B(2004/01/28)
 * * Œ`__umodsi3́AO[o__umodsi3u܂񁚁B
 *   u.global __umodsi3v錾ĂȂ̂ŁÃW[ł̂ݗLłB
 *   u.global __umodsi3v錾ƁAEPSONCuƂԂĂ܂܂B
 */
#ifdef PIECE
asm("
	.code
	.align 2
	; .global 錾_!
__umodsi3:
	ld.w %alr, %r12
	div0u %r13
	div1 %r13		;  1
	div1 %r13		;  2
	div1 %r13		;  3
	div1 %r13		;  4
	div1 %r13		;  5
	div1 %r13		;  6
	div1 %r13		;  7
	div1 %r13		;  8
	div1 %r13		;  9
	div1 %r13		; 10
	div1 %r13		; 11
	div1 %r13		; 12
	div1 %r13		; 13
	div1 %r13		; 14
	div1 %r13		; 15
	div1 %r13		; 16
	div1 %r13		; 17
	div1 %r13		; 18
	div1 %r13		; 19
	div1 %r13		; 20
	div1 %r13		; 21
	div1 %r13		; 22
	div1 %r13		; 23
	div1 %r13		; 24
	div1 %r13		; 25
	div1 %r13		; 26
	div1 %r13		; 27
	div1 %r13		; 28
	div1 %r13		; 29
	div1 %r13		; 30
	div1 %r13		; 31
	div1 %r13		; 32
	;div2u %r13		; Ž㏈͂܂
	;div3u			; Ž㏈͂܂
	ret.d
	ld.w %r10, %ahr		; *delay*(undoc'd)
");
#endif /*PIECE*/

