;	
;	framn2a.s
;
;	P/ECE YM2612(OPN2) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Sun Dec 05 03:03:00 JST 2003 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipn2a.h"
#ifdef YM2612_ASM

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

;
;	YM2612OP\
;
#define EG_ENV		  0	; (int)
#define EG_CNT		  4	; (int)
#define EG_AR		  8	; (int)
#define EG_TL		 12	; (int)
#define EG_DR		 16	; (int)
#define EG_SL		 20	; (int)
#define EG_SR		 24	; (int)
#define EG_RR		 28	; (int)
#define PG_CNT		 32	; (int)
#define PG_SPD		 36	; (int)
#define MUL		 40	; (unsigned char)
#define TL		 41	; (unsigned char)
#define SL		 42	; (unsigned char)
#define YM2612OP_SIZE	 44	; 'add %r12,YM2612OP_SIZE'xXbgɓ邽߁A63ȉK{!!

;
;	YM2612CH\
;
#define OP1		(YM2612OP_SIZE*0)	;   0
#define OP2		(YM2612OP_SIZE*1)	;  44
#define OP3		(YM2612OP_SIZE*2)	;  88
#define OP4		(YM2612OP_SIZE*3)	; 132
#define MIX		176	; (int)
#define FB_IN		180	; (int)
#define FB		184	; (unsigned char)
#define LR		185	; (unsigned char)
#define F_NUMBER_LSB	186	; (unsigned char)
#define F_NUMBER_MSB	187	; (unsigned char)
#define BLOCK		188	; (unsigned char)
#define YM2612CH_SIZE	192

;****************************************************************************
;	
;****************************************************************************

;
; YM2612OP_ENV֐łB
; [in]
;	%r11		env_cnt
;	%r12		YM2612OP\
; [out]
;	%r11		env_cnt
; [use]
;	%r9
; [note]
;	* WX^ߖ̂߁A[NWX^Ƃ%r9𗘗pĂ܂B
;	  ȉYM2612OP_ENV֐̒ŁA%r9j󂷂g߂gȂ悤A
;	  ӂĂB
;
	.global ym2612op_env_attack
ym2612op_env_attack:
	xld.w %r9, [%r12+EG_AR]		; eg_cnt += eg_ar
	add %r11, %r9
	xld.w %r9, [%r12+EG_TL]		; if(eg_cnt >= eg_tl) {
	cmp %r11, %r9
	xjrlt ym2612op_env_attack_L10
	ld.w %r11, %r9			;   eg_cnt = eg_tl
	xld.w %r9, ym2612op_env_decay	;   eg_env = ym2612op_env_decay
	xld.w [%r12+EG_ENV], %r9
ym2612op_env_attack_L10:		; }
	ret

	.global ym2612op_env_decay
ym2612op_env_decay:
	xld.w %r9, [%r12+EG_DR]		; eg_cnt -= eg_dr
	sub %r11, %r9
	xld.w %r9, [%r12+EG_SL]		; if(eg_cnt <= eg_sl) {
	cmp %r11, %r9
	xjrgt ym2612op_env_decay_L10
	ld.w %r11, %r9			;   eg_cnt = eg_sl
	xld.w %r9, ym2612op_env_sustain	;   eg_env = ym2612op_env_sustain
	xld.w [%r12+EG_ENV], %r9
ym2612op_env_decay_L10:			; }
	ret

	.global ym2612op_env_sustain
ym2612op_env_sustain:
	xld.w %r9, [%r12+EG_SR]		; eg_cnt += eg_sr
	sub %r11, %r9
	xjrgt ym2612op_env_sustain_L10	; if(eg_cnt <= 0) {
	xld.w %r11, 0			;   eg_cnt = 0
	xld.w %r9, ym2612op_env_silent	;   eg_env = ym2612op_env_silent
	xld.w [%r12+EG_ENV], %r9
ym2612op_env_sustain_L10:		; }
	ret

	.global ym2612op_env_release
ym2612op_env_release:
	xld.w %r9, [%r12+EG_RR]		; eg_cnt += eg_rr
	sub %r11, %r9
	xjrgt ym2612op_env_release_L10	; if(eg_cnt <= 0) {
	xld.w %r11, 0			;   eg_cnt = 0
	xld.w %r9, ym2612op_env_silent	;   eg_env = ym2612op_env_silent
	xld.w [%r12+EG_ENV], %r9
ym2612op_env_release_L10:		; }
	ret

	.global ym2612op_env_silent
ym2612op_env_silent:
	ret.d
	ld.w %r11, 0			; eg_cnt = 0 *delay*

;****************************************************************************
;	
;****************************************************************************

;
; ym2612ch_mix0..7̍ŏɁApg_cnt,eg_cntǂݏo܂B
; [in]
;	%r12		YM2612CH\
; [out]
;	%r0..%r3	Op1..4pg_cnt
;	%r4..%r7	Op1..4eg_cnt
; [note]
;	* %r0..3X^bNɑޔ܂B
;	  %sp𒲐ꍇ́Ã}ŇōsĂB
;
#macro ym2612op_mix_begin
	pushn %r3
	xld.w %r0, [%r12+OP1+PG_CNT]
	xld.w %r1, [%r12+OP2+PG_CNT]
	xld.w %r2, [%r12+OP3+PG_CNT]
	xld.w %r3, [%r12+OP4+PG_CNT]
	xld.w %r4, [%r12+OP1+EG_CNT]
	xld.w %r5, [%r12+OP2+EG_CNT]
	xld.w %r6, [%r12+OP3+EG_CNT]
	xld.w %r7, [%r12+OP4+EG_CNT]
#endm

;
; ym2612ch_mix0..7̍ŌɁApg_cnt,eg_cnt߂܂B
; [in]
;	%r0..%r3	Op1..4pg_cnt
;	%r4..%r7	Op1..4eg_cnt
;	%r12		YM2612CH\
; [note]
;	* %r0..3X^bN畜܂B
;	  %sp𒲐ꍇ́Ã}NɍsĂB
;
#macro ym2612op_mix_end
	xld.w [%r12+OP1+PG_CNT], %r0
	xld.w [%r12+OP2+PG_CNT], %r1
	xld.w [%r12+OP3+PG_CNT], %r2
	xld.w [%r12+OP4+PG_CNT], %r3
	xld.w [%r12+OP1+EG_CNT], %r4
	xld.w [%r12+OP2+EG_CNT], %r5
	xld.w [%r12+OP3+EG_CNT], %r6
	xld.w [%r12+OP4+EG_CNT], %r7
	popn %r3
#endm

;
; Iy[^̏s܂B
; [in]
;	$1		pg_cntWX^ (%r0..%r3)
;	$2		eg_cntWX^ (%r4..%r7)
;	%r12		YM2612OP\
;	%r15		Iy[^
; [out]
;	%alr		Iy[^o
; [use]
;	%r9
;	%r10
;	%r11
; [note]
;	* ym2612op_mix0..3̎ɗp܂B
;
#macro ym2612op_mix $1, $2
	xld.w %r10, [%r12+PG_SPD]		; pg_cnt += pg_spd
	add $1, %r10
	ld.w %r10, $1				; pg_out = ym2612op_pg_table[((pg_cnt + op_in) >> 16) & 255]
	add %r10, %r15
	xsra %r10, 16-1
	xand %r10, %r10, 255<<1
	ext ym2612op_pg_table@ah
	ext ym2612op_pg_table@al
	ld.h %r10, [%r10]
	;
	xld.w %r11, [%r12+EG_ENV]		; eg_cnt = eg_env(op, op_cnt)
	call.d %r11
	ld.w %r11, $2				; *delay*
	ld.w $2, %r11
	xsra %r11, 8				; eg_out = eg_cnt >> 8
	;
	mlt.h %r10, %r11			; op_out = pg_out * eg_out
#endm

;
; Iy[^1̏s܂B
; [in]
;	%r12		YM2612CH.op[0] (==YM2612CH擪K{!!)
; [out]
;	%r15		Iy[^o
; [use]
;	%r9
;	%r10
;	%r11
;	%alr
;
	.global ym2612op_mix0
ym2612op_mix0:
	xld.w %r15, [%r12+FB_IN]		; op_in = ch->fb_in
	ym2612op_mix %r0, %r4
	;{{Feedback
	xld.ub %r10, [%r12+FB]			; if(ch->fb) { unsigned charł!!
	xcmp %r10, 0
	xjreq ym2612op_mix0_L10
	ld.w %r11, %alr				;   ch->fb_in = op_out << ch->fb >> 6
	sla %r11, %r10
	sra %r11, 6
	xld.w [%r12+FB_IN], %r11
ym2612op_mix0_L10:
	;}}Feedback
	ret.d
	ld.w %r15, %alr				; *delay* (undoc'd)

;
; Iy[^2̏s܂B
; [in]
;	%r12		YM2612CH.op[1]
;	%r15		Iy[^
; [out]
;	%r15		Iy[^o
; [use]
;	%r9
;	%r10
;	%r11
;	%alr
;
	.global ym2612op_mix1
ym2612op_mix1:
	ym2612op_mix %r1, %r5
	ret.d
	ld.w %r15, %alr				; *delay* (undoc'd)

;
; Iy[^3̏s܂B
; [in]
;	%r12		YM2612CH.op[2]
;	%r15		Iy[^
; [out]
;	%r15		Iy[^o
; [use]
;	%r9
;	%r10
;	%r11
;	%alr
;
	.global ym2612op_mix2
ym2612op_mix2:
	ym2612op_mix %r2, %r6
	ret.d
	ld.w %r15, %alr				; *delay* (undoc'd)

;
; Iy[^4̏s܂B
; [in]
;	%r12		YM2612CH.op[3]
;	%r15		Iy[^
; [out]
;	%r15		Iy[^o
; [use]
;	%r9
;	%r10
;	%r11
;	%alr
;
	.global ym2612op_mix3
ym2612op_mix3:
	ym2612op_mix %r3, %r7
	ret.d
	ld.w %r15, %alr				; *delay* (undoc'd)

;****************************************************************************
;	
;****************************************************************************

;
; YM2612CH_MIX֐łB
; [in]
;	%r12		YM2612OP\
;	%r13		mixbuf
;	%r14		count
; [use]
;	S1C33Kɏ]
; [note]
;	* [vJE^ۑpƂ%ahr𗘗pĂ܂B
;	  ĂяoYM2612OP_ENV֐ym2612op_mix}N%ahrj󂵂Ȃ悤A
;	  CĂB
;
	.global ym2612ch_mix0
ym2612ch_mix0:
	ym2612op_mix_begin
	;
ym2612ch_mix0_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	xcall.d ym2612op_mix1			; [1]->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	xcall.d ym2612op_mix2			; [2]->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	xcall.d ym2612op_mix3			; [3]->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [4]->Out
	ld.w [%r13]+, %r10
	;
	xsub %r14, %r14, 1
	xjrne ym2612ch_mix0_L10
	;
	ym2612op_mix_end
	ret

	.global ym2612ch_mix1
ym2612ch_mix1:
	ym2612op_mix_begin
	;
	ld.w %ahr, %r14
ym2612ch_mix1_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	ld.w %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix1			; 0->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xcall.d ym2612op_mix2			; [1]+[2]->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	xcall.d ym2612op_mix3			; [3]->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix1_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	ym2612op_mix_end
	ret

	.global ym2612ch_mix2
ym2612ch_mix2:
	ym2612op_mix_begin
	;
	ld.w %ahr, %r14
ym2612ch_mix2_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	ld.w %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix1			; 0->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	xcall.d ym2612op_mix2			; [2]->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xcall.d ym2612op_mix3			; [1]+[3]->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix2_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	ym2612op_mix_end
	ret

	.global ym2612ch_mix3
ym2612ch_mix3:
	ym2612op_mix_begin
	;
	ld.w %ahr, %r14
ym2612ch_mix3_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	xcall.d ym2612op_mix1			; [1]->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	ld.w %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix2			; 0->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xcall.d ym2612op_mix3			; [2]+[3]->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix3_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	ym2612op_mix_end
	ret

	.global ym2612ch_mix4
ym2612ch_mix4:
	ym2612op_mix_begin
	;
	ld.w %ahr, %r14
ym2612ch_mix4_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	xcall.d ym2612op_mix1			; [1]->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	ld.w %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix2			; 0->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	xcall.d ym2612op_mix3			; [3]->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [2]+[4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix4_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	ym2612op_mix_end
	ret

	.global ym2612ch_mix5
ym2612ch_mix5:
	ym2612op_mix_begin
	xsub %sp, %sp, 4
	;
	ld.w %ahr, %r14
ym2612ch_mix5_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	xld.w [%sp+0], %r15
	xcall.d ym2612op_mix1			; [1]->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	ld.w %r14, %r15
	xld.w %r15, [%sp+0]
	xcall.d ym2612op_mix2			; [1]->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r14, %r15
	xld.w %r15, [%sp+0]
	xcall.d ym2612op_mix3			; [1]->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [2]+[3]+[4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix5_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	xadd %sp, %sp, 4
	ym2612op_mix_end
	ret

	.global ym2612ch_mix6
ym2612ch_mix6:
	ym2612op_mix_begin
	;
	ld.w %ahr, %r14
ym2612ch_mix6_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	xcall.d ym2612op_mix1			; [1]->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	ld.w %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix2			; 0->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix3			; 0->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [2]+[3]+[4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix6_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	ym2612op_mix_end
	ret

	.global ym2612ch_mix7
ym2612ch_mix7:
	ym2612op_mix_begin
	;
	ld.w %ahr, %r14
ym2612ch_mix7_L10:
	;
	xcall ym2612op_mix0			; Fb->[1]
	ld.w %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix1			; 0->[2]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix2			; 0->[3]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r14, %r15
	xld.w %r15, 0
	xcall.d ym2612op_mix3			; 0->[4]
	add %r12, YM2612OP_SIZE			; *delay*
	add %r15, %r14
	xsub %r12, %r12, (YM2612OP_SIZE*3)
	;
	ld.w %r10, [%r13]
	add %r10, %r15				; [1]+[2]+[3]+[4]->Out
	ld.w [%r13]+, %r10
	;
	ld.w %r14, %ahr
	xsub %r14, %r14, 1
	xjrne.d ym2612ch_mix7_L10
	ld.w %ahr, %r14				; *delay* (undoc'd)
	;
	ym2612op_mix_end
	ret

;****************************************************************************
;	
;****************************************************************************

	.global ym2612_copy
ym2612_copy:
	; %r12 = wbuff
	; %r13 = mixbuf
	; %r14 = count
	xld.w %r4, 32767
	not %r5, %r4			; -32768
ym2612_copy_L10:
	ld.w %r6, [%r13]+
	xsra %r6, COPY_SHIFT		; v >>= COPY_SHIFT
	cmp %r6, %r4
	xjrle.d ym2612_copy_L20
	cmp %r6, %r5			; *delay*
	ld.w %r6, %r4
ym2612_copy_L20:
	xjrge.d ym2612_copy_L30
	sub %r14, 1			; *delay*
	ld.w %r6, %r5
ym2612_copy_L30:
	ld.h [%r12]+, %r6
	xjrne ym2612_copy_L10
	ret.d
	ld.w %r10, %r12			; *delay*

;****************************************************************************
;	
;****************************************************************************

#endif /*YM2612_ASM*/
