;
;	framm68a.s
;
;	P/ECE M6800 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipm68a.h"
;/	
;/	clipm68a.h
;/
;/	P/ECE M6800 Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2004 Naoyuki Sawa
;/
;/	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define M6800_ASM
;#ifdef M6800_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	M6800\
;
;*===== WX^ =====*/
;#define CC	 0
;#define D	 2
;#define X	 4
;#define S	 6
;#define PC	 8
;*=====  =====*/
;#define PENDING	10
;#define WAIT	11
;#define CYCLE	12
;*===== O֐ =====*/
;#define READ	16
;#define WRITE	20

;
;	16rbgWX^̏/8rbgANZX
;	G~[VzXg(S1C33,Pentium,etc)Ȃ̂ŁALittleEndianłB
;
;#define A	 3	; HI(D), LittleEndian
;#define B	 2	; LO(D), LittleEndian

;
;	S1C33=>M6800tOϊ
;
;	* ϊ\͕svłB
;	  S1C33M6800{N,Z,V,C}tO͕тĂ̂ŁA
;	  ̂悤Ȏ菇ŕϊł܂B
;
;	S1C33̃tO:	  MD-ICVZN
;				      ||||
;				      VVVV
;	M6800̃tO:	  11HINZVC
;
;	ld.w %r10, %psr		; MD-ICVZN
;	xsll %r10, 4		; CVZN0000
;	mirror %r10, %r10	; 0000NZVC
;

;****************************************************************************
;	
;****************************************************************************

	.global m6800_run
m6800_run:
	pushn %r3
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; m6800
	ext	0x10		; 	xld.w %r3, [%r0+0x10]		; m6800->read
	ld.w	%r3,[%r0]
	ext	0xc		; 	xld.w [%r0+0xc], %r13		; CYCLE
	ld.w	[%r0],%r13
	cmp	%r13,0x0	; 	xcmp %r13, 0			; if(CYCLE <= 0) break
	jrle	m6800_run_exit	; 	xjrle m6800_run_exit
	;
m6800_run_L10:
	ext	0xb		; 	xld.ub %r10, [%r0+0xb]		; if(WAIT) break
	ld.ub	%r10,[%r0]
	ext	0x8		; 	xld.uh %r1, [%r0+0x8]		; PC *anti-interlock*
	ld.uh	%r1,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	jrne	m6800_run_exit	; 	xjrne m6800_run_exit
	;
	ld.uh %r13, %r1			; code = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	ext	m6800_op_table+0x0@h	; 	xld.w %r2, m6800_op_table	; op = &m6800_op_table[code]
	ext	m6800_op_table+0x0@m
	ld.w	%r2,m6800_op_table+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; switch(op->addr)
	ld.ub	%r10,[%r2]
	ext	m6800_run_table+0x0@h	; 	xld.w %r11, m6800_run_table	; *anti-interlock*
	ext	m6800_run_table+0x0@m
	ld.w	%r11,m6800_run_table+0x0@l
	sll	%r10,0x2	; 	xsll %r10, 2
	add %r10, %r11
	ld.w	%r10,[%r10]	; 	xld.w %r10, [%r10]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; *anti-interlock*
	jp %r10
	;
m6800_run_immediate1:
m6800_run_direct:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub %r14, %r10		; arg = arg1
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6800_run_exec	; 	xjp.d m6800_run_exec
	add %r1, 1			; *delay*
	;
m6800_run_indexed:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x4		; 	xld.uh %r14, [%r0+0x4]		; arg = X + arg1
	ld.uh	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.uh %r14, %r14
	;
	jp.d	m6800_run_exec	; 	xjp.d m6800_run_exec
	add %r1, 1			; *delay*
	;
m6800_run_immediate2:
m6800_run_extended:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	sll	%r14,0x8	; 	xsll %r14, 8			; arg = arg1 << 8 | arg2
	or %r14, %r10
	;
	jp.d	m6800_run_exec	; 	xjp.d m6800_run_exec
	add %r1, 1			; *delay*
	;
m6800_run_relative:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b %r14, %r10			; arg = PC + (char)arg1
	add %r14, %r1
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;** fall thru **
	;
m6800_run_inherent:
m6800_run_exec:
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(arg)
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0xc		; 	xld.w %r10, [%r0+0xc]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11			; !INTERLOCK!
	ext	0xc		; 	xld.w [%r0+0xc], %r10
	ld.w	[%r0],%r10
	jrgt	m6800_run_L10	; 	xjrgt m6800_run_L10		; if(CYCLE <= 0) break
m6800_run_exit:
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r3
	ret
	;
	.align 2
m6800_run_table:
	;===== operand bytes=0 =====
	.word m6800_run_inherent	; 0
	;===== operand bytes=1 =====
	.word m6800_run_immediate1	; 1
	.word m6800_run_direct		; 2
	.word m6800_run_indexed		; 3
	.word m6800_run_relative	; 4
	;===== operand bytes=2 =====
	.word m6800_run_immediate2	; 5
	.word m6800_run_extended	; 6
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global m6800_ADD
m6800_ADD:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	ext	0x1fff		; 	xand %r11, %r11, -48		; %r11 = CC(110I0000)
	and	%r11,0x10
	or %r11, %r5			; %r11 = CC(110INZVC)
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	and	%r14,0xf	; 	xand %r14, %r14, 0xf
	add %r13, %r14
	and	%r13,0x10	; 	xand %r13, %r13, 0x10		; %r13 = CC(H)
	sll	%r13,0x1	; 	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b *delay*

	.global m6800_ADC
m6800_ADC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	ext	0x1		; 	xand %r15, %r11, 1		; %r15 = CC(C)
	and	%r15,%r11
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	add %r10, %r4			; %r10[31:24] = a + b + c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	and	%r5,0xc		; 	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	ext	0x4		; 	xand %r7, %r6, 4		; %r7 = %psr(V2)
	and	%r7,%r6
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	and	%r6,0xb		; 	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	ext	0x1fff		; 	xand %r11, %r11, -48		; %r11 = CC(110I0000)
	and	%r11,0x10
	or %r11, %r5			; %r11 = CC(110INZVC)
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	and	%r14,0xf	; 	xand %r14, %r14, 0xf
	add %r13, %r14
	add %r13, %r15			; %r13 = (a & 0xf) + (b & 0xf) + c
	and	%r13,0x10	; 	xand %r13, %r13, 0x10		; %r13 = CC(H)
	sll	%r13,0x1	; 	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b + c *delay*

	.global m6800_SUB
m6800_SUB:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r5			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b *delay*

	.global m6800_SBC
m6800_SBC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	ext	0x1		; 	xand %r15, %r11, 1		; %r15 = CC(C)
	and	%r15,%r11
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	sub %r10, %r4			; %r10[31:24] = a - b - c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	and	%r5,0xc		; 	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	ext	0x4		; 	xand %r7, %r6, 4		; %r7 = %psr(V2)
	and	%r7,%r6
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	and	%r6,0xb		; 	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r5			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b - c *delay*

	.global m6800_ADDW
m6800_ADDW:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	sll	%r13,0x8	; 	xsll %r13, 16			; %r13[31:16] = a
	sll	%r13,0x8
	sll	%r14,0x8	; 	xsll %r14, 16			; %r14[31:16] = b
	sll	%r14,0x8
	add %r13, %r14			; %r13[31:16] = a + b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	srl	%r13,0x8	; 	xsrl %r13, 16			; %r13 = a + b
	srl	%r13,0x8
	ret.d
	ld.w %r10, %r13			; %r10 = a + b *delay*

	.global m6800_SUBW
m6800_SUBW:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	sll	%r13,0x8	; 	xsll %r13, 16			; %r13[31:16] = a
	sll	%r13,0x8
	sll	%r14,0x8	; 	xsll %r14, 16			; %r14[31:16] = b
	sll	%r14,0x8
	sub %r13, %r14			; %r13[31:16] = a - b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	srl	%r13,0x8	; 	xsrl %r13, 16			; %r13 = a - b
	srl	%r13,0x8
	ret.d
	ld.w %r10, %r13			; %r10 = a - b *delay*

	.global m6800_AND
m6800_AND:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	and %r13, %r14			; %r13 = a & b
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a & b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a & b *delay*

	.global m6800_ORA
m6800_ORA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	or %r13, %r14			; %r13 = a | b
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a | b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a | b *delay*

	.global m6800_EOR
m6800_EOR:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	xor %r13, %r14			; %r13 = a ^ b
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a ^ b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a ^ b *delay*

	.global m6800_INC
m6800_INC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	ext	0x20		; 	xadd %r13, %r13, 0x1000000		; %r13[31:24] = a + 1
	ext	0x0
	add	%r13,0x0
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x7	; 	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a + 1 *delay*

	.global m6800_DEC
m6800_DEC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	ext	0x20		; 	xsub %r13, %r13, 0x1000000		; %r13[31:24] = a - 1
	ext	0x0
	sub	%r13,0x0
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x7	; 	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a - 1 *delay*

	.global m6800_COM
m6800_COM:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	ext	0x3		; 	xxor %r13, %r13, 0xff		; %r13 = ~a
	xor	%r13,0x3f
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = ~a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZ00)
	or	%r11,0x1	; 	xoor %r11, %r11, 1		; %r11 = CC(11HINZ01)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = ~a *delay*

	; [1]
	; ʂ0̏ꍇ̂CC(Z)=1,CC(C)=1AȊO͑SCC(Z)=0,CC(C)=0ƂdlłB
	; ʂ0ɂȂ̂́Aa=0̏ꍇłB
	; a=0̏ꍇ̂%psr(C)=0ƂȂAȊO͑S%psr(C)=1ƂȂ܂B
	; Ȃ킿 CC(C)=!%psr(C) łB
	; CC(Z)ɂ%psr(Z)̂܂܎g܂B
	.global m6800_NEG
m6800_NEG:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	ld.w	%r13,0x0	; 	xld.w %r13, 0			; %r13[31:24] = 0
	sub %r13, %r10			; %r13[31:24] = -a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xor	%r10,0x8	; 	xxor %r10, %r10, 8		; %r10 = %psr(MD-ICVZN) [1]
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = -a *delay*

	.global m6800_TST
m6800_TST:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZ00)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************
;	$1($2)
;****************************************************************************

;#macro S1IS2I $1, $2
;	xld.ub %r13, [%r12+$2]
;	xjp m6800_$1
;#endm

	.global m6800op_TSTA_INHERENT
m6800op_TSTA_INHERENT:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2I TST, A
	ld.ub	%r13,[%r12]
	jp	m6800_TST	; 	xjp m6800_TST
	.global m6800op_TSTB_INHERENT
m6800op_TSTB_INHERENT:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2I TST, B
	ld.ub	%r13,[%r12]
	jp	m6800_TST	; 	xjp m6800_TST

;****************************************************************************
;	$1(READ(arg))
;****************************************************************************

;#macro S1IREADIargII $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d m6800_$1
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_TST_ADDRESS
m6800op_TST_ADDRESS:
	pushn %r0	; 	S1IREADIargII TST
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	call.d	m6800_TST	; 	xcall.d m6800_TST
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

;****************************************************************************
;	$1($3,$2)
;****************************************************************************

;#macro S1IS3_S2I $1, $2, $3
;	xld.ub %r13, [%r12+$3]
;	xld.ub %r14, [%r12+$2]
;	xjp m6800_$1
;#endm

	.global m6800op_CBA_INHERENT
m6800op_CBA_INHERENT:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS3_S2I SUB, B, A
	ld.ub	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	ext	m6800_SUB@rm	; 	xjp m6800_SUB
	jp	m6800_SUB@rl

;****************************************************************************
;	$1($2,arg)
;****************************************************************************

;#macro S1IS2_argI $1, $2
;	xld.ub %r13, [%r12+$2]
;	xjp m6800_$1
;#endm

	.global m6800op_CMPA_DATA
m6800op_CMPA_DATA:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2_argI SUB, A
	ld.ub	%r13,[%r12]
	ext	m6800_SUB@rm	; 	xjp m6800_SUB
	jp	m6800_SUB@rl
	.global m6800op_CMPB_DATA
m6800op_CMPB_DATA:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2_argI SUB, B
	ld.ub	%r13,[%r12]
	ext	m6800_SUB@rm	; 	xjp m6800_SUB
	jp	m6800_SUB@rl
	.global m6800op_BITA_DATA
m6800op_BITA_DATA:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2_argI AND, A
	ld.ub	%r13,[%r12]
	ext	m6800_AND@rm	; 	xjp m6800_AND
	jp	m6800_AND@rl
	.global m6800op_BITB_DATA
m6800op_BITB_DATA:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2_argI AND, B
	ld.ub	%r13,[%r12]
	ext	m6800_AND@rm	; 	xjp m6800_AND
	jp	m6800_AND@rl

;****************************************************************************
;	$1($2,READ(arg))
;****************************************************************************

;#macro S1IS2_READIargII $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d m6800_$1		; *delay*
;	ld.w %r12, %r0
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_CMPA_ADDRESS
m6800op_CMPA_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII SUB, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB		; *delay*
	call.d	m6800_SUB@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global m6800op_CMPB_ADDRESS
m6800op_CMPB_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII SUB, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB		; *delay*
	call.d	m6800_SUB@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global m6800op_BITA_ADDRESS
m6800op_BITA_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII AND, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_AND@rm	; 	xcall.d m6800_AND		; *delay*
	call.d	m6800_AND@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global m6800op_BITB_ADDRESS
m6800op_BITB_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII AND, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_AND@rm	; 	xcall.d m6800_AND		; *delay*
	call.d	m6800_AND@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2)
;****************************************************************************

;#macro S2_S1I$2I $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d m6800_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_INCA_INHERENT
m6800op_INCA_INHERENT:
	pushn %r0	; 	S2_S1I$2I INC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_INC@rm	; 	xcall.d m6800_INC
	call.d	m6800_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_INCB_INHERENT
m6800op_INCB_INHERENT:
	pushn %r0	; 	S2_S1I$2I INC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_INC@rm	; 	xcall.d m6800_INC
	call.d	m6800_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_DECA_INHERENT
m6800op_DECA_INHERENT:
	pushn %r0	; 	S2_S1I$2I DEC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_DEC@rm	; 	xcall.d m6800_DEC
	call.d	m6800_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_DECB_INHERENT
m6800op_DECB_INHERENT:
	pushn %r0	; 	S2_S1I$2I DEC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_DEC@rm	; 	xcall.d m6800_DEC
	call.d	m6800_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_COMA_INHERENT
m6800op_COMA_INHERENT:
	pushn %r0	; 	S2_S1I$2I COM, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_COM@rm	; 	xcall.d m6800_COM
	call.d	m6800_COM@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_COMB_INHERENT
m6800op_COMB_INHERENT:
	pushn %r0	; 	S2_S1I$2I COM, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_COM@rm	; 	xcall.d m6800_COM
	call.d	m6800_COM@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_NEGA_INHERENT
m6800op_NEGA_INHERENT:
	pushn %r0	; 	S2_S1I$2I NEG, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_NEG@rm	; 	xcall.d m6800_NEG
	call.d	m6800_NEG@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_NEGB_INHERENT
m6800op_NEGB_INHERENT:
	pushn %r0	; 	S2_S1I$2I NEG, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_NEG@rm	; 	xcall.d m6800_NEG
	call.d	m6800_NEG@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ROLA_INHERENT
m6800op_ROLA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROL, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ROL@rm	; 	xcall.d m6800_ROL
	call.d	m6800_ROL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ROLB_INHERENT
m6800op_ROLB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROL, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ROL@rm	; 	xcall.d m6800_ROL
	call.d	m6800_ROL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_RORA_INHERENT
m6800op_RORA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ROR@rm	; 	xcall.d m6800_ROR
	call.d	m6800_ROR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_RORB_INHERENT
m6800op_RORB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ROR@rm	; 	xcall.d m6800_ROR
	call.d	m6800_ROR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ASLA_INHERENT
m6800op_ASLA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASL, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ASL@rm	; 	xcall.d m6800_ASL
	call.d	m6800_ASL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ASLB_INHERENT
m6800op_ASLB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASL, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ASL@rm	; 	xcall.d m6800_ASL
	call.d	m6800_ASL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ASRA_INHERENT
m6800op_ASRA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ASR@rm	; 	xcall.d m6800_ASR
	call.d	m6800_ASR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ASRB_INHERENT
m6800op_ASRB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ASR@rm	; 	xcall.d m6800_ASR
	call.d	m6800_ASR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_LSRA_INHERENT
m6800op_LSRA_INHERENT:
	pushn %r0	; 	S2_S1I$2I LSR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_LSR@rm	; 	xcall.d m6800_LSR
	call.d	m6800_LSR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_LSRB_INHERENT
m6800op_LSRB_INHERENT:
	pushn %r0	; 	S2_S1I$2I LSR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_LSR@rm	; 	xcall.d m6800_LSR
	call.d	m6800_LSR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2,arg)
;****************************************************************************

;#macro S2_S1IS2_argI $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d m6800_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_ADDA_DATA
m6800op_ADDA_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADD, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ADD@rm	; 	xcall.d m6800_ADD
	call.d	m6800_ADD@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ADDB_DATA
m6800op_ADDB_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADD, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ADD@rm	; 	xcall.d m6800_ADD
	call.d	m6800_ADD@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ADCA_DATA
m6800op_ADCA_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ADC@rm	; 	xcall.d m6800_ADC
	call.d	m6800_ADC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ADCB_DATA
m6800op_ADCB_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ADC@rm	; 	xcall.d m6800_ADC
	call.d	m6800_ADC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SUBA_DATA
m6800op_SUBA_DATA:
	pushn %r0	; 	S2_S1IS2_argI SUB, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB
	call.d	m6800_SUB@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SUBB_DATA
m6800op_SUBB_DATA:
	pushn %r0	; 	S2_S1IS2_argI SUB, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB
	call.d	m6800_SUB@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SBCA_DATA
m6800op_SBCA_DATA:
	pushn %r0	; 	S2_S1IS2_argI SBC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_SBC@rm	; 	xcall.d m6800_SBC
	call.d	m6800_SBC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SBCB_DATA
m6800op_SBCB_DATA:
	pushn %r0	; 	S2_S1IS2_argI SBC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_SBC@rm	; 	xcall.d m6800_SBC
	call.d	m6800_SBC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ANDA_DATA
m6800op_ANDA_DATA:
	pushn %r0	; 	S2_S1IS2_argI AND, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_AND@rm	; 	xcall.d m6800_AND
	call.d	m6800_AND@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ANDB_DATA
m6800op_ANDB_DATA:
	pushn %r0	; 	S2_S1IS2_argI AND, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_AND@rm	; 	xcall.d m6800_AND
	call.d	m6800_AND@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ORAA_DATA
m6800op_ORAA_DATA:
	pushn %r0	; 	S2_S1IS2_argI ORA, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_ORA@rm	; 	xcall.d m6800_ORA
	call.d	m6800_ORA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ORAB_DATA
m6800op_ORAB_DATA:
	pushn %r0	; 	S2_S1IS2_argI ORA, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_ORA@rm	; 	xcall.d m6800_ORA
	call.d	m6800_ORA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_EORA_DATA
m6800op_EORA_DATA:
	pushn %r0	; 	S2_S1IS2_argI EOR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6800_EOR@rm	; 	xcall.d m6800_EOR
	call.d	m6800_EOR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_EORB_DATA
m6800op_EORB_DATA:
	pushn %r0	; 	S2_S1IS2_argI EOR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6800_EOR@rm	; 	xcall.d m6800_EOR
	call.d	m6800_EOR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$3=$1($3,$2)
;****************************************************************************

;#macro S3_S1IS3_S2I $1, $2, $3
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$3]
;	xld.ub %r14, [%r12+$2]
;	xcall.d m6800_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$3], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_ABA_INHERENT
m6800op_ABA_INHERENT:
	pushn %r0	; 	S3_S1IS3_S2I ADD, B, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	ext	m6800_ADD@rm	; 	xcall.d m6800_ADD
	call.d	m6800_ADD@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SBA_INHERENT
m6800op_SBA_INHERENT:
	pushn %r0	; 	S3_S1IS3_S2I SUB, B, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB
	call.d	m6800_SUB@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2,READ(arg))
;****************************************************************************

;#macro S2_S1IS2_READIargII $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d m6800_$1		; *delay*
;	ld.w %r12, %r0
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_ADDA_ADDRESS
m6800op_ADDA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADD, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_ADD@rm	; 	xcall.d m6800_ADD		; *delay*
	call.d	m6800_ADD@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ADDB_ADDRESS
m6800op_ADDB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADD, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_ADD@rm	; 	xcall.d m6800_ADD		; *delay*
	call.d	m6800_ADD@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ADCA_ADDRESS
m6800op_ADCA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADC, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_ADC@rm	; 	xcall.d m6800_ADC		; *delay*
	call.d	m6800_ADC@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ADCB_ADDRESS
m6800op_ADCB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADC, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_ADC@rm	; 	xcall.d m6800_ADC		; *delay*
	call.d	m6800_ADC@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SUBA_ADDRESS
m6800op_SUBA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SUB, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB		; *delay*
	call.d	m6800_SUB@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SUBB_ADDRESS
m6800op_SUBB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SUB, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_SUB@rm	; 	xcall.d m6800_SUB		; *delay*
	call.d	m6800_SUB@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SBCA_ADDRESS
m6800op_SBCA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SBC, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_SBC@rm	; 	xcall.d m6800_SBC		; *delay*
	call.d	m6800_SBC@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_SBCB_ADDRESS
m6800op_SBCB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SBC, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_SBC@rm	; 	xcall.d m6800_SBC		; *delay*
	call.d	m6800_SBC@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ANDA_ADDRESS
m6800op_ANDA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII AND, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_AND@rm	; 	xcall.d m6800_AND		; *delay*
	call.d	m6800_AND@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ANDB_ADDRESS
m6800op_ANDB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII AND, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_AND@rm	; 	xcall.d m6800_AND		; *delay*
	call.d	m6800_AND@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ORAA_ADDRESS
m6800op_ORAA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ORA, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_ORA@rm	; 	xcall.d m6800_ORA		; *delay*
	call.d	m6800_ORA@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_ORAB_ADDRESS
m6800op_ORAB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ORA, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_ORA@rm	; 	xcall.d m6800_ORA		; *delay*
	call.d	m6800_ORA@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_EORA_ADDRESS
m6800op_EORA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII EOR, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6800_EOR@rm	; 	xcall.d m6800_EOR		; *delay*
	call.d	m6800_EOR@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_EORB_ADDRESS
m6800op_EORB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII EOR, B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6800_EOR@rm	; 	xcall.d m6800_EOR		; *delay*
	call.d	m6800_EOR@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	WRITE(arg,$1(READ(arg)))
;****************************************************************************

;#macro WRITEIarg_S1IREADIargIII $1
;	pushn %r1
;	ld.w %r1, %r14
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d m6800_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

	.global m6800op_INC_ADDRESS
m6800op_INC_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII INC
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_INC@rm	; 	xcall.d m6800_INC
	call.d	m6800_INC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_DEC_ADDRESS
m6800op_DEC_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII DEC
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_DEC@rm	; 	xcall.d m6800_DEC
	call.d	m6800_DEC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_COM_ADDRESS
m6800op_COM_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII COM
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_COM@rm	; 	xcall.d m6800_COM
	call.d	m6800_COM@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_NEG_ADDRESS
m6800op_NEG_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII NEG
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_NEG@rm	; 	xcall.d m6800_NEG
	call.d	m6800_NEG@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_ROL_ADDRESS
m6800op_ROL_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ROL
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_ROL@rm	; 	xcall.d m6800_ROL
	call.d	m6800_ROL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_ROR_ADDRESS
m6800op_ROR_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ROR
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_ROR@rm	; 	xcall.d m6800_ROR
	call.d	m6800_ROR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_ASL_ADDRESS
m6800op_ASL_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ASL
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_ASL@rm	; 	xcall.d m6800_ASL
	call.d	m6800_ASL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_ASR_ADDRESS
m6800op_ASR_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ASR
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_ASR@rm	; 	xcall.d m6800_ASR
	call.d	m6800_ASR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6800op_LSR_ADDRESS
m6800op_LSR_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII LSR
	ld.w %r1, %r14
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6800_LSR@rm	; 	xcall.d m6800_LSR
	call.d	m6800_LSR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	Others
;****************************************************************************

;#macro Trr_INHERENT $1, $2
;	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
;	xld.ub %r10, [%r12+$1]		; $2 = $1
;	xld.b [%r12+$2], %r10
	;
;	xrr %r10, 8			; %r10[31:24] = $2
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
;	or %r11, %r10			; %r11 = CC(11HINZ0C)
;	xld.b [%r12+CC], %r11
	;
;	ret
;#endm

	.global m6800op_TAB_INHERENT
m6800op_TAB_INHERENT:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	Trr_INHERENT A, B
	;
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]		; $2 = $1
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8			; %r10[31:24] = $2
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global m6800op_TBA_INHERENT
m6800op_TBA_INHERENT:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	Trr_INHERENT B, A
	;
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]		; $2 = $1
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8			; %r10[31:24] = $2
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

;#macro CLRr_INHERENT $1
;	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
;	xld.b [%r12+$1], %r8		; $1 = 0 *anti-interlock*
	;
;	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
;	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
;	xld.b [%r12+CC], %r11
	;
;	ret
;#endm

	.global m6800op_CLRA_INHERENT
m6800op_CLRA_INHERENT:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	CLRr_INHERENT A
	;
	ext	0x3		; 	xld.b [%r12+0x3], %r8		; $1 = 0 *anti-interlock*
	ld.b	[%r12],%r8
	;
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or	%r11,0x4	; 	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global m6800op_CLRB_INHERENT
m6800op_CLRB_INHERENT:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	CLRr_INHERENT B
	;
	ext	0x2		; 	xld.b [%r12+0x2], %r8		; $1 = 0 *anti-interlock*
	ld.b	[%r12],%r8
	;
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000)
	or	%r11,0x4	; 	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

;#macro CLR_ADDRESS
;	pushn %r0
	;
;	xld.w %r10, [%r12+WRITE]	; WRITE(arg, 0)
;	ld.w %r13, %r14
;	xld.w %r14, 0
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.ub %r11, [%r0+CC]		; %r11 = CC
;	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000) !INTERLOCK!
;	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
;	xld.b [%r0+CC], %r11
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_CLR_ADDRESS
m6800op_CLR_ADDRESS:
	pushn %r0	; 	CLR_ADDRESS
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; WRITE(arg, 0)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ld.w	%r14,0x0	; 	xld.w %r14, 0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(11HI0000) !INTERLOCK!
	or	%r11,0x4	; 	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************

;#macro STAr_ADDRESS $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+WRITE]	; WRITE(arg, $1)
;	ld.w %r13, %r14
;	xld.ub %r14, [%r12+$1]
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.ub %r10, [%r0+$1]		; %r10 = $1
;	xld.ub %r11, [%r0+CC]		; %r11 = CC *anti-interlock*
;	xrr %r10, 8			; %r10[31:24] = $1
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
;	or %r11, %r10			; %r11 = CC(11HINZ0C)
;	xld.b [%r0+CC], %r11
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_STAA_ADDRESS
m6800op_STAA_ADDRESS:
	pushn %r0	; 	STAr_ADDRESS A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; WRITE(arg, $1)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x3		; 	xld.ub %r10, [%r0+0x3]		; %r10 = $1
	ld.ub	%r10,[%r0]
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC *anti-interlock*
	rr	%r10,0x8	; 	xrr %r10, 8			; %r10[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global m6800op_STAB_ADDRESS
m6800op_STAB_ADDRESS:
	pushn %r0	; 	STAr_ADDRESS B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; WRITE(arg, $1)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x2		; 	xld.ub %r10, [%r0+0x2]		; %r10 = $1
	ld.ub	%r10,[%r0]
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC *anti-interlock*
	rr	%r10,0x8	; 	xrr %r10, 8			; %r10[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************

;#macro LDAr_DATA $1
;	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
;	xld.b [%r12+$1], %r14		; $1 = arg
	;
;	xrr %r14, 8			; %r14[31:24] = $1
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
;	or %r11, %r10			; %r11 = CC(11HINZ0C)
;	xld.b [%r12+CC], %r11
	;
;	ret
;#endm

	.global m6800op_LDAA_DATA
m6800op_LDAA_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	LDAr_DATA A
	;
	ext	0x3		; 	xld.b [%r12+0x3], %r14		; $1 = arg
	ld.b	[%r12],%r14
	;
	rr	%r14,0x8	; 	xrr %r14, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global m6800op_LDAB_DATA
m6800op_LDAB_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	LDAr_DATA B
	;
	ext	0x2		; 	xld.b [%r12+0x2], %r14		; $1 = arg
	ld.b	[%r12],%r14
	;
	rr	%r14,0x8	; 	xrr %r14, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

;#macro LDAr_ADDRESS $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.b [%r0+$1], %r10		; $1 = READ(arg)
	;
;	xld.ub %r11, [%r0+CC]		; %r11 = CC
	;
;	xrr %r10, 8			; %r14[31:24] = $1
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
;	or %r11, %r10			; %r11 = CC(11HINZ0C)
;	xld.b [%r0+CC], %r11
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_LDAA_ADDRESS
m6800op_LDAA_ADDRESS:
	pushn %r0	; 	LDAr_ADDRESS A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x3		; 	xld.b [%r0+0x3], %r10		; $1 = READ(arg)
	ld.b	[%r0],%r10
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC
	;
	rr	%r10,0x8	; 	xrr %r10, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global m6800op_LDAB_ADDRESS
m6800op_LDAB_ADDRESS:
	pushn %r0	; 	LDAr_ADDRESS B
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x2		; 	xld.b [%r0+0x2], %r10		; $1 = READ(arg)
	ld.b	[%r0],%r10
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC
	;
	rr	%r10,0x8	; 	xrr %r10, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************

;#macro PSHr_INHERENT $1
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+S]
;	xld.ub %r14, [%r12+$1]		; *anti-interlock*
;	xsub %r11, %r13, 1
;	xld.h [%r12+S], %r11
;	call %r10
;	ret
;#endm

	.global m6800op_PSHA_INHERENT
m6800op_PSHA_INHERENT:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PSHr_INHERENT A
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]		; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x6		; 	xld.h [%r12+0x6], %r11
	ld.h	[%r12],%r11
	call %r10
	ret
	.global m6800op_PSHB_INHERENT
m6800op_PSHB_INHERENT:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PSHr_INHERENT B
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]		; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x6		; 	xld.h [%r12+0x6], %r11
	ld.h	[%r12],%r11
	call %r10
	ret

;****************************************************************************

;#macro PULr_INHERENT $1
;	pushn %r0
	;
;	xld.uh %r13, [%r12+S]
;	xld.w %r10, [%r12+READ]		; *anti-interlock*
;	xadd %r13, %r13, 1
;	xld.h [%r12+S], %r13
;	ld.uh %r13, %r13
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$1], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6800op_PULA_INHERENT
m6800op_PULA_INHERENT:
	pushn %r0	; 	PULr_INHERENT A
	;
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.h [%r12+0x6], %r13
	ld.h	[%r12],%r13
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6800op_PULB_INHERENT
m6800op_PULB_INHERENT:
	pushn %r0	; 	PULr_INHERENT B
	;
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.h [%r12+0x6], %r13
	ld.h	[%r12],%r13
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	JUMP AND BRANCH
;****************************************************************************

	.global m6800op_JMP_ADDRESS
	.global m6800op_BRA_ADDRESS
m6800op_JMP_ADDRESS:
m6800op_BRA_ADDRESS:
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
	ret

;****************************************************************************

	.global m6800op_JSR_ADDRESS
	.global m6800op_BSR_ADDRESS
m6800op_BSR_ADDRESS:
m6800op_JSR_ADDRESS:
	pushn %r2
	;
	ext	0x6		; 	xld.uh %r1, [%r12+0x6]		; S
	ld.uh	%r1,[%r12]
	ext	0x8		; 	xld.uh %r2, [%r12+0x8]		; PC
	ld.uh	%r2,[%r12]
	;
	ext	0x8		; 	xld.h [%r12+0x8], %r14		; PC <= arg
	ld.h	[%r12],%r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; PUSH(PCL)
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; S--
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; PUSH(PCH)
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ld.uh %r14, %r2
	srl	%r14,0x8	; 	xsrl %r14, 8
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; S--
	ext	0x6		; 	xld.h [%r0+0x6], %r1
	ld.h	[%r0],%r1
	;
	popn %r2
	ret

;****************************************************************************

	.global m6800op_RTS_INHERENT
m6800op_RTS_INHERENT:
	pushn %r2
	;
	ext	0x6		; 	xld.uh %r1, [%r12+0x6]		; S
	ld.uh	%r1,[%r12]
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; POP(PCH)
	ld.w	%r10,[%r12]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; S++
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r2, %r10			; (save PCH)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; POP(PCL)
	ld.w	%r10,[%r0]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; S++
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	sll	%r2,0x8		; 	xsll %r2, 8			; PC <= PCH << 8 | PCL
	or %r2, %r10
	ext	0x8		; 	xld.h [%r0+0x8], %r2
	ld.h	[%r0],%r2
	;
	ext	0x6		; 	xld.h [%r0+0x6], %r1		; S
	ld.h	[%r0],%r1
	;
	popn %r2
	ret

;****************************************************************************

;* Branch if Flag is Clear */
;#macro Bfc_ADDRESS $1
;	xbtst [%r12+CC], $1
;	xjrne $$1			; if(flag is 1) no-jump
;	xld.h [%r12+PC], %r14
;$$1:
;	ret
;#endm

	.global m6800op_BCC_ADDRESS
m6800op_BCC_ADDRESS:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	Bfc_ADDRESS 0
	jrne	__LX0001	; 	xjrne __L0001			; if(flag is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0001:				; __L0001:
	ret
	.global m6800op_BVC_ADDRESS
m6800op_BVC_ADDRESS:
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1	; 	Bfc_ADDRESS 1
	jrne	__LX0002	; 	xjrne __L0002			; if(flag is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0002:				; __L0002:
	ret
	.global m6800op_BNE_ADDRESS
m6800op_BNE_ADDRESS:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	Bfc_ADDRESS 2
	jrne	__LX0003	; 	xjrne __L0003			; if(flag is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0003:				; __L0003:
	ret
	.global m6800op_BPL_ADDRESS
m6800op_BPL_ADDRESS:
	btst	[%r12],0x3	; 	xbtst [%r12+0x0], 0x3	; 	Bfc_ADDRESS 3
	jrne	__LX0004	; 	xjrne __L0004			; if(flag is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0004:				; __L0004:
	ret

;****************************************************************************

;* Branch if Flag is Set */
;#macro Bfs_ADDRESS $1
;	xbtst [%r12+CC], $1
;	xjreq $$1			; if(flag is 0) no-jump
;	xld.h [%r12+PC], %r14
;$$1:
;	ret
;#endm

	.global m6800op_BCS_ADDRESS
m6800op_BCS_ADDRESS:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	Bfs_ADDRESS 0
	jreq	__LX0005	; 	xjreq __L0005			; if(flag is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0005:				; __L0005:
	ret
	.global m6800op_BVS_ADDRESS
m6800op_BVS_ADDRESS:
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1	; 	Bfs_ADDRESS 1
	jreq	__LX0006	; 	xjreq __L0006			; if(flag is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0006:				; __L0006:
	ret
	.global m6800op_BEQ_ADDRESS
m6800op_BEQ_ADDRESS:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	Bfs_ADDRESS 2
	jreq	__LX0007	; 	xjreq __L0007			; if(flag is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0007:				; __L0007:
	ret
	.global m6800op_BMI_ADDRESS
m6800op_BMI_ADDRESS:
	btst	[%r12],0x3	; 	xbtst [%r12+0x0], 0x3	; 	Bfs_ADDRESS 3
	jreq	__LX0008	; 	xjreq __L0008			; if(flag is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
__LX0008:				; __L0008:
	ret

;****************************************************************************

	.global m6800op_BGE_ADDRESS
m6800op_BGE_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jrne	m6800op_BGE_ADDRESS_L10	; 	xjrne m6800op_BGE_ADDRESS_L10	; if(N^V is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
m6800op_BGE_ADDRESS_L10:
	ret

	.global m6800op_BLT_ADDRESS
m6800op_BLT_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jreq	m6800op_BLT_ADDRESS_L10	; 	xjreq m6800op_BLT_ADDRESS_L10	; if(N^V is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
m6800op_BLT_ADDRESS_L10:
	ret

;
	.global m6800op_BGT_ADDRESS
m6800op_BGT_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	rl	%r11,0x1	; 	xrl %r11, 1			; %r11 = 011HINZV
	or %r10, %r11			;              +- (N^V)|Z
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jrne	m6800op_BGT_ADDRESS_L10	; 	xjrne m6800op_BGT_ADDRESS_L10	; if((N^V)|Z is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
m6800op_BGT_ADDRESS_L10:
	ret

;
	.global m6800op_BLE_ADDRESS
m6800op_BLE_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	rl	%r11,0x1	; 	xrl %r11, 1			; %r11 = 011HINZV
	or %r10, %r11			;              +- (N^V)|Z
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jreq	m6800op_BLE_ADDRESS_L10	; 	xjreq m6800op_BLE_ADDRESS_L10	; if((N^V)|Z is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
m6800op_BLE_ADDRESS_L10:
	ret

;
	.global m6800op_BHI_ADDRESS
m6800op_BHI_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = 11HINZVC
	and	%r10,0x5	; 	xand %r10, %r10, 5		; %r10 = 00000Z0C
	jrne	m6800op_BHI_ADDRESS_L10	; 	xjrne m6800op_BHI_ADDRESS_L10	; if(Z|C is 1) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
m6800op_BHI_ADDRESS_L10:
	ret

;
	.global m6800op_BLS_ADDRESS
m6800op_BLS_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = 11HINZVC
	and	%r10,0x5	; 	xand %r10, %r10, 5		; %r10 = 00000Z0C
	jreq	m6800op_BLS_ADDRESS_L10	; 	xjreq m6800op_BLS_ADDRESS_L10	; if(Z|C is 0) no-jump
	ext	0x8		; 	xld.h [%r12+0x8], %r14
	ld.h	[%r12],%r14
m6800op_BLS_ADDRESS_L10:
	ret

;****************************************************************************
;
;****************************************************************************

;#endif /*M6800_ASM*/
