/*	
 *	clipm69.h
 *
 *	P/ECE M6809 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_M69_H__
#define __CLIP_M69_H__

/****************************************************************************
 *
 ****************************************************************************/

/* M6809_ASMV{`ǂݍ݂܂B
 * M6809_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipm69a.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define M6809_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef M6809_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef M6809_ASM
#undef M6809_TRACE
#endif /*M6809_ASM*/ 

#ifdef M6809_TRACE
#define M6809TRACE	TRACE
#else /*M6809_TRACE*/
#define M6809TRACE	1 ? ((void)0) : TRACE
#endif /*M6809_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _M6809 M6809;

/*
 *	M6809RAO֐̌^`
 */
typedef unsigned char M6809READPROC (M6809* m6809, unsigned short addr);
typedef          void M6809WRITEPROC(M6809* m6809, unsigned short addr, unsigned char data);

/*
 *	M6809RA
 */
/*typedef*/ struct _M6809 {
	/*===== WX^ =====*/
	unsigned char cc;		/* + 0, 1 */
	unsigned char dp;		/* + 1, 1 */
	unsigned short d;		/* + 2, 2 */
	unsigned short x;		/* + 4, 2 */
	unsigned short y;		/* + 6, 2 */
	unsigned short u;		/* + 8, 2 */
	unsigned short s;		/* +10, 2 */
	unsigned short pc;		/* +12, 2 */
	/*=====  =====*/
	unsigned char pending;		/* +14, 1 */
	unsigned char wait;		/* +15, 1 */
	int cycle;			/* +16, 4 */
	/*===== O֐ =====*/
	M6809READPROC* read;		/* +20, 4 */
	M6809WRITEPROC* write;		/* +24, 4 */
} /*M6809*/;				/* =28    */

/* M6809.pending */
#define M6809_FIRQ_PENDING	(1 << 0)	/* FIRQۗ (Dx) */
#define M6809_IRQ_PENDING	(1 << 1)	/* IRQ ۗ (Dx) */

/*
 *	ZbgE荞݃xN^
 */
#define M6809_RESET_VECTOR	0xfffe		/* Reset (#RESET) */
#define M6809_NMI_VECTOR	0xfffc		/* Non-Maskable Interrupt (#NMI) */
#define M6809_SWI_VECTOR	0xfffa		/* Software Interrupt (SWI) */
#define M6809_IRQ_VECTOR	0xfff8		/* Interrupt Request (#IRQ) */
#define M6809_FIRQ_VECTOR	0xfff6		/* Fast Interrupt Request (#FIRQ) */
#define M6809_SWI2_VECTOR	0xfff4		/* Software Interrupt 2 (SWI2) */
#define M6809_SWI3_VECTOR	0xfff2		/* Software Interrupt 3 (SWI3) */
#define M6809_RESERVED_VECTOR	0xfff0		/* Reserved */

/*
 *	CXgNV֐錾
 */
typedef                  void M6809OPPROC (M6809* m6809, int code, int arg);
#define M6809FN_(OP, FN) void m6809op_##FN(M6809* m6809, int code, int arg);	/* 錾p */
#include "m6809/list.h" /* [m6809.xls]List */
M6809FN_("10_INHERENT" , 10_INHERENT )
M6809FN_("11_INHERENT" , 11_INHERENT )
M6809FN_("ERR_INHERENT", ERR_INHERENT)
#undef  M6809FN_
#define M6809FN_(    FN) void m6809op_##FN(M6809* m6809, int code, int arg)	/* `p */

/*
 *	IyR[h}bvECXgNVe[u
 */
typedef struct _M6809OP {
	M6809OPPROC* proc;	/* + 0, 4 */
	unsigned char addr;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 m6809_op_name_table[]̕ւ̃ItZbgł */
} M6809OP;			/* = 8    */
#define M6809OP_(CODE, MNEMONIC, ADDRMODE, FUNCTYPE, CYCLE, NAME)	{ m6809op_##MNEMONIC##_##FUNCTYPE, M6809_##ADDRMODE, CYCLE, 0x##NAME },
extern const M6809OP m6809_op_table[256/*XX*/];		/* opcode = XX */
extern const M6809OP m6809_op_table_10[256/*XX*/];	/* opcode = 10XX */
extern const M6809OP m6809_op_table_11[256/*XX*/];	/* opcode = 11XX */
extern const char m6809_op_name_table[];	/* CXgNVe[u */

/***** M6809OP.addr *****/
/*==== operand bytes=0 ====*/
#define M6809_INHERENT		0
/*==== operand bytes=1 ====*/
#define M6809_IMMEDIATE1	1
#define M6809_DIRECT		2
#define M6809_RELATIVE1		3
/*==== operand bytes=2 ====*/
#define M6809_IMMEDIATE2	4
#define M6809_EXTENDED		5
#define M6809_RELATIVE2		6
/*==== operand bytes=? ====*/
#define M6809_INDEXED		7

/****************************************************************************
 *	֐
 ****************************************************************************/

/* M6809Zbgɐݒ肳AM6809RÃCREAD/WRITE̊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char m6809_internal_read (M6809* m6809, unsigned short addr);
         void m6809_internal_write(M6809* m6809, unsigned short addr, unsigned char data);

/* ۗĂ}XN\荞݂AĂ犄荞݂s܂B
 * CC(I,F)܂PENDINGω\̂鏈sɁAKĂяoĂB
 */
void m6809_check_pending(M6809* m6809);

/* 荞݂s܂B
 */
void m6809_int(M6809* m6809, int vector, int entire);

/* 荞݂畜A܂B
 */
void m6809_rti(M6809* m6809);

/* 1߂܂1voCgtFb`As܂B
 */
void m6809_one(M6809* m6809, const M6809OP op_table[/*256*/]);

/* CfNXAhbVO܂B
 */
int m6809_indexed(M6809* m6809);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* M6809Zbg܂B
 * [in]
 *	m6809		M6809\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 * [note]
 *	* read,writeNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EREAD	M6809\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  EWRITE	M6809\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 */
void m6809_reset(M6809* m6809, M6809READPROC* read, M6809WRITEPROC* write);

/* M6809s܂B
 * [in]
 *	m6809		M6809\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂WAITԂɂȂ܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAm6809->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇAm6809->cycle=-5 ƂȂ܂B
 */
void m6809_run(M6809* m6809, int cycle);

/* }XNs荞(NMI)NGXg𔭍s܂B
 * [in]
 *	m6809		M6809\́B
 * [note]
 *	* ΂Dx荞݃NGXgłB
 *	* }XNs\荞݃NGXǵAɎ󂯕t܂B
 *	* CC(E)ZbgđSWX^ޔACC(I,F)Zbg(=֎~)܂B
 */
void m6809_nmi(M6809* m6809);

/* }XN\荞(FIRQ)NGXg𔭍s܂B
 * [in]
 *	m6809		M6809\́B
 * [note]
 *	* NMIDxႭAIRQDx荞݃NGXgłB
 *	* CC(F)ZbgĂA荞݃NGXg͕ۗ܂B
 *	  CC(F)NAꂽƂɁA荞ݏs܂B
 *	* CC(E)NA{PC,CC}ޔACC(I,F)Zbg(=֎~)܂B
 */
void m6809_firq(M6809* m6809);

/* }XN\荞(IRQ)NGXg𔭍s܂B
 * [in]
 *	m6809		M6809\́B
 * [note]
 *	* ΂DxႢ荞݃NGXgłB
 *	* CC(I)ZbgĂA荞݃NGXg͕ۗ܂B
 *	  CC(I)NAꂽƂɁA荞ݏs܂B
 *	* CC(E)ZbgđSWX^ޔACC(I)Zbg(=֎~)܂B
 */
void m6809_irq(M6809* m6809);

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	m6809		M6809\́B
 */
void m6809_dump(M6809* m6809);

#ifdef PIECE
/* M6809s܂B(X^bNؑցE)
 * [in]
 *	m6809		M6809\́B
 *	cycle		sTCNB
 * [note]
 *	* m6809_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- m6809_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  m6809_run2()̓X^bN0x1000ɈڂAm6809_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAm6809_run2()̎gpɂ͏܂B
 *	  Em6809_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Em6809_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Em6809_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAm6809_run2()̎gpɂ͏[ȒӂKvłB
 *	  m6809_run()gꍇɊrׂāAm6809_run2()gꍇ̌ʂ́A20%̍ƂȂ܂B
 */
void m6809_run2(M6809* m6809, int cycle);
#endif /*PIECE*/

#endif /*__CLIP_M69_H__*/
