/*	
 *	clipir.h
 *
 *	ԊOʐM (24/48MHzΉ)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sat Mar 05 15:53:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_IR_H__
#define __CLIP_IR_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* ʐMtH[}bgݒ肵܂B
 * [in]
 *	mode		1: P/ECE Kernel̐ԊOʐMƌ݊̃tH[}bgB
 *			   P/ECEWAPIpceIRStartRx/Tx()ƒʐMł܂B
 *			0: P/ECE Kernel̐ԊOʐMƔ݊̃tH[}bgB
 *			   P/ECEWAPIpceIRStartRx/Tx()ƒʐMł܂B
 *			   ̑ɁAłB
 * [note]
 *	- ʐMtH[}bg̏ĺA1: ݊[h łB
 *	- ʐMtH[}bǵAir_send/recv()ŒʐMJnOɐݒ肵ĂB
 *	  ir_stop()ŒʐM~ĂAʐMtH[}bg̐ݒ͈ێ܂B
 *	- ir_send/recv()ł̒ʐMɃ[h؂ւ悤ƂƁAAT[g܂B
 *	- ݊[hƔ݊[ḧႢ́A̒ʂłB
 *	  1. P/ECE Kernel̐ԊOʐḾAMf[^̊eoCĝ܂܃GR[hđôł͂ȂA
 *	     CRC32e[u̒lƂXorĂGR[hĂ܂B
 *	     ̂悤ɂ邱ƂɂāAǂȌʂ̂sȂ̂łAdlɂȂĂ܂B
 *	     - ݊[h́A̎dlɍ킹āACRC32e[u̒l߁AXorĂGR[h܂B
 *	     - ݊[h́AMf[^̊eoCĝ܂܃GR[h܂B
 *	  2. P/ECE Kernel̐ԊOʐḾAM̑ooCgAM̗voCgȂꍇɁA
 *	     Mf[^ubÑg[oāAM𒆒fł悤ɂȂĂ܂B
 *	     AԊOʐMAPIAvP[V֎ۂ̎MoCgʒm@\̂ŁA
 *	     ʐMf[^Ɏۂ̃TCY𖄂ߍޕKv܂B
 *	     - ݊[h́A̎dlɍ킹邽߂ɁAMɂăg[𑗏oĂ܂B
 *	     - ݊[hł́AMƎMoCgłƉ肵Ag[𑗏o܂B
 *	       M̗voCg̕Ȃꍇ́Air_stop()ŖIɒ~܂ŁAMf[^҂܂B
 *	       g[𑗏oȂԂ񍂑Ȃ̂ŁAȃf[^ubNpɂɒʐMꍇɗLłB
 *	     - ݊[hł́AMMƂɁA܂M̓g[ỏ\܂B
 *	       ̂߁AMɕԑf[^𑗐MƁA܂葤MłĂȂ\܂B
 *	       ݊[hł́AM̎Mɂ͕KAM̑MĂ܂B
 *	       M MM ̐؂ւ[ɍȂ΁Aɕԑf[^𑗐MĂvłB
 *	       ɑM݂ɐ؂ւĒʐMsꍇ́A݊[h𗘗pĂB
 */
void ir_mode(int mode);

/* ԊOŃf[^𑗐M܂B
 * [in]
 *	data		Mf[^̐擪AhXB
 *	len		Mf[^̃oCgB
 *			1oCg̒ʐM͕słB(AT[g܂)
 *	callback	MR[obNB
 *			NULLw肷ƁAR[obN͌Ăяo܂B
 * [note]
 *	- ̊֐́AʐM҂ɂɏԂ܂B
 *	  ʐḾAR[obNA܂ir_stat()ĂяoĔ肵ĂB
 *	  ʐM܂ŁAdata̓ej󂵂Ă͂܂B
 *	- ʐMƁAIir_stop()Ăяo܂B
 *	  Iir_stop()ĂяoKv͗L܂B(Ăł\܂B)
 *	- ʐMOɒʐM𒆒fɂ́Air_stop()ĂяoĂB
 *	  ʐM𒆒fꍇ́AR[obN͌Ăяo܂B!!
 *	- R[obNĂяoOɁAɎIir_stop()Ă΂Ă܂B
 *	  R[obN̒ŁAir_stop()ĂԕKv͂܂B(Ăł\܂B)
 *	  ܂AR[obN̒ŒɎ̒ʐMJn邱Ƃł܂B
 *	- 24MHz/48MHzǂ̃NbNłg܂B
 *	  AʐM̓NbN؂ւȂŉB
 */
void ir_send(const void* data, int len, void (*callback)());

/* ԊOŃf[^M܂B
 * [in]
 *	data		Mf[^i[obt@̐擪AhXB
 *	len		Mf[^i[obt@̃oCgB
 *			1oCg̒ʐM͕słB(AT[g܂)
 *	callback	MR[obNB
 *			NULLw肷ƁAR[obN͌Ăяo܂B
 * [note]
 *	- ̊֐́AʐM҂ɂɏԂ܂B
 *	  ʐḾAR[obNA܂ir_stat()ĂяoĔ肵ĂB
 *	  ʐM܂ŁAdataobt@ێȂ΂܂B
 *	- ʐMƁAIir_stop()Ăяo܂B
 *	  Iir_stop()ĂяoKv͗L܂B(Ăł\܂B)
 *	- ʐMOɒʐM𒆒fɂ́Air_stop()ĂяoĂB
 *	  ʐM𒆒fꍇ́AR[obN͌Ăяo܂B!!
 *	- R[obNĂяoOɁAɎIir_stop()Ă΂Ă܂B
 *	  R[obN̒ŁAir_stop()ĂԕKv͂܂B(Ăł\܂B)
 *	  ܂AR[obN̒ŒɎ̒ʐMJn邱Ƃł܂B
 *	- 24MHz/48MHzǂ̃NbNłg܂B
 *	  AʐM̓NbN؂ւȂŉB
 */
void ir_recv(void* data, int len, void (*callback)());

/* ԊOʐM@\~܂B
 * [note]
 *	- ir_send()܂ir_recv()ĂяoAvP[V́A
 *	  IOɕKir_stop()ĂяoĂB
 *	- ir_send()܂ir_recv()ĂяoĂȂĂA
 *	  ir_stop()ĂяoƂ͏ɈSłB
 */
void ir_stop();

/* ԊOʐM󋵂擾܂B
 * [out]
 *	߂l		ʐMȂ΁A0ȊO̒lԂ܂B
 *			~A܂́AMĂA0Ԃ܂B
 */
int ir_stat();

#endif /*__CLIP_IR_H__*/
