/*	
 *	main.c
 *
 *	IPEnableRouter - IP]@\؂ւvO for Windows 2000/XP
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Sat Aug 06 21:40:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Aug 20 05:20:00 JST 2005 Naoyuki Sawa
 *	- QƁEݒ肷郌WXgl̖OuEnableRoutervuIPEnableRoutervɏCB
 *	  Webɂ́AuEnableRoutervƏĂ鎑܂A͌łB
 */
#define STRICT
#include <windows.h>
#include "resource.h"

#define APP_TITLE	"IPEnableRouter"

/* Windows 2000A܂́AWindows XPIP]@\On/Off@F
 * "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\IPEnableRouter"=0A܂́AGg΁AIP]@\OffłB
 * "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\IPEnableRouter"=1@@@@@@@@@@@Ȃ΁AIP]@\On łB
 */
#define ROOT_KEY	HKEY_LOCAL_MACHINE
#define KEY_NAME	"System\\CurrentControlSet\\Services\\Tcpip\\Parameters"
#define VALUE_NAME	"IPEnableRouter"

BOOL CALLBACK DlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
int QueryValue();
int SetValue(int value);

int PASCAL
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	int retval;
	HANDLE mutex;
	OSVERSIONINFO os;

	/* dNh~p̃~[eNX쐬܂B */
	mutex = CreateMutex(NULL, FALSE, APP_TITLE);
	if(mutex) {

		/* dNh~p̃~[eNXbN܂B */
		retval = WaitForSingleObject(mutex, 0);
		if(retval == WAIT_OBJECT_0) {

			/* Windows 2000/XPȍ~ł邱ƂmF܂B
			 * ~ Windows 95/98/Me    dwPlatformId=1 dwMajorVersion=4 dwMinorVersion=?
			 * ~ Windows NT 3.x      dwPlatformId=2 dwMajorVersion=3 dwMinorVersion=?
			 * ~ Windows NT 4.0      dwPlatformId=2 dwMajorVersion=4 dwMinorVersion=0
			 *  Windows 2000        dwPlatformId=2 dwMajorVersion=5 dwMinorVersion=0
			 *  Windows XP          dwPlatformId=2 dwMajorVersion=5 dwMinorVersion=1
			 *  Windows Server 2003 dwPlatformId=2 dwMajorVersion=5 dwMinorVersion=2
			 */
			os.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
			retval = GetVersionEx(&os);
			if(!retval) {
				MessageBox(NULL, "OS̃o[W񂪎擾ł܂B", APP_TITLE, MB_ICONSTOP | MB_OK);
				goto L_ERR;
			}
			if((os.dwPlatformId != VER_PLATFORM_WIN32_NT) || (os.dwMajorVersion < 5)) {
				MessageBox(NULL, "̃AvP[VWindows 2000/XPȍ~płB", APP_TITLE, MB_ICONSTOP | MB_OK);
				goto L_ERR;
			}

			/* C_CAO\܂B */
			DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG), NULL, DlgProc);
L_ERR:
			/* dNh~p̃~[eNXbN܂B */
			ReleaseMutex(mutex);
		}

		/* dNh~p̃~[eNX܂B */
		CloseHandle(mutex);
	}

	return 0;
}

/* WI{^ύXxBN_CLICKED񑗂ė̂ŁAڂ𖳎邽߂ɑIԂoĂ܂B */
int id_sel;

BOOL CALLBACK
DlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int retval;
	int id;
	int notify;
	HICON icon;

	switch(uMsg) {
	case WM_INITDIALOG:
		/* _CAOEChEɃACRݒ肵܂B */
		icon = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICON));
		if(icon) {
			SendMessage(hWnd, WM_SETICON, ICON_BIG  , (LPARAM)icon);
			SendMessage(hWnd, WM_SETICON, ICON_SMALL, (LPARAM)icon);
		}
		/* ݂IP]ݒWI{^̏Ԃɔf܂B */
		retval = QueryValue();
		if(retval) { /* IPEnableRouter=1 */
			id_sel = IDC_ON;
		} else {     /* IPEnableRouter=0 */
			id_sel = IDC_OFF;
		}
		SendDlgItemMessage(hWnd, id_sel, BM_SETCHECK, BST_CHECKED, 0);
		return TRUE;

	case WM_COMMAND:
		/* WI{^IꂽAIP]ݒ֔f܂B */
		id     = LOWORD(wParam);
		notify = HIWORD(wParam);
		switch(id) {
		case IDC_ON:
		case IDC_OFF:
			if((notify == BN_CLICKED) && (id != id_sel)) {
				id_sel = id;
				retval = SetValue(id_sel == IDC_ON);
				if(retval != 0) {
					MessageBox(hWnd, "WXg݂̏Ɏs܂B", APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
				}
			}
			return TRUE;
		}
		break;

	case WM_CLOSE:
		/* E[~]{^ꂽA_CAOI܂B */
		EndDialog(hWnd, 0);
		return TRUE;
	}

	return FALSE;
}

/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\IPEnableRouter"̒l擾܂B
 * ̃Gg݂ȂꍇA0ƓӖł̂ŁAl̎擾Ɏsꍇ0Ԃ܂B
 */
int
QueryValue()
{
	HKEY key = NULL;
	int value = 0; /* IPEnableRouter̃Ggꍇ́AIPEnableRouter=0ƓłB */
	//
	int retval;
	int type;
	int size;

	/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters"J܂B */
	retval = RegOpenKeyEx(HKEY_LOCAL_MACHINE, KEY_NAME, 0, KEY_ALL_ACCESS, &key);
	if(retval != 0) {
		goto L_EXIT;
	}

	/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\IPEnableRouter"擾܂B */
	size = sizeof value;
	retval = RegQueryValueEx(key, VALUE_NAME, NULL, &type, (void*)&value, &size);
	if(retval != 0) {
		goto L_EXIT;
	}

L_EXIT:

	/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters"JĂA܂B */
	if(key) {
		RegCloseKey(key);
	}

	return value;
}

/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\IPEnableRouter"̒lݒ肵܂B
 * Ȃ0AsȂ0ȊO̒lԂ܂B
 */
int
SetValue(int value)
{
	HKEY key = NULL;
	//
	int retval;

	/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters"J܂B */
	retval = RegOpenKeyEx(HKEY_LOCAL_MACHINE, KEY_NAME, 0, KEY_ALL_ACCESS, &key);
	if(retval != 0) {
		goto L_EXIT;
	}

	/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\IPEnableRouter"ݒ肵܂B */
	retval = RegSetValueEx(key, VALUE_NAME, 0, REG_DWORD, (void*)&value, sizeof value);
	if(retval != 0) {
		goto L_EXIT;
	}

L_EXIT:

	/* "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters"JĂA܂B */
	if(key) {
		RegCloseKey(key);
	}

	return retval;
}

