/*	
 *	clipm68.c
 *
 *	P/ECE M6800 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipm68i.h"	/*M6800G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const M6800OP m6800_op_table[256/*opcode*/] = {
#include "m6800/table.h" /* [m6800.xls]Table */
};

/*
 *	CXgNVe[u
 */
#undef M6800FN_
#define M6800FN_(OP, FN)	OP "\0"
const char m6800_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "m6800/list.h" /* [m6800.xls]List */
};
#undef M6800FN_

/****************************************************************************
 *	֐
 ****************************************************************************/

void m6800_check_pending(M6800* m6800) {
#define CHECK_PENDING(x)				\
	if(PENDING & M6800_##x##_PENDING) {		\
		PENDING &= ~M6800_##x##_PENDING;	\
		m6800_int(m6800, M6800_##x##_VECTOR);	\
		return;					\
	}

	/* ܂܂Ƀ`FbNB(قƂǂ̏ꍇAreturnł܂) */
	if(!PENDING) return;

	/* 荞݋֎~Ȃ牽܂B */
	if(CC & 0x10) return;

	/* ΂Dx̍荞݁𔭐܂B */
	CHECK_PENDING(IRQ1);
	CHECK_PENDING(ICI);
	CHECK_PENDING(OCI);
	CHECK_PENDING(TOI);
	CHECK_PENDING(CMI);
	CHECK_PENDING(IRQ2);
	CHECK_PENDING(SIO); /* ̊荞݂ԗDxႢƂɒ!! */

#undef CHECK_PENDING
}

void m6800_int(M6800* m6800, int vector) {
	PUSHW(PC);
	PUSHW(X);
	PUSH(A);
	PUSH(B);
	PUSH(CC);
	CC |= 0x10;		/* I=1:荞݋֎~ */
	PC = READW(vector);
	WAIT = 0;		/* WAIT */
}

void m6800_rti(M6800* m6800) {
	PULL(CC);			/* CC(I) 1:֎~0: ɕω\ */
	PULL(B);
	PULL(A);
	PULLW(X);
	PULLW(PC);
	CC |= 0xc0;			/* CC[7:6]=11Œ */
	m6800_check_pending(m6800);	/* YȂ!! */
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
m6800_reset(M6800* m6800, M6800READPROC* read, M6800WRITEPROC* write)
{
	memset(m6800, 0, sizeof(M6800));
	m6800->read  = read  ? read  : m6800_internal_read;
	m6800->write = write ? write : m6800_internal_write;

	CC = 0xd0;		/* CC[7] Unused    = 1 Œ */
				/* CC[6] Unused    = 1 Œ */
				/* CC[5] HalfCarry = 0 */
				/* CC[4] Interrut  = 1 Zbg㊄荞݋֎~ */
				/* CC[3] Negative  = 0 */
				/* CC[2] Zero      = 0 */
				/* CC[1] Overflow  = 0 */
				/* CC[0] Carry     = 0 */
	PC = READW(M6800_RESET_VECTOR);
}

void
m6800_nmi(M6800* m6800)
{
	m6800_int(m6800, M6800_NMI_VECTOR);
}

void m6800_irq1(M6800* m6800) { PENDING |= M6800_IRQ1_PENDING; m6800_check_pending(m6800); }
void m6800_ici(M6800* m6800)  { PENDING |= M6800_ICI_PENDING;  m6800_check_pending(m6800); }
void m6800_oci(M6800* m6800)  { PENDING |= M6800_OCI_PENDING;  m6800_check_pending(m6800); }
void m6800_toi(M6800* m6800)  { PENDING |= M6800_TOI_PENDING;  m6800_check_pending(m6800); }
void m6800_sio(M6800* m6800)  { PENDING |= M6800_SIO_PENDING;  m6800_check_pending(m6800); }
void m6800_cmi(M6800* m6800)  { PENDING |= M6800_CMI_PENDING;  m6800_check_pending(m6800); }
void m6800_irq2(M6800* m6800) { PENDING |= M6800_IRQ2_PENDING; m6800_check_pending(m6800); }

void
m6800_dump(M6800* m6800)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("CC:%c%c%c%c%c%c%c%c A:%02x B:%02x X:%04x S:%04x PC:%04x\n",
		CC & (1 << 7) ? '1' : '-',
		CC & (1 << 6) ? '1' : '-',
		CC & (1 << 5) ? 'H' : '-',
		CC & (1 << 4) ? 'I' : '-',
		CC & (1 << 3) ? 'N' : '-',
		CC & (1 << 2) ? 'Z' : '-',
		CC & (1 << 1) ? 'V' : '-',
		CC & (1 << 0) ? 'C' : '-',
		A, B, X, S, PC);
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global m6800_run2
m6800_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall m6800_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

