/*	
 *	clippzl.c
 *
 *	P/ECE Zlib
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sat Mar 13 13:00:00 JST 2004 Naoyuki Sawa
 *	- 1st release.
 *	* Sun Mar 14 16:52:00 JST 2004 Naoyuki Sawa
 *	- _pdeflate_uncompress()ɂāAubNɃm[hobt@̃ZbgYĂ܂B
 *	  ̃ubN܂ޑ傫Ȉkf[^WJƁAm[hobt@čsāA
 *	  m[hsɂȂWJsĂ܂Ă܂B
 *	  ABugCAubNɃm[hobt@Zbg悤ɂ܂B
 *	- m[hobt@TCY𔼕ɂ܂B
 *	  ܂ł2048vfmۂĂ܂Aʏ̈kf[^ł300`400xg܂B
 *	  ]T肷̂ŁA1024܂Ō炵܂B
 *	  ܂O{x]T̂łԂvƎv܂AӂKvłB
 *	* Sun Mar 15 12:30:00 JST 2004 Naoyuki Sawa
 *	- pdeflate_uncompress()AWJɏo̓TCYłȂ0ԂĂBugCB
 *	  WJ́Ao̓TCYԂ悤ɂȂ܂B
 *	- ZipWJC^[tFCXǉ܂B
 */
//#include "clip.h"
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/* * P/ECE APIŗpꍇ́Ã}N`LɂĂB
 *   P/ECE APIȊOŗpꍇ́ARgAEgĂB
 * * P/ECEŗpꍇłAmalloc()/free()gꍇ́A}N`svłB
 *   malloc()/free()gɂ́Aansi_InitMalloc()găq[v܂B
 */
///#define malloc  pceHeapAlloc
///#define free    pceHeapFree

/* * pdeflate_uncompress()ŊmۂAnt}؃m[hobt@̗vfłB
 *   Code Length codeALiteral/Length codeADistance ec[́Ãm[hobt@ɍ쐬܂B
 *   O̃c[̍vm[hm[hobt@vf𒴂ƁAWJsG[Ԃ܂B
 * * ő升vm[h͗_ŋ߂Ȃ悤Ȃ̂ŁAŒ邵܂B
 *   ̈kf[^ŎĂ݂ƂAO̃c[̍vm[h300`400xƂȂ܂B
 *   1024ĂΏ[Ǝv܂A1024𒴂邱Ƃ΁AĒĂB
 */
#define PDEFLATE_NODES_LEN	1024

/****************************************************************************
 *	oCgXg[ (o)
 ****************************************************************************/

int
pbytestream_init(PBYTESTREAM* out, void* buffer, int len)
{
	if(len < 0) return ERRNO;

	memset(out, 0, sizeof(PBYTESTREAM));
	out->buffer = (unsigned char*)buffer;
	out->len = len;

	return 0;
}

int
pbytestream_put(PBYTESTREAM* out, int value)
{
	if(out->pos >= out->len) return ERRNO;

	out->buffer[out->pos++] = (unsigned char)value;

	return 1;
}

/****************************************************************************
 *	rbgXg[
 ****************************************************************************/

int
pbitstream_init(PBITSTREAM* in, const void* data, int len)
{
	if((len < 0) || (len > INT_MAX / 8 - 1)) return ERRNO;

	memset(in, 0, sizeof(PBITSTREAM));
	in->data = (const unsigned char*)data;
	in->len = len * 8; /* bitP */

	return 0;
}

int
pbitstream_get(PBITSTREAM* in, int* out, int bits)
{
	//	                        s2  s1
	//	                        /   /
	//	                      +-+----+
	//	MSB|.....xxx|xxxxxxxx|xxx.....|LSB
	//	         +--------------+    |
	//	                /       |    |
	//	              bits     pos   p
	//	  mask = 111_11111111_111

	int v, n, s1, s2, mask;
	const unsigned char* p;

	if(bits < 1 || bits > 32) return ERRNO;
	if(in->pos + bits > in->len) return ERRNO;

	p = &in->data[in->pos / 8];
	s1 = in->pos & 7;
	s2 = 8 - s1;

	v = *p++ >> s1;
	n = bits - s2;
	while(n > 0) {
		v |= *p++ << s2;
		s2 += 8;
		n -= 8;
	}

	mask = (unsigned)-1 >> (32 - bits);
	if(out) *out = v &= mask;
	in->pos += bits;

	return bits;
}

int
pbitstream_align(PBITSTREAM* in, int bits)
{
	if(bits < 1 || bits > 32) return ERRNO;

	/* posbits̔{ɐ؏グ܂B */
	in->pos = (in->pos + (bits - 1)) / bits * bits;

	return 0;
}

/****************************************************************************
 *	nt}
 ****************************************************************************/

int
phufftree_init(PHUFFTREE pht[/*len*/], int len, const unsigned char code_bits[/*values*/], int values)
{
	int retval, value, bits, code, index;
	unsigned short bits_count[PHUFFTREE_MAX_BITS + 1]; /* 2x16=32[byte] */
	unsigned short bits_code [PHUFFTREE_MAX_BITS + 1]; /* 2x16=32[byte] */

	if(values < 0 || values > PHUFFTREE_MAX_VALUE + 1) return ERRNO;

	/* nt}؂̑Sm[hnext[0,1]APHUFFTREE_BLANKɏ܂B */
	memset(pht, -1, sizeof(PHUFFTREE) * len);

	/* erbg蓖Ăꂽl̐𐔂܂B */
	memset(bits_count, 0, sizeof bits_count);
	for(value = 0; value < values; value++) {
		bits = code_bits[value];
		if(bits > PHUFFTREE_MAX_BITS) return ERRNO;
		if(bits) bits_count[bits]++; /* rbg0̒l͕sgp */
	}

	/* erbg̍ŏ̕蓖Ă܂B */
	code = 0;
	for(bits = 1; bits <= PHUFFTREE_MAX_BITS; bits++) {
		code = (code + bits_count[bits - 1]) << 1;
		bits_code[bits] = (unsigned short)code;
	}

	/* elɕ蓖āAnt}؂{Al}̃yAǉ܂B */
	index = -1; /* li[m[hCfNX̍ől */
	for(value = 0; value < values; value++) {
		bits = code_bits[value];
		if(bits) { /* 0rbg̒l(=gp)͒ǉ܂ */
			code = bits_code[bits]++;
			retval = phufftree_add(pht, len, code, bits, value);
			if(retval < 0) return retval;
			if(retval > index) index = retval;
		}
	}

	/* gpm[h(=li[m[hCfNX̍ől+1)Ԃ܂B */
	return index + 1;
}

int
phufftree_add(PHUFFTREE pht[/*len*/], int len, int code, int code_bits, int value)
{
	int index, bit, next_index;
	PHUFFTREE* node;

	if(code_bits < 1 || code_bits > PHUFFTREE_MAX_BITS ) return ERRNO;
	if(value     < 0 || value     > PHUFFTREE_MAX_VALUE) return ERRNO;

	/* ̃Nǂ鏈B */
	index = 0;
	for(;;) {
		/* m[h擾܂B */
		if(index > len - 1) return ERRNO; /* nt}ؔj */
		node = &pht[index];

		/* c蕄rbg炵܂B */
		code_bits--;

		/* T(0or1)擾܂B */
		bit = (code >> code_bits) & 1;

		/* Ō̃rbgȂAli[ցB */
		if(!code_bits) goto FINAL;

		/* ̃m[hCfNX擾܂B */
		next_index = node->next[bit];

		/* Nr؂ꂽA܂B */
		if(next_index == PHUFFTREE_BLANK) break;

		/* m[hCfNXXVA[vB */
		if(next_index <= index) return ERRNO; /* O֖߂邱Ƃ͂肦Ȃ */
		index = next_index;
		if(index & PHUFFTREE_LEAF) return ERRNO; /* nt}ؔj */
	}

	/* ݂̃m[hŁAƂ󂫂̃m[hT܂B
	 * ~~~~~~~~~~~~~~~~~~~~dv!!݂̃m[hƂ󂫂̉\܂B
	 */
	for(next_index = index + 1; next_index < len; next_index++) {
		if(pht[next_index].next[0] == PHUFFTREE_BLANK &&
		   pht[next_index].next[1] == PHUFFTREE_BLANK) break;
	}
	if(next_index == len) return ERRNO; /* m[hs */

	/* ŏ̋󂫃m[hփN܂B */
	node->next[bit] = (unsigned short)next_index;

	/* 㑱N쐬鏈B */
	index = next_index;
	node = &pht[index];
	for(;;) {
		/* c蕄rbg炵܂B */
		code_bits--;

		/* T(0or1)擾܂B */
		bit = (code >> code_bits) & 1;

		/* Ō̃rbgȂAli[ցB */
		if(!code_bits) goto FINAL;

		/* ̃m[hփN܂B */
		index++;
		if(index > len - 1) return ERRNO; /* m[hs */
		if(node->next[bit] != PHUFFTREE_BLANK) return ERRNO; /* nt}ؔj */
		node->next[bit] = (unsigned short)index;
		node++;
	}

FINAL:
	/* li[܂B */
	if(node->next[bit] != PHUFFTREE_BLANK) return ERRNO; /* nt}ؔj */
	node->next[bit] = (unsigned short)(value | PHUFFTREE_LEAF);

	/* li[m[h̃CfNXԂ܂B */
	return index;
}

int
phufftree_lookup(PHUFFTREE pht[/*len*/], int len, PBITSTREAM* in)
{
	int index, bit, next_index, value;
	PHUFFTREE* node;

	/* ̃Nǂ鏈B */
	index = 0;
	for(;;) {
		/* m[h擾܂B */
		if(index > len - 1) return ERRNO; /* nt}ؔj */
		node = &pht[index];

		/* 1rbgǂݍ݂܂B */
		if(pbitstream_get(in, &bit, 1) < 0) return ERRNO;

		/* ̃m[hCfNX擾܂B */
		next_index = node->next[bit];
		if(next_index & PHUFFTREE_LEAF) break; /* [t(or)ȂΔ܂ */

		/* m[hCfNXXVA[vB */
		if(next_index <= index) return ERRNO; /* O֖߂邱Ƃ͂肦Ȃ */
		index = next_index;
	}

	/* l擾܂B */
	value = next_index & ~PHUFFTREE_LEAF;
	if(value < 0 || value > PHUFFTREE_MAX_VALUE) return ERRNO; /* nt}ؔj */
	/*next_index=PHUFFTREE_BLANKꍇAŃG[oł܂B*/

	/* lԂ܂B */
	return value;
}

/****************************************************************************
 *	Deflate`
 ****************************************************************************/

/* Code Length code WJ̕ёւ (dl) */
static const unsigned char pdeflate_code_length_code_order[19] = {
	16,	/* 0*/
	17,	/* 1*/
	18,	/* 2*/
	 0,	/* 3*/
	 8,	/* 4*/
	 7,	/* 5*/
	 9,	/* 6*/
	 6,	/* 7*/
	10,	/* 8*/
	 5,	/* 9*/
	11,	/*10*/
	 4,	/*11*/
	12,	/*12*/
	 3,	/*13*/
	13,	/*14*/
	 2,	/*15*/
	14,	/*16*/
	 1,	/*17*/
	15	/*18*/
};

/* Length code 257`285 ̒ǉrbgƃx[X (dl) */
typedef struct _PDEFLATELENGTHCODEINFO {
	short extra_bits;	/* ǉrbg */
	short length;		/* x[X     */
} PDEFLATELENGTHCODEINFO;
static const PDEFLATELENGTHCODEINFO pdeflate_length_code_info[285 - 257 + 1] = {
	{0,  3},	/*257*/
	{0,  4},	/*258*/
	{0,  5},	/*259*/
	{0,  6},	/*260*/
	{0,  7},	/*261*/
	{0,  8},	/*262*/
	{0,  9},	/*263*/
	{0, 10},	/*264*/
	{1, 11},	/*265*/
	{1, 13},	/*266*/
	{1, 15},	/*267*/
	{1, 17},	/*268*/
	{2, 19},	/*269*/
	{2, 23},	/*270*/
	{2, 27},	/*271*/
	{2, 31},	/*272*/
	{3, 35},	/*273*/
	{3, 43},	/*274*/
	{3, 51},	/*275*/
	{3, 59},	/*276*/
	{4, 67},	/*277*/
	{4, 83},	/*278*/
	{4, 99},	/*279*/
	{4,115},	/*280*/
	{5,131},	/*281*/
	{5,163},	/*282*/
	{5,195},	/*283*/
	{5,227},	/*284*/
	{0,258},	/*285*/
};

/* Distance code 0`29 ̒ǉrbgƃx[X (dl) */
typedef struct _PDEFLATEDISTANCECODEINFO {
	short extra_bits;	/* ǉrbg */
	short distance;		/* x[X   */
} PDEFLATEDISTANCECODEINFO;
static const PDEFLATEDISTANCECODEINFO pdeflate_distance_code_info[29 + 1] = {
	{ 0,    1},	/* 0*/
	{ 0,    2},	/* 1*/
	{ 0,    3},	/* 2*/
	{ 0,    4},	/* 3*/
	{ 1,    5},	/* 4*/
	{ 1,    7},	/* 5*/
	{ 2,    9},	/* 6*/
	{ 2,   13},	/* 7*/
	{ 3,   17},	/* 8*/
	{ 3,   25},	/* 9*/
	{ 4,   33},	/*10*/
	{ 4,   49},	/*11*/
	{ 5,   65},	/*12*/
	{ 5,   97},	/*13*/
	{ 6,  129},	/*14*/
	{ 6,  193},	/*15*/
	{ 7,  257},	/*16*/
	{ 7,  385},	/*17*/
	{ 8,  513},	/*18*/
	{ 8,  769},	/*19*/
	{ 9, 1025},	/*20*/
	{ 9, 1537},	/*21*/
	{10, 2049},	/*22*/
	{10, 3073},	/*23*/
	{11, 4097},	/*24*/
	{11, 6145},	/*25*/
	{12, 8193},	/*26*/
	{12,12289},	/*27*/
	{13,16385},	/*28*/
	{13,24577},	/*29*/
};

static int
_pdeflate_uncompress(PBYTESTREAM* out, PBITSTREAM* in, unsigned char code_bits[/*PHUFFTREE_MAX_VALUE + 1*/], PHUFFTREE nodes[/*PDEFLATE_NODES_LEN*/])
{
	int out_pos0 = out->pos; /* o̓oCg𒲂ׂ邽߁AʒuۑĂ܂ */
	//
	int retval;
	int i;
	int v;
	int bits;
	int dist;
	/* 3 header bits */
	int bfinal;
	int btype;
	/* 00 - no compression */
	int len;
	int nlen;
	/* 10 - compressed with dynamic Huffman codes */
	int hlit;
	int hdist;
	int hclen;

	PHUFFTREE* tree;			/* m[hobt@̋󂫗vf擪m[h */
	int tree_len;				/* m[hobt@̎c󂫗vf */
	//
	PHUFFTREE* code_length_code_tree;	/* Code Length code c[̐擪m[h */
	int code_length_code_tree_len;		/* Code Length code c[̃m[h */
	//
	PHUFFTREE* literal_length_code_tree;	/* Literal/Length code c[̐擪m[h */
	int literal_length_code_tree_len;	/* Literal/Length code c[̃m[h */
	//
	PHUFFTREE* distance_code_tree;		/* Distance code c[̐擪m[h */
	int distance_code_tree_len;		/* Distance code c[̃m[h */

	do {
		/* m[hobt@Zbg܂BYȂ!! */
		tree = nodes;
		tree_len = PDEFLATE_NODES_LEN;

		/* 3 header bits
		 * [  0]: BFINAL is set if and only if this is the last block of the data set.
		 * [2:1]: BTYPE specifies how the data are compressed, as follows:
		 *	  00 - no compression
		 *	  01 - compressed with fixed Huffman codes
		 *	  10 - compressed with dynamic Huffman codes
		 *	  11 - reserved (error)
		 */
		if(pbitstream_get(in, &bfinal, 1) < 0) return ERRNO;
		if(pbitstream_get(in, &btype, 2) < 0) return ERRNO;

		switch(btype) {
		/*==========================================================*
		 *	00 - NO COMPRESSION
		 *==========================================================*/
		case 0:
			/* rbgXg[oCgE܂Ői߂܂B */
			retval = pbitstream_align(in, 8);
			if(retval < 0) return retval;

			/* +0,2: LEN is the number of data bytes in the block.
			 * +2,2: NLEN is the one's complement of LEN.
			 */
			if(pbitstream_get(in, &len, 16) < 0) return ERRNO;
			if(pbitstream_get(in, &nlen, 16) < 0) return ERRNO;
			if((len ^ 0xffff) != nlen) return ERRNO;

			/* ǂݍ񂾃oCĝ܂܏o͂܂B */
			while(len--) {
				if(pbitstream_get(in, &v, 8) < 0) return ERRNO;
				if(pbytestream_put(out, v) < 0) return ERRNO;
			}

			/* ̃ubN̓WJ܂B */
			break;

		/*==========================================================*
		 *	01 - COMPRESSED WITH FIXED HUFFMAN CODES
		 *==========================================================*/
		case 1:
			/***** Literal/Length code WJ ******/

			/* e Literal/Length code ̃rbgݒ肵܂B(dl) */
			memset(code_bits, 0, sizeof(unsigned char) * (PHUFFTREE_MAX_VALUE + 1));
			i = 0;					// Lit Value | Bits | Codes
			while(i <= 143) code_bits[i++] = 8;	//   0 - 143 |    8 | 00110000  - 10111111
			while(i <= 255) code_bits[i++] = 9;	// 144 - 255 |    9 | 110010000 - 111111111
			while(i <= 279) code_bits[i++] = 7;	// 256 - 279 |    7 | 0000000   - 0010111
			while(i <= 287) code_bits[i++] = 8;	// 280 - 287 |    8 | 11000000  - 11000111
								// Literal/Length values 286-287 will never actually occur in the compressed data.

			/* Literal/Length code ̃nt}؂쐬܂B */
			literal_length_code_tree = tree; /* 󂫃m[h̐擪AhX擾 */
			retval = phufftree_init(literal_length_code_tree, tree_len, code_bits, PHUFFTREE_MAX_VALUE + 1);
			if(retval < 0) return retval;
			literal_length_code_tree_len = retval;
			tree += retval; /* 󂫃m[h̐擪AhXi߂ */
			tree_len -= retval; /* 󂫃m[h炷 */

			/***** Distance code WJ ******/

			/* e Distance code ̃rbgݒ肵܂B(dl) */
			memset(code_bits, 0, sizeof(unsigned char) * (PHUFFTREE_MAX_VALUE + 1));
			i = 0;
			while(i <= 31) code_bits[i++] = 5;	// Distance codes 0-31 are represented by (fixed-length) 5 bit codes.
								// Distance codes 30-31 will never actually occur in the compression data.

			/* Distance code ̃nt}؂쐬܂B */
			distance_code_tree = tree; /* 󂫃m[h̐擪AhX擾 */
			retval = phufftree_init(distance_code_tree, tree_len, code_bits, PHUFFTREE_MAX_VALUE + 1);
			if(retval < 0) return retval;
			distance_code_tree_len = retval;
			tree += retval; /* 󂫃m[h̐擪AhXi߂ */
			tree_len -= retval; /* 󂫃m[h炷 */

			/* f[^WJցB */
			goto DECOMPRESS_DATA;

		/*==========================================================*
		 *	10 - COMPRESSED WITH DYNAMIC HUFFMAN CODES
		 *==========================================================*/
		case 2:
			/* [ 4: 0]: HLIT, # of Literal/Length codes - 257 (257`286)
			 * [ 9: 5]: HDIST, # of Distance codes - 1        (  1` 32)
			 * [13:10]: HCLEN, # of Code Length codes - 4     (  4` 19)
			 */
			if(pbitstream_get(in, &hlit, 5) < 0) return ERRNO;
			if(pbitstream_get(in, &hdist, 5) < 0) return ERRNO;
			if(pbitstream_get(in, &hclen, 4) < 0) return ERRNO;
			hlit += 257;
			if(hlit < 257 || hlit > 286) return ERRNO;
			hdist += 1;
			if(hdist < 1 || hdist > 32) return ERRNO;
			hclen += 4;
			if(hclen < 4 || hclen > 19) return ERRNO;

			/***** Code Length code WJ ******/

			/* e Code Length code ̃rbgǂݍ݂܂B */
			memset(code_bits, 0, sizeof(unsigned char) * (PHUFFTREE_MAX_VALUE + 1));
			i = 0;
			while(i < hclen) {
				if(pbitstream_get(in, &v, 3) < 0) return ERRNO;
				code_bits[pdeflate_code_length_code_order[i++]] = (unsigned char)v;
			}

			/* Code Length code ̃nt}؂쐬܂B */
			code_length_code_tree = tree; /* 󂫃m[h̐擪AhX擾 */
			retval = phufftree_init(code_length_code_tree, tree_len, code_bits, PHUFFTREE_MAX_VALUE + 1);
			if(retval < 0) return retval;
			code_length_code_tree_len = retval;
			tree += retval; /* 󂫃m[h̐擪AhXi߂ */
			tree_len -= retval; /* 󂫃m[h炷 */

			/***** Literal/Length code WJ ******/

			/* e Literal/Length code ̃rbgǂݍ݂܂B */
			memset(code_bits, 0, sizeof(unsigned char) * (PHUFFTREE_MAX_VALUE + 1));
			i = 0;
			while(i < hlit) {
				retval = phufftree_lookup(code_length_code_tree, code_length_code_tree_len, in);
				if(retval < 0) return retval;
				v = retval;
				if(v <= 15) {
					/* 0 - 15: Represent code lengths of 0 - 15 */
					code_bits[i++] = (unsigned char)v;
				} else if(v == 16) {
					/* 16: Copy the previous code length 3 - 6 times. */
					if(!i) return ERRNO; /* O̒lȂ */
					v = code_bits[i - 1];
					if(pbitstream_get(in, &len, 2) < 0) return ERRNO; /* 2bit: JԂ-3 */
					len += 3;
					while(len--) {
						if(i > hlit - 1) return ERRNO; /* JԂ񐔂I[𒴂 */
						code_bits[i++] = (unsigned char)v;
					}
				} else if(v == 17) {
					/* 17: Repeat a code length of 0 for 3 - 10 timnes. */
					if(pbitstream_get(in, &len, 3) < 0) return ERRNO; /* 3bit: JԂ-3 */
					len += 3;
					while(len--) {
						if(i > hlit - 1) return ERRNO; /* JԂ񐔂I[𒴂 */
						code_bits[i++] = 0;
					}
				} else if(v == 18) {
					/* 18: Repeat a code length of 0 for 11 - 138 timnes. */
					if(pbitstream_get(in, &len, 7) < 0) return ERRNO; /* 7bit: JԂ-11 */
					len += 11;
					while(len--) {
						if(i > hlit - 1) return ERRNO; /* JԂ񐔂I[𒴂 */
						code_bits[i++] = 0;
					}
				} else {
					return ERRNO;
				}
			}

			/* Literal/Length code ̃nt}؂쐬܂B */
			literal_length_code_tree = tree; /* 󂫃m[h̐擪AhX擾 */
			retval = phufftree_init(literal_length_code_tree, tree_len, code_bits, PHUFFTREE_MAX_VALUE + 1);
			if(retval < 0) return retval;
			literal_length_code_tree_len = retval;
			tree += retval; /* 󂫃m[h̐擪AhXi߂ */
			tree_len -= retval; /* 󂫃m[h炷 */

			/***** Distance code WJ ******/

			/* e Distance code ̃rbgǂݍ݂܂B */
			memset(code_bits, 0, sizeof(unsigned char) * (PHUFFTREE_MAX_VALUE + 1));
			i = 0;
			while(i < hdist) {
				retval = phufftree_lookup(code_length_code_tree, code_length_code_tree_len, in);
				if(retval < 0) return retval;
				v = retval;
				if(v <= 15) {
					/* 0 - 15: Represent code lengths of 0 - 15 */
					code_bits[i++] = (unsigned char)v;
				} else if(v == 16) {
					/* 16: Copy the previous code length 3 - 6 times. */
					if(!i) return ERRNO; /* O̒lȂ */
					v = code_bits[i - 1];
					if(pbitstream_get(in, &len, 2) < 0) return ERRNO; /* 2bit: JԂ-3 */
					len += 3;
					while(len--) {
						if(i > hdist - 1) return ERRNO; /* JԂ񐔂I[𒴂 */
						code_bits[i++] = (unsigned char)v;
					}
				} else if(v == 17) {
					/* 17: Repeat a code length of 0 for 3 - 10 timnes. */
					if(pbitstream_get(in, &len, 3) < 0) return ERRNO; /* 3bit: JԂ-3 */
					len += 3;
					while(len--) {
						if(i > hdist - 1) return ERRNO; /* JԂ񐔂I[𒴂 */
						code_bits[i++] = 0;
					}
				} else if(v == 18) {
					/* 18: Repeat a code length of 0 for 11 - 138 timnes. */
					if(pbitstream_get(in, &len, 7) < 0) return ERRNO; /* 7bit: JԂ-11 */
					len += 11;
					while(len--) {
						if(i > hdist - 1) return ERRNO; /* JԂ񐔂I[𒴂 */
						code_bits[i++] = 0;
					}
				} else {
					return ERRNO;
				}
			}

			/* Distance code ̃nt}؂쐬܂B */
			distance_code_tree = tree; /* 󂫃m[h̐擪AhX擾 */
			retval = phufftree_init(distance_code_tree, tree_len, code_bits, PHUFFTREE_MAX_VALUE + 1);
			if(retval < 0) return retval;
			distance_code_tree_len = retval;
			tree += retval; /* 󂫃m[h̐擪AhXi߂ */
			tree_len -= retval; /* 󂫃m[h炷 */

			/* f[^WJցB */
			goto DECOMPRESS_DATA;

		/*==========================================================*
		 *	01 - COMPRESSED WITH FIXED HUFFMAN CODES
		 *	                   AND
		 *	10 - COMPRESSED WITH DYNAMIC HUFFMAN CODES
		 *==========================================================*/
DECOMPRESS_DATA:
			for(;;) {
				/* Literal/Length code 擾܂B */
				retval = phufftree_lookup(literal_length_code_tree, literal_length_code_tree_len, in);
				if(retval < 0) return retval;
				v = retval;
				if(v <= 255) {
					/* 0 - 255: copy byte (literal byte) to output stream */
					if(pbytestream_put(out, v) < 0) return ERRNO;

				} else if(v == 256) {
					/* 256: end of block */
					break;

				} else if(v <= 285) {
					/* 257 - 285: move backwords distance bytes in tye output stream,
					 *            and copy length bytes from this position to the output stream.
					 */

					/* Rs[߂܂B */
					v -= 257;
					bits = pdeflate_length_code_info[v].extra_bits;
					len  = pdeflate_length_code_info[v].length;
					if(bits) {
						if(pbitstream_get(in, &v, bits) < 0) return ERRNO;
						len += v;
					}

					/* Rs[Jnʒuւ̋߂܂B */
					retval = phufftree_lookup(distance_code_tree, distance_code_tree_len, in);
					if(retval < 0) return retval;
					v = retval;
					if(v > 29) return ERRNO;
					bits = pdeflate_distance_code_info[v].extra_bits;
					dist = pdeflate_distance_code_info[v].distance;
					if(bits) {
						if(pbitstream_get(in, &v, bits) < 0) return ERRNO;
						dist += v;
					}

					/* Rs[܂B */
					i = out->pos - dist;
					if(i < 0) return ERRNO; /* o̓obt@JnʒuO̓Rs[s */
					while(len--) {
						v = out->buffer[i++];
						if(pbytestream_put(out, v) < 0) return ERRNO;
					}

				} else {
					return ERRNO;
				}
			}

			/* ̃ubN̓WJ܂B */
			break;

		/*==========================================================*
		 *	11 - RESERVED (ERROR)
		 *==========================================================*/
		default:
			return ERRNO;
		}

	} while(!bfinal); /* ŏIubN̓WJ甲܂ */

	/* o̓oCgԂ܂B */
	return out->pos - out_pos0;
}

int
pdeflate_uncompress(PBYTESTREAM* out, PBITSTREAM* in)
{
	int retval;
	unsigned char* code_bits/*[PHUFFTREE_MAX_VALUE + 1]*/;
	PHUFFTREE* nodes/*[PDEFLATE_NODES_LEN]*/;

	/* rbgzpmۂ܂B */
	code_bits = (unsigned char*)malloc(sizeof(unsigned char) * (PHUFFTREE_MAX_VALUE + 1));
	if(!code_bits) {
		return ERRNO;
	}

	/* nt}؃m[hobt@pmۂ܂B */
	nodes = (PHUFFTREE*)malloc(sizeof(PHUFFTREE) * PDEFLATE_NODES_LEN);
	if(!nodes) {
		free(code_bits);
		return ERRNO;
	}

	/* WJ̖{̂Ăяo܂B */
	retval = _pdeflate_uncompress(out, in, code_bits, nodes);

	/* nt}؃m[hobt@pJ܂B */
	free(nodes);

	/* rbgzpJ܂B */
	free(code_bits);

	return retval;
}

/****************************************************************************
 *	Zlib`
 ****************************************************************************/

int
pzlib_uncompress(void* outbuf, int outlen, const void* inbuf, int inlen)
{
	PBYTESTREAM _out;
	PBYTESTREAM* out = &_out;
	//
	PBITSTREAM _in;
	PBITSTREAM* in = &_in;
	//
	int retval;
	int cmf, flg;
	int adler32;

	/* oCgXg[(o)쐬܂B */
	retval = pbytestream_init(out, outbuf, outlen);
	if(retval < 0) return retval;

	/* rbgXg[()쐬܂B */
	retval = pbitstream_init(in, inbuf, inlen);
	if(retval < 0) return retval;

	/* +0,1: CMF (Compression Method and flags)
	 *	 [3:0]: CM (Compression method)
	 *	 [7:4]: CINFO (Compression info)
	 */
	if(pbitstream_get(in, &cmf, 8) < 0) return ERRNO;
	if((cmf & 0xf) != 8) return ERRNO;	/* 8:Deflate(dl) */
	if((cmf >> 4) > (15 - 8)) return ERRNO;	/* WBITS<=15(dl) */

	/* +1,1: FLG (FLaGs)
	 *	 [4:0]: FCHECK (check bits for CMF and FLG)
	 *	 [  5]: FDICT (preset dictionary)
	 *	 [7:6]: FLEVEL (compression level)
	 */
	if(pbitstream_get(in, &flg, 8) < 0) return ERRNO;
	if(flg & (1 << 5)) return ERRNO;	/* PresetDictionaryΉ */
	if((cmf << 8 | flg) % 31) return ERRNO;	/* CheckDigit(dl) */

	/* WJB */
	retval = pdeflate_uncompress(out, in);
	if(retval < 0) return retval;
	outlen = retval; /* o̓oCg */

	/* ̓rbgXg[̃oCgE܂Ői߂܂B */
	retval = pbitstream_align(in, 8);
	if(retval < 0) return retval;

	/* +n,4: ADLER32 (Adler-32 checksum)
	 *	 !!LITTLE-ENDIAN!!
	 */
	if(pbitstream_get(in, &retval, 8) < 0) return ERRNO;
	adler32  = retval << 24;
	if(pbitstream_get(in, &retval, 8) < 0) return ERRNO;
	adler32 |= retval << 16;
	if(pbitstream_get(in, &retval, 8) < 0) return ERRNO;
	adler32 |= retval <<  8;
	if(pbitstream_get(in, &retval, 8) < 0) return ERRNO;
	adler32 |= retval <<  0;
	retval = pzlib_adler32(outbuf, outlen);
	if(retval != adler32) return ERRNO;

	return outlen;
}

int
pzlib_adler32(const void* data, int len)
{
	const unsigned char* p = (const unsigned char*)data;
	int s1 = 1/*(dl)*/;
	int s2 = 0;

	while(len--) {
		s1 = (s1 + *p++) % 65521/*(dl)*/;
		s2 = (s1 + s2  ) % 65521/*(dl)*/;
	}

	return s1 | s2 << 16;
}

int
pzlib_crc32(const void* data, int len)
{
#define POLY	((1<<(31-26))|	\
		 (1<<(31-23))|	\
		 (1<<(31-22))|	\
		 (1<<(31-16))|	\
		 (1<<(31-12))|	\
		 (1<<(31-11))|	\
		 (1<<(31-10))|	\
		 (1<<(31- 8))|	\
		 (1<<(31- 7))|	\
		 (1<<(31- 5))|	\
		 (1<<(31- 4))|	\
		 (1<<(31- 2))|	\
		 (1<<(31- 1))|	\
		 (1<<(31- 0)))

	const unsigned char* p = (const unsigned char*)data;
	unsigned int r = 0xffffffff;
	int i, v;

	while(len--) {
		v = *p++;
		for(i = 0; i < 8; i++) {
			if((r ^ v) & 1) {
				r = (r >> 1) ^ POLY;
			} else {
				r =  r >> 1;
			}
			v >>= 1;
		}
	}

	return r ^ 0xffffffff;

#undef POLY
}

/****************************************************************************
 *	Zip`
 ****************************************************************************/

/* Zipt@C`̃[Jt@Cwb_APUNZIPDIR\̂ɓǂݍ݂܂B
 * [in]
 *	dir		t@Ci[PUNZIPDIR\́B
 *	header		[Jt@Cwb_ւ̃|C^B
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
static int
punzip_getdir(PUNZIPDIR* dir, const PUNZIPLOCALFILEHEADER* header)
{
	int v;
	int filename_length;
	int extra_field_length;
	const unsigned char* p;

	/* ܂NAB */
	memset(dir, 0, sizeof(PUNZIPDIR));

	/* local_file_header_signature[4] */
	v = header->local_file_header_signature[0]
	  | header->local_file_header_signature[1] <<  8
	  | header->local_file_header_signature[2] << 16
	  | header->local_file_header_signature[3] << 24;
	if(v != PUNZIPLOCALFILEHEADER_SIGNATURE) return ERRNO;

	/* version_needed_to_extract[2] */
	// ܂B

	/* general_purpose_bit_flag[2] */
	// ܂B
	// [   0]: ÍĂ܂B
	//         WJɎs܂B
	// [ 2:1]: k`L̃tOłB
	//         Kv܂B
	// [   3]: t@CTCYCRC-32DataDescriptorɊi[Ă܂B
	//         WJɎs܂B
	//           ܂Aȍ~̃t@C񑖍ɂs܂B
	// [15:4]: gpłB

	/* compression_method[2] */
	v = header->compression_method[0]
	  | header->compression_method[1] << 8;
	dir->compression_method = v;

	/* last_mod_file_time[2] */
	/* last_mod_file_date[2] */
	// g܂B

	/* crc32[4] */
	// GeneralPurposeBitFlagbit3=1 ̏ꍇA0i[Ă܂B
	// WJɎs܂B
	v = header->crc32[0]
	  | header->crc32[1] <<  8
	  | header->crc32[2] << 16
	  | header->crc32[3] << 24;
	dir->crc32 = v;

	/* compressed_size[4] */
	// GeneralPurposeBitFlagbit3=1 ̏ꍇA0i[Ă܂B
	// WJɎs܂B
	v = header->compressed_size[0]
	  | header->compressed_size[1] <<  8
	  | header->compressed_size[2] << 16
	  | header->compressed_size[3] << 24;
	dir->compressed_size = v;

	/* uncompressed_size[4] */
	// GeneralPurposeBitFlagbit3=1 ̏ꍇA0i[Ă܂B
	// WJɎs܂B
	v = header->uncompressed_size[0]
	  | header->uncompressed_size[1] <<  8
	  | header->uncompressed_size[2] << 16
	  | header->uncompressed_size[3] << 24;
	dir->uncompressed_size = v;

	/* filename_length[2] */
	v = header->filename_length[0]
	  | header->filename_length[1] <<8;
	filename_length = v;

	/* extra_field_length[2] */
	v = header->extra_field_length[0]
	  | header->extra_field_length[1] <<8;
	extra_field_length = v;

	/* filename[filename_length] */
	p = (const unsigned char*)(header + 1);
	if(filename_length <= sizeof dir->filename - 1) {
		memcpy(dir->filename, p, filename_length);
	} else {
		memcpy(dir->filename, p, sizeof dir->filename - 1); /* t@Cꍇ́Aȗ */
	}
	p += filename_length;

	/* extra_field[extra_field_length] */
	// g܂B
	p += extra_field_length;

	/* file_data[compressed_size] */
	dir->file_data = p;
	p += dir->compressed_size;

	/* ̃t@C܂ł̑΋Ԃ܂B
	 * GeneralPurposeBitFlagbit3=1̏ꍇAFileDatǎDataDescriptor݂܂Ał͍lĂ܂B
	 * ̊֐Ԃ΋ɏ]ăt@C񑖍ʒui߂ƁAʒuDataDescriptorwƂɂȂA
	 * t@Cǂݍݎ̃VOl`s܂B
	 * DataDescriptor͋DOSpPKZIPŎgĂ@\݂ŁAŋ߂Zipt@Cł͎gĂȂ悤łB
	 */
	return p - (const unsigned char*)header;
}

/* t@Cr܂B
 * [in]
 *	s1,s2		rt@CB
 * [out]
 *	߂l		vA0Ԃ܂B
 *			vȂ΁A0ȊO̒lԂ܂B
 * [note]
 *	* t@C̑啶Ə͋ʂ܂B
 *	  ܂ApX"/""\"͋ʂ܂B
 */
static int
punzip_strcmp(const char* s1, const char* s2)
{
	int c1, c2;
	do {
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
		if(c1 == '\\') c1 = '/';
		if(c2 == '\\') c2 = '/';
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}

int
punzip_init(PUNZIP* puz, const void* data, int len)
{
	if(len < 0) return ERRNO;

	memset(puz, 0, sizeof(PUNZIP));
	puz->data = (const unsigned char*)data;
	puz->len = len;

	return 0;
}

int
punzip_dir(PUNZIP* puz, PUNZIPDIR* dir)
{
	int retval;

	if(dir) {
		/* ɏI[܂őĂAsłB */
		if(puz->dir_pos >= puz->len) return ERRNO;

		/* t@Cǂݍ݂܂B */
		retval = punzip_getdir(dir, (const PUNZIPLOCALFILEHEADER*)&puz->data[puz->dir_pos]);
		if(retval < 0) return retval;

		/* t@C񑖍ʒu֐i߂܂B */
		puz->dir_pos += retval;
	} else {
		/* t@C񑖍ʒu擪֖߂܂B */
		puz->dir_pos = 0;
	}

	return 0;
}

int
punzip_find(PUNZIP* puz, const char* filename, PUNZIPDIR* dir)
{
	int retval;
	int dir_pos0 = puz->dir_pos; /* t@C񑖍ʒuޔ */

	/* t@C񑖍ʒu擪֖߂܂B */
	punzip_dir(puz, NULL);
	for(;;) {
		/* t@Cǂݍ݂܂B */
		retval = punzip_dir(puz, dir);
		if(retval < 0) break;

		/* t@Cr܂B */
		if(punzip_strcmp(dir->filename, filename) == 0) {
			retval = 0;
			break;
		}
	}

	puz->dir_pos = dir_pos0; /* t@C񑖍ʒu */
	return retval;
}

int
punzip_uncompress(PUNZIP* puz, const char* filename, void* outbuf, int outlen)
{
	int retval;
	int crc32;
	PUNZIPDIR dir;
	PBITSTREAM in;
	PBYTESTREAM out;

	/* t@CT܂B */
	retval = punzip_find(puz, filename, &dir);
	if(retval < 0) return retval;
	if(dir.uncompressed_size > outlen) return ERRNO; /* o̓obt@s */

	switch(dir.compression_method) {
	/*==========================================================*
	 *	Method 0 - The file is stored (no compression)
	 *==========================================================*/
	case 0:
		/* kȂ̂ŁAkTCYƓWJTCY͓͂B */
		if(dir.compressed_size != dir.uncompressed_size) return ERRNO;

		/* kf[^o̓obt@ɃRs[B */
		memcpy(outbuf, dir.file_data, dir.uncompressed_size);

		break;
	/*==========================================================*
	 *	Method 8 - The file is Deflated
	 *==========================================================*/
	case 8:
		/* ̓Xg[B */
		retval = pbitstream_init(&in, dir.file_data, dir.compressed_size);
		if(retval < 0) return retval;

		/* o̓Xg[B */
		retval = pbytestream_init(&out, outbuf, outlen);
		if(retval < 0) return retval;

		/* o̓obt@֓WJB */
		retval = pdeflate_uncompress(&out, &in);
		if(retval < 0) return retval;
		if(retval != dir.uncompressed_size) return ERRNO; /* o̓TCYsv */

		break;
	/*==========================================================*
	 *	̑̈k`ɂ͖ΉłB
	 *==========================================================*/
	default:
		return ERRNO;
	}

	/* CRCB */
	crc32 = pzlib_crc32(outbuf, dir.uncompressed_size);
	if(dir.crc32 != crc32) return ERRNO;

	/* o̓TCYԂ܂B */
	return dir.uncompressed_size;
}

