/*
 *	wav.c
 *
 *	dppcmcnv - WAV to PPD Ro[^
 *	Copyright (C) 2002-2006 Naoyuki Sawa
 *
 *	* Sun Jul 21 04:37:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "app.h"

#define CONVERT_UNIT	65536	/* oCgÂϊ邩H */

/****************************************************************************
 *	wav_new
 ****************************************************************************/

WAV*
wav_new()
{
	WAV* wav;
	wav = (WAV*)calloc(1, sizeof(WAV));
	if(wav == NULL) die("słB");
	return wav;
}

/****************************************************************************
 *	wav_free
 ****************************************************************************/

void
wav_free(WAV* wav)
{
	if(wav == NULL) return;
	if(wav->fmt != NULL) free(wav->fmt);
	if(wav->data != NULL) free(wav->data);
}

/****************************************************************************
 *	wav_load
 ****************************************************************************/

WAV*
wav_load(const char* path)
{
	int retval;
	WAV* wav;
	HMMIO mmio;
	MMCKINFO ck1, ck2;

	/* WAV\̂쐬܂B */
	wav = wav_new();

	/* WAVt@CJ܂B */
	mmio = mmioOpen((char*)path, NULL, MMIO_READ);
	if(mmio == NULL) die("%sJ܂B", path);

	/* RIFF:WAVE`Nɓ܂B */
	memset(&ck1, 0, sizeof(MMCKINFO));
	ck1.ckid    = mmioStringToFOURCC("RIFF", 0); /* MMIO_FINDRIFF́Ackif̎w͏ȗ\ */
	ck1.fccType = mmioStringToFOURCC("WAVE", 0);
	retval = mmioDescend(mmio, &ck1, NULL, MMIO_FINDRIFF);
	if(retval != 0) die("RIFF`N܂B");

	/* fmt`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("fmt", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval != 0) die("fmt`N܂B");

	/* tH[}bgǂݍ݂܂B */
	wav->fmt = (WAVEFORMATEX*)malloc(ck2.cksize);
	if(wav->fmt == NULL) die("słB");
	retval = mmioRead(mmio, (char*)wav->fmt, ck2.cksize);
	if(retval != (int)ck2.cksize) die("tH[}bgǂݍ߂܂B");

	/* fmt`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* data`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("data", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval != 0) die("data`N܂B");

	/* f[^ǂݍ݂܂B */
	wav->c_data = ck2.cksize;
	wav->data = (char*)malloc(wav->c_data);
	if(wav->data == NULL) die("słB");
	retval = mmioRead(mmio, wav->data, wav->c_data);
	if(retval != wav->c_data) die("f[^ǂݍ߂܂B");

	/* data`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* RIFF`N𔲂܂B */
	retval = mmioAscend(mmio, &ck1, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* WAVt@C܂B */
	retval = mmioClose(mmio, 0);
	if(retval != 0) die("mmioClose()s܂B");

	return wav;
}

/****************************************************************************
 *	wav_to_wav
 ****************************************************************************/

void
wav_to_wav(WAV* wav1, WAV* wav2)
{
	int retval, unit1, unit2, flag, ofs, len, cap;
	HACMSTREAM acm;
	ACMSTREAMHEADER stream;

	wav2->c_data = 0; /* Ô */
	free(wav2->data); /* Ô */

	/* ACMXg[J܂B */
	retval = acmStreamOpen(&acm, NULL, wav1->fmt, wav2->fmt, NULL, 0, 0, ACM_STREAMOPENF_NONREALTIME);
	if(retval != 0) die("WAVt@C͕ϊł܂B");

	/* Xg[obt@쐬܂B */
	unit1 = (CONVERT_UNIT + (wav1->fmt->nBlockAlign - 1)) / wav1->fmt->nBlockAlign * wav1->fmt->nBlockAlign;
	retval = acmStreamSize(acm, unit1, &unit2, ACM_STREAMSIZEF_SOURCE);
	if(retval != 0) die("acmStreamSize()s܂B");
	memset(&stream, 0, sizeof stream);
	stream.cbStruct = sizeof stream;
	stream.pbSrc = (unsigned char*)malloc(unit1);
	stream.cbSrcLength = unit1;
	stream.pbDst = (unsigned char*)malloc(unit2);
	stream.cbDstLength = unit2;
	if(stream.pbSrc == NULL || stream.pbDst == NULL) die("słB");
	retval = acmStreamPrepareHeader(acm, &stream, 0);
	if(retval != 0) die("acmStreamPrepareHeader()s܂B");

	/* ϊ[vB */
	ofs = 0;
	cap = 0;
	while(ofs < wav1->c_data) {
		/* ϊ̃f[^ǂݍ݂܂B */
		len = wav1->c_data - ofs;
		if(len > unit1) len = unit1;
		memcpy(stream.pbSrc, wav1->data + ofs, len);
		stream.cbSrcLength = len;
		/* ϊ̃f[^SďƂ͌Ȃ̂ŁA܂ofs͐i߂܂B */

		/* ϊ܂B */
		flag = 0;
		if(ofs       == 0           ) flag |= ACM_STREAMCONVERTF_START;
		if(ofs + len == wav1->c_data) flag |= ACM_STREAMCONVERTF_END  ; /* Yƃf[^̍Ōオ؂鋰ꂪ܂I */
		retval = acmStreamConvert(acm, &stream, flag);
		if(retval != 0) die("acmStreamConvert()s܂B");
		/* ϊ̃f[^ꂽAofsi߂܂B */
		ofs += stream.cbSrcLengthUsed;

		/* ϊ̃f[^݂܂B */
		len = stream.cbDstLengthUsed;
		if(cap < (int)(wav2->c_data + len)) {
			do {
				cap = cap == 0 ? 1 : cap << 1;
				wav2->data = (char*)realloc(wav2->data, cap);
				if(wav2->data == NULL) die("słB");
			} while(cap < (int)(wav2->c_data + len));
		}
		memcpy(wav2->data + wav2->c_data, stream.pbDst, len);
		wav2->c_data += len;
	}

	/* Xg[obt@폜܂B
	 * * acmStreamUnprepareHeader()ĂԑOɁA
	 *   cbSrcLengthacmStreamPrepareHeader()Ɠlɖ߂ĂȂƁA
	 *   acmStreamUnprepareHeader()G[Ԃ悤łB
	 * * Ō̕ϊł́AcbSrcLengthunit1ȒlɂȂĂ̂ŁA
	 *   ̂܂acmStreamUnprepareHeader()Ăł܂ƁAs܂B
	 */
	stream.cbSrcLength = unit1; /* Kv!! */
	retval = acmStreamUnprepareHeader(acm, &stream, 0);
	if(retval != 0) die("acmStreamUnprepareHeader()s܂B");
	free(stream.pbSrc);
	free(stream.pbDst);

	/* ACMXg[܂B */
	retval = acmStreamClose(acm, 0);
	if(retval != 0) die("acmStreamClose()s܂B");
}
