;
;	clipw65a.s
;
;	P/ECE W65C02 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Apr 10 06:09:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipw65a.h"
;
;	clipw65a.h
;
;	P/ECE W65C02 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Apr 10 06:09:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;

; clipw65a.sAframw65a.sɃCN[hĎg܂B

;****************************************************************************
;	W65C02\
;****************************************************************************

				; typedef struct _W65C02 {
;#define _A_		 0	; 	unsigned char a;	/* + 0,1          AAAAAAAA */
;#define C		 1	; 	unsigned char c;	/* + 1,1          -------C */
;#define _NZ_		 2	; 	unsigned short nz;	/* + 2,2 N------- NZZZZZZZ */
;#define DI		 4	; 	unsigned char di;	/* + 4,1          ----DI-- */
;#define V		 5	; 	unsigned char v;	/* + 5,1          V------- */
;#define _Y_		 6	; 	unsigned char y;	/* + 6,1          YYYYYYYY */
;#define _X_		 7	; 	unsigned char x;	/* + 7,1          XXXXXXXX */
;#define _PC_		 8	; 	unsigned short pc;	/* + 8,2 PCPCPCPC PCPCPCPC */
;#define _S_		10	; 	unsigned char s;	/* +10,1          SSSSSSSS */
;#define WI		11	; 	unsigned char wi;	/* +11,1          ------WI */
;#define _CYCLE_		12	; 	int cycle;		/* +12,4 cTCN    */
;#define SIZEOF_W65C02	16	; } W65C02;			/* =16 */

;#define CA		 0					;* + 0,2 -------C AAAAAAAA */

;* W65C02.wi */
;#define IRQ_BIT		 0	; IRQtÕrbgʒu
;#define WAI_BIT		 1	; WAItÕrbgʒu

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define addr	r0	; ݂̖߂AddressModeAAhXێ܂B
			; AddressMode()ݒ肵AAction()QƂ܂B
			; Operation()Ȃ̃[`́AƂĎgpsłB(O)
			; AddressMode𔺂Ȃ߂ɂẮA[NWX^ƂĎgp\łB
;#define data	r1	; ݂̖߂֓nf[^A߂̖߂f[^ێ܂B
			; ǂݍ݂𔺂߂̏ꍇAAction()ݒ肵AOperation()QƂ܂B
			; ݂𔺂߂̏ꍇAOperation()ݒ肵AAction()QƂ܂B
			; ǂݏȂ߂ɂẮA[NWX^ƂĎgp\łB
;#define pseq	r2	; ݂̖߂ɑΉw65c02seqGg̑|C^łB
			; w65c02_run()Aw65c02_run()Action()gp܂B
			; AddressMode()AOperation()Ȃ̃[`́AgpsłB
;#define s0	r3	; ėp[NWX^łB
			; ꎞIɎsReLXg𔲂ĂAlێ܂B
;#define A	r4	; AWX^̒lێ܂B($00..$FF)
;#define Y	r5	; XWX^̒lێ܂B($00..$FF)
;#define X	r6	; YWX^̒lێ܂B($00..$FF)
;#define NZ	r7	; P(N,~Z)\lێ܂B(N------- NZZZZZZZ)
			; P(N)=NZ[15]|NZ[7], P(Z)=(NZ[6:0]==0?1:0)
;		r8	; 
;		r9	; 
;#define PC	r10	; PCWX^̒lێ܂B($0000..$FFFF)
;#define S	r11	; SWX^̒lێ܂B($00..$FF)
;#define t0	r12	; ėp[NWX^łB
			; ꎞIɎsReLXg𔲂ƁAl͔j󂳂܂B
;#define t1	r13	; ėp[NWX^łB
			; ꎞIɎsReLXg𔲂ƁAl͔j󂳂܂B
;#define CPU	r14	; w65c02\̂̐擪AhXێ܂B
;#define CYCLE	r15	; csTCNێ܂B

;****************************************************************************
;	
;****************************************************************************

;****************************************************************************
;	
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

; CPUZbg܂B
;
	.global	w65c02_reset
w65c02_reset:
	ext	w65c02+0x0@h	; 	xld.w	%r12, w65c02			; ܂NA܂B
	ext	w65c02+0x0@m
	ld.w	%r12,w65c02+0x0@l
	ld.w	%r13,0x0	; 	xld.w	%r13, 0
	ld.w	%r14,0x10	; 	xld.w	%r14, 16
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	;
	pushn	%r3
	ext	w65c02_enter@rm	; 	xcall	w65c02_enter			; sReLXg֓܂B
	call	w65c02_enter@rl
	;
	ext	0x3ff		; 	xld.w	%r0, 0xfffc
	ld.w	%r0,0x3c
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data = [$FFFC+0]
	call	w65c02_read@rl
	ld.w	%r10, %r1			; %PC   = [$FFFC+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =           [$FFFC+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; *delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =           [$FFFC+1]<<8
	or	%r10, %r1			; %PC   = [$FFFC+0]|[$FFFC+1]<<8
	;
	ext	0x3		; 	xld.w	%r11, 0xff			; S     = $FF (bBdlł͕s)
	ld.w	%r11,0x3f
	;
	ld.w	%r1,0x4		; 	xld.w	%r1, 0x04			; P     = D=0,I=1
	call	w65c02_set_p	; 	xcall	w65c02_set_p			;       (NVZ=Cb0Bdlł͕s)
	;
	ext	w65c02_leave@rm	; 	xcall	w65c02_leave			; sReLXg𔲂܂B
	call	w65c02_leave@rl
	popn	%r3
	ret

; IRQv܂B
;
	.global	w65c02_irq
w65c02_irq:
	pushn	%r3
	ext	w65c02_enter@rm	; 	xcall	w65c02_enter			; sReLXg֓܂B
	call	w65c02_enter@rl
	;
	ext	0xb		; 	xbset	[%r14+0xb], 0x0		; IRQvtOZbg܂B
	bset	[%r14],0x0
	call	w65c02_check_pending	; 	xcall	w65c02_check_pending		; IRQs\ׂ܂B
	;
	ext	w65c02_leave@rm	; 	xcall	w65c02_leave			; sReLXg𔲂܂B
	call	w65c02_leave@rl
	popn	%r3
	ret

; NMIs܂B
;
	.global	w65c02_nmi
w65c02_nmi:
	pushn	%r3
	ext	w65c02_enter@rm	; 	xcall	w65c02_enter			; sReLXg֓܂B
	call	w65c02_enter@rl
	;
	ext	0x3ff		; 	xld.w	%r0, 0xfffa			; NMIs܂B
	ld.w	%r0,0x3a
	call.d	w65c02_interrupt	; 	xcall.d	w65c02_interrupt
	ld.w	%r1, 0			; *delay*
	;
	ext	w65c02_leave@rm	; 	xcall	w65c02_leave			; sReLXg𔲂܂B
	call	w65c02_leave@rl
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

; PWX^l擾܂B
; [in,out]
;	w65c02.c -------+
;	w65c02.di ---++ |
;	w65c02.v -+  || |
;	          |  || |
;	         NV11DIZC --> %data
;	         |     |
;	%NZ -----+-----+
; [use]
;	%dataɖ߂lݒ肷邱ƈȊÓASWX^ۑ܂B
;
	.global	w65c02_get_p
w65c02_get_p:
	ext	0x4		; 	xld.ub	%r1, [%r14+0x4]		; %data  = 0000DI00
	ld.ub	%r1,[%r14]
	and	%r1,0xc		; 	xand	%r1, %r1, 0x0c
	;
	ext	0x5		; 	xbtst	[%r14+0x5], 0x7			; %data |= 0V000000
	btst	[%r14],0x7
	jreq	3
	ext	       0x1			; (skip?)
	or	%r1, 0x0			; (skip?)
	;
	ext	0x1		; 	xbtst	[%r14+0x1], 0x0			; %data |= 0000000C
	btst	[%r14],0x0
	jreq	2
	or	%r1, 0x1			; (skip?)
	;
	ext	0x4		; 	xand	%r9, %r7, 0x8080		; %data |= N0000000
	ext	0x80
	and	%r9,%r7
	jreq	3
	ext	       0x2			; (skip?)
	or	%r1, 0x0			; (skip?)
	;
	ext	0xff		; 	xand	%r9, %r7, 0xff			; %data |= 000000Z0
	and	%r9,%r7
	jrne	2
	or	%r1, 0x2			; (skip?)
	;
	ret.d
	add	%r1, 0x30			; %data += 00110000 *delay*

; PWX^lݒ肵܂B
; [in,out]
;	          +--------> w65c02.v
;	          |  ++----> w65c02.di
;	          |  || +--> w65c02.c
;	          |  || |
;	data --> NV??DIZC
;	         |     |
;	         +-----+---> %NZ
; [use]
;	%NZɖ߂lݒ肷邱ƈȊÓASWX^ۑ܂B
;
	.global	w65c02_set_p
w65c02_set_p:
	ext	0x4		; 	xld.b	[%r14+0x4], %r1		; DI  = ----DI--
	ld.b	[%r14],%r1
	;
	ld.w	%r9, %r1			; V   = V-------
	sll	%r9,0x1		; 	xsll	%r9, 1
	ext	0x5		; 	xld.b	[%r14+0x5], %r9
	ld.b	[%r14],%r9
	;
	ext	0x1		; 	xld.b	[%r14+0x1], %r1			; C   = -------C
	ld.b	[%r14],%r1
	;
	ld.w	%r7, %r1			; %NZ = N------- 00000000
	sll	%r7,0x8		; 	xsll	%r7, 8
	;
	not	%r9, %r1			; %NZ = N------- 00000010 (Z=0)
	and	%r9,0x2		; 	xand	%r9, %r9, 0x2			;       N------- 00000000 (Z=1)
	ret.d
	or	%r7, %r9			; *delay*

; 荞݂s܂B
; [in]
;		%data	%addr
;		------	------
;	IRQ	0	0xfffe
;	NMI	0	0xfffa
;	BRK	1	0xfffe
;
	.global	w65c02_interrupt
w65c02_interrupt:
	ext	0x1		; 	xxor	%r3, %r1, 1			; %s0   = 0000000b (b=~B)
	xor	%r3,%r1
	;
	add	%r10, %r1			; if B then PC++ (dl)
	ld.w	%r1, %r10
	ext	w65c02_push@rm	; 	xcall.d	w65c02_push			; Push HI(PC)
	call.d	w65c02_push@rl
	srl	%r1, 8			; *delay*
	ext	w65c02_push@rm	; 	xcall.d	w65c02_push			; Push LO(PC)
	call.d	w65c02_push@rl
	ld.ub	%r1, %r10			; *delay*
	;
	call.d	w65c02_get_p	; 	xcall.d	w65c02_get_p			; %data = NV11DIZC
	sll	%r3, 4				; %s0   = 000b0000 *delay*
	ext	w65c02_push@rm	; 	xcall.d	w65c02_push			; Push P
	call.d	w65c02_push@rl
	xor	%r1, %r3			; %data = NV1BDIZC *delay*
	;
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data = [vector+0]
	call	w65c02_read@rl
	ld.w	%r10, %r1			; %PC   = [vector+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =            [vector+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; *delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =            [vector+1]<<8
	or	%r10, %r1			; %PC   = [vector+0]|[vector+1]<<8
	;
	ld.w	%r9,0x4		; 	xld.w	%r9, 0x04			; D=0,I=1 (D=065C02gdl)
	ext	0x4		; 	xld.b	[%r14+0x4], %r9
	ld.b	[%r14],%r9
	ext	0xb		; 	xbclr	[%r14+0xb], 0x1		; 荞ݔɂAWAI܂B
	bclr	[%r14],0x1
	;
	ret

; ۗĂIRQv𒲂ׁAs\ȂΎs܂B
;
	.global	w65c02_check_pending
w65c02_check_pending:
	ext	0x4		; 	xbtst	[%r14+0x4], 0x2			; IRQ}XNĂȂ?
	btst	[%r14],0x2
	jrne	w65c02_check_pending_EXIT	; 	xjrne	w65c02_check_pending_EXIT
	ext	0xb		; 	xbtst	[%r14+0xb], 0x0		; IRQvۗĂ邩?
	btst	[%r14],0x0
	jreq	w65c02_check_pending_EXIT	; 	xjreq	w65c02_check_pending_EXIT
	;
	ext	0xb		; 	xbclr	[%r14+0xb], 0x0		; IRQvtONA܂B
	bclr	[%r14],0x0
	ext	0x3ff		; 	xld.w	%r0, 0xfffe			; IRQs܂B
	ld.w	%r0,0x3e
	call.d	w65c02_interrupt	; 	xcall.d	w65c02_interrupt
	ld.w	%r1, 0			; *delay*
	;
w65c02_check_pending_EXIT:
	ret

;****************************************************************************
;	AddressMode (gppxႢ)
;****************************************************************************

	.global	w65c02_IaI
w65c02_IaI:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [PC+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; %addr =  PC+0			*delay*
	ld.w	%r3, %r1			; %s0   = [PC+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [PC+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         PC+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [PC+1]<<8
	or	%r3, %r1			; %s0   = [PC+0]|[PC+1]<<8
	add	%r10, 2				; PC+=2
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [a+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r3			; %addr =  a+0			*delay*
	ld.w	%r3, %r1			; %s0   = [a+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =       [a+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =        a+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =       [a+1]<<8
	or	%r3, %r1			; %s0   = [a+0]|[a+1]<<8
	ret.d
	ld.w	%r0, %r3			; %addr = (a)			*delay*

	.global	w65c02_Ia_xI
w65c02_Ia_xI:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [PC+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; %addr =  PC+0			*delay*
	ld.w	%r3, %r1			; %s0   = [PC+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [PC+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         PC+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [PC+1]<<8
	or	%r3, %r1			; %s0   = [PC+0]|[PC+1]<<8
	add	%r10, 2				; PC+=2
	add	%r3, %r6				; %s0   =  a+X
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [a+X+0]
	call.d	w65c02_read@rl
	ld.uh	%r0, %r3			; %addr =  a+X+0 ($0000..$FFFF)	*delay*
	ld.w	%r3, %r1			; %s0   = [a+X+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =         [a+X+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =          a+X+1	*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =         [a+X+1]<<8
	or	%r3, %r1			; %s0   = [a+X+0]|[a+X+1]<<8
	ret.d
	ld.w	%r0, %r3			; %addr = (a+X)			*delay*

;****************************************************************************
;	Operation (gppxႢ)
;****************************************************************************

	.global	w65c02_ERR
w65c02_ERR:
	ext	w65c02_leave@rm	; 	xcall	w65c02_leave			; sReLXg𔲂܂B
	call	w65c02_leave@rl
	ext	w65c02_err@rm	; 	xjp	w65c02_err			; Cł̃G[[`ցB
	jp	w65c02_err@rl

;----------------------------------------------------------------------------

	.global	w65c02_ADCD
w65c02_ADCD:
	ext	w65c02_leave@rm	; 	xcall	w65c02_leave
	call	w65c02_leave@rl
	ext	w65c02_adcd@rm	; 	xcall.d	w65c02_adcd
	call.d	w65c02_adcd@rl
	ld.w	%r12, %r1			; *delay*
	ext	w65c02_enter@rm	; 	xjp	w65c02_enter
	jp	w65c02_enter@rl

	.global	w65c02_SBCD
w65c02_SBCD:
	ext	w65c02_leave@rm	; 	xcall	w65c02_leave
	call	w65c02_leave@rl
	ext	w65c02_sbcd@rm	; 	xcall.d	w65c02_sbcd
	call.d	w65c02_sbcd@rl
	ld.w	%r12, %r1			; *delay*
	ext	w65c02_enter@rm	; 	xjp	w65c02_enter
	jp	w65c02_enter@rl

;----------------------------------------------------------------------------

	.global	w65c02_TRB
w65c02_TRB:
	ld.w	%r12, %r7		; %t0 = n------- n-------
	srl	%r7,0x8		; 	xsrl	%r7, 8			; %NZ =          n-------
	or	%r7, %r12		; %NZ =          N-------
	;xsll	%NZ, 8			; %NZ = N------- 00000000 -----------+
	;				;                                    |
	ld.w	%r12, %r1		; %NZ = N------- 0000000Z            |
	and	%r12, %r4			;                       |            |
	jreq.d	3			;  (data & A) ? 0 : 1 --+            |
	sll	%r7,0x8		; 	 xsll	%r7, 8			; %NZ = N------- 00000000 *delay* <--+
	or	%r7, 1			;                         (skip?)
	;
	not	%r12, %r4			; %data = data & ~A
	ret.d
	and	%r1, %r12		; *delay*

	.global	w65c02_TSB
w65c02_TSB:
	ld.w	%r12, %r7		; %t0 = n------- n-------
	srl	%r7,0x8		; 	xsrl	%r7, 8			; %NZ =          n-------
	or	%r7, %r12		; %NZ =          N-------
	;xsll	%NZ, 8			; %NZ = N------- 00000000 -----------+
	;				;                                    |
	ld.w	%r12, %r1		; %NZ = N------- 0000000Z            |
	and	%r12, %r4			;                       |            |
	jreq.d	3			;  (data & A) ? 0 : 1 --+            |
	sll	%r7,0x8		; 	 xsll	%r7, 8			; %NZ = N------- 00000000 *delay* <--+
	or	%r7, 1			;                         (skip?)
	;
	ret.d
	or	%r1, %r4		; %data = data | A *delay*

;----------------------------------------------------------------------------

	.global	w65c02_CLI
w65c02_CLI:
	ext	0x4		; 	xbclr	[%r14+0x4], 0x2
	bclr	[%r14],0x2
	jp	w65c02_check_pending	; 	xjp	w65c02_check_pending		; ۗĂIRQv𒲂ׂ܂B

	.global	w65c02_SEI
w65c02_SEI:
	ext	0x4		; 	xbset	[%r14+0x4], 0x2
	bset	[%r14],0x2
	ret

	.global	w65c02_CLD
w65c02_CLD:
	ext	0x4		; 	xbclr	[%r14+0x4], 0x3
	bclr	[%r14],0x3
	ret

	.global	w65c02_SED
w65c02_SED:
	ext	0x4		; 	xbset	[%r14+0x4], 0x3
	bset	[%r14],0x3
	ret

	.global	w65c02_CLV
w65c02_CLV:
	ext	0x5		; 	xbclr	[%r14+0x5], 0x7
	bclr	[%r14],0x7
	ret

;----------------------------------------------------------------------------

	.global	w65c02_NOP
w65c02_NOP:
	ret

	.global	w65c02_WAI
w65c02_WAI:
	ext	0xb		; 	xbset	[%r14+0xb], 0x1
	bset	[%r14],0x1
	ret.d
	ld.w	%r15, 0			; *delay*

	.global	w65c02_STP
w65c02_STP:
	ret.d
	sub	%r10, 1				; *delay*

	.global	w65c02_BRK
w65c02_BRK:
	ext	0x3ff		; 	xld.w	%r0, 0xfffe			; BRKs܂B
	ld.w	%r0,0x3e
	ext	w65c02_interrupt@rm	; 	xjp.d	w65c02_interrupt
	jp.d	w65c02_interrupt@rl
	ld.w	%r1, 1			; *delay*

	.global	w65c02_RTI
w65c02_RTI:
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull P
	call	w65c02_pull@rl
	ext	w65c02_set_p@rm	; 	xcall	w65c02_set_p
	call	w65c02_set_p@rl
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull LO(PC)
	call	w65c02_pull@rl
	ext	w65c02_pull@rm	; 	xcall.d	w65c02_pull			; Pull HI(PC)
	call.d	w65c02_pull@rl
	ld.w	%r10, %r1			; *delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %PC = PC
	ext	w65c02_check_pending@rm	; 	xjp.d	w65c02_check_pending		; ۗĂIRQv𒲂ׂ܂B
	jp.d	w65c02_check_pending@rl
	or	%r10, %r1			; *delay*

;----------------------------------------------------------------------------

	.global	w65c02_BBR0
	.global	w65c02_BBS0
w65c02_BBR0:
w65c02_BBS0:
	and	%r1,0x1		; 	xand	%r1, %r1, 0x1
	ret

	.global	w65c02_BBR1
	.global	w65c02_BBS1
w65c02_BBR1:
w65c02_BBS1:
	and	%r1,0x2		; 	xand	%r1, %r1, 0x2
	ret

	.global	w65c02_BBR2
	.global	w65c02_BBS2
w65c02_BBR2:
w65c02_BBS2:
	and	%r1,0x4		; 	xand	%r1, %r1, 0x4
	ret

	.global	w65c02_BBR3
	.global	w65c02_BBS3
w65c02_BBR3:
w65c02_BBS3:
	and	%r1,0x8		; 	xand	%r1, %r1, 0x8
	ret

	.global	w65c02_BBR4
	.global	w65c02_BBS4
w65c02_BBR4:
w65c02_BBS4:
	and	%r1,0x10	; 	xand	%r1, %r1, 0x10
	ret

	.global	w65c02_BBR5
	.global	w65c02_BBS5
w65c02_BBR5:
w65c02_BBS5:
	ext	0x0		; 	xand	%r1, %r1, 0x20
	and	%r1,0x20
	ret

	.global	w65c02_BBR6
	.global	w65c02_BBS6
w65c02_BBR6:
w65c02_BBS6:
	ext	0x1		; 	xand	%r1, %r1, 0x40
	and	%r1,0x0
	ret

	.global	w65c02_BBR7
	.global	w65c02_BBS7
w65c02_BBR7:
w65c02_BBS7:
	ext	0x2		; 	xand	%r1, %r1, 0x80
	and	%r1,0x0
	ret

;----------------------------------------------------------------------------

	.global	w65c02_RMB0
w65c02_RMB0:
	and	%r1,0x3e	; 	xand	%r1, %r1, -2
	ret

	.global	w65c02_RMB1
w65c02_RMB1:
	and	%r1,0x3d	; 	xand	%r1, %r1, -3
	ret

	.global	w65c02_RMB2
w65c02_RMB2:
	and	%r1,0x3b	; 	xand	%r1, %r1, -5
	ret

	.global	w65c02_RMB3
w65c02_RMB3:
	and	%r1,0x37	; 	xand	%r1, %r1, -9
	ret

	.global	w65c02_RMB4
w65c02_RMB4:
	and	%r1,0x2f	; 	xand	%r1, %r1, -17
	ret

	.global	w65c02_RMB5
w65c02_RMB5:
	ext	0x1fff		; 	xand	%r1, %r1, -33
	and	%r1,0x1f
	ret

	.global	w65c02_RMB6
w65c02_RMB6:
	ext	0x1ffe		; 	xand	%r1, %r1, -65
	and	%r1,0x3f
	ret

	.global	w65c02_RMB7
w65c02_RMB7:
	ext	0x1ffd		; 	xand	%r1, %r1, -129
	and	%r1,0x3f
	ret

	.global	w65c02_SMB0
w65c02_SMB0:
	or	%r1,0x1		; 	xoor	%r1, %r1, 0x1
	ret

	.global	w65c02_SMB1
w65c02_SMB1:
	or	%r1,0x2		; 	xoor	%r1, %r1, 0x2
	ret

	.global	w65c02_SMB2
w65c02_SMB2:
	or	%r1,0x4		; 	xoor	%r1, %r1, 0x4
	ret

	.global	w65c02_SMB3
w65c02_SMB3:
	or	%r1,0x8		; 	xoor	%r1, %r1, 0x8
	ret

	.global	w65c02_SMB4
w65c02_SMB4:
	or	%r1,0x10	; 	xoor	%r1, %r1, 0x10
	ret

	.global	w65c02_SMB5
w65c02_SMB5:
	ext	0x0		; 	xoor	%r1, %r1, 0x20
	or	%r1,0x20
	ret

	.global	w65c02_SMB6
w65c02_SMB6:
	ext	0x1		; 	xoor	%r1, %r1, 0x40
	or	%r1,0x0
	ret

	.global	w65c02_SMB7
w65c02_SMB7:
	ext	0x2		; 	xoor	%r1, %r1, 0x80
	or	%r1,0x0
	ret

;****************************************************************************
;	
;****************************************************************************
