/*	
 *	cliptga.c
 *
 *	TGA Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Sun Apr 26 17:16:49 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

void
tga_decode(const void* _p,
	void (*size_proc)(int w, int h, void* user_data),
	void (*draw_proc)(int x, int y, int r, int g, int b, int a, void* user_data),
	void* user_data)
{
	const unsigned char* p = _p;
	/* TGA File Header */
	int ID_Length;
	int Color_Map_Type;
	int Image_Type;
	/* Color Map Specification */
	int First_Entry_Index;
	int Color_map_Length;
	int Color_map_Entry_Size;
	/* Image Specification */
	//int X_origin_of_Image;
	//int Y_origin_of_Image;
	int Image_Width;
	int Image_Height;
	int Pixel_Depth;
	int Image_Descriptor;
	/* Image/Color Map Data */
	//const unsigned char* Image_ID;
	const unsigned char* Color_Map_Data;
	//const unsigned char* Image_Data;

	/* TGA File Header */
	ID_Length            = p[ 0];
	Color_Map_Type       = p[ 1];
	Image_Type           = p[ 2];
	/* Color Map Specification */
	First_Entry_Index    = p[ 3] | p[ 4] << 8;
	Color_map_Length     = p[ 5] | p[ 6] << 8;
	Color_map_Entry_Size = p[ 7];
	/* Image Specification */
	//X_origin_of_Image  = p[ 8] | p[ 9] << 8;
	//Y_origin_of_Image  = p[10] | p[11] << 8;
	Image_Width          = p[12] | p[13] << 8;
	Image_Height         = p[14] | p[15] << 8;
	Pixel_Depth          = p[16];
	Image_Descriptor     = p[17];
	/* Image/Color Map Data */
	p += 18;
	//Image_ID = p;
	p += ID_Length;
	if(Color_Map_Type) {
		Color_Map_Data = p;
		p += ((Color_map_Entry_Size + 7) / 8) * Color_map_Length;
	} else {
		Color_Map_Data = NULL;
	}
	//Image_Data = p;

	if(size_proc) {
		size_proc(Image_Width, Image_Height, user_data);
	}
	if(draw_proc) {
		int Packet_Type = 0;
		int Pixel_Count = (Image_Type & 8) ? 0 : (Image_Width * Image_Height);
		int x, y;
		for(y = 0; y < Image_Height; y++) {
			for(x = 0; x < Image_Width; x++) {
				const unsigned char* Pixel_Data;
				int bits_per_pixel = Pixel_Depth;
				int i, r, g, b, a = 255;
				if(!Pixel_Count--) {
					Packet_Type = (p[0] & 0x80);
					Pixel_Count = (p[0] & 0x7F);
					p += 1;
				}
				Pixel_Data = p;
				if(!Packet_Type || !Pixel_Count) {
					p += (Pixel_Depth + 7) / 8;
				}
				switch(Image_Type & ~8) {
				case 1: /* COLOR-MAPPED IMAGES */
					switch(bits_per_pixel) {
					case 8:
						i = Pixel_Data[0] - First_Entry_Index;
						Pixel_Data = Color_Map_Data + ((Color_map_Entry_Size + 7) / 8) * i;
						bits_per_pixel = Color_map_Entry_Size;
						break;
					default:
						DIE();
					}
					/* FALLTHRU */
				case 2: /* TRUE-COLOR IMAGES */
					switch(bits_per_pixel) {
					case 32: /* 8 bits per primary including Alpha channel */
						a = Pixel_Data[3];
						/* FALLTHRU */
					case 24: /* 8 bits per primary */
						r = Pixel_Data[2];
						g = Pixel_Data[1];
						b = Pixel_Data[0];
						break;
					case 16: /* 5 bits per primary with 1 bit to select interrupt control */
					case 15: /* 5 bits per primary */
						r =                               (Pixel_Data[1] & 0x7C) >> 2;
						g = (Pixel_Data[0] & 0xE0) >> 5 | (Pixel_Data[1] & 0x03) << 3;
						b = (Pixel_Data[0] & 0x1F) >> 0;
						r = (r << 3) | (r >> 2);
						g = (g << 3) | (g >> 2);
						b = (b << 3) | (b >> 2);
						break;
					default:
						DIE();
					}
					break;
				case 3: /* BLACK AND WHITE (UNMAPPED) IMAGES */
					switch(bits_per_pixel) {
					case 8:
						r = Pixel_Data[0];
						g = Pixel_Data[0];
						b = Pixel_Data[0];
						break;
					default:
						DIE();
					}
					break;
				default:
					DIE();
				}
				draw_proc((Image_Descriptor & 0x10) ? (Image_Width  - 1 - x) : x,
				         !(Image_Descriptor & 0x20) ? (Image_Height - 1 - y) : y, r, g, b, a, user_data);
			}
		}
	}
}
