/*	
 *	clipp62.h
 *
 *	P/ECE HuC6280-PSG Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_P62_H__
#define __CLIP_P62_H__

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	HuC6280-PSG`l
 */
typedef struct _HUC6280PSGCHANNEL {
	unsigned char reg[6];		/* + 0, 6: $0802`$0807̒lێ */
	//
	unsigned char enable;		/* + 6, 1: `l  1:ON/0:OFF */
	unsigned char dda;		/* + 7, 1: DirectD/A 1:ON/0:OFF */
	unsigned char noise;		/* + 8, 1: mCY    1:ON/0:OFF (Ch4,5̂) */
	unsigned char wave_index;	/* + 9, 1: g`f[^݃CfNX */
	//
	short volume;			/* +10, 2: {[ (14bit) */
	//
	int tone_period;		/* +12, 4: g[ */
	int tone_progress;		/* +16, 4: g[isJE^ */
	//
	int noise_period;		/* +20, 4: mCY */
	int noise_progress;		/* +24, 4: mCYisJE^ */
	//
	unsigned short tone_index;	/* +28, 2: g[g`CfNX */
	unsigned short noise_lfsr;	/* +30, 2: mCYLFSR(Linear Feedback Shift Register) */
	//
	char wave[32];			/* +32,32: g`f[^ (DDAwave[0]o) */
} HUC6280PSGCHANNEL;			/* =64 */

/*
 *	HuC6280-PSGRA
 */
typedef struct _HUC6280PSG {
	int channel_select;		/* ݒ`lI */
	int main_volume;		/* C{[ (`l{[XV̂ݎQ) */
	HUC6280PSGCHANNEL channel[6];	/* `l */
	//
	DDA clock_progress;		/* NbNisDDA */
} HUC6280PSG;

/****************************************************************************
 *	֐
 ****************************************************************************/

void huc6280psg_update_volume(HUC6280PSG* psg, HUC6280PSGCHANNEL* channel);

int huc6280psg_process(HUC6280PSG* psg, int cycle);
int huc6280psg_channel_process(HUC6280PSG* psg, HUC6280PSGCHANNEL* channel, int cycle);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* HuC6280-PSGRAZbg܂B
 * [in]
 *	psg		HUC6280PSG\́B
 *	clock		̓NbNB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́AHuC6280-PSGZbgsꍇɁAKvɉČĂяoĂB
 */
void huc6280psg_reset(HUC6280PSG* psg, int clock);

/* WX^l݂܂B
 * [in]
 *	psg		HUC6280PSG\́B
 *	addr		WX^AhXB(0`9)
 *	data		WX^lB
 */
void huc6280psg_write(HUC6280PSG* psg, int addr, unsigned char data);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAw肳ꂽTṽ~LVOs܂B
 * [in]
 *	psg		HUC6280PSG\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void huc6280psg_mix(HUC6280PSG* psg, short wbuff[/*count*/], int count);

#endif /*__CLIP_P62_H__*/
