/*	
 *	clipip.c
 *
 *	IPvgRhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Aug 25 05:43:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

#define DEFAULT_TIMEOUT	1000	/* ^CAEgԂ̊l[~b] */

/****************************************************************************
 *	ARPvgRhCo
 ****************************************************************************/

#define ARP_TABLE_SIZE	16	/* ARPe[u̗vf () */

/* ARPvgRhCo\ */
typedef struct _ARPDRIVER {
	ETHERNETCLIENT ethernet_client;		/* EthernetNCAgo^p */
	ARPENTRY table[ARP_TABLE_SIZE];		/* ARPe[u */
} ARPDRIVER;
static ARPDRIVER arp_driver;

static void arp_start();
static void arp_stop();
static void arp_recv(ETHERNETCLIENT* ethernet_client, const unsigned char* address/*[6]*/, const unsigned char* data/*[length]*/, int length);
static void arp_conf(ETHERNETCLIENT* ethernet_client);
static int arp_get_address(int ip_address, unsigned char ethernet_address[6]);
static void arp_set_address(int ip_address, const unsigned char ethernet_address[6]);

/*--------------------------------------------------------------------------*/

static void
arp_start()
{
	/* hCo\̂NA܂B */
	memset(&arp_driver, 0, sizeof arp_driver);

	/* ARPvgRhCoJn܂B */
	arp_driver.ethernet_client.type = 0x0806/*ARP*/;
	arp_driver.ethernet_client.recv = arp_recv;
	arp_driver.ethernet_client.conf = arp_conf;
	ethernet_open(&arp_driver.ethernet_client);
}

static void
arp_stop()
{
	/* ARPvgRhCo~܂B */
	ethernet_close(&arp_driver.ethernet_client);

	/* hCo\̂NA܂B */
	memset(&arp_driver, 0, sizeof arp_driver);
}

static void
arp_recv(ETHERNETCLIENT* ethernet_client, const unsigned char* address/*[6]*/, const unsigned char* _data/*[length]*/, int length)
{
	unsigned char* data = (unsigned char*)_data;
	//
	unsigned char dummy[6];
	IPCONFIG ip_config;
	ip_get_config(&ip_config);

	if(length < 28) {
		return;
	}
	if(BEHALF(data + 0) != 1) {			/* + 0,2: n[hEFAAhX̎ (Ethernet) */
		return;
	}
	if(BEHALF(data + 2) != 0x0800) {		/* + 2,2: _AhX̎ (IP) */
		return;
	}
	if(BEBYTE(data + 4) != 6) {			/* + 4,1: n[hEFAAhX */
		return;
	}
	if(BEBYTE(data + 5) != 4) {			/* + 5,1: _AhX */
		return;
	}

	switch(BEHALF(data + 6)) {			/* + 6,2: Iy[VR[h */
	case 1: /* ARPv */

		/* ĐIPAhXAIPAhXɈv... */
		if(BEWORD(data + 24) == ip_config.ip_address) {			/* +24,  4: Đ_AhX */

			/* MIPAhXEthernetAhX̑ΉAIP->EthernetAhXϊ\ɓo^܂B */
			arp_set_address(BEWORD(data + 14),			/* +14,  4: M_AhX */
					       data +  8);			/* + 8,  6: Mn[hEFAAhX */

			/* ARPpPbgԑ܂B */
			          PUT_BEHALF(data +  6, 2);			/* + 6,  2: Iy[VR[h (ARP) */
			              memcpy(data + 18, data + 8, 6 + 4);	/* +18,6+4: Đn[hEFAAhXAĐ_AhX */
			ethernet_get_address(data +  8);			/* + 8,  6: Mn[hEFAAhX */
			          PUT_BEWORD(data + 14, ip_config.ip_address);	/* +14,  4: M_AhX */
			ethernet_send(&arp_driver.ethernet_client, address, data, 28);

		/* ĐIPAhXAIPAhXɈvȂ... */
		} else {

			/* MIPAhXAARPe[uɓo^Ăꍇ̂݁AXV܂B(Gratuitous ARP) */
			if(arp_get_address(BEWORD(data + 14), dummy)) {		/* +14,  4: M_AhX */
			   arp_set_address(BEWORD(data + 14),			/* +14,  4: M_AhX */
						  data +  8);			/* + 8,  6: Mn[hEFAAhX */
			}
		}

		return;

	case 2: /* ARP */
	case 3: /* RARPv */
	case 4: /* RARP */

		/* ĐIPAhXAIPAhXɈv... */
		if(BEWORD(data + 24) == ip_config.ip_address) {			/* +24,  4: Đ_AhX */

			/* MIPAhXEthernetAhX̑ΉAIP->EthernetAhXϊ\ɓo^܂B */
			arp_set_address(BEWORD(data + 14),			/* +14,  4: M_AhX */
					       data +  8);			/* + 8,  6: Mn[hEFAAhX */

		/* ĐIPAhXAIPAhXɈvȂ... */
		} else {

			/* MIPAhXAARPe[uɓo^Ăꍇ̂݁AXV܂B(Gratuitous ARP) */
			if(arp_get_address(BEWORD(data + 14), dummy)) {		/* +14,  4: M_AhX */
			   arp_set_address(BEWORD(data + 14),			/* +14,  4: M_AhX */
						  data +  8);			/* + 8,  6: Mn[hEFAAhX */
			}
		}

		return;
	}
}

static void
arp_conf(ETHERNETCLIENT* ethernet_client)
{
	/* EthernetAhXω܂B
	 * lbg[Nݒ̏Ă΁AGratuitous ARP𑗏o܂B
	 */
	arp_gratuitous();

	/* 2005/08/27݁AcOȂAőoGratuitous ARPLANzXg֓͂܂B
	 * ڂ́Aarp_gratuitous()֐錾̃RgQƂĂB
	 * Windows XP̃lbg[NubW^C~Ox߂ɁALANzXg֓͂Ȃ̂łA
	 * Gratuitous ARP𑗏o邱Ǝ̂͊ԈĂȂ̂ŁÂ܂܎cĂƂɂ܂B(Qł)
	 */
}

int
arp_gratuitous()
{
	int retval;
	unsigned char ethernet_address[6];
	IPCONFIG ip_config;
	unsigned char data[28];

	/* EthernetAhXݒȂ΁AGratuitous ARP͔s܂B */
	ethernet_get_address(ethernet_address);
	if(memcmp(ethernet_address, ethernet_null_address, 6) == 0) {
		return -1;
	}

	/* IPAhXݒȂ΁AGratuitous ARP͔s܂B */
	ip_get_config(&ip_config);
	if(!ip_config.ip_address) {
		return -1;
	}

#if 1	/*----------------------------------------------------------------------------------------------*/

	/* Gratuitous ARP𔭍s܂B(IPAhXARPvu[hLXg) */
	PUT_BEHALF(data +  0, 1);			/* + 0,2: n[hEFAAhX̎ (Ethernet) */
	PUT_BEHALF(data +  2, 0x0800);			/* + 2,2: _AhX̎ (IP) */
	PUT_BEBYTE(data +  4, 6);			/* + 4,1: n[hEFAAhX */
	PUT_BEBYTE(data +  5, 4);			/* + 5,1: _AhX */
	PUT_BEHALF(data +  6, 1);			/* + 6,2: Iy[VR[h (ARPv) */
	    memcpy(data +  8, ethernet_address, 6);	/* + 8,6: Mn[hEFAAhX () */
	PUT_BEWORD(data + 14, ip_config.ip_address);	/* +14,4: M_AhX         () */
	    memcpy(data + 18, ethernet_null_address, 6);/* +18,6: Đn[hEFAAhX (Null) */
	PUT_BEWORD(data + 24, ip_config.ip_address);	/* +24,4: Đ_AhX         () */
	retval = ethernet_send(&arp_driver.ethernet_client, ethernet_broadcast_address, data, 28);
	if(retval < 0) {
		return -1; /* ML[ς */
	}

#else	/*-------------------- Gratuitous ARP̎dlł́AǂłOK݂ł --------------------*/

	/* Gratuitous ARP𔭍s܂B(IPAhXARPu[hLXg) */
	PUT_BEHALF(data +  0, 1);			/* + 0,2: n[hEFAAhX̎ (Ethernet) */
	PUT_BEHALF(data +  2, 0x0800);			/* + 2,2: _AhX̎ (IP) */
	PUT_BEBYTE(data +  4, 6);			/* + 4,1: n[hEFAAhX */
	PUT_BEBYTE(data +  5, 4);			/* + 5,1: _AhX */
	PUT_BEHALF(data +  6, 2);			/* + 6,2: Iy[VR[h (ARP) */
	    memcpy(data +  8, ethernet_address, 6);	/* + 8,6: Mn[hEFAAhX () */
	PUT_BEWORD(data + 14, ip_config.ip_address);	/* +14,4: M_AhX         () */
	    memcpy(data + 18, ethernet_address, 6);	/* +18,6: Đn[hEFAAhX () */
	PUT_BEWORD(data + 24, ip_config.ip_address);	/* +24,4: Đ_AhX         () */
	retval = ethernet_send(&arp_driver.ethernet_client, ethernet_broadcast_address, data, 28);
	if(retval < 0) {
		return -1; /* ML[ς */
	}

#endif	/*----------------------------------------------------------------------------------------------*/

	return 0;
}

/* ARPe[uAw肳ꂽIPAhXɑΉAEthernetAhX擾܂B
 * 擾vfAARPe[u̐擪ֈړ܂B(MRU)
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static int
arp_get_address(int ip_address, unsigned char* ethernet_address/*[6]*/)
{
	int i;

	/* w肳ꂽIPAhXɈvvf܂B */
	for(i = 0; i < ARP_TABLE_SIZE; i++) {
		if(arp_driver.table[i].ip_address == ip_address) {
			/* vvfEthernetAhXAw肳ꂽobt@֊i[܂B */
			memcpy(ethernet_address, arp_driver.table[i].ethernet_address, 6);
			/* vvfO̗vfAЂƂÂւ炵܂B */
			memmove(&arp_driver.table[1], &arp_driver.table[0], sizeof(ARPENTRY) * i);
			/* vvfƓeA擪̗vfɊi[܂B */
			arp_driver.table[0].ip_address = ip_address;
			memcpy(arp_driver.table[0].ethernet_address, ethernet_address, 6);
			return 0; /*  */
		}
	}

	return -1; /* s */
}

/* ARPe[uɁAIPAhXEthernetAhX̑go^A܂́AXV܂B
 * o^A܂́AXVvfAARPe[u̐擪ֈړ܂B(MRU)
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static void
arp_set_address(int ip_address, const unsigned char* ethernet_address/*[6]*/)
{
	int i;

	/* w肳ꂽIPAhXɈvvfA܂́A̗vf폜A
	 * 폜vfO̗vfAЂƂÂւ炵܂B
	 */
	for(i = 0; i < ARP_TABLE_SIZE - 1/*!!*/; i++) {
		if(arp_driver.table[i].ip_address == ip_address) {
			break;
		}
	}
	memmove(&arp_driver.table[1], &arp_driver.table[0], sizeof(ARPENTRY) * i);

	/* 擪̗vfɁAIPAhXEthernetAhX̑Ήi[܂B */
	arp_driver.table[0].ip_address = ip_address;
	memcpy(arp_driver.table[0].ethernet_address, ethernet_address, 6);
}

int
arp_request(int ip_address, unsigned char* ethernet_address/*[6]*/, int timeout)
{
	int T0 = pceTimerGetCount();	/* ^CAEg̊ */
	int send_ok = 0;		/* ARPvpPbg𑗐MA1ɂȂ܂ */
	//
	int retval;

	/* 荞݋ԂŌĂ΂ꂽꍇ́AARPvpPbgMɁAARPpPbg҂܂B */
	if(ENABLED) {
		if(timeout < 0) {	/* ̃^CAEglw肳ꂽꍇ́AlƂ܂ */
			timeout = DEFAULT_TIMEOUT;
		}
	} else {
		timeout = 0;		/* 荞݋֎~ŌĂ΂ꂽꍇ́AɃ^CAEg܂ */
	}

	do {
ENTER_CS;
		/* ARPe[uAw肳ꂽIPAhXɑΉEthernetAhX擾܂B */
		retval = arp_get_address(ip_address, ethernet_address);
LEAVE_CS;
		/* EthernetAhX擾łA(0)Ԃ܂B */
		if(retval == 0) {
			return 0;
		}

		/* ARPvpPbgu[hLXg܂B */
		if(!send_ok) {
			unsigned char data[28];
			IPCONFIG ip_config;
			ip_get_config(&ip_config);
			          PUT_BEHALF(data +  0, 1);			/* + 0,2: n[hEFAAhX̎ (Ethernet) */
			          PUT_BEHALF(data +  2, 0x0800);		/* + 2,2: _AhX̎ (IP) */
			          PUT_BEBYTE(data +  4, 6);			/* + 4,1: n[hEFAAhX */
			          PUT_BEBYTE(data +  5, 4);			/* + 5,1: _AhX */
			          PUT_BEHALF(data +  6, 1);			/* + 6,2: Iy[VR[h (ARPv) */
			ethernet_get_address(data +  8);			/* + 8,6: Mn[hEFAAhX */
			          PUT_BEWORD(data + 14, ip_config.ip_address);	/* +14,4: M_AhX */
			              memset(data + 18, 0, 6);			/* +18,6: Đn[hEFAAhX (0) */
			          PUT_BEWORD(data + 24, ip_address);		/* +24,4: Đ_AhX */
										/* =28 */
			retval = ethernet_send(&arp_driver.ethernet_client, ethernet_broadcast_address, data, 28);
			if(retval >= 0) {
				send_ok = 1; /* Aȍ~͑M܂ */
			}
		}
	} while(pceTimerGetCount() - T0 < timeout); /* ^CAEg܂ŁAARPpPbg҂܂ */

	/* EthernetAhX擾łȂ΁As()Ԃ܂B */
	return -1;
}

int
arp_table(ARPENTRY* table/*[table_size]*/, int table_size)
{
	int i;

	if(table_size > ARP_TABLE_SIZE) {
		table_size = ARP_TABLE_SIZE;
	}

ENTER_CS;

	for(i = 0; i < table_size; i++) {
		if(!arp_driver.table[i].ip_address) {
			break;
		}
		table[i] = arp_driver.table[i];
	}

LEAVE_CS;

	return i;
}

/****************************************************************************
 *	ICMPvgRhCo
 ****************************************************************************/

/* ICMPvgRhCo\ */
typedef struct _ICMPDRIVER {
	IPCLIENT ip_client;		/* IPNCAgo^p */
	/*{{icmp_echo_request()*/
	int echo_address;		/* GR[v𑗐MAĐAhX */
	int echo_identifier;		/* GR[vbZ[Wɐݒ肵Aʎq */
	int echo_sequence;		/* GR[vbZ[Wɐݒ肵Aԍ */
	/*}}icmp_echo_request()*/
	ICMPSTAT stat;			/* ʐM */
} ICMPDRIVER;
static ICMPDRIVER icmp_driver;

/*{{icmp_echo_request()*/
#define ICMP_ECHO_DATA_LENGTH	8
static const unsigned char icmp_echo_data[ICMP_ECHO_DATA_LENGTH + 1] = "PIECE-ME";
/*}}icmp_echo_request()*/

static void icmp_start();
static void icmp_stop();
static void icmp_recv(IPCLIENT* ip_client, int source_ip_address, int destination_ip_address, const unsigned char* data/*[length]*/, int length);

/*--------------------------------------------------------------------------*/

static void
icmp_start()
{
	/* hCo\̂NA܂B */
	memset(&icmp_driver, 0, sizeof icmp_driver);

	/* ICMPvgRhCoJn܂B */
	icmp_driver.ip_client.protocol = 1/*ICMP*/;
	icmp_driver.ip_client.recv = icmp_recv;
	ip_open(&icmp_driver.ip_client);
}

static void
icmp_stop()
{
	/* ICMPvgRhCo~܂B */
	ip_close(&icmp_driver.ip_client);

	/* hCo\̂NA܂B */
	memset(&icmp_driver, 0, sizeof icmp_driver);
}

static void
icmp_recv(IPCLIENT* ip_client, int source_ip_address, int destination_ip_address, const unsigned char* _data/*[length]*/, int length)
{
	unsigned char* data = (unsigned char*)_data;

	if(length < 4) {
		return;
	}
	if(internet_checksum(data, length) != 0) {			/* +2,2: `FbNT */
		return;
	}

	switch(BEBYTE(data + 0)) {					/* +0,1: ^Cv */
	case 0: /* GR[ */

		/* GR[MAJEgAbvāAicmp_echo_request()֒ʒm܂B
		 * icmp_echo_request()Ƀ^CAEgĂAӖȒʒmƂȂ܂B(Sł)
		 */
		if(length != 8 + ICMP_ECHO_DATA_LENGTH) {
			return;
		}
		if(source_ip_address != icmp_driver.echo_address) {
			return;
		}
		if(BEHALF(data + 4) != icmp_driver.echo_identifier) {	/* +4,2: ʎq */
			return;
		}
		if(BEHALF(data + 6) != icmp_driver.echo_sequence) {	/* +6,2: ԍ */
			return;
		}
		if(memcmp(data + 8, icmp_echo_data, ICMP_ECHO_DATA_LENGTH) != 0) {	/* +8,8: f[^ */
			return;
		}
		icmp_driver.stat.echo_reply++;	/* JEgAbv (icmp_echo_request()ւ̒ʒm˂) */

		return;

	case 8: /* GR[v */

		/* GR[vMAJEgAbvāAGR[bZ[Wԑ܂B */
		PUT_BEBYTE(data + 0, 0);				/* +0,1: ^Cv (GR[) */
		update_internet_checksum(data, length, 2);		/* +2,2: `FbNT */
		ip_send(ip_client, source_ip_address, data, length);
		icmp_driver.stat.echo_request++; /* JEgAbv */

		return;
	}
}

int
icmp_echo_request(int address, int timeout)
{
	int T0 = pceTimerGetCount();	/* ^CAEg̊AAʎqV[h */
	int send_ok = 0;		/* GR[vpPbg𑗐MA1ɂȂ܂ */
	//
	unsigned char data[8 + ICMP_ECHO_DATA_LENGTH];
	int retval;
	int elapse;
	int echo_reply;

	/* ̃^CAEglw肳ꂽꍇ́AlƂ܂B */
	if(timeout < 0) {
		timeout = DEFAULT_TIMEOUT;
	}

	/* GR[vbZ[W쐬܂B */
	PUT_BEBYTE(data + 0, 8);					/* +0,1: ^Cv (GR[v) */
	PUT_BEBYTE(data + 1, 0);					/* +1,1: R[h */
	PUT_BEHALF(data + 4, (unsigned short)T0);			/* +4,2: ʎq */
	PUT_BEHALF(data + 6, 0);					/* +6,2: ԍ */
	    memcpy(data + 8, icmp_echo_data, ICMP_ECHO_DATA_LENGTH);	/* +8,8: f[^ */
	update_internet_checksum(data, 8 + ICMP_ECHO_DATA_LENGTH, 2);	/* +2,2: `FbNT */

ENTER_CS;

	/* GR[҂̏i[܂B */
	icmp_driver.echo_address    = address;
	icmp_driver.echo_identifier = BEHALF(data + 4);
	icmp_driver.echo_sequence   = BEHALF(data + 6);

	/* GR[bZ[WM񐔃JEgAbvo邽߂ɁA݂̒lLĂ܂B */
	echo_reply = icmp_driver.stat.echo_reply;

LEAVE_CS;

	do {
		/* GR[vbZ[W𑗐M܂B */
		if(!send_ok) {
			retval = ip_send(&icmp_driver.ip_client, address, data, 8 + ICMP_ECHO_DATA_LENGTH);
			if(retval >= 0) {
				send_ok = 1; /* Aȍ~͑M܂ */
			}
		}

		/* GR[bZ[WMAx(0A܂́A)Ԃ܂B */
		elapse = pceTimerGetCount() - T0;
		if(icmp_driver.stat.echo_reply != echo_reply) { /* 1wordANZXȂ̂ŁArsv */
			return elapse;
		}
	} while(elapse < timeout); /* ^CAEg܂ŁAGR[bZ[W̎M҂܂ */

	/* GR[bZ[WMłȂ΁As()Ԃ܂B */
	return -1;
}

void
icmp_stat(ICMPSTAT* stat)
{
ENTER_CS;

	*stat = icmp_driver.stat;

LEAVE_CS;
}

/****************************************************************************
 *	IPvgRhCo
 ****************************************************************************/

typedef struct _IPDRIVER {
	ETHERNETCLIENT ethernet_client;	/* EthernetNCAgo^p */
	IPCONFIG config;		/* lbg[Nݒ */
	LIST_ENTRY client_list;		/* NCAgXg */
} IPDRIVER;
static IPDRIVER ip_driver;

static void ip_recv(ETHERNETCLIENT* ethernet_client, const unsigned char* address/*[6]*/, const unsigned char* data/*[length]*/, int length);
static IPCLIENT* ip_find_client(int protocol);

/*--------------------------------------------------------------------------*/

/* NCAgXgAw肵ʃvgRɑΉNCAgT܂B
 * w肵ʃvgRɑΉNCAgA|C^Ԃ܂B
 * w肵ʃvgRɑΉNCAgȂ΁ANULLԂ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static IPCLIENT*
ip_find_client(int protocol)
{
	LIST_ENTRY* list_head = &ip_driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;	/* 擪̗vf(orI[) */
	IPCLIENT* client;

	while(list_entry != list_head) {
		if(!list_entry) {
			DIE(); /* A܂́ANCAgXgj */
		}
		client = CONTAINING_RECORD(list_entry, IPCLIENT, list_entry);
		if(client->protocol == protocol) {
			return client;
		}
		list_entry = list_entry->Flink;
	}

	return NULL;
}

void
ip_start(int txque_capacity)
{
	/* ܂Amɒ~܂B */
	ip_stop();

	/* hCo\̂NA܂B */
	memset(&ip_driver, 0, sizeof ip_driver);

	/* NCAgXg܂B */
	InitializeListHead(&ip_driver.client_list);

ENTER_CS;

	/* IPvgRhCoJn܂B(EthernetNCAg) */
	memset(&ip_driver.ethernet_client, 0, sizeof ip_driver.ethernet_client);
	ip_driver.ethernet_client.type = 0x0800/*IP*/;
	ip_driver.ethernet_client.recv = ip_recv;
	ethernet_open(&ip_driver.ethernet_client);

	/* ARPvgRhCoJn܂B(EthernetNCAg) */
	arp_start();

	/* ICMPvgRhCoJn܂B(IPNCAg) */
	icmp_start();

LEAVE_CS;
}

void
ip_stop()
{
	/* JnĂȂ΁A܂B */
	if(!ip_driver.client_list.Flink) {
		return;
	}

ENTER_CS;

	/* ICMPvgRhCo~܂B(IPNCAg) */
	icmp_stop();

	/* ARPvgRhCo~܂B(EthernetNCAg) */
	arp_stop();

	/* IPvgRhCo~܂B(EthernetNCAg) */
	ethernet_close(&ip_driver.ethernet_client);

LEAVE_CS;

	/* hCo\̂NA܂B */
	memset(&ip_driver, 0, sizeof ip_driver);
}

void
ip_open(IPCLIENT* client)
{
ENTER_CS;

	if((client->protocol < 0x00) || (client->protocol > 0xff)) {
		DIE(); /* sȃvgRID */
	}

	if(ip_find_client(client->protocol)) {
		DIE(); /* vgRIDo^ς */
	}

	/* NCAgXgɒǉ܂B */
	InsertTailList(&ip_driver.client_list, &client->list_entry);

LEAVE_CS;
}

void
ip_close(IPCLIENT* client)
{
ENTER_CS;

	if(ip_find_client(client->protocol) != client) {
		DIE(); /* o^̃NCAg */
	}

	/* NCAgXg菜܂B */
	RemoveEntryList(&client->list_entry);

LEAVE_CS;
}

int
ip_send(IPCLIENT* client, int address, const void* data/*[length]*/, int length)
{
	int retval;
	//
	int tmpbuf_length;
	unsigned char* tmpbuf = NULL; /* vJ */
	//
	unsigned char ethernet_address[6];
	IPHEADER* header;
	//
	IPCONFIG ip_config;
	ip_get_config(&ip_config);

	if(length < 0) {
		DIE(); /* p[^s */
	}

	/* IPf[^O\zpobt@mۂ܂B */
	tmpbuf_length = 20/*IPwb_*/ + length/*f[^*/;
	tmpbuf = malloc(tmpbuf_length);
	if(!tmpbuf) {
		DIE(); /* s */
	}

	/* ĐIPAhXu[hLXgAhXȂ΁AEthernetu[hLXgs܂B */
	if(address == (ip_config.ip_address | ~ip_config.subnet_mask)) {
		memcpy(ethernet_address, ethernet_broadcast_address, 6);

	/* ĐIPAhXA܂́AftHgQ[gEFCɑ΂EthernetAhX擾܂B */
	} else {
		retval = arp_request((address & ip_config.subnet_mask) ==
			(ip_config.ip_address & ip_config.subnet_mask) ? address : ip_config.default_gateway,
			ethernet_address, -1/*̃^CAEgԂgp*/);
		if(retval != 0) {
			length = -1; /* AhXs */
			goto L_EXIT;
		}
	}

	/* IPf[^O\z܂B */
	header = (IPHEADER*)tmpbuf;
	memset(header, 0, sizeof(IPHEADER));
	header->protocol		= client->protocol;
	header->source_ip_address	= ip_driver.config.ip_address;
	header->destination_ip_address	= address;
	header->data			= (unsigned char*)data;
	header->data_length		= length;
	retval = pack_ip_header(header, tmpbuf, tmpbuf_length);
	if(retval != tmpbuf_length) {
		DIE(); /* L蓾Ȃ */
	}

	/* IPf[^O𑗐M܂B */
	retval = ethernet_send(&ip_driver.ethernet_client, ethernet_address, tmpbuf, tmpbuf_length);
	if(retval < 0) {
		length = -1; /* Ms */
		goto L_EXIT;
	}

L_EXIT:

	/* IPf[^O\zpobt@܂B */
	free(tmpbuf);

	/* Ȃ΁Af[^̂܂ܕԂ܂B */
	return length;
}

void
ip_set_config(const IPCONFIG* config)
{
ENTER_CS;

	/* lbg[Nݒ肪ω... */
	if(memcmp(&ip_driver.config, config, sizeof(IPCONFIG)) != 0) {

		/* Vlbg[Nݒi[܂B */
		memcpy(&ip_driver.config, config, sizeof(IPCONFIG));

		/* EthernetAhXݒ̏Ă΁AGratuitous ARP𑗏o܂B
		 * - ɂ́AIPAhXωꍇ̂݁AGratuitous ARP𑗏oׂłA
		 *   ݂̎ł́AȒP̂߂ɁA̍ڂωꍇoĂ܂B
		 */
		arp_gratuitous();

		/* ARPIPNCAgŖ̂ŁAȉ̏ƕʂɁAIɒʒmĂ܂B */

		/* NCAg̐ݒύXR[obNցAlbg[Nݒ̕ωʒm܂B
		 * - 2005/09/05݁A̒ʒm𗘗pĂIPNCAghCo͗L܂B
		 *   獡ATCPUDPhCoɂāAp邩܂B(\)
		 * - EthernethCoEthernetAhXω`dĂ̂ł͖ƂɒӂĂB
		 *   {ʒḿA܂łAlbg[Nݒ(IPAhXȂ)̕ωʒm̂łB
		 *   EthernetAhX̕ωIPhCoɂċz邽߁AʃhCoł͍lsvłB
		 *   {IɁANwhCo̐ݒωmKv̂́AN+1whCołB
		 */
		{
			LIST_ENTRY* list_head = &ip_driver.client_list;	/* Xg̃[gvf */
			LIST_ENTRY* list_entry = list_head->Flink;	/* 擪̗vf(orI[) */
			IPCLIENT* client;

			while(list_entry != list_head) {
				if(!list_entry) {
					DIE(); /* A܂́ANCAgXgj */
				}
				client = CONTAINING_RECORD(list_entry, IPCLIENT, list_entry);
				if(client->conf) {
					client->conf(client);
				}
				list_entry = list_entry->Flink;
			}
		}
	}

LEAVE_CS;
}

void
ip_get_config(IPCONFIG* config)
{
ENTER_CS;

	memcpy(config, &ip_driver.config, sizeof(IPCONFIG));

LEAVE_CS;
}

static void
ip_recv(ETHERNETCLIENT* ethernet_client, const unsigned char* address/*[6]*/, const unsigned char* data/*[length]*/, int length)
{
	int retval;
	IPHEADER header;
	IPCLIENT* client;

	/* IPf[^OWJ܂B */
	retval = unpack_ip_header(&header, data, length);
	if(retval < 0) {
		return;
	}

	/* tOgpPbg͖ΉłB */
	if((header.flags & (1<<2)) ||	/* 㑱pPbgL */
	   (header.fragment_offset)) {	/* tOgItZbgwL */
		return;
	}

	/* āA܂́Au[hLXgpPbgȊÓAj܂B */
	if((header.destination_ip_address !=  ip_driver.config.ip_address) &&
	   (header.destination_ip_address != (ip_driver.config.ip_address | ~ip_driver.config.subnet_mask))) {
		return;
	}
	
	/* ʃvgRɑΉNCAg֑܂B */
	client = ip_find_client(header.protocol);
	if(client) {
		if(client->recv) {
			client->recv(client,
				header.source_ip_address,	/* MIPAhX */
				header.destination_ip_address,	/* ĐIPAhX */
				header.data,			/* f[^ */
				header.data_length);		/* f[^ */
		}
	}
}

