/*	
 *	clipdct2.h
 *
 *	񎟌DCT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Sat Jan 31 22:35:45 JST 2009 Naoyuki Sawa
 *	- VK쐬B
 *	- fdct8x8half()Aidct8x8half()쐬AAZus܂B
 */
#ifndef __CLIP_DCT2_H__
#define __CLIP_DCT2_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* 8x8f̓񎟌FDCTs܂B
 * [in]
 *	src		ԗ̈(F)̓̓f[^B
 *	dst		g̈̏o̓f[^󂯎obt@B
 *			srcdstɓobt@w肷邱Ƃ\łB(GAXZ[t)
 *			̏ꍇA̓f[^o̓f[^ŏ㏑܂B
 * [note]
 *	- JPEGMPEG̃vO쐬ۂɁAp邱Ƃz肵č쐬܂B
 *	- Zx16bitłA͂Əo͂͐łB
 *	  8x8DCTZɂāAϊ̒l͓͒l̍ő8{ɂȂ\܂B
 *	  ]āA}4095𒴂͒l^Ȃ悤AӂĂB
 */
void fdct8x8half(const short* src/*[8 * 8]*/, short* dst/*[8 * 8]*/);

/* 8x8f̓񎟌IDCTs܂B
 * [in]
 *	src		g̈̓̓f[^B
 *	dst		ԗ̈(F)̏o̓f[^󂯎obt@B
 *			srcdstɓobt@w肷邱Ƃ\łB(GAXZ[t)
 *			̏ꍇA̓f[^o̓f[^ŏ㏑܂B
 * [note]
 *	- JPEGMPEG̃vO쐬ۂɁAp邱Ƃz肵č쐬܂B
 *	- Zx16bitłA͂Əo͂͐łB
 *	  8x8DCTZɂāAϊ̒l͓͒l̍ő8{ɂȂ\܂B
 *	  ]āA}4095𒴂͒l^Ȃ悤AӂĂB
 */
void idct8x8half(const short* src/*[8 * 8]*/, short* dst/*[8 * 8]*/);

#endif /*__CLIP_DCT2_H__*/
