/*
 *	clipadp.h
 *
 *	2-bit ADPCM Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Wed Dec 20 00:13:10 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Dec 20 17:31:02 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Dec 21 11:18:32 JST 2006 Naoyuki Sawa
 *	- ADPCMCHANNEL\̂ՂёւāAASMadpcm_mix1()œK܂B
 *	* Thu Mar 01 01:53:43 JST 2007 Naoyuki Sawa
 *	- adpcm_stat()ǉ܂B
 */
#ifndef __CLIP_ADP_H__
#define __CLIP_ADP_H__

/****************************************************************************
 *	萔A\
 ****************************************************************************/

/* PCEWAVEINFO.type ̓Ǝg */
#define PW_TYPE_2BITADPCM	3
#define PW_TYPE_ADPCM_X		(PW_TYPE_2BITADPCM|PW_TYPE_VR|PW_TYPE_ADP_INI)
#define PW_TYPE_ADPCM_X_NI	(PW_TYPE_2BITADPCM|PW_TYPE_VR)

#define ADPCMBUFLEN		320	/* =16000/50 c 1[tick](=1/50[sec])̃Tv */

/* AZuR[h璼ڎQƂ邽߁ACAEgŒł!! */
//typedef struct _ADPCMCHANNEL {
//	int loop;			/* + 0,4: 0=~, 1`=c胋[v, -1=[v */
//	int pcm;			/* + 4,4: oPCMl */
//	short data;			/* + 8,2: ADPCMl̃obt@ */
//	short delta;			/* +10,2: l */
//	short progress;			/* +12,2: isJE^ */
//	short rate;			/* +14,2: TvO[g */
//	int len;			/* +16,4: co̓Tv */
//	const unsigned char* ptr;	/* +20,4: ADPCMf[^ʒu */
//	int init_len;			/* +24,4: co̓TṽZbgl */
//	const unsigned char* init_ptr;	/* +28,4: ADPCMf[^ʒũZbgl */
//} ADPCMCHANNEL;				/* =32 */
//* Thu Dec 21 11:18:32 JST 2006 Naoyuki Sawa
//- ADPCMCHANNEL\̂ՂёւāAASMadpcm_mix1()œK܂B
typedef struct _ADPCMCHANNEL {
	int pcm;			/* + 0,4: oPCMl */
	short data;			/* + 4,2: ADPCMl̃obt@ */
	short delta;			/* + 6,2: l */
	short progress;			/* + 8,2: isJE^ */
	short rate;			/* +10,2: TvO[g */
	int len;			/* +12,4: co̓Tv */
	const unsigned char* ptr;	/* +16,4: ADPCMf[^ʒu */
	int loop;			/* +20,4: 0=~, 1`=c胋[v, -1=[v */
	int init_len;			/* +24,4: co̓TṽZbgl */
	const unsigned char* init_ptr;	/* +28,4: ADPCMf[^ʒũZbgl */
} ADPCMCHANNEL;				/* =32 */

typedef struct _ADPCMDRIVER {
	int nch;			/* `l */
	ADPCMCHANNEL* pch/*[nch]*/;	/* `l\ */
} ADPCMDRIVER;

/* framadp.c */
void adpcm_mix1(ADPCMCHANNEL* pch, int mixbuf[/*ADPCMBUFLEN*/]);
void adpcm_mix2(short wbuff[/*ADPCMBUFLEN*/], int mixbuf[/*ADPCMBUFLEN*/]);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* 2-bit ADPCM DecoderN܂B
 * [in]
 *	nch		`lB
 * [note]
 *	* adpcm_play()gOadpcm_init()ĂяoāA2-bit ADPCM DecoderNĂĂB
 *	* ̊֐́Astream_play()ĂяoĂ܂B
 *	  stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOadpcm_exit()ĂяoāAxN^𕜌ĂB
 *	  ACuIɎIɃtbN𕜌̂ŁAadpcm_exit()Ă΂ɏIĂSłB
 */
void adpcm_init(int nch);

/* 2-bit ADPCM Decoder~܂B
 * [note]
 *	* 2-bit ADPCM DecoderNĂȂ΁Å֐͉s܂B
 */
void adpcm_exit();

/* 2-bit ADPCM`ppdf[^Đ܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 *	data		2-bit ADPCM`ppdf[^B(t@CC[W̐擪AhX)
 *	loop		1` = [v, -1 = [vB
 * [note]
 *	* ̊֐̎ǵAsound_play()ƓłB
 *	  clippce.hsound_play()̃RgQƂĂB
 *	* ̊֐́A2-bit ADPCM`ppdf[^̍Đɂ̂ݗpł܂B
 *	  2-bit ADPCM`ȊOppdw肷ƁAG[I܂B
 *	  2-bit ADPCM`ȊOppdĐɂ́Asound_play()𗘗pĂB
 */
void adpcm_play(int ch, const void* data, int loop);

/* 2-bit ADPCM`ppdf[^Đ~܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 * [note]
 *	* w肳ꂽ`lĐłȂꍇ́Å֐͉s܂B
 */
void adpcm_stop(int ch);

/* w肳ꂽ2-bit ADPCM`lAĐ~𒲂ׂ܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 * [out]
 *	߂l		ĐȂ0ȊO̒lԂ܂B
 *			~Ȃ0Ԃ܂B
 * [note]
 *	* 2007/03/01݂̎́AADPCMCHANNEL.loop̒l̂܂ܕԂĂ̂ŁA
 *	  ߂ĺA{0=~, 1`=c胋[v, -1=[v} ƂȂĂ܂B
 *	  AύXꍇɁA߂lς\܂B
 *	  ߂lÂ悤ɉ肵ăR[fBOȂ悤AӂĂB
 */
int adpcm_stat(int ch);

#endif /*__CLIP_ADP_H__*/
