/*
 *	main.c
 *
 *	w^CZǂ
 *
 *	* Sun Oct 25 14:18:15 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_MUSIC
#include "instdef2.c"
#endif /*USE_MUSIC*/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	
 ****************************************************************************/

const short fuda_spr_tbl[2/*blink*/][3/*iro*/][16/*setugou*/] = {
	{ {             -1, SPR_FUDA1_xxxR, SPR_FUDA1_xxDx, SPR_FUDA1_xxDR,
	    SPR_FUDA1_xLxx, SPR_FUDA1_xLxR, SPR_FUDA1_xLDx, SPR_FUDA1_xLDR,
	    SPR_FUDA1_Uxxx, SPR_FUDA1_UxxR, SPR_FUDA1_UxDx, SPR_FUDA1_UxDR,
	    SPR_FUDA1_ULxx, SPR_FUDA1_ULxR, SPR_FUDA1_ULDx, SPR_FUDA1_ULDR },
	  {             -1, SPR_FUDA2_xxxR, SPR_FUDA2_xxDx, SPR_FUDA2_xxDR,
	    SPR_FUDA2_xLxx, SPR_FUDA2_xLxR, SPR_FUDA2_xLDx, SPR_FUDA2_xLDR,
	    SPR_FUDA2_Uxxx, SPR_FUDA2_UxxR, SPR_FUDA2_UxDx, SPR_FUDA2_UxDR,
	    SPR_FUDA2_ULxx, SPR_FUDA2_ULxR, SPR_FUDA2_ULDx, SPR_FUDA2_ULDR },
	  {             -1, SPR_FUDA3_xxxR, SPR_FUDA3_xxDx, SPR_FUDA3_xxDR,
	    SPR_FUDA3_xLxx, SPR_FUDA3_xLxR, SPR_FUDA3_xLDx, SPR_FUDA3_xLDR,
	    SPR_FUDA3_Uxxx, SPR_FUDA3_UxxR, SPR_FUDA3_UxDx, SPR_FUDA3_UxDR,
	    SPR_FUDA3_ULxx, SPR_FUDA3_ULxR, SPR_FUDA3_ULDx, SPR_FUDA3_ULDR } },
	{ {             -1, SPR_FUDA1_xxxR, SPR_FUDA1_xxDx, SPR_FUDA1_xxDR,
	    SPR_FUDA1_xLxx, SPR_FUDA1_xLxR, SPR_FUDA1_xLDx, SPR_FUDA1_xLDR,
	    SPR_FUDA1_Uxxx, SPR_FUDA1_UxxR, SPR_FUDA1_UxDx, SPR_FUDA1_UxDR,
	    SPR_FUDA1_ULxx, SPR_FUDA1_ULxR, SPR_FUDA1_ULDx, SPR_FUDA1_ULDR },
	  {             -1, SPR_FUDA2_xxxR, SPR_FUDA2_xxDx, SPR_FUDA2_xxDR,
	    SPR_FUDA2_xLxx, SPR_FUDA2_xLxR, SPR_FUDA2_xLDx, SPR_FUDA2_xLDR,
	    SPR_FUDA2_Uxxx, SPR_FUDA2_UxxR, SPR_FUDA2_UxDx, SPR_FUDA2_UxDR,
	    SPR_FUDA2_ULxx, SPR_FUDA2_ULxR, SPR_FUDA2_ULDx, SPR_FUDA2_ULDR },
	  {             -1, SPR_FUDA4_xxxR, SPR_FUDA4_xxDx, SPR_FUDA4_xxDR,
	    SPR_FUDA4_xLxx, SPR_FUDA4_xLxR, SPR_FUDA4_xLDx, SPR_FUDA4_xLDR,
	    SPR_FUDA4_Uxxx, SPR_FUDA4_UxxR, SPR_FUDA4_UxDx, SPR_FUDA4_UxDR,
	    SPR_FUDA4_ULxx, SPR_FUDA4_ULxR, SPR_FUDA4_ULDx, SPR_FUDA4_ULDR } },
};

const short kazu_spr_tbl[5/*kazu*/] = {
	SPR_KAZU1, SPR_KAZU2, SPR_KAZU3, SPR_KAZU4, SPR_KAZU5,
};

const short yaku_spr_tbl[YAKU_TYPE_COUNT/*type*/] = {
	SPR_YAKU_SUURETU, SPR_YAKU_DOUSUU, SPR_YAKU_HOUI, SPR_YAKU_KANZEN,
};

const short ten_spr_tbl[10/*0...9*/] = {
	SPR_TEN_0, SPR_TEN_1, SPR_TEN_2, SPR_TEN_3, SPR_TEN_4, SPR_TEN_5, SPR_TEN_6, SPR_TEN_7, SPR_TEN_8, SPR_TEN_9,
};

const short tefuda_pos_tbl[2/*teban*/][TEFUDA_COUNT][2/*x,y*/] = {
	{ { TEFUDA1_X + (MASU_SIZE * 1), TEFUDA1_Y + (MASU_SIZE * 0) },
	  { TEFUDA1_X + (MASU_SIZE * 2), TEFUDA1_Y + (MASU_SIZE * 0) },
	  { TEFUDA1_X + (MASU_SIZE * 0), TEFUDA1_Y + (MASU_SIZE * 1) },
	  { TEFUDA1_X + (MASU_SIZE * 1), TEFUDA1_Y + (MASU_SIZE * 1) },
	  { TEFUDA1_X + (MASU_SIZE * 2), TEFUDA1_Y + (MASU_SIZE * 1) } },
	{ { TEFUDA2_X + (MASU_SIZE * 1), TEFUDA2_Y + (MASU_SIZE * 0) },
	  { TEFUDA2_X + (MASU_SIZE * 2), TEFUDA2_Y + (MASU_SIZE * 0) },
	  { TEFUDA2_X + (MASU_SIZE * 0), TEFUDA2_Y + (MASU_SIZE * 1) },
	  { TEFUDA2_X + (MASU_SIZE * 1), TEFUDA2_Y + (MASU_SIZE * 1) },
	  { TEFUDA2_X + (MASU_SIZE * 2), TEFUDA2_Y + (MASU_SIZE * 1) } },
};

const short score_pos_tbl[2/*teban*/][2/*x,y*/] = {
	{ SCORE1_X, SCORE1_Y },
	{ SCORE2_X, SCORE2_Y },
};

const short teban_pos_tbl[2/*teban*/][2/*x,y*/] = {
	{ TEBAN1_X, TEBAN1_Y },
	{ TEBAN2_X, TEBAN2_Y },
};

const char dir_tbl[DIR_COUNT][2/*x,y*/] = {
	{  1,  0 }, /* DIR_R */
	{  0,  1 }, /* DIR_D */
	{ -1,  0 }, /* DIR_L */
	{  0, -1 }, /* DIR_U */
};

const unsigned char setugou_rate_tbl[5][2/*percent,setugou*/] = {
	{ 20, FUDA_SETUGOU_U },
	{ 20, FUDA_SETUGOU_U | FUDA_SETUGOU_D },
	{ 20, FUDA_SETUGOU_U | FUDA_SETUGOU_R },
	{ 30, FUDA_SETUGOU_U | FUDA_SETUGOU_D | FUDA_SETUGOU_R },
	{ 10, FUDA_SETUGOU_U | FUDA_SETUGOU_L | FUDA_SETUGOU_D | FUDA_SETUGOU_R },
};

const unsigned char setugou_rot_tbl[16/*setugou*/] = {
	0,
	                              FUDA_SETUGOU_D,
	               FUDA_SETUGOU_L,
	               FUDA_SETUGOU_L|FUDA_SETUGOU_D,
	FUDA_SETUGOU_U,
	FUDA_SETUGOU_U|               FUDA_SETUGOU_D,
	FUDA_SETUGOU_U|FUDA_SETUGOU_L,
	FUDA_SETUGOU_U|FUDA_SETUGOU_L|FUDA_SETUGOU_D,
	                                             FUDA_SETUGOU_R,
	                              FUDA_SETUGOU_D|FUDA_SETUGOU_R,
	               FUDA_SETUGOU_L|               FUDA_SETUGOU_R,
	               FUDA_SETUGOU_L|FUDA_SETUGOU_D|FUDA_SETUGOU_R,
	FUDA_SETUGOU_U|                              FUDA_SETUGOU_R,
	FUDA_SETUGOU_U|               FUDA_SETUGOU_D|FUDA_SETUGOU_R,
	FUDA_SETUGOU_U|FUDA_SETUGOU_L|               FUDA_SETUGOU_R,
	FUDA_SETUGOU_U|FUDA_SETUGOU_L|FUDA_SETUGOU_D|FUDA_SETUGOU_R,
};

const unsigned char tefuda_sel_tbl[DIR_COUNT][TEFUDA_COUNT] = {
	{ 1, 0, 3, 4, 2 }, /* DIR_R */
	{ 3, 4, 0, 0, 1 }, /* DIR_D */
	{ 1, 0, 4, 2, 3 }, /* DIR_L */
	{ 3, 4, 0, 0, 1 }, /* DIR_U */
};

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* B */
	app_init();

	/* C[vB */
	for(;;) {
		if(!setjmp(jb_sel)) {
			demo_main();
		} else {
			exit(0);
		}
		if(!setjmp(jb_sel)) {
			game_main();
		}
	}

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

void
app_init()
{
	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
	pceLCDDispStart();
#ifdef REPEAT_PAD
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*REPEAT_PAD*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef RESOURCE_FNAME
	/* pext@CYt\[X擾܂B */
	resource = resource_address(RESOURCE_FNAME);
#endif /*RESOURCE_FNAME*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef USE_GC
	/* K[x[WRN^[܂B */
	gc_init();
#endif /*USE_GC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	music_loudness(1);
	loadInst(); /* uRandomism Zone(http://www8.plala.or.jp/randomism/)v́whFLbgver.2.10xgp */
	InitMusic();
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(ADPCM_CHANNELS);
#endif /*USE_2BIT_ADPCM*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
	sakiyomi = 1;
	mokuhyou = 500;
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_MUSIC
	/* mɉyt~܂B
	 * TEh̒~̓CupceAppExit()ōsĂ̂ŁA
	 * ł͕Kv܂B
	 */
	StopMusic();
	music_loudness(0);
#endif /*USE_MUSIC*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef USE_GC
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*USE_GC*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 */
void
update()
{
#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/
			/* ʍXVB */
			update();
#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/
			/* VXeB */
#ifdef USE_IDLE
			idle_yield();
#else /*USE_IDLE*/
			yield();
#endif /*USE_IDLE*/
			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;

			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

//{{TEST
#if 0
	if(joy & TRG_LRUD) {
		sound_play(0, sound_table[SND_SE01], 1);
	}
	if(joy & TRG_ABCD) {
		sound_play(0, sound_table[SND_SE02], 1);
	}
#endif
//}}TEST

	now++;	/* O[o^C}XV */

	/* _ŃJE^i߂ */
	blink++;
}

/****************************************************************************
 *	
 ****************************************************************************/

static const unsigned char demo_tbl[4][7][7] = {
	{{1,1,1,0,1,1,1},
	 {0,0,1,0,1,0,0},
	 {2,2,1,0,1,2,2},
	 {0,2,0,0,0,2,0},
	 {2,2,1,0,1,2,2},
	 {0,0,1,0,1,0,0},
	 {1,1,1,0,1,1,1}},
	{{0,2,2,0,2,2,0},
	 {0,2,0,0,0,2,0},
	 {1,1,0,0,0,1,1},
	 {1,0,0,0,0,0,1},
	 {1,1,0,0,0,1,1},
	 {0,2,0,0,0,2,0},
	 {0,2,2,0,2,2,0}},
	{{1,1,0,0,0,1,1},
	 {1,0,2,0,2,0,1},
	 {0,2,2,0,2,2,0},
	 {2,2,0,0,0,2,2},
	 {0,2,2,0,2,2,0},
	 {1,0,2,0,2,0,1},
	 {1,1,0,0,0,1,1}},
	{{2,2,0,0,0,2,2},
	 {0,2,0,0,0,2,0},
	 {1,0,0,0,0,0,1},
	 {1,1,0,0,0,1,1},
	 {1,0,0,0,0,0,1},
	 {0,2,0,0,0,2,0},
	 {2,2,0,0,0,2,2}},
};

static int demo_sel;
static int demo_pat;
static int demo_cnt;
static int demo_fade;

/*--------------------------------------------------------------------------*/

static void demo_bg_draw() {
	int spr;

	/* wi */
	spr = SPR_PIC1 + pic_sel;
	sprite_draw((~now >> 1 & 127) - 128, 0, spr, DRW_NOMAL);
	sprite_draw((~now >> 1 & 127)      , 0, spr, DRW_NOMAL);
}

/*--------------------------------------------------------------------------*/

static void demo_ttl_draw() {
	int c;
	int x;
	int y;
	int col;
	int row;
	int spr;
	int type;

	/* Obh */
	x = 24;
	y = 4;
	sprite_draw(x, y, SPR_TTL_GRID, DRW_NOMAL);

	/* D */
	for(row = 0; row < 7; row++) {
		for(col = 0; col < 7; col++) {
			type = demo_tbl[demo_pat][row][col];
			if(type) {
				switch(demo_cnt) {
				case 0: case 29: c = 3; break;
				case 1: case 28: c = 2; break;
				case 2: case 27: c = 1; break;
				default:         c = 0; break;
				}
				if(c < type - 1) c = type - 1;
				if(c <= 2) {
					x = col * 11 + 27;
					y = row * 11 + 7;
					spr = ((col >= 1) && (demo_tbl[demo_pat][row][col - 1] == type)) ? SPR_TTL_FUDA_L2 : SPR_TTL_FUDA_L1;
					sprite_draw(x, y, spr, DRW_MASK(c));
					spr = ((col <= 5) && (demo_tbl[demo_pat][row][col + 1] == type)) ? SPR_TTL_FUDA_R2 : SPR_TTL_FUDA_R1;
					sprite_draw(x, y, spr, DRW_MASK(c));
					spr = ((row >= 1) && (demo_tbl[demo_pat][row - 1][col] == type)) ? SPR_TTL_FUDA_U2 : SPR_TTL_FUDA_U1;
					sprite_draw(x, y, spr, DRW_MASK(c));
					spr = ((row <= 5) && (demo_tbl[demo_pat][row + 1][col] == type)) ? SPR_TTL_FUDA_D2 : SPR_TTL_FUDA_D1;
					sprite_draw(x, y, spr, DRW_MASK(c));
				}
			}
		}
	}

	/* S */
	x = 52;
	y = 3;
	sprite_draw(x, y, SPR_TTL_LOGO, DRW_NOMAL);
	x += 25;
	y += 75;
	sprite_draw(x, y, SPR_TTL_MODOKI, DRW_NOMAL);

	/* D̃p^[i߂ */
	if(!(now % 3)) {
		if(++demo_cnt == 30) {
			demo_cnt = 0;
			if(++demo_pat == 4) {
				demo_pat = 0;
			}
		}
	}
}

/*--------------------------------------------------------------------------*/

static void demo_cfg_draw() {
	int c;
	int x;
	int y;

	y = 12;
	x = 17;
	render_rectangle_shadow(&render, x, (y - 1) + (15 * demo_sel), 93, 13, -1, 0);

	c = (demo_sel == 0) ? 0x330 : 0x331;
	render_printf_framed(&render, x, y, 0, c, "     W     %4d", mokuhyou);
	y += 15;

	c = (demo_sel == 1) ? 0x330 : 0x331;
	render_printf_framed(&render, x, y, 0, c, "Ȃ̎  %s", (teban_sel == 0) ? "" : "");
	y += 15;

	c = (demo_sel == 2) ? 0x330 : 0x331;
	render_printf_framed(&render, x, y, 0, c, "bot̋  %s", (sakiyomi == 0) ? "ア" : "");
	y += 15;

	c = (demo_sel == 3) ? 0x330 : 0x331;
	render_printf_framed(&render, x, y, 0, c, " ҂̔zD   %s", (haifuda_sel == 0) ? "" : "Ⴄ");
}

/*--------------------------------------------------------------------------*/

static void
ttl_ftr_draw()
{
	if(blink % SEC(2) < SEC(1)) {
		sprite_draw(FTR_X, FTR_Y, SPR_TTL_FTR, DRW_NOMAL);
	}
}

/*--------------------------------------------------------------------------*/

static void
cfg_ftr_draw()
{
	if(blink % SEC(2) < SEC(1)) {
		sprite_draw(FTR_X, FTR_Y, SPR_CFG_FTR, DRW_NOMAL);
	}
}

/*--------------------------------------------------------------------------*/

void
demo_main()
{
	pic_sel = (pic_sel + RND32_RANGE(seed, 1, 6)) % 6;

	demo_sel = 0;
	demo_pat = 0;
	demo_cnt = 0;
	demo_fade = 3;

	while(demo_fade >= 1) {
		schedule();
		demo_bg_draw(); /* wi */
		demo_ttl_draw(); /* ^Cg */
		render_rectangle_shadow(&render, 0, 0, DISP_X, DISP_Y, demo_fade, 3);
		demo_fade--;
		if(joy & TRG_MASK) {
			demo_fade = 0; /* tF[hCLZ */
		}
	}
L_TTL:
	/* ^Cg */
	blink = 0; /* _Ń^C~O킹 */
	for(;;) {
		schedule();
		demo_bg_draw(); /* wi */
		demo_ttl_draw(); /* ^Cg */
		ttl_ftr_draw(); /*  */
		if(joy & TRG_A) {
			goto L_CFG;
		}
		if(joy & TRG_SELECT) {
			longjmp(jb_sel, 1); /* I */
		}
	}
L_CFG:
	/* ݒ */
	blink = 0; /* _Ń^C~O킹 */
	for(;;) {
		schedule();
		demo_bg_draw(); /* wi */
		demo_cfg_draw(); /* ݒ */
		cfg_ftr_draw(); /*  */
		if(joy & TRG_A) {
			break;
		}
		if(joy & TRG_SELECT) {
			goto L_TTL;
		}
		if(joy & TRG_UP) demo_sel--;
		if(joy & TRG_DN) demo_sel++;
		if(demo_sel < 0) demo_sel = 3;
		if(demo_sel > 3) demo_sel = 0;
		switch(demo_sel) {
		case 0:
			if(joy & TRG_LF) mokuhyou -= 100;
			if(joy & TRG_RI) mokuhyou += 100;
			if(mokuhyou < MOKUHYOU_MIN) mokuhyou = MOKUHYOU_MAX;
			if(mokuhyou > MOKUHYOU_MAX) mokuhyou = MOKUHYOU_MIN;
			break;
		case 1:
			if(joy & TRG_LR) teban_sel = !teban_sel;
			break;
		case 2:
			if(joy & TRG_LR) sakiyomi = !sakiyomi;
			break;
		case 3:
			if(joy & TRG_LR) haifuda_sel = !haifuda_sel;
			break;
		}
	}

	while(demo_fade <= 3) {
		schedule();
		demo_bg_draw(); /* wi */
		demo_cfg_draw(); /* ݒ */
		render_rectangle_shadow(&render, 0, 0, DISP_X, DISP_Y, demo_fade, 3);
		demo_fade++;
		if(joy & TRG_MASK) {
			demo_fade = 4; /* tF[hAEgLZ */
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
game_main()
{
	SEARCH search; /* 1.2KBxȂ̂ŁAX^bNɎĂv */
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player;
	int i;
	int j;
	int col;
	int row;
	int spr;
	int ten;
	int goukei;

	game_init();

	/* ΐJn\ */
	for(i = 0; i < SEC(3.0); i++) {
		schedule();
		kyokumen_draw(kyokumen);
		if(i < 4) { /* tF[hC */
			render_rectangle_shadow(&render, 0, 0, DISP_X, DISP_Y, (i ^ 3), 3);
		} else if(i < 4 + 5) { /* ̎DAj[V */
			tefuda_gen_draw(i - 4);
		} else if(i == 4 + 5) { /* ̎D */
			tefuda_gen(kyokumen);
		} else { /* ΐJn\ */
			render_rectangle_shadow(&render, KAISI_X + 3, KAISI_Y + 3, KAISI_W - 6, KAISI_H - 6, 2, 3);
			sprite_draw(KAISI_X, KAISI_Y, SPR_KAISI, DRW_NOMAL);
		}
		if(joy & TRG_MASK) {
			break; /* Aj[VLZ */
		}
	}
	tefuda_gen(kyokumen); /* Aj[VLZꍇ̂߂ɁAmɎDBɐĂꍇ͉Ȃ̂őv */

	/* C[v */
	for(;;) {
		/* ҂̎Ԃs */
		for(kyokumen->teban = 0; kyokumen->teban < 2; kyokumen->teban++) {
			player = &kyokumen->player[kyokumen->teban];

			/* ꏄڂȂ΁Azu */
			if(!kyokumen->junme) {
				kyokumen->kaijo = 1; /* tefuda_put()NA */
			}

			/* L肪΁c */
			if(!get_te_list(kyokumen, NULL)) {
				/* tB[hςɂȂ? */
				if(is_field_full(kyokumen)) {
					goto L_JUDGE; /* s */
				} else {
					/* uDu܂^TO__zuv\ */
					for(i = 0; i < SEC(3); i++) {
						schedule();
						kyokumen_draw(kyokumen);
						render_rectangle_shadow(&render, KAIJO_X + 3, KAIJO_Y + 3, KAIJO_W - 6, KAIJO_H - 6, 2, 3);
						sprite_draw(KAIJO_X, KAIJO_Y, SPR_KAIJO, DRW_NOMAL);
						if(joy & TRG_MASK) {
							break; /* Aj[VLZ */
						}
					}
					/* XRA50__Azu */
					player->score -= 50;
					if(player->score < 0) {
						player->score = 0;
					}
					kyokumen->kaijo = 1; /* tefuda_put()NA */
					/* L肪L邱ƂmF */
					if(!get_te_list(kyokumen, NULL)) {
						DIE(); /* zûŁAK擾ł͂ */
					}
				}
			}

			/* DƔzuI */
			if(kyokumen->teban == teban_sel) {
				/* }jA */
				manual_main();
			} else {
				/* I[g */
				auto_main();
			}

			/* DtB[hɔzu */
			tefuda_put(kyokumen);

			/* tB[hIAj[V */
			for(i = 0; i < 5; i++) {
				schedule();
				kyokumen_draw(kyokumen);
				field_sel_done_draw(i);
				if(joy & TRG_MASK) {
					break; /* Aj[VLZ */
				}
			}

			/* T */
			yaku_search(kyokumen, &search);

			/* c */
			if(search.yaku_cnt) {
				goukei = 0; /* ɍv_߂ */
				/* ̖\ */
				for(i = 0; i < search.yaku_cnt; i++) {
					j = 0;
					for(;;) {
						schedule();
						kyokumen_draw(kyokumen);
						if(yaku_draw(&search.yaku[i], j++)) {
							break;
						}
						if(joy & TRG_MASK) {
							break; /* Aj[VLZ */
						}
					}
					ten = yaku_get_ten(&search.yaku[i]);
					player->score += ten;
					goukei += ten;
				}
				/* ȏ̖ĂAv_\ */
				if(search.yaku_cnt >= 2) {
					col = player->field_col;
					row = player->field_row;
					spr = SPR_YAKU_GOUKEI;
					for(i = 0; i < YAKU_DRAW_NAME_TIME + SEC(0.5); i++) { /* ƒ߂ɕ\B */
						schedule();
						kyokumen_draw(kyokumen);
						yaku_draw_name_ten(col, row, i, spr, goukei);
						if(joy & TRG_MASK) {
							break; /* Aj[VLZ */
						}
					}
				}
				/* XRAڕW𒴂As */
				if(player->score >= mokuhyou) {
					goto L_JUDGE;
				}
			}
		}

		/* ڂi߂ */
		kyokumen->junme++;

		/* DAj[V */
		for(i = 0; i < 5; i++) {
			schedule();
			kyokumen_draw(kyokumen);
			tefuda_gen_draw(i);
			if(joy & TRG_MASK) {
				break; /* Aj[VLZ */
			}
		}

		/* D */
		tefuda_gen(kyokumen);
	}
L_JUDGE:
	/* s\
	 * ڕW_ɓBɃtB[hςɂȂƂ́A_̑ق
	 * _ȂvC[̕ɂ邱Ƃɂ(őɖ̂ŔȂł傤c(^^;)
	 */
	if(kyokumen->player[teban_sel].score > kyokumen->player[!teban_sel].score) {
		spr = SPR_KATI;
	} else {
		spr = SPR_MAKE;
	}
	for(i = 0; i < SEC(0.5); i++) { /* EFCg */
		schedule();
		kyokumen_draw(kyokumen);
		if(joy & TRG_MASK) {
			break; /* Aj[VLZ */
		}
	}
	for(i = 0; i < SEC(15) + 4; i++) {
		schedule();
		kyokumen_draw(kyokumen);
		render_rectangle_shadow(&render, JUDGE_X + 3, JUDGE_Y + 3, JUDGE_W - 6, JUDGE_H - 6, 2, 3);
		sprite_draw(JUDGE_X, JUDGE_Y, spr, DRW_NOMAL);
		if(i >= SEC(15)) {
			render_rectangle_shadow(&render, 0, 0, DISP_X, DISP_Y, (i - SEC(15)), 3);
		}
		if(joy & TRG_MASK) {
			if(i < SEC(15)) {
				i = SEC(15); /* tF[hAEgJn */
			} else {
				break; /* Aj[VLZ */
			}
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
game_init()
{
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player;
	int i;
	int s[2];

	memset(&game, 0, sizeof game);

	pic_sel = (pic_sel + RND32_RANGE(seed, 1, 6)) % 6;

	s[0] = RND32(seed);
	if(haifuda_sel == 0) {
		s[1] = s[0];		/* vC[12𓯂cɂꍇ */
	} else {
		s[1] = RND32(seed);	/* vC[12Ⴄcɂꍇ */
	}

	for(i = 0; i < 2; i++) {
		player = &kyokumen->player[i];
		player->seed = s[i];
		player->field_col = (FIELD_SIZE - 1) / 2;
		player->field_row = (FIELD_SIZE - 1) / 2;
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

int
is_field_full(const KYOKUMEN* kyokumen)
{
	int col;
	int row;
	const FUDA* field;

	for(row = 0; row < FIELD_SIZE; row++) {
		for(col = 0; col < FIELD_SIZE; col++) {
			field = &kyokumen->field[row][col];
			if(!field->setugou) {
				return 0; /* ܂󂫂L */
			}
		}
	}

	return 1; /* tB[hςɂȂ */
}

/****************************************************************************
 *	
 ****************************************************************************/

void
manual_main()
{
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player = &kyokumen->player[kyokumen->teban];
	int i;

	for(;;) {
		/* DI */
		blink = 0; /* _Ń^C~O킹 */
		for(;;) {
			schedule();
			if(tefuda_sel_exec()) {
				player->tefuda_rot_anim = 0; /* ]Ȃ犮 */
				break;
			}
			kyokumen_draw(kyokumen);
			haiti_draw();
			tefuda_sel_draw();
			sel_hdr_ftr_draw();
			if(joy & TRG_SELECT) {
				/* j[ */
				menu_sel = 0; /* I = Q[ĊJ */
				do {
					schedule();
					kyokumen_draw(kyokumen);
					haiti_draw();
					tefuda_sel_draw();
					menu_draw();
				} while(!menu_exec());
				if(menu_sel) {
					longjmp(jb_sel, 1); /* ^Cg֖߂ */
				}
				blink = 0; /* _Ń^C~O킹 */
			}
		}

		/* DItB[hIJڃAj[V */
		for(i = 0; i < 6; i++) {
			schedule();
			kyokumen_draw(kyokumen);
			haiti_draw();
			tefuda_field_draw(i);
			if(joy & TRG_MASK) {
				break; /* Aj[VLZ */
			}
		}

		/* tB[hI */
		blink = 0; /* _Ń^C~O킹 */
		for(;;) {
			schedule();
			if(joy & TRG_SELECT) {
				player->tefuda_rot_anim = 0; /* ]Ȃ犮 */
				break;
			}
			if(field_sel_exec()) {
				player->tefuda_rot_anim = 0; /* ]Ȃ犮 */
				return; /* ܂ */
			}
			kyokumen_draw(kyokumen);
			haiti_draw();
			field_sel_draw();
			put_hdr_ftr_draw();
		}

		/* tB[hIDIJڃAj[V */
		for(i = 6 - 1; i >= 0; i--) {
			schedule();
			kyokumen_draw(kyokumen);
			haiti_draw();
			tefuda_field_draw(i);
			if(joy & TRG_MASK) {
				break; /* Aj[VLZ */
			}
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

#define TNK_MTR_X_ADD	21	/* vlwb_̌_烁[^`ւ̃ItZbg */
#define TNK_MTR_Y_ADD	 2
#define THK_MTR_W	39	/* [^`̃TCY */
#define THK_MTR_H	 5

/*--------------------------------------------------------------------------*/

/* idle thread */
static int
auto_idle_proc(int param)
{
	PROGRESS* progress = (PROGRESS*)param;
	//
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player = &kyokumen->player[kyokumen->teban];
	TE best_te;
	int i;

	/* őP擾 */
	get_best_te(kyokumen, &best_te, progress);

	/* őPi[ */
	player->tefuda_sel = best_te.tefuda_sel;
	for(i = 0; i < best_te.tefuda_rot; i++) {
		FUDA* tefuda = &player->tefuda[player->tefuda_sel];
		tefuda->setugou = setugou_rot_tbl[tefuda->setugou];
	}
	player->field_col = best_te.field_col;
	player->field_row = best_te.field_row;

	return 0;
}

/*--------------------------------------------------------------------------*/

static void
progress_draw(PROGRESS* progress)
{
	int x;
	int y;
	int w;
	int h;
	int spr;

	x = HDR_X;
	y = HDR_Y;
	spr = SPR_TNK_HDR;
	sprite_draw(x, y, spr, DRW_NOMAL);

	/* [^` */
	x += TNK_MTR_X_ADD;
	y += TNK_MTR_Y_ADD;
	w = THK_MTR_W;
	h = THK_MTR_H;
	render_rectangle_shadow(&render, x, y, w, h, 2, 3);
	if(progress->max) {
		w = w * progress->pos / progress->max;
		render_rectangle_fill(&render, x, y, w, h, 0);
	}

	if(blink % SEC(2) < SEC(1)) {
		x = FTR_X;
		y = FTR_Y;
		spr = SPR_TNK_FTR;
		sprite_draw(x, y, spr, DRW_NOMAL);
	}
}

/*--------------------------------------------------------------------------*/

void
auto_main()
{
	KYOKUMEN* kyokumen = &game.kyokumen;
	PROGRESS progress = { 0 };
	int i;

	/* vl[`N
	 * vl[`́Aȉ̃tB[hɍőPi[
	 *   player->field_col
	 *   player->field_row
	 *   player->tefuda_sel
	 *   player->tefuda[player->tefuda_sel].setugou (])
	 */
	idle_init(auto_idle_proc, (int)&progress);

	/* vl[`܂Łc */
	blink = 0; /* _Ń^C~O킹 */
	while(idle_stat()) {
		/* `惋[`ׂ̕ĂAvl[`100%̃^CXCX^邱Ƃɂ
		 * ̕t[[g邪Avl҂̊ԂȂ̂ŁAقǋCɂȂȂ낤
		 */
		apptm_wk = pceTimerGetCount();
		schedule();
		kyokumen_draw(kyokumen);
		haiti_draw();
		tefuda_sel_draw();
		progress_draw(&progress);
		if(joy & TRG_SELECT) {
			/* j[ */
			menu_sel = 0; /* I = Q[ĊJ */
			do {
				schedule();
				kyokumen_draw(kyokumen);
				haiti_draw();
				tefuda_sel_draw();
				menu_draw();
			} while(!menu_exec());
			if(menu_sel) {
				idle_init(NULL, 0); /* vl[`𒆒fBYƁAprogressւ݂̏pĂ܂ */
				longjmp(jb_sel, 1); /* ^Cg֖߂ */
			}
			blink = 0; /* _Ń^C~O킹 */
		}
	}

	/* DItB[hIJڃAj[V */
	for(i = 0; i < 6; i++) {
		schedule();
		kyokumen_draw(kyokumen);
		haiti_draw();
		tefuda_field_draw(i);
		if(joy & TRG_MASK) {
			break; /* Aj[VLZ */
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

#define MENU1_X	35
#define MENU1_Y	21

#define MENU2_X	35
#define MENU2_Y	51

#define MENU_W	57
#define MENU_H	17

/*--------------------------------------------------------------------------*/

int
menu_exec()
{
	if(joy & TRG_UP) {
		menu_sel = 0; /* Q[ĊJ */
	}
	if(joy & TRG_DN) {
		menu_sel = 1; /* ^Cgɂǂ */
	}
	if(joy & TRG_A) {
		return 1; /*  */
	}
	if(joy & (TRG_B | TRG_SELECT)) {
		menu_sel = 0; /* Q[ĊJ */
		return 1; /*  */
	}
	return 0; /* p */
}

/*--------------------------------------------------------------------------*/

void
menu_draw()
{
	if(menu_sel == 0) {
		render_rectangle_fill  (&render, MENU1_X + 3, MENU1_Y + 3, MENU_W - 6, MENU_H - 6, 0);
		render_rectangle_shadow(&render, MENU2_X + 3, MENU2_Y + 3, MENU_W - 6, MENU_H - 6, 1, 3);
	} else {
		render_rectangle_fill  (&render, MENU2_X + 3, MENU2_Y + 3, MENU_W - 6, MENU_H - 6, 0);
		render_rectangle_shadow(&render, MENU1_X + 3, MENU1_Y + 3, MENU_W - 6, MENU_H - 6, 1, 3);
	}
	sprite_draw(MENU1_X, MENU1_Y, SPR_SAIKAI, DRW_NOMAL);
	sprite_draw(MENU2_X, MENU2_Y, SPR_MODORU, DRW_NOMAL);
	if(menu_sel == 0) {
		render_rectangle_shadow(&render, MENU2_X + 3, MENU2_Y + 3, MENU_W - 6, MENU_H - 6, 1, 3);
	} else {
		render_rectangle_shadow(&render, MENU1_X + 3, MENU1_Y + 3, MENU_W - 6, MENU_H - 6, 1, 3);
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
fuda_draw(const FUDA* fuda, int x, int y, int rot)
{
	int spr;

	/* D */
	spr = fuda_spr_tbl[(now >> 1) & 1][fuda->iro][fuda->setugou] - rot;
	sprite_draw(x, y, spr, DRW_NOMAL);

	/*  */
	spr = kazu_spr_tbl[fuda->kazu];
	sprite_draw(x, y, spr, DRW_NOMAL);
}

/****************************************************************************
 *	
 ****************************************************************************/

void
kyokumen_draw(const KYOKUMEN* kyokumen)
{
	const PLAYER* player;
	int i;
	int j;
	int col;
	int row;
	int x;
	int y;
	int spr;
	int score;
	const FUDA* field1;
	const FUDA* field2;
	const FUDA* tefuda;

	/* wi */
	spr = SPR_PIC1 + pic_sel;
	sprite_draw((~now >> 1 & 127) - 128, 0, spr, DRW_NOMAL);
	sprite_draw((~now >> 1 & 127)      , 0, spr, DRW_NOMAL);

	/* g */
	sprite_draw(0, 0, SPR_BG, DRW_NOMAL);

	for(row = 0; row < FIELD_SIZE; row++) {
		for(col = 0; col < FIELD_SIZE; col++) {
			field1 = &kyokumen->field[row][col];
			if(!field1->setugou) {
				continue;
			}

			x = FIELD_X + MASU_SIZE * col;
			y = FIELD_Y + MASU_SIZE * row;

			/* D */
			fuda_draw(field1, x, y, 0);

			/* Eڍ */
			if(field1->setugou & FUDA_SETUGOU_R) {
				if(col < FIELD_SIZE - 1) {
					field2 = &kyokumen->field[row][col + 1];
					if(field2->setugou & FUDA_SETUGOU_L) {
						if((field1->iro == field2->iro) ||
						   ((field1->iro == kyokumen->teban) && (field2->iro == FUDA_IRO_NIJI)) ||
						   ((field1->iro == FUDA_IRO_NIJI) && (field2->iro == kyokumen->teban))) {
							spr = SPR_SETUGOU_R;
							sprite_draw(x, y, spr, DRW_NOMAL);
						}
					}
				}
			}

			/* ڍ */
			if(field1->setugou & FUDA_SETUGOU_D) {
				if(row < FIELD_SIZE - 1) {
					field2 = &kyokumen->field[row + 1][col];
					if(field2->setugou & FUDA_SETUGOU_U) {
						if((field1->iro == field2->iro) ||
						   ((field1->iro == kyokumen->teban) && (field2->iro == FUDA_IRO_NIJI)) ||
						   ((field1->iro == FUDA_IRO_NIJI) && (field2->iro == kyokumen->teban))) {
							spr = SPR_SETUGOU_D;
							sprite_draw(x, y, spr, DRW_NOMAL);
						}
					}
				}
			}
		}
	}

	for(i = 0; i < 2; i++) {
		player = &kyokumen->player[i];

		/*  */
		x = teban_pos_tbl[i][0];
		y = teban_pos_tbl[i][1];
		spr = (i == teban_sel) ? SPR_BG_YOU : SPR_BG_CPU;
		sprite_draw(x, y, spr, DRW_NOMAL);

		/* XRA */
		x = score_pos_tbl[i][0];
		y = score_pos_tbl[i][1];
		score = player->score;
		if(score > 9999) {
			score = 9999;
		}
		render_printf(&render, x, y, 2, 0, "%4d", score);

		for(j = 0; j < TEFUDA_COUNT; j++) {
			tefuda = &player->tefuda[j];
			if(!tefuda->setugou) {
				continue;
			}

			x = tefuda_pos_tbl[i][j][0];
			y = tefuda_pos_tbl[i][j][1];

			/* D */
			fuda_draw(tefuda, x, y, 0);
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
tefuda_gen_draw(int cnt/*0..4*/)
{
	static const char tbl[5][2/*size,color*/] = {
		{ 1, 2 },
		{ 3, 2 },
		{ 5, 1 },
		{ 7, 1 },
		{ 9, 0 },
	};
	const KYOKUMEN* kyokumen = &game.kyokumen;
	const PLAYER* player;
	int i;
	int j;
	int x;
	int y;
	int s;
	int c;
	const FUDA* tefuda;

	if((cnt < 0) || (cnt > ARRAY_SIZE(tbl) - 1)) {
		DIE();
	}
	s = tbl[cnt][0];
	c = tbl[cnt][1];

	for(i = 0; i < 2; i++) {
		player = &kyokumen->player[i];
		for(j = 0; j < TEFUDA_COUNT; j++) {
			tefuda = &player->tefuda[j];
			if(tefuda->setugou) {
				continue;
			}
			x = tefuda_pos_tbl[i][j][0];
			y = tefuda_pos_tbl[i][j][1];

			x -= (s - 9) / 2;
			y -= (s - 9) / 2;
			render_rectangle_fill(&render, x, y, s, s, c);
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

int
tefuda_sel_exec()
{
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player = &kyokumen->player[kyokumen->teban];
	FUDA* tefuda = &player->tefuda[player->tefuda_sel];
	int dir = -1;

	if(joy & TRG_A) {
		return 1;
	}
	if(joy & TRG_B) {
		tefuda->setugou = setugou_rot_tbl[tefuda->setugou];
		player->tefuda_rot_anim = 3;
	} else {
		if(player->tefuda_rot_anim) {
			player->tefuda_rot_anim--;
		}
	}
	if(joy & TRG_LF) dir = DIR_L;
	if(joy & TRG_RI) dir = DIR_R;
	if(joy & TRG_UP) dir = DIR_U;
	if(joy & TRG_DN) dir = DIR_D;
	if(dir != -1) {
		player->tefuda_sel = tefuda_sel_tbl[dir][player->tefuda_sel];
	}

	return 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

void
haiti_draw()
{
	const KYOKUMEN* kyokumen = &game.kyokumen;
	const PLAYER* player = &kyokumen->player[kyokumen->teban];
	const FUDA* tefuda = &player->tefuda[player->tefuda_sel];
	int col;
	int row;
	int x;
	int y;
	int spr;

	for(row = 0; row < FIELD_SIZE; row++) {
		for(col = 0; col < FIELD_SIZE; col++) {
			if(fuda_put_test(kyokumen, tefuda->iro, col, row)) {
				x = FIELD_X + MASU_SIZE * col;
				y = FIELD_Y + MASU_SIZE * row;
				spr = SPR_MASU2;
				sprite_draw(x, y, spr, 0);
			}
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
tefuda_sel_draw()
{
	const KYOKUMEN* kyokumen = &game.kyokumen;
	const PLAYER* player = &kyokumen->player[kyokumen->teban];
	const FUDA* tefuda = &player->tefuda[player->tefuda_sel];
	int x;
	int y;
	int spr;

	x = tefuda_pos_tbl[kyokumen->teban][player->tefuda_sel][0];
	y = tefuda_pos_tbl[kyokumen->teban][player->tefuda_sel][1];

	if(player->tefuda_rot_anim) {
		spr = SPR_MASU3;
		sprite_draw(x, y, spr, DRW_NOMAL);
		fuda_draw(tefuda, x, y, player->tefuda_rot_anim);
	}

	spr = SPR_CURSOR;
	sprite_draw(x, y, spr, DRW_NOMAL);
}

/*--------------------------------------------------------------------------*/

void
sel_hdr_ftr_draw()
{
	if(blink % SEC(2) < SEC(1)) {
		sprite_draw(HDR_X, HDR_Y, SPR_SEL_HDR, DRW_NOMAL);
		sprite_draw(FTR_X, FTR_Y, SPR_SEL_FTR, DRW_NOMAL);
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

int
field_sel_exec()
{
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player = &kyokumen->player[kyokumen->teban];
	FUDA* tefuda = &player->tefuda[player->tefuda_sel];
	int dir = -1;

	if(joy & TRG_A) {
		if(fuda_put_test(kyokumen, tefuda->iro, player->field_col, player->field_row)) {
			return 1;
		}
	}
	if(joy & TRG_B) {
		tefuda->setugou = setugou_rot_tbl[tefuda->setugou];
		player->tefuda_rot_anim = 3;
	} else {
		if(player->tefuda_rot_anim) {
			player->tefuda_rot_anim--;
		}
	}
	if(joy & TRG_LF) dir = DIR_L;
	if(joy & TRG_RI) dir = DIR_R;
	if(joy & TRG_UP) dir = DIR_U;
	if(joy & TRG_DN) dir = DIR_D;
	if(dir != -1) {
		player->field_col = player->field_col + dir_tbl[dir][0];
		player->field_row = player->field_row + dir_tbl[dir][1];
		if(player->field_col <           0) player->field_col += FIELD_SIZE;
		if(player->field_col >= FIELD_SIZE) player->field_col -= FIELD_SIZE;
		if(player->field_row <           0) player->field_row += FIELD_SIZE;
		if(player->field_row >= FIELD_SIZE) player->field_row -= FIELD_SIZE;
	}

	return 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

void
field_sel_draw()
{
	SEARCH search; /* 1.2KBxȂ̂ŁAX^bNɎĂv */
	KYOKUMEN* kyokumen = &game.kyokumen;
	PLAYER* player = &kyokumen->player[kyokumen->teban];
	FUDA* tefuda = &player->tefuda[player->tefuda_sel];
	int x;
	int y;
	int spr;

	x = tefuda_pos_tbl[kyokumen->teban][player->tefuda_sel][0];
	y = tefuda_pos_tbl[kyokumen->teban][player->tefuda_sel][1];
	spr = SPR_MASU3;
	sprite_draw(x, y, spr, DRW_NOMAL);

	x = FIELD_X + MASU_SIZE * player->field_col;
	y = FIELD_Y + MASU_SIZE * player->field_row;
	fuda_draw(tefuda, x, y, player->tefuda_rot_anim);
	spr = SPR_CURSOR;
	sprite_draw(x, y, spr, DRW_NOMAL);

	/* 𔻒eXg\(B@\) */
	{
		static int yaku_test_on;
		if(joy & TRG_START) {
			yaku_test_on = !yaku_test_on;
		}
		if(yaku_test_on) {
			if(fuda_put_test(kyokumen, tefuda->iro, player->field_col, player->field_row)) {
				FUDA* field = &kyokumen->field[player->field_row][player->field_col];
				FUDA* tefuda = &player->tefuda[player->tefuda_sel];
				int n[YAKU_TYPE_COUNT] = { 0 };
				int i;

				memcpy(field, tefuda, sizeof(FUDA));
				yaku_search(kyokumen, &search);
				memset(field, 0, sizeof(FUDA));

				for(i = 0; i < search.yaku_cnt; i++) {
					n[search.yaku[i].type]++;
				}

				x = 106;
				y = kyokumen->teban ? 1 : 54;
				for(i = 0; i < YAKU_TYPE_COUNT; i++) {
					sprite_draw(x + 0, y, yaku_spr_tbl[i], DRW_NOMAL);
					render_printf_framed(&render, x + 9, y - 1, 0, 3, "%2d", n[i]);
					y += 8;
				}
			}
		}
	}
}

/*--------------------------------------------------------------------------*/

void
put_hdr_ftr_draw()
{
	if(blink % SEC(2) < SEC(1)) {
		sprite_draw(HDR_X, HDR_Y, SPR_PUT_HDR, DRW_NOMAL);
		sprite_draw(FTR_X, FTR_Y, SPR_PUT_FTR, DRW_NOMAL);
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
tefuda_field_draw(int cnt/*0..5*/)
{
	static const char tbl[6][2/*size,color*/] = {
		{  9, 0 },
		{ 11, 1 },
		{ 15, 2 },
		{ 15, 2 },
		{ 11, 1 },
		{  9, 0 },
	};
	const KYOKUMEN* kyokumen = &game.kyokumen;
	const PLAYER* player = &kyokumen->player[kyokumen->teban];
	int x;
	int y;
	int s;
	int c;
	int spr;

	if((cnt < 0) || (cnt > ARRAY_SIZE(tbl) - 1)) {
		DIE();
	}
	s = tbl[cnt][0];
	c = tbl[cnt][1];

	x = tefuda_pos_tbl[kyokumen->teban][player->tefuda_sel][0];
	y = tefuda_pos_tbl[kyokumen->teban][player->tefuda_sel][1];
	if(cnt < 3) {
		x -= (s - 9) / 2;
		y -= (s - 9) / 2;
		render_rectangle_fill(&render, x, y, s, s, c);
	} else {
		spr = SPR_MASU3;
		sprite_draw(x, y, spr, DRW_NOMAL);
	}

	x = FIELD_X + MASU_SIZE * player->field_col;
	y = FIELD_Y + MASU_SIZE * player->field_row;
	if(cnt >= 3) {
		x -= (s - 9) / 2;
		y -= (s - 9) / 2;
		render_rectangle_fill(&render, x, y, s, s, c);
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
field_sel_done_draw(int cnt/*0..4*/)
{
	static const char tbl[5][2/*size,color*/] = {
		{  9, 0 },
		{ 11, 0 },
		{ 13, 1 },
		{ 15, 1 },
		{ 19, 2 },
	};
	const KYOKUMEN* kyokumen = &game.kyokumen;
	const PLAYER* player = &kyokumen->player[kyokumen->teban];
	int x;
	int y;
	int s;
	int c;

	if((cnt < 0) || (cnt > ARRAY_SIZE(tbl) - 1)) {
		DIE();
	}
	s = tbl[cnt][0];
	c = tbl[cnt][1];

	x = FIELD_X + MASU_SIZE * player->field_col;
	y = FIELD_Y + MASU_SIZE * player->field_row;

	x -= (s - 9) / 2;
	y -= (s - 9) / 2;
	if(!cnt) {
		render_rectangle_fill(&render, x, y, s, s, c);
	} else {
		render_rectangle(&render, x, y, s, s, c);
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

static int
yaku_draw_suuretu_dousuu_houi(const YAKU* yaku, int cnt)
{
	int i;
	int x;
	int y;
	int pos1;
	int col1;
	int row1;
	int pos2;
	int col2;
	int row2;
	int spr;
	int ten;

	/* ΂̋ */
	for(i = 0; i < cnt; i++) {
		if(i > yaku->len - 1) {
			break;
		}
		pos1 = yaku->pos[i];
		col1 = pos1 & 15;
		row1 = pos1 >> 4;
		x = FIELD_X + MASU_SIZE * col1;
		y = FIELD_Y + MASU_SIZE * row1;
		spr = SPR_FIRE1 + (now & 1);
		sprite_draw(x, y, spr, DRW_NOMAL);
	}

	/* Ȃ */
	for(i = 1; i < cnt + 1; i++) {
		if(yaku->type == YAKU_TYPE_HOUI) {
			/* ͂́AŏƍŌ̂ȂL */
			if(i > yaku->len) {
				break;
			}
		} else {
			/* Ɠ́AŏƍŌ̂Ȃ */
			if(i > yaku->len - 1) {
				break;
			}
		}
		pos1 = yaku->pos[i % yaku->len];
		col1 = pos1 & 15;
		row1 = pos1 >> 4;
		pos2 = yaku->pos[i - 1];
		col2 = pos2 & 15;
		row2 = pos2 >> 4;
		if(col1 < col2) {
			x = FIELD_X + MASU_SIZE * col1;
			y = FIELD_Y + MASU_SIZE * row1;
			spr = SPR_FIRE1_R + (now & 1);
		} else if(col2 < col1) {
			x = FIELD_X + MASU_SIZE * col2;
			y = FIELD_Y + MASU_SIZE * row2;
			spr = SPR_FIRE1_R + (now & 1);
		} else if(row1 < row2) {
			x = FIELD_X + MASU_SIZE * col1;
			y = FIELD_Y + MASU_SIZE * row1;
			spr = SPR_FIRE1_D + (now & 1);
		} else /* if(row2 < row1) */ {
			x = FIELD_X + MASU_SIZE * col2;
			y = FIELD_Y + MASU_SIZE * row2;
			spr = SPR_FIRE1_D + (now & 1);
		}
		sprite_draw(x, y, spr, DRW_NOMAL);
	}

	cnt -= yaku->len;

	/* ̖OƓ_ */
	if(cnt >= 0) {
		pos1 = yaku->pos[0];
		col1 = pos1 & 15;
		row1 = pos1 >> 4;
		spr = yaku_spr_tbl[yaku->type];
		ten = yaku_get_ten(yaku);
		yaku_draw_name_ten(col1, row1, cnt, spr, ten);
	}

	if(cnt >= YAKU_DRAW_NAME_TIME - 1) {
		return 1;
	}

	return 0;
}

/*--------------------------------------------------------------------------*/

static int
yaku_draw_kanzen(const YAKU* yaku, int cnt)
{
	const KYOKUMEN* kyokumen = &game.kyokumen;
	const FUDA* field;
	int i;
	int x;
	int y;
	int pos;
	int col;
	int row;
	int spr;
	int ten;

	/* R */
	for(i = 0; i < yaku->len; i++) {
		pos = yaku->pos[i];
		col = pos & 15;
		row = pos >> 4;
		x = FIELD_X + MASU_SIZE * col;
		y = FIELD_Y + MASU_SIZE * row;
		spr = (cnt < 2/**/) ? SPR_ROCK1 : SPR_ROCK2;
		sprite_draw(x, y, spr, DRW_NOMAL);
	}

	/* Ȃ */
	for(i = 0; i < yaku->len; i++) {
		pos = yaku->pos[i];
		col = pos & 15;
		row = pos >> 4;
		x = FIELD_X + MASU_SIZE * col;
		y = FIELD_Y + MASU_SIZE * row;
		field = &kyokumen->field[row][col];
		if(field->setugou & FUDA_SETUGOU_R) {
			spr = (cnt < 2/**/) ? SPR_ROCK1_R : SPR_ROCK2_R;
			sprite_draw(x, y, spr, DRW_NOMAL);
		}
		if(field->setugou & FUDA_SETUGOU_D) {
			spr = (cnt < 2/**/) ? SPR_ROCK1_D : SPR_ROCK2_D;
			sprite_draw(x, y, spr, DRW_NOMAL);
		}
	}

	cnt -= 4/**/;

	/* ̖OƓ_ */
	if(cnt >= 0) {
		pos = yaku->pos[0];
		col = pos & 15;
		row = pos >> 4;
		spr = yaku_spr_tbl[yaku->type];
		ten = yaku_get_ten(yaku);
		yaku_draw_name_ten(col, row, cnt, spr, ten);
	}

	if(cnt >= YAKU_DRAW_NAME_TIME - 1) {
		return 1;
	}

	return 0;
}

/*--------------------------------------------------------------------------*/

int
yaku_draw(const YAKU* yaku, int cnt)
{
	int (*fn)(const YAKU* yaku, int cnt);

	switch(yaku->type) {
	case YAKU_TYPE_SUURETU:
	case YAKU_TYPE_DOUSUU:
	case YAKU_TYPE_HOUI:
		fn = yaku_draw_suuretu_dousuu_houi;
		break;
	case YAKU_TYPE_KANZEN:
		fn = yaku_draw_kanzen;
		break;
	default:
		DIE();
	}

	return (*fn)(yaku, cnt);
}

/****************************************************************************
 *	
 ****************************************************************************/

/* ̖OƁA_\Ƃ́A}X̊W̃ItZbg */
#define YAKU_NAME_Y_SUB	8	/* ̖O\OɁA}XyWɂ̒l𑫂 */
#define YAKU_NAME_Y_ADD	8	/* _̕\OɁAyWɂ̒l𑫂 */
#define YAKU_TEN_X_SUB	3	/* _10̈ʂ\OɁAxW炱̒l */
#define YAKU_TEN_X_ADD	6	/* _1̈ʂ\OɁAxWɂ̒l𑫂 */
				/* _3̏ꍇ́AYAKU_TEN_X_SUB2{ */

/*--------------------------------------------------------------------------*/

void
yaku_draw_name_ten(int col, int row, int cnt, int name_spr, int ten)
{
	int x;
	int y;
	int spr;
	int dx = 0;
	int param = DRW_NOMAL;

	/* ̖OƓ_́Au}Xɕ\ */
	x = FIELD_X + MASU_SIZE * col;
	y = FIELD_Y + MASU_SIZE * row;

	switch(name_spr) {
	case SPR_YAKU_GOUKEI:
		/* v͌ďo ({͊g傾Ȃp) */
		if(cnt <= 3) {
			param = DRW_MASK(cnt ^ 3);
		}
		break;
	case SPR_YAKU_KANZEN:
		/* S͐Î~\ */
		/** no job **/
		break;
	default:
		/* ȊO͏ƍEɓ */
		y -= cnt;
		if(cnt > 5) {
			dx = (cnt - 5) * (cnt - 5);
		}
		break;
	}

	x += dx;

	/* ̖O */
	y -= YAKU_NAME_Y_SUB;
	sprite_draw(x, y, name_spr, param);
	y += YAKU_NAME_Y_ADD;

	x -= dx * 2;

	/* _ */
	if(ten >= 10) {
		x -= YAKU_TEN_X_SUB;
		if(ten >= 100) {
			x -= YAKU_TEN_X_SUB;
		}
	}
	/* 100̌ */
	if(ten >= 100) {
		spr = ten_spr_tbl[(ten / 100) % 10];
		sprite_draw(x, y, spr, param);
		x += YAKU_TEN_X_ADD;
	}
	/* 10̌ */
	if(ten >= 10) {
		spr = ten_spr_tbl[(ten / 10) % 10];
		sprite_draw(x, y, spr, param);
		x += YAKU_TEN_X_ADD;
	}
	/* 1̌ */
	spr = ten_spr_tbl[ten % 10];
	sprite_draw(x, y, spr, param);
}

/****************************************************************************
 *	
 ****************************************************************************/

int
yaku_get_ten(const YAKU* yaku)
{
	int ten;

	switch(yaku->type) {
	case YAKU_TYPE_SUURETU:
	case YAKU_TYPE_DOUSUU:
	case YAKU_TYPE_HOUI:
		ten = yaku->len * 10;
		break;
	case YAKU_TYPE_KANZEN:
		ten = yaku->len * 20;
		break;
	default:
		DIE();
	}

	return ten;
}

/****************************************************************************
 *	
 ****************************************************************************/

void
tefuda_put(KYOKUMEN* kyokumen)
{
	PLAYER* player = &kyokumen->player[kyokumen->teban];
	FUDA* tefuda;
	FUDA* field;

	/* DtB[hɔzuA̎DNA */
	field = &kyokumen->field[player->field_row][player->field_col];
	tefuda = &player->tefuda[player->tefuda_sel];
	memcpy(field, tefuda, sizeof(FUDA));
	memset(tefuda, 0, sizeof(FUDA));

	/* zumɃNA */
	kyokumen->kaijo = 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

void
tefuda_gen(KYOKUMEN* kyokumen)
{
	PLAYER* player;
	int teban;
	int i;
	int a;
	int b;
	FUDA* tefuda;

	for(teban = 0; teban < 2; teban++) {
		player = &kyokumen->player[teban];
		for(i = 0; i < TEFUDA_COUNT; i++) {
			tefuda = &player->tefuda[i];
			if(tefuda->setugou) {
				continue; /* ɗLƂɂ͐Ȃ */
			}

			/* ڍ */
			a = RND32_RANGE(player->seed, 0, 100);
			for(b = 0; b < ARRAY_SIZE(setugou_rate_tbl) - 1; b++) {
				if((a -= setugou_rate_tbl[b][0]) < 0) {
					break;
				}
			}
			tefuda->setugou = setugou_rate_tbl[b][1];

			/* F */
			a = RND32_RANGE(player->seed, 0, 100);
			tefuda->iro = (a < NIJI_RATE) ? FUDA_IRO_NIJI : teban;

			/*  */
			tefuda->kazu = RND32_RANGE(player->seed, 0, 5);
		}
	}
}

