/*
 *	fram.c
 *
 *	w^CZǂ
 *
 *	* Sun Oct 25 14:18:15 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

static void
yaku_search_suuretu_dousuu_sub(SEARCH* search, int col, int row, int dir, int kazu, int order)
{
	const KYOKUMEN* kyokumen = search->kyokumen;
	const FUDA* field;
	YAKU* yaku;
	int pos;
	int yaku_cnt_save;
	int i;

	/* tB[hOȂA܂ */
	col += dir_tbl[dir][0];
	row += dir_tbl[dir][1];
	if((col < 0) || (col > FIELD_SIZE - 1) ||
	   (row < 0) || (row > FIELD_SIZE - 1)) {
		return;
	}
	field = &kyokumen->field[row][col];

	/* ɐڍ΁A܂ */
	dir ^= 2; /* 180x] =  */
	if(!(field->setugou & (1 << dir))) {
		return;
	}

	/* G̐FDȂ΁A܂ */
	if(field->iro == !kyokumen->teban) {
		return;
	}

	/* 񏸏(order=1)A܂́A~(order=-1)A܂́A(order=0)łȂ΁A܂ */
	kazu += order;
	if(field->kazu != kazu) {
		return;
	}

	/* ɒTĂA܂ */
	pos = col | row << 4;
	if(memchr(search->pos, pos, search->len)) {
		return;
	}

	/* T}X}[N */
	if(search->len > YAKU_LEN_MAX - 1) {
		DIE();
	}
	search->pos[search->len++] = pos;

	/* ̐TOɁAĂ̐ۑ */
	yaku_cnt_save = search->yaku_cnt;

	/* ȊOŁAڍ̂ɒT */
	for(i = 0; i < DIR_COUNT - 1; i++) {
		dir = (dir + 1) % DIR_COUNT;
		if(field->setugou & (1 << dir)) {
			yaku_search_suuretu_dousuu_sub(search, col, row, dir, kazu, order);
		}
	}

	/* TŖĂȂ΁A܂ł̒ToHŖ𐬗 */
	if(search->yaku_cnt == yaku_cnt_save) {
		if(search->yaku_cnt > SEARCH_YAKU_MAX - 1) {
			DIE();
		}
		yaku = &search->yaku[search->yaku_cnt];
		yaku->type = order ? YAKU_TYPE_SUURETU : YAKU_TYPE_DOUSUU; /* 񏸏(order=1)A܂́A~(order=-1)A܂́A(order=0) */
		yaku->len = search->len;
		memcpy(yaku->pos, search->pos, search->len);
		if(++search->yaku_cnt == SEARCH_YAKU_MAX) {
			longjmp(search->exit_jb, 1);
		}
	}

	/* T}X̃}[N */
	if(search->len < 1) {
		DIE();
	}
	search->len--;
}

/*--------------------------------------------------------------------------*/

static void
yaku_search_suuretu_dousuu(SEARCH* search, int col, int row)
{
	const KYOKUMEN* kyokumen = search->kyokumen;
	const FUDA* field;
	int dir;

	field = &kyokumen->field[row][col];

	/* ŏ̒Tʒui[ */
	search->len = 1;
	search->pos[0] = col | row << 4;

	/* ڍ̗L֒T */
	for(dir = 0; dir < DIR_COUNT; dir++) {
		if(field->setugou & (1 << dir)) {
			yaku_search_suuretu_dousuu_sub(search, col, row, dir, field->kazu, 1/*񏸏*/);
			if(search->len != 1) {
				DIE();
			}
		}
	}

	/* ڍ̗L֒T */
	for(dir = 0; dir < DIR_COUNT; dir++) {
		if(field->setugou & (1 << dir)) {
			yaku_search_suuretu_dousuu_sub(search, col, row, dir, field->kazu, -1/*~*/);
			if(search->len != 1) {
				DIE();
			}
		}
	}

	/* ڍ̗L֒T */
	for(dir = 0; dir < DIR_COUNT; dir++) {
		if(field->setugou & (1 << dir)) {
			yaku_search_suuretu_dousuu_sub(search, col, row, dir, field->kazu, 0/**/);
			if(search->len != 1) {
				DIE();
			}
		}
	}
}

/*--------------------------------------------------------------------------*/

static void
yaku_search_houi_sub(SEARCH* search, int col, int row, int dir)
{
	const KYOKUMEN* kyokumen = search->kyokumen;
	const FUDA* field;
	YAKU* yaku;
	int pos;
	int i;
	int j;

	/* tB[hOȂA܂ */
	col += dir_tbl[dir][0];
	row += dir_tbl[dir][1];
	if((col < 0) || (col > FIELD_SIZE - 1) ||
	   (row < 0) || (row > FIELD_SIZE - 1)) {
		return;
	}
	field = &kyokumen->field[row][col];

	/* ɐڍ΁A܂ */
	dir ^= 2; /* 180x] =  */
	if(!(field->setugou & (1 << dir))) {
		return;
	}

	/* ToH̐擪ɖ߂c */
	pos = col | row << 4;
	if(search->pos[0] == pos) {
		/* t͐̕ڍɐĂAdo^͂Ȃ
		 * t̏ꍇApos[0]͓ŁApos[1...len-1]tɊi[Ă
		 * 肠̒Tpos[0]͏ɓȂ̂ŁAKv͖
		 * <> {0x14,0x24,0x25,0x15} <-> {0x14,0x15,0x25,0x24}
		 */
		for(i = 0; i < search->yaku_cnt; i++) {
			yaku = &search->yaku[i];
			if((yaku->type == YAKU_TYPE_HOUI) && (yaku->len == search->len)) {
				for(j = 1; j < search->len; j++) {
					if(yaku->pos[j] != search->pos[search->len - j]) {
						break;
					}
				}
				if(j == search->len) {
					return; /* ܂ */
				}
			}
		}
		/* 𐬗 */
		if(search->yaku_cnt > SEARCH_YAKU_MAX - 1) {
			DIE();
		}
		yaku = &search->yaku[search->yaku_cnt];
		yaku->type = YAKU_TYPE_HOUI;
		yaku->len = search->len;
		memcpy(yaku->pos, search->pos, search->len);
		if(++search->yaku_cnt == SEARCH_YAKU_MAX) {
			longjmp(search->exit_jb, 1);
		}
		return; /* ܂ */
	}

	/* G̐FDȂ΁A܂ */
	if(field->iro == !kyokumen->teban) {
		return;
	}

	/* ɒTĂA܂ */
	if(memchr(search->pos, pos, search->len)) {
		return;
	}

	/* T}X}[N */
	if(search->len > YAKU_LEN_MAX - 1) {
		DIE();
	}
	search->pos[search->len++] = pos;

	/* ȊOŁAڍ̂ɒT */
	for(i = 0; i < DIR_COUNT - 1; i++) {
		dir = (dir + 1) % DIR_COUNT;
		if(field->setugou & (1 << dir)) {
			yaku_search_houi_sub(search, col, row, dir);
		}
	}

	/* T}X̃}[N */
	if(search->len < 1) {
		DIE();
	}
	search->len--;
}

/*--------------------------------------------------------------------------*/

static void
yaku_search_houi(SEARCH* search, int col, int row)
{
	const KYOKUMEN* kyokumen = search->kyokumen;
	const FUDA* field;
	int dir;

	field = &kyokumen->field[row][col];

	/* ŏ̒Tʒui[ */
	search->len = 1;
	search->pos[0] = col | row << 4;

	/* ڍ̗L֒T */
	for(dir = 0; dir < DIR_COUNT; dir++) {
		if(field->setugou & (1 << dir)) {
			yaku_search_houi_sub(search, col, row, dir);
			if(search->len != 1) {
				DIE();
			}
		}
	}
}

/*--------------------------------------------------------------------------*/

static void
yaku_suuretu_kanzen_sub(SEARCH* search, int col, int row, int dir)
{
	const KYOKUMEN* kyokumen = search->kyokumen;
	const FUDA* field;
	int pos;
	int i;

	/* tB[hOȂASڍŖ */
	col += dir_tbl[dir][0];
	row += dir_tbl[dir][1];
	if((col < 0) || (col > FIELD_SIZE - 1) ||
	   (row < 0) || (row > FIELD_SIZE - 1)) {
		longjmp(search->exit_jb, 1);
	}
	field = &kyokumen->field[row][col];

	/* ɐڍ΁ASڍŖ */
	dir ^= 2; /* 180x] =  */
	if(!(field->setugou & (1 << dir))) {
		longjmp(search->exit_jb, 1);
	}

	/* G̐FDȂ΁ASڍŖ */
	if(field->iro == !kyokumen->teban) {
		longjmp(search->exit_jb, 1);
	}

	/* ɒTĂA܂ŁBSڍ̉\L */
	pos = col | row << 4;
	if(memchr(search->pos, pos, search->len)) {
		return;
	}

	/* T}X}[N */
	if(search->len > YAKU_LEN_MAX - 1) {
		DIE();
	}
	search->pos[search->len++] = pos;

	/* ȊOŁAڍ̂ɒT */
	for(i = 0; i < DIR_COUNT - 1; i++) {
		dir = (dir + 1) % DIR_COUNT;
		if(field->setugou & (1 << dir)) {
			yaku_suuretu_kanzen_sub(search, col, row, dir); /* SڍłȂvexit_jbŔ */
		}
	}

	/* ŁAT}X̃}[NȂ!!
	 * }[NĂ܂ƁA}X킩ȂȂĂ܂
	 * - Ƃ́A}XĂ
	 * - ȂƂ́Ar܂ŒT}XĂBS~
	 */
}

/*--------------------------------------------------------------------------*/

static void
yaku_suuretu_kanzen(SEARCH* search, int col, int row)
{
	const KYOKUMEN* kyokumen = search->kyokumen;
	const FUDA* field;
	YAKU* yaku;
	int dir;

	field = &kyokumen->field[row][col];

	/* ŏ̒Tʒui[ */
	search->len = 1;
	search->pos[0] = col | row << 4;

	/* ڍ̗L֒T */
	for(dir = 0; dir < DIR_COUNT; dir++) {
		if(field->setugou & (1 << dir)) {
			yaku_suuretu_kanzen_sub(search, col, row, dir); /* SڍłȂvexit_jbŔ */
		}
	}

	/* SڍŖvȂ΁A𐬗 */
	if(search->yaku_cnt > SEARCH_YAKU_MAX - 1) {
		DIE();
	}
	yaku = &search->yaku[search->yaku_cnt];
	yaku->type = YAKU_TYPE_KANZEN;
	yaku->len = search->len;
	memcpy(yaku->pos, search->pos, search->len);
	if(++search->yaku_cnt == SEARCH_YAKU_MAX) {
		longjmp(search->exit_jb, 1);
	}
}

/*--------------------------------------------------------------------------*/

static int
yaku_compare(const void* _yaku1, const void* _yaku2)
{
	const YAKU* yaku1 = _yaku1;
	const YAKU* yaku2 = _yaku2;

	/* ̎ނŔr */
	if(yaku1->type < yaku2->type) return -1;
	if(yaku1->type > yaku2->type) return  1;

	/* }X̐Ŕr */
	if(yaku1->len < yaku2->len ) return -1;
	if(yaku1->len > yaku2->len ) return  1;

	/* Ƃ͓ƌȂĂǂ̂AꉞA}X̔ԍŔr邱Ƃɂ */
	return memcmp(yaku1->pos, yaku2->pos, yaku2->len);
}

/*--------------------------------------------------------------------------*/

void
yaku_search(const KYOKUMEN* kyokumen, SEARCH* search)
{
	const PLAYER* player = &kyokumen->player[kyokumen->teban];

	/* T */
	memset(search, 0, sizeof(SEARCH));
	search->kyokumen = kyokumen;

	/* T */
	if(!setjmp(search->exit_jb)) {
		/*{{̏ԕK{*/
		yaku_search_suuretu_dousuu(search, player->field_col, player->field_row); /* ̐ɂȂexit_jbŔ */
		yaku_search_houi          (search, player->field_col, player->field_row); /* ̐ɂȂexit_jbŔ */
		yaku_suuretu_kanzen       (search, player->field_col, player->field_row); /* SڍłȂvexit_jbŔ */
		/*}}̏ԕK{*/
	}

	/* Ƀ\[g(\̂) */
	qsort(search->yaku, search->yaku_cnt, sizeof(YAKU), yaku_compare);
}

/****************************************************************************
 *	
 ****************************************************************************/

int
fuda_put_test(const KYOKUMEN* kyokumen, int iro, int col, int row)
{
	const PLAYER* player = &kyokumen->player[kyokumen->teban];
	int dir;
	int col2;
	int row2;
	const FUDA* tefuda;
	const FUDA* field;

	field = &kyokumen->field[row][col];
	tefuda = &player->tefuda[player->tefuda_sel];

	/* ɒuĂD̏ɂ͔zułȂ */
	if(field->setugou) {
		return 0;
	}

	/* zuĂAǂɂłzuł */
	if(kyokumen->kaijo) {
		return 1;
	}

	/* ̐FDDׂ̗ɔzuł */
	for(dir = 0; dir < DIR_COUNT; dir++) {
		col2 = col + dir_tbl[dir][0];
		row2 = row + dir_tbl[dir][1];
		if((col2 >= 0) && (col2 <= FIELD_SIZE - 1) &&
		   (row2 >= 0) && (row2 <= FIELD_SIZE - 1)) {
			field = &kyokumen->field[row2][col2];
			if(field->setugou && (field->iro != !kyokumen->teban)) {
				return 1; // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ G̐FDłȂ = ̐FDD
			}
		}
	}

	/* D́AG̐FD̗׈ȊOȂAǂɂłzuł */
	if(iro == FUDA_IRO_NIJI) {
		for(dir = 0; dir < DIR_COUNT; dir++) {
			col2 = col + dir_tbl[dir][0];
			row2 = row + dir_tbl[dir][1];
			if((col2 >= 0) && (col2 <= FIELD_SIZE - 1) &&
			   (row2 >= 0) && (row2 <= FIELD_SIZE - 1)) {
				field = &kyokumen->field[row2][col2];
				if(field->setugou && (field->iro == !kyokumen->teban)) {
					return 0;
				}
			}
		}
		return 1;
	}

	return 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

int
get_te_list(const KYOKUMEN* kyokumen, TE te_list[/*TE_MAX*/]) /* te_list = null ok */
{
	const PLAYER* player = &kyokumen->player[kyokumen->teban];
	int tefuda_sel;
	int tefuda_rot;
	int field_col;
	int field_row;
	int i;
	int n_te = 0; /* te_list[]Ɋi[ */
	int n_fuda = 0; /* fuda_list[]Ɋi[ */
	int n_pos[3/*iro*/] = { 0, 0, 0 }; /* pos_list[][]Ɋi[ */
	FUDA fuda;
	FUDA fuda_list[TEFUDA_COUNT * 4]; /* D(ő5) * ](ő4ω) */
	unsigned char pos_list[3/*iro*/][FIELD_SIZE * FIELD_SIZE]; /* F(ő3) * łʒu */

	/* eDɂāc */
	for(tefuda_sel = 0; tefuda_sel < TEFUDA_COUNT; tefuda_sel++) {
		fuda = player->tefuda[tefuda_sel];
		if(!fuda.setugou) {
			DIE(); /* Ŏ~܂Atefuda_gen()YĂ */
		}
		/* e]p^[ɂāc */
		for(tefuda_rot = 0; tefuda_rot < 4; tefuda_rot++) {
			/* ̎D̎ނ́Ả]p^[AɏoĂ? */
			for(i = 0; i < n_fuda; i++) {
				if(!memcmp(&fuda_list[i], &fuda, sizeof(FUDA))) {
					break; /* oĂ */
				}
			}
			/* ɏoĂA̎DI]́AL胊Xg͍쐬ς */
			if(i != n_fuda) {
				continue; /* ΂ */
			}
			/* oe[uɊi[ */
			fuda_list[n_fuda++] = fuda;
			/* ̐FłĂʒuAɌ?
			 * ɌđłĂʒuꍇAƔfĂ܂A薳
			 */
			if(!n_pos[fuda.iro]) {
				/* Ȃ΁A̐FłĂʒu */
				for(field_row = 0; field_row < FIELD_SIZE; field_row++) {
					for(field_col = 0; field_col < FIELD_SIZE; field_col++) {
						if(fuda_put_test(kyokumen, fuda.iro, field_col, field_row)) {
							pos_list[fuda.iro][n_pos[fuda.iro]++] = field_col | field_row << 4;
						}
					}
				}
				/* ]l̎肪DɂȂȂ悤ɁA炩߃VtĂ */
				if(te_list) { /* Ƃ̓VtĂӖ̂ŕsv */
					int tmp = seed; /* tHAOEhŗV[hXV邩ȂՓ˂Ȃ悤ɈꎞϐɃRs[Ďg */
					shuffle(&pos_list[fuda.iro][0], n_pos[fuda.iro], sizeof pos_list[fuda.iro][0], &tmp);
				}
			}
			/* DI]ƁAłĂʒȗgݍ킹AL胊XgɊi[ */
			for(i = 0; i < n_pos[fuda.iro]; i++) {
				if(te_list) { /* te_list = null ok */
					te_list[n_te].tefuda_sel = tefuda_sel;
					te_list[n_te].tefuda_rot = tefuda_rot;
					te_list[n_te].field_col = pos_list[fuda.iro][i] & 15;
					te_list[n_te].field_row = pos_list[fuda.iro][i] >> 4;
				}
				n_te++; /* te_list=null̏ꍇA͐ */
			}
			/* ]p^[i߂ */
			fuda.setugou = setugou_rot_tbl[fuda.setugou];
		}
	}

	/* L̐Ԃ */
	return n_te;
}

/****************************************************************************
 *	
 ****************************************************************************/

static int
apply_te_at_once(KYOKUMEN* k_new, const KYOKUMEN* k_old, TE* te)
{
	SEARCH search; /* 1.2KBxȂ̂ŁAX^bNɎĂv */
	PLAYER* player;
	FUDA* tefuda;
	int i;

	/* ǖʂRs[ */
	memcpy(k_new, k_old, sizeof(KYOKUMEN));

	/* i[ */
	player = &k_new->player[k_new->teban];
	player->tefuda_sel = te->tefuda_sel;
	tefuda = &player->tefuda[player->tefuda_sel];
	for(i = 0; i < te->tefuda_rot; i++) {
		tefuda->setugou = setugou_rot_tbl[tefuda->setugou];
	}
	player->field_col = te->field_col;
	player->field_row = te->field_row;

	/* ł */
	tefuda_put(k_new);

	/* T */
	yaku_search(k_new, &search);

	/* XRAZ */
	for(i = 0; i < search.yaku_cnt; i++) {
		player->score += yaku_get_ten(&search.yaku[i]);
	}

	/* Ԃ𔽓] */
	k_new->teban = !k_new->teban;

	/* 10ɕς鎞Ɂc */
	if(!k_new->teban) {
		/* ڂi߂ (zuɉêŕK{) */
		k_new->junme++;
		/* D𐶐 */
		tefuda_gen(k_new);
	}

	/* ꏄڂȂ΁Azu */
	if(!k_new->junme) {
		k_new->kaijo = 1; /* tefuda_put()NA */
	}

	/* Ԃ𔽓]Oɋ߂XRAԂ */
	return player->score;
}

/*--------------------------------------------------------------------------*/

static int
static_eval(KYOKUMEN* kyokumen)
{
	int dir;
	int col1;
	int row1;
	int col2;
	int row2;
	FUDA* field1;
	FUDA* field2;
	int eval[2/*teban*/] = { 0, 0 };
	int open[2/*iro,DȊO*/] = { 0, 0 };

	/* ڍ̐悪󂫃}Xł鐔AFƂɃJEg
	 * DɂĂ͗ԂɋʂŁA]lÊŁAʂJEgȂƂɂ
	 */
	for(row1 = 0; row1 < FIELD_SIZE; row1++) {
		for(col1 = 0; col1 < FIELD_SIZE; col1++) {
			field1 = &kyokumen->field[row1][col1];
			if(field1->setugou) {
				if(field1->iro != FUDA_IRO_NIJI) {
					for(dir = 0; dir < DIR_COUNT; dir++) {
						if(field1->setugou & (1 << dir)) {
							col2 = col1 + dir_tbl[dir][0];
							row2 = row1 + dir_tbl[dir][1];
							if((col2 >= 0) && (col2 <= FIELD_SIZE - 1) &&
							   (row2 >= 0) && (row2 <= FIELD_SIZE - 1)) {
								field2 = &kyokumen->field[row2][col2];
								if(!field2->setugou) {
									open[field1->iro]++;
								}
							}
						}
					}
				}
			}
		}
	}

	/* eԂ̕]l߂ */
	eval[0] = kyokumen->player[0].score + open[0];
	eval[1] = kyokumen->player[1].score + open[1];

	/* ݂̎ԂɂāA]lԂ */
	if(kyokumen->teban == 0) {
		return eval[0] - eval[1];
	} else {
		return eval[1] - eval[0];
	}
}

/*--------------------------------------------------------------------------*/

static int
alpha_beta(const KYOKUMEN* kyokumen, TE* best_te/*null ok */, PROGRESS* progress/*null ok*/, int depth, int alpha, int beta)
{
	static struct {
		KYOKUMEN k_tmp; /* zûݎgp */
		KYOKUMEN k_new;
		TE te_list[TE_MAX];
	} work[SAKIYOMI_MAX + 1]; /* eċÃ[NGA */
	KYOKUMEN* k_new = &work[depth].k_new;
	TE* te_list = work[depth].te_list;
	PLAYER* player;
	//
	int n_te;
	int i_te;
	int eval;
	int te_sel;

	/* L擾 */
	n_te = get_te_list(kyokumen, te_list);
	if(!n_te) { /* L肪΁c */
		/* tB[hςɂȂ? */
		if(is_field_full(kyokumen)) {
			/* tB[hς̏ԂŁAget_best_te()ĂяoĂ͂ȂAċÄi(best_te!=NULL)ł邱Ƃ͖͂ */
			if(best_te) {
				DIE(); /* Ŏ~܂Aget_best_te()ĂяõoO */
			}
			/* sԂ */
			eval = static_eval(k_new);
			if(eval > 0) return EVAL_MAX; /*  */
			if(eval < 0) return EVAL_MIN; /*  */
			return 0; /*  */
		} else {
			/* XRAƔzuύX邽߁A[NGAɃRs[ */
			KYOKUMEN* k_tmp = &work[depth].k_tmp;
			memcpy(k_tmp, kyokumen, sizeof(KYOKUMEN));
			player = &k_tmp->player[k_tmp->teban];
			/* XRA50__Azu */
			player->score -= 50;
			if(player->score < 0) {
				player->score = 0;
			}
			k_tmp->kaijo = 1; /* tefuda_put()NA */
			/* LĎ擾 */
			n_te = get_te_list(k_tmp, te_list);
			if(!n_te) {
				DIE(); /* zûŁAK擾ł͂ */
			}
			/* ȍ~́Ak_tmpkyokumenƂĎg */
			kyokumen = k_tmp;
		}
	}

	/* vOXo[ */
	if(progress) {
		progress->max = n_te;
	}

	/* ɁAőP߂
	 * ASĂ̒̕]lȉAŏ̒I
	 */
	te_sel = 0;

	/* eLɂāc */
	for(i_te = 0; i_te < n_te; i_te++) {
		/* 𔽉f
		 * apply_te_at_once()AƂAԂ]Ă邱Ƃɒ
		 */
		if(apply_te_at_once(k_new, kyokumen, &te_list[i_te]) >= mokuhyou) {
			///* ڕW_𒴂AꂪőP */
			//alpha = EVAL_MAX;
			//te_sel = i_te;
			//break; /* ܂ */
			//̏ƁARs[^mMƂɒ߂ēKȎł̂ŁAsRB
			//̏ȂĂ͂قƂǈȂ̂ŁAOƂɂB
		}
		/* 𔽉fʂ́A]l擾
		 * ɎԂ]Ă̂ŁAalpha_beta()static_eval()́A̕]lԂ
		 * ]āA]l𐳕]KvL
		 */
		if(depth) {
			eval = -alpha_beta(k_new, NULL, NULL, depth - 1, -beta, -alpha);
		} else {
			eval = -static_eval(k_new);
		}
		/* uȂƂvƂ]l𒴂c */
		if(eval > alpha) {
			/* őPƂđIA]lXV */
			alpha = eval;
			te_sel = i_te;
			/* uXvƂ]l𒴂c */
			if(alpha >= beta) {
				break; /*  */
			}
		}
		/* vOXo[is */
		if(progress) {
			progress->pos++;
		}
	}

	/* őPi[ */
	if(best_te) {
		*best_te = te_list[te_sel];
	}

	/* őP̕]lԂ
	 * ASĂ̒̕]lȉÂ܂ܕԂ
	 * ̕]loȂꍇłԂ_uFail-Softvł͖Aʏ̃@ɂ͉eȂ
	 * uFail-Softvǂ́ANull window searchgNegascout@Au\gMTD(f)@ɉe
	 */
	return alpha;
}

/*--------------------------------------------------------------------------*/

void
get_best_te(const KYOKUMEN* kyokumen, TE* best_te, PROGRESS* progress)
{
	/* @ōőPT
	 * ڂ͑łĂʒuĒTɎԂ̂ŁAڂ̂ݐǂݖƂ
	 */
	alpha_beta(kyokumen, best_te, progress,
		kyokumen->junme ? sakiyomi : 0,
		EVAL_MIN, EVAL_MAX);
}

