/*	
 *	clipz80.h
 *
 *	P/ECE Z80 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_Z80_H__
#define __CLIP_Z80_H__

/****************************************************************************
 *
 ****************************************************************************/

/* Z80_ASMV{`ǂݍ݂܂B
 * Z80_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipz80a.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define Z80_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef Z80_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef Z80_ASM
#undef Z80_TRACE
#endif /*Z80_ASM*/ 

#ifdef Z80_TRACE
#define Z80TRACE	TRACE
#else /*Z80_TRACE*/
#define Z80TRACE	1 ? ((void)0) : TRACE
#endif /*Z80_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _Z80 Z80;

/*
 *	Z80RAO֐̌^`
 */
typedef unsigned char Z80READPROC (Z80* z80, unsigned short addr);
typedef          void Z80WRITEPROC(Z80* z80, unsigned short addr, unsigned char data);
typedef unsigned char Z80INPROC   (Z80* z80, unsigned short addr);
typedef          void Z80OUTPROC  (Z80* z80, unsigned short addr, unsigned char data);

/*
 *	Z80RA
 */
/*typedef*/ struct _Z80 {
	/*===== WX^ =====*/
	unsigned short af;		/* + 0, 2 */
	unsigned short bc;		/* + 2, 2 */
	unsigned short de;		/* + 4, 2 */
	unsigned short hl;		/* + 6, 2 */
	//
	unsigned short af2;		/* + 8, 2 */
	unsigned short bc2;		/* +10, 2 */
	unsigned short de2;		/* +12, 2 */
	unsigned short hl2;		/* +14, 2 */
	//
	unsigned short ix;		/* +16, 2 */
	unsigned short iy;		/* +18, 2 */
	unsigned short sp;		/* +20, 2 */
	unsigned short pc;		/* +22, 2 */
	//
	unsigned char r;		/* +24, 1 */
	unsigned char i;		/* +25, 1 */
	unsigned char _resv1[6];	/* +26, 6 */
	/*=====  =====*/
	unsigned char iff1;		/* +32, 1 */
	unsigned char iff2;		/* +33, 1 */
	unsigned char im;		/* +34, 1 */
	unsigned char halt;		/* +35, 1 */
	int cycle;			/* +36, 4 */
	/*{{2005/01/07 INTvۗΉ̂߂ɒǉ*/
	unsigned char pending;		/* +40, 1 INTvۗ (0:/1:L) */
	unsigned char pending_no;	/* +41, 1 ۗĂINTv̔ԍ */
	/*}}2005/01/07 INTvۗΉ̂߂ɒǉ*/
	unsigned char _resv2[6];	/* +42, 6 */
	/*===== O֐ =====*/
	Z80READPROC* read;		/* +48, 4 */
	Z80WRITEPROC* write;		/* +52, 4 */
	Z80INPROC* in;			/* +56, 4 */
	Z80OUTPROC* out;		/* +60, 4 */
} /*Z80*/;				/* =64    */

/*
 *	CXgNV֐錾
 */
typedef                void Z80OPPROC (Z80* z80, unsigned char code, unsigned char arg1, unsigned char arg2);
#define Z80FN_(OP, FN) void z80op_##FN(Z80* z80, unsigned char code, unsigned char arg1, unsigned char arg2);	/* 錾p */
#include "z80/list.h" /* [z80.xls]List!C10 */
Z80FN_("CB"   , CB   )
Z80FN_("ED"   , ED   )
Z80FN_("DD"   , DD   )
Z80FN_("FD"   , FD   )
Z80FN_("DDCB" , DDCB )
Z80FN_("FDCB" , FDCB )
Z80FN_("ERROR", ERROR)
#undef  Z80FN_
#define Z80FN_(OP, FN) void z80op_##FN(Z80* z80, unsigned char code, unsigned char arg1, unsigned char arg2)	/* `p */

/*
 *	IyR[h}bvEj[jbNe[u
 */
typedef struct _Z80OP {
	Z80OPPROC* proc;	/* + 0, 4 */
	unsigned char argc;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 z80_op_name_table[]̕ւ̃ItZbgł */
} Z80OP;			/* = 8    */
#define Z80OP_(CODE, PROC, ARGC, CYCLE, NAME)	{ z80op_##PROC, 0x##ARGC, 0x##CYCLE, 0x##NAME },
extern const Z80OP z80_op_table[256/*XX*/];		/* XX */
extern const Z80OP z80_op_table_CB[256/*XX*/];		/* CB XX */
extern const Z80OP z80_op_table_ED[256/*XX*/];		/* ED XX */
extern const Z80OP z80_op_table_DD[256/*XX*/];		/* DD XX */
extern const Z80OP z80_op_table_FD[256/*XX*/];		/* FD XX */
extern const Z80OP z80_op_table_DDCB[256/*XX*/];	/* DD CB ?? XX */
extern const Z80OP z80_op_table_FDCB[256/*XX*/];	/* FD CB ?? XX */
extern const char z80_op_name_table[];			/* j[jbNe[u */

/****************************************************************************
 *	֐
 ****************************************************************************/

/* Z80Zbgɐݒ肳AZ80RÃCREAD/WRITEEI/O IN/OUT̊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char z80_internal_read (Z80* z80, unsigned short addr);
         void z80_internal_write(Z80* z80, unsigned short addr, unsigned char data);
unsigned char z80_internal_in   (Z80* z80, unsigned short addr);
         void z80_internal_out  (Z80* z80, unsigned short addr, unsigned char data);

/* * ۗĂINTvA}XJu荞݂Ă犄荞݂s܂B
 *   IFF1܂PENDINGA01֕ω\̂鏈sɁAKĂяoĂB
 * * EI߂IFF1(0or1)1֕ω܂AƂĕۗINTv܂!!
 *   {EIRETI}Ƃߕт́ARETIɂĕۗINTv܂B(Z80̎dl...ԂBvmF)
 *   荞݃[`̖{EIRETI}ł͂Ȃ{EIRET}ƂȂĂAۗINTv͎󂯕t܂B
 *   ݂ۗ̕INTv͒PɖāAɐVINTvsꂽɂ炽߂Ċ荞݂s܂B
 *   ڂ́AEIRETI̎QƂĂB
 */
void z80_check_pending(Z80* z80);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* Z80Zbg܂B
 * [in]
 *	z80		Z80\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 *	in		I/O         READ O֐ (NULL:RA֐gp)
 *	out		I/O         WRITEO֐ (NULL:RA֐gp)
 * [note]
 *	* read,write,in,outNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EREAD	Z80\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  EWRITE	Z80\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 *	  EIN		-1Ԃ܂B
 *	  EOUT		܂B
 */
void z80_reset(Z80* z80, Z80READPROC* read, Z80WRITEPROC* write, Z80INPROC* in, Z80OUTPROC* out);

/* Z80s܂B
 * [in]
 *	z80		Z80\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂HALT܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAz80->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇA  z80->cycle=-5 ƂȂ܂B
 *	  ܂A cycle=100 ŌĂяoA10 TCNs HALT ꍇ́Az80->cycle=90 ƂȂ܂B
 */
void z80_run(Z80* z80, int cycle);

/* }XN\荞݃NGXg𔭍s܂B
 * [in]
 *	z80		Z80\́B
 *	no		荞݃[hɂĈӖقȂ܂B
 *			[h0: RST XXH ߂̃IyR[hw肵܂B
 *			[h1: Ӗ܂B
 *			[h2: 荞݃xN^̉ʃoCgw肵܂B
 * [note]
 *	// * 荞݂֎~ĂA荞݃NGXg͖܂B
 *	//   荞݃NGXg͕ۗ܂B
 *	// 2005/01/07 INTvۗΉ
 *	* 荞݂֎~ĂA荞݃NGXg͕ۗ܂B
 *	  荞݂ꂽƂɁA荞݂s܂B
 */
void z80_int(Z80* z80, unsigned char no);

/* }XNs荞݃NGXg𔭍s܂B
 * [in]
 *	z80		Z80\́B
 */
void z80_nmi(Z80* z80);

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	z80		Z80\́B
 */
void z80_dump(Z80* z80);

#ifdef PIECE
/* Z80s܂B(X^bNؑցE)
 * [in]
 *	z80		Z80\́B
 *	cycle		sTCNB
 * [note]
 *	* z80_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- z80_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  z80_run2()̓X^bN0x1000ɈڂAz80_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAz80_run2()̎gpɂ͏܂B
 *	  Ez80_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Ez80_run()Ă΂O֐(READ/WRITE/IN/OUT)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Ez80_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAz80_run2()̎gpɂ͏[ȒӂKvłB
 *	  z80_run()gꍇɊrׂāAz80_run2()gꍇ̌ʂ́A()̍ƂȂ܂B
 */
void z80_run2(Z80* z80, int cycle);
#endif /*PIECE*/

#endif /*__CLIP_Z80_H__*/
