/*	
 *	clipwin.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2002 Naoyuki Sawa
 *
 *	* Wed Apr 24 09:26:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Jun  2 20:07:00 JST 2002 Naoyuki Sawa
 *	- pceLCDDrawObject()clipdobj.cɕB
 */
#include "clip.h"

static PIECE_VRAM* lcdbuff; /* `E]ƂȂ鉼z */

PIECE_VRAM*
pceLCDSetBuffer(PIECE_VRAM* vram)
{
	PIECE_VRAM* old;

	/* ȑỎzʂޔ܂B */
	old = lcdbuff;

	/* Vzʂݒ肵܂B */
	if(vram != INVALIDPTR) lcdbuff = vram;

	/* ȑỎzʂԂ܂B */
	return old;
}


void
pceLCDTrans(HDC dc, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, const RGBQUAD* palette)
{
	int i;
	struct {
		BITMAPINFOHEADER bi;
		RGBQUAD rgb[256];
	} bmi;
	BITMAPINFOHEADER* bi = &bmi.bi;
	RGBQUAD* rgb = bmi.rgb;

	/* DIBdl: 4oCg(=4sNZ)PʂłȂ΂܂B */
	ASSERT((lcdbuff->w & 3) == 0);

	/* ]DIB쐬܂B */
	memset(bi, 0, sizeof(BITMAPINFOHEADER));
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = lcdbuff->w;
	bi->biHeight = -lcdbuff->h; /* gbv_E */
	bi->biPlanes = 1;
	bi->biBitCount = 8;
	if(palette != NULL) {
		memcpy(rgb, palette, sizeof(RGBQUAD) * 256);
	} else {
		for(i = 0; i < 256; i++) {
			rgb[i].rgbRed   =
			rgb[i].rgbGreen =
			rgb[i].rgbBlue  = (unsigned char)(85 * (3 - (i & 3)));
		}
	}

	/* DIB]܂B */
	if(sw == 0) sw = lcdbuff->w;
	if(sh == 0) sh = lcdbuff->h;
	StretchDIBits(dc,
		dx, dy, dw, dh,
		sx, sy, sw, sh,
		lcdbuff->buf, (BITMAPINFO*)&bmi, DIB_RGB_COLORS, SRCCOPY);
}

void
pceLCDSetObject(DRAW_OBJECT* obj, PIECE_BMP* src, int dx, int dy, int sx, int sy, int w, int h, int param)
{
	/* ]̐ݒB */
	obj->dest = lcdbuff;
	obj->dx   = dx;
	obj->dy   = dy;
	obj->dw   = w;
	obj->dh   = h;

	/* ]̐ݒB */
	obj->src  = src;
	obj->sx   = sx;
	obj->sy   = sy;

	/* NbsO̐ݒB */
	obj->clip.left   = 0;
	obj->clip.top    = 0;
	obj->clip.right  = lcdbuff->w;
	obj->clip.bottom = lcdbuff->h;

	/* ̑̐ݒB */
	obj->param = param;
	obj->type  = 0;
}

/* pceLCDDrawObject̃R[h𗬗p܂B
 * pceLCDDrawObjectT|[gȂ@\(1rbg摜Ȃ)gƁA
 * DIE()ŏI܂B
 */
#define DISP_X			(DIE(), 0)
#define DISP_Y			(DIE(), 0)
#define pceLCDSetBuffer(a)	(DIE(), 0)
#define pceVectorSetKs(a, b)	(DIE(), 0)
#include "clipdobj.c"
int
pceLCDDrawObject(DRAW_OBJECT obj)
{
	return new_LCDDrawObject(obj);
}

/* hook_LCDDrawObject/unhook_LCDDrawObjectgpx} */
#pragma warning(disable: 4505)
