/*	
 *	clipmisc.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Dec 12 21:51:29 JST 2001 Naoyuki Sawa
 *	- 쐬JnB
 *	* Thu May 30 22:41:27 JST 2002 Naoyuki Sawa
 *	- die()̏I{^ASTARTSELECTɕύXB
 *	* Sun Jan 26 19:33:00 JST 2003 Naoyuki Sawa
 *	- die()֐̐錾__attribute__((noreturn))ǉ̂ŁA
 *	  x}̂߁Adie()֐̍Ōexit(1)ǉB
 *	  :__attribute__((...))͊֐錾̂ݎw\łB
 *	       ֐Ɏw肷ƃRpCG[ƂȂ܂B
 *	* Sun May 4 18:05:00 JST 2003 Naoyuki Sawa
 *	- fpk_size()/fpk_load()ǉ܂B
 *	  ȑOAzip`̃T|[gǉɁAfpk`̃T|[g͍폜̂łA
 *	  󂫃eʂNzipWJpobt@(32K)Ȃ悤ȏꍇ
 *	  ͂fpk`gƂ̂ŁAfpk`̃T|[gĎ܂B
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- g[Xo(TRACE_ON/TRACE/trace())ǉ܂B
 *	* Wed Sep 15 06:36:00 JST 2004 Naoyuki Sawa
 *	- RpCoÔ߁ARND8/16,RND8/16_RANGE}N֐܂B
 *	  ߋ̃\[X̌݊̂߁A֐Ăяo}N`Ă܂B
 *	* Tue Dec 13 04:26:00 JST 2005 Naoyuki Sawa
 *	- die()̕svpceLCDDispStop()Ăяo폜܂B
 *	* Mon Dec 26 01:25:00 JST 2005 Naoyuki Sawa
 *	- RNV֘A̎Aclipmisc.cclipcoll.c֕܂B
 *	- C^[tFCX֘A̎Aclipmisc.cclipintf.c֕܂B
 *	* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
 *	- 32bit[֐(rnd32())ǉ܂B
 *	  32bit^ASYƂāAuXorshift RNGsv̗p܂B(ȉAXorshift@ƌĂԂƂɂ܂)
 *	  Xorshift@̎Auclip\keep\Xorshift RNGs.zipvɕۑ܂B
 *	- Xorshift@ɂ32bit[֐(rnd32())V݂ƂɔA8bit[`@Xorshift@ɕύX܂B
 *	  `@ɖ肪L킯ł͂܂񂪁AŜ̓̂߂ƁAXorshift@̕ǂ[(?)ƎvłB
 *	- Xorshift@ɂ32bit[֐(rnd32())V݂ƂɔA16bit[`@Xorshift@ɕύX܂B
 *	  `@ɖ肪L킯ł͂܂񂪁AŜ̓̂߂ƁAXorshift@̕ǂ[(?)ƎvłB
 *	* Tue Oct 03 01:05:53 JST 2006 Naoyuki Sawa
 *	- ĂяoKw̏ȂfobOu[NuDebugBreak()vu__asm int 3vɕύX܂B
 *	  2006/10/3݂́AĂяoKw̏ȂG[_CAO̔ՂD悵āA
 *	  uDebugBreak()vłu__asm int 3vłȂuabort()v̗pĂ̂łA
 *	  ̂߂̊oƂāARgƂĎcĂƂɂ܂B
 *	* Thu Aug 13 17:02:32 JST 2009 Naoyuki Sawa
 *	- [eBeBF̃ZNVǉ܂B
 *	- quick_search()ǉ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	ėp}NE֐
 *****************************************************************************/

//int
//rnd8(int* seed)
//{
//	/* 8rbg(wZ80}V`̏x) */
//	*seed = *seed * 5 + 0x3711;
//	return (*seed >> 8) & 0xff;
//}
//* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
//- Xorshift@ɂ32bit[֐(rnd32())V݂ƂɔA8bit[`@Xorshift@ɕύX܂B
//  `@ɖ肪L킯ł͂܂񂪁AŜ̓̂߂ƁAXorshift@̕ǂ[(?)ƎvłB
int
rnd8(int* seed)
{
	/* 32bit[l̒8bitA8bit[lƂĕԂ܂B
	 * - 傫ȃrbg̋[lAȃrbg̋[loꍇA
	 *   ŏʂŉʂoAoǂƂĂ܂B
	 *
	 *	++++-++++-++++-++++-++++-++++-++++-++++-< rnd32()
	 *	|||| |||| |||| |||| |||| |||| |||| ||||
	 *	1111 1111 1111 1111 0000 0000 0000 0000
	 *	fedc ba98 7654 3210 fedc ba98 7654 3210
	 *	               |||| ||||
	 *	               ++++-++++----------------> rnd8()
	 */
	return (unsigned char)(rnd32(seed) >> ((32 - 8) / 2));
}

//int
//rnd16(int* seed)
//{
//	/* 16rbg(VisualC++ 6.0 \VC98\CRT\SRC\RAND.C Qlɂ܂) */
//	*seed = *seed * 214013 + 2531011;
//	return (*seed >> 16) & 0xffff;
//}
//* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
//- Xorshift@ɂ32bit[֐(rnd32())V݂ƂɔA16bit[`@Xorshift@ɕύX܂B
//  `@ɖ肪L킯ł͂܂񂪁AŜ̓̂߂ƁAXorshift@̕ǂ[(?)ƎvłB
int
rnd16(int* seed)
{
	/* 32bit[l̒16bitA16bit[lƂĕԂ܂B
	 * - 傫ȃrbg̋[lAȃrbg̋[loꍇA
	 *   ŏʂŉʂoAoǂƂĂ܂B
	 *
	 *	++++-++++-++++-++++-++++-++++-++++-++++-< rnd32()
	 *	|||| |||| |||| |||| |||| |||| |||| ||||
	 *	1111 1111 1111 1111 0000 0000 0000 0000
	 *	fedc ba98 7654 3210 fedc ba98 7654 3210
	 *	          |||| |||| |||| ||||
	 *	          ++++-++++-++++-++++-----------> rnd16()
	 */
	return (unsigned short)(rnd32(seed) >> ((32 - 16) / 2));
}

/* * Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
 * - 32bit[֐(rnd32())ǉ܂B
 *   32bit^ASYƂāAuXorshift RNGsv̗p܂B(ȉAXorshift@ƌĂԂƂɂ܂)
 *   Xorshift@̎Auclip\keep\Xorshift RNGs.zipvɕۑ܂B
 * - rnd16()֐ŗpĂ`@̂܂܎gA16bitEVtgɂ̂܂32bit[ƂĕԂ@\łA
 *   ̕@ł́A/݂ɐĂ܂ƓAǂȂ[łƔf̂ŁAXorshift@gƂɂ܂B
 */
int
rnd32(int* seed)
{
#define MAGIC_NUMBER 2463534242u /* 0ȊOȂΉł */

	/* O̗lo܂B
	 * - ȉ̃VtgŹAZpVtgłȂ_VtgōsKv̂ŁAlƂĎo܂B
	 *   ֐C^[tFCX(seed)́Ap̎gՂlāAtlւ̃|C^ƂĂ܂B
	 */
	unsigned y = *seed;

	/* O̗l0Ȃ΁A0ȊO̓KȒlɒu܂B
	 * - Xorshift@̗́AMn񗐐ɐiĂāA0𐶐ł܂B
	 *   32rbg𐶐ꍇÁu2^32vłȂu(2^32)-1vłB
	 *   Ȃ킿A0x00000000`0xFFFFFFFF͈̗̔͂𐶐̂ł͂ȂA0x00000001`0xFFFFFFFF͈̗̔͂𐶐܂B
	 *   0܂߂ɂ́A̓KȈʒuɁAI0ޕKv܂B
	 * - MAGIC_NUMBER̒lɈӖ͖A0ȊO̒lȂΉł\܂B
	 *   Xorshift@̌T̃TvR[hA܂܏V[hlƂāu2463534242vgĂ̂ŁAɂȂ񂾂łB
	 *   V[hlA0ȊOȂΉłǂAXorshift@̌T̃TvR[hɂĂAu2463534242vɈӖ͂܂B
	 * - {֐́AXorshift@̌T̃TvR[hɎāA0ɂΉĂ̂ŁAV[hlƂ0w肷邱Ƃ\łB
	 *   MAGIC_NUMBERɂ́A0w肷邱Ƃ͕słB
	 */
	if(y == 0) y = MAGIC_NUMBER;

	/* Xorshift@gāAO̗lA̗l𐶐܂B
	 * - Vtg[13,17,5]̑gݍ킹́AXorshift@̌T̃TvR[hQlɂ܂B
	 *   Xorshift@̌Tɂ́AȊOɂAlXȃVtg̑gݍ킹ڂĂ܂B
	 */
	y ^= (y << 13);
	y ^= (y >> 17);
	y ^= (y <<  5);

	/* ̗l̒lɂȂȂOɁAI0݂܂B
	 * - Xorshift@0𐶐łȂ̂ŁA̓KȈʒuɁAI0ޕKv܂B
	 *   q̃RgQƂĂB
	 */
	if(y == MAGIC_NUMBER) y = 0;

	/* ̗lA̗V[hƂĊi[܂B
	 * - ֐̖߂lł闐lƊi[闐V[h͓lȂ̂ŁAseed𖳂Ƃ\łA
	 *   Ƃ΁Aȉ̂悤ȌĂяołƕ֗Ȃ̂ŁAseed݂Ă܂B
	 *
	 *	retval = rnd32(&seed) % 100; // 0`99̗l𐶐
	 *
	 *   ܂AA^ɗpASYύXA߂lƗV[hłȂȂꍇɂΉł܂B
	 *   ۂɍA^ASYA`@Xorshift@ɕύX킯łA֐C^[tFCXɕῶ܂B
	 * - rnd32()̖߂l(int)Ȃ̂ŁA0x00000000`0xFFFFFFFFł͂ȂA-0x80000000`0x7FFFFFFFƂȂ܂B
	 *   rnd8()̖߂l0x00`0xFFł邱ƂArnd16()̖߂l0x0000`0xFFFFł邱ƂɊrׂƁAѐɌ܂B
	 *   łĂ̎dlƂŔArnd8()rnd16()߂l(int)łArnd32()߂ľ^ς̂łB
	 *   0x00000000`0xFFFFFFFF̗lKvȂ΁AĂяoɂĖ߂l(unsigned)ɃLXgĂB
	 *   I(unsigned)ւ̃LXgvAڂŔȂ(unsigned)lɗ^e̓`dASƍl܂B
	 */
	return (*seed = y);

#undef MAGIC_NUMBER
}

int
rnd8_range(int* seed, int a, int b)
{
	return rnd8(seed) % (b - a) + a;
}

int
rnd16_range(int* seed, int a, int b)
{
	return rnd16(seed) % (b - a) + a;
}

int
rnd32_range(int* seed, int a, int b)
{
	return (unsigned)rnd32(seed) % (unsigned)(b - a) + a;
	//     ~~~~~~~~~~Kv!!~~~~~~~~~~
}

void
shuffle(void* base, int num, int width, int* seed)
{
	int i;
	int c;
	int i_dst;
	int i_src;
	unsigned char* p_dst;
	unsigned char* p_src;

	///* 0vf̔z͕słB܂A
	// * ݂̎16bit𗘗pĂ邽߁A65536vf߂̔zɂ͖ΉłB
	// */
	//if((num < 0) || (num > (1<<16))) {
	//	DIE();
	//}
	//2006/07/06 num͈̔͌폜܂B
	// * Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
	// - rnd32()̐V݂ɔA16bit32bit𗘗p悤ύX܂B
	//   ̕ύXɂA65536vfȏ̔zVbtłȂȂ܂B
	//   (num < 0)͈݂̐܂AȂ̂ŁAȗ邱Ƃɂ܂B

	/* 擪vfŏIvf܂ŏԂ... */
	p_dst = base;
	for(i_dst = 0; i_dst < num; i_dst++) {

		/* ̗vf肵܂B */
		//i_src = RND16_RANGE(*seed, i_dst, num);
		//* Thu Jul 06 11:48:53 JST 2006 Naoyuki Sawa
		//- rnd32()̐V݂ɔA16bit32bit𗘗p悤ύX܂B
		//  ̕ύXɂA65536vfȏ̔zVbtłȂȂ܂B
		i_src = RND32_RANGE(*seed, i_dst, num);
		p_src = (unsigned char*)base + width * i_src;

		/* 1oCgÂ܂B */
		for(i = 0; i < width; i++) {
			c = *p_dst;
			    *p_dst = *p_src;
			             *p_src = c;
			p_dst++;
			p_src++;
		}
	}
}

/*****************************************************************************
 *	G[
 *****************************************************************************/

#ifdef PIECE
/* void die(const char* fmt, ...) __attribute__((noreturn)) */
asm("
	.code
	.align	1
	.global	die
die:
	; as33AZúA`V{externƌȂ̂ŁA
	; Iextern錾͕Kv܂B(_def_vbuff̂)
	;//xcall pceLCDDispStop		; pceLCDDispStop(); {{2005/12/13 Naoyuki Sawa svȂ̂ō폜܂}}
	xld.w %r12, _def_vbuff		; pceLCDSetBuffer(_def_vbuff);
	xcall pceLCDSetBuffer
	xcall pceLCDDispStart		; pceLCDDispStart();
	xld.w %r12, 0			; pceFontSetType(0);
	xcall pceFontSetType
	xld.w %r12, 3			; pceFontSetTxColor(3);
	xcall pceFontSetTxColor
	xld.w %r12, 0			; pceFontSetBkColor(0);
	xcall pceFontSetBkColor
	xld.w %r12, 0			; pceFontSetPos(0, 0);
	xld.w %r13, 0
	xcall pceFontSetPos
	xld.w %r4, die_L10		; pceFontPrintf(fmt, ...);
	xld.w [%sp], %r4
	xjp pceFontPrintf
die_L10:
	xcall pceLCDTrans		; pceLCDTrans();
die_L20:				; for(;;) {
	xcall yield			;	yield();
	xcall pcePadGet			;	if(pcePadGet() & TRG_SELECT) {
	xand %r10, %r10, 0x4000		;
	xjreq die_L30			;
	xld.w %r12, 1			;		pceAppReqExit(1);
	xcall pceAppReqExit		;
die_L30:				;	}
	xjp die_L20			; }
");
#else /*PIECE*/
/* * __declspec(noreturn)́A.ht@C̊֐錾ɕt邾ŗǂ悤łB
 *   .ct@C̊֐`ɂ́AtĂȂĂ݂łB()
 *   GCC__attribute__((noreturn))A֐`ɂ͕tłȂƂɍ킹āA
 *   __declspec(noreturn)A֐`ɂ͕tȂƂɂ܂B
 * * GCĆA__attribute__((noreturn))t֐AďԂꍇA
 *   RpCɌx\܂B
 *   Visual C++́A__declspec(noreturn)t֐AďԂĂA
 *   RpCɌx\Ȃ̂ŁAӂKvłB
 */
/*__declspec(noreturn)*/ void
die(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
#if 1
	abort(); /* DebugBreak()G[_CAOՂł */
#else
	//DebugBreak(); /* abort()ĂяoKwȂčς݂܂ */
	//* Tue Oct 03 01:05:53 JST 2006 Naoyuki Sawa
	//- ĂяoKw̏ȂfobOu[NuDebugBreak()vu__asm int 3vɕύX܂B
	//  2006/10/3݂́AĂяoKw̏ȂG[_CAO̔ՂD悵āA
	//  uDebugBreak()vłu__asm int 3vłȂuabort()v̗pĂ̂łA
	//  ̂߂̊oƂāARgƂĎcĂƂɂ܂B
	__asm int 3; /* DebugBreak()ɌĂяoKwȂčς݂܂ */
#endif
}
#endif /*PIECE*/

/*****************************************************************************
 *	g[Xo
 *****************************************************************************/

void
trace(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
}

/*****************************************************************************
 *	[eBeBFCӒpPbgL[
 *****************************************************************************/

QUEUE*
create_queue(int capacity)
{
	QUEUE* queue;

	if(capacity < 0) {
		DIE();
	}

	/* pPbgTCYi[psizeof(int)ZāAۂ̃Xg[WTCYƂ܂B
	 * őŁAcapacityoCg̃pPbgAL[Ɋi[ł悤ɂ邽߂łB
	 */
	capacity += sizeof(int);

	/* wb_ƃXg[W̃mۂ܂B */
	queue = malloc(sizeof(QUEUE) + capacity);
	if(!queue) {
		DIE(); /* s */
	}

	/* wb_܂B */
	queue->capacity = capacity;
	queue->size = 0;

	return queue;
}

void
delete_queue(QUEUE* queue)
{
	/* wb_ƃXg[W̃J܂B */
	free(queue);
}

void
clear_queue(QUEUE* queue)
{
	queue->size = 0;
}

int
write_queue(QUEUE* queue, const void* packet/*[length]*/, int length)
{
	unsigned char* storage = (unsigned char*)(queue + 1);

	if(length < 0) {
		DIE();
	}

	/* pPbgTCYƃpPbgf[^ǉ󂫗eʂ邩H */
	if((int)(queue->size + (sizeof(int) + length)) > queue->capacity) {
		return -1;
	}

	/* L[̖ɃpPbgTCYƃpPbgf[^ǉ܂B */
	PUT_LEWORD(storage + queue->size, length);
	memcpy(storage + queue->size + sizeof(int), packet, length);
	queue->size += (sizeof(int) + length);

	return length;
}

int
read_queue(QUEUE* queue, void* packet/*[maxlength]*/, int maxlength)
{
	unsigned char* storage = (unsigned char*)(queue + 1);
	int length;

	if(maxlength < 0) {
		DIE();
	}

	/* L[łȂH */
	if(!queue->size) {
		return -1;
	}

	/* L[̐擪̃pPbgTCY擾܂B */
	if(queue->size < sizeof(int)) {
		DIE(); /* L[jH */
	}
	length = LEWORD(storage);
	if((length < 0) || ((int)(sizeof(int) + length) > queue->size)) {
		DIE(); /* L[jH */
	}

	/* w肳ꂽ̈Ɋi[ł邩H */
	if(length > maxlength) {
		return -1;
	}

	/* L[̐擪̃pPbgAw肳ꂽ̈ɃRs[܂B
	 * Apacket=NULLȂ΁AǂݏopPbgf[^j܂B
	 */
	if(packet) {
		memcpy(packet, storage + sizeof(int), length);
	}

	/* L[̐擪̃pPbg폜A̕AL[l߂܂B */
	queue->size -= (sizeof(int) + length);
	memmove(storage, storage + (sizeof(int) + length), queue->size);

	return length;
}

const void*
peek_queue(QUEUE* queue, int* _length)
{
	unsigned char* storage = (unsigned char*)(queue + 1);
	int length;

	/* L[󂩁H */
	if(!queue->size) {
		return NULL;
	}

	/* L[̐擪̃pPbgTCY擾܂B */
	if(queue->size < sizeof(int)) {
		DIE(); /* L[jH */
	}
	length = LEWORD(storage);
	if((length < 0) || ((int)(sizeof(int) + length) > queue->size)) {
		DIE(); /* L[jH */
	}

	/* pPbgTCYi[܂B */
	if(_length) {
		*_length = length;
	}

	/* pPbgf[^̐擪AhXԂ܂B */
	return storage + sizeof(int);
}

int
queue_space(QUEUE* queue)
{
	int space = queue->capacity - queue->size - sizeof(int);
	if(space < 0) {
		space = 0;
	}
	return space;
}

/*****************************************************************************
 *	[eBeBFOobt@
 *****************************************************************************/

BUFFER*
create_buffer(int capacity)
{
	BUFFER* buffer;

	if(capacity < 0) {
		DIE();
	}

	/* wb_ƃXg[W̃mۂ܂B */
	buffer = malloc(sizeof(BUFFER) + capacity);
	if(!buffer) {
		DIE(); /* s */
	}

	/* wb_܂B */
	buffer->capacity = capacity;
	buffer->size = 0;

	return buffer;
}

void
delete_buffer(BUFFER* buffer)
{
	/* wb_ƃXg[W̃J܂B */
	free(buffer);
}

void
clear_buffer(BUFFER* buffer)
{
	buffer->size = 0;
}

int
write_buffer(BUFFER* buffer, const void* data/*[length]*/, int length)
{
	unsigned char* storage = (unsigned char*)(buffer + 1);

	if(length < 0) {
		DIE();
	}

	/* ރf[^AXg[W̋󂫗eʂ֐؂l߂܂B */
	if(length > (buffer->capacity - buffer->size)) {
		length = (buffer->capacity - buffer->size);
	}

	/* Xg[WցAf[^݂܂B */
	memcpy(storage + buffer->size, data, length);
	buffer->size += length;

	/* ۂɏ񂾃f[^Ԃ܂B */
	return length;
}

int
read_buffer(BUFFER* buffer, void* data/*[maxlength]*/, int maxlength)
{
	unsigned char* storage = (unsigned char*)(buffer + 1);
	int length;

	if(maxlength < 0) {
		DIE();
	}

	/* ǂݏof[^Aw肳ꂽ̈TCY֐؂l߂܂B */
	length = maxlength < buffer->size
	       ? maxlength : buffer->size;

	/* Xg[W擪̃f[^Aw肳ꂽ̈ɃRs[܂B
	 * Adata=NULLȂ΁Aǂݏof[^j܂B
	 */
	if(data) {
		memcpy(data, storage, length);
	}

	/* Xg[W擪̃f[^폜A̕AXg[Wl߂܂B */
	buffer->size -= length;
	memmove(storage, storage + length, buffer->size);

	/* ۂɓǂݏof[^Ԃ܂B */
	return length;
}

const void*
peek_buffer(BUFFER* buffer, int* length)
{
	/* f[^i[܂B */
	if(length) {
		*length = buffer->size;
	}

	/* Xg[W̐擪AhXԂ܂B */
	return buffer + 1;
}

int
buffer_space(BUFFER* buffer)
{
	/* ݉\ȍőf[^́AXg[W̋󂫗eʂłB */
	return buffer->capacity - buffer->size;
}

/*****************************************************************************
 *	[eBeBF_uNXg
 *****************************************************************************/

void
InitializeListHead(LIST_ENTRY* ListHead)
{
	ListHead->Flink = ListHead->Blink = ListHead;
}

int
IsListEmpty(LIST_ENTRY* ListHead)
{
	return ListHead->Flink == ListHead;
}

LIST_ENTRY*
RemoveHeadList(LIST_ENTRY* ListHead)
{
	LIST_ENTRY* Head = ListHead->Flink;
	RemoveEntryList(Head);
	return Head;
}

LIST_ENTRY*
RemoveTailList(LIST_ENTRY* ListHead)
{
	LIST_ENTRY* Tail = ListHead->Blink;
	RemoveEntryList(Tail);
	return Tail;
}

void
RemoveEntryList(LIST_ENTRY* Entry)
{
	LIST_ENTRY* Flink = Entry->Flink;
	LIST_ENTRY* Blink = Entry->Blink;
	Blink->Flink = Flink;
	Flink->Blink = Blink;
}

void
InsertHeadList(LIST_ENTRY* ListHead, LIST_ENTRY* Entry)
{
	LIST_ENTRY* Head = ListHead->Flink;
	Entry->Flink = Head;
	Entry->Blink = ListHead;
	ListHead->Flink = Head->Blink = Entry;
}

void
InsertTailList(LIST_ENTRY* ListHead, LIST_ENTRY* Entry)
{
	LIST_ENTRY* Tail = ListHead->Blink;
	Entry->Flink = ListHead;
	Entry->Blink = Tail;
	Tail->Flink = ListHead->Blink = Entry;
}

/*****************************************************************************
 *	[eBeBF
 *****************************************************************************/

#ifndef PIECE
void*
quick_search(const void* _mem1/*[len1]*/, int len1, const void* _mem2/*[len2]*/, int len2)
{
	int tbl[256]; /* X^bN1KB܂ */
	unsigned char* mem1 = (unsigned char*)_mem1;
	unsigned char* mem2 = (unsigned char*)_mem2;
	unsigned char* tmp1;
	unsigned char* tmp2;
	unsigned char* lim1;
	int i;

	/* p^[́Af[^擪Ɉv */
	if(!len2) {
		return mem1;
	}

	/* f[^̔ŕAőAhX߂ */
	len1 -= len2;
	if(len1 < 0) {
		return NULL;
	}
	lim1 = mem1 + len1; /* = mem1+(len1-len2) */

	/* XLbve[u */
	i = 0;
	do {
		tbl[i] = -1;
	} while(++i < 256);
	i = 0;
	do {
		tbl[mem2[i]] = i;
	} while(++i < len2);

	/* [v */
	do {
		/*{{memcmp(mem1,mem2,len2)*/
		tmp1 = mem1;
		tmp2 = mem2;
		i = len2;
		while(*tmp1++ == *tmp2++) {
			if(!--i) {
				return mem1;
			}
		}
		/*}}memcmp(mem1,mem2,len2)*/

		/* r̎̕QƂāAr̈ʒu炷 */
		if(mem1 == lim1) { /* mem1̖+1ւ̃ANZXh~ */
			break;
		}
		mem1 += len2;
		mem1 -= tbl[*mem1];
	} while(mem1 <= lim1);

	return NULL;
}
#else /*PIECE*/
void* quick_search(const void* _mem1/*[len1]*/, int len1, const void* _mem2/*[len2]*/, int len2);
asm("
		.code
		.align		1
		.global		quick_search
quick_search:
		xsub		%sp, %sp, 1024			;// %sp  := tbl
		ld.w		%r4, %sp			;// %r4  := tbl
		;//---------------------------------------------;//
		cmp		%r15, 0				;// if(!len2)
		jreq		quick_search_RET0		;//   return NULL
		;//---------------------------------------------;//
		sub		%r13, %r15			;// %r13 := len1 -= len2
		jrlt		quick_search_RET0		;// if(len1 < 0) return NULL
		add		%r13, %r12			;// %r13 := lim1 = mem1 + len1
		;//---------------------------------------------;//
		ld.w		%r5, %sp			;// %r5  := ptr = tbl
		ld.w		%r6, -1				;// %r6  := -1
		xld.w		%r7, 256			;// %r7  := cnt = 256
		 ld.w		[%r5]+, %r6			;// do { *ptr++ = -1
		 sub		%r7, 1				;//      %r7  := cnt--
		jrne		-2				;// } while(cnt)
		;//---------------------------------------------;//
		ld.w		%r5, %r14			;// %r5  := ptr = mem2
		ld.w		%r6, 0				;// %r6  := i = 0
		 ld.ub		%r7, [%r5]+			;// do { %r7  :=      *ptr++
		 sla		%r7, 2				;//      %r7  :=      *ptr++ * sizeof(int)
		 add		%r7, %r4			;//      %r7  := &tbl[*ptr++]
		 ld.w		[%r7], %r6			;//               tbl[*ptr++] = i
		 add		%r6, 1				;//      %r6  := i++
		 cmp		%r6, %r15			;//
		jrne		-6				;// } while(i != len2)
		;//---------------------------------------------;//
quick_search_LOOP:						;// do {
		ld.w		%r5, %r12			;//   %r5  := tmp1 = mem1
		ld.w		%r6, %r14			;//   %r6  := tmp2 = mem2
		ld.w		%r7, %r15			;//   %r7  := i    = len2
		 ld.ub		%r10, [%r5]+			;//   do { %r10 := *tmp1++
		 ld.ub		%r11, [%r6]+			;//        %r11 := *tmp2++
		 cmp		%r10, %r11			;//        if(*tmp1++ != *tmp2++)
		 jrne		quick_search_NEXT		;//          goto NEXT
		 sub		%r7, 1				;//        %r7  := i--
		jrne		-5				;//   } while(i)
		jp.d		quick_search_RET		;//   return mem1
		ld.w		%r10, %r12			;//   %r10 := mem1				*delay*
quick_search_NEXT:						;//
		cmp		%r12, %r13			;//   if(mem1 == lim1)
		jreq		quick_search_RET0		;//     return NULL
		add		%r12, %r15			;//   %r12 :=              mem1 += len2
		ld.ub		%r5, [%r12]			;//   %r5  :=             *mem1
		sla		%r5, 2				;//   %r5  :=             *mem1 * sizeof(int)	!INTERLOCK!
		add		%r5, %r4			;//   %r5  :=        &tbl[*mem1]
		ld.w		%r5, [%r5]			;//   %r5  :=         tbl[*mem1]
		sub		%r12, %r5			;//   %r12 := mem1 -= tbl[*mem1]		!INTERLOCK!
		cmp		%r12, %r13			;//
		jrle		quick_search_LOOP		;// } while(mem1 <= lim1)
		;//---------------------------------------------;//
quick_search_RET0:
		ld.w		%r10, 0
quick_search_RET:
		xadd		%sp, %sp, 1024
		ret
");
#endif /*PIECE*/

