/*
 *	clipadp.c
 *
 *	2-bit ADPCM Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Wed Dec 20 00:13:10 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Dec 20 17:31:02 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Mar 01 01:53:43 JST 2007 Naoyuki Sawa
 *	- adpcm_stat()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	[Jϐ
 ****************************************************************************/

static ADPCMDRIVER driver;

/****************************************************************************
 *	[J֐
 ****************************************************************************/

static int
adpcm_stream_callback(short wbuff[/*ADPCMBUFLEN*/], int param/*NOUSE*/)
{
	static int mixbuf[ADPCMBUFLEN]; /* ~LVOobt@Ars`shbłI */
	//
	int i;

	/* ~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* e`lɂ... */
	for(i = 0; i < driver.nch; i++) {
		/* ĐȂ... */
		if(driver.pch[i].loop) {
			/* `l̏o͂A~LVOobt@֍܂B */
			adpcm_mix1(&driver.pch[i], mixbuf);
		}
	}

	/* ~LVOobt@NbsOāAo̓obt@֏݂܂B */
	adpcm_mix2(wbuff, mixbuf);

	return 0;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
adpcm_init(int nch)
{
	/* mɖԂɂ܂B */
	adpcm_exit();

	/* `l\̂mۂ܂B */
	driver.nch = nch;
	driver.pch = calloc(nch, sizeof(ADPCMCHANNEL));
	if(!driver.pch) {
		DIE(); /* s */
	}

	/* Xg[ĐJn܂B
	 * - X^bN̎gppxȂ̂ŁAX^bNؑւgȂƂɂ܂B
	 *   ۂ̃AvP[VŎĂ݂āAǂ炪f\łB
	 * 2006/12/21ǋL
	 * - \ǂAX^bNؑւgȂł邱ƂmF܂B
	 */
	stream_play(ADPCMBUFLEN, adpcm_stream_callback, 0/*NOUSE*/, 0/*X^bN؊gȂ*/);
}

void
adpcm_exit()
{
	/* mɃXg[Đ~܂B */
	stream_stop();

	/* mɃ`l\̂܂B */
	free(driver.pch/*NULLOK*/);
	memset(&driver, 0, sizeof driver); /*Kv!!*/
}

void
adpcm_play(int ch, const void* data, int loop)
{
	ADPCMCHANNEL* pch;
	const PCEWAVEINFO* pwi;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	if(memcmp(data, "MCPP", 4) != 0) {
		DIE(); /* VOl`s */
	}
	pwi = (const PCEWAVEINFO*)((const unsigned char*)data + 4/*VOl`*/ + 4/*TCY*/);
	if((pwi->type & 3) != PW_TYPE_2BITADPCM) {
		DIE(); /* 2bit-ADPCMłȂ */
	}

	pch->loop = 0;
	/*{{̊ԂŊ荞݂ĂA~`lƌȂ̂ňSł*/
	pch->pcm      = 0;
	pch->data     = 0;
	pch->delta    = 16;
	pch->progress = 0;
	pch->rate     = pwi->resv;
	pch->len      = pwi->len;
	pch->ptr      = (const unsigned char*)(pwi + 1); /* "pwi->pData"ł͂܂!! */
	pch->init_len = pch->len;
	pch->init_ptr = pch->ptr;
	/*}}̊ԂŊ荞݂ĂA~`lƌȂ̂ňSł*/
	pch->loop = loop;
}

void
adpcm_stop(int ch)
{
	ADPCMCHANNEL* pch;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	pch->loop = 0; /* 1[h݂̏Ȃ̂ŁA荞݋֎~͕svł */
}

int
adpcm_stat(int ch)
{
	ADPCMCHANNEL* pch;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	return pch->loop; /* 1[h̓ǂݏoȂ̂ŁA荞݋֎~͕svł */
}

