/*
 *	main.c
 *
 *	Vvo[V
 *
 *	* Sun Aug 28 18:46:02 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_CHR
#define CHR_ CHR_INIT2
const CHR chr_tbl[] = {
#include "chr.h"
};
#undef CHR_
#endif /*USE_CHR*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	smain
 ****************************************************************************/

void
smain()
{
	/* B */
	app_init();

	/* C[vB */
	for(;;) {
		if(demo_main() < 0) break;
		game_main();
	}

	/* N[AbvB
	 * START+SELECTŏIꍇ̓N[Abv͍s܂B
	 */
	app_exit();
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

void
app_init()
{
#ifdef USE_MUSIC
	/* hFǂݍ݂܂B */
	{
		int retval;
		thread_lock();
		retval = loadInst();
		thread_unlock();
		if(retval != 0) {
			grcls(3);
			symbol(4, 34, "drum.arcǂݍݎsł", 0, 0);
			symbol(4, 44, "h͍Đ܂", 0, 0);
			wait(3000);
			grcls(-1);
		}
	}
#endif /*USE_MUSIC*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

	/* \ݒB */
	dispmode(1,	/* 1:XvCg\/0:\ */
		 1,	/* 1:eLXg\/0:\ */
		 1,	/* 1:OtBbN\/0:\ */
		 0,	/* 1:eLXgO/0:w */
		 0);	/* wiF(wʕ\Ȃ̂) */
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
}

/****************************************************************************
 *	schedule
 ****************************************************************************/

void
schedule()
{
	static unsigned prev;
	       unsigned cur;
	int joy_old, trg;

#ifdef USE_PAUSE
	{
		int pause = 0;
		for(;;) {
#endif /*USE_PAUSE */

			/* [VSYNC҂B */
			if(prev == 0) prev = msec();
			do {
				cur = msec();
			} while((cur - prev) * FPS < 1000); /* (cur-prev)<(1000/FPS)̕ό` */
			prev = cur;

			/* pbhԎ擾B
			 * - VvCuł́AgK̔ōsKv܂B
			 */
			joy_old = joy;
			joy = pad() & 0x00ff;
			trg = (joy ^ joy_old) & joy;
			joy |= trg << 8;

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause; /* PAUSEԐ؂ւ */
				if(!pause) pausedisp(0);
			}
			if(!pause) break;

			/* PAUSEbZ[W_ŕ\B */
			if(msec() % 1000 < 750) {
				pausedisp(1);
			} else {
				pausedisp(0);
			}
		}
	}
#endif /*USE_PAUSE */

#ifdef QUICK_REPEAT
	/* I[gs[gB */
	{
		static unsigned char rep[8]; /* I[gs[gJE^ */
		int i, mask;
		for(i = 0; i < 8; i++) {
			mask = 1 << i; /* PAD_* */
			if(QUICK_REPEAT_PADS & mask) {
				if(joy & mask) {
					if(rep[i] != 0xff) rep[i]++;
					if(rep[i] >= QUICK_REPEAT_DELAY) joy |= mask << 8; /* TRG_* */
				} else {
					rep[i] = 0;
				}
			}
		}
	}
#endif QUICK_REPEAT

	now++;	/* O[o^C}XV */
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void
delay(int frame)
{
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	萔
 ****************************************************************************/
#define CELL_COLS		5					//Z̗񐔁B
#define CELL_ROWS		(7+1)					//Z̍sBŉsɐ΂L΃Q[I[o[ɂȂB
/*--------------------------------------------------------------------------*/
#define CLOUD_L_X		20					//̉_̍[̃XvCgWB(CXW̎n_ł)
#define CLOUD_R_X		((DISP_X-20)-1)				//Ẻ_̉E[̃XvCgWB(CXW̏I_ł)
/*--------------------------------------------------------------------------*/
#define LINE_Y			(((CELL_ROWS-1)*8)-1)			//CYWB
#define PLAYER_Y		(CELL_ROWS*8-2)				//vC[̏[̃XvCgWB
#define MAGAZINE_Y		(PLAYER_Y+10)				//eq̏[̃XvCgWB
#define MAGAZINE_H		5					//eq̒eꔭ̍B
/*--------------------------------------------------------------------------*/
#define ROAD_X			((((DISP_X/8)-CELL_COLS)*8)/2)		//̍[̃XvCgWB
#define OBJ_SHADOW_L		0
#define OBJ_SHADOW_R		12
#define OBJ_MAGAZINE_3		24
#define OBJ_MAGAZINE_2		25
#define OBJ_MAGAZINE_1		26
#define OBJ_PLAYER		27
#define OBJ_SIGHT		31
#define OBJ_SHOT		32
#define OBJ_CLOUD_L		33
#define OBJ_CLOUD_R		45
#define OBJ_SCORE_1000		57
#define OBJ_SCORE_100		58
#define OBJ_SCORE_10		59
#define OBJ_SCORE_1		60
//#define OBJ_			61
//#define OBJ_			62
//#define OBJ_			63
/****************************************************************************
 *	\
 ****************************************************************************/
//ST_Cell.flag
#define FLAG_SHOT		(1<<0)
#define FLAG_ERASE		(1<<1)
/*--------------------------------------------------------------------------*/
//ST_Cell.stat
#define STAT_ERASE		1	//
/*--------------------------------------------------------------------------*/
//ST_Cell.disc
#define DISC_B			1
#define DISC_W			2
/*--------------------------------------------------------------------------*/
typedef struct _ST_Cell {
	unsigned char		flag;					//tO			0,,FLAG_*̑gݍ킹
	unsigned char		stat;					//				0,,STAT_*
	unsigned char		disc;					//				0,,DISC_*
	unsigned char		anim;					//Aj[VJE^	ėp
	//
	unsigned char		trigger_id;
} ST_Cell;
/*--------------------------------------------------------------------------*/
typedef struct _ST_Game {
	int			score;					//XRA
	//
	short			player_col;				//vC[
	short			player_x;				//vC[̕\XW
	//
	short			magazine_disc[3];			//eq̒e̐F			DISC_*
	short			magazine_x[3];				//eq̒e̕\XW
	short			magazine_ofs;				//eq̒e̕\YItZbg	MAGAZINE_H...0
	//
	short			shot_disc;				//Vbg̒e̐F		0=,,DISC_*
	short			shot_col;				//Vbg
	short			shot_row;				//Vbgs
	//
	short			cell_spd;				//Z̑x			(sNZ/t[)<<8
	short			cell_ofs;				//Z̕\YItZbg		((8)76543210)<<8
	ST_Cell			cell[CELL_ROWS][CELL_COLS];
	//
	short			cloud_y;
	//
	unsigned char		trigger_id_r;
	unsigned char		trigger_id_w;
} ST_Game;
static ST_Game stGame;
/****************************************************************************
 *	
 ****************************************************************************/
extern const unsigned char SE1[];
extern const unsigned char SE2[];
extern const unsigned char SE3[];
extern const unsigned char SE4[];
extern /*const*/ unsigned char BGM[];
/*--------------------------------------------------------------------------*/
//ŃAj[V
static const unsigned char TBL_Erase[][2]={
	{CHR_E_DISC_B	,CHR_E_DISC_W	},
	{CHR_E_DISC_B1	,CHR_E_DISC_W1	},
	{CHR_E_DISC_B2	,CHR_E_DISC_W2	},
	{CHR_E_DISC_B3	,CHR_E_DISC_W3	},
	{CHR_E_DISC_W	,CHR_E_DISC_B	},
	{CHR_E_ERASE_W1	,CHR_E_ERASE_B1	},
	{CHR_E_ERASE_W2	,CHR_E_ERASE_B2	},
	{CHR_E_ERASE_W3	,CHR_E_ERASE_B3	},
	{CHR_E_ERASE_W3	,CHR_E_ERASE_B3	},
	{CHR_E_ERASE_W4	,CHR_E_ERASE_B4	},
	{CHR_E_ERASE_W4	,CHR_E_ERASE_B4	},
	{CHR_E_ROAD	,CHR_E_ROAD	},
};
/****************************************************************************
 *	
 ****************************************************************************/
static int chdispno(int obj, int x, int y, int chrno);
static void bgdispno(int x, int y, int chrno);
static void game_init();
static void player_exec();
static void player_draw();
static void sight_exec();
static void sight_draw();
static void magazine_exec();
static void magazine_draw();
static void shot_exec();
static void shot_draw();
static void cloud_exec();
static void cloud_draw();
static int cell_exec();
static void cell_draw();
static void score_draw();
/****************************************************************************
 *	
 ****************************************************************************/
//Lԍw肵ăXvCg\B
static int chdispno(int obj, int x, int y, int chrno) {
	if((unsigned)chrno >= (unsigned)ARRAY_SIZE(chr_tbl)) { DIE(); }
	return chdisp(obj, x, y, &chr_tbl[chrno]);
}
#define chdisp(obj,x,y,chr)	DIE()	//Ԉchdisp()gɌoՂ悤ɃG[~B
/*--------------------------------------------------------------------------*/
//Lԍw肵BG\B
static void bgdispno(int x, int y, int chrno) {
	if((unsigned)chrno >= (unsigned)ARRAY_SIZE(chr_tbl)) { DIE(); }
	bgdisp(x, y, &chr_tbl[chrno]);
}
#define bgdisp(x,y,chr)		DIE()	//Ԉbgdisp()gɌoՂ悤ɃG[~B
/*--------------------------------------------------------------------------*/
//xϓɏo邽߂̊֐B
static int rnd_disc(const short aDisc[/*nDisc*/], int nDisc) {
	if(nDisc) {
		int i = rnd(nDisc);
		switch(aDisc[i]) {
		default:DIE();
		case DISC_B: return DISC_W;
		case DISC_W: return DISC_B;
		}
	}
	return rnd(2) ? DISC_B : DISC_W;
}
/*--------------------------------------------------------------------------*/
//Q[B
static void game_init() {
	//B
	{
		srand(pceTimerGetCount());
	}
	//\̂B
	{
		int i;
		memset(&stGame, 0, sizeof stGame);
		stGame.player_col = CELL_COLS / 2;
		stGame.player_x = stGame.player_col * 8;
		for(i = 0; i < 3; i++) {
			stGame.magazine_disc[i] = rnd_disc(stGame.magazine_disc, i);
			stGame.magazine_x[i] = stGame.player_x;
		}
		stGame.cell_spd = (1<<4);	//x	
	}
	//ʂB
	{
		//XvCg
		{
			spcls(0);
		}
		//BG
		{
			int x, y, chrno;
			bgcls();
			for(y = 0; y < BG_CY; y++) {
				for(x = 0; x < BG_CX; x++) {
					chrno = CHR_NULL;
					switch(x) {
					case BG_CX-1-2:		chrno = CHR_DIRT;	break;		//_[g
					case BG_CX-1-1:		chrno = CHR_DIRT;	break;		//
					case BG_CX-1-0:		chrno = CHR_CURB_L;	break;		//
					case 0:			chrno = CHR_E_ROAD;	break;		//
					case 1:			chrno = CHR_O_ROAD;	break;		//
					case 2:			chrno = CHR_E_ROAD;	break;		//
					case 3:			chrno = CHR_O_ROAD;	break;		//
					case 4:			chrno = CHR_E_ROAD;	break;		//
					case 4+1+0:		chrno = CHR_CURB_R;	break;		//
					case 4+1+1:		chrno = CHR_DIRT;	break;		//
					case 4+1+2:		chrno = CHR_DIRT;	break;		//_[g
					}
					bgdispno(x, y, chrno);
				}
			}
		}
		//OtBbN
		{
			grcls(-1);
			line(CLOUD_L_X, LINE_Y, CLOUD_R_X, LINE_Y, 2);
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//vC[̎sB
static void player_exec() {
	int x, dx;
//{{Ǐ]悤ɁAtŒǏ]sɂ܂B
	//vC[̕\XẂAvC[Ǐ]B
	x = stGame.player_col * 8;
	if(stGame.player_x >= x) {
		dx = stGame.player_x - x;
		dx = (dx * 2) / 3;
		stGame.player_x = x + dx;
	} else {
		dx = x - stGame.player_x;
		dx = (dx * 2) / 3;
		stGame.player_x = x - dx;
	}
	//E{^ꂽAvC[̈ړsB
	if((joy & TRG_LF) && (stGame.player_col > 0)) {
		stGame.player_col--;
	}
	if((joy & TRG_RI) && (stGame.player_col < CELL_COLS - 1)) {
		stGame.player_col++;
	}
//}}Ǐ]悤ɁAtŒǏ]sɂ܂B
	//A{^,,B{^ꂽc
	if(joy & TRG_AB) {
		//VbgoĂÃ݂Vbge܂ŎsB
		while(stGame.shot_disc) { shot_exec(); }
		//̗񂪈tłȂ΁c
		if(!stGame.cell[CELL_ROWS - 1][stGame.player_col].disc) {
			//VbgoB
			stGame.shot_disc = stGame.magazine_disc[0];
			stGame.shot_col = stGame.player_col;
			stGame.shot_row = CELL_ROWS - 1;
			ppdplay(SE2);
			//̒e𑕓UB
			stGame.magazine_disc[0] = stGame.magazine_disc[1];
			stGame.magazine_disc[1] = stGame.magazine_disc[2];
			stGame.magazine_disc[2] = rnd_disc(stGame.magazine_disc, 2);
			stGame.magazine_ofs = MAGAZINE_H;
		}
	}
}
/*--------------------------------------------------------------------------*/
//vC[̕`揈sB
static void player_draw() {
	int obj, x, y, chrno;
	//vC[
	obj = OBJ_PLAYER;
	x = ROAD_X + stGame.player_x;
	y = PLAYER_Y;
	chrno = CHR_PLAYER;
	chdispno(obj, x, y, chrno);
}
/****************************************************************************
 *	
 ****************************************************************************/
//Ə̎sB
static void sight_exec() {
	/** no job **/
}
/*--------------------------------------------------------------------------*/
//Ə̕`揈sB
static void sight_draw() {
	int obj, x, y, chrno;
	ST_Cell* cell;
	//VbgoȂ΁c
	if(!stGame.shot_disc) {
		//ԉɗL΂̍s߂B(y=-1ɂȂB)
		for(y = CELL_ROWS - 1; y >= 0; y--) {
			cell = &stGame.cell[y][stGame.player_col];
			if(cell->disc) { break; }
		}
		//ԉ̍sɐ΂΁c
		if(y < (CELL_ROWS - 1)) {
			//̍sցB
			y++;
			//sNZW߂B
			x = ROAD_X + stGame.player_col * 8;
			y = (y * 8) - (stGame.cell_ofs>>8);
			//Ə`B
			obj = OBJ_SIGHT;
			switch(stGame.magazine_disc[0]) {
			default:DIE();
			case DISC_B: chrno = CHR_SIGHT_B; break;
			case DISC_W: chrno = CHR_SIGHT_W; break;
			}
			chdispno(obj, x, y, chrno);
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//eq̎sB
static void magazine_exec() {
	int x, dx;
//{{Ǐ]悤ɁAtŒǏ]sɂ܂B
	//eq̒e3̕\XẂAeq̒e2̕\XWǏ]B
	x = stGame.magazine_x[1];
	if(stGame.magazine_x[2] >= x) {
		dx = stGame.magazine_x[2] - x;
		dx = (dx * 2) / 3;
		stGame.magazine_x[2] = x + dx;
	} else {
		dx = x - stGame.magazine_x[2];
		dx = (dx * 2) / 3;
		stGame.magazine_x[2] = x - dx;
	}
	//eq̒e2̕\XẂAeq̒e1̕\XWǏ]B
	x = stGame.magazine_x[0];
	if(stGame.magazine_x[1] >= x) {
		dx = stGame.magazine_x[1] - x;
		dx = (dx * 2) / 3;
		stGame.magazine_x[1] = x + dx;
	} else {
		dx = x - stGame.magazine_x[1];
		dx = (dx * 2) / 3;
		stGame.magazine_x[1] = x - dx;
	}
	//eq̒e1̕\XẂAvC[̕\XWǏ]B
	x = stGame.player_x;
	if(stGame.magazine_x[0] >= x) {
		dx = stGame.magazine_x[0] - x;
		dx = (dx * 2) / 3;
		stGame.magazine_x[0] = x + dx;
	} else {
		dx = x - stGame.magazine_x[0];
		dx = (dx * 2) / 3;
		stGame.magazine_x[0] = x - dx;
	}
//}}Ǐ]悤ɁAtŒǏ]sɂ܂B
	//eq̒e̕\YItZbg炷B
	stGame.magazine_ofs = (stGame.magazine_ofs * 2) / 3;
}
/*--------------------------------------------------------------------------*/
//eq̕`揈sB
static void magazine_draw() {
	int obj, x, y, chrno;
	//eq̒e1
	obj = OBJ_MAGAZINE_1;
	x = ROAD_X + stGame.magazine_x[0];
	y = MAGAZINE_Y + (MAGAZINE_H * 0) + stGame.magazine_ofs;
	switch(stGame.magazine_disc[0]) {
	default:DIE();
	case DISC_B: chrno = CHR_SHOT_B; break;
	case DISC_W: chrno = CHR_SHOT_W; break;
	}
	chdispno(obj, x, y, chrno);
	//eq̒e2
	obj = OBJ_MAGAZINE_2;
	x = ROAD_X + stGame.magazine_x[1];
	y = MAGAZINE_Y + (MAGAZINE_H * 1) + stGame.magazine_ofs;
	switch(stGame.magazine_disc[1]) {
	default:DIE();
	case DISC_B: chrno = CHR_SHOT_B; break;
	case DISC_W: chrno = CHR_SHOT_W; break;
	}
	chdispno(obj, x, y, chrno);
	//eq̒e3
	obj = OBJ_MAGAZINE_3;
	x = ROAD_X + stGame.magazine_x[2];
	y = MAGAZINE_Y + (MAGAZINE_H * 2) + stGame.magazine_ofs;
	switch(stGame.magazine_disc[2]) {
	default:DIE();
	case DISC_B: chrno = CHR_SHOT_B; break;
	case DISC_W: chrno = CHR_SHOT_W; break;
	}
	chdispno(obj, x, y, chrno);
}
/****************************************************************************
 *	
 ****************************************************************************/
//Vbg̎sB
static void shot_exec() {
	int y;
	//VbgoĂc
	if(stGame.shot_disc) {
		//VbgړB
		stGame.shot_row--;
		//Vbg̍s̈ɐ΂L邩Aԏ̍s܂ňړA~B
		for(y = CELL_ROWS - 2; y >= 0; y--) {	//y=(CELL_ROWS-2)`-1
			ST_Cell* cell = &stGame.cell[y][stGame.shot_col];
			if(cell->disc) { break; }
		}
		y++;					//y=(CELL_ROWS-1)` 0
		if((unsigned)y >= CELL_ROWS) { DIE(); }	//oO
		if(stGame.shot_row <= y) {
			ST_Cell* cell = &stGame.cell[y][stGame.shot_col];
			memset(cell, 0, sizeof(ST_Cell));
			cell->disc = stGame.shot_disc;
			cell->flag = FLAG_SHOT;
			cell->trigger_id = stGame.trigger_id_w++;
			//Vbg𖢏oɖ߂B
			stGame.shot_disc = 0;
		}
	}
}
/*--------------------------------------------------------------------------*/
//Vbg̕`揈sB
static void shot_draw() {
	int obj, x, y, chrno;
	//VbgoĂc
	if(stGame.shot_disc) {
		//Vbg`悷B
		obj = OBJ_SHOT;
		x = ROAD_X + (stGame.shot_col * 8);
		y =           stGame.shot_row * 8;
		switch(stGame.shot_disc) {
		default:DIE();
		case DISC_B: chrno = CHR_SHOT_B; break;
		case DISC_W: chrno = CHR_SHOT_W; break;
		}
		chdispno(obj, x, y, chrno);
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//_̎sB
static void cloud_exec() {
	if(++stGame.cloud_y >= (DISP_Y + 24)) {
		stGame.cloud_y = 0;
	}
}
/*--------------------------------------------------------------------------*/
//_̕`揈sB
static void cloud_draw() {
	int obj, x, y, chrno;
	//_
	obj = OBJ_CLOUD_L;
	x = CLOUD_L_X;
	y = stGame.cloud_y;
	if(y >= DISP_Y) { y -= (DISP_Y + 24); }
	chrno = CHR_CLOUD_L;
	chdispno(obj, x, y, chrno);
	//e
	obj = OBJ_SHADOW_L;
	y += 16;
	if(y >= DISP_Y) { y -= (DISP_Y + 24); }
	chrno = CHR_SHADOW_L;
	chdispno(obj, x, y, chrno);
	//E_
	obj = OBJ_CLOUD_R;
	x = CLOUD_R_X;
	y = stGame.cloud_y;
	if(y >= DISP_Y) { y -= (DISP_Y + 24); }
	y += (DISP_Y + 24) / 2;
	if(y >= DISP_Y) { y -= (DISP_Y + 24); }
	chrno = CHR_CLOUD_R;
	chdispno(obj, x, y, chrno);
	//Ee
	obj = OBJ_SHADOW_R;
	y += 16;
	if(y >= DISP_Y) { y -= (DISP_Y + 24); }
	chrno = CHR_SHADOW_R;
	chdispno(obj, x, y, chrno);
}
/****************************************************************************
 *	
 ****************************************************************************/
//Z̏ŌpsB
static int cell_exec_erase() {
	int result = 0;
	int x, y;
	ST_Cell* cell;
	//tB[hŜ𑖍āc
	for(y = 0; y < CELL_ROWS; y++) {
		for(x = 0; x < CELL_COLS; x++) {
			cell = &stGame.cell[y][x];
			//̃ZłȂ΁c
			if(cell->disc) {
				//ŒȂ΁c
				if(cell->stat == STAT_ERASE) {
					if(++cell->anim >= ARRAY_SIZE(TBL_Erase)) {
						memset(cell, 0, sizeof(ST_Cell));
						stGame.score++;
						if(!(stGame.score % 2)) { stGame.cell_spd++; }	//2_ƂɁA(1/256)[sNZ/t[]鎖ɂB	//
					}
					//Œł鎖}[NB
					result = 1;
				}
			}
		}
	}
	return result;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Z̗sB
static int cell_exec_fall() {
	int result = 0;
	int x, y;
	ST_Cell *cell1, *cell2;
	//tB[hŜ𑖍āc
	for(y = 0; y < CELL_ROWS; y++) {
		for(x = 0; x < CELL_COLS; x++) {
			cell1 = &stGame.cell[y][x];
			//̃ZȂ΁c
			if(!cell1->disc) {
				//ԉ̍słȂ΁c
				if(y < (CELL_ROWS - 1)) {
					cell2 = &stGame.cell[y + 1][x];
					//̍słȂ΁c
					if(cell2->disc) {
						//̍s̍sɃRs[B
						*cell1 = *cell2;
						//̍sNAB
						memset(cell2, 0, sizeof(ST_Cell));
						//ł鎖}[NB
						result = 1;
					}
				}
			}
		}
	}
	return result;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Z̏ŊJnsB
static int cell_exec_trigger() {
	static const char TBL_Dir[8][2]={
		{-1,-1},{ 0,-1},{ 1,-1},
		{-1, 0},        { 1, 0},
		{-1, 1},{ 0, 1},{ 1, 1},
	};
	int result = 0;
	int x1, y1, x2, y2, vx, vy, iDir;
	ST_Cell *cell1, *cell2;
	while(stGame.trigger_id_r != stGame.trigger_id_w) {
		int trigger_id = stGame.trigger_id_r++;
		//tB[hŜ𑖍āc
		for(y1 = 0; y1 < CELL_ROWS; y1++) {
			for(x1 = 0; x1 < CELL_COLS; x1++) {
				cell1 = &stGame.cell[y1][x1];
				//~VbgȂ΁c
				if((cell1->flag & FLAG_SHOT) && (cell1->trigger_id == trigger_id)) {
					//̈ʒu8ɂāc
					for(iDir = 0; iDir < 8; iDir++) {
						vx = TBL_Dir[iDir][0];
						vy = TBL_Dir[iDir][1];
						//ڂZi߂B
						x2 = x1 + vx;
						y2 = y1 + vy;
						//ׂ̃ZtB[hȂ΁c
						if(((unsigned)x2 < CELL_COLS) &&
						   ((unsigned)y2 < CELL_ROWS)) {
							//ׂ̃Z擾B
							cell2 = &stGame.cell[y2][x2];
							//ׂ̃Zc
							if(cell2->disc &&			//łȂA
							  (cell2->disc != cell1->disc) &&	//~VbgƈႤFŁA
							 !(cell2->flag & FLAG_SHOT)) {		//~VbgłȂ΁c
								for(;;) {
									//ڂZi߂B
									x2 += vx;
									y2 += vy;
									//ڂZtB[hOɂȂ甲B
									if(((unsigned)x2 >= CELL_COLS) ||
									   ((unsigned)y2 >= CELL_ROWS)) { break; }
									//ڂZ擾B
									cell2 = &stGame.cell[y2][x2];
									//ڂZc
									if(!cell2->disc ||				//󂩁A
									   (cell2->flag & FLAG_SHOT)) { break; }	//~VbgȂ΁A[v𔲂B
									//ڂZc
									if(cell2->disc == cell1->disc) {		//~VbgƓFȂ΁c
										for(;;) {
											//ڂZ߂B
											x2 -= vx;
											y2 -= vy;
											//̈ʒuɖ߂AB
											if((x1 == x2) && (y1 == y2)) { break; }
											//ڂZɁAŃtOZbgB
											cell2 = &stGame.cell[y2][x2];
											cell2->flag |= FLAG_ERASE;
										}
										break;	//܂
									}
								}
							}
						}
					}
				}
			}
		}
		//tB[hŜ𑖍āc
		for(y1 = 0; y1 < CELL_ROWS; y1++) {
			for(x1 = 0; x1 < CELL_COLS; x1++) {
				cell1 = &stGame.cell[y1][x1];
				if(cell1->disc) {
					switch(cell1->flag) {
					default:DIE();
					case 0:
						/** no job **/
						break;
					case FLAG_SHOT:
						if(cell1->trigger_id == trigger_id) {
							cell1->flag &= ~FLAG_SHOT;
						}
						break;
					case FLAG_ERASE:
						cell1->flag &= ~FLAG_ERASE;
						cell1->stat = STAT_ERASE;
						cell1->anim = 0;
						result = 1;
						break;
					}
				}
			}
		}
		if(result) {
			ppdplay(SE3);
			break;
		}
	}
	return result;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Z̐issB
static int cell_exec_move() {
	int x, y, spd;
	ST_Cell* cell;
	//ԉɗL΂̍s߂B(y=-1ɂȂB)
	for(y = CELL_ROWS - 1; y >= 0; y--) {
		for(x = 0; x < CELL_COLS; x++) {
			cell = &stGame.cell[y][x];
			if(cell->disc) { break; }
		}
		if(x < CELL_COLS) { break; }
	}
	//ԉ̍sɐ΂L΁AQ[I[o[B
	if(y == (CELL_ROWS - 1)) { return 1; }
	//݂̐isx擾B
	spd = stGame.cell_spd;
	//ԉ̈̍sɐ΂L΁ȂxɂB
	if(y == (CELL_ROWS - 2)) { spd >>= 1; }
	//{^Ă邩A΂Ȃ΁AɐisB
	//łȂ΁Ȃ݂xŐisB
	if((joy & PAD_DN) || (y < 3/**/)) { spd = max(spd, (1<<8)); }
	//肵xŐisB
	stGame.cell_ofs -= spd;
	//Zi̕~l𒴂Ăԁc
	while(stGame.cell_ofs < 0) {
		stGame.cell_ofs += (8<<8);
		memmove(&stGame.cell[1], &stGame.cell[0], sizeof(ST_Cell) * (CELL_COLS * (CELL_ROWS - 1)));
		for(x = 0; x < CELL_COLS; x++) {
			ST_Cell* cell = &stGame.cell[0][x];
			memset(cell, 0, sizeof(ST_Cell));
			//̗ɏȂFDIɒIďo悤ɂB
			{
				short aDisc[CELL_ROWS - 1];
				int i;
				for(i = 0; i < CELL_ROWS - 1; i++) {
					ST_Cell* cell = &stGame.cell[i + 1][x];
					if(!cell->disc) { break; }
					aDisc[i] = cell->disc;
				}
				cell->disc = rnd_disc(aDisc, i);
			}
		}
	}
	return 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Z̎sB
static int cell_exec() {
	//Z̏ŌpsB
	if(cell_exec_erase()) { return 0; }
	//Z̗sB
	if(cell_exec_fall()) { return 0; }
	//Z̏ŊJnsB
	if(cell_exec_trigger()) { return 0; }
	//Z̐issB
	if(cell_exec_move()) { return 1; }	//Q[I[o[
	return 0;
}
/*--------------------------------------------------------------------------*/
//Z̕`揈sB
static void cell_draw() {
	int x, y, chrno;
	for(y = 0; y < CELL_ROWS; y++) {
		for(x = 0; x < CELL_COLS; x++) {
			ST_Cell* cell = &stGame.cell[y][x];
			chrno = CHR_E_ROAD;
			switch(cell->stat) {
			default:DIE();
			case 0:
				switch(cell->disc) {
				default:DIE();
				case 0:
					/** no job **/
					break;
				case DISC_B:
					chrno = (cell->flag & FLAG_SHOT) ? CHR_E_ROAD_B : CHR_E_DISC_B;
					break;
				case DISC_W:
					chrno = (cell->flag & FLAG_SHOT) ? CHR_E_ROAD_W : CHR_E_DISC_W;
					break;
				}
				break;
			case STAT_ERASE:
				switch(cell->disc) {
				default:DIE();
			//	case 0:		//ZSTAT_ERASEɂȂ鎖͋N蓾Ȃ͂B
				case DISC_B:
					chrno = TBL_Erase[cell->anim][0];
					break;
				case DISC_W:
					chrno = TBL_Erase[cell->anim][1];
					break;
				}
				break;
				break;
			}
			if(x & 1) {
				chrno += (CHR_O_ROAD - CHR_E_ROAD);
			}
			bgdispno(x, y, chrno);
		}
	}
	bghome(-ROAD_X, stGame.cell_ofs>>8);
}
/****************************************************************************
 *	
 ****************************************************************************/
static void score_draw() {
	int obj, x, y, chrno;
	int score = stGame.score;
	if(score > 9999) { score = 9999; }
	//1000̈
	obj = OBJ_SCORE_1000;
	x = 2;
	y = 2;
	chrno = CHR_NUM_0 + ((score / 1000) % 10);
	chdispno(obj, x, y, chrno);
	//100̈
	obj = OBJ_SCORE_100;
	x += 4;
	chrno = CHR_NUM_0 + ((score / 100) % 10);
	chdispno(obj, x, y, chrno);
	//10̈
	obj = OBJ_SCORE_10;
	x += 4;
	chrno = CHR_NUM_0 + ((score / 10) % 10);
	chdispno(obj, x, y, chrno);
	//1̈
	obj = OBJ_SCORE_1;
	x += 4;
	chrno = CHR_NUM_0 + (score % 10);
	chdispno(obj, x, y, chrno);
}
/****************************************************************************
 *	game_main
 ****************************************************************************/
static int game_exec() {
	shot_exec();
	magazine_exec();
	player_exec();
	sight_exec();
	cloud_exec();
	return cell_exec();	//0=p,1=Q[I[o[
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void game_draw() {
    //{{spcls(0)`e`揈̓rŉʍXVȂ悤ɃXbhbNB
	thread_lock();
	//
	spcls(0);
	shot_draw();
	magazine_draw();
	player_draw();
	sight_draw();
	cloud_draw();
	cell_draw();
	score_draw();
	//
	thread_unlock();
    //}}spcls(0)`e`揈̓rŉʍXVȂ悤ɃXbhbNB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void game_main() {
	int i;
	//Q[B
	game_init();
	for(;;) {
		schedule();
		//ZNg{^ꂽAQ[LZă^Cgʂ֖߂B
		if(joy & TRG_SELECT) { return; }
		//Q[̎sB
		if(game_exec()) { break; }	//Q[I[o[
		//Q[̕`揈sB
		game_draw();
	}
	pmdstop();
	ppdplay(SE4);
	//Q[I[o[\ÕEFCg
	for(i = 0; i < SEC(1.0); i++) {
		schedule();
		//ZNg{^ꂽAQ[LZă^Cgʂ֖߂B
		if(joy & TRG_SELECT) { return; }
		//Q[̕`揈sB
		game_draw();
	}
	//Q[I[o[\
	grprintf(4, 5, 0x30, "GAMEOVER");
	//Q[I[o[\̃EFCg
	for(i = 0; i < SEC(10.0); i++) {
		schedule();
		//ZNg{^,,A{^,,B{^ꂽAQ[LZă^Cgʂ֖߂B
		if(joy & (TRG_SELECT|TRG_AB)) { break; }
		//Q[̕`揈sB
		game_draw();
	}
}
/****************************************************************************
 *	demo_main
 ****************************************************************************/
int demo_main() {
	pmdstop();
	//fp\ݒ
	dispmode(1,	/* 1:XvCg\/0:\ */
		 0,	/* 1:eLXg\/0:\ */
		 1,	/* 1:OtBbN\/0:\ */
		 0,	/* 1:eLXgO/0:w */
		 3);	/* wiF(wʕ\Ȃ̂) */
	bgcls();
	spcls(0);
	grcls(-1);
	grprintf(4, 3, 0xF0, "   ");
	grprintf(4, 4, 0xF0, " ް ");
	grprintf(4, 7, 0xF0, "A  START");
	grprintf(4, 8, 0xF0, "SEL EXIT");
	score_draw();
	for(;;) {
		schedule();
		//ZNg{^ꂽAIB
		if(joy & TRG_SELECT) { return -1; }
		//A{^,,B{^ꂽAQ[JnB
		if(joy & TRG_AB) { break; }
	}
	ppdplay(SE1);
	delay(SEC(0.5));
	//Q[p\ݒ
	dispmode(1,	/* 1:XvCg\/0:\ */
		 1,	/* 1:eLXg\/0:\ */
		 1,	/* 1:OtBbN\/0:\ */
		 0,	/* 1:eLXgO/0:w */
		 0);	/* wiF(wʕ\Ȃ̂) */
	pmdplay(BGM);
	return 0;
}
