//-----------------------------------------------------------
// ssbpLib v1.2.3
//
// Copyright(C) Web Technology Corp.
// http://www.webtech.co.jp/
//-----------------------------------------------------------
//
// SS5Player.h
//


/************************************************************
ΉssbptH[}bg̓o[W3łB
Ss5Converter̃tH[}bgo[WSpriteStudioSDKQƂĂB
https://github.com/SpriteStudio/SpriteStudio5-SDK/wiki/%E3%82%B3%E3%83%B3%E3%83%90%E3%83%BC%E3%82%BF%E3%81%AE%E4%BD%BF%E3%81%84%E6%96%B9

- Quick start
 
  #include "SS5Player.h"

  
  // SS5vC[̐錾
  ss::Player *ssplayer;
  ss::ResourceManager *resman;


  //\[X}l[W̍쐬
  resman = ss::ResourceManager::getInstance();
  //vC[̍쐬
  ssplayer = ss::Player::create();

  //Ajf[^\[Xɒǉ
  //ꂼ̃vbgtH[ɍ킹pX֕ύXĂB
  resman->addData("character_template_comipo\\character_template1.ssbp");
  //vC[Ƀ\[X蓖
  ssplayer->setData("character_template1");					// ssbpt@Cigqsvj
  //Đ郂[Vݒ
  ssplayer->play("character_template_3head/stance");		// Aj[Vw(ssae/Aj[V)


  //\ʒuݒ
  ssplayer->setPosition(1280/2, 720);
  //XP[ݒ
  ssplayer->setScale(0.5f, 0.5f);
  //]ݒ
  ssplayer->setRotation(0.0f, 0.0f, 0.0f);
  //xݒ
  ssplayer->setAlpha(255);
  //]ݒ
  ssplayer->setFlip(false, false);


  //C[vŌĂяoĂB
  ssplayer->update(dt);					//vC[̍XV
  ssplayer->draw();						//vC[̕`


  I resmanAplayer  delete ĂB
  //SS5Player̍폜
  delete (ssplayer);
  delete (resman);

  gpAj[Vɍ킹 PlayerNX`ɂݒp萔ύXĂB

  ssbpLib̐ɂĂ͂̃y[WQƂĂB
  https://github.com/SpriteStudio/ssbpLib/wiki

  gp@ɂĂPlayerNX̃RgQƂĂB

*************************************************************/

#ifndef SS5Player_h
#define SS5Player_h

#include "SS5PlayerData.h"
#include "SS5PlayerTypes.h"
#include "SS5PlayerPlatform.h"
#include <map>
#include <vector>
#include <string>
#include <stdarg.h>
#include <assert.h>
#include <time.h>

//GtFNg֘A
#include "./Common/loader/ssloader.h"
#include "./Common/Animator/ssplayer_macro.h"
#include "./Common/Animator/ssplayer_matrix.h"
#include "./Common/Animator/ssplayer_effectfunction.h"
#include "./Common/Animator/ssplayer_cellmap.h"
#include "./Common/Animator/ssplayer_PartState.h"
#include "./Common/Animator/MersenneTwister.h"

#pragma warning(disable : 4996)

//{{2016/04/15ǉ:G[ǉ܂BڍׂssbpLib.h̓̃RgQƂĉB
extern "C" void syslog(int priority, const char* format, ...);
extern "C" __declspec(noreturn) void die(const char* format, ...);
#define SSLOG(...)		syslog(7/*LOG_DEBUG*/,       __VA_ARGS__)
#define SS_ASSERT(cond)		((void)((cond) || (die("%s(%d): %s",     __FILE__, __LINE__, #cond     ), 0)))
#define SS_ASSERT2(cond, msg)	((void)((cond) || (die("%s(%d): %s: %s", __FILE__, __LINE__, #cond, msg), 0)))
#define SSLOGERROR(format,...)	syslog(3/*LOG_ERR*/, format, __VA_ARGS__)
//}}2016/04/15ǉ:G[ǉ܂BڍׂssbpLib.h̓̃RgQƂĉB

namespace ss
{
class CustomSprite;
class CellCache;
class CellRef;
class AnimeCache;
class AnimeRef;
class ResourceSet;
struct ProjectData;
class SSSize;
class Player;

//֐`
extern void get_uv_rotation(float *u, float *v, float cu, float cv, float deg);

/**
* 萔
*/

#define __SSPI__	(3.14159265358979323846f)
#define __SS2PI__	(__SSPI__ * 2)
#define SSRadianToDegree(Radian) ((float)( Radian * __SS2PI__ )/ 360.0f )
#define SSDegreeToRadian(Degree) ((float)( Degree * 360.0f) / __SS2PI__)


#define SS_SAFE_DELETE(p)            do { if(p) { delete (p); (p) = 0; } } while(0)
#define SS_SAFE_DELETE_ARRAY(p)     do { if(p) { delete[] (p); (p) = 0; } } while(0)
#define SS_SAFE_FREE(p)                do { if(p) { free(p); (p) = 0; } } while(0)
#define SS_SAFE_RELEASE(p)            do { if(p) { (p)->release(); } } while(0)
#define SS_SAFE_RELEASE_NULL(p)        do { if(p) { (p)->release(); (p) = 0; } } while(0)
#define SS_SAFE_RETAIN(p)            do { if(p) { (p)->retain(); } } while(0)
#define SS_BREAK_IF(cond)            if(cond) break

//{{2016/04/15폜:G[ǉ܂BڍׂssbpLib.h̓̃RgQƂĉB
//#ifdef _DEBUG
//	#define SSLOG(...)       do {} while (0)
//	#define SS_ASSERT(cond)    assert(cond)
//	#define SS_ASSERT2(cond, msg) SS_ASSERT(cond)
//	#define SSLOGERROR(format,...)  do {} while (0)
//#else
//	#define SSLOG(...)       do {} while (0)
//	#define SS_ASSERT(cond)
//	#define SS_ASSERT2(cond, msg) ((void)(cond))
//	#define SSLOGERROR(format,...)  do {} while (0)
//#endif
//}}2016/04/15폜:G[ǉ܂BڍׂssbpLib.h̓̃RgQƂĉB


/**
* State
p[c̏i[܂BState̓eƂɕ`揈쐬ĂB
*/
struct State
{
	int flags;						/// ̃t[ōXVsXe[^X̃tO
	int cellIndex;					/// p[cɊ蓖ĂꂽZ̔ԍ
	float x;						/// SS5Agr[gFXW
	float y;						/// SS5Agr[gFYW
	float z;						/// SS5Agr[gFZW
	float pivotX;					/// _XItZbg{Zɐݒ肳ꂽ_ItZbgX
	float pivotY;					/// _YItZbg{Zɐݒ肳ꂽ_ItZbgY
	float rotationX;				/// X]ieq֌WvZρj
	float rotationY;				/// Y]ieq֌WvZρj
	float rotationZ;				/// Z]ieq֌WvZρj
	float scaleX;					/// XXP[ieq֌WvZρj
	float scaleY;					/// YXP[ieq֌WvZρj
	int opacity;					/// sxi0`255jieq֌WvZρj
	float size_X;					/// SS5Agr[gFXTCY
	float size_Y;					/// SS5Agr[gFXTCY
	float uv_move_X;				/// SS5Agr[gFUV Xړ
	float uv_move_Y;				/// SS5Agr[gFUV Yړ
	float uv_rotation;				/// SS5Agr[gFUV ]
	float uv_scale_X;				/// SS5Agr[gFUV XXP[
	float uv_scale_Y;				/// SS5Agr[gFUV YXP[
	float boundingRadius;			/// SS5Agr[gF蔼a
	int colorBlendFunc;				/// SS5Agr[gFJ[uh̃uh@
	int colorBlendType;				/// SS5Agr[gFJ[uh̒PF_J[B
	bool flipX;						/// ]ieq֌WvZρj
	bool flipY;						/// c]ieq֌WvZρj
	bool isVisibled;				/// \ieq֌WvZρj
	float instancerotationX;		/// CX^Xp[cɐݒ肳ꂽX]
	float instancerotationY;		/// CX^Xp[cɐݒ肳ꂽY]
	float instancerotationZ;		/// CX^Xp[cɐݒ肳ꂽZ]
	SSV3F_C4B_T2F_Quad quad;		/// _f[^AWAJ[lAUV܂܂i_ό`ATCYXYAUVړXYAUVXP[AUV]A]fρj
	TextuerData texture;			/// ZɑΉeNX`ԍiQ[ŊǗĂԍݒ肷j
	SSRect rect;					/// ZɑΉeNX`̕\̈iJnWAj
	int blendfunc;					/// p[cɐݒ肳ꂽuh@
	float mat[16];					/// p[c̈ʒuZo邽߂̃}gNXieq֌WvZρj

	void init()
	{
		flags = 0;
		cellIndex = 0;
		x = 0.0f;
		y = 0.0f;
		z = 0.0f;
		pivotX = 0.0f;
		pivotY = 0.0f;
		rotationX = 0.0f;
		rotationY = 0.0f;
		rotationZ = 0.0f;
		scaleX = 1.0f;
		scaleY = 1.0f;
		opacity = 255;
		size_X = 1.0f;
		size_Y = 1.0f;
		uv_move_X = 0.0f;
		uv_move_Y = 0.0f;
		uv_rotation = 0.0f;
		uv_scale_X = 1.0f;
		uv_scale_Y = 1.0f;
		boundingRadius = 0.0f;
		colorBlendFunc = 0;
		colorBlendType = 0;
		flipX = false;
		flipY = false;
		isVisibled = false;
		instancerotationX = 0.0f;
		instancerotationY = 0.0f;
		instancerotationZ = 0.0f;
		memset(&quad, 0, sizeof(quad));
		texture.handle = 0;
		texture.size_w = 0;
		texture.size_h = 0;
		rect.size.height = 0;
		rect.size.width = 0;
		rect.origin.x = 0;
		rect.origin.y = 0;
		blendfunc = 0;
		memset(&mat, 0, sizeof(mat));
	}

	State() { init(); }
};

/**
* CustomSprite
*/
class CustomSprite
{
private:
	static unsigned int ssSelectorLocation;
	static unsigned int	ssAlphaLocation;
	static unsigned int	sshasPremultipliedAlpha;

	//	static CCGLProgram* getCustomShaderProgram();

private:
	//	CCGLProgram*	_defaultShaderProgram;
	bool				_useCustomShaderProgram;
	float				_opacity;
	int					_hasPremultipliedAlpha;
	int					_colorBlendFuncNo;
	bool				_flipX;
	bool				_flipY;

public:
	float				_mat[16];
	State				_state;
	bool				_isStateChanged;
	CustomSprite*		_parent;
	Player*				_ssplayer;
	float				_liveFrame;
	SSV3F_C4B_T2F_Quad	_sQuad;

	//GtFNgpp[^
	SsEffectRenderer*	refEffect;
	SsPartState			partState;

	//[VuhpXe[^X
	State				_orgState;


public:
	CustomSprite();
	virtual ~CustomSprite();

	static CustomSprite* create();

	void initState()
	{
		_state.init();
		_isStateChanged = true;
	}

	void setStateValue(float& ref, float value)
	{
		if (ref != value)
		{
			ref = value;
			_isStateChanged = true;
		}
	}

	void setStateValue(int& ref, int value)
	{
		if (ref != value)
		{
			ref = value;
			_isStateChanged = true;
		}
	}

	void setStateValue(bool& ref, bool value)
	{
		if (ref != value)
		{
			ref = value;
			_isStateChanged = true;
		}
	}

	void setStateValue(SSV3F_C4B_T2F_Quad& ref, SSV3F_C4B_T2F_Quad value)
	{
		//		if (ref != value)
		{
			ref = value;
			_isStateChanged = true;
		}
	}

	void setState(const State& state)
	{
		setStateValue(_state.flags, state.flags);
		setStateValue(_state.cellIndex, state.cellIndex);
		setStateValue(_state.x, state.x);
		setStateValue(_state.y, state.y);
		setStateValue(_state.z, state.z);
		setStateValue(_state.pivotX, state.pivotX);
		setStateValue(_state.pivotY, state.pivotY);
		setStateValue(_state.rotationX, state.rotationX);
		setStateValue(_state.rotationY, state.rotationY);
		setStateValue(_state.rotationZ, state.rotationZ);
		setStateValue(_state.scaleX, state.scaleX);
		setStateValue(_state.scaleY, state.scaleY);
		setStateValue(_state.opacity, state.opacity);
		setStateValue(_state.size_X, state.size_X);
		setStateValue(_state.size_Y, state.size_Y);
		setStateValue(_state.uv_move_X, state.uv_move_X);
		setStateValue(_state.uv_move_Y, state.uv_move_Y);
		setStateValue(_state.uv_rotation, state.uv_rotation);
		setStateValue(_state.uv_scale_X, state.uv_scale_X);
		setStateValue(_state.uv_scale_Y, state.uv_scale_Y);
		setStateValue(_state.boundingRadius, state.boundingRadius);
		setStateValue(_state.isVisibled, state.isVisibled);
		setStateValue(_state.flipX, state.flipX);
		setStateValue(_state.flipY, state.flipY);
		setStateValue(_state.blendfunc, state.blendfunc);
		setStateValue(_state.colorBlendFunc, state.colorBlendFunc);
		setStateValue(_state.colorBlendType, state.colorBlendType);

		setStateValue(_state.instancerotationX, state.instancerotationX);
		setStateValue(_state.instancerotationY, state.instancerotationY);
		setStateValue(_state.instancerotationZ, state.instancerotationZ);
		setStateValue(_state.quad, state.quad);
		_state.texture = state.texture;
		_state.rect = state.rect;
		memcpy(&_state.mat, &state.mat, sizeof(_state.mat));
	}


	// override
	virtual void draw(void);
	virtual void setOpacity(unsigned char opacity);

	// original functions
	void changeShaderProgram(bool useCustomShaderProgram);
	bool isCustomShaderProgramEnabled() const;
	void setColorBlendFunc(int colorBlendFuncNo);
	SSV3F_C4B_T2F_Quad& getAttributeRef();

	void setFlippedX(bool flip);
	void setFlippedY(bool flip);
	bool isFlippedX();
	bool isFlippedY();
	void sethasPremultipliedAlpha(int PremultipliedAlpha);

public:
};


/**
 * ResourceManager
 */
//class ResourceManager : public Ref
class ResourceManager
{
public:
	static const std::string s_null;

	/**
	 * ftHgCX^X擾܂.
	 *
	 * @return ftHgResourceManagerCX^X
	 */
	static ResourceManager* getInstance();

	/**
	 * ssbpt@Cǂݍ݊ǗΏۂƂ܂.
	 * dataKeyssbp̃t@CigqȂjɂȂ܂.
	 *
	 * @param  ssbpFilepath  ssbpt@C̃pX
	 * @param  imageBaseDir  摜t@C̓ǂݍ݌[gpX. ȗssbp̂ꏊ[gƂ܂.
	 * @return dataKey
	 */
	std::string addData(const std::string& ssbpFilepath, const std::string& imageBaseDir = s_null);

	/**
	 * ssbpt@Cǂݍ݊ǗΏۂƂ܂.
	 *
	 * @param  dataKey       dataKey̎w
	 * @param  ssbpFilepath  ssbpt@C̃pX
	 * @param  imageBaseDir  摜t@C̓ǂݍ݌[gpX. ȗssbp̂ꏊ[gƂ܂.
	 * @return dataKey
	 */
	std::string addDataWithKey(const std::string& dataKey, const std::string& ssbpFilepath, const std::string& imageBaseDir = s_null);

	/**
	 * w肳ꂽssbpf[^ǗΏۂƂ܂.
	 *
	 * @param  dataKey       dataKey̎w
	 * @param  data          ssbpf[^
	 * @param  imageBaseDir  摜t@C̓ǂݍ݌[gpX. ȗssbp̂ꏊ[gƂ܂.
	 * @return dataKey
	 */
	std::string addData(const std::string& dataKey, const ProjectData* data, const std::string& imageBaseDir = s_null);
	
	/**
	 * wf[^܂.
	 * pXAgqssbpw肵ĂB
	 *
	 * @param  dataKey
	 */
	void removeData(const std::string& dataKey);

	/**
	 * SẴf[^܂.
	 */
	void removeAllData();

	/**
	* OɑΉf[^擾܂.
	*/
	ResourceSet* getData(const std::string& dataKey);

	/**
	* w肵Z̃eNX`ύX܂.
	* @param  ssbpName       ssbpigqt@Cj
	* @param  ssceName       ssceigqt@Cj
	* @param  texture        ύX̃eNX`nh
	* @return ύXs
	*/
	bool changeTexture(char* ssbpName, char* ssceName, long texture);

	/**
	* w肵f[^̃eNX`j܂B
	* @param  dataName       ssbpigqt@Cj
	* @return s
	*/
	bool releseTexture(char* ssbpName);

	/**
	* ǂݍłssbpAj[V̑t[擾܂B
	* @param  ssbpName       ssbpigqt@Cj
	* @param  animeName      ssae/[V
	* @return Aj[V̑t[i݂Ȃꍇ̓AT[gj
	*/
	int getMaxFrame(std::string ssbpName, std::string animeName);

	/**
	 * VResourceManagerCX^X\z܂.
	 *
	 * @return ResourceManagerCX^X
	 */
	static ResourceManager* create();

public:
	ResourceManager(void);
	virtual ~ResourceManager();

protected:
	std::map<std::string, ResourceSet*>	_dataDic;
};



/**
 * UserData
 */
struct UserData
{
	enum {
		FLAG_INTEGER	= 1 << 0,
		FLAG_RECT		= 1 << 1,
		FLAG_POINT		= 1 << 2,
		FLAG_STRING		= 1 << 3
	};

	const char*	partName;		/// Part name
	int			frameNo;		/// Frame no

	int			flags;			/// Flags of valid data
	int			integer;		/// Integer
	int			rect[4];		/// Rectangle Left, Top, Right, Bottom
	int			point[2];		/// Position X, Y
	const char*	str;			/// String (zero terminated)
	int			strSize;		/// String size (byte count)
};


/**
* LabelData
*/
struct LabelData
{
	std::string	str;			/// String (zero terminated)
	int			strSize;		/// String size (byte count)
	int			frameNo;		/// Frame no
};

//CX^Xf[^
struct Instance
{
	int			refStartframe;		//Jnt[
	int			refEndframe;		//It[
	float		refSpeed;			//Đx
	int			refloopNum;			//[v
	bool		infinity;			//[v
	bool		reverse;			//tđI
	bool		pingpong;			//
	bool		independent;		//Ɨ
	void clear(void)
	{
		refStartframe = 0;			//Jnt[
		refEndframe = 1;			//It[
		refSpeed = 1;				//Đx
		refloopNum = 1;				//[v
		infinity = false;			//[v
		reverse = false;			//tđI
		pingpong = false;			//
		independent = false;		//Ɨ
	}
};


/**
* ResluteState
* Q[ɕԂp[cXe[^XB
* KvɉăJX^}CYĂB
*/
struct ResluteState
{
	int flags;						/// ̃t[ōXVsXe[^X̃tO
	int cellIndex;					/// p[cɊ蓖ĂꂽZ̔ԍ
	float x;						/// SS5Agr[gFXW
	float y;						/// SS5Agr[gFYW
	float z;						/// SS5Agr[gFZW
	float pivotX;					/// _XItZbg{Zɐݒ肳ꂽ_ItZbgX
	float pivotY;					/// _YItZbg{Zɐݒ肳ꂽ_ItZbgY
	float rotationX;				/// X]ieq֌WvZρj
	float rotationY;				/// Y]ieq֌WvZρj
	float rotationZ;				/// Z]ieq֌WvZρj
	float scaleX;					/// XXP[ieq֌WvZρj
	float scaleY;					/// YXP[ieq֌WvZρj
	int opacity;					/// sxi0`255jieq֌WvZρj
	float size_X;					/// SS5Agr[gFXTCY
	float size_Y;					/// SS5Agr[gFXTCY
	float uv_move_X;				/// SS5Agr[gFUV Xړ
	float uv_move_Y;				/// SS5Agr[gFUV Yړ
	float uv_rotation;				/// SS5Agr[gFUV ]
	float uv_scale_X;				/// SS5Agr[gFUV XXP[
	float uv_scale_Y;				/// SS5Agr[gFUV YXP[
	float boundingRadius;			/// SS5Agr[gF蔼a
	int colorBlendFunc;				/// SS5Agr[gFJ[uh̃uh@
	int colorBlendType;				/// SS5Agr[gFJ[uh̒PF_J[B
	bool flipX;						/// ]ieq֌WvZρj
	bool flipY;						/// c]ieq֌WvZρj
	bool isVisibled;				/// \ieq֌WvZρj

	int	part_type;					/// p[c
	int	part_boundsType;			/// 蔻
	int	part_alphaBlendType;		/// BlendType
	int	part_labelcolor;			/// xJ[
};

/**
* Đt[Ɋ܂܂p[cf[^̃tO
*/
enum {
	PART_FLAG_INVISIBLE			= 1 << 0,		/// \
	PART_FLAG_FLIP_H			= 1 << 1,		/// ]
	PART_FLAG_FLIP_V			= 1 << 2,		/// c]

	// optional parameter flags
	PART_FLAG_CELL_INDEX		= 1 << 3,		/// Zԍ
	PART_FLAG_POSITION_X		= 1 << 4,		/// XW
	PART_FLAG_POSITION_Y		= 1 << 5,		/// YW
	PART_FLAG_POSITION_Z		= 1 << 6,		/// ZW
	PART_FLAG_PIVOT_X			= 1 << 7,		/// _ItZbgX
	PART_FLAG_PIVOT_Y			= 1 << 8,		/// _ItZbgY
	PART_FLAG_ROTATIONX			= 1 << 9,		/// X]
	PART_FLAG_ROTATIONY			= 1 << 10,		/// Y]
	PART_FLAG_ROTATIONZ			= 1 << 11,		/// Z]
	PART_FLAG_SCALE_X			= 1 << 12,		/// XP[X
	PART_FLAG_SCALE_Y			= 1 << 13,		/// XP[Y
	PART_FLAG_OPACITY			= 1 << 14,		/// sx
	PART_FLAG_COLOR_BLEND		= 1 << 15,		/// J[uh
	PART_FLAG_VERTEX_TRANSFORM	= 1 << 16,		/// _ό`

	PART_FLAG_SIZE_X			= 1 << 17,		/// TCYX
	PART_FLAG_SIZE_Y			= 1 << 18,		/// TCYY

	PART_FLAG_U_MOVE			= 1 << 19,		/// UVړX
	PART_FLAG_V_MOVE			= 1 << 20,		/// UVړY
	PART_FLAG_UV_ROTATION		= 1 << 21,		/// UV]
	PART_FLAG_U_SCALE			= 1 << 22,		/// UVXP[X
	PART_FLAG_V_SCALE			= 1 << 23,		/// UVXP[Y
	PART_FLAG_BOUNDINGRADIUS	= 1 << 24,		/// 蔼a

	PART_FLAG_INSTANCE_KEYFRAME = 1 << 25,		/// CX^X
	PART_FLAG_INSTANCE_START	= 1 << 26,		/// CX^XFJnt[
	PART_FLAG_INSTANCE_END		= 1 << 27,		/// CX^XFIt[
	PART_FLAG_INSTANCE_SPEED	= 1 << 28,		/// CX^XFĐx
	PART_FLAG_INSTANCE_LOOP		= 1 << 29,		/// CX^XF[v
	PART_FLAG_INSTANCE_LOOP_FLG = 1 << 30,		/// CX^XF[vݒ

	NUM_PART_FLAGS
};

/**
* _ό`tO
*/
enum {
	VERTEX_FLAG_LT = 1 << 0,
	VERTEX_FLAG_RT = 1 << 1,
	VERTEX_FLAG_LB = 1 << 2,
	VERTEX_FLAG_RB = 1 << 3,
	VERTEX_FLAG_ONE = 1 << 4	// color blend only
};

/**
* CX^X[vݒtO
*/
enum {
	INSTANCE_LOOP_FLAG_INFINITY = 1 << 0,		//
	INSTANCE_LOOP_FLAG_REVERSE = 1 << 1,
	INSTANCE_LOOP_FLAG_PINGPONG = 1 << 2,
	INSTANCE_LOOP_FLAG_INDEPENDENT = 1 << 3,
};

/**
* Animation Part Type
*/
enum
{
	PARTTYPE_INVALID = -1,
	PARTTYPE_NULL,			/// nullB̈SRT̂݁B~`̓蔻͐ݒ\B
	PARTTYPE_NORMAL,		/// ʏp[cB̈B摜͖ĂB
	PARTTYPE_TEXT,			/// eLXg(\@j
	PARTTYPE_INSTANCE,		/// CX^XBAjAp[cւ̎QƁBV[ҏW[h̑ւɂȂ
	PARTTYPE_EFFECT,		// ss5.5ΉGtFNgp[c
	PARTTYPE_NUM
};

/*
* 蔻̎
*/
enum
{
	INVALID = -1,
	NONE,			///< 蔻ƂĎgȂB
	QUAD,			///< ݂ɕό`lӌ`B_ό`ȂǓKp̂Sp񂾗̈BłdB
	AABB,			///< ]ȂŜ͂ދ`Ō
	CIRCLE,			///< ^~̔aŋɂ蔻肷
	CIRCLE_SMIN,	///< ^~̔aŋɂ蔻肷 (XP[x,y̍ŏlƂj
	CIRCLE_SMAX,	///< ^~̔aŋɂ蔻肷 (XP[x,y̍őlƂj
	num
};

/**
* uh@
*/
enum BlendType
{
	BLEND_MIX,		///< 0 uhi~bNXj
	BLEND_MUL,		///< 1 Z
	BLEND_ADD,		///< 2 Z
	BLEND_SUB		///< 3 Z
};

/*
Common\Loader\sstypes.hɎۂ̒`܂B
/// eNX`bv[h
namespace SsTexWrapMode
{
	enum _enum
	{
		invalid = -1,	/// Ȃ
		clamp,			/// Nv
		repeat,			/// s[g
		mirror,			/// ~[
		num
	};
};

/// eNX`tB^[[h fԕ@
namespace SsTexFilterMode
{
	enum _enum
	{
		invalid = -1,
		nearlest,	///< jAXglCo[
		linear,		///< jAAoCjA
		num
	};
};
*/

#define DOT (10.0f)					/// Œ菭̒萔 10=1hbg

//J[x萔
#define COLORLABELSTR_NONE		""
#define COLORLABELSTR_RED		"Red"
#define COLORLABELSTR_ORANGE	"Orange"
#define COLORLABELSTR_YELLOW	"Yellow"
#define COLORLABELSTR_GREEN		"Green"
#define COLORLABELSTR_BLUE		"Blue"
#define COLORLABELSTR_VIOLET	"Violet"
#define COLORLABELSTR_GRAY		"Gray"
enum
{
	COLORLABEL_NONE,		///< 0 Ȃ
	COLORLABEL_RED,			///< 1 
	COLORLABEL_ORANGE,		///< 2 IW
	COLORLABEL_YELLOW,		///< 3 F
	COLORLABEL_GREEN,		///< 4 
	COLORLABEL_BLUE,		///< 5 
	COLORLABEL_VIOLET,		///< 6 
	COLORLABEL_GRAY,		///< 7 DF
};

//------------------------------------------------------------------------------
//vC[̐ݒ`
//gpAj[Vɍ킹Đݒ肵ĂB


//vC[ňAjɊ܂܂p[c̍ő吔
//傫ȂƃvC[ɕׂ܂B
#define PART_VISIBLE_MAX (512)


// GtFNg@\gpꍇ
// Common/Animator/ssplayer_effect.h
// ɒ`ĂGtFNgNX̊Ǘobt@萔QƂĂB
// GtFNgNX̃obt@ȂꍇAp[eBN\ȂȂ܂B
//#define SSEFFECTRENDER_EMMITER_MAX (128)		//Pp[cǗG~b^[obt@
//#define SSEFFECTRENDER_PARTICLE_MAX (512)		//Pp[cǗp[eBNobt@


//Wn̐ݒF}CiX̏ꍇ͗L
//̃Tvł͗LɂDXCũXvCg\@\gpĕ`悵܂B
//XvCg@\gpꍇAg嗦┽]ɐt܂B
//ɂꍇ͏vXƂČvZs܂B
//̃Tvł3D@\gpĕ`悵܂B
//ꂼ̃vbgtH[ɍ킹WnŎgpĂB
//DXCuŎgpꍇUP_MINUS𖳌ɂ܂setPosition
//ʃTCYWݒ肵ĉ^pƂƎv܂B
//#define UP_MINUS


//------------------------------------------------------------------------------


/**
 * Player
 */
class Player
{
public:
	/**
	 * PlayerCX^X\z܂.
	 *
	 * @param  resman  gpResourceManagerCX^X. ȗ̓ftHgCX^Xgp܂.
	 * @return PlayerCX^X
	 */
	static Player* create(ResourceManager* resman = NULL);

	/**
	 * gpResourceManagerCX^Xݒ肵܂.
	 *
	 * @param  resman  gpResourceManagerCX^X. ȗ̓ftHgCX^Xgp܂.
	 */
	void setResourceManager(ResourceManager* resman = NULL);

	/**
	 * gpResourceManagerCX^X܂.
	 * ēxResourceManagerCX^Xݒ肷܂ł͍ĐłȂȂ܂.
	 */
	void releaseResourceManager();

	/**
	 * Đssbpf[^dataKeyݒ肵܂.
	 *
	 * @param  dataKey  Đf[^dataKey
	 */
	void setData(const std::string& dataKey);

	/**
	 * ݒ肳Ăssbpf[^܂.
	 */
	void releaseData();

	/**
	 * ݒ肳ĂAj[V܂.
	 */
	void releaseAnime();

	/**
	* Aj[V̍ĐJn܂.
	*
	* @param  ssaeName      pbN(ssaej
	* @param  motionName    Đ郂[V
	* @param  loop          Đ[v̎w. ȗ0
	* @param  startFrameNo  ĐJnt[No̎w. ȗ0
	*/
	void play(const std::string& ssaeName, const std::string& motionName, int loop = 0, int startFrameNo = 0);

	/**
	* Aj[V̍ĐJn܂.
	* Aj[VĐf[^I܂.
	* "ssae/[VŎw肵Ă.
	* sample.ssaeanime_1w肷ꍇAsample/anime_1ƂȂ܂.
	* ver1.1烂[V݂̂Ŏw肷鎖͂łȂȂ܂B
	*
	* @param  animeName     ĐAj[V
	* @param  loop          Đ[v̎w. ȗ0
	* @param  startFrameNo  ĐJnt[No̎w. ȗ0
	*/
	void play(const std::string& animeName, int loop = 0, int startFrameNo = 0);

	/**
	* ݍĐĂ郂[VƃuhȂĐ܂B
	* Aj[VĐf[^I܂.
	* "ssae/[VŎw肵Ă.
	* sample.ssaeanime_1w肷ꍇAsample/anime_1ƂȂ܂.
	* ver1.1烂[V݂̂Ŏw肷鎖͂łȂȂ܂B
	*
	* uhAj[V͈̏ȉɂȂ܂B
	* EssbpɊ܂܂Ă鎖
	* Ep[c\ip[cAp[cjł鎖
	* SpriteStudiõt[Rg[ɕԃp[cォ珇ɃuhĂ܂B
	* p[c̃`FbN͍sȂĂ܂̂őJڌƑJڐAj̃p[c̏Ԃ𓯂ɂKv܂B
	* JڌƑJڐ̃p[c\ĂȂꍇAuh܂̂łӂB
	*
	* Agr[g
	* WXAWYAX]AY]AZ]AXP[XAXP[Ŷ݂łB
	* ȊÕAgr[g͑JڐAj̒lKp܂B
	* CX^Xp[cQƂĂ\[XAj̓uh܂B
	* GtFNgp[c甭p[eBN̓uh܂B
	* 
	*
	* @param  animeName     ĐAj[V
	* @param  loop          Đ[v̎w. ȗ0
	* @param  startFrameNo  ĐJnt[No̎w. ȗ0
	* @param  blendTime		[VuhsԁAPʂ͕b@ȗ1b
	*/
	void motionBlendPlay(const std::string& animeName, int loop = 0, int startFrameNo = 0, float blendTime = 0.1f);

	/**
	 * Đ𒆒f܂.
	 */
	void animePause();

	/**
	 * ĐĊJ܂.
	 */
	void animeResume();

	/**
	 * Đ~܂.
	 * Q[ŃAj[V̕\t[𐧌䂷ꍇstop()Ăяo
	 * Q[̍XVsetFrameNo()Ăяow̃t[\ĂB
	 */
	void stop();

	/**
	 * ĐĂAj[ṼpbN(ssae)Ԃ܂.
	 *
	 * @return pbN(ssae)
	 */
	const std::string& getPlayPackName() const;

	/**
	 * ĐĂAj[VԂ܂.
	 *
	 * @return Aj[V
	 */
	const std::string& getPlayAnimeName() const;
	
	/**
	* Aj[V̑t[擾܂.
	*
	* @return t[
	*/
	int getMaxFrame() const;

	/**
	 * Đt[No擾܂.
	 * Get frame no of playing.
	 *
	 * @return Đt[No. frame no.
	 */
	int getFrameNo() const;

	/**
	 * Đt[Noݒ肵܂.
	 * Set frame no of playing.
	 *
	 * @param Đt[No. frame no.
	 */
	void setFrameNo(int frameNo);

	/**
	 * ĐXs[h擾܂. (1.0f:W)
	 * Set speed to play. (1.0f:normal speed)
	 */
	float getStep() const;

	/**
	 * ĐXs[hݒ肵܂. (1.0f:W)
	 * Get speed to play. (1.0f:normal speed)
	 */
	void setStep(float step);
	
	/** 
	 * w肳ĂĐ[v񐔂擾܂. (0:wȂ)
	 * Get a playback loop count of specified. (0:not specified)
	 */
	int getLoop() const;

	/** 
	 * Đ[v񐔂ݒ肵܂. (0:wȂ)
	 * Set a playback loop count.  (0:not specified)
	 */
	void setLoop(int loop);

	/** 
	 * ݂܂ł̃[vĐ񐔂擾܂.
	 * Get repeat count a playback.
	 */
	int getLoopCount() const;

	/** 
	 * ݂܂ł̃[vĐ񐔂NA܂.
	 * Clear repeat count a playback.
	 */
	void clearLoopCount();

	/**
	 * t[XLbvit[[gɍ킹Đt[XLbvj̐ݒ܂. (default: true)
	 * Set frame-skip(to skip the playback frame according to the frame rate). (default: true)
	 */
	void setFrameSkipEnabled(bool enabled);
	
	/** 
	 * t[XLbv̐ݒԂԂ܂.
	 * Get frame-skip setting.
	 */
	bool isFrameSkipEnabled() const;

	/**
	* xt[ʒu擾܂.
	*/
	int getLabelToFrame(char* findLabelName);

	/**
	* indexp[c擾܂.
	*
	* @param  result        p[c󂯎obt@
	* @param  name          擾p[c
	* @param  frameNo       擾t[ԍ -1̏ꍇ͌ݍĐĂt[Kp
	*/
	const char* getPartName(int partId) const;

	/**
	* p[cindex擾܂.
	*/
	int indexOfPart(const char* partName) const;

	/**
	* p[c̖Ap[c擾܂.
	*
	* @param  result        p[c󂯎obt@
	* @param  name          擾p[c
	* @param  frameNo       擾t[ԍ -1̏ꍇ͌ݍĐĂt[Kp
	*/
	bool getPartState(ResluteState& result, const char* name, int frameNo = -1);

	/**
	* p[cp[c̕\A\ݒ肵܂.
	* RWp̃p[c⍷ւOtBbNASS5ŕ\sQ[ł͔\ɂꍇɎgp܂B
	* SS̔\Agr[gݒ肷킯ł͂Ȃ̂ŒӂĂB
	*/
	void setPartVisible(std::string partsname, bool flg);

	/**
	* p[cp[cɊ蓖ZύX܂.
	* ̊֐Őݒ肵p[c͎QƃZA`r[g̉e܂B
	* Ajɐݒ肳ꂽZɖ߂ꍇ́AZ""w肵ĂB
	*
	* @param  partsname         p[c
	* @param  sscename          Z}bv
	* @param  cellname          \Z
	*/
	void setPartCell(std::string partsname, std::string sscename, std::string cellname);

	/*
	* vC[{̂̈ʒuݒ肵܂B
	*/
	void  setPosition(float x, float y);

	/*
	* vC[{̂̉]pxݒ肵܂B2D̉]Zɒlݒ肵ĂB
	*/

	void  setRotation(float x, float y, float z);
	/*
	* vC[{̂̃XP[ݒ肵܂B
	*/
	void  setScale(float x, float y);

	/*
	* vC[{̂̓xݒ肵܂B
	*/
	void  setAlpha(int a);

	/*
	* Aj̋Pxݒ肵܂.
	* setColor(Color3B)ł͂ȂgpĂB
	* ƂăJ[uhKpꂽp[c̐F͕ύXł܂̂ŒӂĂB
	*
	* @param  r          Ԑ(0`255)
	* @param  g          ΐ(0`255)
	* @param  b          (0`255)
	*/
	void setColor(int r, int g, int b);

	/*
	* Ow肵ăp[c̍ĐCX^XAjύX܂B
	* w肵p[cCX^Xp[cłȂꍇAfalseԂ܂.
	* CX^Xp[c̓fBtHgł́ussae:[VvƂĂ܂B
	* ĐAj̖O"ssae/Aj[V"ƂčĐĂB
	* ݍĐĂAjw肷邱Ƃ͓qƂȂ薳[vƂȂ邽߂ł܂B
	* ύXAj[V͓ssbpɊ܂܂Kv܂B
	*
	* CX^XL[蓮Őݒ肷鎖o܂B
	* Aj[Vɍ킹ĊJnt[AIt[̃CX^XAgr[gݒ肵ĂB
	* It[ől͑t[-1ɂȂ܂B
	* ύXOƌŃAj[V̑t[ႤꍇA݂Ȃt[QƂėO܂B
	* ㏑tOfalsȅꍇASSɐݒ肳ꂽCX^XAgr[g̐ݒgp܂B
	* gpF
	* ss::Instance param;
	* param.clear();
	* param.refEndframe = resman->getMaxFrame("ssbp","ssae/[V") - 1;	//Aj[V̒擾
	* param.infinity = true;														//[vݒ
	* ssplayer->changeInstanceAnime("ĐĂAj[VɊ܂܂CX^Xp[c", "ssae/[V", true, param);
	*
	* @param  partsname			SS̃p[c
	* @param  animeName			QƂAj
	* @param  overWrite			CX^XL[̏㏑tO
	* @param  keyParam			CX^XL[̃p[^
	*/
	bool changeInstanceAnime(std::string partsname, std::string animeName, bool overWrite, Instance keyParam);

	/*
	* vC[ɃCX^Xp[^ݒ肵܂B
	*
	* @param  overWrite			CX^XL[̏㏑tO
	* @param  keyParam			CX^XL[̃p[^
	*/
	void setInstanceParam(bool overWrite, Instance keyParam);

	/*
	* vC[CX^Xp[^擾܂B
	*
	* @param  overWrite			CX^XL[̏㏑tO
	* @param  keyParam			CX^XL[̃p[^
	*/
	void getInstanceParam(bool *overWrite, Instance *keyParam);

	/*
	* vC[{̂̔]ݒ肵܂B
	*/
	void  setFlip(bool flipX, bool flipY);

	/*
	* Q[̃t[[gݒ肵܂BfBtHg60FPSB
	*/
	void setGameFPS(float fps);

	/*
	* p[cԍɑΉXvCg擾܂B
	* 
	* @param  partIndex			p[cԍ
	*/
	CustomSprite* getSpriteData(int partIndex);


	/*
	* vC[̍XVs܂BQ[̍XV^C~OŌĂяoĂB
	*/
	void update(float dt);

	/*
	* vC[̕\s܂BQ[̕\^C~OŌĂяoĂB
	*/
	void draw();

public:
	Player(void);
	~Player();
	bool init();


protected:
	void allocParts(int numParts, bool useCustomShaderProgram);
	void releaseParts();
	void setPartsParentage();

	void play(AnimeRef* animeRef, int loop, int startFrameNo);
	void updateFrame(float dt);
	void setFrame(int frameNo);
	void checkUserData(int frameNo);
	void set_InstanceAlpha(int alpha);
	void set_InstanceRotation(float rotX, float rotY, float rotZ);
	float parcentVal(float val1, float val2, float parcent);
	float parcentValRot(float val1, float val2, float parcent);

protected:
	ResourceManager*	_resman;
	ResourceSet*		_currentRs;
	std::string			_currentdataKey;
	std::string			_currentAnimename;
	AnimeRef*			_currentAnimeRef;
	std::vector<CustomSprite *>	_parts;

	Player*				_motionBlendPlayer;
	float				_blendTime;
	float				_blendTimeMax;

	bool				_frameSkipEnabled;
	float				_playingFrame;
	float				_step;
	int					_loop;
	int					_loopCount;
	bool				_isPlaying;
	bool				_isPausing;
	bool				_isPlayFirstUserdataChack;
	int					_prevDrawFrameNo;
	bool				_partVisible[PART_VISIBLE_MAX];
	int					_cellChange[PART_VISIBLE_MAX];
	int					_partIndex[PART_VISIBLE_MAX];
	int					_InstanceAlpha;
	float				_InstanceRotX;
	float				_InstanceRotY;
	float				_InstanceRotZ;
	int					_animefps;
	int					_col_r;
	int					_col_g;
	int					_col_b;
	bool				_instanceOverWrite;		//CX^X㏑邩H
	Instance			_instanseParam;			//CX^Xp[^

	UserData			_userData;

	State				_state;
	float				_gamefps;
};


};	// namespace ss

#endif
