/*	
 *	dstdpipe.c
 *
 *	dstdpipe - P/ECEWo͒ppCv
 *	Copyright (C) 2002-2014 Naoyuki Sawa
 *
 *	* Thu Mar 13 01:25:35 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Mar 14 04:56:05 JST 2014 Naoyuki Sawa
 *	- AWo͂tbV悤ɁAC܂B
 *	  stdout_routine()̃RgQƂĂB
 */
#define STRICT
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <process.h>

#include <pieceif.h>
#pragma comment(lib,"pieceif.lib")

#define VERSION		"20140314"

/****************************************************************************
 *	ϐ
 ****************************************************************************/

volatile int terminate;	/* Iv */
char devno;	/* P/ECEfoCXԍ */
USBCOMS ucs;	/* USBCOMԎ擾p */

/****************************************************************************
 *	usage
 ****************************************************************************/

void usage() {
	fprintf(stderr, "dstdpipe - P/ECEWo͒ppCv (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2014 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE: dstdpipe [devno]\n");
	fprintf(stderr, "  devno  P/ECEfoCXԍ\n");
	fprintf(stderr, "         ȗ́A#0(ڂP/ECE)ɐڑ܂B\n");
	exit(EXIT_FAILURE);
}

/****************************************************************************
 *	disconnect
 ****************************************************************************/

void disconnect() {
	ismUCClose();	/* USBCOMؒf(P/ECEƎ̃vgRCł̐ؒf) */
	ismExit();	/* oNPIPEؒf(OSxUSBʐMCł̐ؒf) */
}

/****************************************************************************
 *	sigint
 ****************************************************************************/

void sigint(int sig) {
	terminate = 1; /* Iv */
}

/****************************************************************************
 *	stdin_routine
 ****************************************************************************/

HANDLE stdin_event;	/* W̓obt@ł邱ƂA蓮ZbgCxg */
volatile char stdin_str[1024];

void stdin_routine(void* arglist) {
	/* ̃XbhIOoEhȂ̂ŁACXbhDxグ܂B */
	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_ABOVE_NORMAL);
	for(;;) {
		/* W̓obt@ɂȂ܂ő҂B蓮ZbgCxgȂ̂ŁAWaitForSingleObject()ԂACxg̓VOiԂ̂܂܂łB */
		WaitForSingleObject(stdin_event, INFINITE);
		/* W͂AW̓obt@֓ǂݍށBW͂ꂽ甲 */
		if(!fgets((char*)stdin_str, sizeof stdin_str, stdin)) { break; }	/* LXgvolatilěx̂ */
		/* ǂݍ񂾌ʂłȂ΁A蓮ZbgCxgZbgāACXbhցAW̓obt@łȂȂƂB */
		if(stdin_str[0]) { ResetEvent(stdin_event); }
	}
	terminate = 1; /* Iv */
}

/****************************************************************************
 *	stdout_routine
 ****************************************************************************/

HANDLE stdout_event;	/* Wo̓obt@łȂƂA蓮ZbgCxg */
volatile char stdout_str[1024];

void stdout_routine(void* arglist) {
	/* ̃XbhIOoEhȂ̂ŁACXbhDxグ܂B */
	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_ABOVE_NORMAL);
	for(;;) {
		/* Wo̓obt@łȂȂ܂ő҂B蓮ZbgCxgȂ̂ŁAWaitForSingleObject()ԂACxg̓VOiԂ̂܂܂łB */
		WaitForSingleObject(stdout_event, INFINITE);
		/* Wo̓obt@AWo͂֏oBWo͂ꂽ甲 */
		if(fputs((char*)stdout_str, stdout) == -1) { break; }	/* LXgvolatilěx̂ */
		/* AWo͂tbVB
		 * - c[R}hCgpꍇ́AtbVȂĂȂB
		 *   Wo͂R\[ɌĂ̂ŁÂ܂܂łobt@OȂB
		 * - Ac[opCvƂĎgpꍇɁAtbVȂƖ肪B
		 *   :TclXNvg
		 *   set fp [open "|dstdpipe.exe" "r+"]
		 *   fconfigure $fp -buffering line
		 *   puts $fp "How do you do?"
		 *   gets $fp s	#//ꂪ擾łɑ҂肪B
		 *   puts "P/ECE said '$s'."
		 *   AWo͂tbV΁AL̖͉B
		 * - Ac[R}hCgpꍇ́AXvȂ̂ŁAWo͂tbVKv͖AĂQ͖B
		 *   ͂ɐ\ቺ\͂邪AXAP/ECEƂ̒ʐMxƂĂx̂ŁAxȂĂAA\̈Ⴂ͐ȂB
		 */
		fflush(stdout);
		/* 蓮ZbgCxgZbgāACXbhցAWo̓obt@ɂȂƂB */
		ResetEvent(stdout_event);
	}
	terminate = 1; /* Iv */
}

/****************************************************************************
 *	main
 ****************************************************************************/

int main(int argc, char* argv[]) {
	int retval, exit_code;
	char* p;

	/* IR[hsƂĂB */
	exit_code = EXIT_FAILURE;

	/*--------------------  --------------------*/

	/* R}hĆB */
	switch(argc) {
	case 1:	/* dstdpipe */
		/** no job **/
		break;
	case 2:	/* dstdpipe devno */
		/* foCXԍw */
		devno = (char)strtol(argv[1], &p, 10);
		if(*p != '\0') { usage(); } /* ȊO̕ŏI[ */
		break;
	default:
		usage();
	}

	/* Ctrl+CtbN܂B */
	signal(SIGINT, sigint);

	/* P/ECEɐڑ܂B */
	retval = ismInitEx(devno, PIECE_DEF_WAITN);
	if(retval != 0) {
		fprintf(stderr, "### P/ECEɐڑł܂B\n");
		goto EXIT;
	}

	/* USBCOMɐڑ܂B */
	retval = ismUCOpen(&ucs);
	if(retval != 0) {
		fprintf(stderr, "### USBCOMɐڑł܂B\n");
		goto EXIT;
	}
	if(!ucs.mystat || strcmp(ucs.signature, "stderr") != 0) {
		fprintf(stderr, "### WG[o͂ɐڑł܂B\n");
		goto EXIT;
	}

	/* W̓XbhJn܂B */
	stdin_event = CreateEvent(NULL, TRUE/*蓮Zbg*/, TRUE/*VOi*/, NULL);	/* W̓obt@ł邱ƂA蓮ZbgCxgBԂŕW̓obt@͋ł̂ŁAVOiԂƂB */
	if(!stdin_event) {
		fprintf(stderr, "### W̓obt@ł邱ƂA蓮ZbgCxg̍쐬Ɏs܂B\n");
		goto EXIT;
	}
	retval = _beginthread(stdin_routine, 0, NULL);
	if(retval == -1) {
		fprintf(stderr, "### W̓Xbh̍쐬Ɏs܂B\n");
		goto EXIT;
	}

	/* Wo̓XbhJn܂B */
	stdout_event = CreateEvent(NULL, TRUE/*蓮Zbg*/, FALSE/*VOi*/, NULL);	/* Wo̓obt@łȂƂA蓮ZbgCxgBԂŕWo̓obt@͋ł̂ŁAVOiԂƂB */
	if(!stdout_event) {
		fprintf(stderr, "### Wo̓obt@łȂƂA蓮ZbgCxg̍쐬Ɏs܂B\n");
		goto EXIT;
	}
	retval = _beginthread(stdout_routine, 0, NULL);
	if(retval == -1) {
		fprintf(stderr, "### Wo̓Xbh̍쐬Ɏs܂B\n");
		goto EXIT;
	}

	/*-------------------- C[v --------------------*/

	/* IvZbg܂Łc */
	while(!terminate) {
		Sleep(0);	/* Cx */

		/* USBCOM̏Ԃ擾܂B */
		retval = ismUCGetStat(&ucs); /* ismUCGetStat()̓VOl`͓ǂݍ݂܂!!v */
		if(retval != 0) {
			fprintf(stderr, "### USBCOM̏Ԏ擾Ɏs܂B\n");
			goto EXIT;
		}

		/* P/ECÉAPpceUSBCOMStop()ĂяoŐؒf*̂ł͂Ȃ*A
		 * 󕶎VOl`pceUSBCOMSetup()sApceUSBCOMStop()ĂŐؒfĂB
		 * ȂƂƁAPCƂ̐ڑmĂƁApceUSBCOMStop()͐ؒfsȂłB
		 * ̂߁ApceUSBCOMSetup()gPCƂ̐ڑtOуVOl`NAĂA
		 * 炽߂pceUSBCOMStop()ĂяoĐؒfŝłB(BIOS 1.18̂ӂ܂Ɉˑ)
		 */
		//if(!ucs.mystat || strcmp(ucs.signature, "stderr") != 0) {
		if(!ucs.mystat/* || strcmp(ucs.signature, "stderr") != 0*/) { /* ismUCGetStat()̓VOl`ǂ܂Ȃ̂ŁAĂʂł */
			fprintf(stderr, "### WG[o͂ؒf܂B\n");
			goto EXIT;
		}

		/* Wo̓obt@Ȃ΁c */
		if(WaitForSingleObject(stdout_event, 0) == WAIT_TIMEOUT) {	/* Wo̓obt@łȂƂA蓮ZbgCxgAVOiԂȂ΁c */
			/* P/ECȆMv... */
			if(ucs.txstat & USBCOM_STAT_TXWAIT/*TXING̃rbg𖳎邽߂ɁÃ}XNK{I*/) {
				if((ucs.txlen < 1) || (ucs.txlen > sizeof stdout_str - 1/*nul*/)) {
					fprintf(stderr, "### MvTCYsłB(%d)\n", ucs.txlen);
					goto EXIT;
				}
				/* P/ECȆMf[^M܂B */
				retval = ismUCRead((char*)stdout_str, ucs.txlen);	/* LXgvolatilěx̂ */
				if(retval != 0) {
					fprintf(stderr, "### f[^MG[łB\n");
					goto EXIT;
				}
				/* P/ECȆMf[^nulI[ĂȂ̂ŁAnulI[ǉB */
				stdout_str[ucs.txlen] = '\0';
				/* 蓮ZbgCxgZbgāAWo̓obt@łȂȂƂB */
				SetEvent(stdout_event);
			}
		}

		/* W̓obt@łȂ΁c */
		if(WaitForSingleObject(stdin_event, 0) == WAIT_TIMEOUT) {	/* W̓obt@ł邱ƂA蓮ZbgCxgAVOiԂȂ΁c */
			/* P/ECE̎Mv... */
			if(ucs.rxstat & USBCOM_STAT_RXWAIT/*RXING̃rbg𖳎邽߂ɁÃ}XNK{I*/) {
				if((ucs.rxlen < 1) || (ucs.rxlen > sizeof stdin_str)) {
					fprintf(stderr, "### MvTCYsłB(%d)\n", ucs.rxlen);
					goto EXIT;
				}
				/* P/ECE֑M܂B */
				retval = ismUCWrite((char*)stdin_str, ucs.rxlen);	/* LXgvolatilěx̂ */
				if(retval != 0) {
					fprintf(stderr, "### f[^MG[łB\n");
					goto EXIT;
				}
				/* 蓮ZbgCxgZbgāAW̓obt@ɂȂƂB */
				SetEvent(stdin_event);
			}
		}
	}

	/*-------------------- N[Abv --------------------*/

	/* IR[h𐬌ƂB */
	exit_code = EXIT_SUCCESS;
EXIT:
	/* mɐؒf܂B */
	disconnect();

	return exit_code;
}

