/*
 *	app.c
 *
 *	dsetargv - ChJ[hWJc[
 *	Copyright (C) 2014 Naoyuki Sawa
 *
 *	* Sun Feb 02 23:15:51 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <process.h>	/* _spawnvp() */

/* dv
 * R}hC̃ChJ[hWJ邽߂ɁA
 * [vWFNg̐ݒ]->[N]->[IuWFNg/CuW[]Ɂusetargv.objvǉ܂B
 */

/****************************************************************************
 *	
 ****************************************************************************/

#define VERSION "20140202"

/* IvV */
int opt_Verbose;	/* 1Ȃ΁AWJ̃R}hC\B */
int opt_Debug;		/* 1Ȃ΁AWJ̃R}hC\AR}hsȂB */

/*--------------------------------------------------------------------------*/
__declspec(noreturn) void usage();
__declspec(noreturn) void die(const char* fmt, ...);
#define DIE() die(__FILE__, __LINE__)

#define __CLIP_H__
/* getopt */
#include "../../include/getopt.h"
#include "../../getopt.c"
#undef  __CLIP_H__

/****************************************************************************
 *	
 ****************************************************************************/

int main(int argc, char* argv[]) {
	int opt, i;
	/* R}hCIvVB */
	opterr = 0; /* IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB */
	while((opt = getopt(argc, argv, "hvd")) != -1) {
		switch(opt) {
		default:
		case 'h': usage();
		case 'v': opt_Verbose = 1; break;
		case 'd': opt_Debug   = 1; break;
		}
	}
	if(optind >= argc) { usage(); }
	/* 'v''d'IvVw肳ĂAWJ̃R}hC\B */
	if(opt_Verbose || opt_Debug) {
		for(i = optind; i < argc; i++) {
			if(i != optind) { fprintf(stderr, " "); }
			fprintf(stderr, "%s", argv[i]);
		}
	}
	fprintf(stderr, "\n");
	/* 'd'IvVw肳ĂA܂ŁB */
	if(opt_Debug) { return EXIT_SUCCESS; }
	/* R}hsB */
	//MSDN Cu Microsoft Visual Studio 6.0 [Xu_spawnvpA_wspawnvpvp:
	//_spawnvp܂_wspawnvp֐(mode_P_WAITw)̖߂ĺAqvZX̏IR[hłB
	//񓯊_spawnvp܂_wspawnvp֐(mode_P_NOWAIT܂_P_NOWAITOw)̖߂ĺAvZXnhłB
	//vZXIƁAIXe[^X0ɂȂ܂B
	//qvZX0ȊÖŖIexit[`ĂяoƁAIԂ0ȊO̒lɐݒ肳܂B
	//qvZXIɐݒ肵̏IXe[^XȊO̐̏IXe[^X́Ȃł؂A܂͊荞݂ɂُIӖ܂B
	//߂l-1̏ꍇɂ̓G[(qvZXNĂȂ)܂B
	//̏ꍇAO[oϐerrnoɂ͈ȉ̂ꂩ̒lݒ肳܂B
	//E2BIG  Xg1024oCg𒴂ĂB
	//EINVAL modeB
	//ENOENT t@C܂̓pXȂBw肳ꂽt@Cs\t@CłȂAs\t@Č`słB
	//ENOMEM ŝߎqvZXsłȂB
	i = _spawnvp(_P_WAIT, argv[optind], &argv[optind]);
	//                                  ~~~~~~~~~~~~~R}hƂēnKv邱Ƃɒ
	if(i == -1) { die("%ssł܂B(%s)", argv[optind], strerror(errno)); }
	return i;
}

/*--------------------------------------------------------------------------*/
/* g\AG[IB */
void usage() {
	fprintf(stderr, "dsetargv - ChJ[hWJc[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2014 Naoyuki Sawa All Rights Reserved.\n");
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "    dsetargv [-h] [-v] [-d] cmdname [args ...]\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "    -h            g\܂B\n");
	fprintf(stderr, "    -v            R}hsOɁAWJ̃R}hC\܂B\n");
	fprintf(stderr, "    -d            WJ̃R}hC\邾ŁAsI܂B\n");
	fprintf(stderr, "Example:\n");
	fprintf(stderr, "    ECHOR}h͂ꎩgł͈ChJ[hWJ܂񂪁A\n");
	fprintf(stderr, "    dsetargvƑgݍ킹āAChJ[hWJ邱Ƃł܂B\n");
	fprintf(stderr, "                    ECHO sample*.txt  sample*.txt\n");
	fprintf(stderr, "    dsetargv CMD /C ECHO sample*.txt  sample1.txt sample2.txt sample3.txt\n");
	exit(EXIT_FAILURE);
}

/*--------------------------------------------------------------------------*/
/* bZ[W\AG[IB */
void die(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
#ifdef  _DEBUG
	__asm int 3; /* fobOՂ悤ɁAfobO̓fobKŎ~߂ */
#endif/*_DEBUG*/
	exit(EXIT_FAILURE);
}

