//---------------------------------------------------------------------------
//
//   MQ3DLib.cpp      Copyright(C) 1999-2000, O.Mizno
//
//    @ƕ֗Ȋ֐WB
//
//---------------------------------------------------------------------------

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "MQPlugin.h"
#include "MQ3DLib.h"


// float^_Z֐ɑΉĂȂC++Builder5p΍
#ifdef __BORLANDC__
#define  acosf  acos
#define  cosf   cos
#endif


//---------------------------------------------------------------------------
//  GetNormal()
//     3_Ȃʂ̖@𓾂
//---------------------------------------------------------------------------
MQPoint GetNormal(const MQPoint& p0, const MQPoint& p1, const MQPoint& p2)
{
	MQPoint ep = GetCrossProduct(p1-p2, p0-p1);

	if(ep == MQPoint(0,0,0))
		return MQPoint(0,0,0);

	return ep / GetSize(ep);
}

//---------------------------------------------------------------------------
//  GetQuadNormal()
//     4_Ȃʂ̖@𓾂
//---------------------------------------------------------------------------
MQPoint GetQuadNormal(const MQPoint& p0, const MQPoint& p1, const MQPoint& p2, const MQPoint& p3)
{
	MQPoint n,n1a,n1b,n2a,n2b;

	n1a = GetNormal(p0, p1, p2);
	n1b = GetNormal(p0, p2, p3);
	n2a = GetNormal(p1, p2, p3);
	n2b = GetNormal(p1, p3, p0);

	// ^c񂾎lp`̏ꍇ͕Е̓ςȂ̂ŁA
	// Q@̓ς̒lrāA傫I
	if(GetInnerProduct(n1a,n1b) > GetInnerProduct(n2a,n2b)) {
		n = Normalize(n1a + n1b);
	} else {
		n = Normalize(n2a + n2b);
	}

	return n;
}

//---------------------------------------------------------------------------
//  GetCrossingAngle()
//     2xNǧpxWAPʂ0΂܂ł̒lœ
//---------------------------------------------------------------------------
float GetCrossingAngle(const MQPoint& v1, const MQPoint& v2)
{
	float d,c;

	d = GetSize(v1) * GetSize(v2);
	if(d == 0.0f)
		return 0.0f;

	c = GetInnerProduct(v1, v2) / d;
	if(c >= 1.0f) return 0.0f;
	if(c <=-1.0f) return PI;

	return acosf(c);
}

//---------------------------------------------------------------------------
//  SearchInvertedFace()
//     Ό̖ʂ݂邩ǂ𒲂ׂ
//     ݂Ă΂̖ʂ̃CfbNXAȂ-1Ԃ
//---------------------------------------------------------------------------
int SearchInvertedFace(MQObject obj, int faceindex, int start, int end)
{
	int i,j,k;
	int cvidx[4], dvidx[4];

	int face_count = obj->GetFaceCount();
	if(faceindex >= face_count)
		return -1;

	int pt_count = obj->GetFacePointCount(faceindex);
	if(pt_count == 0)
		return -1;

	obj->GetFacePointArray(faceindex, dvidx);

	if(start < 0) start = 0;
	if(end   < 0) end   = face_count-1;

	for(i=start; i<=end; i++)
	{
		if(pt_count != obj->GetFacePointCount(i))
			continue;
		
		obj->GetFacePointArray(i, cvidx);

		for(j=0; j<pt_count; j++) {
			if(cvidx[j] != dvidx[0]) continue;
			for(k=1; k<pt_count; k++) {
				if(cvidx[(j+k)%pt_count] != dvidx[pt_count-k])
					break;
			}
			if(k == pt_count)
				return i;
		}
	}

	return -1;
}


//---------------------------------------------------------------------------
//  class MQGouraudHash
//     MQObjNormalNXœIɎgnbV
//---------------------------------------------------------------------------
class MQGouraudHash
{
public:
	MQPoint nv;
	int count;
	MQGouraudHash *next;

	inline MQGouraudHash() { nv.zero(); count=0; next=NULL; }
};

typedef MQGouraudHash *MQGouraudHashTable[4];

//---------------------------------------------------------------------------
//  class MQObjNormal
//     IuWFNg̖@vZNXB
//     X[WOpxɑ΂鏈sB
//     gp͈ȉ̂悤ȊB
//
//       MQObjNormal *normal = new MQObjNormal(obj);
//       int face_count = obj->GetFaceCount();
//       for(int face=0; face<face_count; face++) {
//           int count = obj->GetFacePointCount(face);
//           for(int vert=0; vert<count; vert++) {
//				MQPoint nv = normal->Get(face, vert);
//              // ɖ@ɑ΂鏈
//           }
//       }
//       delete normal;
//---------------------------------------------------------------------------
MQObjNormal::~MQObjNormal()
{
	delete[] normal;
}

MQObjNormal::MQObjNormal(MQObject obj)
{
	int i,j;
	int face_count, vert_count;
	int vi[4];

	face_count = obj->GetFaceCount();
	vert_count = obj->GetVertexCount();

	MQPoint *face_n = new MQPoint[face_count];
	normal = new MQPoint[face_count * 4];

	// ʂƂɖ@vZ
	for(i=0; i<face_count; i++)
	{
		int count = obj->GetFacePointCount(i);

		// Op`Ǝlp`ł͖ʂɑ΂@̌vZ@͈قȂ
		switch(count) {
		case 3:
			obj->GetFacePointArray(i, vi);
			face_n[i] = GetNormal(
				obj->GetVertex(vi[0]), obj->GetVertex(vi[1]), obj->GetVertex(vi[2]));
			break;
		case 4:
			obj->GetFacePointArray(i, vi);
			face_n[i] = GetQuadNormal(
				obj->GetVertex(vi[0]), obj->GetVertex(vi[1]), 
				obj->GetVertex(vi[2]), obj->GetVertex(vi[3]));
			break;
		default:
			face_n[i].zero();
			break;
		}
	}

	switch(obj->GetShading()) {
	case MQOBJECT_SHADE_FLAT:
		for(i=0; i<face_count; i++)
		{
			int count = obj->GetFacePointCount(i);
			for(j=0; j<count; j++)
				normal[i*4+j] = face_n[i];
			for(; j<4; j++)
				normal[i*4+j].zero();
		}
		break;

	case MQOBJECT_SHADE_GOURAUD:
		{
			MQGouraudHashTable *vtbl, *cvt;
			MQGouraudHash *hash, *chs;

			// X[WOpx̎擾
			float facet = cosf( RAD(obj->GetSmoothAngle()) );

			// nbV̏
			vtbl = new MQGouraudHashTable[face_count];
			hash = new MQGouraudHash[vert_count + face_count*4];
			int hash_count = vert_count;

			// ʂƂɃnbVɖ@xNgZbg
			for(i=0,cvt=vtbl; i<face_count; i++,cvt++)
			{
				int count = obj->GetFacePointCount(i);
				if(count < 3) continue;

				obj->GetFacePointArray(i, vi);

				// ʒ̊e_Ƃɖ@xNgnbV֊i[Ă
				for(j=0; j<count; j++)
				{
					// ڂ钸_ɑ΂ẴnbV𓾂
					chs = &hash[vi[j]];

					// nbV܂Ȃ炻ɏi[
					if(chs->count == 0) {
						chs->nv = face_n[i];
						chs->count++;
						(*cvt)[j] = chs;
						continue;
					}

					// nbVłȂȂAɊi[Ă@Ƃ̃X[WO
					// px`FbNKvB
					// ASYƂĂ͕sSȂAƂ肠px
					// ͂ȂƎvB

					const MQPoint& pa = face_n[i];
					float da = pa.norm();
					for(; ; chs=chs->next)
					{
						// Qʂ̊px`FbN
						float c = 0.0f;
						if(da > 0.0f) {
							MQPoint& pb = chs->nv;
							float db = pb.norm();
							if(db > 0.0f)
								c = GetInnerProduct(pa, pb) / sqrtf(da*db);
						}
							
						// X[WOpxȓH
						if(c >= facet)
						{
							// ڂ钸_ɑ΂Ėʂ̖@xNĝ܂܉ZB
							// {ȂAڂ钸_ɑʓ̂Qӂ̊pxɂ
							// xNg̉ZʂςׂAƂ肠pXB
							chs->nv += pa;
							chs->count++;
							(*cvt)[j] = chs;
							break;
						}

						// X[WO͍sȂ̂ŁÃnbV`FbNB
						// ̃nbVf[^Ȃꍇ͐VK쐬B
						if(chs->next == NULL) {
							(*cvt)[j] = chs->next = &hash[hash_count++];
							chs = chs->next;
							chs->nv = pa;
							chs->count = 1;
							chs->next = NULL;
							break;
						}
					}
				}
			}

			// nbV̖@xNg̐K
			for(i=0,chs=hash; i<hash_count; i++,chs++) {
				if(chs->count > 1)
					chs->nv.normalize();
			}

			// @obt@ɃZbg
			for(i=0,cvt=vtbl; i<face_count; i++,cvt++)
			{
				int count = obj->GetFacePointCount(i);
				if(count < 3) continue;
				for(j=0; j<count; j++)
					normal[i*4+j] = (*cvt)[j]->nv;
				for(; j<4; j++)
					normal[i*4+j].zero();
			}

			// nbV
			delete[] vtbl;
			delete[] hash;
		}
		break;
	}

	delete[] face_n;
}


//---------------------------------------------------------------------------
//  class MQObjEdge
//     IuWFNg̃GbW΂Ǘ
//     ȉ̂悤ɂface_indexŎʒline_index̕ӂL
//     ʂ̃CfbNXpfɁAӂ̃CfbNXplɓB
//     gp͈ȉB
//
//       int pf,pl;
//       MQObjEdge *edge = new MQObjEdge(obj);
//       edge->getPair(face_index, line_index, pf, pl);
//       delete edge;
//
//---------------------------------------------------------------------------
MQObjEdge::MQObjEdge(MQObject obj)
{
	int vert_count = obj->GetVertexCount();
	int face_count = obj->GetFaceCount();

	m_obj = obj;
	m_face = face_count;
	m_pair = new MQObjEdgePairFace[face_count];

class MRelTree
{
public:
	MQObjEdgePair pair;
	int next;

	inline MRelTree() { next = -1; }
	inline MRelTree& operator = (const MRelTree& r)
		{pair=r.pair; next=r.next; return *this;}
};

	MRelTree *tree = new MRelTree[vert_count + face_count*4];

	int regvc = vert_count;
	for(int cf=0; cf<face_count; cf++)
	{
		int cvi[4];
		int cfc = obj->GetFacePointCount(cf);

		if(cfc < 3)
			continue;

		obj->GetFacePointArray(cf, cvi);

		cfc--; // decrement to be faster
		for(int j=0; j<=cfc; j++)
		{
			// check tree
			int v1 = cvi[j];
			int v2 = cvi[j<cfc? j+1 : 0];
			for(MRelTree drel=tree[v2]; drel.pair.face>=0; drel=tree[drel.next])
			{
				int dvi[4];
				int df = drel.pair.face;
				int dfc = obj->GetFacePointCount(df);
				obj->GetFacePointArray(df, dvi);
				if(m_pair[df][drel.pair.line].face < 0)
				{
					if(/*v2 == dvi[drel.pair.line]
					&&*/ v1 == dvi[drel.pair.line<dfc-1 ? drel.pair.line+1 : 0])
					{
						// set relation
						m_pair[df][drel.pair.line] = MQObjEdgePair(cf,j);
						m_pair[cf][j] = drel.pair;
						goto CR_REG_END;
					}
				}
				if(drel.next < 0) break;
			}
			// not find in tree, so regist vertex1
			MRelTree *ctr;
			for(ctr=&tree[v1]; ctr->pair.face>=0; ctr=&tree[ctr->next]){
				if(ctr->next < 0){
					ctr->next = regvc;
					ctr = &tree[regvc++];
					break;
				}
			}
			ctr->pair = MQObjEdgePair(cf,j);
CR_REG_END:;
		}
	}

	delete[] tree;
}

MQObjEdge::~MQObjEdge()
{
	delete[] m_pair;
}

bool MQObjEdge::getPair(int face_index, int line_index, int& pair_face, int& pair_line)
{
	if(face_index >= m_face)
		return false;

	if(m_pair[face_index][line_index].face < 0)
		return false;

	pair_face = m_pair[face_index][line_index].face;
	pair_line = m_pair[face_index][line_index].line;

	return true;
}


