%{
//{{^R[h:y.tab.y(錾,%{`%})========================================
#include "app.h"
#pragma warning(default: 4131)	//{{2016/03/01ǉ:clipstd.hɂC4131̌xxグ܂ABison/Flex̐R[hɂ͋X^C̐錾gĂ̂ŁABison/Flex̐R[ĥ݌xxɖ߂܂B}}
//p[T[X^bN̏l`܂B
//sizeof(YYSTYPE)*YYINITDEPTH) X^bNɊmۂ܂B
//ftHgł200ƒ`ĂAP/ECEɂ͑傫܂B
//P/ECEɓK؂ȁAȃTCY(16)ɁAĒ`܂B
//p[T[X^bNsꍇ́AIɊĝŁA肠܂B
#define YYINITDEPTH 16
//G[񍐊֐`܂B
char err_path[MAX_PATH];	//'-e'IvVw肳ꂽAG[Ot@Ci[B
void yyerror(const char* fmt, ...) {
	static FILE* fp_err;	//ŏ̃G[OL^鎞ɁAG[Ot@C쐬B
	//'-e'IvVw肳ĂāAŏ̃G[OL^鎞Ȃ΁c
	if(*err_path && !fp_err) {
		//G[Ot@C쐬B
		fp_err = fopen(err_path, "w");
		if(!fp_err) { die("%s 쐬ł܂B\n", err_path); }
		//G[Ot@C̏o̓Xg[́Aobt@OƂB
		// - die()ŏI(abort())ɁAobt@tbVȂ悤Ȃ̂ŁAĂKvLB
		//   ʂ̈ĂƂāẢ̏Ŗfflush()@L邪Aobt@OƂȒP낤B
		setbuf(fp_err, NULL);
	}
	//G[bZ[W(,y,G[O)o͂B
	             fprintf(stderr, "### error at line %d : ", yylineno);	//G[bZ[W
	if(fp_err) { fprintf(fp_err, "### error at line %d : ", yylineno); }	//G[O
	{
		va_list ap;
		va_start(ap, fmt);
		             vfprintf(stderr, fmt, ap);		//G[bZ[W
		if(fp_err) { vfprintf(fp_err, fmt, ap); }	//G[O
		va_end(ap);
	}
	             fputc('\n', stderr);	//G[bZ[W
	if(fp_err) { fputc('\n', fp_err); }	//G[O
}
//}}^R[h:y.tab.y(錾,%{`%})========================================
%}

%union {
	int		v_num;
	double		v_dbl;
	char*		v_lab;
	char*		v_str;
}
%token	<v_num>		T_NUM
%token	<v_dbl>		T_DBL
%token	<v_lab>		T_LAB
%token	<v_str>		T_STR
%token			T_EOL

%type	<v_num>		expr
%type	<v_dbl>		edbl

%left			'|'
%left			'^'
%left			'&'
%left			'<' '>'
%left			'+' '-'
%left			'*' '/'
%nonassoc		'~' T_UPL T_UMI T_CAST_INT T_CAST_DBL

%%

all
		: pre_blank
		| all expr eols			{ printf("expr: %d\n", $2); }
		| all edbl eols			{ printf("edbl: %f\n", $2); }
		| all T_LAB eols		{ printf("T_LAB: %s\n", $2); }
		| all T_STR eols		{ printf("T_STR: %s\n", $2); }
		;
pre_blank
		: /* empty */
		| pre_blank T_EOL		/* no action */
		;
eols
		:      T_EOL
		| eols T_EOL
		;
expr
		: T_NUM
		| '(' expr ')'			{ $$ =  $2; }
		| T_CAST_INT expr		{ $$ =  $2; }
		| T_CAST_INT edbl		{ $$ =  $2; }
		| '+' expr %prec T_UPL		{ $$ =  $2; }
		| '-' expr %prec T_UMI		{ $$ = -$2; }
		| '~' expr			{ $$ = ~$2; }
		| expr '+' expr			{ $$ = $1 + $3; }
		| expr '-' expr			{ $$ = $1 - $3; }
		| expr '*' expr			{ $$ = $1 * $3; }
		| expr '/' expr			{ $$ = $1 / $3; }
		| expr '&' expr			{ $$ = $1 & $3; }
		| expr '^' expr			{ $$ = $1 ^ $3; }
		| expr '|' expr			{ $$ = $1 | $3; }
		| expr '<' expr			{ $$ = $1 << $3; }
		| expr '>' expr			{ $$ = $1 >> $3; }
		;
edbl
		: T_DBL
		| '(' edbl ')'			{ $$ =  $2; }
		| T_CAST_DBL expr		{ $$ =  $2; }
		| T_CAST_DBL edbl		{ $$ =  $2; }
		| '+' edbl %prec T_UPL		{ $$ =  $2; }
		| '-' edbl %prec T_UMI		{ $$ = -$2; }
		| edbl '+' edbl			{ $$ = $1 + $3; }
		| edbl '+' expr			{ $$ = $1 + $3; }
		| expr '+' edbl			{ $$ = $1 + $3; }
		| edbl '-' edbl			{ $$ = $1 - $3; }
		| edbl '-' expr			{ $$ = $1 - $3; }
		| expr '-' edbl			{ $$ = $1 - $3; }
		| edbl '*' edbl			{ $$ = $1 * $3; }
		| edbl '*' expr			{ $$ = $1 * $3; }
		| expr '*' edbl			{ $$ = $1 * $3; }
		| edbl '/' edbl			{ $$ = $1 / $3; }
		| edbl '/' expr			{ $$ = $1 / $3; }
		| expr '/' edbl			{ $$ = $1 / $3; }
		;

%%
