/*
 *	regexp.c
 *
 *	Bell V8 K\
 *
 *	* Mon Aug 22 21:52:16 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- Bell V8 K\łB(http://kaworu.jpn.org/doc/FreeBSD/jman/man3/regexp.3.php)
 *	  POSIX.2 K\ł͂܂B(http://linuxjm.osdn.jp/html/LDP_man-pages/man7/regex.7.html)
 *	  POSIX.2 K\͕GŃR[hTCY傫Ȃ̂ŁABell V8 K\ōς܂鎖ɂ܂B
 *	- MINIX 1.7.5 ̃\[X(http://download.minix3.org/previous-versions/gzipped/Intel-1.7.5.tar.gz)Ɋ܂܂ĂA
 *	  /Intel-1.7.5/SYS/src/lib/other/regexp.cɁA폜ĒPč쐬܂B
 *	* Tue Aug 23 21:53:38 JST 2016 Naoyuki Sawa
 *	- LO_̕ύXs܂B
 *	  AvP[V̊ϓ_́AύX̉e͗L܂B
 *	  @regcomp()1pXڂ𔻒肷@ύX܂B
 *	  ܂ł́A(regcode == &regdummy)Ŕ肵Ă܂Aregdummyp~A(regcode == (void*)-1)Ŕ肷悤ɂ܂B
 *	  O҂Ȃ͋@Bŕߊ|܂A҂Ȃ1߂ŔôŁAxR[hTCYǂȂ͂łB
 *	  Aregcomp()̃G[ύX܂B
 *	  ܂ł́AG[oTu[`NULLԂA`dčsɂāAG[sĂ܂B
 *	  ύX́AG[oTu[`regfail()oRlongjmp()𓊓Aregcomp()Lb`悤ɂ܂B
 *	  ̕ύXɂATu[`̖߂l𔻒肷鏈ȗoāAŜ̌ʂǂȂ܂B
 *	  ڍׂ́Aregfail()֐̃Rg,y,regcomp()̏QƂĉB
 *	  Bregcomp()sɎQƂO[oϐp~AX^bNt[ST_RegComp^ϐœn悤ɂ܂B
 *	  regexec()sɎQƂO[oϐp~AX^bNt[ST_RegExec^ϐœn悤ɂ܂B
 *	  ̕ύXɂAregcomp(),y,regexec()Aē\(}`XbhΉ)ƂȂ܂B
 */
#include "clip.h"
/*****************************************************************************
 *	萔A}NA\
 *****************************************************************************/
//Definition		number		operand?	meaning
#undef  END
#define END		 0		//no		End of program.
#undef  BOL
#define BOL		 1		//no		Match "" at beginning of line.
#undef  EOL
#define EOL		 2		//no		Match "" at end of line.
#undef  ANY
#define ANY		 3		//no		Match any one character.
#undef  ANYOF
#define ANYOF		 4		//str		Match any character in this string.
#undef  ANYBUT
#define ANYBUT		 5		//str		Match any character not in this string.
#undef  BRANCH
#define BRANCH		 6		//node		Match this alternative, or the next...
#undef  BACK
#define BACK		 7		//no		Match "", "next" ptr points backward.
#undef  EXACTLY
#define EXACTLY		 8		//str		Match this string.
#undef  NOTHING
#define NOTHING		 9		//no		Match empty string.
#undef  OPEN
#define OPEN		10		//no		Mark this point in input as start of #n.
//      OPEN+1		11
//      OPEN+2		12
//      OPEN+3		13
//      OPEN+4		14
//      OPEN+5		15
//      OPEN+6		16
//      OPEN+7		17
//      OPEN+8		18
//      OPEN+9		19
#undef  CLOSE
#define CLOSE		20		//no		Analogous to OPEN.
//      CLOSE+1		21
//      CLOSE+2		22
//      CLOSE+3		23
//      CLOSE+4		24
//      CLOSE+5		25
//      CLOSE+6		26
//      CLOSE+7		27
//      CLOSE+8		28
//      CLOSE+9		29
/*--------------------------------------------------------------------------*/
#undef  OP
#define OP(p)		(*(p))
#undef  OPERAND
#define OPERAND(p)	((p)+3)
/*--------------------------------------------------------------------------*/
#undef  ISMULT
#define ISMULT(c)	(((c) == '*') || ((c) == '+') || ((c) == '?'))
#undef  META
#define META		"^$.[()|*+?\\"		//e]f͊܂߂ȂɒӂB
/*--------------------------------------------------------------------------*/
typedef struct _ST_RegExp {
//public:
	char*		startp[NSUBEXP];
	char*		endp[NSUBEXP];
//private:
	unsigned char	program[0];
} ST_RegExp;
/*--------------------------------------------------------------------------*/
//Work variables for regcomp().
typedef struct _ST_RegComp {
	jmp_buf			regenv;		//regfail() -> regcomp().
	const unsigned char*	regparse;	//Input-scan pointer.
	int			regnpar;	//() count.
	unsigned char*		regcode;	//Code-emit pointer; (void*)-1 = don't.
	int			regsize;	//Code size.
} ST_RegComp;
/*--------------------------------------------------------------------------*/
//Work variables for regexec().
typedef struct _ST_RegExec {
	const unsigned char*	reginput;	//String-input pointer.
	const unsigned char*	regbol;		//Beginning of input, for ^ check.
	const unsigned char**	regstartp;	//Pointer to startp array.
	const unsigned char**	regendp;	//Ditto for endp.
} ST_RegExec;
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
//Forward declarations for regcomp()'s friends.
__declspec(noreturn) static void regfail(ST_RegComp* pRegComp, const char* errmsg) __attribute__((noreturn));
static unsigned char* regprogram(ST_RegComp* pRegComp, int paren, int* pHasWidth);
static unsigned char* regbranch(ST_RegComp* pRegComp, int* pHasWidth);
static unsigned char* regpiece(ST_RegComp* pRegComp, int* pHasWidth);
static unsigned char* regatom(ST_RegComp* pRegComp, int* pHasWidth);
static unsigned char* regnode(ST_RegComp* pRegComp, int op);
static void regchar(ST_RegComp* pRegComp, int c);
static void reginsert(ST_RegComp* pRegComp, int op, unsigned char* operand);
static void regtail(ST_RegComp* pRegComp, unsigned char* p, unsigned char* val);
static void regoptail(ST_RegComp* pRegComp, unsigned char* p, unsigned char* val);
//Forward declarations for regexec()'s friends.
static int regtry(ST_RegExec* pRegExec, ST_RegExp* prog, const unsigned char* string);
static int regmatch(ST_RegExec* pRegExec, unsigned char* p, int indent/*DEBUG*/);
static unsigned char* regnext(unsigned char* p);
#ifdef  DEBUG
static char* regprop(int op);
#endif//DEBUG
/*****************************************************************************
 *	
 *****************************************************************************/
regexp* regcomp(const char* exp) {
	ST_RegExp* volatile/*x}*/ prog = NULL;	//volatiletȂƁAgcc33.exeŁuwarning: variable `prog' might be clobbered by `longjmp' or `vfork'vƂxo܂B֘AƂāAclipseh.h́u2015/10/11ɍsCeɂĂ̐vQƂĉB
	ST_RegComp stRegComp;
	if(!exp) { DIE(); }	//sBĂяõoOłB
	//K\̃RpCsB
	if(!setjmp(stRegComp.regenv)) {
		int bHasWidth;
		//1pXڂŃR[hŜ̃TCY߂B
		stRegComp.regparse	= exp;			//Input-scan pointer.
		stRegComp.regnpar	= 1;			//() count.	\0ɑÖق()L̂ƌȂB
		stRegComp.regcode	= (void*)-1;		//Code-emit pointer; (void*)-1 = don't.
		stRegComp.regsize	= 0;			//Code size.
		regprogram(&stRegComp, 0/*paren*/, &bHasWidth);
		//m[hԂ̋𕄍n[t[hŕ\߂ɁAR[hŜ̃TCYUSHRT_MAXȉłȂĂ͂ȂȂB
		// - ɂ́A"next"wm[hԂ̋USHRT_MAXȉł΁AR[hŜ̃TCYUSHRT_MAX𒴂ĂĂ\Ȃ̂A
		//   ṕAR[hŜ̃TCYUSHRT_MAXȉɐĂ薳낤B
		if(stRegComp.regsize > USHRT_MAX) { regfail(&stRegComp, "regexp too big"); }
		//mۂB
		prog = malloc(sizeof(ST_RegExp) + stRegComp.regsize);
		if(!prog) { regfail(&stRegComp, "out of space"); }
		//2pXڂŃR[h𐶐B
		stRegComp.regparse	= exp;			//Input-scan pointer.
		stRegComp.regnpar	= 1;			//() count.	\0ɑÖق()L̂ƌȂB
		stRegComp.regcode	= prog->program;	//Code-emit pointer; (void*)-1 = don't.
		regprogram(&stRegComp, 0/*paren*/, &bHasWidth);
		if((stRegComp.regcode - prog->program) != stRegComp.regsize) { DIE(); }	//1pXڂŋ߂R[hŜ̃TCYƁA2pXڂŎۂɐR[hTCY͈v͂łBĂAW[̃oOłB
	//rŃG[āAregerror()IɏԂꍇ́AmɃNULLԂB
	} else {
		free(prog/*NULL*/);
		prog = NULL;
	}
	return (regexp*)prog;
}
/*--------------------------------------------------------------------------*/
//G[
static void regfail(ST_RegComp* pRegComp, const char* errmsg) {
	//ftHg,,AvP[V`́Aregerror()ĂяoB
	regerror(errmsg);
	//regerror()exit()abort()ĂяoďIAւ͓BȂB
	//regerror()Ԃꍇ́Aregcomp()փOWvNULLԂB
	longjmp(pRegComp->regenv, 1);
}
/*--------------------------------------------------------------------------*/
//K\́Ae|fŋ؂ꂽA0ȏ̃u`łB
//u`1ƈv̂ƈv܂B
static unsigned char* regprogram(ST_RegComp* pRegComp, int paren, int* pHasWidth) {
	unsigned char *ret, *br, *ender;
	int no, bHasWidth;
	//bIɁAȂƂ1ȏɃ}b`鎖tOZbgĂB
	*pHasWidth = 1;
	//Make an OPEN node, if parenthesized.
	if(paren) {
		if(pRegComp->regnpar >= NSUBEXP) { regfail(pRegComp, "too many ()"); }
		no = pRegComp->regnpar;	//no=1`9
		pRegComp->regnpar++;
		//'('m[h쐬Au`Ŝ̐擪m[hƌȂB(̎_ł'('m[h"next"tB[h͖ݒłB)
		ret = regnode(pRegComp, OPEN + no);
	} else {
		no = 0;		//not actually used, keep compiler quiet.
		ret = NULL;
	}
	//Pick up the branches, linking them together.
	br = regbranch(pRegComp, &bHasWidth);	//BRANCHm[h,y,ɘAȂÃm[h쐬B(̎_ł͐擪BRANCHm[h"next"tB[h͖ݒłB)
	if(paren) {
		//'('m[h"next"tB[hA擾u`̍ŏBRANCHm[hփNB
		regtail(pRegComp, ret, br);	//OPEN -> first.
	} else {
		//擾Ãm[h̐擪BRANCHm[hAu`Ŝ̐擪m[hƌȂB
		ret = br;
	}
	//󕶎Ƀ}b`u`L΁AȂƂ1ȏɃ}b`鎖tONAB
	*pHasWidth &= bHasWidth;
	//e|fŋ؂ꂽÃu`L΁c
	while(*pRegComp->regparse == '|') {
		//e|f̎֐i߂B
		pRegComp->regparse++;
		//BRANCHm[h,y,ɘAȂÃm[h쐬B(̎_ł͐擪BRANCHm[h"next"tB[h͖ݒłB)
		br = regbranch(pRegComp, &bHasWidth);
		//u`Ŝ̐擪m[hHāAŌBRANCHm[h̎ɁA擾Ãm[h̐擪BRANCHm[hNB
		regtail(pRegComp, ret, br);	//BRANCH -> BRANCH.
		//󕶎Ƀ}b`u`L΁AȂƂ1ȏɃ}b`鎖tONAB
		*pHasWidth &= bHasWidth;
	}
	//Make a closing node, and hook it on the end.
	ender = regnode(pRegComp, paren ? (CLOSE + no) : END);	//')'m[h,,ENDm[h쐬B
	regtail(pRegComp, ret, ender);				//u`Ŝ̐擪m[hHāAŌBRANCHm[h̎ɁA')'m[h,,ENDm[hNB
	//Hook the tails of the branches to the closing node.
	if(pRegComp->regcode != (void*)-1) {	//2pXڂł̂ݎsB1pXڂł͎ۂɃR[h𐶐ĂȂ̂ŁȀ͎soȂB
		for(br = ret; br; br = regnext(br)) {
			regoptail(pRegComp, br, ender);		//eu`̍Ō̃m[hA')'m[h,,ENDm[hւ̃N쐬B
		}
	}
	//Check for proper termination.
	if(paren) {
		if(*pRegComp->regparse != ')') { regfail(pRegComp, "unmatched ()"); }
		pRegComp->regparse++;
	} else {
		if(*pRegComp->regparse == ')') { regfail(pRegComp, "unmatched ()"); }
		if(*pRegComp->regparse != '\0') { regfail(pRegComp, "junk on end"); }	//"Can't happen".
	}
	return ret;
}
/*--------------------------------------------------------------------------*/
//u`́A0ȏ̘As[XłB
//ŏɈv̂ƈvŁAɈv̂ƈv܂
static unsigned char* regbranch(ST_RegComp* pRegComp, int* pHasWidth) {
	unsigned char *ret, *chain;
	int bHasWidth;
	//bIɁAȂƂ1ȏɃ}b`鎖tONAĂB
	*pHasWidth = 0;
	//u`̃m[h쐬B
	ret = regnode(pRegComp, BRANCH);
	//͕̏I[ɓB邩Ae|f,e)fo܂Łc
	chain = NULL;	//Õs[X
	while((*pRegComp->regparse != '\0') && (*pRegComp->regparse != '|') && (*pRegComp->regparse != ')')) {
		//s[X擾B
		unsigned char* latest = regpiece(pRegComp, &bHasWidth);
		//ȂƂ1ȏɃ}b`鎖tO}[WB
		*pHasWidth |= bHasWidth;
		//Õs[XL΁AÕs[X̍Ō̃m[h"next"ɁÃs[XAB
		if(chain) { regtail(pRegComp, chain, latest); }
		//Õs[XLB
		chain = latest;
	}
	//s[X΁Ãu`ƂB
	if(!chain) { regnode(pRegComp, NOTHING); }
	//ŁAu`̃m[h"next"Aŏ̃s[XփNĂ͂ȂɒӂB
	// - u`̃m[h"next"烊ŃÃu`̍ŏ̃s[Xł͂ȂÃu`,,')',,ENDłB
	//   u`̃m[h"next"烊N鏈́A֐ł͂ȂAregprogram()ɗL܂B
	// - vɁA֐Ԃ\́Aȉɂ悤ɂȂĂ܂B(ۂɂpieceƂm[h̎ނ͖̂ŁAEXACTLYłB)
	//   BRANCH{next=0},piece1{next=piece2},piece2{next=piece3},piece3{next=0}
	return ret;
}
/*--------------------------------------------------------------------------*/
//s[X́Ae*f,e+f,e?fƂAgłB
//e*fAǵAAg0ȏ̈ṽV[PXƈv܂B
//e+fAǵAAg1ȏ̈ṽV[PXƈv܂B
//e?fAǵAAg̈vA܂nullXgOƈv܂B
static unsigned char* regpiece(ST_RegComp* pRegComp, int* pHasWidth) {
	unsigned char *ret, *next;
	//Ag擾B
	ret = regatom(pRegComp, pHasWidth);
	//e*f,e+f,e?fĂȂ΁AAgԂB
	if(!ISMULT(*pRegComp->regparse)) { return ret; }
	//"()*""()+"Ȃ΁AG[ƂB
	if(!*pHasWidth && (*pRegComp->regparse != '?')) { regfail(pRegComp, "*+ operand could be empty"); }
	//"()*""()?"Ȃ΁AȂƂ1ȏɃ}b`鎖tONAB
	//"()+"Ȃ΁AȂƂ1ȏɃ}b`鎖tOZbgB
	*pHasWidth = (*pRegComp->regparse == '+');
	//e*f,e+f,e?fɂāc
	switch(*pRegComp->regparse++) {
	default:DIE();	//oO
	case '*':
		//Emit x* as (x&|), where & means "self".
		reginsert(pRegComp, BRANCH, ret);			//Either x	BRANCH1,atom										reginsert()OretatomwĂ邪Areginsert()retBRANCHwĂ鎖ɒӂB
		regoptail(pRegComp, ret, regnode(pRegComp, BACK));	//and loop	BRANCH1,atom{next=BACK},BACK
		regoptail(pRegComp, ret, ret);				//back		BRANCH1,atom{next=BACK},BACK{next=BRANCH1}
		regtail(pRegComp, ret, regnode(pRegComp, BRANCH));	//or		BRANCH1{next=BRANCH2},atom{next=BACK},BACK{next=BRANCH1},BRANCH2
		regtail(pRegComp, ret, regnode(pRegComp, NOTHING));	//null.		BRANCH1{next=BRANCH2},atom{next=BACK},BACK{next=BRANCH1},BRANCH2{next=NOTHING},NOTHING
		break;
	case '+':
		//Emit x+ as x(&|), where & means "self".
		next = regnode(pRegComp, BRANCH);			//Either	atom,BRANCH1
		regtail(pRegComp, ret, next);				//		atom{next=BRANCH1},BRANCH1
		regtail(pRegComp, regnode(pRegComp, BACK), ret);	//loop back	atom{next=BRANCH1},BRANCH1,BACK{next=atom}
		regtail(pRegComp, next, regnode(pRegComp, BRANCH));	//or		atom{next=BRANCH1},BRANCH1{next=BRANCH2},BACK{next=atom},BRANCH2
		regtail(pRegComp, ret, regnode(pRegComp, NOTHING));	//null.		atom{next=BRANCH1},BRANCH1{next=BRANCH2},BACK{next=atom},BRANCH2{next=NOTHING},NOTHING
		break;
	case '?':
		//Emit x? as (x|).
		reginsert(pRegComp, BRANCH, ret);			//Either x	BRANCH1,atom										reginsert()OretatomwĂ邪Areginsert()retBRANCHwĂ鎖ɒӂB
		regtail(pRegComp, ret, regnode(pRegComp, BRANCH));	//or		BRANCH1{next=BRANCH2},atom,BRANCH2
		next = regnode(pRegComp, NOTHING);			//null.		BRANCH1{next=BRANCH2},atom,BRANCH2,NOTHING
		regtail(pRegComp, ret, next);				//		BRANCH1{next=BRANCH2},atom,BRANCH2{next=NOTHING},NOTHING				"next"ݒ肳m[h́Aatomł͂ȂBRANCH2ł鎖ɒӂBregtail()nextHčŝŁABRANCH1Jnatomɂ͓BȂłB
		regoptail(pRegComp, ret, next);				//		BRANCH1{next=BRANCH2},atom{next=NOTHING},BRANCH2{next=NOTHING},NOTHING
		break;
	}
	//e*f,e+f,e?f̌Ɂe*f,e+f,e?fL΁AG[ƂB
	if(ISMULT(*pRegComp->regparse)) { regfail(pRegComp, "nested *+?"); }
	return ret;
}
/*--------------------------------------------------------------------------*/
//AǵA
//ʂň͂܂ꂽK\(K\̈vƈv)A
//͈(LQ)A
//e.f(1LN^ƈv)A
//e^f(̓XgO̍ŏnullXgOƈv)A
//e$f(̓XgO̍ŌnullXgOƈv)A
//1LN^e\f(̃LN^ƈv)A
//̑̈ӖȂ1LN^(̃LN^ƈv)łB
static unsigned char* regatom(ST_RegComp* pRegComp, int* pHasWidth) {
	unsigned char* ret;
	int bHasWidth;
	//bIɁAȂƂ1ȏɃ}b`鎖tONAĂB
	*pHasWidth = 0;
	//̕ɂāc
	switch(*pRegComp->regparse++) {
	case '^':
		{
			ret = regnode(pRegComp, BOL);
		}
		break;
	case '$':
		{
			ret = regnode(pRegComp, EOL);
		}
		break;
	case '.':
		{
			ret = regnode(pRegComp, ANY);
			//ȂƂ1ȏɃ}b`鎖tOZbgB
			*pHasWidth = 1;
		}
		break;
	case '[':
		{
			int class, classend;
			//e[f̒̕e^fȂ΁Aے蕶NXƂB
			if(*pRegComp->regparse == '^') {
				ret = regnode(pRegComp, ANYBUT);	//Complement of range.
				pRegComp->regparse++;			//e^f̎֐i߂B
			} else {
				ret = regnode(pRegComp, ANYOF);
			}
			//NX̍ŏ̕e-f,e]fȂ΁c
			if((*pRegComp->regparse == '-') || (*pRegComp->regparse == ']')) {
				//e-f,e]f^LN^ƌȂɁANẌꕔƂēo^B
				regchar(pRegComp, *pRegComp->regparse++);
			}
			//e]fɓB܂Łc
			while(*pRegComp->regparse != ']') {
				//NXĂȂ΁AG[ƂB
				if(*pRegComp->regparse == '\0') { regfail(pRegComp, "unmatched []"); }
				//NX̍ŏ̕ȊOŁe-foc
				if(*pRegComp->regparse == '-') {
					//e-f̎֐i߂B
					pRegComp->regparse++;
					//NXĂȂ΁AG[ƂB
					if(*pRegComp->regparse == '\0') { regfail(pRegComp, "unmatched []"); }
					//e-fNX̍Ō̕Ȃ΁c
					if(*pRegComp->regparse == ']') {
						//e-f^LN^ƌȂɁANẌꕔƂēo^B
						regchar(pRegComp, '-');
					//e-fNX̍Ō̕łȂ΁c
					} else {
						//͈͂̍ŏ̕R[h+1߂B
						// - +1闝ŔAŏ̕R[h͑Õ[vœo^ς݂łB
						class    = *(pRegComp->regparse - 2) + 1;
						//͈͂̍Ō̕R[h߂B
						classend = *(pRegComp->regparse++);
						//͈͂sȂ΁AG[ƂB
						if((class - 1) > classend) { regfail(pRegComp, "invalid [] range"); }
						//͈͂̕ASēo^B
						while(class <= classend) { regchar(pRegComp, class++); }
					}
				//^LN^ȊOȂ΁c
				} else {
					//o^B
					// - ͈͂̍ŏ̕Aœo^B
					regchar(pRegComp, *pRegComp->regparse++);
				}
			}
			//NX̏I[o^B
			regchar(pRegComp, '\0');
			//e]f̎֐i߂B
			pRegComp->regparse++;
			//ȂƂ1ȏɃ}b`鎖tOZbgB
			*pHasWidth = 1;
		}
		break;
	case '(':
		{
			//e(f`e)f̒p[XB
			ret = regprogram(pRegComp, 1/*paren*/, &bHasWidth);
			//ȂƂ1ȏɃ}b`鎖tO}[WB
			*pHasWidth |= bHasWidth;
		}
		break;
	case '\0':
	case ')':
	case '|':
		{
			regfail(pRegComp, "internal urp");	//Supposed to be caught earlier.
		}
		break;
	case '*':
	case '+':
	case '?':
		{
			//󕶎̌Ɂe*f,e+f,e?fL΁AG[ƂB
			regfail(pRegComp, "*+? follows nothing");
		}
		break;
	case '\\':
		{
			//e\f̌ɕ΁AG[łB
			if(*pRegComp->regparse == '\0') { regfail(pRegComp, "trailing \\"); }
			//e\f̌̕o^B
			ret = regnode(pRegComp, EXACTLY);
			regchar(pRegComp, *pRegComp->regparse++);
			regchar(pRegComp, '\0');
			//ȂƂ1ȏɃ}b`鎖tOZbgB
			*pHasWidth = 1;
		}
		break;
	default:
		{
			int len, ender;
			//̐擪ʒu֖߂B
			pRegComp->regparse--;
			//^LN^ȊOō\Ă镶̒߂B
			len = strcspn(pRegComp->regparse, META);
			if(len < 1) { DIE(); }	//N蓾Ȃ͂B
			//I[^LN^̕擾B
			ender = *(pRegComp->regparse + len);
			//2ȏŁAI[^LN^e*f,e+f,e?f̂ꂩȂ΁ȂΏۂƂȂ镶܂߂ȂB
			if((len > 1) && ISMULT(ender)) { len--; }	//Back off clear of *+? operand.
			if(len < 1) { DIE(); }	//N蓾Ȃ͂B
			//o^B
			ret = regnode(pRegComp, EXACTLY);
			do { regchar(pRegComp, *pRegComp->regparse++); } while(--len);
			regchar(pRegComp, '\0');
			//ȂƂ1ȏɃ}b`鎖tOZbgB
			*pHasWidth = 1;
		}
		break;
	}
	return ret;
}
/*--------------------------------------------------------------------------*/
//R[h̖ɁAR[h𐶐B
static unsigned char* regnode(ST_RegComp* pRegComp, int op) {
	//1pXڂȂ΁AR[hTCY𑝂₵āAR[h𐶐ȂB
	if(pRegComp->regcode == (void*)-1) {	//1pX
		pRegComp->regsize += 3;
		return pRegComp->regcode;
	}
	*pRegComp->regcode++ = op;
	*pRegComp->regcode++ = 0;	//Null "next" pointer.
	*pRegComp->regcode++ = 0;	//
	return pRegComp->regcode - 3;
}
/*--------------------------------------------------------------------------*/
//R[h̖ɁAǉB
static void regchar(ST_RegComp* pRegComp, int c) {
	//1pXڂȂ΁AR[hTCY𑝂₵āAR[h𐶐ȂB
	if(pRegComp->regcode == (void*)-1) {	//1pX
		pRegComp->regsize++;
	} else {
		*pRegComp->regcode++ = c;
	}
}
/*--------------------------------------------------------------------------*/
//ς݂̃R[h̓ŕAoperand̈ʒuȍ~3oCgɂ炵A󂢂ʒuɃR[h𐶐B
static void reginsert(ST_RegComp* pRegComp, int op, unsigned char* operand) {
	unsigned char *src, *dst;
	//1pXڂȂ΁AR[hTCY𑝂₵āAR[h𐶐ȂB
	if(pRegComp->regcode == (void*)-1) {	//1pX
		pRegComp->regsize += 3;
		return;
	}
	//ς݂̃R[h̓ŕAoperand̈ʒuȍ~3oCgɂ炵A󂢂ʒuɃR[h𐶐B
	src = pRegComp->regcode;
	pRegComp->regcode += 3;
	dst = pRegComp->regcode;
	while(src > operand) { *--dst = *--src; }
	*operand++ = op;	//Op node, where operand used to be.
	*operand++ = 0;		//Null "next" pointer.
	*operand++ = 0;		//
}
/*--------------------------------------------------------------------------*/
//m[hpJnāA"next"tB[hݒ肳ĂȂAŌ̃m[hB
//Ō̃m[h"next"tB[hɁAŌ̃m[hƃm[hval̃ItZbgi[B
static void regtail(ST_RegComp* pRegComp, unsigned char* p, unsigned char* val) {
	int offset;
	//1pXڂȂΉȂB
	// - ̊֐́ÃR[h"next"tB[h邾Ȃ̂ŁAR[hTCY߂鏈ɂ͊֌WL܂B
	//   ̊֐́ÃR[hH鏈܂ނ̂ŁAR[h𐶐ĂȂ1pXڂł͂ȍ~͎̏so܂B
	if(p == (void*)-1) { return; }	//1pX
	//p猟JnāA"next"tB[hݒ肳ĂȂAŌ̃m[hB
	for(;;) {
		unsigned char* next = regnext(p);
		if(!next) { break; }
		p = next;
	}
	//"next"tB[hݒ肳ĂȂŌ̃m[h'BACK'Ȃ΁c
	if(OP(p) == BACK) {
		//valŎw肳ꂽm[hAŌ̃m[hւ́AItZbg߂B
		offset = p - val;
		if((unsigned)offset > USHRT_MAX) { DIE(); }	//1pXڂŃR[hŜ̃TCYUSHRT_MAXȉł鎖mFς݂Ȃ̂ŁAm[hԂ̋USHRT_MAX𒴂邱Ƃ͋N蓾Ȃ͂BŃG[~瓖W[̃oOłB
	//"next"tB[hݒ肳ĂȂŌ̃m[h'BACK'ȊOȂ΁c
	} else {
		//Ō̃m[hAvalŎw肳ꂽm[hւ́AItZbg߂B
		offset = val - p;
		if((unsigned)offset > USHRT_MAX) { DIE(); }	//1pXڂŃR[hŜ̃TCYUSHRT_MAXȉł鎖mFς݂Ȃ̂ŁAm[hԂ̋USHRT_MAX𒴂邱Ƃ͋N蓾Ȃ͂BŃG[~瓖W[̃oOłB
	}
	//Ō̃m[h"next"tB[hݒ肷B
	p[1] = offset >> 8;	//16rbgBE
	p[2] = offset;		//
}
/*--------------------------------------------------------------------------*/
//m[hp̃Iyh̃m[hɑ΂āAregtail()ĂяoB
//m[hpBRANCHm[hȊOȂ΁AIyh,,Iyh̓m[hł͂Ȃ̂ŁAȂB
//(m[hpBRANCHm[hȊOƂȂP[X́Aregprogram()A'(',')',ENDɑ΂ČĂяoꍇ݂̂ƎvB)
// - ̊֐͖OƎv܂B
//   ŏA'reg-OPerator-tail'̗ƎvĂāA֐Ȃ̂oɔY݂܂B
//   ́A'reg-OPerand-tail'̗łB
//   u`̈Ãm[h̍Ō̃m[hAm[hvalւ̃N쐬邽߂̊֐łB
static void regoptail(ST_RegComp* pRegComp, unsigned char* p, unsigned char* val) {
	//"Operandless" and "op != BRANCH" are synonymous in practice.
	if((p == (void*)-1) || (OP(p) != BRANCH)) { return; }	//\[Xɂ(!p)O锻fĂA֐(!p)ŌĂяo鎖͖͂Ȃ̂ŁA(!p)O锻f͕sv낤BA\[X̓G[NULLœ`dčs߂ɁA(!p)OĂ̂낤Bł́AG[longjmp()ŏ̂ŁA(!p)O锻f͕svB
	regtail(pRegComp, OPERAND(p), val);
}
/*****************************************************************************
 *	
 *****************************************************************************/
int regexec(regexp* prog, const char* string) {
	ST_RegExec stRegExec;
	//Be paranoid...
	if(!prog || !string) { DIE(); }	//sBĂяõoOłB
	//Mark beginning of line for ^.
	stRegExec.regbol = string;
	//Messy cases: unanchored match.
	do {
		if(regtry(&stRegExec, (ST_RegExp*)prog, string)) { return 1; }	//(string=="")
	} while(*string++);							//(string=="")Ȃ΃[v𔲂B
	//Failure.
	return 0;
}
/*--------------------------------------------------------------------------*/
//0 failure, 1 success
static int regtry(ST_RegExec* pRegExec, ST_RegExp* prog, const unsigned char* string) {
//{{memset()̎g͑Sɂ炸VC++6.0ł͌xôňꎞIɌx}ĉB
#ifdef  _MSC_VER
#pragma warning(disable:4090)	//'function' : 'const' Cq͈قȂ܂B
#pragma warning(disable:4022)	//'memset' : 1 Ԗڂ߲̎̌^Ǎ߲^ƈقȂ܂B
#endif//_MSC_VER
	memset(prog->startp, 0, sizeof prog->startp);
	memset(prog->endp,   0, sizeof prog->endp  );
#ifdef  _MSC_VER
#pragma warning(default:4090)	//'function' : 'const' Cq͈قȂ܂B
#pragma warning(default:4022)	//'memset' : 1 Ԗڂ߲̎̌^Ǎ߲^ƈقȂ܂B
#endif//_MSC_VER
//}}memset()̎g͑Sɂ炸VC++6.0ł͌xôňꎞIɌx}ĉB
	pRegExec->reginput  = string;
	pRegExec->regstartp = (const unsigned char**)prog->startp;
	pRegExec->regendp   = (const unsigned char**)prog->endp;
	if(!regmatch(pRegExec, prog->program, 0/*DEBUG*/)) { return 0; }
	pRegExec->regstartp[0] = string;
	pRegExec->regendp[0] = pRegExec->reginput;
	return 1;
}
/*--------------------------------------------------------------------------*/
//0 failure, 1 success
static int regmatch(ST_RegExec* pRegExec, unsigned char* p, int indent/*DEBUG*/) {
	while(p) {
		unsigned char* next = regnext(p);	//Next node.
#ifdef  DEBUG
		if(regnarrate) {
			int op = OP(p);
			fprintf(stderr, "%*s%s", indent * 2/**/, "", regprop(op));
			if((op == ANYOF) || (op == ANYBUT) || (op == EXACTLY)) {
				fprintf(stderr, "(%s)", OPERAND(p));
			}
			fputc('\n', stderr);
		}
#endif//DEBUG
		switch(OP(p)) {
		default:DIE();	//memory corruption
		case END:
			return 1;	//Success!
		case BOL:
			if(pRegExec->reginput != pRegExec->regbol) { return 0; }
			break;
		case EOL:
			if(*pRegExec->reginput != '\0') { return 0; }
			break;
		case ANY:
			if(*pRegExec->reginput == '\0') { return 0; }
			pRegExec->reginput++;
			break;
		case ANYOF:
			if((*pRegExec->reginput == '\0') || !strchr(OPERAND(p), *pRegExec->reginput)) { return 0; }
			pRegExec->reginput++;
			break;
		case ANYBUT:
			if((*pRegExec->reginput == '\0') ||  strchr(OPERAND(p), *pRegExec->reginput)) { return 0; }
			pRegExec->reginput++;
			break;
		case BRANCH:
			{
				if(OP(next) == BRANCH) {
					do {
						const unsigned char* save = pRegExec->reginput;
						if(regmatch(pRegExec, OPERAND(p), indent + 1)) { return 1; }
						pRegExec->reginput = save;
						p = regnext(p);
					} while(p && (OP(p) == BRANCH));
					return 0;
				}
				next = OPERAND(p);	//Avoid recursion.
			}
			break;
		case BACK:
			/** no job **/
			break;
		case EXACTLY:
			{
				unsigned char* operand = OPERAND(p);
				int len = strlen(operand);
				if(strncmp(operand, pRegExec->reginput, len)) { return 0; }
				pRegExec->reginput += len;
			}
			break;
		case NOTHING:
			/** no job **/
			break;
	//sv	case OPEN+0:	//\0regtry()ŖIɏ̂ŁAOPEN+0̃m[h͐ȂB
		case OPEN+1:
		case OPEN+2:
		case OPEN+3:
		case OPEN+4:
		case OPEN+5:
		case OPEN+6:
		case OPEN+7:
		case OPEN+8:
		case OPEN+9:
			{
				int no = OP(p) - OPEN;
				const unsigned char* save = pRegExec->reginput;
				if(!regmatch(pRegExec, next, indent + 1)) { return 0; }
				//Don't set startp if some later invocation of the same parentheses already has.
				// - JԂ̒()LꍇAԍŌɃ}b`LƂӖłB
				//   Ⴆ΁A"ABC"ɑ΂āAK\/(.)+/KpꍇA\1"C"w܂B
				if(!pRegExec->regstartp[no]) { pRegExec->regstartp[no] = save; }
				return 1;
			}
			break;
	//sv	case CLOSE+0:	//\0regtry()ŖIɏ̂ŁACLOSE+0̃m[h͐ȂB
		case CLOSE+1:
		case CLOSE+2:
		case CLOSE+3:
		case CLOSE+4:
		case CLOSE+5:
		case CLOSE+6:
		case CLOSE+7:
		case CLOSE+8:
		case CLOSE+9:
			{
				int no = OP(p) - CLOSE;
				const unsigned char* save = pRegExec->reginput;
				if(!regmatch(pRegExec, next, indent + 1)) { return 0; }
				//Don't set endp if some later invocation of the same parentheses already has.
				// - JԂ̒()LꍇAԍŌɃ}b`LƂӖłB
				//   Ⴆ΁A"ABC"ɑ΂āAK\/(.)+/KpꍇA\1"C"w܂B
				if(!pRegExec->regendp[no]) { pRegExec->regendp[no] = save; }
				return 1;
			}
			break;
		}
		p = next;
	}
	//We get here only if there's trouble -- normally "case END" is the terminating point.
	DIE();
}
/*--------------------------------------------------------------------------*/
//m[hp"next"tB[hHāÃm[hԂB
//"next"tB[hݒ肳ĂȂ΁ANULLԂB
// - \[Xł́A֐regcomp()1pXڂɌĂяoꂽꍇ́A_~[ƂNULLԂ悤ɂȂĂAhB
//   ŁAĂяoɂāA֐regcomp()1pXڂł͌ĂяoȂ悤ɕύXāA֐ł1pXڂ̔폜B
// - AۂɔǉKv̂́Aregprogram()́ufor(br = ret; br; br = regnext(br)) {v̉ӏłB
//   ȊỎӏ(ƌĂregtail())ł́AXAregcomp()1pXڂłregnext()ĂяoȂ悤ɂȂĂB
static unsigned char* regnext(unsigned char* p) {
	int offset;
	offset = (p[1] << 8) | p[2];	//16rbgBE
	if(!offset) { return NULL; }
	if(OP(p) == BACK) {
		return p - offset;
	} else {
		return p + offset;
	}
}
/*****************************************************************************
 *	
 *****************************************************************************/
void regsub(const regexp* prog, const char* source, char* dest) {
	int c;
	if(!prog || !source || !dest) { DIE(); }	//sBĂяõoOłB
	while((c = *source++)) {
		int no = -1;
		if(c == '&') {
			no = 0;
		} else if((c == '\\') && (*source >= '0') && (*source <= '9')) {
			no = *source++ - '0';
		}
		if(no == -1) {	//Ordinary character.
			if(c == '\\' && ((*source == '&') || (*source == '\\'))) { c = *source++; }
			*dest++ = c;
		} else {
			if(prog->startp[no] && prog->endp[no]) {
				int len = prog->endp[no] - prog->startp[no];
				if((int)strnlen(prog->startp[no], len) < len) { DIE(); }	//W[̃oO,,j
				strncpy(dest, prog->startp[no], len);
				dest += len;
			}
		}
	}
	*dest++ = '\0';
}
/*****************************************************************************
 *	fobOp
 *****************************************************************************/
#ifdef  DEBUG
int regnarrate;
/*--------------------------------------------------------------------------*/
void regdump(const regexp* _prog) {
	ST_RegExp* prog = (ST_RegExp*)_prog;
	unsigned char* p = prog->program;
	for(;;) {
		int op = OP(p);
		unsigned char* next = regnext(p);
		printf("%d:%s", p - prog->program, regprop(op));		//Where, what.
		printf("(%d)", next ? ((p - prog->program) + (next - p)) : 0);	//Next ptr.
		p = OPERAND(p);
		if((op == ANYOF) || (op == ANYBUT) || (op == EXACTLY)) {
			fputs(p, stdout);
			p += strlen(p) + 1/*'\0'*/;
		}
		putchar('\n');
		if(op == END) { break; }
	}
}
/*--------------------------------------------------------------------------*/
static char* regprop(int op) {
	static char buf[16];
	const char* s = NULL;
	switch(op) {
	default:DIE();	//oO
	case BOL:	s = "BOL";	break;
	case EOL:	s = "EOL";	break;
	case ANY:	s = "ANY";	break;
	case ANYOF:	s = "ANYOF";	break;
	case ANYBUT:	s = "ANYBUT";	break;
	case BRANCH:	s = "BRANCH";	break;
	case BACK:	s = "BACK";	break;
	case EXACTLY:	s = "EXACTLY";	break;
	case NOTHING:	s = "NOTHING";	break;
	case END:	s = "END";	break;
//sv	case OPEN+0:	//\0regtry()ŖIɏ̂ŁAOPEN+0̃m[h͐ȂB
	case OPEN+1:
	case OPEN+2:
	case OPEN+3:
	case OPEN+4:
	case OPEN+5:
	case OPEN+6:
	case OPEN+7:
	case OPEN+8:
	case OPEN+9:	sprintf(buf, "OPEN%d", op - OPEN);	break;
//sv	case CLOSE+0:	//\0regtry()ŖIɏ̂ŁACLOSE+0̃m[h͐ȂB
	case CLOSE+1:
	case CLOSE+2:
	case CLOSE+3:
	case CLOSE+4:
	case CLOSE+5:
	case CLOSE+6:
	case CLOSE+7:
	case CLOSE+8:
	case CLOSE+9:	sprintf(buf, "CLOSE%d", op - CLOSE);	break;
	}
	if(s) { strcpy(buf, s); }
	return buf;
}
#endif//DEBUG
