/*
 *	obstack.h
 *
 *	Obstack - Pool of memory containing a stack of objects.
 *
 *	* Mon Oct 05 21:33:13 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- uObstackv(http://gcc.gnu.org/onlinedocs/libiberty/Obstacks.html)݊W[łB
 *	  ֐dĺuObstackvƓŁA͓ƎłB
 *	  IWił́uObstackv͑xdĂ╡GłA͒PɎ܂B
 *	- ֐dlg̐́AL̃hLg̑Aȉ̃hLgQlɂȂ܂B
 *	  uWikipedia - Obstackv(http://en.wikipedia.org/wiki/Obstack)
 *	  uIBM developerWorks Japan - [Ǘ̓v(http://www.ibm.com/developerworks/jp/linux/library/l-memory/)
 *	* Tue Oct 06 23:01:47 JST 2015 Naoyuki Sawa
 *	- obstack_free()objectwΉ܂B
 *	  objectNULLȊOw肷ƁAobjectȍ~(object܂)ɍ쐬IuWFNgJ܂B
 *	  ƂۂɂȏsP[X͂قƂǖAobstack_free()objectɂNULLw肷Ǝv܂B
 *	  BAobjectw肪ɗP[XƂẮAL̗p@炢łB
 *	  obstack_free(o,obstack_base(o)); //ݍ쐬̃IuWFNg̏Ԃ0oCgɖ߂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __OBSTACK_H__
#define __OBSTACK_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	
 ****************************************************************************/
//uGNU libiberty - 2.3.1 Obstacksv(http://gcc.gnu.org/onlinedocs/libiberty/Obstacks.html)
//2.3.1.1 Creating Obstacks
struct obstack {
	struct _obstack_chunk*	chunk;
};
/*--------------------------------------------------------------------------*/
//2.3.1.2 Preparing for Using Obstacks
void obstack_init(struct obstack* o);
//2.3.1.3 Allocation in an Obstack
void* obstack_alloc(struct obstack* o, int size);
void* obstack_copy(struct obstack* o, void* data, int size);
void* obstack_copy0(struct obstack* o, void* data, int size);
//2.3.1.4 Freeing Objects in an Obstack
void obstack_free(struct obstack* o, void* object);
//2.3.1.6 Growing Objects
void obstack_blank(struct obstack* o, int size);
void obstack_grow(struct obstack* o, void* data, int size);
void obstack_grow0(struct obstack* o, void* data, int size);
void obstack_1grow(struct obstack* o, int data);
void obstack_ptr_grow(struct obstack* o, void* data);
void obstack_int_grow(struct obstack* o, int data);
void* obstack_finish(struct obstack* o);
//2.3.1.7 Extra Fast Growing Objects
int obstack_room(struct obstack* o);
void obstack_blank_fast(struct obstack* o, int size);
void obstack_1grow_fast(struct obstack* o, int data);
void obstack_ptr_grow_fast(struct obstack* o, void* data);
void obstack_int_grow_fast(struct obstack* o, int data);
//2.3.1.8 Status of an Obstack
void* obstack_base(struct obstack* o);
void* obstack_next_free(struct obstack* o);
int obstack_object_size(struct obstack* o);
//2.3.1.9 Alignment of Data in Obstacks
#define obstack_alignment_mask(o)	(3)
//2.3.1.10 Obstack Chunks
#define obstack_chunk_size(o)		(1024)
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__OBSTACK_H__
