/*
 *	glob.c
 *
 *	p^[Ƀ}b`pXt(POSIX֐)
 *
 *	* Tue May 17 21:36:02 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  QƎ:uLinux Programmer's Manual (3) - GLOBv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/glob.3.html)
 *	- ܂AWin32p܂B
 *	  glob()́Ascandir()ƈāAr̃tH_ɂChJ[hĝŁAWindowsvO~Oł֗ɎgƎvłB
 *	- P/ECEṕAłB
 *	  P/ECEɂ̓tH_̂ŁAscandir()gĂقƂǓƎv܂B
 *	* Tue May 17 23:11:10 JST 2016 Naoyuki Sawa
 *	- P/ECEp܂B
 *	  scandir()ł͂ȂAreaddir()fnmatch()gĎ܂B
 *	  ̕Ղ炻łAʂscandir()gꍇƂقƂǓłB
 *	* Wed May 18 21:26:51 JST 2016 Naoyuki Sawa
 *	- Win32pglob()patternɐ΃pX(uC:\Foo\`vu\Foo\`v)w肳ꂽɁAăJgtH_̑΃pXƂďĂ܂ĂoOC܂B
 *	  _findfirst()fileinfo.nameɊi[pX̃[ϓIłȂ߁Aglob(),y,glob_subr()̏Ȃ蕡GŔhȂĂ܂܂B
 *	  ڍׂ́Aglob(),y,glob_subr()̃RgQƂĉB
 *	  ꌩAʂȏsĂ悤Ɍ镔L邩܂񂪁AꂼɈӖL܂B
 *	  spӂɕςƐ삵ȂȂ鋰ꂪL̂ŁAӂĉB
 *	- Rg̒ŁApXZp[^'\''/'̕ЕɂďĂӏL܂A'\''/'ΉĂ܂B
 *	  glob()pattern̒ŎgppXZp[^ƂẮA'\''/'gp\łB
 *	  AW[gl_pathvɏo͂pXZp[^ƂẮA'\'gpĂ܂B
 *	- glob.c̈ԉɁAugp (Win32)v܂B
 */
#include "clip.h"
/*****************************************************************************
 *	glob (Win32p)
 *****************************************************************************/
#ifdef  WIN32
//drivedirꏏɂĂ͂ȂBR͈ȉ̒ʂ:
//_findfirst("C:Foo",`)ɑ΂ă}b`ƁAfileinfo.name"C:Foo"ł͂Ȃ"Foo"ɂȂ悤B
//drivedirꏏɂāAglob()̍ŏ̌Ăяoargv[0]="C:Foo"ɂȂĂƁAfileinfo.name"Foo"Ȃ̂ŁAglob_subr()makepath()s_"C:"Ă܂B
//ʂ̓JghCuC:ŌΏۂC:낤Aʂ͖Ȃ̂A
//JghCuD:ŁAuC:Foo/Bar/Bazv悤ƂɁAiڂglob_subr()D:ɑ΂čsĂ܂A肪B
//L̖邽߂ɁAdrive͕ĕێĂKvLB
//Aglob()patternɃhCu܂܂ĂȂꍇ́Aglob()̏drive=""ƂȂ̂drive=NULLɂȂ鎖͖AŖ薳B
static void glob_subr(const char* drive, const char* dir/*NULL*/, char** argv, glob_t* pglob) {
	char path[MAX_PATH], *fname;
	struct _finddata_t fileinfo;
	long hfind;
	//pXvf(ChJ[hWJ)擾ApXvfւ̃|C^֐i߂B
	fname = *argv++;
	//pXvf(ChJ[hWJ)L΁c
	if(fname) {
		//̃pX(ChJ[hWJς)ɁApXvf(ChJ[hWJ)ǉāAp^[(ChJ[hWJ)gݗĂB
		makepath(path, drive, dir/*NULL*/, fname/*NULL*/, NULL);
		//̃p^[(ChJ[hWJ)Ƀ}b`Aŏ̃t@C,,tH_擾B
		hfind = _findfirst(path, &fileinfo);
		//̃p^[(ChJ[hWJ)Ƀ}b`At@C,,tH_L΁c
		if(hfind != -1) {
			do {
				//ftHgł́A^LN^[͐擪̃sIhɂ̓}b`łȂB(GLOB_PERIOD̃RgQ)
				if((fileinfo.name[0] == '.') && (fname[0] != '.')) { continue; }	//}b`t@C̈ꕶڂ'.'ŁApXvf(ChJ[hWJ)̈ꕶڂ'.'łȂ΁AOBȂƁAglob("*/*",`)ŌĂяoɁA"../foo","../bar",cɂ}b`Ă܂B
//{{v!!_findfirst(".",`)ɑ΂fileinfo.name"."ł͂Ȃ{̃tH_("test.win")Ԃ悤ŁÂ܂܎gƃJgtH_ōċAłȂ肪BlɁA_findfirst("..",`)ɑ΂fileinfo.name".."ł͂Ȃ{̃tH_("clip")Ԃ悤ŁÂ܂܎gƐetH_֍ċAčsȂȂ肪Bd̂ŁAp^[".",,".."Ȃ΁A_findfirst()Ԃfileinfo.nameAp^[̂(".",,"..")ŏ㏑ĉ鎖ɂBYȕ@ł͂ȂAӐ}ʂ̌ʂɂ͂ȂB
				if(!strcmp(fname, ".") || !strcmp(fname, "..")) {		//̎Afileinfo.nameɂ́Aۂ̃tH_i[Ă܂ĂB
					if(sizeof fileinfo.name <= strlen(fname)) { DIE(); }	//Ôfileinfo.name̗eʂmFBۂɂ_finddata_t.name[260]vȂ͂B
					strcpy(fileinfo.name, fname);				//_findfirst()Ԃfileinfo.nameAp^[̂(".",,"..")ŏ㏑B
				}
//}}v!!_findfirst(".",`)ɑ΂fileinfo.name"."ł͂Ȃ{̃tH_("test.win")Ԃ悤ŁÂ܂܎gƃJgtH_ōċAłȂ肪BlɁA_findfirst("..",`)ɑ΂fileinfo.name".."ł͂Ȃ{̃tH_("clip")Ԃ悤ŁÂ܂܎gƐetH_֍ċAčsȂȂ肪Bd̂ŁAp^[".",,".."Ȃ΁A_findfirst()Ԃfileinfo.nameAp^[̂(".",,"..")ŏ㏑ĉ鎖ɂBYȕ@ł͂ȂAӐ}ʂ̌ʂɂ͂ȂB
				//̃pX(ChJ[hWJς)ɁA}b`t@C,,tH_ǉāAVpX(ChJ[hWJς)gݗĂB
				makepath(path, NULL, dir/*NULL*/, fileinfo.name, NULL);
				//             ~~~~drive͌ʂglob_subr()ɓn̂ŃpXɑgݍ܂Ȃ悤ɒӂB
				//̍ċAĂяoB                 
				glob_subr(drive, path, argv, pglob); //
				//        ~~~~~
			} while(!_findnext(hfind, &fileinfo));	//Ƀ}b`t@C(̓tH_)LԁAJԂB
			//nhB
			if(_findclose(hfind)) { DIE(); }
		}
	//pXvf(ChJ[hWJ)΁c	܂AO̍ċAargv̖Ȃ΁c
	} else {
		//O̍ċAőgݗĂVpX(ChJ[hWJς)L΁c	vɁA΃pXwglob()̍ŏ̍ċAĂяołȂ΁c
		if(dir) {
			//̃pX(ChJ[hWJς)ɁAdrive(w肳Ă)gݍ񂾕gݗĂB
			makepath(path, drive, NULL, dir, NULL);	//dirfnameƌȂđgݗĂBumakepath(path,drive,dir,NULL,NULL)vł͕sBȂƖɗ]v'\'tĂ܂B
			//O̍ċAőgݗĂVpX(ChJ[hWJς)ɁAdrive(w肳Ă)gݍ񂾕A}b`pX̃XgɒǉB
			strv_extend(&pglob->gl_pathv, path);			//    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~YȂ悤!!ustrv_extend(&pglob->gl_pathv,dir)vł͕sBȂglob("C:\Foo",`)̌ʂ"\Foo"ɂȂĂ܂BhCuw肵ꍇ͌ʂɂhCu܂߂"C:\Foo"ɂȂ̂B
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int glob(const char* pattern, int flags, int (*errfunc)(const char* epath, int eerrno), glob_t* pglob) {
	if(flags || errfunc) { DIE(); }	//́Aflags,y,errfuncɖΉłBflags,,errfunc0(NULL)ȊOw肵glob()ĂяoƁAG[~܂B
	//̃Xg쐬B
	pglob->gl_pathv = strv_new(NULL);
	{
		char path[MAX_PATH], drive[MAX_DRIVE], dir[MAX_DIR], fname[MAX_FNAME], ext[MAX_EXT];
		//p^[(ChJ[hWJ)A\vfɕB
		splitpath(pattern, drive, dir, fname, ext);
		//hCu\vfAhCup^[(ChJ[hWJ)ɍB
		makepath(path, NULL, dir, fname, ext);
		//hCup^[(ChJ[hWJ)󕶎ꍇ́AȂB
		// - ȉ̏𔻂Ղ邽߂ɁApath=""̃P[X͍ŏɏOĂɂB
		if(*path) {
			//hCup^[(ChJ[hWJ)ApXvf(ChJ[hWJ)ɕB
			char** argv = strsplit_set(path, "/\\", 0);
			//hCup^[(ChJ[hWJ)A΃pXwȂ΁c
			// - Ȃ݂ɁA'if(!PathIsRelative(pattern)){'ł͏肭ȂB
			//   PathIsRelative()́AuC:Foov΃pXƌȂFALSEԂĂ܂悤(oOł?)B
			//   PathIsRelative̖ɂĂ͉L̃tH[łwEĂ:
			//   uStack Overflow - Is it a WinAPI Bug with PathIsRelative function?v(http://stackoverflow.com/questions/26099361/is-it-a-winapi-bug-with-pathisrelative-function)
			// - d̂ŁAŔf鎖ɂB
			//   argv[0]󕶎ɂȂ̂́Apatḧꕶڂ'\',,'/'ꍇ݂̂łB
			//   ]āAargv[0]󕶎Ȃΐ΃pX,argv[0]󕶎łȂΑ΃pXƔoB
			if(*argv[0]) {	//argv[0]󕶎łȂ΁c
				//ŏ̍ċAĂяoB
				glob_subr(drive, NULL, &argv[0], pglob);
			//hCup^[(ChJ[hWJ)A΃pXwȂ΁c
			} else {	//argv[0]󕶎Ȃ΁c
				//ŏ̍ċAĂяoB
				// - ΃pX'\'́Aargv[1]̐擪ɕt^Ă͂ȂB
				//   argv[1]̐擪ɕt^ƁA_findfirst("\\usr")ɑ΂ă}b`ꍇAfileinfo.name="usr"ɂȂA΃pX'\'Ă܂B
				//   L̂悤glob_subr()ւdirēn΁A_findfirst()̌ʂŒu鎖͖̂ŁA'\'鎖͖B
				glob_subr(drive, "\\", &argv[1], pglob);	//argv[0]󕶎Ȃ̂ŁAargv[1]JnB
			}
			//pXvf(ChJ[hWJ)JB
			strv_free(argv);
		}
	}
	//ftHgł́AԂpX̓\[gB(GLOB_NOSORT̃RgQ)
	strv_sort(pglob->gl_pathv);
	//}b`pX̐i[B
	pglob->gl_pathc = strv_length(pglob->gl_pathv);
	//}b`Ȃ΁ÃXgJāAGLOB_NOMATCHԂB
	if(!pglob->gl_pathc) {
		globfree(pglob);
		return GLOB_NOMATCH;	//̌AAvP[Vglobfree()ĂяoKv͖B
	}
	//ł}b`0ԂB
	return 0;			//̌AAvP[Vglobfree()ĂяoKvLB
}
#endif//WIN32
/*****************************************************************************
 *	glob (P/ECEp)
 *****************************************************************************/
#ifdef  PIECE
int glob(const char* pattern, int flags, int (*errfunc)(const char* epath, int eerrno), glob_t* pglob) {
	if(flags || errfunc) { DIE(); }	//́Aflags,y,errfuncɖΉłBflags,,errfunc0(NULL)ȊOw肵glob()ĂяoƁAG[~܂B
	//̃Xg쐬B
	pglob->gl_pathv = strv_new(NULL);
	{
		struct dirent* e;
		//tH_JB
		DIR* d = opendir(".");	//Cuopendir()͕̎KBclipdire.cQƂB
		//et@Cɂāc
		while((e = readdir(d))) {
			//p^[Ƀ}b`t@CȂ΁c
			if(!fnmatch(pattern, e->d_name, 0)) {	//fnmatch()̓}b`0ԂɒӂB
				//}b`pX̃XgɒǉB
				strv_extend(&pglob->gl_pathv, e->d_name);
			}
		}
		//tH_B
		closedir(d);
	}
	//ftHgł́AԂpX̓\[gB(GLOB_NOSORT̃RgQ)
	strv_sort(pglob->gl_pathv);
	//}b`pX̐i[B
	pglob->gl_pathc = strv_length(pglob->gl_pathv);
	//}b`Ȃ΁ÃXgJāAGLOB_NOMATCHԂB
	if(!pglob->gl_pathc) {
		globfree(pglob);
		return GLOB_NOMATCH;	//̌AAvP[Vglobfree()ĂяoKv͖B
	}
	//ł}b`0ԂB
	return 0;			//̌AAvP[Vglobfree()ĂяoKvLB
}
#endif//PIECE
/*****************************************************************************
 *	globfree ()
 *****************************************************************************/
void globfree(glob_t* pglob) {
	//}b`pX̃XgJB
	strv_free(pglob->gl_pathv/*NULL*/);
	//Ŝ߁A\̂NAĂB
	// - Ă΁AApglobɑ΂čēxglobfree()Ă΂ĂA_~[ƂȂB(strv_free(NULL)͈S)
	memset(pglob, 0, sizeof(glob_t));
}
/*****************************************************************************
 *	gp (Win32)
 *****************************************************************************/
#if 0
//ȉ̎gpł̓ChJ[h'*'gĂ܂A'?'gp\łB
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵΃pX̗
void testA1() {
	glob_t g;
	if(!glob("C:\\usr\\PIECE\\app\\adpcm\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//C:\usr\PIECE\app\adpcm\hello.c
//C:\usr\PIECE\app\adpcm\ose16.c
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵΃pXŁArɃChJ[hg
void testA2() {
	glob_t g;
	if(!glob("C:\\usr\\PIECE\\app\\*\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//C:\usr\PIECE\app\BlackWings\after.c
//C:\usr\PIECE\app\BlackWings\decode.c
//`
//C:\usr\PIECE\app\adpcm\hello.c
//C:\usr\PIECE\app\adpcm\ose16.c
//C:\usr\PIECE\app\gamepad\gamepad.c
//C:\usr\PIECE\app\hello\hello.c
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵Ȃ΃pX̗
void testA3() {
	glob_t g;
	if(!glob("\\usr\\PIECE\\app\\adpcm\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//\usr\PIECE\app\adpcm\hello.c
//\usr\PIECE\app\adpcm\ose16.c
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵Ȃ΃pXŁArɃChJ[hg
void testA4() {
	glob_t g;
	if(!glob("\\usr\\PIECE\\app\\*\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//\usr\PIECE\app\BlackWings\after.c
//\usr\PIECE\app\BlackWings\decode.c
//`
//\usr\PIECE\app\adpcm\hello.c
//\usr\PIECE\app\adpcm\ose16.c
//\usr\PIECE\app\gamepad\gamepad.c
//\usr\PIECE\app\hello\hello.c
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵΃pX̗
void testR1() {
	glob_t g;
	_chdir("C:\\usr\\PIECE\\app");
	_chdrive(4);	//1=A,2=B,3=C,4=D,...	JghCuD:ɂB
	if(!glob("C:adpcm\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//C:adpcm\hello.c
//C:adpcm\ose16.c
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵΃pXŁArɃChJ[hg
void testR2() {
	glob_t g;
	_chdir("C:\\usr\\PIECE\\app");
	_chdrive(4);	//1=A,2=B,3=C,4=D,...	JghCuD:ɂB
	if(!glob("C:*\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//C:BlackWings\after.c
//C:BlackWings\decode.c
//`
//C:adpcm\hello.c
//C:adpcm\ose16.c
//C:gamepad\gamepad.c
//C:hello\hello.c
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵Ȃ΃pX̗
void testR3() {
	glob_t g;
	_chdir("\\usr\\PIECE\\app");
	if(!glob("adpcm\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//adpcm\hello.c
//adpcm\ose16.c
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵Ȃ΃pXŁArɃChJ[hg
void testR4() {
	glob_t g;
	_chdir("\\usr\\PIECE\\app");
	if(!glob("*\\*.c", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//BlackWings\after.c
//BlackWings\decode.c
//`
//adpcm\hello.c
//adpcm\ose16.c
//gamepad\gamepad.c
//hello\hello.c
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//JgtH_΂̗@
void testF1() {
	glob_t g;
	_chdir("\\usr\\PIECE\\app");
	if(!glob(".\\*", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//.\BlackWings
//.\adpcm
//.\block
//.\date
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//JgtH_΂̗A
void testF2() {
	glob_t g;
	_chdir("\\usr\\PIECE\\app");
	if(!glob("*", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//BlackWings
//adpcm
//block
//date
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//etH_΂̗
void testF3() {
	glob_t g;
	_chdir("\\usr\\PIECE\\app");
	if(!glob("..\\*", 0, NULL, &g)) {
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//..\DirectX8a
//..\HTML
//..\INDEX.HTM
//..\Piece.inf
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肷郋[gtH_̗@
void testG1() {
	glob_t g;
	if(!glob("C:\\", 0, NULL, &g)) {	//Bł̓}b`ȂB
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//()
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肷郋[gtH_̗C
void testG2() {
	glob_t g;
	if(!glob("C:\\*", 0, NULL, &g)) {	//BȂ}b`B
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//C:\$RECYCLE.BIN
//C:\$SysReset
//C:\Documents and Settings
//C:\Home
//`
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵Ȃ[gtH_̗@
void testG3() {
	glob_t g;
	if(!glob("\\", 0, NULL, &g)) {	//Bł̓}b`ȂB
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//()
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//hCuw肵Ȃ[gtH_̗C
void testG4() {
	glob_t g;
	if(!glob("\\*", 0, NULL, &g)) {	//BȂ}b`B
		int i;
		for(i = 0; i < (int)g.gl_pathc; i++) {
			puts(g.gl_pathv[i]);
		}
		globfree(&g);
	}
}
//
//\$RECYCLE.BIN
//\$SysReset
//\Documents and Settings
//\Home
//`
#endif
