/*
 *	gdataset.c
 *
 *	Keyed Data Lists, Datasets
 *
 *	* Tue May 31 22:28:49 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibKeyed Data List(https://developer.gnome.org/glib/stable/glib-Keyed-Data-Lists.html),y,Datasets(https://developer.gnome.org/glib/stable/glib-Datasets.html)Qlɂ܂B
 *	  ֐dl̓IWiłƓłA͓ƎŁAȃPȎD悵܂B
 *	- IWił͒PȔzpďȃD悵ĎĂ܂Ałght_hash_table𗘗pĒPȎD悵܂B
 *	  IWiłGObject(GLib̊NX)Ŏgp邽߂ɏȃŗDƂĂ悤łACuł̓[eBeBƂĎg\Ȃ̂ŏȃ͂قǏdvł͂ȂłB
 *	* Wed Jun 01 21:34:08 JST 2016 Naoyuki Sawa
 *	- gdataset.c̈ԉɁAf[^Zbg̎gpǋL܂B
 *	  f[^Xg̎gp͏Ă܂B
 *	  ۂɃf[^Xg𒼐ڎgp鎖͂قƂǖAf[^Zbgėp鎖Ǝv̂ŁAf[^Xg̎gp͕svƎv܂B
 *	  f[^Xg̎gpႪKvȏꍇ́Af[^Zbg̎f[^Xg𗘗pĂ镔QƂĉB
 */
#include "clip.h"
/*****************************************************************************
 *	Keyed Data Lists - lists of data elements which are accessible by a string or GQuark identifier
 *****************************************************************************/
#define G_DATALIST_GET_POINTER(dl)	((ght_hash_table_t*)(*(int*)(dl) & ~G_DATALIST_FLAGS_MASK))	//f[^Xg̃|C^́A[31:2]=|C^,[1:0]=tO Ƃ\łB}ŃA[31:2]=|C^ ̕擾B
#define G_DATALIST_SET_POINTER(dl,p)	*(int*)(dl) = (*(int*)(dl) & G_DATALIST_FLAGS_MASK) | (int)(p)	//f[^Xg̃|C^́A[31:2]=|C^,[1:0]=tO Ƃ\łB}ŃA[31:2]=|C^ ̕ύXB
/*--------------------------------------------------------------------------*/
typedef struct {
	void*		data;				//f[^		NULLs
	void		(*destroy)(void* data);		//fXgN^		NULL
} GDataElt;
/*--------------------------------------------------------------------------*/
static void g_datalist_id_set_internal(GData** datalist, /*GQuark*/int key_id, void* data, void (*destroy_func)(void* data)) {
	if(!key_id ||		//L[ɁANH[N0(=NULL)w肵Ă͂ȂB
	   !data) { DIE(); }	//f[^ɁANULL|C^w肵Ă͂ȂB
	{
		ght_hash_table_t* p_ht;
		if(!(p_ht = G_DATALIST_GET_POINTER(datalist))) {			//nbVe[u쐬Ȃ΁c
			ght_set_rehash((p_ht = ght_create(0)), 1);			//nbVe[u쐬B
			G_DATALIST_SET_POINTER(datalist, p_ht);				//nbVe[ũ|C^i[B
		}
		{
			GDataElt* elt = malloc(sizeof(GDataElt));			//vf̃mۂB
			if(!elt) { DIE(); }						//s
			elt->data    = data;						//vfɁAf[^̃|C^i[B(NULLs)
			elt->destroy = destroy_func;					//vfɁAfXgN^̃|C^i[B(NULL)
			if(ght_insert(p_ht, elt, sizeof key_id, &key_id)) { DIE(); }	//nbVe[uɁAvfǉBL[vfɑ݂ĂAW[̃oOłB
		}
	}
}
/*--------------------------------------------------------------------------*/
static void* g_datalist_id_get_internal(GData** datalist, /*GQuark*/int key_id) {
	if(!key_id) { DIE(); }	//L[ɁANH[N0(=NULL)w肵Ă͂ȂB
	{
		ght_hash_table_t* p_ht;
		void* ret_data = NULL;							//w肳ꂽL[Ɉvvfꍇ̂߂ɁA߂lNULLƂĂB
		if((p_ht = G_DATALIST_GET_POINTER(datalist))) {				//nbVe[u쐬łȂ΁c
			GDataElt* elt = ght_get(p_ht, sizeof key_id, &key_id);		//w肳ꂽL[ɈvvfL΁A擾B
			if(elt) {							//w肳ꂽL[ɈvvfL΁c
				ret_data = elt->data;					//擾f[^߂lƂB
				if(!ret_data) { DIE(); }				//Œ~AW[̃oOłB
			}
		}
		return ret_data;							//擾f[^,,NULLԂB
	}
}
/*--------------------------------------------------------------------------*/
static void* g_datalist_id_remove_internal(GData** datalist, /*GQuark*/int key_id, void (**old_destroy/*NULL*/)(void* data)) {	//(old_destroy!=NULL)ȂΔʒmƌȂB
	if(!key_id) { DIE(); }	//L[ɁANH[N0(=NULL)w肵Ă͂ȂB
	{
		ght_hash_table_t* p_ht;
		void* old_data = NULL;							//w肳ꂽL[Ɉvvfꍇ̂߂ɁA߂lNULLƂĂB
		if(old_destroy) { *old_destroy = NULL; }				//fXgN^i[ϐw肳ĂA܂NULLi[ĂB
		if((p_ht = G_DATALIST_GET_POINTER(datalist))) {				//nbVe[u쐬łȂ΁c
			GDataElt* elt = ght_remove(p_ht, sizeof key_id, &key_id);	//w肳ꂽL[ɈvvfL΁AOB
			if(elt) {							//w肳ꂽL[ɈvvfL΁c
				//```IWiłł͂ŃnbVe[uȂ΃f[^Xg̃JsĂAł͕svƍlčsȂɂBł̓f[^Xg̃Jg_datalist_clear()ł̂ݍsB```
				old_data = elt->data;					//fXgN^ĂяoȂꍇ̂߂ɁAÂf[^߂lƂĂB
				if(!old_data) { DIE(); }				//Œ~AW[̃oOłB
				if(old_destroy) {					//fXgN^i[ϐw肳Ă(=ʒmȂ)c
					*old_destroy = elt->destroy;			//fXgN^i[B(NULL)
				} else if(elt->destroy) {				//ʒmłȂ,,fXgN^L΁c
					(*elt->destroy)(elt->data);			//fXgN^ĂяoB
					old_data = NULL;				//fXgN^Ăяoꍇ́A߂lNULLƂB
				}
				free(elt);						//vf̃JB
			}
		}
		return old_data;							//Âf[^,,NULLԂB
	}
}
/*--------------------------------------------------------------------------*/
//Resets the datalist to NULL.
//It does not free any memory or call any destroy functions.
//Parameters
//		datalist		A pointer to a pointer to a datalist.
void g_datalist_init(GData** datalist) {
	datalist = NULL;
}
/*--------------------------------------------------------------------------*/
//Sets the data corresponding to the given GQuark id, and the function to be called when the element is removed from the datalist.
//Any previous data with the same key is removed, and its destroy function is called.
//Parameters
//		datalist		A datalist.
//		key_id			The GQuark to identify the data element.
//		data			The data element or NULL to remove any previous element corresponding to key_id.	[allow-none]
//		destroy_func		The function to call when the data element is removed.
//					This function will be called with the data element and can be used to free any memory allocated for it.
//					If data is NULL, then destroy_func must also be NULL.
void g_datalist_id_set_data_full(GData** datalist, /*GQuark*/int key_id, void* data, void (*destroy_func)(void* data)) {
	g_datalist_id_remove_internal(datalist, key_id, NULL/*old_destroy*/);
	if(data) { g_datalist_id_set_internal(datalist, key_id, data, destroy_func); }
}
/*--------------------------------------------------------------------------*/
//Retrieves the data element corresponding to key_id.
//Parameters
//		datalist		A datalist.
//		key_id			The GQuark identifying a data element.
//Returns
//		The data element, or NULL if it is not found.
void* g_datalist_id_get_data(GData** datalist, /*GQuark*/int key_id) {
	return g_datalist_id_get_internal(datalist, key_id);
}
/*--------------------------------------------------------------------------*/
//Removes an element, without calling its destroy notification function.
//Parameters
//		datalist		A datalist.
//		key_id			The GQuark identifying a data element.
//Returns
//		The data previously stored at key_id, or NULL if none.
void* g_datalist_id_remove_no_notify(GData** datalist, /*GQuark*/int key_id) {
	void (*old_destroy)(void* data);
	return g_datalist_id_remove_internal(datalist, key_id, &old_destroy/*ʒmƂ邽߂̃_~[*/);
}
/*--------------------------------------------------------------------------*/
//This is a variant of g_datalist_id_get_data() which returns a 'duplicate' of the value.
//dup_func defines the meaning of 'duplicate' in this context, it could e.g. take a reference on a ref-counted object.
//If the key_id is not set in the datalist then dup_func will be called with a NULL argument.
//Note that dup_func is called while the datalist is locked, so it is not allowed to read or modify the datalist.
//This function can be useful to avoid races when multiple threads are using the same datalist and the same key.
//Parameters
//		datalist		Location of a datalist.
//		key_id			The GQuark identifying a data element.
//		dup_func		Function to duplicate the old value.	[allow-none]
//		user_data		Passed as user_data to dup_func.	[allow-none]
//Returns
//		The result of calling dup_func on the value associated with key_id in datalist, or NULL if not set.
//		If dup_func is NULL, the value is returned unmodified.
void* g_datalist_id_dup_data(GData** datalist, /*GQuark*/int key_id, void* (*dup_func)(void* data, void* user_data), void* user_data) {
	void* data = g_datalist_id_get_data(datalist, key_id);
	if(dup_func) { data = (*dup_func)(data/*NULL*/, user_data); }
	return data;
}
/*--------------------------------------------------------------------------*/
//Compares the member that is associated with key_id in datalist to oldval, and if they are the same, replace oldval with newval.
//This is like a typical atomic compare-and-exchange operation, for a member of datalist.
//If the previous value was replaced then ownership of the old value (oldval) is passed to the caller, including the registred destroy notify for it (passed out in old_destroy).
//Its up to the caller to free this as he wishes, which may or may not include using old_destroy as sometimes replacement should not destroy the object in the normal way.
//Parameters
//		datalist		Location of a datalist.
//		key_id			The GQuark identifying a data element.
//		oldval			The old value to compare against.	[allow-none]
//		newval			The new value to replace it with.	[allow-none]
//		destroy			Destroy notify for the new value.	[allow-none]
//		old_destroy		Destroy notify for the existing value.	[allow-none]
//Returns
//		TRUE if the existing value for key_id was replaced by newval, FALSE otherwise.
int g_datalist_id_replace_data(GData** datalist, /*GQuark*/int key_id, void* oldval, void* newval, void (*destroy)(void* data), void (**old_destroy)(void* data)) {
	DIE();	//TODO:[allow-none]łNULLɂ̓dlǂȂ̂ŎۗB
}
/*--------------------------------------------------------------------------*/
//Calls the given function for each data element of the datalist.
//The function is called with each data element's GQuark id and data, together with the given user_data parameter.
//Note that this function is NOT thread-safe.
//So unless datalist can be protected from any modifications during invocation of this function, it should not be called.
//Parameters
//		datalist		A datalist.
//		func			The function to call for each data element.
//		user_data		User data to pass to the function.
void g_datalist_foreach(GData** datalist, void (*func)(/*GQuark*/int key_id, void* data, void* user_data), void* user_data) {
	ght_hash_table_t* p_ht;
	if((p_ht = G_DATALIST_GET_POINTER(datalist))) {	//nbVe[u쐬łȂ΁c
		ght_iterator_t iterator;
		GDataElt* elt;
		const int* p_key_id;
		for(elt = ght_first(p_ht, &iterator, (const void**)&p_key_id);
		    elt;
		    elt = ght_next( p_ht, &iterator, (const void**)&p_key_id)) {
			(*func)(*p_key_id, elt->data, user_data);
		}
	}
}
/*--------------------------------------------------------------------------*/
//Frees all the data elements of the datalist.
//The data elements' destroy functions are called if they have been set.
//Parameters
//		datalist		A datalist.
static void g_datalist_clear_cb(/*GQuark*/int key_id, void* data, void* user_data) {
	g_datalist_id_remove_internal(user_data, key_id, NULL/*old_destroy*/);
}
void g_datalist_clear(GData** datalist) {
	ght_hash_table_t* p_ht;
	g_datalist_foreach(datalist, g_datalist_clear_cb, datalist);	//nbVe[úASĂ̗vf폜B
	if((p_ht = G_DATALIST_GET_POINTER(datalist))) {			//nbVe[u쐬łȂ΁c
		if(ght_size(p_ht)) { DIE(); }				//Œ~AW[̃oOłB
		ght_finalize(p_ht);					//nbVe[u폜B
		G_DATALIST_SET_POINTER(datalist, NULL);			//nbVe[ũ|C^NAB
	}
}
/*--------------------------------------------------------------------------*/
//Turns on flag values for a data list.
//This function is used to keep a small number of boolean flags in an object with a data list without using any additional space.
//It is not generally useful except in circumstances where space is very tight.
//(It is used in the base GObject type, for example.)
//Parameters
//		datalist		Pointer to the location that holds a list.
//		flags			The flags to turn on.
//					The values of the flags are restricted by G_DATALIST_FLAGS_MASK (currently 3; giving two possible boolean flags).
//					A value for flags that doesn't fit within the mask is an error.
void g_datalist_set_flags(GData** datalist, int flags) {
	if(flags & ~G_DATALIST_FLAGS_MASK) { DIE(); }
	*(int*)datalist |= flags;
}
/*--------------------------------------------------------------------------*/
//Turns off flag values for a data list.	See g_datalist_set_flags()
//Parameters
//		datalist		Pointer to the location that holds a list.
//		flags			The flags to turn off.
//					The values of the flags are restricted by G_DATALIST_FLAGS_MASK (currently 3: giving two possible boolean flags).
//					A value for flags that doesn't fit within the mask is an error.
void g_datalist_unset_flags(GData** datalist, int flags) {
	if(flags & ~G_DATALIST_FLAGS_MASK) { DIE(); }
	*(int*)datalist &= ~flags;
}
/*--------------------------------------------------------------------------*/
//Gets flags values packed in together with the datalist.	See g_datalist_set_flags().
//Parameters
//		datalist		Pointer to the location that holds a list.
//Returns
//		The flags of the datalist.
int g_datalist_get_flags(GData** datalist) {
	return *(int*)datalist & G_DATALIST_FLAGS_MASK;
}
/*****************************************************************************
 *	Datasets - associate groups of data elements with particular memory locations
 *****************************************************************************/
static ght_hash_table_t* g_dataset_location_ht;
/*--------------------------------------------------------------------------*/
//Sets the data element associated with the given GQuark id, and also the function to call when the data element is destroyed.
//Any previous data with the same key is removed, and its destroy function is called.
//Parameters
//		dataset_location	The location identifying the dataset.	[not nullable]
//		key_id			The GQuark id to identify the data element.
//		data			The data element.
//		destroy_func		The function to call when the data element is removed.
//					This function will be called with the data element and can be used to free any memory allocated for it.
void g_dataset_id_set_data_full(const void* dataset_location, /*GQuark*/int key_id, void* data, void (*destroy_func)(void* data)) {
	GData** datalist;
	if(!g_dataset_location_ht) {											//nbVe[u쐬Ȃ΁c
		ght_set_rehash((g_dataset_location_ht = ght_create(0)), 1);						//nbVe[u쐬B
	}
	datalist = ght_get(g_dataset_location_ht, sizeof dataset_location, &dataset_location);				//̃P[VɑΉAf[^Xg擾B
	if(!datalist) {													//̃P[VɑΉAf[^Xg΁c
		datalist = malloc(sizeof(GData*));									//f[^Xg̃mۂB
		if(!datalist) { DIE(); }										//s
		g_datalist_init(datalist);										//f[^XgB
		if(ght_insert(g_dataset_location_ht, datalist, sizeof dataset_location, &dataset_location)) { DIE(); }	//̃P[VɑΉAf[^Xgo^B
	}
	g_datalist_id_set_data_full(datalist, key_id, data, destroy_func);						//f[^XgɁAf[^ݒ(data!=NULL),,폜(data==NULL)B
}
/*--------------------------------------------------------------------------*/
//Gets the data element corresponding to a GQuark.
//Parameters
//		dataset_location	The location identifying the dataset.	[not nullable]
//		key_id			The GQuark id to identify the data element.
//Returns
//		The data element corresponding to the GQuark, or NULL if it is not found.
void* g_dataset_id_get_data(const void* dataset_location, /*GQuark*/int key_id) {
	void* data = NULL;												//nbVe[u,,f[^Xgꍇ̂߂ɁA߂lNULLƂĂB
	if(g_dataset_location_ht) {											//nbVe[u쐬łȂ΁c
		GData** datalist = ght_get(g_dataset_location_ht, sizeof dataset_location, &dataset_location);		//̃P[VɑΉAf[^Xg擾B
		if(datalist) {												//̃P[VɑΉAf[^XgL΁c
			data = g_datalist_id_get_data(datalist, key_id);						//f[^XgAf[^擾݂B
		}
	}
	return data;
}
/*--------------------------------------------------------------------------*/
//Removes an element, without calling its destroy notification function.
//Parameters
//		dataset_location	The location identifying the dataset.	[not nullable]
//		key_id			The GQuark ID identifying the data element.
//Returns
//		The data previously stored at key_id, or NULL if none.
void* g_dataset_id_remove_no_notify(const void* dataset_location, /*GQuark*/int key_id) {
	void* data = NULL;												//nbVe[u,,f[^Xgꍇ̂߂ɁA߂lNULLƂĂB
	if(g_dataset_location_ht) {											//nbVe[u쐬łȂ΁c
		GData** datalist = ght_get(g_dataset_location_ht, sizeof dataset_location, &dataset_location);		//̃P[VɑΉAf[^Xg擾B
		if(datalist) {												//̃P[VɑΉAf[^XgL΁c
			data = g_datalist_id_remove_no_notify(datalist, key_id);					//f[^XgAf[^폜݂B
		}
	}
	return data;
}
/*--------------------------------------------------------------------------*/
//Calls the given function for each data element which is associated with the given location.
//Note that this function is NOT thread-safe.
//So unless datalist can be protected from any modifications during invocation of this function, it should not be called.
//Parameters
//		dataset_location	The location identifying the dataset.	[not nullable]
//		func			The function to call for each data element.
//		user_data		User data to pass to the function.
void g_dataset_foreach(const void* dataset_location, void (*func)(/*GQuark*/int key_id, void* data, void* user_data), void* user_data) {
	if(g_dataset_location_ht) {											//nbVe[u쐬łȂ΁c
		GData** datalist = ght_get(g_dataset_location_ht, sizeof dataset_location, &dataset_location);		//̃P[VɑΉAf[^Xg擾B
		if(datalist) {												//̃P[VɑΉAf[^XgL΁c
			g_datalist_foreach(datalist, func, user_data);							//f[^XǵAf[^񋓂B
		}
	}
}
/*--------------------------------------------------------------------------*/
//Destroys the dataset, freeing all memory allocated, and calling any destroy functions set for data elements.
//Parameters
//		dataset_location	The location identifying the dataset.	[not nullable]
void g_dataset_destroy(const void* dataset_location) {
	if(g_dataset_location_ht) {											//nbVe[u쐬łȂ΁c
		GData** datalist = ght_remove(g_dataset_location_ht, sizeof dataset_location, &dataset_location);	//̃P[VɑΉAf[^XgL΁AOB
		if(datalist) {												//̃P[VɑΉAf[^XgL΁c
			g_datalist_clear(datalist);									//f[^Xg폜B
			free(datalist);											//f[^Xg̃JB
		}
	}
}
/*****************************************************************************
 *	f[^Zbg̎gp
 *****************************************************************************/
#if 0
//t@C|C^ɁApXvf֘̕At1BNH[NɕϊăL[ƂAʂ̎g̗łB
static void fnDestroy(void* data) { free(data); }
static void test1_callee(FILE* fp);	//OQ
void test1_caller(const char* path) {
	char drive[MAX_DRIVE], dir[MAX_DIR], fname[MAX_FNAME], ext[MAX_EXT];
	FILE* fp = fopen(path, "w");
	splitpath(path, drive, dir, fname, ext);
	//|C^Ƀf[^֘AtB
	g_dataset_set_data_full(fp, "drive", strdup(drive), fnDestroy);	//W[Ɍł͂ȂA폜֐Ƃfree𒼐ڎw肵Ă͂ȂBڍׂ́Agarray.c'Wed Apr 20 10:51:26 JST 2016'̃RgQƂĉB
	g_dataset_set_data_full(fp, "dir",   strdup(dir),   fnDestroy);	//
	g_dataset_set_data_full(fp, "fname", strdup(fname), fnDestroy);	//
	g_dataset_set_data_full(fp, "ext",   strdup(ext),   fnDestroy);	//
	test1_callee(fp);
	fclose(fp);		//֘At|C^폜鎞Ɂc
	g_dataset_destroy(fp);	//֘Atf[^폜BYƁAʂĂAŕʂ̃IuWFNg܂ܓ|C^ŐꂽɈȑOɊ֘AtÂf[^擾Ă܂肪̂ŁAYȂ悤ɒӂB
}
static void test1_callee(FILE* fp) {
	//|C^Ɋ֘Atf[^擾B
	fprintf(fp, "drive = '%s'\n", g_dataset_get_data(fp, "drive"));
	fprintf(fp, "dir   = '%s'\n", g_dataset_get_data(fp, "dir"  ));
	fprintf(fp, "fname = '%s'\n", g_dataset_get_data(fp, "fname"));
	fprintf(fp, "ext   = '%s'\n", g_dataset_get_data(fp, "ext"  ));
}
/*--------------------------------------------------------------------------*/
//t@C|C^ɁApXvf֘̕At2Bl𒼐ڃL[ƂAȎg̗łB
// - g_dataset_id_`Ag_datalist_id_`Ɏw肷key_id́ANH[Nw肷̂ʂłAȊO̎gƂāA0ȊO̔Cӂ̐lw肵Ă\܂B
//   gdataset.cW[ł́Akey_idNH[Nł鎖ɈˑĂ鏈͖Aj[NȐlłΉłǂłB
//   f[^XgAPIłdatalistPʂŁCf[^ZbgAPIł̓P[VPʂŃj[NłΑvłB
//   Ƃ΁A郍P[Vɑ΂Ă̓NH[NL[ƂėpAʂ̃P[Vɑ΂Ă͐lL[ƂėpĂ\܂B
//   ̓𗘗pƁA؎gpgdataset.cW[̋@\𗘗p鎖oāAx⃁ǂȂ܂B
//   (ƂAx⃁dvȏʂł́Agdataset.cW[̋@\𗘗pȂƂ͎v܂c)
// - datalistA̃P[Vɑ΂āANH[ÑL[Ɛl̃L[𕹗p鎖͏oȂ̂ŒӂĉB
//   quark_from_string()ԂNH[N̒lɂĔ͈͓̑O݂邱Ƃ͏oAlL[Ɣ\L邩łB
static void test2_callee(FILE* fp);	//OQ
void test2_caller(const char* path) {
	char drive[MAX_DRIVE], dir[MAX_DIR], fname[MAX_FNAME], ext[MAX_EXT];
	FILE* fp = fopen(path, "w");
	splitpath(path, drive, dir, fname, ext);
	//|C^Ƀf[^֘AtB
	g_dataset_id_set_data_full(fp, 1, strdup(drive), fnDestroy);
	g_dataset_id_set_data_full(fp, 2, strdup(dir),   fnDestroy);
	g_dataset_id_set_data_full(fp, 3, strdup(fname), fnDestroy);
	g_dataset_id_set_data_full(fp, 4, strdup(ext),   fnDestroy);
	test2_callee(fp);
	fclose(fp);
	g_dataset_destroy(fp);
}
static void test2_callee(FILE* fp) {
	//|C^Ɋ֘Atf[^擾B
	fprintf(fp, "drive = '%s'\n", g_dataset_id_get_data(fp, 1));
	fprintf(fp, "dir   = '%s'\n", g_dataset_id_get_data(fp, 2));
	fprintf(fp, "fname = '%s'\n", g_dataset_id_get_data(fp, 3));
	fprintf(fp, "ext   = '%s'\n", g_dataset_id_get_data(fp, 4));
}
#endif
