/*
 *	error.c
 *
 *	G[o֐
 *
 *	* Mon Sep 28 21:01:46 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- 'GNUg̃G[o֐'݊W[łBgp@͉L̃y[WQƂĂB
 *	  uLinux Programmer's Manual - ERRORv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/error.3.html)
 *	* Sat Oct 24 14:03:11 JST 2015 Naoyuki Sawa
 *	- program_invocation_name,program_invocation_short_nameɂvȌo͂Lɂ܂B
 *	  ܂ł́Aprogram_invocation_name,program_invocation_short_nameɂvȌo͍͂sĂȂ̂łA
 *	  {A/clip/include/errno.h program_invocation_name,program_invocation_short_nameǉāA\ɂȂłB
 *	  ڍׂ́A/clip/include/errno.h ̓̃RgQƂĉB
 *	* Mon Oct 26 20:30:31 JST 2015 Naoyuki Sawa
 *	- error(),y,error_at_line()Aerrnum0w肳Ɖso͂ĂȂoOC܂B
 */
#include "clip.h"
/*****************************************************************************
 *	O[oϐ
 *****************************************************************************/
int error_one_per_line;		//ϐerror_one_per_line0ȊOɐݒ肳ĂꍇAfilenamelinenum̒lɓerror_at_line()̌ĂяóA1(ŏ)bZ[W̏o͂ɂ܂Ƃ߂B
unsigned error_message_count;	//ϐerror_message_count́Aerror()error_at_line()ŏo͂ꂽbZ[W̐\B
void (*error_print_progname)();	//ϐerror_print_prognameɊ֐̃AhX蓖ĂĂꍇ(܂NULLł͂Ȃꍇ)AbZ[W̑OɃvOƃRôł͂ȂÅ֐ĂяoB̊֐͕WG[o(stderr)ɑ΂Ă̓K؂ȕoȂ΂ȂȂB
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
static void error_at_line_subr(int status, int errnum, const char* filename, unsigned linenum, const char* format, va_list ap) {
	if(error_one_per_line && filename) {
		static char*    old_filename;
		static unsigned old_linenum;
		if(old_filename && !strcmp(old_filename, filename) && (old_linenum == linenum)) { goto L_SKIP; }
		free(old_filename);
		if(!(old_filename = strdup(filename))) { DIE(); }
		     old_linenum  =        linenum;
	}
	error_message_count++;
	if(error_print_progname) {							//error_print_prognameݒ肳ĂAerror_print_prognameĂяoăvO\B					//
		(*error_print_progname)();																							//
	} else if(program_invocation_short_name && *program_invocation_short_name) {	//program_invocation_short_name󕶎ɐݒ肳ĂAprogram_invocation_short_namegĊ̏ŃvO\B	//error_print_prognameŗDƂ鎖́Aerror()̊֐dlłB
		fprintf(stderr, "%s: ", program_invocation_short_name);																				//error_print_prognameŗDƂ鎖ȊÓA֐dlł͒`ĂȂ悤łB
	} else if(program_invocation_name && *program_invocation_name) {		//program_invocation_name󕶎ɐݒ肳ĂAprogram_invocation_short_namegĊ̏ŃvO\B	//program_invocation_short_nameprogram_invocation_name̗D揇,y,ݒ肳ĂȂꍇɃvO\Ȃ悤ɂ̂́A̔fł܂B
		fprintf(stderr, "%s: ", program_invocation_name);																				//
	} else {									//L̂ݒ肳ĂȂ΁AvO,y,": "\ȂB								//
		/** no job **/
	}
	if(filename) { fprintf(stderr, "%s:%d: ", filename, linenum); }
	vfprintf(stderr, format, ap);
    //{{2015/10/26C:error(),y,error_at_line()Aerrnum0w肳Ɖso͂ĂȂoOC܂B
    //	if(errnum) { fprintf(stderr, ": %s\n", strerror(errnum)); }
    //2015/10/26C:error(),y,error_at_line()Aerrnum0w肳Ɖso͂ĂȂoOC܂B
	if(errnum) { fprintf(stderr, ": %s", strerror(errnum)); }
	fputc('\n', stderr);
    //}}2015/10/26C:error(),y,error_at_line()Aerrnum0w肳Ɖso͂ĂȂoOC܂B
L_SKIP:
	if(status) { exit(status); }
}
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//uLinux Programmer's Manual - ERRORv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/error.3.html)p:
//error()͔ėpIȃG[o֐łB
//̊֐͕Wo(stdout)ɏoĂAWG[o(stderr)ɏoB
//oéAvOEREXy[XEprintf`̃tH[}bgformatŎw肳ꂽbZ[WłB	ł͎IȃvȌo͂ȗ܂B
//errnum0ȊȌꍇA2ڂ̃RƃXy[X̌strerror(errnum)Ŏw肳ꂽoB
//formatɕKvȔCӂ̈AXgformaťɑB
//o͂̏I[ɂ͉stB
//error()ŏo͂vÓAϐprogram_invocation_name̒lłB					
//program_invocation_namȅlmain()argv[0]̒lƓB							ł͎IȃvȌo͂ȗ܂B
//̕ϐ̒l͕ύX\łAύXerror()̏o͂ςB							
//status0ȊȌꍇAerror()exitĂяoāAw肳ꂽIXe[^XŃvOIB
void error(int status, int errnum, const char* format, ...) {
	va_list ap;
	va_start(ap, format);
	error_at_line_subr(status, errnum, NULL, 0, format, ap);
	va_end(ap);
}
/*---------------------------------------------------------------------------*/
//uLinux Programmer's Manual - ERRORv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/error.3.html)p:
//error_at_line()֐́AfilenamelinenumǉĂȊÓAerror()ƓłB
//o͂́AvǑɃREfilename̒lERElinenum̒loȊÓAerror()ƓłB
//vvZbT̒l__LINE____FILE__́Aerror_at_line()ĂяoƂɖɗB
//̑̃vvZbT̒lgƂłBႦ΁Äœ̓t@CɂʒuQƂłB
void error_at_line(int status, int errnum, const char* filename, unsigned linenum, const char* format, ...) {
	va_list ap;
	va_start(ap, format);
	error_at_line_subr(status, errnum, filename, linenum, format, ap);
	va_end(ap);
}
