/*	
 *	main.c
 *
 *	PceCom - P/ECE USBVA|[gfoCXhCo
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Wed Aug 03 21:57:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#include <initguid.h>
#include "app.h"

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
DriverEntry(DRIVER_OBJECT* driver_object, UNICODE_STRING* registry_path)
{
	KdPrint(("DriverEntry\n"));

	/* fBXpb`[`o^܂B */
	driver_object->DriverUnload                         = driver_unload;
	driver_object->DriverExtension->AddDevice           = add_device;
	driver_object->MajorFunction[IRP_MJ_PNP]            = dispatch_pnp;
	driver_object->MajorFunction[IRP_MJ_CREATE]         = dispatch_create;
	driver_object->MajorFunction[IRP_MJ_CLOSE]          = dispatch_close;
	driver_object->MajorFunction[IRP_MJ_READ]           = dispatch_rx;
	driver_object->MajorFunction[IRP_MJ_WRITE]          = dispatch_tx;
	driver_object->MajorFunction[IRP_MJ_DEVICE_CONTROL] = dispatch_ioctl;
	driver_object->MajorFunction[IRP_MJ_POWER]          = dispatch_power;

	return STATUS_SUCCESS;
}

/****************************************************************************
 *
 ****************************************************************************/

void
driver_unload(DRIVER_OBJECT* driver_object)
{
	KdPrint(("driver_unload\n"));

	/** no job **/
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
add_device(DRIVER_OBJECT* driver_object, DEVICE_OBJECT* physical_device_object)
{
	static int device_index = -1;
	//
	DEVICE_OBJECT* device_object = NULL;
	DEVICE_EXTENSION* device_extension = NULL;
	//
	NTSTATUS status;
	WCHAR _device_name[64];
	UNICODE_STRING device_name;

	KdPrint(("add_device\n"));

	/* foCX쐬܂B(ƂŃfoCXGNXeVɊi[܂B) */
	_snwprintf(_device_name, sizeof _device_name, L"\\Device\\PceCom%d", InterlockedIncrement(&device_index));
	RtlInitUnicodeString(&device_name, _device_name);
	KdPrint(("Device name = %wZ\n", &device_name));

	/* foCX쐬܂B */
	status = IoCreateDevice(
		driver_object,			/* DriverObject */
		sizeof(DEVICE_EXTENSION),	/* DeviceExtensionSize */
		&device_name,			/* DeviceName */
		FILE_DEVICE_SERIAL_PORT,	/* DeviceType */
		0,				/* DeviceCharacteristics */
		TRUE,				/* Exclusive */
		&device_object);
	if(!NT_SUCCESS(status)) {
		KdPrint(("IoCreateDevice failed\n"));
		goto L_EXIT;
	}
	device_extension = device_object->DeviceExtension;

	/* foCXAfoCXi[܂B */
	device_extension->device_object = device_object;
	device_extension->physical_device_object = physical_device_object;

	/* foCXX^bNɒǉAʃfoCXi[܂B */
	device_extension->next_device_object = IoAttachDeviceToDeviceStack(device_object, physical_device_object);
	if(!device_extension->next_device_object) {
		KdPrint(("IoAttachDeviceToDeviceStack failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}

	/* foCXi[܂B */
	RtlInitEmptyUnicodeString(&device_extension->device_name,
		device_extension->_device_name, sizeof device_extension->_device_name);
	RtlCopyUnicodeString(&device_extension->device_name, &device_name);

	/* obt@ANZXI܂B */
	device_object->Flags |= DO_BUFFERED_IO;

	/* d͊Ǘ[`PASSIVE_LEVELŌĂяo悤ɐݒ肵܂B
	 * {hCõR[hZNV́AftHgzuNonPaged̂͂Ȃ̂ŁA
	 *   d͊Ǘ[`DISPATCH_LEVELłĂ΂ĂvȂ͂Ȃ̂łA
	 *   ۂɂ́ADO_POWER_PAGABLEw肵ĂȂƁAIRP_MJ_POWERv
	 *   ^C~OŃoO`FbNāAVXe~܂B
	 *   ȂPASSIVE_LEVELłȂ΂Ȃ̂AsłB(ʃhCo̎dl?)
	 */
	device_object->Flags |= DO_POWER_PAGABLE;

	/* }[N܂B */
	device_object->Flags &= ~DO_DEVICE_INITIALIZING;

L_EXIT:

	if(!NT_SUCCESS(status)) {
		if(device_extension && device_extension->next_device_object) {
			IoDetachDevice(device_extension->next_device_object);
			device_extension->next_device_object = NULL;
		}
		if(device_object) {
			IoDeleteDevice(device_object);
		}
	}

	return status;
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
dispatch_pnp(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	IO_STACK_LOCATION* stack_location = IoGetCurrentIrpStackLocation(irp);
	int minor_function = stack_location->MinorFunction;
	//
	NTSTATUS status;

	KdPrint(("dispatch_pnp - %s\n", pnp_minor_function_name(minor_function)));

	switch(minor_function) {
	case IRP_MN_START_DEVICE:
		{
			int num_pipes;
			USBD_PIPE_INFORMATION pipes[2];

			/* ʃfoCX̏s܂B */
			status = call_next_driver(device_object, irp);
			if(!NT_SUCCESS(status)) {
				KdPrint(("call_next_driver failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			/* IʒmCxg܂B
			 * * stop_device()ɂāAKEVENT.DISPATCHER_HEADER.Size𒲂ׂāAςor𔻒f܂B
			 *   KEVENT.DISPATCHER_HEADER.Type͏0̂܂܂݂Ȃ̂ŁATypeł͔fłȂ悤łB
			 */
			KeInitializeEvent(&device_extension->terminate_event, NotificationEvent, FALSE);
			ASSERT(device_extension->terminate_event.Header.Size);

			/* COM|[go^܂B */
			device_extension->serialcomm = register_serialcomm(
				device_extension->physical_device_object, device_extension->device_name.Buffer);
			if(!device_extension->serialcomm) {
				KdPrint(("register_serialcomm failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			/* RtBM[VI܂B */
			num_pipes = set_configuration(device_extension->next_device_object, pipes, 2);
			if(num_pipes != 2) {
				KdPrint(("set_configuration failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}
			device_extension->rx_pipe = pipes[0]; /* MpCv擾 */
			device_extension->tx_pipe = pipes[1]; /* MpCv擾 */

			/* M܂B */
			status = rx_init(device_object);
			if(!NT_SUCCESS(status)) {
				KdPrint(("rx_init failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			/* M܂B */
			status = tx_init(device_object);
			if(!NT_SUCCESS(status)) {
				KdPrint(("tx_init failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			/* IOCTL܂B */
			status = ioctl_init(device_object);
			if(!NT_SUCCESS(status)) {
				KdPrint(("ioctl_init failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			break;
		}
	case IRP_MN_REMOVE_DEVICE:
		{
			/* foCX~܂B
			 * ʃfoCXIRP_MN_REMOVE_DEVICȄ˗OɁAM|[OIRP~ĂȂƁA
			 *   ʃfoCXIRP_MN_REMOVE_DEVICE܂!!
			 */
			stop_device(device_object);

			/* ʃfoCX̏s܂B */
			status = call_next_driver(device_object, irp);
			if(!NT_SUCCESS(status)) {
				KdPrint(("call_next_driver failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			/* foCXX^bNO܂B */
			if(device_extension->next_device_object) {
				IoDetachDevice(device_extension->next_device_object);
				device_extension->next_device_object = NULL;
			}

			/* foCX폜܂B */
			IoDeleteDevice(device_object);

			break;
		}
	case IRP_MN_QUERY_CAPABILITIES:
		{
			DEVICE_CAPABILITIES* device_capabilities = stack_location->Parameters.DeviceCapabilities.Capabilities;

			/* ʃfoCX̏s܂B */
			status = call_next_driver(device_object, irp);
			if(!NT_SUCCESS(status)) {
				KdPrint(("call_next_driver failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			/* ʃfoCXɂĊi[ꂽfoCXP[preBɉāAxŎOł邱Ƃ}[N܂B */
			device_capabilities->SurpriseRemovalOK = TRUE;

			break;
		}
	default:
		{
			/* ʃfoCX̏s܂B */
			status = call_next_driver(device_object, irp);
			if(!NT_SUCCESS(status)) {
				KdPrint(("call_next_driver failed\n"));
				return complete_request(irp, STATUS_UNSUCCESSFUL, 0);
			}

			break;
		}
	}

	/* IRP̊p܂B */
	return complete_request(irp, irp->IoStatus.Status, irp->IoStatus.Information);
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
dispatch_power(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	IO_STACK_LOCATION* stack_location = IoGetCurrentIrpStackLocation(irp);

	KdPrint(("dispatch_power\n"));

	/* ʃfoCX֗܂B
	 * * d͊Ǘ[`́AʏIRPƈقȂA
	 * - PoStartNextPowerIrp()Kvł邱ƁB
	 * - IoCallDriver()łȂPoCallDriver()gƁB
	 *   ɒӂĂB
	 */
	PoStartNextPowerIrp(irp);
	IoSkipCurrentIrpStackLocation(irp);
	return PoCallDriver(device_extension->next_device_object, irp);
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
dispatch_create(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	IO_STACK_LOCATION* stack_location = IoGetCurrentIrpStackLocation(irp);
	//
	NTSTATUS status;

	KdPrint(("dispatch_create\n"));

	return complete_request(irp, STATUS_SUCCESS, 0);
}

/****************************************************************************
 *
 ****************************************************************************/

NTSTATUS
dispatch_close(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	IO_STACK_LOCATION* stack_location = IoGetCurrentIrpStackLocation(irp);
	//
	NTSTATUS status;

	KdPrint(("dispatch_close\n"));

	return complete_request(irp, STATUS_SUCCESS, 0);
}

/****************************************************************************
 *
 ****************************************************************************/

/* ʃfoCXIRPpXX[A҂܂B
 * IRP͖Ȃ̂ŁÂƂłxIoCompleteRequest()KvłB
 */
NTSTATUS
call_next_driver(DEVICE_OBJECT* device_object, IRP* irp)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	//
	NTSTATUS status;

	KdPrint(("call_next_driver\n"));

	IoCopyCurrentIrpStackLocationToNext(irp);
	status = call_driver(device_extension->next_device_object, irp);
	if(!NT_SUCCESS(status)) {
		KdPrint(("call_driver failed\n"));
		/* FALLTHRU */
	}

	return status;
}

/****************************************************************************
 *
 ****************************************************************************/

/* foCX~܂B
 */
void
stop_device(DEVICE_OBJECT* device_object)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;

	KdPrint(("stop_device\n"));

	/* IʒmCxgVOiԂɂ܂B */
	if(device_extension->terminate_event.Header.Size) {
		KeSetEvent(&device_extension->terminate_event, IO_NO_INCREMENT, FALSE);
	}

	/* COM|[go^܂B */
	if(device_extension->serialcomm) {
		unregister_serialcomm(device_extension->serialcomm);
		device_extension->serialcomm = NULL;
	}

	/* MN[Abv܂B */
	rx_exit(device_object);

	/* MN[Abv܂B */
	tx_exit(device_object);

	/* IOCTLN[Abv܂B */
	ioctl_exit(device_object);

	/* RtBM[V𖢑Iɖ߂܂B */
	unset_configuration(device_extension->next_device_object);
}

/****************************************************************************
 *
 ****************************************************************************/

/* IRP̃LZcwMicrosoft WDM vO~Oxp.237`239Q */
static NTSTATUS
transfer_completion_routine(DEVICE_OBJECT* device_object, IRP* irp, void* context)
{
	KEVENT* event = context;
	KeSetEvent(event, IO_NO_INCREMENT, FALSE);
	return STATUS_MORE_PROCESSING_REQUIRED;
}

NTSTATUS
exec_transfer(DEVICE_OBJECT* device_object, URB* urb)
{
	DEVICE_EXTENSION* device_extension = device_object->DeviceExtension;
	DEVICE_OBJECT* usbd = device_extension->next_device_object;
	//
	NTSTATUS status;
	IRP* irp;
	IO_STACK_LOCATION* stack_location;
	KEVENT event;
	IO_STATUS_BLOCK status_block;
	int pending;
	//
	void* wait_objects[3];
	ASSERT(THREAD_WAIT_OBJECTS >= 3);

	/* IRPʒmCxg܂B */
	KeInitializeEvent(&event, NotificationEvent, FALSE); /* SynchronizationEvents */

	/* IRP쐬܂B(ɎIɉ̂ŁAIȉ͕svł) */
	irp = IoBuildDeviceIoControlRequest(
		IOCTL_INTERNAL_USB_SUBMIT_URB,	/* IoControlCode */
		usbd,				/* DeviceObject */
		NULL,				/* InputBuffer */
		0,				/* InputBufferLength */
		NULL,				/* OutputBuffer */
		0,				/* OutputBufferLength */
		TRUE,				/* InternalDeviceIoControl */
		&event,				/* Event */
		&status_block);			/* IoStatusBlock */
	if(!irp) {
		KdPrint(("IoBuildDeviceIoControlRequest failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}
	stack_location = IoGetNextIrpStackLocation(irp); /* IoGetCurrentIrpStackLocation()ł͂܂!! */
	stack_location->Parameters.Others.Argument1 = urb;

	/* IRP̃LZcwMicrosoft WDM vO~Oxp.237`239Q */
	IoSetCompletionRoutine(irp, transfer_completion_routine, &event, TRUE, TRUE, TRUE);
	pending = IoCallDriver(usbd, irp) == STATUS_PENDING;
	if(pending) {	/* Ă */
		wait_objects[0] = &device_extension->terminate_event;
		wait_objects[1] = &event;
		status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
		if(!NT_SUCCESS(status)) {
			KdPrint(("KeWaitForMultipleObjects failed\n"));
			goto L_EXIT;
		}
		if(status == 0/*Terminate*/) {
			KdPrint(("Cancel transfer\n"));
			IoCancelIrp(irp);
		}
		KeWaitForSingleObject(&event, Executive, KernelMode, FALSE, NULL); /* transfer_completion_routine()ɂEvent set҂ */
	}		/* Ă */
	KeClearEvent(&event); /* transfer_completion_routine()ɂEvent set */
	IoCompleteRequest(irp, IO_NO_INCREMENT); /* STATUS_MORE_PROCESSING_REQUIREDɂĒfĂIRP̊ĊJ */
	if(pending) {	/* K{!! */
		/* dv: IoBuildDeviceIoControlRequest()Ɏw肵EventAIRP̊ɃVOiԂɂȂ̂́A
		 *         IoCallDriver()STATUS_PENDINGԂꂽꍇłB
		 *         STATUS_PENDINGȊOԂꂽꍇ́AIRPĂAEvent̓VOiԂɂȂ܂!!
		 */
		KeWaitForSingleObject(&event, Executive, KernelMode, FALSE, NULL); /* IoBuildDeviceIoControlRequest()ɂEvent set҂ */
	}		/* K{!! */
	status = status_block.Status;

L_EXIT:

	return status;
}

