/*	
 *	clipxls.c
 *
 *	[eBeBFGNZ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Tue Jun 28 21:02:01 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  GNZf[^𒼐ڑ삷鎞ɗp֐AW[Ɏ鎖ɂ܂B
 *	  2016/06/28݂̏Astrtoref()݂̂łB
 *	  ۂɂgpc[AvP[V́A܂쐬Ă܂B
 *	  ꂩc[AvP[V쐬ȂA쌟؂\łB
 *	* Wed Jun 29 21:00:15 JST 2016 Naoyuki Sawa
 *	- strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
 *	  ̂߂ɁAstrtoref_parse1()ŕ擾鏈Ambsnextc(),mbsinc()g悤ɕύX܂B
 *	- strtoref()Ăꕶ́Au'vu!vu[vu]vL܂AVtgJIS2oCgڂɈv̂́u[vu]vȂ̂ŁAu'vu!v͍lsvłB
 *	  u[vu]v́ApX,ubN,V[g̃p[X(strtoref_parse1())ƁAR1C1`̃p[X(strtoref_parse2())Ŕ肵Ă܂A
 *	  VtgJIS\L̂͑O(strtoref_parse1())Ȃ̂ŁA(strtoref_parse2())ł̓VtgJISΉ͕svłB
 *	  ]āAύX́Astrtoref_parse1()łB
 *	- ܂ł́ApX,ubN,V[gɃVtgJIS܂܂ĂƁAԈʂɂȂ鎖L܂A̕ύXɂāAʂɂȂ܂B
 *	  mFʂ́Aȉ̒ʂłB
 *	  eXgvO
 *	  void test() {
 *	    const char ref[]="i[]Cn!A1";	//="\x8A\x69\x94\x5B\x89\xF1\x93\x5D\x83\x43\x83\x8D\x83\x6E\x21\x41\x31"
 *	    char *book, *sheet;
 *	    int flag, col, row;
 *	    flag = strtoref(ref, NULL, &book, &sheet, &row, &col);
 *	    printf("%-40s %06b %'8d %'8d %-24s %-24s\n", ref, flag, row, col, book ? book : "(NULL)", sheet ? sheet : "(NULL)");
 *	    free(book);
 *	    free(sheet);
 *	  }
 *	  ~(CO)
 *	  i[]Cn!A1  101001  1  1  i\x94\x93  Cn	u[v2oCgڂu[vCu]v2oCgڂu]vɋRvāA"i\x94[\x93]Cn!A1"ƌȂĂ܂ĂB
 *	  (C)
 *	  i[]Cn!A1  101001  1  1  (NULL)        i[]Cn
 *	* Sat Jul 02 21:34:21 JST 2016 Naoyuki Sawa
 *	- reftostr()ǉ܂B
 */
#include "clip.h"
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
static int strtoref_parse1(const char* ptr, char** _book, char** _sheet);		//OQ
static int strtoref_parse2(const char* _ptr, char** _endptr, int* _row, int* _col);	//OQ
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//֐󂯕tAGNZ̎Qƕ\́Aȉ̒ʂłB
//ZQ		@	Z
//V[gQ		A	V[g!Z
//			B	'V[g'!Z			V[gɋ󔒂L܂܂ꍇ́Ǎ`ɂȂ悤łB
//ubNQ		C	[ubN]V[g!Z
//			D	'[ubN]V[g'!Z		ubN,,V[gɋ󔒂L܂܂ꍇ́Ǎ`ɂȂ悤łB
//			E	'pX[ubN]V[g'!Z	pX܂܂ꍇ́A󔒂L̗LɊ֌WǍ`ɂȂ悤łB
int strtoref(const char* _ptr, char** _endptr/*NULL*/, char** _book/*NULL*/, char** _sheet/*NULL*/, int* _row/*NULL*/, int* _col/*NULL*/) {
	const char* ptr = _ptr;
	char *book = NULL, *sheet = NULL;
	GString* s = g_string_new(NULL);
	int flag, row, col, c;
	//擪̋󔒂ǂݔ΂B
	while(isspace((c = *ptr++))) { /** no job **/ }
	//󔒈ȊO̍ŏ̕u'vȂ΁c						BDE
	if(c == '\'') {
		//u'v`u'v̊Ԃ̕擾B
		for(;;) {
			c = *ptr++;
			if(!c) { goto L_ERR; }		//u'vB
			if(c == '\'') {			//u'vc
				if(*ptr == '\'') {
					ptr++;		//u''v́u'vƌȂČpB
				} else {
					break;		//PƂ́u'vȂ΃[v𔲂B
				}
			}
			g_string_append_c(s, c);
		}
		//u'v̎̕擾B
		c = *ptr++;
		if(c != '!') { goto L_ERR; }		//u'v̎́̕u!vłȂĂ͂ȂȂB
		//ŁAptŕu!v̎̕(=Z)wĂB
	//󔒈ȊO̍ŏ̕u'vȊOȂ΁c					@AC
	} else {
		const char* save_ptr = ptr - 1/*c*/;
		//u!vLƉ肵āA`u!v܂ł̕擾B
		for(;;) {
			if(!c || (c == '!')) { break; }
			g_string_append_c(s, c);
			c = *ptr++;
		}
		//u!v΁A擾NAA|C^ɖ߂B	@
		if(!c) {
			g_string_truncate(s, 0);
			ptr = save_ptr;
		}
		//ŁAptŕu!v̎̕(=Z),,󔒈ȊO̍ŏ̕(=Z)wĂB
	}
	//u!v̑O͂̕B
	if(!strtoref_parse1(s->str, &book, &sheet)) { goto L_ERR; }
	//u!v̌͂̕B
	if(!(flag = strtoref_parse2(ptr, (char**)&ptr, &row, &col))) { goto L_ERR; }
	//ʂi[B
	if(_endptr) {					//ϊɎgꂽŏI̎̕ւ̃|C^i[ϐw肳Ăc
		*_endptr = (char*)ptr;			//ϊɎgꂽŏI̎̕ւ̃|C^i[B
	}
	if(_book) {					//ubNi[ϐw肳Ăc
		*_book = book;				//ubNi[B
	} else {					//ubNi[ϐw肳ĂȂ΁c
		free(book);				//ubN̕񂪊mۂĂB
	}
	if(_sheet) {					//V[gi[ϐw肳Ăc
		*_sheet = sheet;			//V[gi[B
	} else {					//V[gi[ϐw肳ĂȂ΁c
		free(sheet);				//V[g̕񂪊mۂĂB
	}
	if(_row) {					//si[ϐw肳Ăc
		*_row = row;				//si[B
	}
	if(_col) {					//i[ϐw肳Ăc
		*_col = col;				//i[B
	}
	g_string_free(s, 1/*free_segment*/);		//Ɨp̕B
	return flag;					//tO(!=0)ԂB
L_ERR:
	if(_endptr) {					//ϊɎgꂽŏI̎̕ւ̃|C^i[ϐw肳Ăc
		*_endptr = (char*)_ptr;			//_ptř̒li[B(strtol()Ɠ)
	}
	if(_book) {					//ubNi[ϐw肳Ăc
		*_book = NULL;				//NULL|C^i[B(Ŝ߁BK{ł͂ȂB)
	}
	free(book);					//ubN̕񂪊mۂĂB
	if(_sheet) {					//V[gi[ϐw肳Ăc
		*_sheet = NULL;				//NULL|C^i[B(Ŝ߁BK{ł͂ȂB)
	}
	free(sheet);					//V[g̕񂪊mۂĂB
	if(_row) {					//si[ϐw肳Ăc
		*_row = 0;				//0i[B(Ŝ߁BK{ł͂ȂB)
	}
	if(_col) {					//i[ϐw肳Ăc
		*_col = 0;				//0i[B(Ŝ߁BK{ł͂ȂB)
	}
	g_string_free(s, 1/*free_segment*/);		//Ɨp̕B
	return 0;					//G[(0)ԂB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int strtoref_parse1(const char* ptr, char** _book, char** _sheet) {
	int success = 0, c;
	GString* s = g_string_new(NULL);
	//V[g
	//[ubN]V[g
	//pX[ubN]V[g
	//u[vLƉ肵āA`u[v܂ł̕擾B
	for(;;) {
//{{2016/06/29ύX:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
//		c = *ptr++;
//2016/06/29ύX:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		c = mbsnextc(ptr);
		ptr = mbsinc(ptr);
//}}2016/06/29ύX:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		if(!c) {				//u[vꍇ́c
			if(s->len) {			//ꕶȏ擾ĂAV[gƂĊi[B
				*_sheet = strdup(s->str);
				if(!*_sheet) { DIE(); }	//s
			}
			goto L_RET;			//܂
		}
		if(c == '[') { break; }			//u[vL烋[v𔲂āAu[v̑ÕpX(͋󕶎)̑ɃV[g擾B
//{{2016/06/29ǉ:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		if(c > UCHAR_MAX) { g_string_append_c(s, c >> 8); }
//}}2016/06/29ǉ:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		g_string_append_c(s, c);		//pX(̓V[g)ɕǉB
	}
	//u[v̑ÕpX(͋󕶎)̑ɁAu]v܂ł̕ǉB
	if(!*ptr) { goto L_ERR; }			//u[]v̓G[B
	for(;;) {
//{{2016/06/29ύX:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
//		c = *ptr++;
//2016/06/29ύX:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		c = mbsnextc(ptr);
		ptr = mbsinc(ptr);
//}}2016/06/29ύX:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		if(!c) { goto L_ERR; }			//u]v΃G[B
		if(c == ']') { break; }			//u]vL烋[v𔲂āAubNm肷B
//{{2016/06/29ǉ:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		if(c > UCHAR_MAX) { g_string_append_c(s, c >> 8); }
//}}2016/06/29ǉ:strtoref()́ApX,ubN,V[g̃p[XAVtgJISΉɂ܂B
		g_string_append_c(s, c);		//pXɃubN̕ǉB
	}
	if(s->len) {					//ꕶȏ擾ĂAubNƂĊi[B
		*_book = strdup(s->str);
		if(!*_book) { DIE(); }			//s
	}
	//u]v̌̕񂪁AV[głB
	if(!*ptr) { goto L_ERR; }			//u]v̌ɕ΃G[B
	*_sheet = strdup(ptr);
	if(!*_sheet) { DIE(); }				//s
L_RET:
	success = 1;
L_ERR:
	g_string_free(s, 1/*free_segment*/);		//Ɨp̕B
	return success;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int strtoref_parse2(const char* _ptr, char** _endptr, int* _row, int* _col) {
	const char* ptr;
	char* endptr;
	int flag, row, col;
	//܂AR1C1`Ɖ肵ăp[XĂ݂B
	//RC			s		񑊑
	//RlC		s		񑊑
	//RCl		s		
	//RlCl		s		
	//R[l]C		s		񑊑
	//RC[l]		s		񑊑
	//R[l]C[l]	s		񑊑
	flag = XlsRef_Style_R1C1;
	ptr = _ptr;
	if(toupper(*ptr++) != 'R') { goto L_A1; }
	if(*ptr == '[') {
		ptr++;	//'['
		row = strtol(ptr, &endptr, 0);		//}CiX
		if((endptr == ptr) ||			//l΃G[B
		  (*endptr != ']')) { goto L_A1; }	//u]v΃G[B
		ptr = endptr;
		ptr++;	//']'
		flag |= XlsRef_RowType_Rel;
	} else {
		row = strtoul(ptr, &endptr, 0);		//}CiXs			ˎcOȂstrtoul()'-'eĂ܂̂ł̂ł̓G[oȂc
		if(endptr == ptr) {
			flag |= XlsRef_RowType_Rel;	//Řɐl΍s΁BϊoȂꍇstrtoul()̖߂l0Ȃ̂ŁA(row=0)ɂȂĂ͂B
		} else {
			flag |= XlsRef_RowType_Abs;	//ŘɐlLs΁B
		}
		ptr = endptr;
	}
	if(toupper(*ptr++) != 'C') { goto L_A1; }
	if(*ptr == '[') {
		ptr++;	//'['
		col = strtol(ptr, &endptr, 0);		//}CiX
		if((endptr == ptr) ||			//l΃G[B
		  (*endptr != ']')) { goto L_A1; }	//u]v΃G[B
		ptr = endptr;
		ptr++;	//']'
		flag |= XlsRef_ColType_Rel;
	} else {
		col = strtoul(ptr, &endptr, 0);		//}CiXs			ˎcOȂstrtoul()'-'eĂ܂̂ł̂ł̓G[oȂc
		if(endptr == ptr) {
			flag |= XlsRef_ColType_Rel;	//Čɐl΍s΁BϊoȂꍇstrtoul()̖߂l0Ȃ̂ŁA(col=0)ɂȂĂ͂B
		} else {
			flag |= XlsRef_ColType_Abs;	//ČɐlLs΁B
		}
		ptr = endptr;
	}
	goto L_RET;
L_A1:	//R1C1`Ɖ肵ăp[XoȂ΁AA1`Ɖ肵ăp[XĂ݂B
	//ABCl		s		񑊑
	//$ABCl		s		
	//ABC$l		s		񑊑
	//$ABC$l		s		
	flag = XlsRef_Style_A1;
	ptr = _ptr;
	if(*ptr == '$') {
		ptr++;	//'$'
		flag |= XlsRef_ColType_Abs;
	} else {
		flag |= XlsRef_ColType_Rel;
	}
	if(!isalpha(*ptr)) { return 0; }		//ABC΃G[B
	col = 0;
	for(;;) {
		col += (toupper(*ptr++) - 'A' + 1);	//
		if(!isalpha(*ptr)) { break; }		//e̒l1`26ŁANڂ̏d݂26^(N-1)ƂAϑIȌvZłB
		col *= ('Z' - 'A' + 1);			//
	}
	if(*ptr == '$') {
		ptr++;	//'$'
		flag |= XlsRef_RowType_Abs;
	} else {
		flag |= XlsRef_RowType_Rel;
	}
	row = strtoul(ptr, &endptr, 0);			//}CiXs			ˎcOȂstrtoul()'-'eĂ܂̂ł̂ł̓G[oȂc
	if(endptr == ptr) { return 0; }			//l΃G[B
	ptr = endptr;
L_RET:
	*_endptr = (char*)ptr;
	*_row = row;
	*_col = col;
	return flag;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#if 0
//eXgvO
static const char* const TBL_ref[][2]={
{	"A1",						"A1?",						},
{	"Sheet1!A1",					"Sheet1!A1?",					},
{	"'Sheet 1'!A1",					"'Sheet 1'!A1?",				},
{	"[Book1.xlsx]Sheet1!A1",			"[Book1.xlsx]Sheet1!A1?",			},
{	"'[Book 1.xlsx]Sheet 1'!A1",			"'[Book 1.xlsx]Sheet 1'!A1?",			},
{	"'C:\\Home\\[Book1.xlsx]Sheet1'!A1",		"'C:\\Home\\[Book1.xlsx]Sheet1'!A1?",		},
{	"'C:\\H''o''me\\[Book1.xlsx]Sheet1'!A1",	"'C:\\H''o''me\\[Book1.xlsx]Sheet1'!A1?",	},
{	"ABC123",					"ABC123?",					},
{	"$ABC123",					"$ABC123?",					},
{	"ABC$123",					"ABC$123?",					},
{	"$ABC$123",					"$ABC$123?",					},
{	"RC",						"RC?",						},
{	"R123C",					"R123C?",					},
{	"RC123",					"RC123?",					},
{	"R123C123",					"R123C123?",					},
{	"R[-123]C",					"R[-123]C?",					},
{	"RC[-123]",					"RC[-123]?",					},
{	"R[-123]C[-123]",				"R[-123]C[-123]?",				},
{	"AAA1",						"WWW1?",					},
};
void test() {
	char *endptr, *book, *sheet;
	int flag, col, row, i, j;
	for(i = 0; i < ARRAY_SIZE(TBL_ref); i++) {
		for(j = 0; j < 2; j++) {
			flag = strtoref(TBL_ref[i][j], &endptr, &book, &sheet, &row, &col);
			printf("%-40s %06b %'8d %'8d %-24s %-24s\n", TBL_ref[i][j], flag, row, col, book ? book : "(NULL)", sheet ? sheet : "(NULL)");
			if(j == 0) { if(endptr != (TBL_ref[i][j] + strlen(TBL_ref[i][j])         )) { DIE(); } }
			if(j == 1) { if(endptr != (TBL_ref[i][j] + strlen(TBL_ref[i][j]) - 1/*?*/)) { DIE(); } }
			free(book);
			free(sheet);
		}
	}
}
//
//A1                                       101001        1        1 (NULL)                   (NULL)
//A1?                                      101001        1        1 (NULL)                   (NULL)
//Sheet1!A1                                101001        1        1 (NULL)                   Sheet1
//Sheet1!A1?                               101001        1        1 (NULL)                   Sheet1
//'Sheet 1'!A1                             101001        1        1 (NULL)                   Sheet 1
//'Sheet 1'!A1?                            101001        1        1 (NULL)                   Sheet 1
//[Book1.xlsx]Sheet1!A1                    101001        1        1 Book1.xlsx               Sheet1
//[Book1.xlsx]Sheet1!A1?                   101001        1        1 Book1.xlsx               Sheet1
//'[Book 1.xlsx]Sheet 1'!A1                101001        1        1 Book 1.xlsx              Sheet 1
//'[Book 1.xlsx]Sheet 1'!A1?               101001        1        1 Book 1.xlsx              Sheet 1
//'C:\Home\[Book1.xlsx]Sheet1'!A1          101001        1        1 C:\Home\Book1.xlsx       Sheet1
//'C:\Home\[Book1.xlsx]Sheet1'!A1?         101001        1        1 C:\Home\Book1.xlsx       Sheet1
//'C:\H''o''me\[Book1.xlsx]Sheet1'!A1      101001        1        1 C:\H'o'me\Book1.xlsx     Sheet1
//'C:\H''o''me\[Book1.xlsx]Sheet1'!A1?     101001        1        1 C:\H'o'me\Book1.xlsx     Sheet1
//ABC123                                   101001      123      731 (NULL)                   (NULL)
//ABC123?                                  101001      123      731 (NULL)                   (NULL)
//$ABC123                                  011001      123      731 (NULL)                   (NULL)
//$ABC123?                                 011001      123      731 (NULL)                   (NULL)
//ABC$123                                  100101      123      731 (NULL)                   (NULL)
//ABC$123?                                 100101      123      731 (NULL)                   (NULL)
//$ABC$123                                 010101      123      731 (NULL)                   (NULL)
//$ABC$123?                                010101      123      731 (NULL)                   (NULL)
//RC                                       101010        0        0 (NULL)                   (NULL)
//RC?                                      101010        0        0 (NULL)                   (NULL)
//R123C                                    100110      123        0 (NULL)                   (NULL)
//R123C?                                   100110      123        0 (NULL)                   (NULL)
//RC123                                    011010        0      123 (NULL)                   (NULL)
//RC123?                                   011010        0      123 (NULL)                   (NULL)
//R123C123                                 010110      123      123 (NULL)                   (NULL)
//R123C123?                                010110      123      123 (NULL)                   (NULL)
//R[-123]C                                 101010     -123        0 (NULL)                   (NULL)
//R[-123]C?                                101010     -123        0 (NULL)                   (NULL)
//RC[-123]                                 101010        0     -123 (NULL)                   (NULL)
//RC[-123]?                                101010        0     -123 (NULL)                   (NULL)
//R[-123]C[-123]                           101010     -123     -123 (NULL)                   (NULL)
//R[-123]C[-123]?                          101010     -123     -123 (NULL)                   (NULL)
//AAA1                                     101001        1      703 (NULL)                   (NULL)
//WWW1?                                    101001        1   16,169 (NULL)                   (NULL)		(23*26*26)+(23*26)+23=16169
#endif
/*--------------------------------------------------------------------------*/
static int reftostr_subr1(GString* s, const char* ptr);	//OQ
static void reftostr_subr2(GString* s, int row);	//OQ
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
char* reftostr(const char* book/*NULL*/, const char* sheet/*NULL*/, int row, int col, int flag) {
	GString* s = g_string_new(NULL);
	int req_quote = 0;	//ubN,,V[gɁACV{,'.'ȊO܂܂ĂAreq_quote=1ɂB
	//ubNw肳Ăc
	if(book) {
		//ubNApXƃubNɕB
		char path[MAX_PATH], drive[MAX_DRIVE], dir[MAX_DIR], fname[MAX_FNAME], ext[MAX_EXT];
		splitpath(book, drive, dir, fname, ext);
		//pXAo͕ɒǉB
		makepath(path, drive, dir, NULL, NULL);
		req_quote |= reftostr_subr1(s, path);	//pXɁACV{,'.'ȊO܂܂ĂAreq_quote=1ɂB
		//t@C̑OɁA'['ǉB
		g_string_append_c(s, '[');
		//t@CAo͕ɒǉB
		makepath(path, NULL, NULL, fname, ext);
		req_quote |= reftostr_subr1(s, path);	//t@CɁACV{,'.'ȊO܂܂ĂAreq_quote=1ɂB
		//t@ČɁA']'ǉB
		g_string_append_c(s, ']');
	}
	//V[gw肳Ăc
	if(sheet) {
		//t@CAo͕ɒǉB
		req_quote |= reftostr_subr1(s, sheet);	//V[gɁACV{,'.'ȊO܂܂ĂAreq_quote=1ɂB
	}
	//ubN,,V[gw肳Ăc
	if(s->len) {
		//ubN,,V[gɁACV{,'.'ȊO܂܂Ăc
		if(req_quote) {
			//ubNƃV[gAu'v`u'vň͂ށB
			g_string_insert_c(s, 0, '\'');
			g_string_append_c(s,    '\'');
		}
		//V[g̑OɁA'!'ǉB
		g_string_append_c(s, '!');
	}
	//A1`,,R1C1`ɂāc
	switch(flag & XlsRef_Style_Mask) {
	default:DIE();
	//A1`
	case XlsRef_Style_A1:
		//,,񑊑΂ɂāc
		switch(flag & XlsRef_ColType_Mask) {
		default:DIE();
		//
		case XlsRef_ColType_Abs:
			g_string_append_c(s, '$');
			/* FALLTHRU */
		//񑊑
		case XlsRef_ColType_Rel:
			if(col < 1) { DIE(); }		//A1`ł́A΂ł΂łA1͕sB
			reftostr_subr2(s, col);
			break;
		}
		//s,,s΂ɂāc
		switch(flag & XlsRef_RowType_Mask) {
		default:DIE();
		//s
		case XlsRef_RowType_Abs:
			g_string_append_c(s, '$');
			/* FALLTHRU */
		//s
		case XlsRef_RowType_Rel:
			if(row < 1) { DIE(); }		//A1`ł́A΂ł΂łA1͕sB
			g_string_append_printf(s, "%d", row);
			break;
		}
		break;
	//R1C1`
	case XlsRef_Style_R1C1:
		//s,,s΂ɂāc
		switch(flag & XlsRef_RowType_Mask) {
		default:DIE();
		//s
		case XlsRef_RowType_Abs:
			if(row < 1) { DIE(); }		//R1C1`ł́A΂̏ꍇ̂݁A1͕sB
			g_string_append_printf(s, "R%d", row);
			break;
		//s
		case XlsRef_RowType_Rel:
			if(row) {
				g_string_append_printf(s, "R[%d]", row);
			} else {
				g_string_append_printf(s, "R");
			}
			break;
		}
		//,,񑊑΂ɂāc
		switch(flag & XlsRef_ColType_Mask) {
		default:DIE();
		//
		case XlsRef_ColType_Abs:
			if(col < 1) { DIE(); }		//R1C1`ł́A΂̏ꍇ̂݁A1͕sB
			g_string_append_printf(s, "C%d", col);
			break;
		//񑊑
		case XlsRef_ColType_Rel:
			if(col) {
				g_string_append_printf(s, "C[%d]", col);
			} else {
				g_string_append_printf(s, "C");
			}
			break;
		}
		break;
	}
	//GByteArray̍\̂JAobt@͊Jɖ߂lƂB
	// - Ăяoɂfree()ŉĉB
	return g_string_free(s, 0/*free_segment*/);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int reftostr_subr1(GString* s, const char* ptr) {
	int c, req_quote = 0;	//͕ɁACV{,'.'ȊO܂܂ĂAreq_quote=1ɂB
	//͕́Aeɂāc
	while((c = mbsnextc(ptr))) {					//VtgJISΉ
		ptr = mbsinc(ptr);					//VtgJISΉ
		//o͕ɒǉB
		if(c > UCHAR_MAX) { g_string_append_c(s, c >> 8); }	//VtgJISΉ
		g_string_append_c(s, c);
		//u'v́u''vɃGXP[vB
		if(c == '\'') { g_string_append_c(s, c); }
		//͕ɁACV{,'.'ȊO܂܂ĂAreq_quote=1ɂB
		// - '.'܂܂ĂĂAubNƃV[gu'v`u'vň͂ޕKv͖ɒӂĉB
		//   '.'NH[gΏۂɂĂ܂ƁAubN͊gq'.'܂ނ̂ŁAɃNH[gKvɂȂĂ܂܂B
		//   {ExcelłAubNV[g(gqɌ炸)'.'܂܂ĂĂANH[gȂmF܂B(Excel 2013ɂĊmF)
		if(!(iscsym(c) || (c == '.'))) { req_quote = 1; }
	}
	return req_quote;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void reftostr_subr2(GString* s, int row) {
	//ʌ̒l(d.quot=0`)ƁǍ̒l(d.rem=1`)߂B
	div_t d = div(row, ('Z' - 'A' + 1));
	//ʌ̒lL΁Aʌ̕o͂B
	if(d.quot) { reftostr_subr2(s, d.quot); }
	//̌̕o͂B
	g_string_append_c(s, d.rem + 'A' - 1);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#if 0
//eXgvO
static struct {
	int		flag, row, col;
	const char	*book, *sheet;
} TBL_ref[]={														//
{	BIN8(101001),		1,		1,		NULL,				NULL		},	//A1
{	BIN8(101001),		1,		1,		NULL,				"Sheet1"	},	//Sheet1!A1
{	BIN8(101001),		1,		1,		NULL,				"Sheet 1"	},	//'Sheet 1'!A1
{	BIN8(101001),		1,		1,		"Book1.xlsx",			"Sheet1"	},	//[Book1.xlsx]Sheet1!A1
{	BIN8(101001),		1,		1,		"Book 1.xlsx",			"Sheet 1"	},	//'[Book 1.xlsx]Sheet 1'!A1
{	BIN8(101001),		1,		1,		"C:\\Home\\Book1.xlsx",		"Sheet1"	},	//'C:\Home\[Book1.xlsx]Sheet1'!A1
{	BIN8(101001),		1,		1,		"C:\\H'o'me\\Book1.xlsx",	"Sheet1"	},	//'C:\H''o''me\[Book1.xlsx]Sheet1'!A1
{	BIN8(101001),		123,		731,		NULL,				NULL		},	//ABC123
{	BIN8(011001),		123,		731,		NULL,				NULL		},	//$ABC123
{	BIN8(100101),		123,		731,		NULL,				NULL		},	//ABC$123
{	BIN8(010101),		123,		731,		NULL,				NULL		},	//$ABC$123
{	BIN8(101010),		0,		0,		NULL,				NULL		},	//RC
{	BIN8(100110),		123,		0,		NULL,				NULL		},	//R123C
{	BIN8(011010),		0,		123,		NULL,				NULL		},	//RC123
{	BIN8(010110),		123,		123,		NULL,				NULL		},	//R123C123
{	BIN8(101010),		-123,		0,		NULL,				NULL		},	//R[-123]C
{	BIN8(101010),		0,		-123,		NULL,				NULL		},	//RC[-123]
{	BIN8(101010),		-123,		-123,		NULL,				NULL		},	//R[-123]C[-123]
{	BIN8(101001),		1,		703,		NULL,				NULL		},	//AAA1
{	BIN8(101001),		1,		16169,		NULL,				NULL		},	//WWW1
};
int test() {
	int i;
	for(i = 0; i < ARRAY_SIZE(TBL_ref); i++) {
		char* s = reftostr(TBL_ref[i].book, TBL_ref[i].sheet, TBL_ref[i].row, TBL_ref[i].col, TBL_ref[i].flag);
		puts(s);
		free(s);
	}
	return EXIT_SUCCESS;
}
#endif
