/*	
 *	clipwkst.c
 *
 *	[NV[g(KwnbVe[u)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2016 Naoyuki Sawa
 *
 *	* Mon Jul 13 21:22:16 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Jul 15 01:12:55 JST 2015 Naoyuki Sawa
 *	- Worksheet_ref_l(),Worksheet_ref_a(),Worksheet_ref_v()ǉ܂B
 *	- Worksheet_sum_l(),Worksheet_sum_a(),Worksheet_sum_v()ǉ܂B
 *	* Thu Jul 16 22:21:18 JST 2015 Naoyuki Sawa
 *	- Worksheet_sort(),Worksheet_sort_l(),Worksheet_sort_a(),Worksheet_sort_v()ǉ܂B
 *	* Sun Jul 19 12:59:05 JST 2015 Naoyuki Sawa
 *	- RĝݒǋL:
 *	  W[̊֐́AL[lɎwł̂͐l݂̂ŁA͎wł܂B
 *	  L[lɕw肵ꍇ́A{clipstr.cW[ɒǉAquark_from_string(),quark_to_string()𕹗pĂB
 *	  <>
 *	  Worksheet_set_l(ws,quark_from_string("Value"),quark_from_string("Key"),-1);
 *	  iVal=Worksheet_get_l(ws,quark_from_string("Key"),-1);
 *	  if(iVal!=-1){puts(quark_to_string(iVal));}
 *	* Fri Dec 11 21:38:17 JST 2015 Naoyuki Sawa
 *	- Worksheet_incr_l()A܂ł͖߂lłA(1)̒lԂ悤ɂ܂B
 *	  JE^ƂėpꍇAZ̒l(1)āAɂ̒lQƂ鎖łB
 *	- ߂l𖳎Γ͕ςĂȂ̂ŁÃAvP[Vւ̉e͗L܂B
 *	* Sun Jul 17 21:03:07 JST 2016 Naoyuki Sawa
 *	- Worksheet_ref_l(),Worksheet_get_l(),Worksheet_sum_l(),Worksheet_set_l(),Worksheet_unset_l(),Worksheet_incr_l(),Worksheet_first_l(),Worksheet_sort_l(),
 *	  Worksheet_ref_a(),Worksheet_get_a(),Worksheet_sum_a(),Worksheet_set_a(),Worksheet_unset_a(),Worksheet_incr_a(),Worksheet_first_a(),Worksheet_sort_a()AZu܂B
 *	  ȖړÍAR[hTCY̒ጸłB
 *	  W[R[hTCYA1468oCg1016oCgɌ܂B
 *	* Sun Jul 17 22:34:56 JST 2016 Naoyuki Sawa
 *	- USE_WORKSHEET_GTREEV{`ƁAW[gtree.cW[gp悤ɂ܂B
 *	  USE_WORKSHEET_GTREEV{`Ȃ΁A܂ŒʂAght_hash_table.cW[gp܂B
 *	  ʂ́AUSE_WORKSHEET_GTREEV{`āAgtree.cW[gp悤ɂāA؂悤Ǝv܂B
 *	  A̖肪Aght_hash_table.cW[gp悤ɖ߂ĉB
 *	- gtree.cW[gp悤ɕύXŔA\[g֐(Worksheet_sort())svɂȂ邩łB
 *	  c[͏Ƀ\[gĂ̂ŁAAvP[VCe[V̑OɁAIɃ\[gKvȂ܂B
 *	  USE_WORKSHEET_GTREE`Ăꍇ̓\[g֐̓_~[ƂȂ܂B
 *	  USE_WORKSHEET_GTREE`Ăꍇ̓\[g֐𖳌ɂĂǂ̂łA\[g֐ĂяoẴAvP[V̂߂ɎcĂɂ܂B
 *	* Mon Jul 18 20:14:53 JST 2016 Naoyuki Sawa
 *	- [NV[g(KwnbVe[u)̑啝ȕύXs܂B
 *	  EύXO̓nbVe[u𗘗pƃc[𗘗pIo܂AύX̓c[𗘗p݂̂ƂĒP܂B
 *	  Ec[𗘗p݂̂ƂɔA\[g֐͖ӖɂȂ̂ŁA\[g֐Sɔp~܂B
 *	  EύXO͈x쐬ꂽm[hWorksheet_unset_*()Ă΂Ȃ葶܂AύX͒l0ŎqKwm[hIɍ폜Ďgpߖ񂷂悤ɂ܂B
 *	  EύXOST_Worksheet͎qKw̃c[(ł)ێĂ܂AύX͎qKw̃c[ȂΖ쐬̂܂܂ƂĎgpߖ񂷂悤ɂ܂B
 *	  EύXO͖I0ݒ肳ꂽm[hCe[gĂ܂AL̕ύXɔAύX͒l0,,qKw̃c[̃m[ĥ͎݂Ce[gȂȂ܂B
 *	  E[gKwɑ΂ĒځuWorksheet_unset_l(ws,-1)vĂяóAύXO̓G[łAύX͉\ƂȂ܂B[NV[gNA铮ƂȂ܂B
 *	  EO[oϐuWorksheet_countvǉ܂BAvP[VŜŁAmۂĂST_Worksheet̐ǐՂϐłB(fobOp)
 *	- q̒ʂA̕ύX͓̕ύX̂łB
 *	  ύXÕvO͈肵ēт̂ŁAύXÕ\[XR[hu/clip/keep/18_[NV[g(KwnbVe[u)ύXOۑ/vɕۑĂ܂B	2016/07/18ȑÕ\[XR[h͍L̃tH_QƂĉB
 *	* Wed Jul 20 21:23:00 JST 2016 Naoyuki Sawa
 *	- [J֐Worksheet_key_compare_func()AZu܂B
 *	  Ȋ֐łAc[̑ɂČĂяopx͍̂ŁǍ͍ʂLƎv܂B(v)
 *	- k|C^w肵Worksheet_free()ĂяoꍇɁAȂ̂Worksheet_count炵Ă܂ĂoOC܂B
 */
#include "clip.h"
/****************************************************************************
 *	O[oϐ
 ****************************************************************************/
#ifdef  _DEBUG
int Worksheet_count;		//mۂĂST_Worksheet̐ǐՂB	fobOp
#endif//_DEBUG
/****************************************************************************
 *	[J֐
 ****************************************************************************/
#ifndef PIECE
static int Worksheet_key_compare_func(const void* a, const void* b, void* user_data) {
	if((int)a < (int)b) { return -1; }
	if((int)a > (int)b) { return  1; }
	                    { return  0; }
}
#else //PIECE
/*static*/ int Worksheet_key_compare_func(const void* a, const void* b, void* user_data);
asm("
		.code
		.align		1
Worksheet_key_compare_func:
		cmp		%r12, %r13				;//%psr := a <=> b
		jrlt.d		Worksheet_key_compare_func_RET		;//if((int)a < (int)b) { return -1 }
		ld.w		%r10, -1				;//					*delay*
		jrgt.d		Worksheet_key_compare_func_RET		;//if((int)a > (int)b) { return  1 }
		ld.w		%r10, 1					;//					*delay*
		ld.w		%r10, 0					;//                    { return  0 }
Worksheet_key_compare_func_RET:						;//
		ret							;//
");
#endif//PIECE
/****************************************************************************
 *	쐬/J
 ****************************************************************************/
//Wv\̒PKw쐬B
// - ̊KwƌȂsƌȂ́AAvP[V̉ߎłB
ST_Worksheet* Worksheet_new() {
	//Wv\̒PKw̃mۂB
	ST_Worksheet* ws = calloc(1, sizeof(ST_Worksheet));
	if(!ws) { DIE(); }
#ifdef  _DEBUG
	Worksheet_count++;	//mۂĂST_Worksheet̐ǐՂB	fobOp
#endif//_DEBUG
	//Wv\̒PKwԂB
	return ws;
}
/*--------------------------------------------------------------------------*/
//Wv\̑SKwJB
void Worksheet_free(ST_Worksheet* ws/*NULL*/) {
	//k|C^ɑ΂Čďoꂽꍇ́AȂB	//̖IȔ͕K{łB̔sȂƁǍ̏ŉȂ̂ɁAWorksheet_count炵Ă܂oOB
	if(!ws) { return; }	//܂
	//qKw̃c[L΁c
	if(ws->tKey) {
#ifdef  _DEBUG
		if(!g_tree_nnodes(ws->tKey)) { DIE(); }	//̃c[Worksheet_unset_v()ō폜Ă͂BŃG[~瓖W[̃oOÁAAvP[Vr̊Kwɑ΂ăL[̕(0)Worksheet_unset_l()s\L܂B
#endif//_DEBUG
		//qKw̃c[JB
		g_tree_unref(ws->tKey);
	}
	//̊KwJB
	free(ws);
#ifdef  _DEBUG
	Worksheet_count--;	//mۂĂST_Worksheet̐ǐՂB	fobOp
	if(Worksheet_count < 0) { DIE(); }	//mۂĂST_Worksheet̐0ɂȂ鎖͋N蓾ȂBŒ~瓖W[̃oOłB
#endif//_DEBUG
}
/****************************************************************************
 *	Q
 ****************************************************************************/
//Wv\̃m[hQƂB
// - w肳ꂽm[h݂Ȃꍇ́Ak|C^Ԃ܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́AwsԂ܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
#ifndef PIECE
/*--------------------------------------------------------------------------*/
ST_Worksheet* Worksheet_ref_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/) {
	va_list ap;
	va_start(ap, ws);
	ws = Worksheet_ref_a(ws, ap);
	va_end(ap);
	return ws;
}
/*--------------------------------------------------------------------------*/
ST_Worksheet* Worksheet_ref_a(ST_Worksheet* ws/*NULL*/, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_ref_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
ST_Worksheet* Worksheet_ref_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/);
ST_Worksheet* Worksheet_ref_a(ST_Worksheet* ws/*NULL*/, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_ref_l
		.global		Worksheet_ref_a
Worksheet_ref_l:
		;//[%sp+0] := retp
		;//[%sp+4] := ws
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]		;//%r12 := ws
		xadd		%r13, %sp, 8		;//%r13 := ap = &...
Worksheet_ref_a:
		;//%r12    := ws
		;//%r13    := ap
		xjp		Worksheet_ref_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
ST_Worksheet* Worksheet_ref_v(ST_Worksheet* ws/*NULL*/, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey;
	//̃L[擾B
	iKey = *aKey++;
	//L[I[Ȃ΁Aws/*NULL*/̂܂ܕԂB
	if(iKey == -1) { return ws/*NULL*/; }	//܂
	//qKw̃c[΁Ak|C^ԂB
	if(!ws || !ws->tKey) { return NULL; }	//܂
	//L[ɑΉqKw(L)擾B
	ws = g_tree_lookup(ws->tKey, (void*)iKey);
	//L[ɑΉqKw(L)ɑ΂āAċAB
	return Worksheet_ref_v(ws/*NULL*/, aKey);
}
/****************************************************************************
 *	擾
 ****************************************************************************/
//Wv\̃Z̒l擾B
// - Wv\̃Z̒lݒ肾ꍇ́A(0)Ԃ܂B
//   ݒ(0)ƁAIɐݒ肳ꂽ(0)Aʂ@͗L܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒lԂ܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
#ifndef PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_get_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/) {
	int iVal;
	va_list ap;
	va_start(ap, ws);
	iVal = Worksheet_get_a(ws, ap);
	va_end(ap);
	return iVal;
}
/*--------------------------------------------------------------------------*/
int Worksheet_get_a(ST_Worksheet* ws/*NULL*/, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_get_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
int Worksheet_get_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/);
int Worksheet_get_a(ST_Worksheet* ws/*NULL*/, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_get_l
		.global		Worksheet_get_a
Worksheet_get_l:
		;//[%sp+0] := retp
		;//[%sp+4] := ws
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]		;//%r12 := ws
		xadd		%r13, %sp, 8		;//%r13 := ap = &...
Worksheet_get_a:
		;//%r12    := ws
		;//%r13    := ap
		xjp		Worksheet_get_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_get_v(ST_Worksheet* ws/*NULL*/, const int* aKey/*={key,key,...,key,-1}*/) {
	//w肳ꂽm[h(L)擾B
	ws = Worksheet_ref_v(ws/*NULL*/, aKey);
	//w肳ꂽm[h̒lԂB
	return ws ? ws->iVal : 0;
}
/****************************************************************************
 *	v
 ****************************************************************************/
//Wv\́Aw肳ꂽm[hȉ̃c[̒lvB
// - w肳ꂽm[h݂Ȃꍇ́A(0)Ԃ܂B
//   L(0)ƁAIɐݒ肳ꂽl̍v(0)łꍇƂAʂ@͗L܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́Ãm[hȉ̃c[̒lv܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
// - w肳ꂽm[hg̒lAvɊ܂݂܂B
//   m[hlƃL[𗼕Ăꍇ́AǂvɊ܂݂܂B
//@@@@@ P @@@@
//@@@@@^_@@@@Ⴆ́A}̃c[̍ŏʂ̃m[hw肵ꍇA
//@@@@Q@@@@@vl(1+2+3+4+5=15)ƂȂ܂B
//@@@^@_@@_@@
//@@R@@@S@@T@
#ifndef PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_sum_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/) {
	int iSum;
	va_list ap;
	va_start(ap, ws);
	iSum = Worksheet_sum_a(ws, ap);
	va_end(ap);
	return iSum;
}
/*--------------------------------------------------------------------------*/
int Worksheet_sum_a(ST_Worksheet* ws/*NULL*/, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_sum_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
int Worksheet_sum_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/);
int Worksheet_sum_a(ST_Worksheet* ws/*NULL*/, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_sum_l
		.global		Worksheet_sum_a
Worksheet_sum_l:
		;//[%sp+0] := retp
		;//[%sp+4] := ws
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]		;//%r12 := ws
		xadd		%r13, %sp, 8		;//%r13 := ap = &...
Worksheet_sum_a:
		;//%r12    := ws
		;//%r13    := ap
		xjp		Worksheet_sum_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_sum_v(ST_Worksheet* ws/*NULL*/, const int* aKey/*={key,key,...,key,-1}*/) {
	ST_Worksheet_Iterator it;
	int iKey, iSum;
	//w肳ꂽm[h(L)擾B
	ws = Worksheet_ref_v(ws/*NULL*/, aKey);
	//w肳ꂽm[h̒l擾B
	iSum = Worksheet_get_l(ws/*NULL*/, -1);
	//qKw̃L[ɑ΂čċAAlZB
	for(iKey = Worksheet_first_l(ws/*NULL*/, &it, -1);
	    iKey != -1;
	    iKey = Worksheet_next(&it)) { iSum += Worksheet_sum_l(ws, iKey, -1); }
	return iSum;
}
/****************************************************************************
 *	ݒ
 ****************************************************************************/
//Wv\̃Z̒lݒ肷B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒lݒ肵܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
// - lɂ́ACӂ̐wo܂B
#ifndef PIECE
/*--------------------------------------------------------------------------*/
void Worksheet_set_l(ST_Worksheet* ws, int iVal, ... /*,(-1)*/) {
	va_list ap;
	va_start(ap, iVal);
	Worksheet_set_a(ws, iVal, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
void Worksheet_set_a(ST_Worksheet* ws, int iVal, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	Worksheet_set_v(ws, iVal, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
void Worksheet_set_l(ST_Worksheet* ws, int iVal, ... /*,(-1)*/);
void Worksheet_set_a(ST_Worksheet* ws, int iVal, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_set_l
		.global		Worksheet_set_a
Worksheet_set_l:
		;//%r12    := ws
		;//[%sp+0] := retp
		;//[%sp+4] := iVal
		;//[%sp+8] := ...
		xld.w		%r13, [%sp+4]		;//%r13 := iVal
		xadd		%r14, %sp, 8		;//%r14 := ap = &...
Worksheet_set_a:
		;//%r12    := ws
		;//%r13    := iVal
		;//%r14    := ap
		xjp		Worksheet_set_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
void Worksheet_set_v(ST_Worksheet* ws, int iVal, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey;
	ST_Worksheet* pChild;
	//k|C^ɑ΂Čďoꂽꍇ́AG[~B
	if(!ws) { DIE(); }
	//̃L[擾B
	iKey = *aKey++;
	//L[I[Ȃ΁c
	if(iKey == -1) {
		//̊Kw̒lݒ肷B
		ws->iVal = iVal;
		return;	//܂
	}
	//L[ɑΉqKw(L)擾B
	pChild = Worksheet_ref_l(ws, iKey, -1);
	//L[ɑΉqKw΁c
	if(!pChild) {
		//qKw̃c[쐬Ȃ΁c
		if(!ws->tKey) {
			//qKw̃c[쐬B
			ws->tKey = g_tree_new_full(Worksheet_key_compare_func,		//key_compare_func
			                           NULL,				//key_compare_data
			                           NULL,				//key_destroy_func
			                           (void (*)(void*))Worksheet_free);	//value_destroy_func
		}
		//Wv\̒PKw쐬B
		pChild = Worksheet_new();
		//L[ɑΉqKwƂāAǉB
		g_tree_insert(ws->tKey, (void*)iKey, pChild);
	}
	//L[ɑΉqKwɑ΂āAċAB
	Worksheet_set_v(pChild, iVal, aKey);
	//L[ɑΉqKwAl0ŎqKwm[hƂȂc
	if(!pChild->iVal && !pChild->tKey) {
		//L[ɑΉqKw폜B
		Worksheet_unset_l(ws, iKey, -1);
	}
}
/****************************************************************************
 *	폜
 ****************************************************************************/
//Wv\̎w肳ꂽm[h,y,ȉ̊KwJB
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒lƎqKwNA܂B
//   L[̕т(0)ɂČĂяoốA[gKwɑ΂Ă݂̂ł鎖ɒӂĉB	dv
//   Ⴆ΁Ar̊KwWorksheet_ref_l()Ŏ擾āÅKwɑ΂ĒځuWorksheet_unset_l(ws,-1)vsƁAf[^\j󂳂܂B
//   Kw猩āAl0ŎqKwm[hAqKw̃c[̒ɑ݂Ă͂ȂłB
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
#ifndef PIECE
/*--------------------------------------------------------------------------*/
void Worksheet_unset_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/) {
	va_list ap;
	va_start(ap, ws);
	Worksheet_unset_a(ws, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
void Worksheet_unset_a(ST_Worksheet* ws/*NULL*/, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	Worksheet_unset_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
void Worksheet_unset_l(ST_Worksheet* ws/*NULL*/, ... /*,(-1)*/);
void Worksheet_unset_a(ST_Worksheet* ws/*NULL*/, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_unset_l
		.global		Worksheet_unset_a
Worksheet_unset_l:
		;//[%sp+0] := retp
		;//[%sp+4] := ws
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]		;//%r12 := ws
		xadd		%r13, %sp, 8		;//%r13 := ap = &...
Worksheet_unset_a:
		;//%r12    := ws
		;//%r13    := ap
		xjp		Worksheet_unset_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
void Worksheet_unset_v(ST_Worksheet* ws/*NULL*/, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey;
	ST_Worksheet* pChild;
	//k|C^ɑ΂Čďoꂽꍇ́AȂB
	if(!ws) { return; }	//܂
	//̃L[擾B
	iKey = *aKey++;
	//L[I[Ȃ΁c
	if(iKey == -1) {
		//̊Kw̒lNAB
		ws->iVal = 0;
		//qKw̃c[L΁c
		if(ws->tKey) {
			//qKw̃c[B
			g_tree_unref(ws->tKey);
			             ws->tKey = NULL;
		}
		return;	//܂
	}
	//L[ɑΉqKw(L)擾B
	pChild = Worksheet_ref_l(ws, iKey, -1);
	//L[ɑΉqKw΁AȂB
	if(!pChild) { return; }	//܂
	//L[ɑΉqKwɑ΂āAċAB
	Worksheet_unset_v(pChild, aKey);
	//L[ɑΉqKwAl0ŎqKwm[hƂȂc
	if(!pChild->iVal && !pChild->tKey) {
		//L[ɑΉqKwB
		g_tree_remove(ws->tKey, (void*)iKey);
		//qKw̃c[ɂȂc
		if(!g_tree_nnodes(ws->tKey)) {
			//qKw̃c[B
			g_tree_unref(ws->tKey);
			             ws->tKey = NULL;
		}
	}
}
/****************************************************************************
 *	v
 ****************************************************************************/
//Wv\̃Z̒l(1)A(1)̒lԂB
// - Wv\̃Z̒lݒ肾ꍇ́A(1)̒l(1)ɂȂ܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒l(1)܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
#ifndef PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_incr_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	int iVal;
	va_list ap;
	va_start(ap, ws);
	iVal = Worksheet_incr_a(ws, ap);
	va_end(ap);
	return iVal;
}
/*--------------------------------------------------------------------------*/
int Worksheet_incr_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_incr_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
int Worksheet_incr_l(ST_Worksheet* ws, ... /*,(-1)*/);
int Worksheet_incr_a(ST_Worksheet* ws, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_incr_l
		.global		Worksheet_incr_a
Worksheet_incr_l:
		;//[%sp+0] := retp
		;//[%sp+4] := ws
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]		;//%r12 := ws
		xadd		%r13, %sp, 8		;//%r13 := ap = &...
Worksheet_incr_a:
		;//%r12    := ws
		;//%r13    := ap
		xjp		Worksheet_incr_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_incr_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	//݂̒l擾(1)B
	int iVal = Worksheet_get_v(ws, aKey) + 1;
	//(1)̒lݒ肷B
	Worksheet_set_v(ws, iVal, aKey);
	//(1)̒lԂB
	return iVal;
}
/****************************************************************************
 *	Jn
 ****************************************************************************/
//Wv\̎qKw̍ŏ̃L[擾܂B
// - qKw΁A(-1)Ԃ܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̎qKw̍ŏ̃L[擾܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
// - ֐(-1)ԂꍇÃCe[^ɑ΂Worksheet_next()ĂяoĈSłB
#ifndef PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_first_l(ST_Worksheet* ws/*NULL*/, ST_Worksheet_Iterator* it, ... /*,(-1)*/) {
	int iKey;
	va_list ap;
	va_start(ap, it);
	iKey = Worksheet_first_a(ws, it, ap);
	va_end(ap);
	return iKey;
}
/*--------------------------------------------------------------------------*/
int Worksheet_first_a(ST_Worksheet* ws/*NULL*/, ST_Worksheet_Iterator* it, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_first_v(ws, it, aKey);
}
/*--------------------------------------------------------------------------*/
#else //PIECE
int Worksheet_first_l(ST_Worksheet* ws/*NULL*/, ST_Worksheet_Iterator* it, ... /*,(-1)*/);
int Worksheet_first_a(ST_Worksheet* ws/*NULL*/, ST_Worksheet_Iterator* it, va_list ap);
asm("
		.code
		.align		1
		.global		Worksheet_first_l
		.global		Worksheet_first_a
Worksheet_first_l:
		;//%r12    := ws
		;//[%sp+0] := retp
		;//[%sp+4] := it
		;//[%sp+8] := ...
		xld.w		%r13, [%sp+4]		;//%r13 := it
		xadd		%r14, %sp, 8		;//%r14 := ap = &...
Worksheet_first_a:
		;//%r12    := ws
		;//%r13    := it
		;//%r14    := ap
		xjp		Worksheet_first_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
int Worksheet_first_v(ST_Worksheet* ws/*NULL*/, ST_Worksheet_Iterator* it, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey;
	//w肳ꂽm[h(L)擾B
	ws = Worksheet_ref_v(ws/*NULL*/, aKey);
	//w肳ꂽm[h̎qKw(L)擾B
	it->tree = ws/*NULL*/ ? ws->tKey/*NULL*/ : NULL;
	//w肳ꂽm[h̎qKwL΁Aŏ̃Ce[VsB
	//w肳ꂽm[h̎qKw΁A(-1)ԂB
	return (it->tree && g_tree_first_np(it->tree, &it->it, (void**)&iKey, NULL)) ? iKey : -1;
}
/****************************************************************************
 *	p
 ****************************************************************************/
//Wv\̎qKw̎̃L[擾܂B
// - ̃L[΁A(-1)Ԃ܂B
// - ֐(-1)ԂꍇÃCe[^ɑ΂čēxWorksheet_next()ĂяoĈSłB
int Worksheet_next(ST_Worksheet_Iterator* it) {
	int iKey;
	//w肳ꂽm[h̎qKwL΁ÃCe[VsB
	//w肳ꂽm[h̎qKw΁A(-1)ԂB
	return (it->tree && g_tree_next_np(it->tree, &it->it, (void**)&iKey, NULL)) ? iKey : -1;
}
/****************************************************************************
 *	_v
 ****************************************************************************/
static void Worksheet_dump_indent(int indent) {
	while(indent--) { putchar('\t'); }
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void Worksheet_dump_iter(ST_Worksheet* ws/*NULL*/, int indent) {
	ST_Worksheet_Iterator it;
	int iKey;
	//qKw𑖍B
	for(iKey = Worksheet_first_l(ws/*NULL*/, &it, -1);
	    iKey != -1;
	    iKey = Worksheet_next(&it)) {
		ST_Worksheet* pChild = Worksheet_ref_l(ws, iKey, -1);
		//qKw̒lݒ肳ĂAlo͂B
		if(pChild->iVal) {
			Worksheet_dump_indent(indent);
			printf("%d\t=\t%d\n", iKey, pChild->iVal);
		}
		//qKw̃c[L΁AL[o͂B
		if(pChild->tKey) {
#ifdef  _DEBUG
			if(!g_tree_nnodes(ws->tKey)) { DIE(); }	//̃c[Worksheet_unset_v()ō폜Ă͂BŃG[~瓖W[̃oOÁAAvP[Vr̊Kwɑ΂ăL[̕(0)Worksheet_unset_l()s\L܂B
#endif//_DEBUG
			Worksheet_dump_indent(indent);
			printf("%d\n", iKey);
			Worksheet_dump_iter(pChild, indent + 1);
			Worksheet_dump_indent(indent);
			printf("end\n");
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Wv\̑SKwAWXggNvg`Ń_v܂B
// - WXgXNvg͍̐l܂B
//   ̓Iɂ́AWXgXNvg̃L[ƒl͈̔͂(0)`(65535)ł̂ɑ΂A
//   W[̃L[͈̔͂(-1)Cӂ̐,l͈̔͂(-1)܂ޔCӂ̐łB
//   WXgXNvg̐O邱̒lÂ܂܏o͂܂B
//   ̏ꍇAWXgXNvgRpC_ŃG[ƂȂ܂B
// - [gKwɒڐݒ肵l͏o͂܂B
//   WXgXNvg̍\A'[gKw̒l'͕\oȂłB
void Worksheet_dump(ST_Worksheet* ws/*NULL*/) {
	Worksheet_dump_iter(ws, 0);
}
/****************************************************************************
 *	gp
 ****************************************************************************/
#if 0
void test() {
	ST_Worksheet* ws = Worksheet_new();
	int i, s = 0;
	for(i = 0; i < 1000; i++) {
		int a[8], j, n, v;
		//---
		v = RND16_RANGE(s, 0, 3);
		n = RND16_RANGE(s, 0, 7);
		for(j = 0; j <= n; j++) { a[j] = RND16_RANGE(s, 0, 3); }
		switch(n) {
		default:DIE();
		case 0: Worksheet_set_l(ws, v, a[0], -1); break;
		case 1: Worksheet_set_l(ws, v, a[0], a[1], -1); break;
		case 2: Worksheet_set_l(ws, v, a[0], a[1], a[2], -1); break;
		case 3: Worksheet_set_l(ws, v, a[0], a[1], a[2], a[3], -1); break;
		case 4: Worksheet_set_l(ws, v, a[0], a[1], a[2], a[3], a[4], -1); break;
		case 5: Worksheet_set_l(ws, v, a[0], a[1], a[2], a[3], a[4], a[5], -1); break;
		case 6: Worksheet_set_l(ws, v, a[0], a[1], a[2], a[3], a[4], a[5], a[6], -1); break;
		}
		//---
		n = RND16_RANGE(s, 0, 7);
		for(j = 0; j <= n; j++) { a[j] = RND16_RANGE(s, 0, 3); }
		switch(n) {
		default:DIE();
		case 0: Worksheet_incr_l(ws, a[0], -1); break;
		case 1: Worksheet_incr_l(ws, a[0], a[1], -1); break;
		case 2: Worksheet_incr_l(ws, a[0], a[1], a[2], -1); break;
		case 3: Worksheet_incr_l(ws, a[0], a[1], a[2], a[3], -1); break;
		case 4: Worksheet_incr_l(ws, a[0], a[1], a[2], a[3], a[4], -1); break;
		case 5: Worksheet_incr_l(ws, a[0], a[1], a[2], a[3], a[4], a[5], -1); break;
		case 6: Worksheet_incr_l(ws, a[0], a[1], a[2], a[3], a[4], a[5], a[6], -1); break;
		}
		//---
		n = RND16_RANGE(s, 0, 7);
		for(j = 0; j <= n; j++) { a[j] = RND16_RANGE(s, 0, 3); }
		switch(n) {
		default:DIE();
		case 0: Worksheet_unset_l(ws, a[0], -1); break;
		case 1: Worksheet_unset_l(ws, a[0], a[1], -1); break;
		case 2: Worksheet_unset_l(ws, a[0], a[1], a[2], -1); break;
		case 3: Worksheet_unset_l(ws, a[0], a[1], a[2], a[3], -1); break;
		case 4: Worksheet_unset_l(ws, a[0], a[1], a[2], a[3], a[4], -1); break;
		case 5: Worksheet_unset_l(ws, a[0], a[1], a[2], a[3], a[4], a[5], -1); break;
		case 6: Worksheet_unset_l(ws, a[0], a[1], a[2], a[3], a[4], a[5], a[6], -1); break;
		}
	}
	Worksheet_dump(ws);
	Worksheet_free(ws);
}
#endif
