/*
 *	clipstl.c
 *
 *	STLQlɂč쐬֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sat Mar 05 21:53:08 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- lower_bound()֐,upper_bound()֐쐬܂B
 *	- XbhZ[tłlower_bound_r()֐,upper_bound_r()ǉ܂B
 *	* Tue Jun 07 22:13:11 JST 2016 Naoyuki Sawa
 *	- std_rotate()֐ǉ܂B
 *	  ړÍA[e[g̍̂߂łB
 *	  ڍׂ́Aȉ̒ʂłB
 *	- Aclipstr.cW[memrotate()֐ǉ̂łAfȃASYł͂̂łA܂ᑬłB
 *	  memrotate()ĂяoĂmemmove()铙čHv̂łA܂ʂ͗L܂łB(memmove()o͂P̂łӋ`͗L̂łc)
 *	  @TāAWebŃ[e[g̃ASYɂČČAɁAWC++CuɁAstd::rotate()Ƃ֐L鎖܂B
 *	  ucppreference.com - std::rotatev(http://en.cppreference.com/w/cpp/algorithm/rotate)ɁA̎@ĂAƂĂ̗ǂASŶ悤łB
 *	  ŁÃASYACłƂĎ鎖ɂ܂B
 *	  ځAclipstr.cW[memrotate()ύXĂǂ̂łAĕʊ֐std_rotate()ƂĎAmemrotate()std_rotate()Ăяo悤ɕύX鎖ɂ܂B
 *	  ŔASTLWC++Cuɂč쐬R[h́AW[(clipstl.c)ɏW߂jłB
 *	- gp
 *	  void test() {
 *	      int a[] = { 0,1,2,3,4,5,6,7,8,9 }, i;
 *	      std_rotate(a, &a[3], &a[10]);
 *	      for(i = 0; i < 10; i++) { printf("%d ", a[i]); }
 *	      //:     3 4 5 6 7 8 9 0 1 2
 *	  }
 *	- W[ɒǉ֐'std_'̃vtBNXtjł͂Ȃ̂łA'rotate'ł͂܂ɒP߂ĖȌՓ˂SzȂ̂ŁAʂ'std_'̃vtBNXt鎖ɂ܂B
 *	  ȑOɒǉlower_bound()֐ɂ'std_'̃vtBNX͕tĂȂ̂œꂪĂ܂񂪁Ap͖薳Ǝv܂B
 *	  W[ɒǉ֐̊֐ɂẮA܂茵ɍlȂɂ܂B
 *	  AP[XoCP[XŁA'std_'̃vtBNXt邩ǂfĉB
 *	* Wed Jun 08 21:50:02 JST 2016 Naoyuki Sawa
 *	- std::rotate()̃ASYôŁARgǋL܂B
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
// * Sat Mar 05 21:53:08 JST 2016 Naoyuki Sawa
// - lower_bound()֐,upper_bound()֐ǉ܂B
//   ړÍA'l͈͕̔tbsearch()'sLłB
// - lower_bound,upper_bound̊֐́ASTLstd::lower_bound(),std::upper_bound()܂B
//   ǉlower_bound()֐,upper_bound()֐́Absearch()̈dl/߂ldlŁASTLstd::lower_bound(),std::upper_bound()ƓŝłB
// - Ql
//   uPrograming Placev(http://ppp-lab.sakura.ne.jp/)́wC++(WCu) 20 \[gς݂͈̔͂ASYx(http://ppp-lab.sakura.ne.jp/cpp/library/020.html)̋L
//   uStack Overflowv́wFind the first element in an array that is greater than the targetx(http://stackoverflow.com/questions/6553970/find-the-first-element-in-an-array-that-is-greater-than-the-target)̋L
// - XbhZ[tłlower_bound_r()֐,upper_bound_r()ǉ܂B
//   qsort()ɑ΂Aqsort_r()ɑ܂B
//   Ȃ݂ɁAbsearch()ɑ΂bsearch_r()݂͑܂B
//   bsearch_r,lfind_r,lsearch_r,݂Ȃ̂́ACWCudlĂ̂悤łB
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//(keyval)ƂȂAŏvalւ̃|C^ԂB
//SĂval(keyval)Ȃ΁AŌval̎ւ̃|C^ԂB	std::lower_bound()̎dlłBNULLԂ̂ł͂ȂɒӂĉB
//[in]
//		dĺAbsearch()ƓłB
//		Ɏw肷compar֐́Absearch()Ɠ̂po܂B
//[out]
//		߂l̎dĺAstd::lower_bound()ƓłB
//		֐ANULLԂ͗L܂B
//[note]
//		- 𖞂ʒuꍇAbsearch()NULLԂ܂A֐͍Ōval̎ւ̃|C^ԂɒӂĉB
//		  std::lower_bound()̎dlɕłB
//		- 𖞂ʒuꍇAbsearch()ƓlNULLԂdlɕύX悤Ƃv̂łA
//		  ۂɎgČƁAĂяo̊ϓ_łAŌval̎ւ̃|C^ԂꂽgՂP[X킩܂B
//		  ]āA𖞂ʒuꍇ́Astd::lower_bound()ƓlɁAŌval̎ւ̃|C^Ԃɂ܂B
void* lower_bound(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*)) {
	return lower_bound_r(key, _base, nmemb, size, (int (*)(const void*, const void*, void*))compar, NULL);	//lower_bound()lower_bound_r()́Acompar֐̌`قȂ܂A'cdeclďoK'Ȃ΁Alower_bound()`compar֐ɂāA]Ȉ̂Ŗ肠܂B
}
void* lower_bound_r(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*, void*), void* arg) {
	unsigned char* base = (unsigned char*)_base;
	unsigned lo = 0, hi = nmemb;
	while(lo != hi) {
		unsigned mid = (lo + hi) >> 1;
		if((*compar)(key, base + (size * mid), arg) >  0) {	//̈ʒu̒lL[Ȃ΁Äʒu͏𖞂ĂȂ̂Łc	lower_bound()upper_bound()̈Ⴂ͂̍słB
			lo = mid + 1;					//ʂ̈ʒúAȂƂÄʒu̎ȍ~ƂȂB
		} else {						//̈ʒu̒lL[ȏȂ΁Äʒu͏𖞂Ă̂Łc
			hi = mid;					//ʂ̈ʒúAȂƂÄʒuȑOƂȂB
		}
	}
	return base + (size * lo);	//𖞂ʒuLꍇ́A(lo==hinmemb)ƂȂĂB𖞂ʒuꍇ́A(lo==hi==nmemb)ƂȂĂB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//(keyval)ƂȂAŏvalւ̃|C^ԂB
//SĂval(keyval)Ȃ΁AŌval̎ւ̃|C^ԂB	std::upper_bound()̎dlłBNULLԂ̂ł͂ȂɒӂĉB
//[note]
//	- lower_bound()̐QƂĉB
void* upper_bound(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*)) {
	return upper_bound_r(key, _base, nmemb, size, (int (*)(const void*, const void*, void*))compar, NULL);	//upper_bound()upper_bound_r()́Acompar֐̌`قȂ܂A'cdeclďoK'Ȃ΁Aupper_bound()`compar֐ɂāA]Ȉ̂Ŗ肠܂B
}
void* upper_bound_r(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*, void*), void* arg) {
	unsigned char* base = (unsigned char*)_base;
	unsigned lo = 0, hi = nmemb;
	while(lo != hi) {
		unsigned mid = (lo + hi) >> 1;
		if((*compar)(key, base + (size * mid), arg) >= 0) {	//̈ʒu̒lL[ȉȂ΁Äʒu͏𖞂ĂȂ̂Łc	lower_bound()upper_bound()̈Ⴂ͂̍słB
			lo = mid + 1;					//ʂ̈ʒúAȂƂÄʒu̎ȍ~ƂȂB
		} else {						//̈ʒu̒lL[߂Ȃ΁Äʒu͏𖞂Ă̂Łc
			hi = mid;					//ʂ̈ʒúAȂƂÄʒuȑOƂȂB
		}
	}
	return base + (size * lo);	//𖞂ʒuLꍇ́A(lo==hinmemb)ƂȂĂB𖞂ʒuꍇ́A(lo==hi==nmemb)ƂȂĂB
}
/****************************************************************************
 *	
 ****************************************************************************/
// * Tue Jun 07 22:13:11 JST 2016 Naoyuki Sawa
// - std_rotate()֐ǉ܂B
//   ړÍA[e[g̍̂߂łB
//   ڍׂ́Aȉ̒ʂłB
// - Aclipstr.cW[memrotate()֐ǉ̂łAfȃASYł͂̂łA܂ᑬłB
//   memrotate()ĂяoĂmemmove()铙čHv̂łA܂ʂ͗L܂łB(memmove()o͂P̂łӋ`͗L̂łc)
//   @TāAWebŃ[e[g̃ASYɂČČAɁAWC++CuɁAstd::rotate()Ƃ֐L鎖܂B
//   ucppreference.com - std::rotatev(http://en.cppreference.com/w/cpp/algorithm/rotate)ɁA̎@ĂAƂĂ̗ǂASŶ悤łB
//   ŁÃASYACłƂĎ鎖ɂ܂B
//   ځAclipstr.cW[memrotate()ύXĂǂ̂łAĕʊ֐std_rotate()ƂĎAmemrotate()std_rotate()Ăяo悤ɕύX鎖ɂ܂B
//   ŔASTLWC++Cuɂč쐬R[h́AW[(clipstl.c)ɏW߂jłB
// - gp
//   void test() {
//       int a[] = { 0,1,2,3,4,5,6,7,8,9 }, i;
//       std_rotate(a, &a[3], &a[10]);
//       for(i = 0; i < 10; i++) { printf("%d ", a[i]); }
//       //:     3 4 5 6 7 8 9 0 1 2
//   }
// - W[ɒǉ֐'std_'̃vtBNXtjł͂Ȃ̂łA'rotate'ł͂܂ɒP߂ĖȌՓ˂SzȂ̂ŁAʂ'std_'̃vtBNXt鎖ɂ܂B
//   ȑOɒǉlower_bound()֐ɂ'std_'̃vtBNX͕tĂȂ̂œꂪĂ܂񂪁Ap͖薳Ǝv܂B
//   W[ɒǉ֐̊֐ɂẮA܂茵ɍlȂɂ܂B
//   AP[XoCP[XŁA'std_'̃vtBNXt邩ǂfĉB
//
//------------------------------------------------------------------------------------------------------------------------------
//
//	ucppreference.com - std::rotatev(http://en.cppreference.com/w/cpp/algorithm/rotate)p:
//	template<class ForwardIt> void rotate(ForwardIt first, ForwardIt n_first, ForwardIt last);
//	
//	Parameters
//		first		the beginning of the original range
//		n_first		the element that should appear at the beginning of the rotated range
//		last		the end of the original range
//	
//	Possible implementation
//	
//		Possible implementation
//		template<class ForwardIt> void rotate(ForwardIt first, ForwardIt n_first, ForwardIt last) {
//			ForwardIt next = n_first;
//			while(first != next) {
//				std::iter_swap(first++, next++);
//				if(next == last) {
//					next = n_first;
//				} else if(first == n_first) {
//					n_first = next;
//				}
//			}
//		}
//
//	ƂāA
//		std::vector<int> v = {1,2,3,4,5};	//C++11Ȃstd::vector<int> v{1,2,3,4,5};ƏĂǂB(Uniform Initialization)
//	ɑ΂āA
//		std::rotate(v.begin(), v.begin() + 2, v.end());
//	s̓}܂B
//
//		e: first
//		NF: n_first
//		k: last
//		m: next
//	
//		@
//	
//			@@@@@NF@@@@@k
//			@
//			PQRST@
//			@
//			@e@@@m@@@@@@
//	
//		Aëʒu̒lƁAm̈ʒu̒lAeƂmi߂B
//	
//			@@@@@NF@@@@@k
//			@
//			RQPST@
//			@
//			@@@e@@@m@@@@
//	
//		Bëʒu̒lƁAm̈ʒu̒lAeƂmi߂B
//	
//			@@@@@NF@@@@@k
//			@
//			RSPQT@
//			@
//			@@@@@e@@@m@@
//	
//		Ce==NFɂȂ̂ŁANFm̈ʒuֈړB
//	
//			@@@@@@@@@NF@k
//			@
//			RSPQT@
//			@
//			@@@@@e@@@m@@
//	
//		Dëʒu̒lƁAm̈ʒu̒lAeƂmi߂B
//	
//			@@@@@@@@@NF@k
//			@
//			RSTQP@
//			@
//			@@@@@@@e@@@m
//	
//		Em==kɂȂ̂ŁAmNF̈ʒuֈړB
//	
//			@@@@@@@@@NF@k
//			@
//			RSTQP@
//			@
//			@@@@@@@e@m@@
//	
//		Fëʒu̒lƁAm̈ʒu̒lAeƂmi߂B
//	
//			@@@@@@@@@NF@k
//			@
//			RSTPQ@
//			@
//			@@@@@@@@@e@m
//	
//		Gm==kɂȂ̂ŁAmNF̈ʒuֈړB
//	
//			@@@@@@@@@NF@k
//			@
//			RSTPQ@
//			@
//			@@@@@@@@@e@@
//			@@@@@@@@@m@@
//	
//		He==mɂȂ̂ŏIB
//
//	ŕ̕Al肵ӏ܂B
//	ŏ̗vfl肵čsAx肵vf͕񏑂鎖͖̂ŁAIłB
//	AF`G̕A܂ϓIɗoĂ܂B
//	̗vf́AꎞIɓւČ̕тƈĂ̂ɁAL̃ASYłȂтɖ߂̂ł傤c
//	Ƃ͌AWC++CułASY͊ԈႢȂ̂ŁÂ܂܎鎖ɂ܂B
//	ǁXA悤Ǝv܂B	{{2016/06/08ǋL:std::rotate()̃ASYôŁARgǋL܂B̂QƂĉB}}
//
// * Wed Jun 08 21:50:02 JST 2016 Naoyuki Sawa
// - std::rotate()̃ASYo܂B
//   yԂ`ałꍇzyԂ`ałꍇzyԂ`ałꍇzɕčlĈ菇sǍAc͈͂ɑ΂std::rotate()̏ċAsƍlΔՂłB
//   ڍׂ́Ả̐}QƂĉB
//
//		yԂ`ałꍇz
//	
//			uԁv
//	
//				@@@@NF@@@k
//				
//				PQRS
//				
//				e@@@m@@@@
//				`a
//	
//			uŏIԁv
//	
//				
//				RSPQ
//				
//				a`
//	
//				uԁv̂a擪ֈړA̕`ւ炷ƁAuŏIԁvɂȂ܂B
//	
//	
//			```菇```
//	
//				@@@@NF@@@k
//				
//				PQRS
//				
//				e@@@m@@@@
//				`a
//	
//				@@@@NF@@@k
//				
//				RQPS
//				
//				@@e@@@m@@
//	
//				@@@@NF@@@k
//				
//				RSPQ
//				
//				@@@@e@@@m
//	
//				@@@@NF@@@k
//				
//				RSPQ
//				
//				@@@@e@@@@
//				@@@@m@@@@
//				a`
//	
//				`âŁAłB
//	
//		yԂ`ałꍇz
//	
//			uԁv
//	
//				@@@@@@NF@@@k
//				
//				PQRST
//				
//				e@@@@@m@@@@
//				`a
//	
//			uŏIԁv
//	
//				
//				STPQR
//				
//				a`
//	
//				uԁv̂a擪ֈړA̕`ւ炷ƁAuŏIԁvɂȂ܂B
//	
//	
//			```菇```
//	
//				@@@@@@NF@@@k
//				
//				PQRST
//				
//				e@@@@@m@@@@
//				`a
//	
//				@@@@@@NF@@@k
//				
//				SQRPT
//				
//				@@e@@@@@m@@
//	
//				@@@@@@NF@@@k
//				
//				STRPQ
//				
//				@@@@e@@@@@m
//	
//				@@@@@@NF@@@k
//				
//				STRPQ
//				
//				@@@@e@m@@@@
//				aA'
//	
//				̎_ŁAa͊ĂBA'ɑ΂āAstd::rotate()̏ċAsΗǂB
//	
//		yԂ`ałꍇz
//	
//			uԁv
//	
//				@@@@NF@@@@@k
//				
//				PQRST
//				
//				e@@@m@@@@@@
//				`a
//	
//			uŏIԁv
//	
//				
//				RSTPQ
//				
//				a`
//	
//				uԁv̂a擪ֈړA̕`ւ炷ƁAuŏIԁvɂȂ܂B
//	
//	
//			```菇```
//	
//				@@@@NF@@@@@k
//				
//				PQRST
//				
//				e@@@m@@@@@@
//				`a
//	
//				@@@@NF@@@@@k
//				
//				RQPST
//				
//				@@e@@@m@@@@
//	
//				@@@@NF@@@@@k
//				
//				RSPQT
//				
//				@@@@e@@@m@@
//	
//				@@@@@@@@NF@k
//				
//				RSPQT
//				
//				@@@@e@@@m@@
//				B'A'
//	
//				̎_ŁAB'͊ĂBA'ɑ΂āAstd::rotate()̏ċAsΗǂB
//	
//------------------------------------------------------------------------------------------------------------------------------
#ifndef PIECE
static void std_rotate_word(int* first, int* n_first, int* last) {
	int* next = n_first;
    //{{͈̔͂C\[X́Astd_rotate_byte()/std_rotate_half()/std_rotate_word()ŋʂłB
	while(first != next) {
		int tmp = *first;
		          *first++ = *next;
		                     *next++ = tmp;
		if(next == last) {
			next = n_first;
		} else if(first == n_first) {
			n_first = next;
		}
	}
    //}}͈̔͂C\[X́Astd_rotate_byte()/std_rotate_half()/std_rotate_word()ŋʂłB
}
static void std_rotate_half(short* first, short* n_first, short* last) {
	short* next = n_first;
    //{{͈̔͂C\[X́Astd_rotate_byte()/std_rotate_half()/std_rotate_word()ŋʂłB
	while(first != next) {
		int tmp = *first;
		          *first++ = *next;
		                     *next++ = tmp;
		if(next == last) {
			next = n_first;
		} else if(first == n_first) {
			n_first = next;
		}
	}
    //}}͈̔͂C\[X́Astd_rotate_byte()/std_rotate_half()/std_rotate_word()ŋʂłB
}
static void std_rotate_byte(char* first, char* n_first, char* last) {
	char* next = n_first;
    //{{͈̔͂C\[X́Astd_rotate_byte()/std_rotate_half()/std_rotate_word()ŋʂłB
	while(first != next) {
		int tmp = *first;
		          *first++ = *next;
		                     *next++ = tmp;
		if(next == last) {
			next = n_first;
		} else if(first == n_first) {
			n_first = next;
		}
	}
    //}}͈̔͂C\[X́Astd_rotate_byte()/std_rotate_half()/std_rotate_word()ŋʂłB
}
void std_rotate(void* first, void* n_first, void* last) {
	int x = (int)first | (int)n_first | (int)last;
	if(!(x & 3)) {
		std_rotate_word(first, n_first, last);	//first,n_first,lastSă[h񂵂Ăꍇ
	} else if(!(x & 1)) {
		std_rotate_half(first, n_first, last);	//first,n_first,lastSăn[t[h񂵂Ăꍇ
	} else {
		std_rotate_byte(first, n_first, last);	//first,n_first,lastłAhX̏ꍇ
	}
}
#else //PIECE
void std_rotate(void* first, void* n_first, void* last);
//؃vOBeo[WɋLڂԂ́ÃvOŌvԂłB
//int test() {
//  static int buf[16384];
//  int i, t1, t2, t3;
//  t1 = pceTimerGetCount();
//  for(i = 0; i < 100; i++) { std_rotate(&buf[0], &buf[1], &buf[16384]); }		//ǂ̃o[WłxłB
//  t1 = pceTimerGetCount() - t1;
//  t2 = pceTimerGetCount();
//  for(i = 0; i < 100; i++) { std_rotate(&buf[0], &buf[16384/2], &buf[16384]); }	//'Õo[W'ᑬŁA'o[W1''o[W2'łB
//  t2 = pceTimerGetCount() - t2;
//  t3 = pceTimerGetCount();
//  for(i = 0; i < 100; i++) { std_rotate(&buf[0], &buf[16384-1], &buf[16384]); }	//'Õo[W''o[W1'ᑬŁA'o[W2'łB
//  t3 = pceTimerGetCount() - t3;
//  die("%d[ms]\n%d[ms]\n%d[ms]", t1, t2, t3);
//}
//ȏ̌،ʂA'o[W2'őł鎖A'o[W2'̗p鎖ɂ܂B
//AR[hTCÝA'Õo[W'3ߏȂA'o[W1''o[W2'͓R[hTCYłB
//3ߒx̑Ȃ΋e͈͂Ǝv̂ŁA'o[W2'̗p鎖ɖ͗L܂B
#if 0
//Õo[W	2830[ms] 1347[ms] 2554[ms]
asm("
		.code
		.align		1
		.global		std_rotate
std_rotate:
		;//%r12 := first
		;//%r13 := n_first
		;//%r14 := last
		ld.w		%r9, %r12			;//%r9  :=  first
		or		%r9, %r13			;//%r9  :=  first|n_first
		or		%r9, %r14			;//%r9  :=  first|n_first|last
		and		%r9, 3				;//%r9  := (first|n_first|last)&3
		jreq		std_rotate_word			;//if(    !(first|n_first|last)&3) { goto std_rotate_word }
		and		%r9, 1				;//%r9  := (first|n_first|last)&1
		jreq		std_rotate_half			;//if(    !(first|n_first|last)&1) { goto std_rotate_half }
		;/* FALLTHRU */					;//                                { goto std_rotate_byte }
		;//---------------------------------------------;//
std_rotate_byte:
		ld.w		%r15, %r13			;//%r15 := next = n_first
std_rotate_byte_LOOP:						;//for(;;) {
		cmp		%r12, %r15			;//  if(first == next) { return }
		jreq		std_rotate_RET			;//  
		ld.b		%r4, [%r12]			;//  %r4  := tmp1 = *first
		ld.b		%r5, [%r15]			;//  %r5  := tmp2 = *next
		ld.b		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.b		[%r12]+, %r5			;//  *first++ = tmp2
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }
		jreq		std_rotate_byte			;//  
		cmp		%r12, %r13			;//  if(first != n_first) { continue }
		jrne		std_rotate_byte_LOOP		;//  
		jp.d		std_rotate_byte_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_half:
		ld.w		%r15, %r13			;//%r15 := next = n_first
std_rotate_half_LOOP:						;//for(;;) {
		cmp		%r12, %r15			;//  if(first == next) { return }
		jreq		std_rotate_RET			;//  
		ld.h		%r4, [%r12]			;//  %r4  := tmp1 = *first
		ld.h		%r5, [%r15]			;//  %r5  := tmp2 = *next
		ld.h		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.h		[%r12]+, %r5			;//  *first++ = tmp2
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }
		jreq		std_rotate_half			;//  
		cmp		%r12, %r13			;//  if(first != n_first) { continue }
		jrne		std_rotate_half_LOOP		;//  
		jp.d		std_rotate_half_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_word:
		ld.w		%r15, %r13			;//%r15 := next = n_first
std_rotate_word_LOOP:						;//for(;;) {
		cmp		%r12, %r15			;//  if(first == next) { return }
		jreq		std_rotate_RET			;//  
		ld.w		%r4, [%r12]			;//  %r4  := tmp1 = *first
		ld.w		%r5, [%r15]			;//  %r5  := tmp2 = *next
		ld.w		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.w		[%r12]+, %r5			;//  *first++ = tmp2
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }
		jreq		std_rotate_word			;//  
		cmp		%r12, %r13			;//  if(first != n_first) { continue }
		jrne		std_rotate_word_LOOP		;//  
		jp.d		std_rotate_word_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_RET:
		ret
");
#elif 0
//o[W1		2830[ms] 1278[ms] 2554[ms]
asm("
		.code
		.align		1
		.global		std_rotate
std_rotate:
		;//%r12 := first
		;//%r13 := n_first
		;//%r14 := last
		ld.w		%r9, %r12			;//%r9  :=  first
		or		%r9, %r13			;//%r9  :=  first|n_first
		or		%r9, %r14			;//%r9  :=  first|n_first|last
		and		%r9, 3				;//%r9  := (first|n_first|last)&3
		jreq		std_rotate_word			;//if(    !(first|n_first|last)&3) { goto std_rotate_word }
		and		%r9, 1				;//%r9  := (first|n_first|last)&1
		jreq		std_rotate_half			;//if(    !(first|n_first|last)&1) { goto std_rotate_half }
		;/* FALLTHRU */					;//                                { goto std_rotate_byte }
		;//---------------------------------------------;//
std_rotate_byte:
		ld.w		%r15, %r13			;//%r15 := next = n_first
		cmp		%r12, %r15			;//  	
std_rotate_byte_LOOP:						;//for(;;) {					
	;//	cmp		%r12, %r15			;//  if(first == next) { return }		[v̒xXbgp邽߂ɂ̍s̖߂񂩏ɕBR[hTCY邪xD悷鎖ɂB
		jreq		std_rotate_RET			;//  						
		ld.b		%r4, [%r12]			;//  %r4  := tmp1 = *first			
		ld.b		%r5, [%r15]			;//  %r5  := tmp2 = *next			
		ld.b		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.b		[%r12]+, %r5			;//  *first++ = tmp2				
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }	
		jreq		std_rotate_byte			;//  						
		cmp		%r12, %r13			;//  if(first != n_first) { continue }		
		jrne.d		std_rotate_byte_LOOP		;//  						
		cmp		%r12, %r15			;//  			*delay*
		jp.d		std_rotate_byte_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_half:
		ld.w		%r15, %r13			;//%r15 := next = n_first
		cmp		%r12, %r15			;//  	
std_rotate_half_LOOP:						;//for(;;) {					
	;//	cmp		%r12, %r15			;//  if(first == next) { return }		[v̒xXbgp邽߂ɂ̍s̖߂񂩏ɕBR[hTCY邪xD悷鎖ɂB
		jreq		std_rotate_RET			;//  						
		ld.h		%r4, [%r12]			;//  %r4  := tmp1 = *first			
		ld.h		%r5, [%r15]			;//  %r5  := tmp2 = *next			
		ld.h		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.h		[%r12]+, %r5			;//  *first++ = tmp2				
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }	
		jreq		std_rotate_half			;//  						
		cmp		%r12, %r13			;//  if(first != n_first) { continue }		
		jrne.d		std_rotate_half_LOOP		;//  						
		cmp		%r12, %r15			;//  			*delay*
		jp.d		std_rotate_half_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_word:
		ld.w		%r15, %r13			;//%r15 := next = n_first
		cmp		%r12, %r15			;//  	
std_rotate_word_LOOP:						;//for(;;) {					
	;//	cmp		%r12, %r15			;//  if(first == next) { return }		[v̒xXbgp邽߂ɂ̍s̖߂񂩏ɕBR[hTCY邪xD悷鎖ɂB
		jreq		std_rotate_RET			;//  						
		ld.w		%r4, [%r12]			;//  %r4  := tmp1 = *first			
		ld.w		%r5, [%r15]			;//  %r5  := tmp2 = *next			
		ld.w		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.w		[%r12]+, %r5			;//  *first++ = tmp2				
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }	
		jreq		std_rotate_word			;//  						
		cmp		%r12, %r13			;//  if(first != n_first) { continue }		
		jrne.d		std_rotate_word_LOOP		;//  						
		cmp		%r12, %r15			;//  			*delay*
		jp.d		std_rotate_word_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_RET:
		ret
");
#elif 1
//o[W2		2830[ms] 1278[ms] 2416[ms]	̗p鎖Ɍ肵܂B'o[W2''o[W1'ɂɒxXbgp̂łA'o[W2'̃R[hǂނƗhƎv܂B'o[W1''o[W2'rČ΁A'o[W2'̃R[hoƎv܂B
asm("
		.code
		.align		1
		.global		std_rotate
std_rotate:
		;//%r12 := first
		;//%r13 := n_first
		;//%r14 := last
		ld.w		%r9, %r12			;//%r9  :=  first
		or		%r9, %r13			;//%r9  :=  first|n_first
		or		%r9, %r14			;//%r9  :=  first|n_first|last
		and		%r9, 3				;//%r9  := (first|n_first|last)&3
		jreq		std_rotate_word			;//if(    !(first|n_first|last)&3) { goto std_rotate_word }
		and		%r9, 1				;//%r9  := (first|n_first|last)&1
		jreq		std_rotate_half			;//if(    !(first|n_first|last)&1) { goto std_rotate_half }
		;/* FALLTHRU */					;//                                { goto std_rotate_byte }
		;//---------------------------------------------;//
std_rotate_byte:
		cmp		%r12, %r13			;//%psr := first <=> n_first	
std_rotate_byte_NEXT:						;//						
		ld.w		%r15, %r13			;//%r15 := next = n_first			
std_rotate_byte_LOOP:						;//for(;;) {					
	;//	cmp		%r12, %r15			;//  if(first == next) { return }		[v̒xXbgp邽߂ɂ̍s̖߂񂩏ɕBR[hTCY邪xD悷鎖ɂB
		jreq		std_rotate_RET			;//  						
		ld.b		%r4, [%r12]			;//  %r4  := tmp1 = *first			
		ld.b		%r5, [%r15]			;//  %r5  := tmp2 = *next			
		ld.b		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.b		[%r12]+, %r5			;//  *first++ = tmp2				
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }	
		jreq.d		std_rotate_byte_NEXT		;//  						
		cmp		%r12, %r13			;//  if(first != n_first) { continue }				*delay*		'cmp %r12,%r13'AWvōsׂ'ld.w %r15,%r13; cmp %r12,%r15'̓́A'cmp %r12,%r15'̑pƂȂ܂B
		jrne.d		std_rotate_byte_LOOP		;//  						
		cmp		%r12, %r15			;//  			*delay*
		jp.d		std_rotate_byte_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_half:
		cmp		%r12, %r13			;//%psr := first <=> n_first	
std_rotate_half_NEXT:						;//						
		ld.w		%r15, %r13			;//%r15 := next = n_first			
std_rotate_half_LOOP:						;//for(;;) {					
	;//	cmp		%r12, %r15			;//  if(first == next) { return }		[v̒xXbgp邽߂ɂ̍s̖߂񂩏ɕBR[hTCY邪xD悷鎖ɂB
		jreq		std_rotate_RET			;//  						
		ld.h		%r4, [%r12]			;//  %r4  := tmp1 = *first			
		ld.h		%r5, [%r15]			;//  %r5  := tmp2 = *next			
		ld.h		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.h		[%r12]+, %r5			;//  *first++ = tmp2				
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }	
		jreq.d		std_rotate_half_NEXT		;//  						
		cmp		%r12, %r13			;//  if(first != n_first) { continue }				*delay*		'cmp %r12,%r13'AWvōsׂ'ld.w %r15,%r13; cmp %r12,%r15'̓́A'cmp %r12,%r15'̑pƂȂ܂B
		jrne.d		std_rotate_half_LOOP		;//  						
		cmp		%r12, %r15			;//  			*delay*
		jp.d		std_rotate_half_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_word:
		cmp		%r12, %r13			;//%psr := first <=> n_first	
std_rotate_word_NEXT:						;//						
		ld.w		%r15, %r13			;//%r15 := next = n_first			
std_rotate_word_LOOP:						;//for(;;) {					
	;//	cmp		%r12, %r15			;//  if(first == next) { return }		[v̒xXbgp邽߂ɂ̍s̖߂񂩏ɕBR[hTCY邪xD悷鎖ɂB
		jreq		std_rotate_RET			;//  						
		ld.w		%r4, [%r12]			;//  %r4  := tmp1 = *first			
		ld.w		%r5, [%r15]			;//  %r5  := tmp2 = *next			
		ld.w		[%r15]+, %r4			;//  *next++  = tmp1						*anti-interlock*
		ld.w		[%r12]+, %r5			;//  *first++ = tmp2				
		cmp		%r15, %r14			;//  if(next == last) { next = n_first }	
		jreq.d		std_rotate_word_NEXT		;//  						
		cmp		%r12, %r13			;//  if(first != n_first) { continue }				*delay*		'cmp %r12,%r13'AWvōsׂ'ld.w %r15,%r13; cmp %r12,%r15'̓́A'cmp %r12,%r15'̑pƂȂ܂B
		jrne.d		std_rotate_word_LOOP		;//  						
		cmp		%r12, %r15			;//  			*delay*
		jp.d		std_rotate_word_LOOP		;//}
		ld.w		%r13, %r15			;//  %r13 := n_first = next					*delay*
		;//---------------------------------------------;//
std_rotate_RET:
		ret
");
#endif
#endif//PIECE
